/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.math;

import cryptix.util.core.ArrayUtil;
import java.io.Serializable;
import java.security.SecureRandom;

public class BigRegister
implements Cloneable,
Serializable {
    public static final int MAXIMUM_SIZE = 4096;
    private static final byte[] log2x = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] high = new byte[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final byte[] low = new byte[]{0, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
    private static final String[] binaryDigits = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
    private static final String m_1 = "size < 2";
    private static final String m_2 = "size > MAXIMUM_SIZE";
    private static final SecureRandom prng = new SecureRandom();
    private byte[] bits;
    private int size;
    private static final long serialVersionUID = 2535877383275048954L;

    public BigRegister(int n) {
        if (n < 2) {
            throw new IllegalArgumentException(m_1);
        }
        if (n > 4096) {
            throw new IllegalArgumentException(m_2);
        }
        this.size = n;
        this.bits = new byte[(n + 7) / 8];
    }

    private BigRegister(BigRegister bigRegister) {
        this.size = bigRegister.size;
        this.bits = (byte[])bigRegister.bits.clone();
    }

    public Object clone() {
        return new BigRegister(this);
    }

    public void and(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.bits.length) {
            int n2 = n;
            this.bits[n2] = (byte)(this.bits[n2] & bigRegister.bits[n]);
            ++n;
        }
    }

    public void andNot(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.bits.length) {
            int n2 = n;
            this.bits[n2] = (byte)(this.bits[n2] & ~bigRegister.bits[n]);
            ++n;
        }
    }

    public void or(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.bits.length) {
            int n2 = n;
            this.bits[n2] = (byte)(this.bits[n2] | bigRegister.bits[n]);
            ++n;
        }
        this.pad();
    }

    public void not() {
        int n = 0;
        while (n < this.bits.length) {
            this.bits[n] = ~this.bits[n];
            ++n;
        }
        this.pad();
    }

    public void xor(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.bits.length) {
            int n2 = n;
            this.bits[n2] = (byte)(this.bits[n2] ^ bigRegister.bits[n]);
            ++n;
        }
        this.pad();
    }

    public void shiftLeft(int n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            this.shiftRight(-n);
            return;
        }
        if (n >= this.size) {
            this.reset();
            return;
        }
        int n2 = this.lowestSetBit();
        if (n2 == -1) {
            return;
        }
        if (n2 >= this.size - n) {
            this.reset();
            return;
        }
        n2 = n / 8;
        int n3 = n % 8;
        int n4 = this.bits.length;
        byte[] byArray = new byte[n4];
        if (n3 == 0) {
            System.arraycopy(this.bits, 0, byArray, n2, n4 - n2);
        } else {
            int n5 = 8 - n3;
            int n6 = n2;
            int n7 = 0;
            while (n6 < n4) {
                byArray[n6] = (byte)(this.bits[n7] << n3 | (n7 == 0 ? 0 : (this.bits[n7 - 1] & 0xFF) >>> n5));
                ++n6;
                ++n7;
            }
        }
        this.bits = byArray;
        this.pad();
    }

    public void shiftRight(int n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            this.shiftLeft(-n);
            return;
        }
        if (n >= this.size) {
            this.reset();
            return;
        }
        int n2 = this.highestSetBit();
        if (n2 < 0) {
            return;
        }
        if (n2 < n) {
            this.reset();
            return;
        }
        n2 = n / 8;
        int n3 = n % 8;
        int n4 = this.bits.length;
        byte[] byArray = new byte[n4];
        if (n3 == 0) {
            System.arraycopy(this.bits, n2, byArray, 0, n4 - n2);
        } else {
            int n5 = 0;
            int n6 = n2;
            while (n5 < n4 && n6 < n4) {
                byArray[n5] = (byte)(((n6 == n4 - 1 ? 0 : this.bits[n6 + 1] << 8) | this.bits[n6] & 0xFF) >>> n3);
                ++n5;
                ++n6;
            }
        }
        this.bits = byArray;
        this.pad();
    }

    public void rotateLeft(int n) {
        if ((n %= this.size) == 0) {
            return;
        }
        if (n < 0) {
            this.rotateRight(-n);
            return;
        }
        BigRegister bigRegister = (BigRegister)this.clone();
        bigRegister.shiftRight(this.size - n);
        this.shiftLeft(n);
        this.or(bigRegister);
    }

    public void rotateRight(int n) {
        if ((n %= this.size) == 0) {
            return;
        }
        if (n < 0) {
            this.rotateLeft(-n);
            return;
        }
        BigRegister bigRegister = (BigRegister)this.clone();
        bigRegister.shiftLeft(this.size - n);
        this.shiftRight(n);
        this.or(bigRegister);
    }

    public void invertOrder() {
        byte[] byArray = new byte[this.bits.length];
        int n = 0;
        int n2 = this.size - 1;
        while (n < this.size) {
            if (this.testBit(n)) {
                int n3 = n2 / 8;
                byArray[n3] = (byte)(byArray[n3] | 1 << n2 % 8);
            }
            ++n;
            --n2;
        }
        this.bits = byArray;
    }

    public boolean testBit(int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException();
        }
        return (this.bits[n / 8] & 1 << n % 8) != 0;
    }

    public boolean isSameValue(BigRegister bigRegister) {
        if (bigRegister.size != this.size) {
            return false;
        }
        return ArrayUtil.areEqual(this.bits, bigRegister.bits);
    }

    public int compareTo(BigRegister bigRegister) {
        if (this.size > bigRegister.size) {
            return 1;
        }
        if (this.size < bigRegister.size) {
            return -1;
        }
        return ArrayUtil.compared(this.bits, bigRegister.bits, true);
    }

    public void setBit(int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException();
        }
        int n2 = n / 8;
        this.bits[n2] = (byte)(this.bits[n2] | 1 << n % 8);
    }

    public void setBits(int n, int n2, long l) {
        if (n < 0 || n > this.size || n2 < 1 || n2 > 64 || n + n2 > this.size) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            if ((l & 1L) == 1L) {
                int n5 = n4 / 8;
                this.bits[n5] = (byte)(this.bits[n5] | 1 << n4 % 8);
            }
            l >>>= 1;
            ++n3;
            ++n4;
        }
    }

    public void clearBit(int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException();
        }
        int n2 = n / 8;
        this.bits[n2] = (byte)(this.bits[n2] & ~(1 << n % 8));
    }

    public void flipBit(int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException();
        }
        int n2 = n / 8;
        this.bits[n2] = (byte)(this.bits[n2] ^ 1 << n % 8);
    }

    public int getBit(int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException();
        }
        return (this.bits[n / 8] & 0xFF) >> n % 8 & 1;
    }

    public long getBits(int n, int n2) {
        if (n < 0 || n > this.size || n2 < 1 || n2 > 64 || n + n2 > this.size) {
            throw new IllegalArgumentException();
        }
        long l = 0L;
        int n3 = 0;
        int n4 = n + n2 - 1;
        while (n3 < n2) {
            l = l << 1 | (long)((this.bits[n4 / 8] & 0xFF) >> n4 % 8 & 1);
            ++n3;
            --n4;
        }
        return l;
    }

    public int byteValue() {
        return this.bits[0] & 0xFF;
    }

    public int intValue() {
        int n = 0;
        int n2 = this.bits[n++] & 0xFF;
        try {
            n2 |= (this.bits[n++] & 0xFF) << 8 | (this.bits[n++] & 0xFF) << 16 | (this.bits[n] & 0xFF) << 24;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return n2;
    }

    public long longValue() {
        int n = 0;
        long l = (long)this.bits[n++] & 0xFFL;
        try {
            l |= ((long)this.bits[n++] & 0xFFL) << 8 | ((long)this.bits[n++] & 0xFFL) << 16 | ((long)this.bits[n++] & 0xFFL) << 24 | ((long)this.bits[n++] & 0xFFL) << 32 | ((long)this.bits[n++] & 0xFFL) << 40 | ((long)this.bits[n++] & 0xFFL) << 48 | ((long)this.bits[n] & 0xFFL) << 56;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return l;
    }

    public BigRegister valueOf(long l) {
        BigRegister bigRegister = new BigRegister(this.size);
        int n = Math.min(8, this.bits.length);
        int n2 = 0;
        while (n2 < n) {
            bigRegister.bits[n2] = (byte)(l >>> 8 * n2);
            ++n2;
        }
        bigRegister.pad();
        return bigRegister;
    }

    public void reset() {
        ArrayUtil.clear(this.bits);
    }

    public void atRandom() {
        this.atRandom(prng);
    }

    public void atRandom(SecureRandom secureRandom) {
        secureRandom.nextBytes(this.bits);
        this.pad();
    }

    public void load(BigRegister bigRegister) {
        if (this.size != bigRegister.size) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(bigRegister.bits, 0, this.bits, 0, this.bits.length);
    }

    public void load(byte[] byArray) {
        int n = byArray.length;
        int n2 = this.bits.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(byArray, 0, this.bits, 0, n);
        if (n < n2) {
            ArrayUtil.clear(this.bits, n, n2 - n);
        }
        this.pad();
    }

    public byte[] toByteArray() {
        return (byte[])this.bits.clone();
    }

    public int getSize() {
        return this.size;
    }

    public int countSetBits() {
        int n = 0;
        int n2 = this.bits.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = this.bits[n3];
            n += by < 0 ? 8 : log2x[by & 0xFF];
            ++n3;
        }
        return n;
    }

    public int highestSetBit() {
        int n = this.bits.length - 1;
        while (n > 0 && this.bits[n] == 0) {
            --n;
        }
        if (this.bits[n] == 0) {
            return -1;
        }
        int n2 = this.bits[n] >>> 4 & 0xF;
        int n3 = 4;
        if (n2 == 0) {
            n2 = this.bits[n] & 0xF;
            n3 -= 4;
        }
        return n * 8 + (n3 += high[n2]);
    }

    public int lowestSetBit() {
        int n = 0;
        int n2 = this.bits.length;
        while (n < n2 && this.bits[n] == 0) {
            ++n;
        }
        if (n == n2) {
            return -1;
        }
        int n3 = this.bits[n] & 0xF;
        int n4 = 0;
        if (n3 == 0) {
            n3 = this.bits[n] >>> 4 & 0xF;
            n4 += 4;
        }
        return n * 8 + (n4 += low[n3]);
    }

    public String toString() {
        int n;
        int n2;
        String string;
        StringBuffer stringBuffer = new StringBuffer(8 * this.bits.length + 64);
        stringBuffer.append("Binary dump of a BigRegister [").append(this.size).append("-bit]...\n");
        stringBuffer.append("Byte #:|........|........|........|........|........|........|........|........|\n");
        int n3 = this.bits.length;
        int n4 = n3-- % 8;
        if (n4 != 0) {
            string = "      " + String.valueOf(this.bits.length);
            stringBuffer.append(string.substring(string.length() - 6)).append(':');
            n2 = 0;
            while (n2 < 8 - n4) {
                stringBuffer.append("         ");
                ++n2;
            }
            n2 = 0;
            while (n2 < n4) {
                n = this.bits[n3--] & 0xFF;
                stringBuffer.append(' ').append(binaryDigits[n >>> 4 & 0xF]).append(binaryDigits[n & 0xF]);
                ++n2;
            }
            stringBuffer.append('\n');
        }
        int n5 = (n3 + 1) / 8;
        n2 = 0;
        while (n2 < n5) {
            string = "      " + String.valueOf(8 * (n5 - n2));
            stringBuffer.append(string.substring(string.length() - 6)).append(':');
            int n6 = 0;
            while (n6 < 8) {
                n = this.bits[n3--] & 0xFF;
                stringBuffer.append(' ').append(binaryDigits[n >>> 4 & 0xF]).append(binaryDigits[n & 0xF]);
                ++n6;
            }
            stringBuffer.append('\n');
            ++n2;
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private void pad() {
        int n = 8 - this.size % 8;
        if (n != 8) {
            int n2 = this.bits.length - 1;
            this.bits[n2] = (byte)(this.bits[n2] & 255 >>> n);
        }
    }
}

