/*
 * Decompiled with CFR 0.152.
 */
package Serpent;

import Serpent.Serpent_Properties;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class Serpent_BitSlice {
    static final String NAME = "Serpent_BitSlice";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final int debuglevel = 0;
    static final PrintWriter err = null;
    static final boolean TRACE = Serpent_Properties.isTraceable("Serpent_Algorithm");
    static final int BLOCK_SIZE = 16;
    static final int ROUNDS = 32;
    static final int PHI = -1640531527;
    static final byte[][] Sbox;
    static final byte[][] SboxInverse;
    private static final char[] HEX_DIGITS;

    static void debug(String string) {
        ((PrintWriter)null).println(">>> Serpent_BitSlice: " + string);
    }

    static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> Serpent_BitSlice." + string);
        }
    }

    public static synchronized Object makeKey(byte[] byArray) throws InvalidKeyException {
        int n;
        int[] nArray = new int[132];
        int n2 = byArray.length / 4;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 24;
            ++n4;
        }
        if (n4 < 8) {
            nArray[n4++] = 1;
        }
        n4 = 8;
        int n5 = 0;
        while (n4 < 16) {
            n = nArray[n5] ^ nArray[n4 - 5] ^ nArray[n4 - 3] ^ nArray[n4 - 1] ^ 0x9E3779B9 ^ n5++;
            nArray[n4] = n << 11 | n >>> 21;
            ++n4;
        }
        n4 = 0;
        n5 = 8;
        while (n4 < 8) {
            nArray[n4++] = nArray[n5++];
        }
        n2 = 132;
        while (n4 < n2) {
            n = nArray[n4 - 8] ^ nArray[n4 - 5] ^ nArray[n4 - 3] ^ nArray[n4 - 1] ^ 0x9E3779B9 ^ n4;
            nArray[n4] = n << 11 | n >>> 21;
            ++n4;
        }
        n4 = 0;
        while (n4 < 33) {
            int n6 = nArray[n4];
            int n7 = nArray[n4 + 33];
            int n8 = nArray[n4 + 66];
            int n9 = nArray[n4 + 99];
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            byte[] byArray2 = Sbox[(35 - n4) % 32];
            n5 = 0;
            while (n5 < 32) {
                byte by = byArray2[n6 >>> n5 & 1 | (n7 >>> n5 & 1) << 1 | (n8 >>> n5 & 1) << 2 | (n9 >>> n5 & 1) << 3];
                n13 |= (by & 1) << n5;
                n12 |= (by >>> 1 & 1) << n5;
                n11 |= (by >>> 2 & 1) << n5;
                n10 |= (by >>> 3 & 1) << n5;
                ++n5;
            }
            nArray[n4] = n13;
            nArray[n4 + 33] = n12;
            nArray[n4 + 66] = n11;
            nArray[n4 + 99] = n10;
            ++n4;
        }
        return nArray;
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        byte by;
        int n2;
        byte[] byArray2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray = (int[])object;
        int n7 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n8 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n9 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n10 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n11 = 0;
        int n12 = 0;
        while (n12 < 31) {
            n7 ^= nArray[n11++];
            n8 ^= nArray[n11++];
            n9 ^= nArray[n11++];
            n10 ^= nArray[n11++];
            n6 = 0;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            byArray2 = Sbox[n12];
            n2 = 0;
            while (n2 < 32) {
                by = byArray2[n7 >>> n2 & 1 | (n8 >>> n2 & 1) << 1 | (n9 >>> n2 & 1) << 2 | (n10 >>> n2 & 1) << 3];
                n3 |= (by & 1) << n2;
                n4 |= (by >>> 1 & 1) << n2;
                n5 |= (by >>> 2 & 1) << n2;
                n6 |= (by >>> 3 & 1) << n2;
                ++n2;
            }
            n7 = n3 << 13 | n3 >>> 19;
            n9 = n5 << 3 | n5 >>> 29;
            n8 = n4 ^ n7 ^ n9;
            n10 = n6 ^ n9 ^ n7 << 3;
            n8 = n8 << 1 | n8 >>> 31;
            n10 = n10 << 7 | n10 >>> 25;
            n7 ^= n8 ^ n10;
            n9 ^= n10 ^ n8 << 7;
            n7 = n7 << 5 | n7 >>> 27;
            n9 = n9 << 22 | n9 >>> 10;
            ++n12;
        }
        n7 ^= nArray[n11++];
        n8 ^= nArray[n11++];
        n9 ^= nArray[n11++];
        n10 ^= nArray[n11++];
        n6 = 0;
        n5 = 0;
        n4 = 0;
        n3 = 0;
        byArray2 = Sbox[31];
        n2 = 0;
        while (n2 < 32) {
            by = byArray2[n7 >>> n2 & 1 | (n8 >>> n2 & 1) << 1 | (n9 >>> n2 & 1) << 2 | (n10 >>> n2 & 1) << 3];
            n3 |= (by & 1) << n2;
            n4 |= (by >>> 1 & 1) << n2;
            n5 |= (by >>> 2 & 1) << n2;
            n6 |= (by >>> 3 & 1) << n2;
            ++n2;
        }
        n7 = n3 ^ nArray[n11++];
        n8 = n4 ^ nArray[n11++];
        n9 = n5 ^ nArray[n11++];
        n10 = n6 ^ nArray[n11++];
        byte[] byArray3 = new byte[]{(byte)n7, (byte)(n7 >>> 8), (byte)(n7 >>> 16), (byte)(n7 >>> 24), (byte)n8, (byte)(n8 >>> 8), (byte)(n8 >>> 16), (byte)(n8 >>> 24), (byte)n9, (byte)(n9 >>> 8), (byte)(n9 >>> 16), (byte)(n9 >>> 24), (byte)n10, (byte)(n10 >>> 8), (byte)(n10 >>> 16), (byte)(n10 >>> 24)};
        return byArray3;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        byte by;
        int[] nArray = (int[])object;
        int n2 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n4 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n5 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n6 = 128;
        n2 ^= nArray[n6++];
        n3 ^= nArray[n6++];
        n4 ^= nArray[n6++];
        n5 ^= nArray[n6++];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        byte[] byArray2 = SboxInverse[31];
        int n11 = 0;
        while (n11 < 32) {
            by = byArray2[n2 >>> n11 & 1 | (n3 >>> n11 & 1) << 1 | (n4 >>> n11 & 1) << 2 | (n5 >>> n11 & 1) << 3];
            n10 |= (by & 1) << n11;
            n9 |= (by >>> 1 & 1) << n11;
            n8 |= (by >>> 2 & 1) << n11;
            n7 |= (by >>> 3 & 1) << n11;
            ++n11;
        }
        n6 = 124;
        n2 = n10 ^ nArray[n6++];
        n3 = n9 ^ nArray[n6++];
        n4 = n8 ^ nArray[n6++];
        n5 = n7 ^ nArray[n6++];
        int n12 = 30;
        while (n12 >= 0) {
            n4 = n4 << 10 | n4 >>> 22;
            n2 = n2 << 27 | n2 >>> 5;
            n4 ^= n5 ^ n3 << 7;
            n2 ^= n3 ^ n5;
            n5 = n5 << 25 | n5 >>> 7;
            n3 = n3 << 31 | n3 >>> 1;
            n5 ^= n4 ^ n2 << 3;
            n3 ^= n2 ^ n4;
            n4 = n4 << 29 | n4 >>> 3;
            n2 = n2 << 19 | n2 >>> 13;
            n7 = 0;
            n8 = 0;
            n9 = 0;
            n10 = 0;
            byArray2 = SboxInverse[n12];
            int n13 = 0;
            while (n13 < 32) {
                by = byArray2[n2 >>> n13 & 1 | (n3 >>> n13 & 1) << 1 | (n4 >>> n13 & 1) << 2 | (n5 >>> n13 & 1) << 3];
                n10 |= (by & 1) << n13;
                n9 |= (by >>> 1 & 1) << n13;
                n8 |= (by >>> 2 & 1) << n13;
                n7 |= (by >>> 3 & 1) << n13;
                ++n13;
            }
            n6 = n12 << 2;
            n2 = n10 ^ nArray[n6++];
            n3 = n9 ^ nArray[n6++];
            n4 = n8 ^ nArray[n6++];
            n5 = n7 ^ nArray[n6++];
            --n12;
        }
        byte[] byArray3 = new byte[]{(byte)n2, (byte)(n2 >>> 8), (byte)(n2 >>> 16), (byte)(n2 >>> 24), (byte)n3, (byte)(n3 >>> 8), (byte)(n3 >>> 16), (byte)(n3 >>> 24), (byte)n4, (byte)(n4 >>> 8), (byte)(n4 >>> 16), (byte)(n4 >>> 24), (byte)n5, (byte)(n5 >>> 8), (byte)(n5 >>> 16), (byte)(n5 >>> 24)};
        return byArray3;
    }

    private static final boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final String intToString(int n) {
        char[] cArray = new char[8];
        int n2 = 7;
        while (n2 >= 0) {
            cArray[n2] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
            --n2;
        }
        return new String(cArray);
    }

    private static final String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    private static final String toString(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n * 8];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = nArray[n2];
            cArray[n3++] = HEX_DIGITS[n4 >>> 28 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 24 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 20 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 16 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 12 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 8 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 & 0xF];
            ++n2;
        }
        return new String(cArray);
    }

    static {
        byte[][] byArrayArray = new byte[32][];
        byte[] byArray = new byte[16];
        byArray[0] = 14;
        byArray[1] = 4;
        byArray[2] = 13;
        byArray[3] = 1;
        byArray[4] = 2;
        byArray[5] = 15;
        byArray[6] = 11;
        byArray[7] = 8;
        byArray[8] = 3;
        byArray[9] = 10;
        byArray[10] = 6;
        byArray[11] = 12;
        byArray[12] = 5;
        byArray[13] = 9;
        byArray[15] = 7;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[1] = 15;
        byArray2[2] = 7;
        byArray2[3] = 4;
        byArray2[4] = 14;
        byArray2[5] = 2;
        byArray2[6] = 13;
        byArray2[7] = 1;
        byArray2[8] = 10;
        byArray2[9] = 6;
        byArray2[10] = 12;
        byArray2[11] = 11;
        byArray2[12] = 9;
        byArray2[13] = 5;
        byArray2[14] = 3;
        byArray2[15] = 8;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[0] = 4;
        byArray3[1] = 1;
        byArray3[2] = 14;
        byArray3[3] = 8;
        byArray3[4] = 13;
        byArray3[5] = 6;
        byArray3[6] = 2;
        byArray3[7] = 11;
        byArray3[8] = 15;
        byArray3[9] = 12;
        byArray3[10] = 9;
        byArray3[11] = 7;
        byArray3[12] = 3;
        byArray3[13] = 10;
        byArray3[14] = 5;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[16];
        byArray4[0] = 15;
        byArray4[1] = 12;
        byArray4[2] = 8;
        byArray4[3] = 2;
        byArray4[4] = 4;
        byArray4[5] = 9;
        byArray4[6] = 1;
        byArray4[7] = 7;
        byArray4[8] = 5;
        byArray4[9] = 11;
        byArray4[10] = 3;
        byArray4[11] = 14;
        byArray4[12] = 10;
        byArray4[14] = 6;
        byArray4[15] = 13;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[16];
        byArray5[0] = 15;
        byArray5[1] = 1;
        byArray5[2] = 8;
        byArray5[3] = 14;
        byArray5[4] = 6;
        byArray5[5] = 11;
        byArray5[6] = 3;
        byArray5[7] = 4;
        byArray5[8] = 9;
        byArray5[9] = 7;
        byArray5[10] = 2;
        byArray5[11] = 13;
        byArray5[12] = 12;
        byArray5[14] = 5;
        byArray5[15] = 10;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[16];
        byArray6[0] = 3;
        byArray6[1] = 13;
        byArray6[2] = 4;
        byArray6[3] = 7;
        byArray6[4] = 15;
        byArray6[5] = 2;
        byArray6[6] = 8;
        byArray6[7] = 14;
        byArray6[8] = 12;
        byArray6[10] = 1;
        byArray6[11] = 10;
        byArray6[12] = 6;
        byArray6[13] = 9;
        byArray6[14] = 11;
        byArray6[15] = 5;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[16];
        byArray7[1] = 14;
        byArray7[2] = 7;
        byArray7[3] = 11;
        byArray7[4] = 10;
        byArray7[5] = 4;
        byArray7[6] = 13;
        byArray7[7] = 1;
        byArray7[8] = 5;
        byArray7[9] = 8;
        byArray7[10] = 12;
        byArray7[11] = 6;
        byArray7[12] = 9;
        byArray7[13] = 3;
        byArray7[14] = 2;
        byArray7[15] = 15;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[16];
        byArray8[0] = 13;
        byArray8[1] = 8;
        byArray8[2] = 10;
        byArray8[3] = 1;
        byArray8[4] = 3;
        byArray8[5] = 15;
        byArray8[6] = 4;
        byArray8[7] = 2;
        byArray8[8] = 11;
        byArray8[9] = 6;
        byArray8[10] = 7;
        byArray8[11] = 12;
        byArray8[13] = 5;
        byArray8[14] = 14;
        byArray8[15] = 9;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[16];
        byArray9[0] = 10;
        byArray9[2] = 9;
        byArray9[3] = 14;
        byArray9[4] = 6;
        byArray9[5] = 3;
        byArray9[6] = 15;
        byArray9[7] = 5;
        byArray9[8] = 1;
        byArray9[9] = 13;
        byArray9[10] = 12;
        byArray9[11] = 7;
        byArray9[12] = 11;
        byArray9[13] = 4;
        byArray9[14] = 2;
        byArray9[15] = 8;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[16];
        byArray10[0] = 13;
        byArray10[1] = 7;
        byArray10[3] = 9;
        byArray10[4] = 3;
        byArray10[5] = 4;
        byArray10[6] = 6;
        byArray10[7] = 10;
        byArray10[8] = 2;
        byArray10[9] = 8;
        byArray10[10] = 5;
        byArray10[11] = 14;
        byArray10[12] = 12;
        byArray10[13] = 11;
        byArray10[14] = 15;
        byArray10[15] = 1;
        byArrayArray[9] = byArray10;
        byte[] byArray11 = new byte[16];
        byArray11[0] = 13;
        byArray11[1] = 6;
        byArray11[2] = 4;
        byArray11[3] = 9;
        byArray11[4] = 8;
        byArray11[5] = 15;
        byArray11[6] = 3;
        byArray11[8] = 11;
        byArray11[9] = 1;
        byArray11[10] = 2;
        byArray11[11] = 12;
        byArray11[12] = 5;
        byArray11[13] = 10;
        byArray11[14] = 14;
        byArray11[15] = 7;
        byArrayArray[10] = byArray11;
        byte[] byArray12 = new byte[16];
        byArray12[0] = 1;
        byArray12[1] = 10;
        byArray12[2] = 13;
        byArray12[4] = 6;
        byArray12[5] = 9;
        byArray12[6] = 8;
        byArray12[7] = 7;
        byArray12[8] = 4;
        byArray12[9] = 15;
        byArray12[10] = 14;
        byArray12[11] = 3;
        byArray12[12] = 11;
        byArray12[13] = 5;
        byArray12[14] = 2;
        byArray12[15] = 12;
        byArrayArray[11] = byArray12;
        byte[] byArray13 = new byte[16];
        byArray13[0] = 7;
        byArray13[1] = 13;
        byArray13[2] = 14;
        byArray13[3] = 3;
        byArray13[5] = 6;
        byArray13[6] = 9;
        byArray13[7] = 10;
        byArray13[8] = 1;
        byArray13[9] = 2;
        byArray13[10] = 8;
        byArray13[11] = 5;
        byArray13[12] = 11;
        byArray13[13] = 12;
        byArray13[14] = 4;
        byArray13[15] = 15;
        byArrayArray[12] = byArray13;
        byte[] byArray14 = new byte[16];
        byArray14[0] = 13;
        byArray14[1] = 8;
        byArray14[2] = 11;
        byArray14[3] = 5;
        byArray14[4] = 6;
        byArray14[5] = 15;
        byArray14[7] = 3;
        byArray14[8] = 4;
        byArray14[9] = 7;
        byArray14[10] = 2;
        byArray14[11] = 12;
        byArray14[12] = 1;
        byArray14[13] = 10;
        byArray14[14] = 14;
        byArray14[15] = 9;
        byArrayArray[13] = byArray14;
        byte[] byArray15 = new byte[16];
        byArray15[0] = 10;
        byArray15[1] = 6;
        byArray15[2] = 9;
        byArray15[4] = 12;
        byArray15[5] = 11;
        byArray15[6] = 7;
        byArray15[7] = 13;
        byArray15[8] = 15;
        byArray15[9] = 1;
        byArray15[10] = 3;
        byArray15[11] = 14;
        byArray15[12] = 5;
        byArray15[13] = 2;
        byArray15[14] = 8;
        byArray15[15] = 4;
        byArrayArray[14] = byArray15;
        byte[] byArray16 = new byte[16];
        byArray16[0] = 3;
        byArray16[1] = 15;
        byArray16[3] = 6;
        byArray16[4] = 10;
        byArray16[5] = 1;
        byArray16[6] = 13;
        byArray16[7] = 8;
        byArray16[8] = 9;
        byArray16[9] = 4;
        byArray16[10] = 5;
        byArray16[11] = 11;
        byArray16[12] = 12;
        byArray16[13] = 7;
        byArray16[14] = 2;
        byArray16[15] = 14;
        byArrayArray[15] = byArray16;
        byte[] byArray17 = new byte[16];
        byArray17[0] = 2;
        byArray17[1] = 12;
        byArray17[2] = 4;
        byArray17[3] = 1;
        byArray17[4] = 7;
        byArray17[5] = 10;
        byArray17[6] = 11;
        byArray17[7] = 6;
        byArray17[8] = 8;
        byArray17[9] = 5;
        byArray17[10] = 3;
        byArray17[11] = 15;
        byArray17[12] = 13;
        byArray17[14] = 14;
        byArray17[15] = 9;
        byArrayArray[16] = byArray17;
        byte[] byArray18 = new byte[16];
        byArray18[0] = 14;
        byArray18[1] = 11;
        byArray18[2] = 2;
        byArray18[3] = 12;
        byArray18[4] = 4;
        byArray18[5] = 7;
        byArray18[6] = 13;
        byArray18[7] = 1;
        byArray18[8] = 5;
        byArray18[10] = 15;
        byArray18[11] = 10;
        byArray18[12] = 3;
        byArray18[13] = 9;
        byArray18[14] = 8;
        byArray18[15] = 6;
        byArrayArray[17] = byArray18;
        byte[] byArray19 = new byte[16];
        byArray19[0] = 4;
        byArray19[1] = 2;
        byArray19[2] = 1;
        byArray19[3] = 11;
        byArray19[4] = 10;
        byArray19[5] = 13;
        byArray19[6] = 7;
        byArray19[7] = 8;
        byArray19[8] = 15;
        byArray19[9] = 9;
        byArray19[10] = 12;
        byArray19[11] = 5;
        byArray19[12] = 6;
        byArray19[13] = 3;
        byArray19[15] = 14;
        byArrayArray[18] = byArray19;
        byte[] byArray20 = new byte[16];
        byArray20[0] = 11;
        byArray20[1] = 8;
        byArray20[2] = 12;
        byArray20[3] = 7;
        byArray20[4] = 1;
        byArray20[5] = 14;
        byArray20[6] = 2;
        byArray20[7] = 13;
        byArray20[8] = 6;
        byArray20[9] = 15;
        byArray20[11] = 9;
        byArray20[12] = 10;
        byArray20[13] = 4;
        byArray20[14] = 5;
        byArray20[15] = 3;
        byArrayArray[19] = byArray20;
        byte[] byArray21 = new byte[16];
        byArray21[0] = 12;
        byArray21[1] = 1;
        byArray21[2] = 10;
        byArray21[3] = 15;
        byArray21[4] = 9;
        byArray21[5] = 2;
        byArray21[6] = 6;
        byArray21[7] = 8;
        byArray21[9] = 13;
        byArray21[10] = 3;
        byArray21[11] = 4;
        byArray21[12] = 14;
        byArray21[13] = 7;
        byArray21[14] = 5;
        byArray21[15] = 11;
        byArrayArray[20] = byArray21;
        byte[] byArray22 = new byte[16];
        byArray22[0] = 10;
        byArray22[1] = 15;
        byArray22[2] = 4;
        byArray22[3] = 2;
        byArray22[4] = 7;
        byArray22[5] = 12;
        byArray22[6] = 9;
        byArray22[7] = 5;
        byArray22[8] = 6;
        byArray22[9] = 1;
        byArray22[10] = 13;
        byArray22[11] = 14;
        byArray22[13] = 11;
        byArray22[14] = 3;
        byArray22[15] = 8;
        byArrayArray[21] = byArray22;
        byte[] byArray23 = new byte[16];
        byArray23[0] = 9;
        byArray23[1] = 14;
        byArray23[2] = 15;
        byArray23[3] = 5;
        byArray23[4] = 2;
        byArray23[5] = 8;
        byArray23[6] = 12;
        byArray23[7] = 3;
        byArray23[8] = 7;
        byArray23[10] = 4;
        byArray23[11] = 10;
        byArray23[12] = 1;
        byArray23[13] = 13;
        byArray23[14] = 11;
        byArray23[15] = 6;
        byArrayArray[22] = byArray23;
        byte[] byArray24 = new byte[16];
        byArray24[0] = 4;
        byArray24[1] = 3;
        byArray24[2] = 2;
        byArray24[3] = 12;
        byArray24[4] = 9;
        byArray24[5] = 5;
        byArray24[6] = 15;
        byArray24[7] = 10;
        byArray24[8] = 11;
        byArray24[9] = 14;
        byArray24[10] = 1;
        byArray24[11] = 7;
        byArray24[12] = 6;
        byArray24[14] = 8;
        byArray24[15] = 13;
        byArrayArray[23] = byArray24;
        byte[] byArray25 = new byte[16];
        byArray25[0] = 4;
        byArray25[1] = 11;
        byArray25[2] = 2;
        byArray25[3] = 14;
        byArray25[4] = 15;
        byArray25[6] = 8;
        byArray25[7] = 13;
        byArray25[8] = 3;
        byArray25[9] = 12;
        byArray25[10] = 9;
        byArray25[11] = 7;
        byArray25[12] = 5;
        byArray25[13] = 10;
        byArray25[14] = 6;
        byArray25[15] = 1;
        byArrayArray[24] = byArray25;
        byte[] byArray26 = new byte[16];
        byArray26[0] = 13;
        byArray26[2] = 11;
        byArray26[3] = 7;
        byArray26[4] = 4;
        byArray26[5] = 9;
        byArray26[6] = 1;
        byArray26[7] = 10;
        byArray26[8] = 14;
        byArray26[9] = 3;
        byArray26[10] = 5;
        byArray26[11] = 12;
        byArray26[12] = 2;
        byArray26[13] = 15;
        byArray26[14] = 8;
        byArray26[15] = 6;
        byArrayArray[25] = byArray26;
        byte[] byArray27 = new byte[16];
        byArray27[0] = 1;
        byArray27[1] = 4;
        byArray27[2] = 11;
        byArray27[3] = 13;
        byArray27[4] = 12;
        byArray27[5] = 3;
        byArray27[6] = 7;
        byArray27[7] = 14;
        byArray27[8] = 10;
        byArray27[9] = 15;
        byArray27[10] = 6;
        byArray27[11] = 8;
        byArray27[13] = 5;
        byArray27[14] = 9;
        byArray27[15] = 2;
        byArrayArray[26] = byArray27;
        byte[] byArray28 = new byte[16];
        byArray28[0] = 6;
        byArray28[1] = 11;
        byArray28[2] = 13;
        byArray28[3] = 8;
        byArray28[4] = 1;
        byArray28[5] = 4;
        byArray28[6] = 10;
        byArray28[7] = 7;
        byArray28[8] = 9;
        byArray28[9] = 5;
        byArray28[11] = 15;
        byArray28[12] = 14;
        byArray28[13] = 2;
        byArray28[14] = 3;
        byArray28[15] = 12;
        byArrayArray[27] = byArray28;
        byte[] byArray29 = new byte[16];
        byArray29[0] = 13;
        byArray29[1] = 2;
        byArray29[2] = 8;
        byArray29[3] = 4;
        byArray29[4] = 6;
        byArray29[5] = 15;
        byArray29[6] = 11;
        byArray29[7] = 1;
        byArray29[8] = 10;
        byArray29[9] = 9;
        byArray29[10] = 3;
        byArray29[11] = 14;
        byArray29[12] = 5;
        byArray29[14] = 12;
        byArray29[15] = 7;
        byArrayArray[28] = byArray29;
        byte[] byArray30 = new byte[16];
        byArray30[0] = 1;
        byArray30[1] = 15;
        byArray30[2] = 13;
        byArray30[3] = 8;
        byArray30[4] = 10;
        byArray30[5] = 3;
        byArray30[6] = 7;
        byArray30[7] = 4;
        byArray30[8] = 12;
        byArray30[9] = 5;
        byArray30[10] = 6;
        byArray30[11] = 11;
        byArray30[13] = 14;
        byArray30[14] = 9;
        byArray30[15] = 2;
        byArrayArray[29] = byArray30;
        byte[] byArray31 = new byte[16];
        byArray31[0] = 7;
        byArray31[1] = 11;
        byArray31[2] = 4;
        byArray31[3] = 1;
        byArray31[4] = 9;
        byArray31[5] = 12;
        byArray31[6] = 14;
        byArray31[7] = 2;
        byArray31[9] = 6;
        byArray31[10] = 10;
        byArray31[11] = 13;
        byArray31[12] = 15;
        byArray31[13] = 3;
        byArray31[14] = 5;
        byArray31[15] = 8;
        byArrayArray[30] = byArray31;
        byte[] byArray32 = new byte[16];
        byArray32[0] = 2;
        byArray32[1] = 1;
        byArray32[2] = 14;
        byArray32[3] = 7;
        byArray32[4] = 4;
        byArray32[5] = 10;
        byArray32[6] = 8;
        byArray32[7] = 13;
        byArray32[8] = 15;
        byArray32[9] = 12;
        byArray32[10] = 9;
        byArray32[12] = 3;
        byArray32[13] = 5;
        byArray32[14] = 6;
        byArray32[15] = 11;
        byArrayArray[31] = byArray32;
        Sbox = byArrayArray;
        byte[][] byArrayArray2 = new byte[32][];
        byte[] byArray33 = new byte[16];
        byArray33[0] = 14;
        byArray33[1] = 3;
        byArray33[2] = 4;
        byArray33[3] = 8;
        byArray33[4] = 1;
        byArray33[5] = 12;
        byArray33[6] = 10;
        byArray33[7] = 15;
        byArray33[8] = 7;
        byArray33[9] = 13;
        byArray33[10] = 9;
        byArray33[11] = 6;
        byArray33[12] = 11;
        byArray33[13] = 2;
        byArray33[15] = 5;
        byArrayArray2[0] = byArray33;
        byte[] byArray34 = new byte[16];
        byArray34[1] = 7;
        byArray34[2] = 5;
        byArray34[3] = 14;
        byArray34[4] = 3;
        byArray34[5] = 13;
        byArray34[6] = 9;
        byArray34[7] = 2;
        byArray34[8] = 15;
        byArray34[9] = 12;
        byArray34[10] = 8;
        byArray34[11] = 11;
        byArray34[12] = 10;
        byArray34[13] = 6;
        byArray34[14] = 4;
        byArray34[15] = 1;
        byArrayArray2[1] = byArray34;
        byte[] byArray35 = new byte[16];
        byArray35[0] = 15;
        byArray35[1] = 1;
        byArray35[2] = 6;
        byArray35[3] = 12;
        byArray35[5] = 14;
        byArray35[6] = 5;
        byArray35[7] = 11;
        byArray35[8] = 3;
        byArray35[9] = 10;
        byArray35[10] = 13;
        byArray35[11] = 7;
        byArray35[12] = 9;
        byArray35[13] = 4;
        byArray35[14] = 2;
        byArray35[15] = 8;
        byArrayArray2[2] = byArray35;
        byte[] byArray36 = new byte[16];
        byArray36[0] = 13;
        byArray36[1] = 6;
        byArray36[2] = 3;
        byArray36[3] = 10;
        byArray36[4] = 4;
        byArray36[5] = 8;
        byArray36[6] = 14;
        byArray36[7] = 7;
        byArray36[8] = 2;
        byArray36[9] = 5;
        byArray36[10] = 12;
        byArray36[11] = 9;
        byArray36[12] = 1;
        byArray36[13] = 15;
        byArray36[14] = 11;
        byArrayArray2[3] = byArray36;
        byte[] byArray37 = new byte[16];
        byArray37[0] = 13;
        byArray37[1] = 1;
        byArray37[2] = 10;
        byArray37[3] = 6;
        byArray37[4] = 7;
        byArray37[5] = 14;
        byArray37[6] = 4;
        byArray37[7] = 9;
        byArray37[8] = 2;
        byArray37[9] = 8;
        byArray37[10] = 15;
        byArray37[11] = 5;
        byArray37[12] = 12;
        byArray37[13] = 11;
        byArray37[14] = 3;
        byArrayArray2[4] = byArray37;
        byte[] byArray38 = new byte[16];
        byArray38[0] = 9;
        byArray38[1] = 10;
        byArray38[2] = 5;
        byArray38[4] = 2;
        byArray38[5] = 15;
        byArray38[6] = 12;
        byArray38[7] = 3;
        byArray38[8] = 6;
        byArray38[9] = 13;
        byArray38[10] = 11;
        byArray38[11] = 14;
        byArray38[12] = 8;
        byArray38[13] = 1;
        byArray38[14] = 7;
        byArray38[15] = 4;
        byArrayArray2[5] = byArray38;
        byte[] byArray39 = new byte[16];
        byArray39[1] = 7;
        byArray39[2] = 14;
        byArray39[3] = 13;
        byArray39[4] = 5;
        byArray39[5] = 8;
        byArray39[6] = 11;
        byArray39[7] = 2;
        byArray39[8] = 9;
        byArray39[9] = 12;
        byArray39[10] = 4;
        byArray39[11] = 3;
        byArray39[12] = 10;
        byArray39[13] = 6;
        byArray39[14] = 1;
        byArray39[15] = 15;
        byArrayArray2[6] = byArray39;
        byte[] byArray40 = new byte[16];
        byArray40[0] = 12;
        byArray40[1] = 3;
        byArray40[2] = 7;
        byArray40[3] = 4;
        byArray40[4] = 6;
        byArray40[5] = 13;
        byArray40[6] = 9;
        byArray40[7] = 10;
        byArray40[8] = 1;
        byArray40[9] = 15;
        byArray40[10] = 2;
        byArray40[11] = 8;
        byArray40[12] = 11;
        byArray40[14] = 14;
        byArray40[15] = 5;
        byArrayArray2[7] = byArray40;
        byte[] byArray41 = new byte[16];
        byArray41[0] = 1;
        byArray41[1] = 8;
        byArray41[2] = 14;
        byArray41[3] = 5;
        byArray41[4] = 13;
        byArray41[5] = 7;
        byArray41[6] = 4;
        byArray41[7] = 11;
        byArray41[8] = 15;
        byArray41[9] = 2;
        byArray41[11] = 12;
        byArray41[12] = 10;
        byArray41[13] = 9;
        byArray41[14] = 3;
        byArray41[15] = 6;
        byArrayArray2[8] = byArray41;
        byte[] byArray42 = new byte[16];
        byArray42[0] = 2;
        byArray42[1] = 15;
        byArray42[2] = 8;
        byArray42[3] = 4;
        byArray42[4] = 5;
        byArray42[5] = 10;
        byArray42[6] = 6;
        byArray42[7] = 1;
        byArray42[8] = 9;
        byArray42[9] = 3;
        byArray42[10] = 7;
        byArray42[11] = 13;
        byArray42[12] = 12;
        byArray42[14] = 11;
        byArray42[15] = 14;
        byArrayArray2[9] = byArray42;
        byte[] byArray43 = new byte[16];
        byArray43[0] = 7;
        byArray43[1] = 9;
        byArray43[2] = 10;
        byArray43[3] = 6;
        byArray43[4] = 2;
        byArray43[5] = 12;
        byArray43[6] = 1;
        byArray43[7] = 15;
        byArray43[8] = 4;
        byArray43[9] = 3;
        byArray43[10] = 13;
        byArray43[11] = 8;
        byArray43[12] = 11;
        byArray43[14] = 14;
        byArray43[15] = 5;
        byArrayArray2[10] = byArray43;
        byte[] byArray44 = new byte[16];
        byArray44[0] = 3;
        byArray44[2] = 14;
        byArray44[3] = 11;
        byArray44[4] = 8;
        byArray44[5] = 13;
        byArray44[6] = 4;
        byArray44[7] = 7;
        byArray44[8] = 6;
        byArray44[9] = 5;
        byArray44[10] = 1;
        byArray44[11] = 12;
        byArray44[12] = 15;
        byArray44[13] = 2;
        byArray44[14] = 10;
        byArray44[15] = 9;
        byArrayArray2[11] = byArray44;
        byte[] byArray45 = new byte[16];
        byArray45[0] = 4;
        byArray45[1] = 8;
        byArray45[2] = 9;
        byArray45[3] = 3;
        byArray45[4] = 14;
        byArray45[5] = 11;
        byArray45[6] = 5;
        byArray45[8] = 10;
        byArray45[9] = 6;
        byArray45[10] = 7;
        byArray45[11] = 12;
        byArray45[12] = 13;
        byArray45[13] = 1;
        byArray45[14] = 2;
        byArray45[15] = 15;
        byArrayArray2[12] = byArray45;
        byte[] byArray46 = new byte[16];
        byArray46[0] = 6;
        byArray46[1] = 12;
        byArray46[2] = 10;
        byArray46[3] = 7;
        byArray46[4] = 8;
        byArray46[5] = 3;
        byArray46[6] = 4;
        byArray46[7] = 9;
        byArray46[8] = 1;
        byArray46[9] = 15;
        byArray46[10] = 13;
        byArray46[11] = 2;
        byArray46[12] = 11;
        byArray46[14] = 14;
        byArray46[15] = 5;
        byArrayArray2[13] = byArray46;
        byte[] byArray47 = new byte[16];
        byArray47[0] = 3;
        byArray47[1] = 9;
        byArray47[2] = 13;
        byArray47[3] = 10;
        byArray47[4] = 15;
        byArray47[5] = 12;
        byArray47[6] = 1;
        byArray47[7] = 6;
        byArray47[8] = 14;
        byArray47[9] = 2;
        byArray47[11] = 5;
        byArray47[12] = 4;
        byArray47[13] = 7;
        byArray47[14] = 11;
        byArray47[15] = 8;
        byArrayArray2[14] = byArray47;
        byte[] byArray48 = new byte[16];
        byArray48[0] = 2;
        byArray48[1] = 5;
        byArray48[2] = 14;
        byArray48[4] = 9;
        byArray48[5] = 10;
        byArray48[6] = 3;
        byArray48[7] = 13;
        byArray48[8] = 7;
        byArray48[9] = 8;
        byArray48[10] = 4;
        byArray48[11] = 11;
        byArray48[12] = 12;
        byArray48[13] = 6;
        byArray48[14] = 15;
        byArray48[15] = 1;
        byArrayArray2[15] = byArray48;
        byte[] byArray49 = new byte[16];
        byArray49[0] = 13;
        byArray49[1] = 3;
        byArray49[3] = 10;
        byArray49[4] = 2;
        byArray49[5] = 9;
        byArray49[6] = 7;
        byArray49[7] = 4;
        byArray49[8] = 8;
        byArray49[9] = 15;
        byArray49[10] = 5;
        byArray49[11] = 6;
        byArray49[12] = 1;
        byArray49[13] = 12;
        byArray49[14] = 14;
        byArray49[15] = 11;
        byArrayArray2[16] = byArray49;
        byte[] byArray50 = new byte[16];
        byArray50[0] = 9;
        byArray50[1] = 7;
        byArray50[2] = 2;
        byArray50[3] = 12;
        byArray50[4] = 4;
        byArray50[5] = 8;
        byArray50[6] = 15;
        byArray50[7] = 5;
        byArray50[8] = 14;
        byArray50[9] = 13;
        byArray50[10] = 11;
        byArray50[11] = 1;
        byArray50[12] = 3;
        byArray50[13] = 6;
        byArray50[15] = 10;
        byArrayArray2[17] = byArray50;
        byte[] byArray51 = new byte[16];
        byArray51[0] = 14;
        byArray51[1] = 2;
        byArray51[2] = 1;
        byArray51[3] = 13;
        byArray51[5] = 11;
        byArray51[6] = 12;
        byArray51[7] = 6;
        byArray51[8] = 7;
        byArray51[9] = 9;
        byArray51[10] = 4;
        byArray51[11] = 3;
        byArray51[12] = 10;
        byArray51[13] = 5;
        byArray51[14] = 15;
        byArray51[15] = 8;
        byArrayArray2[18] = byArray51;
        byte[] byArray52 = new byte[16];
        byArray52[0] = 10;
        byArray52[1] = 4;
        byArray52[2] = 6;
        byArray52[3] = 15;
        byArray52[4] = 13;
        byArray52[5] = 14;
        byArray52[6] = 8;
        byArray52[7] = 3;
        byArray52[8] = 1;
        byArray52[9] = 11;
        byArray52[10] = 12;
        byArray52[12] = 2;
        byArray52[13] = 7;
        byArray52[14] = 5;
        byArray52[15] = 9;
        byArrayArray2[19] = byArray52;
        byte[] byArray53 = new byte[16];
        byArray53[0] = 8;
        byArray53[1] = 1;
        byArray53[2] = 5;
        byArray53[3] = 10;
        byArray53[4] = 11;
        byArray53[5] = 14;
        byArray53[6] = 6;
        byArray53[7] = 13;
        byArray53[8] = 7;
        byArray53[9] = 4;
        byArray53[10] = 2;
        byArray53[11] = 15;
        byArray53[13] = 9;
        byArray53[14] = 12;
        byArray53[15] = 3;
        byArrayArray2[20] = byArray53;
        byte[] byArray54 = new byte[16];
        byArray54[0] = 12;
        byArray54[1] = 9;
        byArray54[2] = 3;
        byArray54[3] = 14;
        byArray54[4] = 2;
        byArray54[5] = 7;
        byArray54[6] = 8;
        byArray54[7] = 4;
        byArray54[8] = 15;
        byArray54[9] = 6;
        byArray54[11] = 13;
        byArray54[12] = 5;
        byArray54[13] = 10;
        byArray54[14] = 11;
        byArray54[15] = 1;
        byArrayArray2[21] = byArray54;
        byte[] byArray55 = new byte[16];
        byArray55[0] = 9;
        byArray55[1] = 12;
        byArray55[2] = 4;
        byArray55[3] = 7;
        byArray55[4] = 10;
        byArray55[5] = 3;
        byArray55[6] = 15;
        byArray55[7] = 8;
        byArray55[8] = 5;
        byArray55[10] = 11;
        byArray55[11] = 14;
        byArray55[12] = 6;
        byArray55[13] = 13;
        byArray55[14] = 1;
        byArray55[15] = 2;
        byArrayArray2[22] = byArray55;
        byte[] byArray56 = new byte[16];
        byArray56[0] = 13;
        byArray56[1] = 10;
        byArray56[2] = 2;
        byArray56[3] = 1;
        byArray56[5] = 5;
        byArray56[6] = 12;
        byArray56[7] = 11;
        byArray56[8] = 14;
        byArray56[9] = 4;
        byArray56[10] = 7;
        byArray56[11] = 8;
        byArray56[12] = 3;
        byArray56[13] = 15;
        byArray56[14] = 9;
        byArray56[15] = 6;
        byArrayArray2[23] = byArray56;
        byte[] byArray57 = new byte[16];
        byArray57[0] = 5;
        byArray57[1] = 15;
        byArray57[2] = 2;
        byArray57[3] = 8;
        byArray57[5] = 12;
        byArray57[6] = 14;
        byArray57[7] = 11;
        byArray57[8] = 6;
        byArray57[9] = 10;
        byArray57[10] = 13;
        byArray57[11] = 1;
        byArray57[12] = 9;
        byArray57[13] = 7;
        byArray57[14] = 3;
        byArray57[15] = 4;
        byArrayArray2[24] = byArray57;
        byte[] byArray58 = new byte[16];
        byArray58[0] = 1;
        byArray58[1] = 6;
        byArray58[2] = 12;
        byArray58[3] = 9;
        byArray58[4] = 4;
        byArray58[5] = 10;
        byArray58[6] = 15;
        byArray58[7] = 3;
        byArray58[8] = 14;
        byArray58[9] = 5;
        byArray58[10] = 7;
        byArray58[11] = 2;
        byArray58[12] = 11;
        byArray58[14] = 8;
        byArray58[15] = 13;
        byArrayArray2[25] = byArray58;
        byte[] byArray59 = new byte[16];
        byArray59[0] = 12;
        byArray59[2] = 15;
        byArray59[3] = 5;
        byArray59[4] = 1;
        byArray59[5] = 13;
        byArray59[6] = 10;
        byArray59[7] = 6;
        byArray59[8] = 11;
        byArray59[9] = 14;
        byArray59[10] = 8;
        byArray59[11] = 2;
        byArray59[12] = 4;
        byArray59[13] = 3;
        byArray59[14] = 7;
        byArray59[15] = 9;
        byArrayArray2[26] = byArray59;
        byte[] byArray60 = new byte[16];
        byArray60[0] = 10;
        byArray60[1] = 4;
        byArray60[2] = 13;
        byArray60[3] = 14;
        byArray60[4] = 5;
        byArray60[5] = 9;
        byArray60[7] = 7;
        byArray60[8] = 3;
        byArray60[9] = 8;
        byArray60[10] = 6;
        byArray60[11] = 1;
        byArray60[12] = 15;
        byArray60[13] = 2;
        byArray60[14] = 12;
        byArray60[15] = 11;
        byArrayArray2[27] = byArray60;
        byte[] byArray61 = new byte[16];
        byArray61[0] = 13;
        byArray61[1] = 7;
        byArray61[2] = 1;
        byArray61[3] = 10;
        byArray61[4] = 3;
        byArray61[5] = 12;
        byArray61[6] = 4;
        byArray61[7] = 15;
        byArray61[8] = 2;
        byArray61[9] = 9;
        byArray61[10] = 8;
        byArray61[11] = 6;
        byArray61[12] = 14;
        byArray61[14] = 11;
        byArray61[15] = 5;
        byArrayArray2[28] = byArray61;
        byte[] byArray62 = new byte[16];
        byArray62[0] = 12;
        byArray62[2] = 15;
        byArray62[3] = 5;
        byArray62[4] = 7;
        byArray62[5] = 9;
        byArray62[6] = 10;
        byArray62[7] = 6;
        byArray62[8] = 3;
        byArray62[9] = 14;
        byArray62[10] = 4;
        byArray62[11] = 11;
        byArray62[12] = 8;
        byArray62[13] = 2;
        byArray62[14] = 13;
        byArray62[15] = 1;
        byArrayArray2[29] = byArray62;
        byte[] byArray63 = new byte[16];
        byArray63[0] = 8;
        byArray63[1] = 3;
        byArray63[2] = 7;
        byArray63[3] = 13;
        byArray63[4] = 2;
        byArray63[5] = 14;
        byArray63[6] = 9;
        byArray63[8] = 15;
        byArray63[9] = 4;
        byArray63[10] = 10;
        byArray63[11] = 1;
        byArray63[12] = 5;
        byArray63[13] = 11;
        byArray63[14] = 6;
        byArray63[15] = 12;
        byArrayArray2[30] = byArray63;
        byte[] byArray64 = new byte[16];
        byArray64[0] = 11;
        byArray64[1] = 1;
        byArray64[3] = 12;
        byArray64[4] = 4;
        byArray64[5] = 13;
        byArray64[6] = 14;
        byArray64[7] = 3;
        byArray64[8] = 6;
        byArray64[9] = 10;
        byArray64[10] = 5;
        byArray64[11] = 15;
        byArray64[12] = 9;
        byArray64[13] = 7;
        byArray64[14] = 2;
        byArray64[15] = 8;
        byArrayArray2[31] = byArray64;
        SboxInverse = byArrayArray2;
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

