#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************




CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Spcoef (N, X, F, B, C, D, IFLAG)

******************************************************************
*                                                                *
*    Subroutine Spline_Coefficient                               *
*                                                                *
*                                                                *
*  Calculate coefficients for smooth cubic interpolatory spline. *
*                                                                *
*  Input parameters:                                             *
*    N = number of data points                                   *
*    X = vector of values of the independent variable.  It       *
*        is assumed that x(i) .lt. x(i+1) for all i.             *
*    F = vector of values of the dependent variable.             *
*  Output parameters:                                            *
*                                                                *
*    B = vector of s'(X(I)) VALUES.                              *
*    C = vector of s"(X(I))/2 VALUES.                            *
*    D = vector of s'''(X(I)+)/6 VALUES.                         *
*    IFLAG = 0   normal return;                                  *
*          = -1  input n .le. 1;                                 *
*          = -2  x vector is incorrectly ordered.                *
*                                                                *
*  The vectors X,F,B,C,D must be dimensioned at least N.         *
*                                                                *
******************************************************************


        Real    X(N),F(N),B(N),C(N),D(N)
        Integer N,IFLAG

        Real    H,FP1,FPN,P
        Integer I,K,NM1
 
*       (* Calculate coefficients for tri-diagonal system:
*          store sub-diagonal in B, diagonal in D, diff. 
*          quotient in C. *)
        IF (N .LE. 1) GOTO 70
        B(1) = X(2)-X(1)
        IF (B(1) .LE. 0.) GOTO 80
        C(1) = (F(2)-F(1))/B(1)
        IF (N .GT. 2) GOTO 10
        B(1) = C(1)
        C(1) = 0
        D(1) = 0
        IFLAG = 0

        RETURN

   10   D(1) = 2.0*B(1)
        NM1 = N-1
        DO 20 I = 2,NM1
          B(I) = X(I+1)-X(I)
          IF (B(I) .LE. 0.) GOTO 80
          C(I) = (F(I+1)-F(I))/B(I)
          D(I) = 2.0*(B(I)+B(I-1))
   20   CONTINUE
        D(N) = 2.0*B(N-1)
 
*       (* Calculate estimates for end slopes. *)
        FP1 = C(1)-B(1)*(C(2)-C(1))/(B(1)+B(2))
        IF (N .GT. 3) FP1 = FP1+B(1)*((B(1)+B(2))*(C(3)-C(2))
     &                      /(B(2)+B(3))-C(2)+C(1))/(X(4)-X(1))
        FPN = C(N-1)+B(N-1)*(C(N-1)-C(N-2))/(B(N-2)+B(N-1))
        IF (N .GT. 3) FPN = FPN+B(N-1)*(C(N-1)-C(N-2)-(B(N-2)
     &          +B(N-1))*(C(N-2)-C(N-3))/(B(N-2)+B(N-3)))/(X(N)-X(N-3))
 
*       (* Calculate right-hand-side, store in C. *)
        C(N) = 3.0*(FPN-C(N-1))
        DO 30 K = 2,NM1
          I = N-K+1
          C(I) = 3.0*(C(I)-C(I-1))
   30   CONTINUE
        C(1) = 3.0*(C(1)-FP1)
 
*       (* Solve tridiagonal system. *)
        DO 40 K = 2,N
          P = B(K-1)/D(K-1)
          D(K) = D(K)-P*B(K-1)
          C(K) = C(K)-P*C(K-1)
   40   CONTINUE
        C(N) = C(N)/D(N)
        DO 50 I = 1,NM1
          K = N-I
          C(K) = (C(K)-B(K)*C(K+1))/D(K)
   50   CONTINUE
 
*       (* Calculate spline coefficients. *)
        DO 60 I = 1,NM1
          H = X(I+1)-X(I)
          D(I) = (C(I+1)-C(I))/(3.0*H)
          B(I) = (F(I+1)-F(I))/H-H*(C(I)+H*D(I))
   60   CONTINUE
        IFLAG = 0
        RETURN

   70   IFLAG = -1
        RETURN
   80   IFLAG = -2
        RETURN
        END
