(* Information attached to parsetree *)

(*
$File: Common/GRAMMAR_INFO.sml $
$Date: 1992/12/18 08:57:29 $
$Revision: 1.14 $
$Locker: birkedal $
*)

(*$GRAMMAR_INFO*)
signature GRAMMAR_INFO =
  sig
   (* The constituent info types. *)

    type SourceInfo and DFInfo and ErrorInfo and TypeInfo and OverloadingInfo

   (* The composite info types, pre-elab. and post-elab. *)

    type PreElabGrammarInfo and PostElabGrammarInfo

    val emptyPreElabGrammarInfo:  PreElabGrammarInfo
    val emptyPostElabGrammarInfo: PostElabGrammarInfo

    val addPreElabSourceInfo:
      PreElabGrammarInfo -> SourceInfo -> PreElabGrammarInfo

    val addPreElabDFInfo:
      PreElabGrammarInfo -> DFInfo -> PreElabGrammarInfo

    val getPreElabSourceInfo: PreElabGrammarInfo -> SourceInfo Option
    val getPreElabDFInfo:     PreElabGrammarInfo -> DFInfo Option


    val addPostElabErrorInfo:
      PostElabGrammarInfo -> ErrorInfo -> PostElabGrammarInfo

    val addPostElabTypeInfo:
      PostElabGrammarInfo -> TypeInfo -> PostElabGrammarInfo

    val addPostElabOverloadingInfo:        (* Adds overloading info regadless of whether
					      there already is overloading info attached *)
      PostElabGrammarInfo -> OverloadingInfo -> PostElabGrammarInfo

    val getPostElabSourceInfo: PostElabGrammarInfo -> SourceInfo Option
    val getPostElabDFInfo:     PostElabGrammarInfo -> DFInfo Option
    val getPostElabErrorInfo:  PostElabGrammarInfo -> ErrorInfo Option
    val getPostElabTypeInfo:   PostElabGrammarInfo -> TypeInfo Option
    val getPostElabOverloadingInfo: PostElabGrammarInfo -> OverloadingInfo Option
    val removePostElabOverloadingInfo : PostElabGrammarInfo ->
                                        PostElabGrammarInfo

    val convertGrammarInfo: PreElabGrammarInfo -> PostElabGrammarInfo

    type StringTree
    val layoutDFInfo:          DFInfo -> StringTree
    val layoutErrorInfo:       ErrorInfo -> StringTree
    val layoutSourceInfo:      SourceInfo -> StringTree
    val layoutTypeInfo:        TypeInfo -> StringTree
    val layoutOverloadingInfo: OverloadingInfo -> StringTree

    val layoutPreElabGrammarInfo:  PreElabGrammarInfo -> StringTree
    val layoutPostElabGrammarInfo: PostElabGrammarInfo -> StringTree
  end;
