(* Identifiers which have been resolved *)

(*
$File: Common/ResIdent.sml $
$Date: 1991/08/26 12:15:08 $
$Revision: 1.7 $
$Locker: birkedal $
*)

(*$ResIdent : IDENT VAR CON EXCON RESIDENT *)

functor ResIdent
 (structure Ident : IDENT
  structure Var   : VAR
  structure Con   : CON
  structure Excon : EXCON) : RESIDENT =
struct
  type longvar   = Var.longvar     (* value variables *)
  type longcon   = Con.longcon     (* constructors *)
  type longexcon = Excon.longexcon (* exception constructors *)

  datatype longid =
    LONGVAR of longvar
  | LONGCON of longcon
  | LONGEXCON of longexcon

  fun pr_longid (LONGVAR   longvar  ) = Var.pr_longvar longvar
   |  pr_longid (LONGCON   longcon  ) = Con.pr_longcon longcon
   |  pr_longid (LONGEXCON longexcon) = Excon.pr_longexcon longexcon

  val pr_longvar   = Var.pr_longvar
  and pr_longcon   = Con.pr_longcon
  and pr_longexcon = Excon.pr_longexcon
end;

        


