(*
$File: Compiler/COMPILER_ENV.sml $
$Date: 1992/09/18 18:03:50 $
$Revision: 1.2 $
$Locker:  $
*)

(*$COMPILER_ENV*)
(* COMPILER_ENV: used by CompileDec to look up identifiers, returning lvars
   (for things which have actually been declared) or prims (for built-in
   functions). *)

signature COMPILER_ENV =
  sig
    type CEnv
    type id				(* Identifiers. *)
    type var				(* Unqualified variables. *)
    type longvar			(* Qualified vars (for lookup). *)
    type excon				(* Unqualified exception constructors.*)
    type longexcon			(* Qualified excons (for lookup). *)
    type lvar				(* Unique lambda identifiers. *)

    val emptyCEnv: CEnv
    val initialCEnv: CEnv

    val declareVar: (var * lvar * CEnv) -> CEnv
    val declareExcon: (excon * lvar * CEnv) -> CEnv

    val plus: CEnv * CEnv -> CEnv

    datatype result = LVAR of lvar
                    | ABS | NEG | PLUS | MINUS | MUL | LESS 
		    | GREATER | LESSEQ | GREATEREQ
                    | PRIM		(* Looking up a value identifier will
					   either get you a real lvar,
					   an overloaded operator,
					   or PRIM (which means you have to
					   extract the integer argument and
					   use it in a PRIM lambda-exp). *)

    val lookupId: CEnv -> id -> lvar	(* Look up an identifier in order to
					   print top-level bindings. *)

    val lookupLongvar: CEnv -> longvar -> result
					(* Only `prim' should give you back
					   `PRIM' (and even then it can be
					   overwritten). *)

    val lookupLongexcon: CEnv -> longexcon -> lvar
					(* Looking up an excon must give
					   you an lvar. *)

    val lookupExcon: CEnv -> excon -> lvar
					(* MEMO: Temporary: Match and Bind. *)

    val lvarsOfCEnv: CEnv -> lvar list

    type StringTree
    val layoutCEnv: CEnv -> StringTree
  end;
