(*---RCS--- $Log:	_CEXP.sml,v $
Revision 1.1  92/09/17  14:17:21  birkedal
Edinburgh Version 11Sep92
*)

(*$CEXP*)
(* Continuation-passing expressions are a subset of lambda expressions.
   All applications must be tail-recursive (this is why we get away with
   no stack); it's convenient to make that a "syntactic" restriction in
   this datatype (damn useful in fact, otherwise I would have got it
   wrong). Static scoping rules still apply when the CExp's are
   first generated, although closures will get eliminated later. *)

signature CEXP =
  sig
    type lvar
    type prim
    type (''a, 'b) map

   (* These constructors correspond quite closely to those in LambdaExp,
      except that all inner CExp occurrences are tail-recursive.
    *)

    datatype 'a option = NONE | SOME of 'a

    datatype CExp =
        FIX      of {f: lvar, formals: lvar list, body: CExp} list * CExp
      | APP      of {f: lvar, actuals: Simple list}
      | PRIM_APP of {cont: lvar, prim: prim, arg: lvar}
      | SELECT   of int * lvar
      | SWITCH_I of int Switch
      | SWITCH_S of string Switch
      | SWITCH_R of real Switch
      | SIMPLE	 of Simple

    and Simple =
        VAR      of lvar
      | INTEGER  of int
      | STRING   of string
      | REAL     of real
      | VECTOR	 of lvar list
      | VOID

    and 'a Switch = SWITCH of {arg: lvar,
			       selections: ('a, CExp) map,
			       wildcard: CExp option
				(* mandatory for REAL or STRING switches. *)
			      }

    type StringTree
    val layoutCExp: CExp -> StringTree
  end;
