
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% Find all permanent variables
permvars([Head|Body], Vars, Perms) :-
	colvars(Head, HeadVars),
	xpermvars(Body, [HeadVars,[],[]], [Vars,Half,Perms]), !.

xpermvars([], AllVars, AllVars).

% Disjunction:
xpermvars([Dis|Rest], SoFar, Out) :-
	Dis=(_;_), !,
	disxpermvars(Dis, SoFar, NewSoFar),
	xpermvars(Rest, NewSoFar, Out).

% Conjunction:
xpermvars([A|Rest], SoFar, Out) :-
	SoFar=[Vars, Half, Perms],
	colvars(A, AVars),
	intersectv(AVars, Half, P),
	unionv(Perms, P, NewPerms), % Fresh variables at end of NewPerms.
	unionv(AVars, Vars, NewVars),
	newhalf(A, Half, NewVars, NewHalf),
	NewSoFar=[NewVars, NewHalf, NewPerms],
	xpermvars(Rest, NewSoFar, Out).

	% calculate new Half permanent set:
	newhalf(A, Half, NewVars, Half) :-
		escape_builtin(A), !.
	newhalf(A, Half, NewVars, NewHalf) :-
		unionv(NewVars, Half, NewHalf).

	disxpermvars((A;B), SoFar, Out) :- !,
		xpermvars(A, SoFar, OutA),
		disxpermvars(B, SoFar, OutB),
		mapcar(unionv, OutA, OutB, Out). % Fresh vars at end of Perms.
	disxpermvars(B, SoFar, Out) :-
		xpermvars(B, SoFar, Out).
