
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% Set utilities used in the PLM compiler.
% "v" at the end of a name means no unification done.


in(X, L) :- memberv(X, L).
notin(X, L) :- memberv(X, L), !, fail.
notin(X, L).

unionv(S1, S2, S1) :- S1==S2.
unionv([X|S1], S2, Res) :-
	memberv(X, S2), !,
	unionv(S1, S2, Res).
unionv([X|S1], S2, [X|Res]) :-
	unionv(S1, S2, Res).
unionv([], S, S).

diffv([X|S1], S2, Res) :-
	memberv(X, S2), !,
	diffv(S1, S2, Res).
diffv([X|S1], S2, [X|Res]) :-
	diffv(S1, S2, Res).
diffv([], _, []).

intersectv([X|Set1], Set2, Res) :-
	(in(X, Set1); notin(X, Set2)), !,
	intersectv(Set1, Set2, Res).
intersectv([X|Set1], Set2, [X|Res]) :-
	intersectv(Set1, Set2, Res).
intersectv([], _, []).

includev(X, S1, S1) :- in(X, S1), !.
includev(X, S1, [X|S1]).
