/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.FuncSig;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.JavaInvoke;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

class ArraySig
extends InternalRep {
    Class componentType;
    int dimensions;

    protected InternalRep duplicate() {
        return new ArraySig(this.componentType, this.dimensions);
    }

    static boolean looksLikeArraySig(Interp interp, TclObject signature) throws TclException {
        InternalRep rep = signature.getInternalRep();
        if (rep instanceof FuncSig) {
            return false;
        }
        if (rep instanceof ArraySig) {
            return true;
        }
        if (TclList.getLength((Interp)interp, (TclObject)signature) < 1) {
            return false;
        }
        String clsName = TclList.index((Interp)interp, (TclObject)signature, (int)0).toString();
        return clsName.endsWith("[]") || clsName.startsWith("[");
    }

    static ArraySig get(Interp interp, TclObject signature) throws TclException {
        String clsName;
        InternalRep rep = signature.getInternalRep();
        if (rep instanceof ArraySig) {
            return (ArraySig)rep;
        }
        if (TclList.getLength((Interp)interp, (TclObject)signature) == 1 && ((clsName = TclList.index((Interp)interp, (TclObject)signature, (int)0).toString()).endsWith("[]") || clsName.startsWith("["))) {
            String tmp;
            Class componentType = JavaInvoke.getClassByName(interp, clsName);
            int dimensions = 0;
            if (clsName.charAt(0) == '[') {
                tmp = clsName;
                while (tmp.charAt(++dimensions) == '[') {
                }
            } else {
                tmp = clsName;
                while (tmp.endsWith("[]")) {
                    tmp = tmp.substring(0, tmp.length() - 2);
                    ++dimensions;
                }
            }
            ArraySig sigRep = new ArraySig(componentType, dimensions);
            signature.setInternalRep(sigRep);
            return sigRep;
        }
        throw new TclException(interp, "bad array signature \"" + signature + "\"");
    }

    ArraySig(Class cType, int n) {
        this.componentType = cType;
        this.dimensions = n;
    }
}

