; **************************************************************
; *                                                            *
; *   IFKeyNav                                                 *
; *   IF keyboard travelling AutoIt script by Roy Lazarovich   *
; *   Feel free to use, abuse, misuse, modify and distribute   *
; *                                                            *
; **************************************************************

#include <Misc.au3>

; You can change the title of the window below to possibly work with other interpreters
Local $title = "Windows Frotz";

Local $hWnd = WinWait($title, "", 1)
Local $hDLL = DllOpen("user32.dll")
Local $Run = True

If ($hWnd == 0) Then

   MsgBox (16, "Unable to find window", "IFKeyNav was unable to find a window titled '" & $title & "'" & Chr(13) & "You can re-compile the AutoIt script to possibly work with other interpreters" & Chr(13) & Chr(13) & "IFKeyNav will now exit")
   Exit

Else

   MsgBox (64, "IFKeyNav is ready", "IFKeyNav is ready!" & Chr(13) & Chr(13) & "Press Ctrl+Arrow Keys for the compass directions" & Chr(13) & "Press Ctrl+PgUp,PgDn,End and Home for the diagonals" & Chr(13) & "Press Ctrl+Insert and Ctrl+Delete for up and down respectively" & Chr(13) & "Press Ctrl+Escape to quit IFKeyNav" & Chr(13) & "You can re-compile the AutoIt script to define other key combinations" & Chr(13) & Chr(13) & "Have fun!" & Chr(13) & "-Roy Lazarovich")

EndIf

While $Run

   if WinActive($hWnd) And _IsPressed("11", $hDLL) Then

	  if _IsPressed("25", $hDLL) Then SendDir("w")		; Ctrl+Left
	  if _IsPressed("26", $hDLL) Then SendDir("n")		; Ctrl+Up
	  if _IsPressed("27", $hDLL) Then SendDir("e")		; Ctrl+Right
	  if _IsPressed("28", $hDLL) Then SendDir("s")		; Ctrl+Down
	  if _IsPressed("21", $hDLL) Then SendDir("ne")		; Ctrl+PgUp
	  if _IsPressed("22", $hDLL) Then SendDir("se")		; Ctrl+PgDn
	  if _IsPressed("24", $hDLL) Then SendDir("nw")		; Ctrl+Home
	  if _IsPressed("23", $hDLL) Then SendDir("sw")		; Ctrl+End
	  if _IsPressed("2D", $hDLL) Then SendDir("up")		; Ctrl+Insert
	  if _IsPressed("2E", $hDLL) Then SendDir("down")	; Ctrl+Delete
	  if _IsPressed("1B", $hDLL) Then $Run = False		; Ctrl+Esc

	  ; See other key codes here:
	  ; https://www.autoitscript.com/autoit3/docs/libfunctions/_IsPressed.htm

   EndIf

WEnd

MsgBox (64, "IFKeyNav is closing", "IFKeyNav is closing, goodbye!")

Func SendDir($dir)

   ControlSend($hWnd, "", "", $dir)
   ControlSend($hWnd, "", "", "{ENTER}")
   Sleep(200)

EndFunc
