#include <adv.t>
#include <std.t>
#include <askabout.t>


/* This program is Copyright (c) 1994 David Allen.  It may be freely
   distributed as long as you leave my name and copyright notice on it.
   I'd really like your comments and feedback; send e-mail to
   allen@viewlogic.com, or send us-mail to David Allen, 10 O'Moore Ave,
   Maynard, MA 01754. */


/* This is a simple game with three rooms, three decoration items and
   three actors.  It is intended to show how to use the features in the
   "ask about" module.   See the askabout.t and askabout.doc files for 
   more information. */


/* Have to add aaInit() to preinit, copied from adv.t */
replace preinit: function {
    local o;
    global.lamplist := [];
    o := firstobj();
    while (o <> nil) {
       if (o.islamp) global.lamplist := global.lamplist + o;
       o := nextobj (o); }
    initSearch();
    aaInit(); }


/* Three boring rooms */


startroom: room
   sdesc = "Clearing"
   ldesc = "You're standing in a clearing in the forest.  I hope you weren't
      planning on going far, because in all directions you are
      surrounded by dense forest.  There is, however, a small trail
      which goes north. "
   north = midroom;

midroom: room
   sdesc = "Small trail"
   ldesc = "You are on a small trail which runs north to south.  Dense
      forest surrounds you. "
   north = deadend
   south = startroom;

deadend: room
   sdesc = "Dead end"
   ldesc = "You are at the end of a small trail.  Dense forest surrounds
      you.  (I did say you weren't going far!)  The trail leads
      back to the south. "
   south = midroom;


/* Forest item.  Since ask about does not disambiguate, you can ask about
   forest anywhere.  It has two simple factoids.  The second factoid will
   only be told once per character, but the actual text is randomized. */
forest: thing sdesc = "forest" noun = 'forest' location = nil;

forestfact1: aaFactoid
   aaTheFact = "The forest is very dense."
   aaFactLoc = forest;
forestfact2: aaFactoid
   aaTheFact = { aaOneOf ([
      'I think this forest extends to the end of the world.',
      'The forest extends to the end of the world.',
      'The entire world is covered with forest.']); }
   aaFactLoc = forest;

/* Repeat same decoration in three rooms */
class forestClass: decoration
   sdesc = "forest"
   ldesc = "It is dense forest. ";
forest1: forestClass location = startroom;
forest2: forestClass location = midroom;
forest3: forestClass location = deadend;


/* Three "rock" items; each is a member of the "topic" "rocks".  See 
   askabout.doc and askabout.t for definition and use of "topics". */


rocks: aaTopic noun = 'rocks' sdesc = "rocks" thedesc = "rocks"
   aaFactClass = rockClass;
class rockClass: fixeditem;
rocksfact1: aaFactoid
   aaTheFact = "Rocks are collectible."
   aaFactLoc = rocks;


bluerock: rockClass
   sdesc = "blue rock" noun  = 'rock' adjective = 'blue'
   heredesc = "On the ground is a blue rock. "
   ldesc = "It is a rather ordinary rock; the only thing outstanding about
      it is that it is a rather hideous shade of blue. "
   location = startroom;

redrock: rockClass
   sdesc = "red rock" noun  = 'rock' adjective = 'red'
   heredesc = "On the ground is a red rock. "
   ldesc = "It is a rather ordinary rock; the only thing outstanding about
      it is that it is a rather hideous shade of red. "
   location = startroom;

red1: aaFactoid
   aaTheFact = "The red rock is strangely shaped."
   aaFactLoc = redrock;
red2: aaFactoid
   aaTheFact = "There is an interesting smell to the red rock."
   aaFactLoc = redrock;
/* This factoid is only available if a previous factoid has been told */
red3: aaFactoid
   aaTheFact = "The smell of the red rock reminds me of lilacs."
   aaFactLoc = redrock
   aaAvail (actor) = {
      if (actor.aaNeverTold (red2, &aaTell)) return (nil);
      else return (true); };

greenrock: rockClass
   sdesc = "green rock" noun  = 'rock' adjective = 'green'
   heredesc = "On the ground is a green rock. "
   ldesc = "It is a rather ordinary rock; the only thing outstanding about
      it is that it is a rather hideous shade of green. "
   location = midroom;


/* For this game, each actor has a factoid which can tell their hair color.
   Notice that this "factoid" uses a different mechanism from the usual 
   aaFactoid.aaTell pair. */
modify class Actor
   replace aaGetFactoids (actor) = {
      local l;
      /* First get the basic factoids for the actor */
      l := aaGetBasicFacts (self, actor);
      /* Next, add the hair color factoid.  It is always available; if it
         wasn't, this function would do the work to determine availability. */
      l += self; l += &hairfact; return (l); }
   hairfact (actor) = {
      if (actor = self) "\"My "; else {"\""; self.sdesc; "'s "; }
      "hair is "; say (self.haircolor); ".\" ";
      /* Return nil so factoid is not repeated */
      return (nil); };


/* Three actors, so you can ask them things. */


class joesfriend: object;

joe: Actor, joesfriend
   sdesc = "Joe" thedesc = "Joe" adesc = "Joe" noun = 'Joe'
   ldesc = "Joe is a slightly impatient guy. "
   haircolor = 'brown'
   location = deadend
   repeatedask = []
   checkrepeated (obj) = {
      local i, angry := nil;
      for (i:=1; i<=length(self.repeatedask); i++)
         if (obj = self.repeatedask[i]) { angry := true; break; }
      if (angry = nil) self.repeatedask += obj;
      return (angry); }
   aaDontKnow (obj) = {
      if (self.checkrepeated (obj) = true)
         "\"I said, I don't know much about <<self.aaMaybeMe (obj)>>!\" ";
      else "\"I don't know much about <<self.aaMaybeMe (obj)>>.\" "; }
   aaToldAll (obj) = {
      if (self.checkrepeated (obj) = true)
         "\"I said, I told you all I know about <<self.aaMaybeMe (obj)>>!\" ";
      else "\"I told you all I know about <<self.aaMaybeMe (obj)>>.\" "; };

/* Only Joe's friends know this fact */
joe1: aaFactoid
   aaTheFact = "Joe hates people who ask a lot of questions."
   aaMyFact = "I hate people who ask a lot of questions."
   aaClassKnowing = joesfriend
   aaFactLoc = joe;


/* Fred is Joe's friend */
fred: Actor, joesfriend
   sdesc = "Fred" thedesc = "Fred" adesc = "Fred" noun = 'Fred'
   ldest = "Fred is a rather ordinary guy. "
   haircolor = 'black'
   location = midroom;


tom: Actor
   sdesc = "Tom" thedesc = "Tom" adesc = "Tom" noun = 'Tom'
   ldest = "Tom is a rather ordinary guy. "
   haircolor = 'blond'
   location = startroom;

tom1: aaFactoid
   aaTheFact = "Tom is a collector."
   aaMyFact = "I am a collector."
   aaFactLoc = tom;

/* Only Tom knows this factoid so it doesn't need a TheFact. */
tom2: aaFactoid
   aaMyFact = "I collect rocks."
   aaActorsKnowing = [tom]
   aaFactLoc = tom;
