/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class GameFileParser {
    private int pos = 0;
    private int xor_seed = 63;
    private int xor_inc = 64;
    private boolean encrypt_mode = true;

    public GameState read(InputStream inputStream) throws IOException, HaltTurnException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        GameState gameState = new GameState();
        String string = this.read_to_char(bufferedInputStream, '\u0000');
        if (!"TADS2 bin\n\r\u001a".equals(string)) {
            Jetty.out.print_error("This does not appear to be a TADS game file", 0);
            return null;
        }
        String string2 = this.read_to_char(bufferedInputStream, '\u0000');
        if (!"v2.2.0".equals(string2)) {
            Jetty.out.print_error("Sorry, Jetty can only play games compiled with the most recent version (v2.2.0) of TADS", 0);
            return null;
        }
        int n = this.read_16(bufferedInputStream);
        this.encrypt_mode = (n & 8) != 0;
        String string3 = this.read_to_char(bufferedInputStream, '\u0000');
        gameState.set_version(string2);
        gameState.set_flags(n);
        gameState.set_timestamp(string3);
        while (true) {
            int n2 = this.read_8(bufferedInputStream);
            String string4 = new String(this.read_amount(bufferedInputStream, n2));
            int n3 = this.read_32signed(bufferedInputStream);
            int n4 = n3 - this.pos + 1;
            Jetty.out.print_error("Reading block: " + string4, 2);
            if (string4.equals("XSI")) {
                this.proc_XSI_block(bufferedInputStream, n4, gameState);
                continue;
            }
            if (string4.equals("VOC")) {
                this.proc_VOC_block(bufferedInputStream, n4, gameState);
                continue;
            }
            if (string4.equals("CMPD")) {
                this.proc_CMPD_block(bufferedInputStream, n4, gameState);
                continue;
            }
            if (string4.equals("SPECWORD")) {
                this.proc_SPECWORD_block(bufferedInputStream, n4, gameState);
                continue;
            }
            if (string4.equals("INH")) {
                this.proc_INH_block(bufferedInputStream, n4, gameState);
                continue;
            }
            if (string4.equals("REQ")) {
                this.proc_REQ_block(bufferedInputStream, n4, gameState);
                continue;
            }
            if (string4.equals("PREINIT")) {
                this.proc_PREINIT_block(bufferedInputStream, n4, gameState);
                continue;
            }
            if (string4.equals("FMTSTR")) {
                this.proc_FMTSTR_block(bufferedInputStream, n4, gameState);
                continue;
            }
            if (string4.equals("OBJ")) {
                this.proc_OBJ_block(bufferedInputStream, n4, gameState);
                continue;
            }
            if (string4.equals("$EOF")) break;
            if (string4.equals("XFCN") || string4.equals("FST") || string4.equals("HTMLRES")) {
                Jetty.out.print_error("Ignoring " + string4 + " block", 2);
                this.read_amount(bufferedInputStream, n4);
                continue;
            }
            if (string4.equals("PREINIT") || string4.equals("SYMTAB") || string4.equals("SRC") || string4.equals("SRC2")) {
                Jetty.out.print_error("Skipping debug-only block type: " + string4, 2);
                this.read_amount(bufferedInputStream, n4);
                continue;
            }
            Jetty.out.print_error("Unknown block type: " + string4, 2);
            this.read_amount(bufferedInputStream, n4);
        }
        Jetty.out.print_error("Reached EOF. Exiting.", 2);
        return gameState;
    }

    private void proc_XSI_block(InputStream inputStream, int n, GameState gameState) throws IOException {
        this.xor_seed = this.read_8(inputStream);
        this.xor_inc = this.read_8(inputStream);
    }

    private void proc_PREINIT_block(InputStream inputStream, int n, GameState gameState) throws IOException {
        gameState.set_preinit(this.read_16signed(inputStream));
    }

    private void proc_VOC_block(InputStream inputStream, int n, GameState gameState) throws IOException, HaltTurnException {
        while (n > 0) {
            int n2 = this.read_16(inputStream);
            int n3 = this.read_16(inputStream);
            int n4 = this.read_16(inputStream);
            int n5 = this.read_16(inputStream);
            int n6 = this.read_16(inputStream);
            String string = new String(this.encrypt(this.read_amount(inputStream, n2 + n3)));
            String string2 = null;
            if (n3 > 0) {
                string2 = string.substring(n2);
                string = string.substring(0, n2);
            }
            n -= 10 + n2 + n3;
            gameState.add_vocab(n5, n4, n6, string, string2);
        }
    }

    private void proc_CMPD_block(InputStream inputStream, int n, GameState gameState) throws IOException {
        int n2;
        int n3 = this.read_16(inputStream);
        byte[] byArray = this.encrypt(this.read_amount(inputStream, n3));
        for (int i = 0; i < byArray.length; i += n2 + 2) {
            n2 = GameFileParser.read_16(byArray, i) - 2;
            String string = new String(byArray, i + 2, n2);
            i += n2 + 2;
            n2 = GameFileParser.read_16(byArray, i) - 2;
            String string2 = new String(byArray, i + 2, n2);
            i += n2 + 2;
            n2 = GameFileParser.read_16(byArray, i) - 2;
            String string3 = new String(byArray, i + 2, n2);
            gameState.add_compound_word(string, string2, string3);
        }
    }

    private void proc_SPECWORD_block(InputStream inputStream, int n, GameState gameState) throws IOException {
        int n2;
        int n3 = this.read_16(inputStream);
        byte[] byArray = this.encrypt(this.read_amount(inputStream, n3));
        for (int i = 0; i < byArray.length; i += n2 + 2) {
            char c = (char)GameFileParser.read_8(byArray, i);
            n2 = GameFileParser.read_8(byArray, i + 1);
            String string = new String(byArray, i + 2, n2);
            gameState.add_specword(c, string);
        }
    }

    private void proc_INH_block(InputStream inputStream, int n, GameState gameState) throws IOException {
        while (n > 0) {
            int n2 = this.read_8(inputStream);
            int n3 = this.read_16(inputStream);
            int n4 = this.read_16signed(inputStream);
            int n5 = this.read_16signed(inputStream);
            int n6 = this.read_16(inputStream);
            int[] nArray = new int[n6];
            for (int i = 0; i < n6; ++i) {
                nArray[i] = this.read_16(inputStream);
            }
            n -= 9 + n6 * 2;
            gameState.add_inheritance(n3, n4, n5, n2, nArray);
        }
    }

    private void proc_REQ_block(InputStream inputStream, int n, GameState gameState) throws IOException {
        int[] nArray = new int[25];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        byte[] byArray = this.read_amount(inputStream, n);
        for (int i = 0; i < nArray.length && i < n / 2; ++i) {
            nArray[i] = GameFileParser.read_16signed(byArray, i * 2);
        }
        gameState.set_required(nArray);
    }

    private void proc_FMTSTR_block(InputStream inputStream, int n, GameState gameState) throws IOException {
        int n2;
        int n3 = this.read_16(inputStream);
        byte[] byArray = this.encrypt(this.read_amount(inputStream, n3));
        for (int i = 0; i < byArray.length; i += n2 + 4) {
            int n4 = GameFileParser.read_16(byArray, i);
            n2 = GameFileParser.read_16(byArray, i + 2) - 2;
            String string = new String(byArray, i + 4, n2);
            gameState.add_fmtstr(string, n4);
        }
    }

    private void proc_OBJ_block(InputStream inputStream, int n, GameState gameState) throws IOException {
        while (n > 0) {
            byte[] byArray;
            int n2;
            int n3;
            int n4 = this.read_8(inputStream);
            int n5 = this.read_16signed(inputStream);
            n -= 3;
            if (n4 == 1) {
                n3 = this.read_16(inputStream);
                n2 = this.read_16(inputStream);
                n -= 4 + n2;
                byArray = this.encrypt(this.read_amount(inputStream, n2));
                gameState.add_function_object(n5, byArray);
                continue;
            }
            if (n4 == 2) {
                n3 = this.read_16(inputStream);
                n2 = this.read_16(inputStream);
                n -= 4 + n2;
                byArray = this.encrypt(this.read_amount(inputStream, n2));
                int n6 = 0;
                int n7 = GameFileParser.read_16(byArray, n6);
                int n8 = GameFileParser.read_16(byArray, n6 + 2);
                int n9 = GameFileParser.read_16(byArray, n6 + 4);
                int n10 = GameFileParser.read_16(byArray, n6 + 6);
                int n11 = GameFileParser.read_16(byArray, n6 + 8);
                int n12 = GameFileParser.read_16(byArray, n6 + 12);
                int n13 = GameFileParser.read_16(byArray, n6 + 10);
                n6 += 14;
                int[] nArray = new int[n9];
                int n14 = 0;
                while (n14 < n9) {
                    nArray[n14] = GameFileParser.read_16(byArray, n6);
                    ++n14;
                    n6 += 2;
                }
                if ((n8 & 2) != 0) {
                    n6 = GameFileParser.read_16(byArray, n6);
                }
                TProperty[] tPropertyArray = new TProperty[n10];
                int n15 = 0;
                while (n6 < byArray.length) {
                    int n16 = GameFileParser.read_16(byArray, n6);
                    int n17 = GameFileParser.read_8(byArray, n6 + 2);
                    int n18 = GameFileParser.read_16(byArray, n6 + 3);
                    int n19 = GameFileParser.read_8(byArray, n6 + 5);
                    n6 += 6;
                    if (n17 == 7 || n17 == 3 || n17 == 9) {
                        n6 += 2;
                        n18 -= 2;
                    }
                    byte[] byArray2 = new byte[n18];
                    System.arraycopy(byArray, n6, byArray2, 0, byArray2.length);
                    n6 += n18;
                    TValue tValue = new TValue(n17, byArray2);
                    tPropertyArray[n15++] = new TProperty(n16, tValue);
                }
                gameState.add_object_object(n5, n8, nArray, tPropertyArray);
                continue;
            }
            if (n4 == 7 || n4 == 8) {
                n3 = this.read_16(inputStream);
                this.read_amount(inputStream, n3);
                n -= 2 + n3;
                continue;
            }
            if (n4 == 10) {
                n3 = this.read_8(inputStream);
                this.read_amount(inputStream, n3);
                n -= 1 + n3;
                continue;
            }
            Jetty.out.print_error("Unknown object block: " + n4, 1);
        }
    }

    private byte[] encrypt(byte[] byArray) {
        if (!this.encrypt_mode) {
            return byArray;
        }
        int n = this.xor_seed;
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = n2++;
            byArray[n3] = (byte)(byArray[n3] ^ n);
            n += this.xor_inc;
        }
        return byArray;
    }

    private String read_to_char(InputStream inputStream, char c) throws IOException {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c2 = (char)inputStream.read()) != c) {
            stringBuffer.append(c2);
        }
        this.pos += stringBuffer.length() + 1;
        return stringBuffer.toString();
    }

    private byte[] read_amount(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; i += n2) {
            n2 = inputStream.read(byArray, i, byArray.length - i);
            if (n2 != -1) continue;
            throw new IOException("Premature end of file reached");
        }
        this.pos += n;
        return byArray;
    }

    private int read_8(InputStream inputStream) throws IOException {
        ++this.pos;
        return inputStream.read();
    }

    private int read_16(InputStream inputStream) throws IOException {
        this.pos += 2;
        int n = inputStream.read();
        int n2 = inputStream.read();
        return (n2 << 8) + n;
    }

    private int read_16signed(InputStream inputStream) throws IOException {
        this.pos += 2;
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = (n2 << 8) + n;
        return n3 < 32768 ? n3 : n3 - 65536;
    }

    private int read_32(InputStream inputStream) throws IOException {
        this.pos += 4;
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    private int read_32signed(InputStream inputStream) throws IOException {
        this.pos += 4;
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        int n5 = (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        return n5 < Integer.MIN_VALUE ? n5 : n5 - 1;
    }

    public static int read_8(byte[] byArray, int n) {
        return byArray[n];
    }

    public static int read_16(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (n3 << 8) + n2;
    }

    public static int read_16signed(byte[] byArray, int n) {
        int n2 = byArray[n + 1] & 0xFF;
        int n3 = byArray[n] & 0xFF;
        int n4 = (n2 << 8) + n3;
        return n4 < 32768 ? n4 : n4 - 65536;
    }

    public static int read_32(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        int n4 = byArray[n + 2] & 0xFF;
        int n5 = byArray[n + 3] & 0xFF;
        return (n5 << 24) + (n4 << 16) + (n3 << 8) + n2;
    }

    public static int read_32signed(byte[] byArray, int n) {
        int n2 = byArray[n + 3] & 0xFF;
        int n3 = byArray[n + 2] & 0xFF;
        int n4 = byArray[n + 1] & 0xFF;
        int n5 = byArray[n] & 0xFF;
        int n6 = (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
        return (long)n6 < 0x80000000L ? n6 : (int)((long)n6 - 0x100000000L);
    }
}

