/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class VocabWord {
    public static final int VERB = 2;
    public static final int NOUN = 3;
    public static final int ADJECTIVE = 4;
    public static final int PREPOSITION = 5;
    public static final int ARTICLE = 6;
    public static final int PLURAL = 7;
    public static final int UNKNOWN = -1;
    public static final String SPECWORD_AND = ",";
    public static final String SPECWORD_THEN = ".";
    public static final String SPECWORD_OF = "O";
    public static final String SPECWORD_ALL = "A";
    public static final String SPECWORD_BOTH = "B";
    public static final String SPECWORD_IT = "I";
    public static final String SPECWORD_HIM = "M";
    public static final String SPECWORD_ONE = "N";
    public static final String SPECWORD_ONES = "P";
    public static final String SPECWORD_HER = "R";
    public static final String SPECWORD_THEM = "T";
    public static final String SPECWORD_BUT = "X";
    public static final String SPECWORD_ANY = "Y";
    String _word;
    String[] _word2s;
    int[] _types;
    int[][] _objects;
    String _specword;
    int _number_value;
    boolean _is_string;
    boolean _truncated;

    public VocabWord(String string, int n) {
        this(string, null, -1, n);
    }

    public VocabWord(String string, String string2, int n, int n2) {
        this._word = string;
        this._word2s = new String[1];
        this._word2s[0] = string2;
        this._types = new int[1];
        this._types[0] = n2;
        if (n != -1) {
            this._objects = new int[1][1];
            this._objects[0][0] = n;
        } else {
            this._objects = new int[1][0];
        }
        try {
            this._number_value = Integer.parseInt(this._word);
        }
        catch (NumberFormatException numberFormatException) {
            this._number_value = Integer.MIN_VALUE;
        }
    }

    public String get_word() {
        return this._word;
    }

    public void set_word(String string) {
        this._word = string;
    }

    public boolean is_specword() {
        return this._specword != null;
    }

    public boolean is_specword(String string) {
        return this._specword != null && this._specword.equals(string);
    }

    public boolean is_unknown() {
        return this._types[0] == -1 && !this.is_specword();
    }

    public String get_specword() {
        return this._specword;
    }

    public boolean is_number() {
        return this._number_value != Integer.MIN_VALUE;
    }

    public int get_number() {
        return this._number_value;
    }

    public void is_string(boolean bl) {
        this._is_string = bl;
    }

    public boolean is_string() {
        return this._is_string;
    }

    public void truncated(boolean bl) {
        this._truncated = bl;
    }

    public boolean is_truncated() {
        return this._truncated;
    }

    public void set_specword(String string) {
        this._specword = string;
    }

    public boolean has_objects(int n) {
        return this.get_objects(n, null) != null;
    }

    public boolean has_objects(int n, String string) {
        return this.get_objects(n, string) != null;
    }

    public int get_first_object(int n, String string) throws HaltTurnException {
        int[] nArray = this.get_objects(n, string);
        if (nArray != null && nArray.length > 0) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (Jetty.state.lookup_object(nArray[i]).is_class()) continue;
                return nArray[i];
            }
        }
        return -1;
    }

    public int[] get_objects(int n, String string) {
        for (int i = 0; i < this._types.length; ++i) {
            if (this._types[i] != n || (this._word2s[i] != null || string != null) && (this._word2s[i] == null || !this._word2s[i].equals(string))) continue;
            return this._objects[i];
        }
        return null;
    }

    public boolean get_object(int n, Vector vector, Vector vector2) {
        boolean bl = false;
        for (int i = 0; i < this._objects.length; ++i) {
            for (int j = 0; j < this._objects[i].length; ++j) {
                if (this._objects[i][j] != n) continue;
                bl = true;
                vector.addElement(new Integer(this._types[i]));
                vector2.addElement(this._word2s[i]);
            }
        }
        return bl;
    }

    public void add_obj(String string, int n, int n2) {
        for (int i = 0; i < this._types.length; ++i) {
            if (this._types[i] == n2 && (this._word2s[i] == null ? string == null : this._word2s[i].equals(string))) {
                for (int j = 0; j < this._objects[i].length; ++j) {
                    if (this._objects[i][j] != n) continue;
                    return;
                }
                int[] nArray = new int[this._objects[i].length + 1];
                System.arraycopy(this._objects[i], 0, nArray, 0, this._objects[i].length);
                nArray[this._objects[i].length] = n;
                this._objects[i] = nArray;
                return;
            }
            if (this._types[i] != -1) continue;
            this._word2s[i] = string;
            this._types[i] = n2;
            int[] nArray = new int[]{n};
            this._objects[i] = nArray;
            return;
        }
        int[] nArray = new int[this._types.length + 1];
        System.arraycopy(this._types, 0, nArray, 0, this._types.length);
        nArray[this._types.length] = n2;
        this._types = nArray;
        String[] stringArray = new String[this._word2s.length + 1];
        System.arraycopy(this._word2s, 0, stringArray, 0, this._word2s.length);
        stringArray[this._word2s.length] = string;
        this._word2s = stringArray;
        int[][] nArrayArray = new int[this._objects.length + 1][];
        System.arraycopy(this._objects, 0, nArrayArray, 0, this._objects.length);
        nArrayArray[this._objects.length] = new int[1];
        nArrayArray[this._objects.length][0] = n;
        this._objects = nArrayArray;
    }

    public void remove_obj(String string, int n, int n2) {
        for (int i = 0; i < this._types.length; ++i) {
            if (this._types[i] != n2 || !(this._word2s[i] == null ? string == null : this._word2s[i].equals(string))) continue;
            int n3 = 0;
            while (i < this._objects[i].length) {
                if (this._objects[i][n3] == n) {
                    this._objects[i][n3] = this._objects[i][this._objects[i].length - 1];
                    int[] nArray = new int[this._objects[i].length - 1];
                    System.arraycopy(this._objects[i], 0, nArray, 0, nArray.length);
                    this._objects[i] = nArray;
                    return;
                }
                ++n3;
            }
        }
    }

    public int get_flags() {
        int n = 0;
        for (int i = 0; i < Constants.vocab_prop_flags.length; ++i) {
            if (this.get_objects(Constants.vocab_prop_flags[i][0], null) == null) continue;
            n |= Constants.vocab_prop_flags[i][1];
        }
        if (this.is_unknown()) {
            n |= 0x80;
        }
        if (this.is_specword()) {
            n |= 0x20;
        }
        return n;
    }

    public VocabWord do_clone() {
        VocabWord vocabWord = new VocabWord(this._word, null, -1, -1);
        vocabWord._word2s = new String[this._word2s.length];
        System.arraycopy(this._word2s, 0, vocabWord._word2s, 0, this._word2s.length);
        vocabWord._types = new int[this._types.length];
        System.arraycopy(this._types, 0, vocabWord._types, 0, this._types.length);
        vocabWord._objects = new int[this._objects.length][];
        for (int i = 0; i < vocabWord._objects.length; ++i) {
            vocabWord._objects[i] = new int[this._objects[i].length];
            System.arraycopy(this._objects[i], 0, vocabWord._objects[i], 0, this._objects[i].length);
        }
        vocabWord._specword = this._specword;
        vocabWord._number_value = this._number_value;
        vocabWord._is_string = this._is_string;
        vocabWord._truncated = this._truncated;
        return vocabWord;
    }

    public void merge(VocabWord vocabWord) {
        for (int i = 0; i < vocabWord._objects.length; ++i) {
            for (int j = 0; j < vocabWord._objects[i].length; ++j) {
                this.add_obj(vocabWord._word2s[i], vocabWord._objects[i][j], vocabWord._types[i]);
            }
        }
    }

    public String toString() {
        String[] stringArray = new String[]{"?", "??", "verb", "noun", "adj", "prep", "art", "plu"};
        String string = this._word + " (";
        if (this.is_truncated()) {
            string = string + "TRUNCATED ";
        }
        if (this.is_specword()) {
            string = string + "SPECIAL=" + this._specword + " ";
        }
        if (this._types[0] == -1) {
            string = string + "UNKNOWN";
        } else {
            for (int i = 0; i < this._types.length; ++i) {
                string = string + (i != 0 ? " " : "") + "[" + stringArray[this._types[i]];
                if (this._word2s[i] != null) {
                    string = string + " w/'" + this._word2s[i] + "'";
                }
                string = string + ":";
                for (int j = 0; j < this._objects[i].length; ++j) {
                    string = string + " " + this._objects[i][j];
                }
                string = string + "]";
            }
        }
        return string + ")";
    }
}

