{}
{( C ) Copyright 1994 By Kimmo Fredriksson.}
{}
{You may use this unit freely in your programs, and distribute them,}
{but you are *NOT* allowed to distribute any modified form of this}
{unit, not source, nor the compiled TPU, TPP or whatsoever, *without*}
{my permission! In it's original form, this source is freeware.}
{}
{Internet email: Kimmo.Fredriksson@Helsinki.FI}
{}

{}
{If you want the Turbo Pascal and assembler source code for the TxtMap}
{Unit, register today. Send $20 (or 100 Fmk) to me, and I'll send all}
{the source to you.}
{}
{Kimmo Fredriksson}
{Silvontie 38}
{37740 Haukila}
{FINLAND}
{}

{}
{( C ) Copyright 1994 By Kimmo Fredriksson.}
{}
{Labyrinth-3D Global Data Unit}
{}

{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+}

UNIT	L3DDATA;

	INTERFACE

USES	TxtMap,
	VGAPal;

CONST   Copyright 	= '(C) 1994 By Kimmo Fredriksson';

	Version		= 'Version 1.03';

	RB              = 64;		{ Red Base, --> 32 red values }
	GB              = RB + 32;	{ Green Base }
	BB              = GB + 32;	{ Blue Base }
	WB		= BB + 64;	{ White Base }

	HelpBac		= BB + 16;	        { Help background... }
	HelpBor		= BB + 32;              { ...border... }
	HelpSta		= WB + 63;	        { ...status line... }
	HelpTxt		= 16 * 0 + 4 * 3 + 3;	{ ...and text }

	ErrorBac	= RB + 16;	{ ditto }
	ErrorBor	= RB + 31;
	ErrorTxt        = WB + 63;

	DialogBac	= RB + 16;      { ditto }
	DialogBor	= RB + 24;
	DialogTxt	= RB + 31;

	MessageBac	= GB + 16;      { ditto }
	MessageBor	= GB + 24;
	MessageTxt	= GB + 31;

	MenuBac		= BB + 48;	{ ditto }
	MenuBor         = BB + 63;
	MenuSta         = GB + 31;
	MenuTxt         = WB + 63;

	CeCo		: Byte	= BB + 32;
	FlCo		: Byte	= GB + 16;

	BaCo		= WB + 32;
	BoCB		= WB + 63;
	BoCD		= WB + 16;

	MaxTurn		= 16;
	MinTurn	 	= 1;
	MaxMove		= WorldXZ DIV 2;
	MinMove		= 1;
	MoveSpeed	: Integer = MaxMove DIV 1;
	TurnSpeed	: Integer = MaxTurn DIV 2;

	CreatureSpeed	= MaxMove DIV 4;
	WormSpeed	= 3 * MaxMove DIV 4;

	BRICK0		: Byte = 0; { indexes to TxtMaps-array }
	BRICK1		: Byte = 0;
	MARBLE0		: Byte = 0;
	MARBLE1		: Byte = 0;
	PLASMA0		: Byte = 0;
	PLASMA1		: Byte = 0;
	MANDEL3D	: Byte = 0;
	HAMILTON	: Byte = 0;
	CLOCKBG		: Byte = 0;
	BRICK2		: Byte = 0;
	BRICK3		: Byte = 0;
	B3D		: Byte = 0;
	GHOST		: Byte = 0;

	{ corner co'ordinates of the walls, and corresponding texture indexes }

	PolyWallX0	: ARRAY[ 0..81 ] OF Integer =

			  ( 0,0,8,8,10,10,0,0,12,12,14,14,0,0,2,2,6,6,2,2,
			    8,8,14,14,10,10,4,4,0,0,20,20,24,24,22,22,28,
			    28,30,30,34,34,30,30,38,38,30,30,32,32,38,38,
			    32,32,30,30,28,28,26,26,38,38,36,36,24,24,23,
			    23,16,16,28,28,30,30,34,34,38,38,18,18,16,16 );

	PolyWallZ0	: ARRAY[ 0..81 ] OF Integer =

			  ( 0,18,18,12,12,20,20,26,26,24,24,28,28,40,40,
			    36,36,34,34,32,32,30,30,32,32,38,38,42,42,52,
			    52,46,46,48,48,52,52,44,44,46,46,48,48,52,52,
			    42,42,36,36,40,40,24,24,34,34,24,24,34,34,22,
			    22,16,16,20,20,24,24,20,20,18,18,14,14,18,18,
			    14,14,0,0,6,6,0 );

	PolyWallTI0	: ARRAY[ 0..81 ] OF Byte =

			  ( 0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
			    0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
			    0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
			    0,1,0,1,0,1,0,1,0,1 );

	PolyWallX1	: ARRAY[ 0..15 ] OF Integer =

			  ( 6,18,18,16,16,20,20,26,26,28,28,16,16,14,14,6 );

	PolyWallZ1	: ARRAY[ 0..15 ] OF Integer =

			  ( 40,40,32,32,30,30,40,40,36,36,42,42,50,50,42,42 );

	PolyWallTI1	: ARRAY[ 0..15 ] OF Byte =

			  ( 5,4,5,4,5,4,5,4,5,4,5,4,5,4,5,4 );

	PolyWallX2	: ARRAY[ 0..5 ] OF Integer = ( 12,12,18,18,14,14 );

	PolyWallZ2	: ARRAY[ 0..5 ] OF Integer = ( 22,12,12,16,16,22 );

	PolyWallTI2	: ARRAY[ 0..5 ] OF Byte = ( 5,4,5,4,5,4 );

	WaitVRT		: Boolean = FALSE; { Wait VGAs Vertical ReTrace }

	{ aren't these self-documenting (I like to write the code, not docs) }

	MaxCreatures	= 8;
	MaxWorms	= 4;
	MaxWormLen	= 16;

	NumOfCreats	: Integer = 0;
	NumOfWorms	: Integer = 0;

	FrameCnt        : LongInt = 0;

	STime   	: LongInt = 0;	{ don't bother these }
	ETime   	: LongInt = 0;
	OTime   	: LongInt = 0;

	EndOfGame       : Boolean = FALSE;

TYPE	CreatureTYPE	= RECORD
			    TxtRecPtr	: TxtObjPtr; { pointer to TxtObj }
			    XP		: LongInt;
			    ZP		: LongInt;
			    MoveType	: Byte;
			  END;

	WormTYPE	= RECORD
			    XP		: LongInt;
			    ZP		: LongInt;
			    YAng        : Integer; { movement direction }
			    YAngInc	: Integer; { delta of movement }
			    Len		: Integer;
			    TxtRecPtr	: ARRAY[ 0..MaxWormLen - 1 ] OF TxtObjPtr;
			  END;

	CreaturePtr	= ^CreatureTYPE;
	WormPtr		= ^WormTYPE;

	CreatureArr	= ARRAY[ 0..MaxCreatures - 1 ] OF CreaturePtr;
	WormArr		= ARRAY[ 0..MaxWorms - 1 ] OF WormPtr;

VAR	Pal		: VGAPalTYPE;

	MouseInstalled	: Boolean;

	Creatures	: CreatureArr;
	Worms		: WormArr;

	Clock   	: LongInt ABSOLUTE $0040:$006C;

	ClockHands	: RECORD
			    Secs   : Word;
			    HX, HY : Word;
			    MX, MY : Word;
			    SX, SY : Word;
			  END;


	IMPLEMENTATION


END.
