@REM    CRSPR (Create Sprites) - a batch by Petri Hassinen 11th June, 1995

@ECHO OFF
IF (%5) == () GOTO howto
IF EXIST %5 GOTO texists

REM Processing starts here...

ECHO CRSPR: Initiating PPFIX sequence...
papa ppfix %1 -raw
IF ERRORLEVEL 1 goto error2
ECHO CRSPR: Deleting unnecessary .PAL files...
del *.pal
ECHO CRSPR: Initiating FILECROP sequence...
papa filecrop *.raw /%2
IF ERRORLEVEL 1 goto error
ECHO CRSPR: Deleting unnecessary .RAW files...
del *.raw
ECHO CRSPR: Initiating BOXCR sequence...
papa /'N' boxcr *.trn /%3 /%4 /1
IF ERRORLEVEL 1 goto error
ECHO CRSPR: Deleting unnecessary .TRN files...
del *.trn
ECHO CRSPR: Compiling the sprite data components...
copy /B *.raw %5
ECHO CRSPR: Deleting unnecessary .RAW files...
del *.raw
ECHO.
ECHO CRSPR: Everything OK!
ECHO.
GOTO end

:howto
ECHO Usage :  CRSPR  still_files  starting_address  xsize  ysize  sprite_name
ECHO.
ECHO 'still_files' are the original picture files from which the resulting sprite
ECHO data is generated. You can use wildcards (*, ?) in this argument.
ECHO 'starting_address' specifies the sprite's starting position in the picture.
ECHO 'xsize' and 'ysize' tell the size of the sprite in pixels.
ECHO 'sprite_name' is the name you want to give to your sprite data.
ECHO.
ECHO See also CRSPR.LBM (e.g. PPFIX crspr.lbm) for more help on how to calculate
ECHO 'starting_address'.
ECHO.
ECHO NOTE! 
ECHO You should use this batch only in a temporary directory where there are no 
ECHO files with extensions .RAW, .PAL, .TRN. This is because CRSPR deletes 
ECHO intermediate files with these extensions to save disk space. If you have no
ECHO such files you can use this batch where you like.
ECHO.
ECHO This also means that your original files (still_files) from which the sprites 
ECHO are generated should be LBM files. If they are not, you can convert them into
ECHO LBMs prior to generating sprites by typing:
ECHO PAPA /'Y' PPFIX *.raw /lbm
ECHO.
GOTO end

:texists
ECHO CRSPR: Target already exists, please specify a new target with another name.
ECHO.
GOTO end

:error
ECHO CRSPR: Deleting temporary files (*.RAW, *.TRN)...
del *.raw
del *.trn
:error2
ECHO CRSPR: Error detected, batch terminated!
ECHO.

:end

REM End of CRSPR.BAT
