.imd PC2.h
:userdoc.
:title.PC/2 Help Program
:body.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help with F1, the mouse, the smarticon or the keyboard.            *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_HELP..PC/2 Help for Help
:lines align=center.
:color fc=red.
PC/2 - Program Commander/2 Version 1.70
for IBM OS/2 2.x Presentation Manager
Copyright (C) by Stangl Roman 06, 1994
:color fc=default.
:elines.
:p.Please select one of the following topics for further information:
:ul compact.
:li.:link reftype=hd res=&ID_ABOUTDIALOG..About the utility PC/2:elink.
:li.:link reftype=hd res=&ID_INSTALLATIONHELP..Installing PC/2:elink.
:li.:link reftype=hd res=&ID_GENERALHELP..Using PC/2 as a WPS addon:elink.
:li.:link reftype=hd res=&ID_CONCEPTSHELP..Concepts of the Popup-Menu:elink.
:li.:link reftype=hd res=&ID_USINGHELP..Starting a Program from PC/2:elink.
:li.:link reftype=hd res=&ID_CONFIGDIALOG..Setup the Popup-Menu:elink.
:ul compact.
:li.:link reftype=hd res=&MIID_MENUDIALOG..Adding a Submenu:elink.
:li.:link reftype=hd res=&PIID_PROGRAMDIALOG..Adding a Program:elink.
:li.:link reftype=hd res=&MDID_CONTROLDIALOG..Adding a Popup Menu controls:elink.
:li.:link reftype=hd res=&RDID_RESORTDIALOG..Resorting a (Sub)menu:elink.
:li.:link reftype=hd res=&SUID_STARTUPDIALOG..Run-time parameters:elink.
:eul.
:li.:link reftype=hd res=&ID_DESKTOPDIALOG..Setup the Desktop:elink.
:li.:link reftype=hd res=&ID_OVERVIEWHELP..PC/2's Desktop overview window:elink.
:li.:link reftype=hd res=&ID_ERRORHELP..Error messages:elink.
:eul.
:p.:link reftype=hd res=&ID_HELP..<Backward>:elink.
                                :link reftype=hd res=&ID_ABOUTDIALOG..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the About PC/2 dialog box.                               *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_ABOUTDIALOG..Help for About PC/2
:lines align=center.
:color fc=red.
PC/2 - Program Commander/2 Version 1.70
for IBM OS/2 2.x Presentation Manager
Copyright (C) by Stangl Roman 06, 1994
:color fc=default.
:elines.
:p.E-Mail:
:ul compact.
:li.InterNet: RSTANGL@VNET.IBM.COM
:li.FidoNet: Roman Stangl @ 2&colon.310/14 LA BAMBA BBS Tel.: (Int. Code +43 +1 +6898971)
:li.FidoNet: Roman Stangl @ IBM Austria National Support BBS Tel.: (Int. Code +43 +1 +21145-6600)
:li.IBM VNET: 61821799 at VIEVMA
:eul.
:p.This program is classified as Freeware. Under the copyright, you are allowed and
encouraged to freely use, distribute or modify this program under the following
conditions:
:ul compact.
:li.The complete source code and all executables are included. This rule also applies
for any modifications you made.
:li.You may only charge for the costs of duplicating, :hp8.distribution on InterNet, FidoNet
or similar is preferred:ehp8. therefor. This program must not be sold by immoral "Public
Domain &amp. ShareWare" dealers that charge a price far ahead of the actual duplication costs.
:li.:hp8.Any:ehp8. commercial use is prohibited without contacting me prior, except
for incorporating the idea/code in any future release of OS/2 by IBM, however this
clause doesn't apply for any private use.
:li.You don't want to port this utility to MS Windows or Windows NT (Nice Try).
:eul.
:p.You are encouraged to upload this utility to your favourite file-server or
BBS. Please ensure that no file is missing, if you change the archive to
a different compression scheme.
:p.If you find this program useful and want to honor about ten weeks of work writing
this utility, you are welcome to send me a small fee of about 50 to 150 Austrian
Schilling (about 5 to 15 dollar) to my home address. Of course you don't need
to pay again, if a new release of PC/2 comes out.
Please send any donations in cash, because it makes some troubles to exchange
money orders or similar in Austria!
:p.Any suggestions are of course welcome too.
Because of the Freeware status of PC/2 I am :hp8.not:ehp8. going to send new
versions or anything else by mail (which is likely to become a never ending story),
however I try my best to do support via E-Mail!
:p.Thanks to all those, who sent me proposals and bug reports to improve this
utility!
Special thanks to Mario Semo, Carrick von Schoultz and Markus Hof, Roman Fischer,
Alex Stewart, Ingo Pflanz, Rolf Knebel and Michael Wakunda who gave me advices
and/or source code to modify for use within PC/2 and/or other support.
:p.My home address is:
:sl compact.
:li.    Roman Stangl
:li.    Strebersdorferstrasse 46
:li.    A-2103  Langenzersdorf, Austria
:esl.
:p.:link reftype=hd res=&ID_HELP..<Backward>:elink.
                                :link reftype=hd res=&ID_INSTALLATIONHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help for PC/2 installation.                                        *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_INSTALLATIONHELP..Installing PC/2
:p.You have obviously started PC/2 once, because you are reading this help panel.
The installation is just straight forward with the REXX script that installs PC/2,
however there are some points to notice:
:ul.
:li.The installation installed an icon on the Desktop and started the help panels
of PC/2. To ensure that OS/2 starts PC/2 automatically the next time you boot your
system, you must start PC/2 again (you then can notice that the background behind
the icon changes). If you have added :hp4.SET RESTARTOBJECTS=STARTUPFOLDERSONLY:ehp4.
in your :hp8.CONFIG.SYS:ehp8. then you must also add a shadow of PC/2 to your startup
folder to ensure PC/2 is started the next time you boot OS/2.
:li.PC/2 requires the file :hp8.PC2HOOK.DLL:ehp8. to be accessible. PC/2 tries
to find this file either in the current directory, or in a path
that is included in the environment variable :hp4.LIBPATH:ehp4.. PC/2 will
not be able to run, if :hp8.PC2HOOK.DLL:ehp8. can't be loaded.
The file :hp8.PC2.HLP:ehp8. may be either accessible in the directory,
where PC/2 is started from, or in a path that is included in the environment
variable :hp4.HELP:ehp4.. If you have problems running PC/2, ensure,
that the working directory of PC/2 is accessible by these variables
in your :hp8.CONFIG.SYS:ehp8..
:li.The installation assumes that you are using the default profile :hp8.Pc2.cfg:ehp8.
containing a standard pre-defined Popup-Menu. If you want to use an other Popup-Menu,
you have to restart PC/2 and add your preferred profile as a commandline option.
Click to the next help panel to get more information about commandline parameters.
You may also use your favourite editor, to import one profile into another, but
you have to ensure, that you don't violate the syntax rules of the profile.
:li.PC/2 looks for its initialization file :hp8.PC2.INI:ehp8. in the directory
where PC/2 was started from.
:li.You can only run one copy of PC/2 concurrently.
:li.If you select a DOS-Program to be started via PC/2, the time-slice of their
sessions is optimized (the DOS-Settings are modified to
:hp4.IDLE_SECONDS=5 IDLE_SENSITIVITY=100:ehp4.) to get a better performance. This
is useful for most DOS games.
:li.You may use PC/2 with or without the WPS installed, you may even use PC/2 as
a replacement for the WPS. To do so you must install PC/2 first. Then you have
to ensure that :hp8.PC2HOOK.DLL:ehp8. is accessible by PC/2. 
Do this by adding the path you installed PC/2 into, to the :hp4.LIBPATH:ehp4.
environment variable in your :hp8.CONFIG.SYS:ehp8..
PC/2 won't run as a WPS replacement if :hp8.PC2HOOK.DLL:ehp8. is not in a path
pointed to by the :hp4.LIBPATH:ehp4. environment variable (this requirement is
new for Version 1.70).
You also have to ensure that :hp8.PC2.HLP:ehp8. is accessible in the PC/2 directory or
in a path pointed to by the :hp4.HELP:ehp4. environment
variable in your :hp8.CONFIG.SYS:ehp8. file. Then replace the statement 
:hp8.SET RUNWORKPLACE=C&colon.\OS2\PMSHELL.EXE:ehp8. with
:hp8.SET RUNWORKPLACE=[path]PC2.EXE:ehp8. where :hp8.[path]:ehp8. is the pathname
of the directory you installed PC/2. The next time you boot, PC/2 will be
started as a replacement for the WPS.
Be careful, OS/2 seems to dislike any parameters added to the program that
is started as the WPS!
:p.:hp8.Caution! PC/2 was not tested on all OS/2 versions or installed software
and hardware :ehp8.(simply because I don't have them):hp8., so there may be
bugs!:ehp8.. Of course you can start the WPS from a command prompt by typing
:hp8.START PMSHELL:ehp8. or add a corresponding entry to PC/2.
:eul.
:p.:link reftype=hd res=&ID_ABOUTDIALOG..<Backward>:elink.
                                :link reftype=hd res=&ID_GENERALHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected general help from the PC/2 main help panel.                        *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_GENERALHELP..General Help for PC/2
:p.PC/2 - Program Commander is an addon or replacement for the WPS (Workplace Shell).
The user can configure a menu that pops up, when mouse button 1 is clicked
anywhere on the Desktop. From this freely configurable Popup-Menu, you can select
an entry, which is launched immediately.
:p.PC/2 lets you define Hotkeys too. Pressing the Hotkey defined for a program, this
program is switched into the foreground or, if it is not already running, launched
immediately.
:p.PC/2 also allows you to expand the Desktop to a 9-fold virtual
Desktop, you may define Hotkeys to switch to an application on any virtual Desktop
by a simple keypress.
You may also switch to any virtual Desktop directly by doubleclicking with mouse
button 1 on PC/2's overview window.
p.PC/2 also enables you to define a UNIX-style behaviour of switching the input focus
from one window to another. This allows you to have the input focus in a window, which
is not the topmost window.
:p.For example. the Popup-Menu might look like:
:artwork name='Pc2ipc01.bmp' align=left.
:p.You have selected the item :hp4.Prompts:ehp4., which is a Submenu containing
seven more items. F.e. the item :hp4.OS/2 Window:ehp4. starts a windowed OS/2
command prompt, when selected. This Popup-Menu is fully configurable, you may add,
change or remove items. An item can either be a Submenu containing more items, 
the name of a program or a Menu Control.
:p.The complete Popup-Menu can be modified but the Menu Control :hp9.Desktop Menu:ehp9.
must be defined before the Popup-Menu will be displayed after mouse button 1 clicks.
If you have not defined this Menu Control, the :hp9.Setup:ehp9. dialog appears after
mouse button 1 clicks enabling you to add this control.
:p.Your configuration is read from the default profile :hp8.Pc2.cfg:ehp8. each time
PC/2 is started and saved every time you made changes.
You can of course overwrite the default
configuration filename to a file named :hp8.Filename.ext:ehp8. by invoking PC/2 with
the following commandline option:
:p.:hp8.PC2 [-Profile Filename.ext]:ehp8. or
:p.:hp8.PC2 [/Profile Filename.ext]:ehp8.
:p.where :hp8.Filename.ext:ehp8. conforms to a filename of a PC/2 profile. Both FAT
and HPFS filename naming convention is accepted. A few
sample configuration files are provided in this package.
:p.As the default, the Popup-Menu appears if you double-click once on the Desktop,
if no option or the following option is specified:
:p.:hp8.PC2 [-DoubleClick]:ehp8. or
:p.:hp8.PC2 [/DoubleClick]:ehp8.
:p.You may select a single-click instead, by invoking PC/2 with the following
commandline option:
:p.:hp8.PC2 [-SingleClick]:ehp8. or
:p.:hp8.PC2 [/SingleClick]:ehp8.
:p.Please be sure not to combine both click behavior options.
If you don't specify this option a user-modifyable default behaviour is taken
from :hp8.PC2.INI:ehp8..
Of course the options changing the click behavior and the configuration
filename options may be combined.
:p.Because some people use PC/2 as a WPS replacement, PC/2 contains a Menuitem
to ShutDown OS/2. By selecting this entry, it is safe to power off your PS/2 or
PC after all disk activity has been stopped, although no windows are closed.
If you run PC/2 as a WPS replacement and may want to start the WPS either by
starting :hp8.PMSHELL.EXE:ehp8. from a command prompt or by starting a
:hp8.PMSHELL:ehp8. Menuitem with PC/2.
You then can follow the WPS initialization by heavy disk access and
buildup of your Desktop with objects.
PC/2 requires to know the Desktop (in technical terms the window handle
of the Desktop) to be able to catch mouse button 1 clicks. If you start
the WPS the Desktop changes too. Therefor PC/2 checks regularily if the
Desktop has changed, so you may have to wait a little bit,
after the WPS was started, that PC/2 recognizes mouse clicks again..
:p.I would strongly recommend to start PC/2 during OS/2 boot. If you don't
want to use the default profile, don't forget to add :hp8./Profile Filename.exe:ehp8.
to the :hp4.Parameters:ehp4. entryfield in the Settings of PC/2.
:p.The reason why I wrote this utility was primarily, that many programs
installed on a system require many folders and icons on the Desktop. But to
start a program, I don't want to open and close folders, so I made shadows on
the Desktop messing it up. The solution I prefer is to click on the Desktop,
getting immediately a menu and selecting the application to be launched from
this menu, or alternatively launch or switch to applications by simply pressing
a Hotkey.
So PC/2 may help you to start your programs more quickly, without needing to open
and close folders. When running without the WPS installed, you even don't have the
possibility to launch applications from icons.
:p.:link reftype=hd res=&ID_INSTALLATIONHELP..<Backward>:elink.
                                :link reftype=hd res=&ID_CONCEPTSHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected concepts from the PC/2 main help panel.                            *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_CONCEPTSHELP..Concepts of PC/2
:p.The basic idea behind PC/2 is to have an configurable Popup-Menu available,
to start programs quicky, without having to open and close folders.
:p.The Popup-Menu, popped up when you click with mouse button 1 anywhere on
the Desktop (just like button 2 for the Desktop Menu), consists of so-called
items. An item may be a Submenu, which contains further items, or the title of
an Application or Menu Control items. A Submenu contains a little arrow right
beside the title of the Submenu. Mouse button 1 is on most system the left
mouse button.
:p.You can imagine this Popup-Menu as a tree, with applications as leaves and
Submenus as nodes. PC/2 allows you to freely build your own tree. To do so
you have to click on the Desktop with the left mouse button and to select
:hp8.PC/2 Setup &rarrow. Config Menu:ehp8.. A dialog box appears, where you
can add, modify or remove Submenus and Applications. The listbox displays all
Submenus and Applications of one level (like a cut through the tree). Of
course you may change this level up and down.
:p.You must have defined the Menu :hp8.Configure Menu:ehp8. before PC/2 display
it's Popup-Menu on mouse button 1 clicks. If you don't have defined it, PC/2
displays it's Setup dialog after each click until you have added this control.
:p.Once you have configured your tree of Submenus and Applications, just press
:hp8.Ok:ehp8. to take them into effect and save them to the profile or
:hp8.Cancel:ehp8. to take them into effect without saving.
:p.:link reftype=hd res=&ID_GENERALHELP..<Backward>:elink.
                                :link reftype=hd res=&ID_USINGHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help for starting a program from PC/2.                             *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_USINGHELP..Help for starting a program via PC/2
:p.After you have configured the PC/2 Popup-Menu, you click on the Desktop
with mouse button 1, select the Application you want to start and click on it.
The Application will be started as if you were clicking on an icon.
:p.One advantage starting an Application this way is, that you can manipulate
many parameters on how the Application is started, one thing you can't do with
many icons. F.e. you can start it invisible (useful for a backup program), making
it only visible by selecting it from the window list. You may also specify the size
of the Application or to start it in the background. You can even set it's priority
or define a Hotkey to switch to it.
:p.You can also start WPS objects, f.e. the Drives object or the Selective
Install.
If you have an WPS object, that represents a seamless WIN-OS2 application,
you may even launch all types of seamless WIN-OS2 sessions.
Without an corresponding WPS Object, PC/2 can only start seamless WIN-OS2
sessions as separate sessions (the complete WIN-OS2 environment is loaded).
Be warned! - you have to create an WPS Object with :hp8.MAKEOBJ.CMD:ehp8. first
to define an Object ID (Identifier) with that Object, to enable PC/2 to get
this ID.
:p.To close an Application, select the corresponding option from the Application
or terminate it from the tasklist.
Alternatively you may use PC/2's Kill smarticon to close the application's window.
:p.:link reftype=hd res=&ID_CONCEPTSHELP..<Backward>:elink.
                                :link reftype=hd res=&ID_CONFIGDIALOG..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Configuration/Setup PC/2 dialog box.                 *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_CONFIGDIALOG..Help for PC/2 Setup
:p.In the listbox, all Submenus and Applications of one level (imagine as a cut
through the tree) are displayed. A Submenu has an arrow right beside it. F.e. assume
the listbox contains 6 Submenus and 2 Applications resulting in the following Popup-Menu:
:artwork name='Pc2ipc02.bmp' align=left.
:p.Select the item :hp8.Config Menu:ehp8. to configure the items appearing in the
Popup-Menu. The :hp9.Setup:ehp9. dialog appears allowing you to adjust all items of
the current level.
:p.You may want to get into the Submenu :hp4.Prompts:ehp4.. Just select the Submenu
:hp4.Prompts:ehp4. an click on the button :hp8.Level Down >>:ehp8.. The listbox
will now be filled with all Submenus and Applications of the Submenu :hp4.Prompts:ehp4..
To get one level up, simply press :hp8.<< Level Up:ehp8.. If nothing seems to
change, you may be either at the highest level (the root of the tree) or at 
the deepest level (a leaf of the tree) of a Submenu.
:p.To configure the Popup-Menu just select an item.
:ul compact.
:li.To change or to remove this item use the buttons :hp8.Change Entry:ehp8. 
or :hp8.Remove Entry:ehp8.. Either a new dialog appears allowing you to change
the item, or the item will be removed.
:li.To add a Submenu or an Application press the buttons :hp8.Add Submenu:ehp8.
or :hp8.Add Program:ehp8.. A new dialog is displayed allowing you to add a new
Submenu or Application, after pressing :hp8.Ok:ehp8. in this dialog, the Submenu
or Application will be inserted :hp8.after:ehp8. the selected item, or at
the end of the list if no item is selected.
:li.To add a Control press the button :hp8.Add Control:ehp8. and a dialog
appears allowing you to add Menu Controls predefined by PC/2.
:li.To resort a Submenu press the button :hp8.Resort Menu:ehp8..
A new dialog is displayed allowing you to resort the currently listed Submenu.
Press here to get more information about the
:link reftype=hd res=&RDID_RESORTDIALOG..Resort:elink. dialog.
:eul.
:p.If the listbox is empty, you can't remove or change anything. You also can't
select any item, but in this case you can add a Submenu or an Application by
just pressing the buttons, without needing to select an item.
:p.Press :hp8.Ok:ehp8. to write the configuration to the profile, or press
:hp8.Cancel:ehp8. to keep the changes only in memory. Both buttons will dismiss
the dialog.
:p.:link reftype=hd res=&CDID_HELP_1..Example 1:elink.
     :link reftype=hd res=&CDID_HELP_2..Example 2:elink.
:p.:link reftype=hd res=&ID_CONCEPTSHELP..<Backward>:elink.
                                :link reftype=hd res=&MIID_MENUDIALOG..<Forward>:elink.

.*--------------------------------------------------------------------------------------*
.* The user selected example 1 from the Setup PC/2 help.                                *
.*--------------------------------------------------------------------------------------*

:h2 res=&CDID_HELP_1..Setup example 1
:p.Assume the listbox contains the following items resulting in the following Popup-Menu:
:artwork name='Pc2ipc03.bmp' align=left.
:p.You want to remove the Submenu :hp4.References:ehp4., rename the Submenu
:hp4.Tools:ehp4. to :hp4.Utilities:ehp4. and add a Submenu :hp4.Demos:ehp4..
:ol compact.
:li.Select the item :hp4.References:ehp4.. You can now press the button
:hp8.Remove Entry:ehp8. to remove the submenu, but only if this Submenu is empty.
If it isn't empty, get into this Submenu by pressing :hp8.Level Down >>:ehp8.
and remove all items.
:li.To rename :hp4.Tools:ehp4. to :hp4.Utilities:ehp4. select the item
:hp4.Tools:ehp4. and press the button :hp8.Change Entry:ehp8.. A dialog box
appears allowing you to rename this item.
:li.Select the item, after which you want to insert the new Submenu. Then press
the button :hp4.Add Submenu:ehp4. to add one. A dialog box appears allowing you
to enter the title of a new Submenu.
:eol.

.*--------------------------------------------------------------------------------------*
.* The user selected example 2 from the Setup PC/2 help.                                *
.*--------------------------------------------------------------------------------------*

:h2 res=&CDID_HELP_2..Setup example 2
:p.Assume that you have remove all items, leading to an empty listbox. Now
you want to add the Applications :hp4.Backup:ehp4. and :hp4.Terminal:ehp4..
:ol compact.
:li.The listbox is empty, so you can't select any item. Just press the
button :hp8.Add Program:ehp8. and a dialog box appears, allowing you to
enter all the data required for the new Application.
:li.Now the listbox contains the item :hp4.Backup:ehp4., select it and
press the button :hp8.Add Program:ehp8. a second time. Again you get
a dialog box, where you enter the data for the Application :hp4.Terminal:ehp4..
:eol.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Menu installation PC/2 dialog box.                   *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&MIID_MENUDIALOG..Help for PC/2 Menu Installation
:p.This dialog is used to get a name for a Submenu, which is then added to the
Popup-Menu. You can enter whatever you like, f.e. to make a Submenu that contains
OS/2 utilities you might enter :hp4.Utilities:ehp4..
:p.If you have chosen in the previous dialog to change the name of a Submenu, then
overwrite the pre-entered text.
:p.Press :hp8.Ok:ehp8. to accept, or press :hp8.Cancel:ehp8. to ignore the data
you entered.
:p.:link reftype=hd res=&MIID_HELP_1..Examples:elink.
:p.:link reftype=hd res=&ID_CONFIGDIALOG..<Backward>:elink.
                                :link reftype=hd res=&PIID_PROGRAMDIALOG..<Forward>:elink.

.*--------------------------------------------------------------------------------------*
.* The user selected examples from the Menu installation PC/2 help.                     *
.*--------------------------------------------------------------------------------------*

:h2 res=&MIID_HELP_1..Menu installation examples
:p.Assume you have entered the following Submenu Titles:
:dl tsize=12 break=fit.
:dthd.:hp8.Title&colon.
:ddhd.Purpose&colon.:ehp8.
:dt.Prompts
:dd.You want to add a Submenu named :hp4.Prompts:ehp4., that contains OS/2 and DOS,
fullscreen and windowed command prompts.
:dt.Spreadsheets
:dd.You want to add a Submenu named :hp4.Spreadsheets:ehp4. for your spreadsheet
program like Lotus 123/G or Excel.
:edl.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation PC/2 dialog box.                *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&PIID_PROGRAMDIALOG..Help for PC/2 Program Installation
:p.This dialog is a notebook consisting of the following pages:

:dl tsize=12 break=fit.
:dthd.:hp8.Page&colon.
:ddhd.Tab title&colon.:ehp8.
:dt.:hp9.Application:ehp9.
:dd.This page is used to define an application's title, path, filename,
working directory, command-line parameters and DOS settings.
:dt.:hp9.Session:ehp9.
:dd.This page determines the type of session you want to add. Select
between PM, OS/2, DOS and WIN-OS2 sessions.
:dt.:hp9.Style:ehp9.
:dd.This page can be used to define the appearance of an application. If the
application doesn't overwrite attributes, you may define the style, size and
position.
:dt.:hp9.Hotkey:ehp9.
:dd.This page is used to define a Hotkey, which will switch to the application
and bring it into the foreground.
:dt.:hp9.Priority:ehp9.
:dd.This page can be used to overwrite the default priority assigned to an
application.
:warning text='Caution:'.Changing the priority may cause serious problems, because
the application may be set to consume nothing to the full CPU time!.
:ewarning.
:edl.
:p.Press :hp8.Ok:ehp8. to accept, or press :hp8.Cancel:ehp8. to ignore the data
you entered in all notebook pages.
:p.For more information click about on one of the above notebook pages select:
:ul compact.
:li.:link reftype=hd res=&PIID_PAGE1..Application Settings:elink.
:li.:link reftype=hd res=&PIID_PAGE2..Session Settings:elink.
:li.:link reftype=hd res=&PIID_PAGE3..Style Settings:elink.
:li.:link reftype=hd res=&PIID_PAGE4..Hotkey Settings:elink.
:li.:link reftype=hd res=&PIID_PAGE5..Priority Settings:elink.
:eul.
:p.:link reftype=hd res=&PIID_EXAMPLE1..Example 1:elink.
:p.:link reftype=hd res=&MIID_MENUDIALOG..<Backward>:elink.
                                :link reftype=hd res=&MDID_CONTROLDIALOG..<Forward>:elink.


.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation Application notebook page.      *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_PAGE1..Application Settings
:p.This dialog is used to get the title, the path and filename, the working
directory and parameters of a Menuitem, which is then added to the Popup-Menu.
:p.For a normal user it is the easiest way to use the following guidelines.
According to the type of application you add, some fields may not be editable
or visible:
:dl tsize=12 break=fit.
:dthd.:hp8.Fieldname&colon.
:ddhd.You would enter&colon.:ehp8.
:dt.:hp9.Program Title&colon.:ehp9.
:dd.Here you enter the name which should appear on the applications's titlebar, 
which may be overwritten by some applications.
For OS/2 and DOS windows, this will also be the title in the window list.
You may also name the Objects here, you want to add.
:dt.:hp9.Path and Filename&colon.:ehp9.
:dd.Here you enter the fully qualified path and filename. F.e. you might enter
:hp4.c&colon.\os2\cmd.exe:ehp4. to obtain an OS/2 command prompt, or
:hp4.c&colon.\os2\mdos\qbasic.exe:ehp4. to start the basic interpreter.
:p.Here you also enter the name of WPS Objects.
WPS Objects are referred either by their defined Object ID (Identity) f.e.
:hp4.<WP_DRIVES>:ehp4. or :hp4.<WP_INST>:ehp4. for preinstalled Objects,
of f.e. :hp4.<WP_USER_CALC>:ehp4. or :hp4.<WP_WIN_PBRUSH>:ehp4. for
Objects installed by the user with :hp8.MAKEOBJ.CMD:ehp8., a REXX-utility
supplied with PC/2.
Preinstalled WPS Objects have usually a defined name, you may need to take a
look into the file :hp8.OS2_20.RC:ehp8. to get further information.
:p.PC/2 can only launch WPS Objects named by their defined ID, so be careful
to get either the correct ID from :hp8.OS2_20.RC:ehp8. or to define an Object
with a known ID with :hp8.MAKEOBJ.CMD:ehp8.
For a user installed Objects, you can freely use any name, preferably a
descriptive name in the form :hp4.<WP_xxxx>:ehp4..
:p.Sorry, this may be a little complicated, but it is the only way I know
to get a known Object ID and the only way I know to start all types of seamless
WIN-OS2 sessions.
You can't use the Program Template to create Objects if you want them to
add to PC/2, because PC/2 can't obtain the Object ID of such Objects.
:p.Here you would also enter the path and filename of a seamless WIN-OS2
application.
:dt.:hp9.Working Directory&colon.:ehp9.
:dd.Here you enter the directory where the EXE, HLP and DLL files of your
application are located. Before the application is started, a change drive
and change directory call is made, to make this directory the working directory.
:dt.:hp9.Parameters&colon.:ehp9.
:dd.Here you enter the parameters passed to the application. PC/2 allows you
to be asked for commandline parameters before the application is invoked.
Press on :link reftype=hd res=&SUID_STARTUPDIALOG..Commandline Parameters:elink.
to find out more about this feature. Assume that you want
to use VIEW.EXE to view the command reference, you would enter
:hp4.c&colon.\os2\book\cmdref.inf:ehp4..
:p.If you have selected the WIN-OS2 Program Manager :hp4.PROGMAN.EXE:ehp4.
to be started as a seamless WIN-OS2 application, you may enter 1 and only
1 additional WIN-OS2 application, that will be started by the Program
Manager in the same WIN-OS2 session.
The Program Manager itself will be started minimized.
:dt.:hp9.DOS Settings&colon.:ehp9.
:dd.If you select as program type a DOS Full-Screen or DOS Window, a multiline
entryfield is displayed where you can enter the DOS Settings you need. Default,
the DOS Settings :hp4.IDLE_SECONDS=5:ehp4. and :hp4.IDLE_SENSITIVITY:ehp4. are
added if you create a DOS application for the first time. (You have to spell
the DOS Settings exactly as they are displayed in the standard DOS Settings
dialog - even then some can't be set for whatever reasons there are.)
:p.As seamless WIN-OS2 sessions are also DOS type sessions, you can also
adjust the Settings of seamless WIN-OS2 sessions here, f.e. you may want to
increase the memory by adding DPMI_MEMORY_LIMIT=8.
:dt.:hp8.File Find:ehp8.&colon.
:dd.If you click on this button, the standard file dialog of OS/2 is displayed
where you can select the application you want to install. The application
parameters (f.e. path) will then be inserted automatically in the
corresponding entryfields.
:dt.Drag &amp. Drop:
:dd.You can alternatively use the Drag &amp. Drop operation to install one
application. Select one application from f.e. a Drives object or from
a filemanager, drag it into the dialog to any area that accepts it and
drop it.
The settings will be adjusted according to the application you dragged into.
You may also drag any WPS Object into this dialog, but be careful to
verify the name of the Object, because I don't know how to do this
automatically (you may need to look into :hp8.OS2_20.RC:ehp8.
for the exact spelling of preinstalled Objects.
:edl.
:p.For a power user, the data entered may be less. Because the OS/2 API
DosStartSession() is used to start the application, all rules for this
API apply as described in the toolkit. Hence you may leave the entryfield
Path and Filename blank and then select from the
:link reftype=hd res=&PIID_PAGE2..Session Settings:elink. group an
OS/2 or DOS fullscreen or window, to get a command prompt.
:p.You may also start an appliciation indirectly through a secondary command
processor by specifying :hp4.c&colon.\os2\cmd.exe:ehp4. as the Path and Filename and
use then the :hp4./C:ehp4. or :hp4./K:ehp4. option of CMD.EXE in the
Parameters entryfield.
:p.Press :hp8.Ok:ehp8. to accept, or press :hp8.Cancel:ehp8. to ignore the data
you entered in all notebook pages.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation Session notebook page.          *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_PAGE2..Session Settings
:p.Here you can select the type of application you want to add.
By default, PC/2 tries to determine the type of an application you installed
via the standard file dialog or via Drag &amp. Drop.
:dl tsize=12 break=fit.
:dthd.:hp8.Option&colon.
:ddhd.Description&colon.:ehp8.
:dt.:hp9.Determined by WPS:ehp9.
:dd.This default selection lets the WPS choose the type of application when
started.
:dt.:hp9.OS/2 Full-Screen:ehp9.
:dd.The seesion is a command session, started in full-screen.
:dt.:hp9.OS/2 Window:ehp9.
:dd.The session is a command session, started in a window on PM.
:dt.:hp9.Presentation Manager:ehp9.
:dd.The session is graphical PM application.
:dt.:hp9.DOS Full-Screen:ehp9.
:dd.The session is a DOS command session, started in full-screen.
:dt.:hp9.DOS Window:ehp9.
:dd.The session is a DOS command session, started in a window on PM.
:dt.:hp9.WPS Object:ehp9.
:dd.The Object-ID of the WPS Object to be started is contained in the entryfield
:hp9.Path and Filename&colon.:ehp9.. The session can only be started when the
Object-ID is assigned.
:dt.:hp9.Seamless WIN-OS2:ehp9.
:dd.The session is a seamless WIN-OS2 session. Be sure that your graphics
adapter supports such sessions. Currently all seamless WIN-OS2 sessions
are seperate sessions.
:dt.:hp9.Real Mode:ehp9.
:dd.The seamless WIN-OS2 session is started in Real Mode. Real Mode compatibility
is only provided by OS/2 2.0.
:dt.:hp9.Standard Mode:ehp9.
:dd.The seamless WIN-OS2 session is started in Standard Mode.
:dt.:hp9.386 Enhanced Mode:ehp9.
:dd.The seamless WIN-OS2 session is started in 386 Enhanced Mode. 386 Enhanced
mode compatibility is only provided by OS/2 2.1.
:edl.
:p.You generally have to verify, that the Program Type setting corresponds
to the application you installed, for most programs you can use
:hp9.Determined by WPS:ehp9. if you aren't sure.
:p.According to the Program Type that is selected, some settings may not
be editable or visible.
:p.OS/2 and DOS Fullscreen or Windows are only used, if you want to start
a command prompt as the application. In this case, you usually enter in the
the entryfield Path and Filename of the group Program Data the path of
the corresponding command processor. A advanced technique to select the
type of command processor only with these radiobuttons is described under
the group :hp9.Program Type:ehp9..
:p.To add a seamless WIN-OS2 session without a corresponding WPS Object
defined, select the :hp9.Seamless WIN-OS2:ehp9. radiobutton.
Another group of buttons will be enabled, allowing you the select the
Settings of the WIN-OS2 session.
Although there is a :hp9.Separate Session:ehp9. checkbox, seamless WIN-OS2
sessions will currently always be started as separate sessions.
:warning.
Under OS/2 2.0 GA, seamless WIN-OS2 sessions may only be started with
the WPS running, otherwise the system hangs.
There seems also to be a problem with a real mode session, because
such a WIN-OS2 session starts to load, but doesn't finish successfully.
Under OS/2 2.1 GA you may start seamless WIN-OS2 session with or without
the WPS installed.
:ewarning.
:p.Press :hp8.Ok:ehp8. to accept, or press :hp8.Cancel:ehp8. to ignore the data
you entered in all notebook pages.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation Style notebook page.            *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_PAGE3..Style Settings
:p.You can select one of the radiobuttons and any of the checkboxes to
define the style the application should be started with.
:p.Some applications overwrite the default style settings, i. e. by
reading them from a profile.
PC/2 can't force such applications to accept the styles you selected.
:dl tsize=12 break=fit.
:dthd.:hp8.Option&colon.                         c
:ddhd.Description&colon.:ehp8.
:dt.:hp9.Application defined:ehp9.
:dd.The default style defined by the session itself is used.
:dt.:hp9.Maximized:ehp9.
:dd.The session's default style is modified to maximized.
:dt.:hp9.Minimized:ehp9.
:dd.The session's default style is modified to minimized.
:dt.:hp9.Invisible:ehp9.
:dd.The window created by the application is invisible.
:dt.:hp9.No Autoclose:ehp9.
:dd.The window created by the application is not terminated when the application
shuts down.
:dt.:hp9.Background:ehp9.
:dd.The window is created in the background.
:dt.:hp9.User defined Size &amp. Position:ehp9.
:dd.The session's default size and position is modified to the values entered.
PC/2 forces the window to the entered position, even when the application overwrites
these values. You may specify a position relative to the origin of the Virtual
Desktops (the "middle" Desktop of the 9 Virtual Desktops), useful when the.
:link reftype=hd res=&ID_DESKTOPDIALOG..Virtual Desktop:elink. feature is
enabled.
:edl
F.e. if you selected :hp9.Minimized:ehp9., :hp9.Invisible:ehp9. and
:hp9.Background:ehp9. buttons, the application will be started minimized, in the
background and invisible (this may make sense for a backup program).
:p.Press :hp8.Ok:ehp8. to accept, or press :hp8.Cancel:ehp8. to ignore the data
you entered in all notebook pages.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation Hotkey notebook page.           *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_PAGE4..Hotkey Settings
:p.PC/2 supports the definition of Hotkey, to switch from the current application to a
certain application just by pressing a Hotkey. If the Hotkeyed session is on another
virtual Desktop, PC/2 switches to this Desktop and switches the application into the
foreground. PC/2 supports 0 ... 9 in combination with either the Ctrl-Key or the
Alt-Key as Hotkeys giving you 20 different Hotkeys at maximum.
:p.If PC/2 can't detect the application running, the pressed Hotkey is defined for,
it starts the application as if it was invoked by PC/2's Popup-Menu.
Starting applications by pressing a Hotkey is another alternative invoking programs 
delivered by PC/2.
:p.PC/2 allows you to mark the application as non-movable around the virtual Desktop.
By defining this style the application always keeps on the active Desktop, regardless
to which :link reftype=hd res=&ID_DESKTOPDIALOG..virtual Desktop:elink. you are
switching to.
:p.
:dl tsize=12 break=fit.
:dthd.:hp8.Control&colon.
:ddhd.Description&colon.:ehp8.
:dt.:hp9.Session name:ehp9.
:dd.If you either mark the application as non-movable or define a Hotkey, you must fill
this entryfield with a string that equals or is part of, of either the applications
name on it's titlebar or the applications name in the window list.
If you use one of the two features and you leave the entryfield empty, PC/2 copies the
string from :hp9.Program Title:ehp9. entryfield when you press :hp8.Ok.:ehp8..
:p.Be sure that the string you entered matches only with the current application, because
the first match of this string with any applications's titlebar or it's entry in the
window list will be taken.
You may want to start your application without these options first, to get it's titlebar
name or it's entry in the window list.
:p.I strongly recommend to fill in this entryfield if you experience unexpected results.
PC/2 uses the session name to identify the current sessions from all running sessions.
:dt.:hp9.Keep on active Desktop:ehp9.
:dd.Checking this flags keeps the application always on the current Desktop regardless
to which virtual Desktop you move.
:dt.:hp9.Enable Hotkey:ehp9.
:dd.This flag defines you want to define a Hotkey for this application. The controls
necessary to define the Hotkey will be enabled.
:dt.:hp9.Default:ehp9.
:dd.Once you pressed the Hotkey the Desktop is switched to the virtual Desktop the
application is located on and activates it.
:dt.:hp9.Maximized:ehp9.
:dd.The same as for :hp9.Default:ehp9. is done, but the applications window is maximized
too.
:dt.:hp9.Restore:ehp9.
:dd.The same as for :hp9.Default:ehp9. is done, but the applications window is restored
too.
:dt.:hp9.Ctrl-Key:ehp9.
:dd.You define a Hotkey which ranges from 0 ... 9 and A ... Z in conjunction with the Ctrl-Key.
:dt.:hp9.Alt-Key:ehp9.
:dd.You define a Hotkey which ranges from 0 ... 9 and A ... Z in conjunction with the Alt-Key.
:p.You must select a key in the range between 0 and 9 or A ... Y from the drop down box which in
conjunction with the Ctrl-key or Alt-key is used to switch to the application. You can 
define this way 72 different keys as the maximum.
:p.OS/2 and DOS windows modify the keys pressed in such a way, that PC/2 is not
able to detect them. If you wand to switch from such a window, change the focus
to another window, for example to the Window List by pressing CTRL+ESC.
:warning text='Caution!'. All keys defined as Hotkeys in PC/2 are no longer available
for other applications, because once a key is defined as Hotkey no other application
except PC/2 gets this key.
This is a limitation of the Hotkey feature, because only this way PC/2 can ensure
that if a Hotkey is defined, the Desktop switches to this application.
The Hotkey launches the application, if the application, the Hotkey is defined for,
is not running.
If you need a certain key, which is defined as a Hotkey in PC/2, change the Hotkey
to an unused key.
:ewarning.
:dt.:hp9.Current Window List:ehp9.
:dd.To define the style non-movable or the Hotkey you may start the application first
without these options and gets its titlebar name from it's window or it's window
list name from the :hp9.Current Window List:ehp9..
:edl.
:p.Press :hp8.Ok:ehp8. to accept, or press :hp8.Cancel:ehp8. to ignore the data
you entered in all notebook pages.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation Priority notebook page.         *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_PAGE5..Priority Settings
:p.PC/2 allows you to specify the priority of the applications you start via the Popup-Menu.
OS/2 has the following priority classes and deltas defined to select from:
:dl tsize=12 break=fit.
:dthd.:hp8.Priority Class&colon.
:ddhd.Description&colon.:ehp8.
:dt.:hp9.Idle time:ehp9.
:dd.:hp8.Idle-time:ehp8. is the lowest priority class a session or thread can run under OS/2.
You may use this option for task that should only be performed if enough CPU-resource is
available, i.e. for a background NFS (Network File System) Server or BBS.
:dt.:hp9.Regular:ehp9.
:dd.If not specified otherwise the priority class :hp8.Regular:ehp8. is the default class of all
sessions and threads. For these default class the priority delta of 0 is default.
:dt.:hp9.No Change:ehp9.
:dd.This option just doesn't change the priority. The application is started with
the priority class Regular and priority delta 0.
:dt.:hp9.Time Critical:ehp9.
:dd.:hp8.Time-critical:ehp8. priority class is used for time-critical sessions. Examples 
may be real-time data acquisition.
:dt.:hp9.Foreground Server:ehp9.
:dd.:hp8.Foreground Server:ehp8. is the highest priority class available that should be only
used for small assembly language applications because they really eat up the CPU time.
:dt.:hp9.Priority Delta:ehp9.
:dd.The priority delta selectable between 0 and 31 is defined for each priority class.
I.e. a session with Regular priority class and priority delta 25 has a lower priority
than a session with Time-critial priority class and priority delta 3.
:edl.
:p.:warning text='Extreme caution!'. Changing the priority from the default selection
may cause serious performance impacts on your system. Be very carefully when
selecting higher priorities, because the higher the priority the higher the CPU time-slice
a session consumes deteriorating overall system performance.
You can't change the priority of DOS session (and WIN-OS2 sessions are DOS sessions)
because allowing this would lock PM for unknown reasons.
:ewarning.
:p.For example if you set an OS/2 command prompt to a Time-critical priority, you may
not be able to switch to other sessions until the command prompt is waiting for input.
:p.Press :hp8.Ok:ehp8. to accept, or press :hp8.Cancel:ehp8. to ignore the data
you entered in all notebook pages.

.*--------------------------------------------------------------------------------------*
.* The user selected examples from the Program installation PC/2 help.                  *
.*--------------------------------------------------------------------------------------*
:h2 res=&PIID_EXAMPLE1..Program installation example 1
:p.Assume you want to add Lotus 123/G:
:dl tsize=12 break=fit.
:dthd.:hp8.Fieldname&colon.
:ddhd.You would enter&colon.:ehp8.
:dt.:hp9.Program Title&colon.:ehp9.
:dd.:hp4.Lotus 123/G:ehp4.
:dt.:hp9.Path and Filename&colon.:ehp9.
:dd.:hp4.c&colon.\123g\123g.exe:ehp4.
:dt.:hp9.Working Directory&colon.:ehp9.
:dd.:hp4.c&colon.\123g:ehp4.
:dt.:hp9.Parameters&colon.:ehp9.
:dd.(none)
:edl.
:p.Lotus 123/G is a Presentation Manager application so you would select
:hp4.Presentation Manager:ehp4. as program type. The program style may be
:hp4.Maximized:ehp4., because more information is visible. The priority
may be left at the default selection :hp4.No Change:ehp4..
:p.Assume you want to add the WPS Object System Clock (located in the
folder :hp8.OS/2 System &rarrow. System Setup:ehp8.):
:dl tsize=12 break=fit.
:dthd.:hp8.Fieldname&colon.
:ddhd.You would enter&colon.:ehp8.
:dt.:hp9.Program Title&colon.:ehp9.
:dd.:hp4.System Clock:ehp4.
:dt.:hp9.Path and Filename&colon.:ehp9.
:dd.:hp4.<WP_CLOCK>:ehp4.
:dt.:hp9.Working Directory&colon.:ehp9.
:dd.(n/a)
:dt.:hp9.Parameters&colon.:ehp9.
:dd.(n/a)
:edl.
:p.The System Clock is a WPS Object, so :hp4.WPS Object:ehp4. is
selected as the program type.
You may have to look into the file :hp8.OS2_20.RC:ehp8. to get the defined
name of preinstalled WPS Objects.
Most settings are not available for WPS Objects.
:p.Assume you want to add the WPS Object seamless WIN-OS2 Clock.
First you must create an WPS Object with a known Object ID (Identifier) with
:hp8.MAKEOBJ.CMD:ehp8., a small REXX-utility supplied with PC/2.
To do so, start :hp8.MAKEOBJ.CMD:ehp8. and supply the Object ID
:hp4.<WP_WIN_CLOCK>:ehp4. when you're asked to.
Then open the newly created Object Settings and change them as you
usually do, when you want to make an Object for a seamless WIN-OS2
session of the WIN-OS2 clock.
After you have created the WIN-OS2 clock object, you can drag it into
this dialog of PC/2:
:dl tsize=12 break=fit.
:dthd.:hp8.Fieldname&colon.
:ddhd.You would enter&colon.:ehp8.
:dt.:hp9.Program Title&colon.:ehp9.
:dd.:hp4.Clock:ehp4.
:dt.:hp9.Path and Filename&colon.:ehp9.
:dd.:hp4.<WP_WIN_CLOCK>:ehp4.
:dt.:hp9.Working Directory&colon.:ehp9.
:dd.(n/a)
:dt.:hp9.Parameters&colon.:ehp9.
:dd.(n/a)
:edl.
:p.The seamless WIN-OS2 Clock is a WPS Object, so :hp4.WPS Object:ehp4.
is used as the program type.
Assuming that you created the seamless WIN-OS2 clock object as outlined
before, then the Object ID is :hp4.<WP_WIN_CLOCK>:ehp4..
If you had an WPS Object before, and you don't know the Object ID, you
have to create a new one with :hp8.MAKEOBJ.CMD:ehp8., to define a known
Object ID.
:p.Sorry, this may be a little complicated, but it is the only way I know
to get a known Object ID and the only way I know to start seamless
WIN-OS2 sessions.
:p.Assume you want to add the WIN-OS2 Program Manager.
Open the Program Installation dialog, and either enter the path information
(f.e. c&colon.\os2\mdos\winos2\progman.exe) or drag :hp4.PROGMAN.EXE:ehp4.
into.
If you have entered the data manually, you also must check the
seamless WIN-OS2 session.
Further assume that you want in the same WIN-OS2 session also start the
WIN-OS2 File Manager :hp4.WINFILE.EXE:ehp4., then you add it to the
Parameters entryfield:
:dl tsize=12 break=fit.
:dthd.:hp8.Fieldname&colon.
:ddhd.You would enter&colon.:ehp8.
:dt.:hp9.Program Title&colon.:ehp9.
:dd.:hp4.Prog &amp. File Manager:ehp4.
:dt.:hp9.Path and Filename&colon.:ehp9.
:dd.:hp4.c&colon.\os2\mdos\winos2\progman.exe:ehp4.
:dt.:hp9.Working Directory&colon.:ehp9.
:dd.:hp4.c&colon.\os2\mdos\winos2:ehp4.
:dt.:hp9.Parameters&colon.:ehp9.
:dd.:hp4.winfile.exe:ehp4.
:edl.
:p.You can only add a Parameter to the WIN-OS2 Program Manager, and only
one.

.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Control Addition PC/2 dialog box.                    *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&MDID_CONTROLDIALOG..Help for PC/2 Control Addition
:p.This dialog allows you to add Menu Control items to PC/2's Popup-Menu. Except for
:hp9.Break Separator:ehp9. and :hp9.Menu Separator:ehp9. you may only add 1 instance
of the Menu Control to the Popup-Menu.
The Menu Control :hp9.Configure Popup-Menu Settings:ehp9. must be added
to the Popup-Menu in order that PC/2 displays the Popup-Menu after mouse button 1
clicks, otherwise the :link reftype=hd res=&ID_CONFIGDIALOG..Setup dialog:elink. will
be invoked after each mouse click until you have added this Menu Control. PC/2
supports the following Menu Controls:
:dl tsize=12 break=fit.
:dthd.:hp8.Control&colon.
:ddhd.Description&colon.:ehp8.
:dt.:hp9.Menu Settings:ehp9.
:dd.This button is used to add the Menu Control to be able to configure the Popup-Menu
via the Setup dialog.
:dt.:hp9.Desktop Settings:ehp9.
:dd.This button is used to add the Menu Control to configure the virtual Desktop feature.
:dt.:hp9.About PC/2:ehp9.
:dd.This button adds the About PC/2 Menu Control.
:dt.:hp9.ShutDown OS/2:ehp9.
:dd.This button adds a Menu Control, which when selected displays a message box allowing
you to shutdown OS/2 just be clicking on :hp8.Ok:ehp8. or pressing the :hp8.Enter:ehp8. key.
:dt.:hp9.Help:ehp9.
:dd.This button add the online help Menu Control item.
:dt.:hp9.Exit:ehp9.
:dd.This button is used to add the Menu Control to be able to exit PC/2 via a message box
by just clicking on :hp8.Ok:ehp8. or pressing the :hp8.Enter:ehp8. key.
:dt.:hp9.Break Separator:ehp9.
:dd.This button is used to add one break separator Menu Control. You may add this
Menu Control to convert a large single-column menu to a smaller multi-column menu.
This Control is a Menu Control that you may add as often you prefer. I suggest to
use this Control only to break Menuitems not being a Submenu.
:dt.:hp9.Menu Separator:ehp9.
:dd.This button is used to add one separator Menu Control. You may add this Menu Control
to enhance the readability of the Popup-Menu. This Control is a Menu Control that
you may add as often you prefer.
:edl.
:p.Press :hp8.Ok:ehp8. to accept or press :hp8.Cancel:ehp8. to ignore the your modifications.
:p.:link reftype=hd res=&PIID_PROGRAMDIALOG..<Backward>:elink.
                                :link reftype=hd res=&RDID_RESORTDIALOG..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Resort PC/2 dialog box.                              *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&RDID_RESORTDIALOG..Help for PC/2 Resort
:p.This dialog box contains two listboxes, the left one that displays the currently
available Menuentries and the right one that displays the currently resorted
Menuentries.
Select the first Menuentry from the left listbox and press the 
:hp8.Reorder:ehp8. button, to resort it to the right listbox.
For the next Menuentry(ies) repeat this procedure, until the left listbox is empty.
:p.You can cancel the resort before you have done any sort, but you have to resort
the complete Submenu once you made one resort operation.
:p.All sorted Menuentries in the right listbox can't be started with PC/2 until
you complete the resort by pressing :hp8.OK:ehp8..
Warning! - You have to press :hp8.OK:ehp8. in the :link reftype=hd 
res=&ID_CONFIGDIALOG..Setup Dialog:elink. to write the resorted Menuentries
structure to the configuration file.
:p.:link reftype=hd res=&MDID_CONTROLDIALOG..<Backward>:elink.
                                :link reftype=hd res=&SUID_STARTUPDIALOG..<Forward>:elink.

.*--------------------------------------------------------------------------------------*
.* The user selected help from the Startup Parameters dialog box.                       *
.*--------------------------------------------------------------------------------------*

:h1 res=&SUID_STARTUPDIALOG..Help for PC/2 Startup Parameters
:p.PC/2 allows you to replace the commandline parameters of your application
completly or partly.
:p.F.e. assume you have a TCP/IP communications package installed on your
system. You also have added an Menuitem that start a file transfer program named
:hp4.FTP:ehp4.. :hp4.FTP:ehp4. requires as a parameter the name of the host
you want to connect to.
To prompt you for this parameter immediately before :hp4.FTP:ehp4. is started,
you would modify the parameters entryfield of the PC/2 Program Installation
dialog like :hp8.[Please enter host address]:ehp8.
:p.Further assume that you selected the Menuitem :hp4.FTP:ehp4. from the
Popup-Menu. Just before :hp4.FTP:ehp4. is started, a dialog box is displayed,
requesting the host address from you. F.e. you will type
:hp8.ftp.cdrom.com:ehp8., then the file transfer program will be invoked
as if you typed :hp8.FTP ftp.cdrom.com:ehp8. from a commandline.
:p.Generally the syntax for the commandline parameters is:
:p.:hp8.Parameter(s) 1 [Text] Parameter(s) 2:ehp8.
:p.Assume you typed :hp8.FirstFile.doc:ehp8. as the first and
:hp8.ThirdFile.doc:ehp8. as the second parameter.
You will be asked by a dialog box, what to replace :hp8.[Text]:ehp8. with.
Assume you entered :hp8.MyFile.doc:ehp8. then the program will be invoked
with the commandline parameters :hp8.FirstFile.doc MyFile.doc ThirdFile.doc:ehp8..
The string :hp8.[Text]:ehp8. would have been replaced by :hp8.MyFile.doc:ehp8..
Of course both parameters may be omitted, both may contain more than one parameter
or only one of them may present. Omitting :hp8.[Text]:ehp8. would start the
application without asking you for a commandline parameter prior.
:p.You may also use this dialog, to add a second WIN-OS2 application to a
WIN-OS2 session, if the first application is the WIN-OS2 Program Manager.
:p.PC/2 allows you to edit commandline parameters similar to the WPS (open
the Settings notebook of any application,
position the cursor into the Parameters entryfield and
press F1 or Help to get further information).
:p.Press :hp8.Ok:ehp8. to accept the parameters you entered, or press
:hp8.Cancel:ehp8. to replace the commandline parameters by an empty string.
:p.:link reftype=hd res=&RDID_RESORTDIALOG..<Backward>:elink.
                                :link reftype=hd res=&ID_DESKTOPDIALOG..<Forward>:elink.

.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Desktop Setup PC/2 dialog box.                       *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_DESKTOPDIALOG..Help for PC/2 Desktop Setup
:p.PC/2 supports what is called :hp8.Sliding Focus:ehp8. and :hp8.Virtual
Desktop:ehp8..
:p.A :hp8.sliding Focus:ehp8. ensures, that the window under the mouse pointer
is always the active window (the one that has a highlighted frame).
If you move the pointer over another window, PC/2 recognizes the pointer movements,
and tries to activate the window currently under the mouse pointer.
The windows will behave similar to X-Windows, but the active window is always fully
displayed.
:p.A :hp8.Virtual Desktop:ehp8. is a Desktop enhancement that expands your display.
For example assume that you are running OS/2 on an XGA-2 at a resolution of 1024 * 768
pixels.
Your display has then 1024 columns and 768 rows of pixels, giving you a
Desktop where application windows can be seen.
We will call this the :hp8.physical Desktop:ehp8..
Of course you can start windows outside this Desktop, but you won't be able to
see them unless you switch to this Desktop..
:p.PC/2 allows you to expand this Desktop, so that you can move the physical
Desktop around to see the windows you couldn't see before.
We will call this enhancement the :hp8.Virtual Desktop:ehp8..
Simply speaking, imagine the virtual Desktop as an 3 * 3 array of Desktops,
with the physical Desktop you now can see in the middle.
Now imagine, that you can move your physical Desktop around within the
larger virtual Desktop.
For example assume that you move the physical Desktop left, all windows you have
started will move right, so some disappear in the right side  and some
appear on the left side of your display.
:p.That's just that what PC/2 does for you.
If you move your mouse pointer on the leftmost column of your display
(column 0), all windows move rightward, as the physical Desktop moves
leftward within the virtual Desktop.
The same principle is used on the rightmost columns and the top and
bottom rows.
If you move your mouse pointer into a corner of your display, the Desktop
even will move in two directions, leading to a horizontal and a
vertical movement.
:p.Of course you can only move your physical Desktop in one direction,
as long as this movement keeps the physical Desktop within the
virtual Desktop.
Using this feature, you expand your physical Desktop to a 9-fold virtual
Desktop.
:dl tsize=12 break=fit.
:dthd.:hp8.Control&colon.
:ddhd.Description&colon.:ehp8.
:dt.:hp9.Sliding Focus:ehp9.
:dd.Select this checkbox to enable the :hp8.Sliding Focus:ehp8. feature of
PC/2.
:dt.:hp9.Preserve Z-Order:ehp9.
:dd.To preserve the Z-order of the windows, that is the order in which a window in
the foreground overlaps a window behind, also check the :hp9.Preserve Z-Order:ehp9.
checkbox.
If you run seamless WIN-OS2 sessions, you may want to disable the sliding Focus,
to avoid some nasty problems.
:dt.:hp9.Button 2 titlebar click to set window to bottom:ehp9.
:dd.Select this checkbox if you want to click down mouse button 2 on any window's
titlebar to set this window to the bottom of all windows. This moves the window
you clicked on behind all other windows, lowering its Z-Order to the minimum.
:dt.:hp9.Virtual Desktop:ehp9.
:dd.Select this checkbox to enable the :hp8.Virtual Desktop:ehp8. feature of
PC/2.
:dt.:hp9.Move OS/2's Desktop:ehp9.
:dd.This checkbox allows you to move the Desktop within the virtual Desktop
like any other window. The Desktop is another name for the WPS (WorkPlace-Shell).
You may check this option if you don't need the services provided by the WPS
on all Virtual Desktops.
:dt.:hp9.Click to Move:ehp9.
:dd.If you prefer to click, before the physical Desktop is moved,
select this option.
After you move your mouse pointer over the surrounding rows or columns
you have to click, either a single or double click according to the
:dt.:hp9.Overview Window:ehp9.
:dd.You may also want an overview window, that contains the current
layout of the virtual Desktop.
Select this checkbox to enable this feature.
You may doubleclick with mouse button 1 on any of the 9 :hp8.virtual
Desktop:ehp8.s to immediately switch to this Desktop.
commandline option, to move the physical Desktop.
:dt.:hp9.Keep on top:ehp9.
:dd.Select this option if you want the overview window to stay always on
the top of the Desktop, even if another window has the focus.
:dt.:hp9.Virtual Desktop Scrolling:ehp9.
:dd.You can use this scrollbar to select the percentage of the display
dimensions the physical Desktop should move for a single movement.
You can select between 0 and 100 % wit 5% increments, with 100 % being the
default one.
:dt.:hp9.OS/2's Desktop Name:ehp9.
:dd.PC/2 has to know the name of this Desktop, so you have to ensure that
you type its name in the entryfield.
Under OS/2 2.0 its usually named :hp8.OS/2 2.0 Desktop:ehp8., but
it changes under OS/2 2.1 to :hp8.Desktop:ehp8., if you haven't installed
it over an existing OS/2 2.0 system.
You may rename the Desktop by clicking with mouse button 2 on the Desktop
selecting Desktop&rarrow.Settings and selecting the General notebook page.
Changing the title can be used to replace :hp8.OS/2 2.0 Desktop:ehp8.
by :hp8.Desktop:ehp8..
Also ensure that you translate is into your national language, if you
don't use an English OS/2 version.
:dt.:hp9.Window List Name:ehp9.
:dd.PC/2 also requires to know the name of the Window List.
The Window List is usually named :hp8.Window List:ehp8. but you have to 
ensure that it is translated into your national language, if you don't
use an English OS/2 version.
:dt.:hp9.Button 1 Single Click:ehp9.
:dd.Select this option if you want to activate the Popup-Menu or
switch to another virtual Desktop with a single click with mouse button 1.
:dt.:hp9.Button 1 Double Click:ehp9.
:dd.Select this option if you want to activate the Popup-Menu or
switch to another virtual Desktop with a double click with mouse button 1.
:edl.
:p.These setting are saved and will be used when PC/2 is loaded unless you have
specified a different behaviour with the
:link reftype=hd res=&SUID_STARTUPDIALOG..Commandline Parameters:elink..
:p.Press :hp8.Ok:ehp8. to accept the configuration and save it into an INI file,
or press :hp8.Cancel:ehp8. to ignore any changes you made.
If your INI file is corrupted, PC/2 assumes default values, which
you then can edit and save to a new INI file.
:p.:link reftype=hd res=&SUID_STARTUPDIALOG..<Backward>:elink.
                                :link reftype=hd res=&ID_OVERVIEWHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help for PC/2's overview window.                                   *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_OVERVIEWHELP..Help for PC/2's overview window
:p.PC/2's Desktop overview window displays a sized image of all windows available on
all Virtual Desktops and allows direct manipulation.
Of course PC/2's overview window must be enabled before it is displayed..
The overview window is controlled by smarticons, located at the top of the window.
The currently active smarticon is framed and pressed. If mouse button 2 is pressed
on a window the action corresponding to the active smarticon is performed.
:p.To perform actions on the windows displayed in PC/2's Desktop overview window, the
following smarticons may be used:
:dl tsize=12 break=fit.
:dthd.:hp8.Icon&colon.
:ddhd.Description&colon.:ehp8.
:dt.:artwork name='Exit.bmp' runin align=left.:hp9.Exit PC/2:ehp9.
:dd.Click on this smarticon to exit PC/2.
:dt.:artwork name='Move.bmp' runin align=left.:hp9.Move window:ehp9.
:dd.Selecting this icon changes the cursor to a window pointer cursor, allowing you
to select and move a window by clicking and holding mouse button 2.
:dt.:artwork name='Top.bmp' runin align=left.:hp9.Set to top:ehp9.
:dd.Selecting this icon changes the cursor to a cross wires cursor, allowing you to
move a window on the top of the Desktop by clicking mouse button 2 onto it.
:dt.:artwork name='Bottom.bmp' runin align=left.:hp9.Set to bottom:ehp9.
:dd.Selecting this icon changes the cursor to a cross wires cursor, allowing you to
move a window to the bottom of the Desktop by clicking mouse button 2 onto it.
:dt.:artwork name='Close.bmp' runin align=left.:hp9.Kill a session:ehp9.
:dd.Selecting this icon changes the cursor to a cross wires cursor, allowing you to
terminate a window by clicking mouse button 2 onto it.
:dt.:artwork name='Maximize.bmp' runin align=left.:hp9.Maximize window:ehp9.
:dd.Selecting this icon changes the cursor to a cross wires cursor, allowing you to
maximize a window by clicking mouse botton 2 onto it.
:dt.:artwork name='Minimize.bmp' runin align=left.:hp9.Minimize window:ehp9.
:dd.Selecting this icon changes the cursor to a cross wires cursor, allowing you to
minimize a window by clicking mouse botton 2 onto it.
:dt.:artwork name='Restore.bmp' runin align=left.:hp9.Restore window:ehp9.
:dd.Selecting this icon changes the cursor to a cross wires cursor, allowing you to
restore a window by clicking mouse botton 2 onto it.
:dt.:artwork name='ShutDown.bmp' runin align=left.:hp9.ShutDown OS/2:ehp9.
:dd.Selecting this icon changes the cursor to a window pointer cursor and displays
a message box asking to continue ShutDown of OS/2.
:dt.:artwork name='Help.bmp' runin align=left.:hp9.PC/2 Help:ehp9.
:dd.Selecting this icon changes the cursor to a window pointer cursor and displays
PC/2's online help you are reading now.
:edl.
:p.:link reftype=hd res=&ID_DESKTOPDIALOG..<Backward>:elink.
                                :link reftype=hd res=&ID_ERRORHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected error help.                                                        *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_ERRORHELP..Help for PC/2 Errors
:p.PC/2 can't verify all user input for validity, so some user input may cause
some PC/2 functions to fail. In this case, a message box is displayed containing
the module and the sourcecode linenumber that failed. Also a error message is
displayed containing which error occured and what should be done to resolve the
problem.
:p.F.e. you might have configured to start the program :hp4.VIEW.EXE:ehp4. by
writing :hp4.c&colon.\os3\view.exe:ehp4. in the entryfield :hp9.Path and Filename:ehp9.
in the Program Installation dialog. This of course leads to an error, because when
OS/2 tries to start this item, it can't find the directory :hp4.\os3\:ehp4. simply
because it should read :hp4.\os2\:ehp4.. A message box is displayed saying an
error occured and that the user input should be corrected.
:p.The messagebox has three buttons that may be pressed:
:dl tsize=12 break=fit.
:dthd.:hp8.Button&colon.
:ddhd.Result&colon.:ehp8.
:dt.:hp8.Abort:ehp8.
:dd.PC/2 will be terminated and all unsaved data will be lost. You have to restart
PC\2 again. This button should be the last one you select.
:dt.:hp8.Retry:ehp8.
:dd.The error is ignored, you may need to correct your data entered in the entryfields.
:dt.:hp8.Ignore:ehp8.
:dd.The error is ignored, you may need to correct your data entered in the entryfields.
:edl.
:p.:link reftype=hd res=&ID_OVERVIEWHELP..<Backward>:elink.
                                :link reftype=hd res=&ID_HELP..<Forward>:elink.

:euserdoc.

