/* extern.h
 * External routine and variable definitions for the file conversion package.
 *
 * Peter Webb, Summer 1990
 */

#ifndef extern_h
#define extern_h

#ifdef XGUI

/* Include X files, just in case */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#endif

/* Include global definitions */

#include "reformat.h"
#include "types.h"
#include "error.h"

/* Global (package-wide) variables */

/* init_widgets.c */

#ifdef XGUI

extern Widget MsgOut;

#endif

/* In window.c */

#ifdef XGUI

extern XrmDatabase resourceBase;  /* Fully merged resource data base */
extern Display *AppDisplay;
extern int AppScreen;
extern int screen;
extern Visual *visual;
extern char *InputFiles;
extern int ResetFileOnCd;
extern char *EmptyList[];
extern Widget AppShell;

#endif 

extern char HelpFile[FILE_SIZE];

/* In reformat.c */

extern char *ProcName;
extern CvtBlkPtr CvtList;
extern char ScratchBuf[BUF_SIZE];
extern char InputDirectory[FILE_SIZE];
extern char OutputDirectory[FILE_SIZE];
extern int PrintInfo;
extern int Debug;
extern int CompressHDF;
extern long Height, Width;

/* In cmdline.c */

extern FileCvt FileTypeMap[];

/* In callback.c */

extern int DescendDirectories;

/* External functions */

extern char *strsave(), *strchr(), *strrchr();
extern CvtBlkPtr NewCvtBlk();

#ifdef XGUI

/* confirm.c */

extern Boolean GetConfirmation();

#endif

/* window.c */

extern void WriteOutputMsg();

/* utils.c */

extern StrListPtr NewStrListElt();
extern ErrorCode FullInputPath();
extern ErrorCode FullOutputPath();
extern long power();
extern int OverWrite();
extern int FileExists();
extern char *NewTempFile();

/* error.c */

extern ErrorCode err_msg();

/* callback.c */

extern void ConvertCallBack();
extern void QuitCallBack();
extern void HelpCallBack();
extern void HelpToggleCallBack();
extern void HelpSearchCallBack();
extern void FileListCallBack();
extern void CompressYesNoCallBack();
extern void FileTypeCallBack();
extern void HelpQuitCallBack();
extern void ScrollDialogText();

/* dialog.c */

extern void DialogNewString();
extern void DialogForwardChar();
extern void DialogBackwardChar();
extern void DialogInsertChar();
extern void DialogDeleteChar();
extern void DialogFocusIn();
extern void DialogFocusOut();

/* init_widgets.c */

extern void InitWidgets();

/* Each of these is in its own seperate file */

extern ErrorCode WriteHDF();
extern ErrorCode WriteFITS();
extern ErrorCode WriteGIF();
extern ErrorCode WriteXWD();
extern ErrorCode WriteTIFF();
extern ErrorCode WriteRaw8();
extern ErrorCode WriteSunrast();

/* raw8tori8.c */

extern ErrorCode Raw8ToRI8();

/* xwdtori8.c */

extern ErrorCode XWDToRI8();

/* sun2ri8.c */

extern ErrorCode SunToRI8();

/* tifftori8.c */

extern ErrorCode TiffToRI8();

/* gif2ri8.c */

extern ErrorCode GIFToRI8();

/* pict2ri8.c */

extern ErrorCode PictToRI8();

/* fits2hdf.c */

extern ErrorCode FitsToHDF();

/* append_type.c */

extern ErrorCode AppendType();
extern ErrorCode LastPathElement();
extern FileType WhatFileType();

#endif

