/* write_raw8.c
 * Write data out to a raw 8-bit file.
 *
 * Peter Webb, Summer 1990.
 */

#include <stdio.h>

/* Package include files */

#include "reformat.h"
#include "types.h"
#include "extern.h"
#include "error.h"

/* Write out a raw 8-bit file */

ErrorCode WriteRaw8(info)
  FileInfo *info;
{
  FILE *fp;

  if (info == NULL) return(err_msg(WriteRaw8File, NullPtr));

/* Open the file */

  fp = fopen(info->name);
  if (fp == NULL) return(err_msg(WriteRaw8File, OutputOpenFailed));

/* Write the data, in one huge chunk.  No padding, nothing. */

  if (fwrite(info->image, sizeof(byte), info->height * info->width, fp)
      != info->height * info->width)
    {
      free(info->image);
      return(err_msg(WriteRaw8File, FileSystemError));
    }

  fclose(fp);

  return(AllOk);
}


