/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1994  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.7 of 15-Sep-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * const.h ---	constants determining size and other parameters of system
 * (duz 09Jul93)
 */

#ifndef __CONST_H
#define	__CONST_H

/* Configuration defaults, change to taste: */

#define	TOTAL_SIZE	0x80000	/* size of system altogether */
#define	STACK_SIZE	0	/* 0 -> TOTAL_SIZE / 8 */
#define	FLT_STACK_SIZE	0	/* 0 -> TOTAL_SIZE / 16 */
#define	RET_STACK_SIZE	0	/* 0 -> TOTAL_SIZE / 16 */
#define	MAX_FILES	0x10	/* maximum number of open files */
#define	MIN_HOLD	0x100	/* minimum space for <# # #S HOLD #> etc. */
#define	MIN_PAD		0x400	/* minimum free space in PAD */
#define POCKETS		8	/* number of buffers and */
#define	POCKET_SIZE	0x100	/* size of buffers for interpretation of S" */
#define	HISTORY_SIZE	0x1000	/* size of command line history buffer */
#define	ORDER_LEN	16	/* maximum word lists in search order */
#define	LD_LOCALS	5	/* 2^n is number of local variables allowed */
#define	LD_THREADS	5	/* 2^n is number of threads in words list */
#define	PREFIX_HEX	'$'	/* 0 or prefix for input of hex numbers */
#define	PREFIX_BINARY	'%'	/* 0 or prefix for input of binary numbers */
#define	TEXT_COLS	80	/* in case pfe fails determining screen size */
#define	TEXT_ROWS	25	/* dito */
#define	CAPS_ON		0	/* do you like (faked) caps lock by default? */
#define	LOWER_CASE_ON	1	/* allow "dup" to find "DUP" by default */
#define LWRCASE_FN_ON	1	/* convert file names to lower case? */
#define FLOAT_INPUT_ON	1	/* allow input of floating point numbers */
#define	NO_COMPLETION	0	/* 1 if you don't like completion feature */
#define	EDITOR		"emacs"	/* preferred editor for text files, */
				/* env-variable EDITOR overrides this */
#define	LOGNAME		"you"	/* if your machine has no env-variable */
				/* LOGNAME, put your name here */
#define	ED_TABW		4	/* width of tab steps in block editor */

#if defined (EMX)
#define	PATH_DELIMITER	';'	/* separates path names in a paths list */
#define	DIR_DELIMITER	'\\'	/* separates directories in a path */
#define INC_PATHS	";\\PFE\\INCLUDE\\"
#define INC_EXTENSIONS	";.PFE;.4;.4TH;.FTH"
#define BLK_PATHS	INC_PATHS
#define BLK_EXTENSIONS	";.BLK;.SCR"
#define PFERC_FILE	"PFE0.RC"
#define DEFAULT_BLKFILE	"PFE.BLK"
#define LLCMD		"DIR"
#define LSCMD		"DIR /W"
#else
#define	PATH_DELIMITER	':'	/* separates path names in a paths list */
#define	DIR_DELIMITER	'/'	/* separates directories in a path */
#define INC_PATHS	":/usr/local/lib/pfe/:~/.pfe/"
#define INC_EXTENSIONS	":.pfe:.4:.4th:.fth:.forth"
#define BLK_PATHS	INC_PATHS
#define BLK_EXTENSIONS	":.blk:.scr"
#define PFERC_FILE	"~/.pferc"
#define DEFAULT_BLKFILE	"pfe.blk"
#define LLCMD		"ls -alF"
#define LSCMD		"ls -C"
#endif


/*
 * Decompiler style. Each 5 comma separated numbers, meaning:
 * additional spaces after print,
 * cr before print, changed indentation for first cr,
 * cr after print, changed indentation for second cr.
 */

#define	DEFAULT_STYLE	0, 0,  0, 0,  0
#define	LOCALS_STYLE	0, 0,  0, 1,  0
#define	SEMICOLON_STYLE	0, 0, -4, 0,  0
#define	DOES_STYLE	0, 1, -4, 0,  4

#define	IF_STYLE	1, 1,  0, 0,  4
#define	ELSE_STYLE	1, 1, -4, 1,  4
#define	THEN_STYLE	1, 1, -4, 1,  0

#define	BEGIN_STYLE	1, 1,  0, 0,  4
#define	WHILE_STYLE	1, 1, -4, 0,  4
#define	REPEAT_STYLE	1, 1, -4, 1,  0
#define	UNTIL_STYLE	1, 1, -4, 1,  0
#define	AGAIN_STYLE	1, 1, -4, 1,  0

#define	DO_STYLE	1, 1,  0, 0,  4
#define	LOOP_STYLE	1, 1, -4, 1,  0

#define	CASE_STYLE	1, 1,  0, 0,  4
#define	OF_STYLE	1, 1,  0, 0,  4
#define	ENDOF_STYLE	0, 0,  0, 1, -4
#define	ENDCASE_STYLE	0, 1, -4, 1,  0


/* other constants, do not change! */

#define	VERSION		"0.9.7"
#define	DATE		"15-Sep-94"

#undef TRUE
#define	TRUE		((Cell)-1)

#undef FALSE
#define	FALSE		((Cell)0)

#define	SMUDGED		0x20	/* these bits are flags in */
#define	IMMEDIATE	0x40	/* the count byte of a definition */

#define	TIB_SIZE	0x100	/* size of terminal input buffer */
#define	BPBUF		0x400	/* bytes per block */

#define	MAX_LOCALS	(1<<LD_LOCALS)
#define	THREADS		(1<<LD_THREADS)

/* Readable macros for magic numbers suggested by spc@pineal.math.fau.edu */

#if HIGHBYTE_FIRST
#define	MAKE_MAGIC(A,B,C,D)	((Cell)A << 24 | (Cell)B << 16 |\
				 (Cell)C <<  8 | (Cell)D)
#else
#define	MAKE_MAGIC(A,B,C,D)	((Cell)D << 24 | (Cell)C << 16 |\
				 (Cell)B <<  8 | (Cell)A)
#endif

#define	SAVE_MAGIC	MAKE_MAGIC('P','F','E','S')
#define	EXCEPTION_MAGIC	MAKE_MAGIC('X','C','P','T')
#define	INPUT_MAGIC	MAKE_MAGIC('S','V','I','N')
#define	DEST_MAGIC	MAKE_MAGIC('D','E','S','T')
#define	ORIG_MAGIC	MAKE_MAGIC('O','R','I','G')
#define	LOOP_MAGIC	MAKE_MAGIC('L','O','O','P')
#define	CASE_MAGIC	MAKE_MAGIC('C','A','S','E')
#define	OF_MAGIC	MAKE_MAGIC('O','F','O','F')
#define SEMANT_MAGIC	MAKE_MAGIC('S','E','M','A')

/* THROW codes */

#define	THROW_ABORT		-1
#define	THROW_ABORT_QUOTE	-2
#define	THROW_STACK_OVER	-3
#define	THROW_STACK_UNDER	-4
#define	THROW_RSTACK_OVER	-5
#define	THROW_RSTACK_UNDER	-6
#define	THROW_INVALID_MEMORY	-9
#define	THROW_ARG_TYPE		-12
#define	THROW_UNDEFINED		-13
#define	THROW_COMPILE_ONLY	-14
#define	THROW_INVALID_FORGET	-15
#define	THROW_ZERO_NAME		-16
#define	THROW_PICNUM_OVER	-17
#define	THROW_PARSE_OVER	-18
#define	THROW_NAME_TOO_LONG	-19
#define	THROW_UNSUPPORTED	-21
#define	THROW_CONTROL_MISMATCH	-22
#define	THROW_ADDRESS_ALIGNMENT	-23
#define	THROW_USER_INTERRUPT	-28
#define	THROW_COMPILER_NESTING	-29
#define	THROW_INVALID_NAME	-32
#define	THROW_BLOCK_READ	-33
#define	THROW_BLOCK_WRITE	-34
#define	THROW_INVALID_BLOCK	-35
#define	THROW_FILE_ERROR	-37
#define	THROW_FILE_NEX		-38
#define	THROW_UNEXPECTED_EOF	-39
#define	THROW_FSTACK_OVER	-44
#define	THROW_FSTACK_UNDER	-45
#define	THROW_CURRENT_DELETED	-47
#define	THROW_SEARCH_OVER	-49
#define	THROW_SEARCH_UNDER	-50
#define	THROW_FLOATING_POINT	-55
#define	THROW_QUIT		-56
#define	THROW_IF_ELSE		-58

#define	THROW_NO_BINARY		-2048
#define	THROW_BIN_TOO_BIG	-2049
#define	THROW_OUT_OF_MEMORY	-2050
#define	THROW_INDEX_RANGE	-2051

#endif
