# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class KeyVaultSecretStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the Key Vault secret.
    """

    INITIALIZED = "Initialized"
    WAITING_ON_CERTIFICATE_ORDER = "WaitingOnCertificateOrder"
    SUCCEEDED = "Succeeded"
    CERTIFICATE_ORDER_FAILED = "CertificateOrderFailed"
    OPERATION_NOT_PERMITTED_ON_KEY_VAULT = "OperationNotPermittedOnKeyVault"
    AZURE_SERVICE_UNAUTHORIZED_TO_ACCESS_KEY_VAULT = "AzureServiceUnauthorizedToAccessKeyVault"
    KEY_VAULT_DOES_NOT_EXIST = "KeyVaultDoesNotExist"
    KEY_VAULT_SECRET_DOES_NOT_EXIST = "KeyVaultSecretDoesNotExist"
    UNKNOWN_ERROR = "UnknownError"
    EXTERNAL_PRIVATE_KEY = "ExternalPrivateKey"
    UNKNOWN = "Unknown"
