# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ModelResult(Model):
    """Result of a model status query operation.

    :param model_id: Get or set model identifier.
    :type model_id: str
    :param status: Get or set the status of model. Possible values include:
     'created', 'ready', 'invalid'
    :type status: str or ~azure.cognitiveservices.formrecognizer.models.enum
    :param created_date_time: Get or set the created date time of the model.
    :type created_date_time: datetime
    :param last_updated_date_time: Get or set the model last updated datetime.
    :type last_updated_date_time: datetime
    """

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
    }

    def __init__(self, *, model_id: str=None, status=None, created_date_time=None, last_updated_date_time=None, **kwargs) -> None:
        super(ModelResult, self).__init__(**kwargs)
        self.model_id = model_id
        self.status = status
        self.created_date_time = created_date_time
        self.last_updated_date_time = last_updated_date_time
