# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.cognitiveservices import CognitiveServicesManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCognitiveServicesManagementAccountsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CognitiveServicesManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_accounts_begin_create(self, resource_group):
        response = self.client.accounts.begin_create(
            resource_group_name=resource_group.name,
            account_name="str",
            account={
                "etag": "str",
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "kind": "str",
                "location": "str",
                "name": "str",
                "properties": {
                    "abusePenalty": {"action": "str", "expiration": "2020-02-20 00:00:00", "rateLimitPercentage": 0.0},
                    "allowProjectManagement": bool,
                    "allowedFqdnList": ["str"],
                    "amlWorkspace": {"identityClientId": "str", "resourceId": "str"},
                    "apiProperties": {
                        "aadClientId": "str",
                        "aadTenantId": "str",
                        "eventHubConnectionString": "str",
                        "qnaAzureSearchEndpointId": "str",
                        "qnaAzureSearchEndpointKey": "str",
                        "qnaRuntimeEndpoint": "str",
                        "statisticsEnabled": bool,
                        "storageAccountConnectionString": "str",
                        "superUser": "str",
                        "websiteName": "str",
                    },
                    "associatedProjects": ["str"],
                    "callRateLimit": {
                        "count": 0.0,
                        "renewalPeriod": 0.0,
                        "rules": [
                            {
                                "count": 0.0,
                                "dynamicThrottlingEnabled": bool,
                                "key": "str",
                                "matchPatterns": [{"method": "str", "path": "str"}],
                                "minCount": 0.0,
                                "renewalPeriod": 0.0,
                            }
                        ],
                    },
                    "capabilities": [{"name": "str", "value": "str"}],
                    "commitmentPlanAssociations": [{"commitmentPlanId": "str", "commitmentPlanLocation": "str"}],
                    "customSubDomainName": "str",
                    "dateCreated": "str",
                    "defaultProject": "str",
                    "deletionDate": "str",
                    "disableLocalAuth": bool,
                    "dynamicThrottlingEnabled": bool,
                    "encryption": {
                        "keySource": "Microsoft.KeyVault",
                        "keyVaultProperties": {
                            "identityClientId": "str",
                            "keyName": "str",
                            "keyVaultUri": "str",
                            "keyVersion": "str",
                        },
                    },
                    "endpoint": "str",
                    "endpoints": {"str": "str"},
                    "internalId": "str",
                    "isMigrated": bool,
                    "locations": {
                        "regions": [{"customsubdomain": "str", "name": "str", "value": 0.0}],
                        "routingMethod": "str",
                    },
                    "migrationToken": "str",
                    "networkAcls": {
                        "bypass": "str",
                        "defaultAction": "str",
                        "ipRules": [{"value": "str"}],
                        "virtualNetworkRules": [
                            {"id": "str", "ignoreMissingVnetServiceEndpoint": bool, "state": "str"}
                        ],
                    },
                    "networkInjections": [
                        {"scenario": "str", "subnetArmId": "str", "useMicrosoftManagedNetwork": bool}
                    ],
                    "privateEndpointConnections": [
                        {
                            "etag": "str",
                            "id": "str",
                            "location": "str",
                            "name": "str",
                            "properties": {
                                "privateLinkServiceConnectionState": {
                                    "actionsRequired": "str",
                                    "description": "str",
                                    "status": "str",
                                },
                                "groupIds": ["str"],
                                "privateEndpoint": {"id": "str"},
                                "provisioningState": "str",
                            },
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "publicNetworkAccess": "str",
                    "quotaLimit": {
                        "count": 0.0,
                        "renewalPeriod": 0.0,
                        "rules": [
                            {
                                "count": 0.0,
                                "dynamicThrottlingEnabled": bool,
                                "key": "str",
                                "matchPatterns": [{"method": "str", "path": "str"}],
                                "minCount": 0.0,
                                "renewalPeriod": 0.0,
                            }
                        ],
                    },
                    "raiMonitorConfig": {"adxStorageResourceId": "str", "identityClientId": "str"},
                    "restore": bool,
                    "restrictOutboundNetworkAccess": bool,
                    "scheduledPurgeDate": "str",
                    "skuChangeInfo": {
                        "countOfDowngrades": 0.0,
                        "countOfUpgradesAfterDowngrades": 0.0,
                        "lastChangeDate": "str",
                    },
                    "storedCompletionsDisabled": bool,
                    "userOwnedStorage": [{"identityClientId": "str", "resourceId": "str"}],
                },
                "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_accounts_begin_update(self, resource_group):
        response = self.client.accounts.begin_update(
            resource_group_name=resource_group.name,
            account_name="str",
            account={
                "etag": "str",
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "kind": "str",
                "location": "str",
                "name": "str",
                "properties": {
                    "abusePenalty": {"action": "str", "expiration": "2020-02-20 00:00:00", "rateLimitPercentage": 0.0},
                    "allowProjectManagement": bool,
                    "allowedFqdnList": ["str"],
                    "amlWorkspace": {"identityClientId": "str", "resourceId": "str"},
                    "apiProperties": {
                        "aadClientId": "str",
                        "aadTenantId": "str",
                        "eventHubConnectionString": "str",
                        "qnaAzureSearchEndpointId": "str",
                        "qnaAzureSearchEndpointKey": "str",
                        "qnaRuntimeEndpoint": "str",
                        "statisticsEnabled": bool,
                        "storageAccountConnectionString": "str",
                        "superUser": "str",
                        "websiteName": "str",
                    },
                    "associatedProjects": ["str"],
                    "callRateLimit": {
                        "count": 0.0,
                        "renewalPeriod": 0.0,
                        "rules": [
                            {
                                "count": 0.0,
                                "dynamicThrottlingEnabled": bool,
                                "key": "str",
                                "matchPatterns": [{"method": "str", "path": "str"}],
                                "minCount": 0.0,
                                "renewalPeriod": 0.0,
                            }
                        ],
                    },
                    "capabilities": [{"name": "str", "value": "str"}],
                    "commitmentPlanAssociations": [{"commitmentPlanId": "str", "commitmentPlanLocation": "str"}],
                    "customSubDomainName": "str",
                    "dateCreated": "str",
                    "defaultProject": "str",
                    "deletionDate": "str",
                    "disableLocalAuth": bool,
                    "dynamicThrottlingEnabled": bool,
                    "encryption": {
                        "keySource": "Microsoft.KeyVault",
                        "keyVaultProperties": {
                            "identityClientId": "str",
                            "keyName": "str",
                            "keyVaultUri": "str",
                            "keyVersion": "str",
                        },
                    },
                    "endpoint": "str",
                    "endpoints": {"str": "str"},
                    "internalId": "str",
                    "isMigrated": bool,
                    "locations": {
                        "regions": [{"customsubdomain": "str", "name": "str", "value": 0.0}],
                        "routingMethod": "str",
                    },
                    "migrationToken": "str",
                    "networkAcls": {
                        "bypass": "str",
                        "defaultAction": "str",
                        "ipRules": [{"value": "str"}],
                        "virtualNetworkRules": [
                            {"id": "str", "ignoreMissingVnetServiceEndpoint": bool, "state": "str"}
                        ],
                    },
                    "networkInjections": [
                        {"scenario": "str", "subnetArmId": "str", "useMicrosoftManagedNetwork": bool}
                    ],
                    "privateEndpointConnections": [
                        {
                            "etag": "str",
                            "id": "str",
                            "location": "str",
                            "name": "str",
                            "properties": {
                                "privateLinkServiceConnectionState": {
                                    "actionsRequired": "str",
                                    "description": "str",
                                    "status": "str",
                                },
                                "groupIds": ["str"],
                                "privateEndpoint": {"id": "str"},
                                "provisioningState": "str",
                            },
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "publicNetworkAccess": "str",
                    "quotaLimit": {
                        "count": 0.0,
                        "renewalPeriod": 0.0,
                        "rules": [
                            {
                                "count": 0.0,
                                "dynamicThrottlingEnabled": bool,
                                "key": "str",
                                "matchPatterns": [{"method": "str", "path": "str"}],
                                "minCount": 0.0,
                                "renewalPeriod": 0.0,
                            }
                        ],
                    },
                    "raiMonitorConfig": {"adxStorageResourceId": "str", "identityClientId": "str"},
                    "restore": bool,
                    "restrictOutboundNetworkAccess": bool,
                    "scheduledPurgeDate": "str",
                    "skuChangeInfo": {
                        "countOfDowngrades": 0.0,
                        "countOfUpgradesAfterDowngrades": 0.0,
                        "lastChangeDate": "str",
                    },
                    "storedCompletionsDisabled": bool,
                    "userOwnedStorage": [{"identityClientId": "str", "resourceId": "str"}],
                },
                "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_accounts_begin_delete(self, resource_group):
        response = self.client.accounts.begin_delete(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_accounts_get(self, resource_group):
        response = self.client.accounts.get(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_accounts_list_by_resource_group(self, resource_group):
        response = self.client.accounts.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_accounts_list(self, resource_group):
        response = self.client.accounts.list(
            api_version="2025-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_accounts_list_keys(self, resource_group):
        response = self.client.accounts.list_keys(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_accounts_regenerate_key(self, resource_group):
        response = self.client.accounts.regenerate_key(
            resource_group_name=resource_group.name,
            account_name="str",
            key_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_accounts_list_skus(self, resource_group):
        response = self.client.accounts.list_skus(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_accounts_list_usages(self, resource_group):
        response = self.client.accounts.list_usages(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_accounts_list_models(self, resource_group):
        response = self.client.accounts.list_models(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2025-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
