/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.disassembler;

import java.util.ArrayList;

public final class Signature {
    private TypeFormatter formatter;
    private String signature;
    private int sigLength;
    private int parsePosition;
    private String type;
    private boolean isMethod;
    private ArrayList parameters = new ArrayList();
    private int parameterCount;
    private final String[] ARRAYS = new String[]{null, "[]", "[][]", "[][][]", "[][][][]", "[][][][][]", "[][][][][][]", "[][][][][][][]", "[][][][][][][][]", "[][][][][][][][][]", "[][][][][][][][][][]"};

    public Signature(TypeFormatter formatter) {
        this.formatter = formatter;
    }

    public void setSignature(String sig) {
        this.signature = sig;
        this.parsePosition = 0;
        this.sigLength = sig.length();
        this.parameterCount = 0;
        if (sig.charAt(0) == '(') {
            this.isMethod = true;
            this.parseMethod();
        } else {
            this.isMethod = false;
            this.parseType();
        }
    }

    public void parseType() {
        this.type = this.nextType();
        if (this.hasMore()) {
            throw new IllegalArgumentException("Simple type not fully parsed: " + this.signature);
        }
    }

    public boolean hasMore() {
        return this.parsePosition < this.sigLength;
    }

    private String nextType() {
        int i;
        String type = "ERROR";
        int arrays = 0;
        block15: for (i = this.parsePosition; i < this.sigLength; ++i) {
            char c = this.signature.charAt(i);
            switch (c) {
                case 'B': {
                    type = "byte";
                    break;
                }
                case 'C': {
                    type = "char";
                    break;
                }
                case 'D': {
                    type = "double";
                    break;
                }
                case 'F': {
                    type = "float";
                    break;
                }
                case 'I': {
                    type = "int";
                    break;
                }
                case 'J': {
                    type = "long";
                    break;
                }
                case 'S': {
                    type = "short";
                    break;
                }
                case 'Z': {
                    type = "boolean";
                    break;
                }
                case 'V': {
                    type = "void";
                    break;
                }
                case 'L': {
                    int semiPos = this.signature.indexOf(59, i + 1);
                    type = this.signature.substring(i + 1, semiPos);
                    type = this.getFormattedType(type);
                    i = semiPos;
                    break;
                }
                case '[': {
                    ++arrays;
                    continue block15;
                }
                case '(': {
                    if (!this.isMethod()) {
                        throw new IllegalArgumentException("Unexpected: ) in " + this.signature);
                    }
                    type = "(";
                    break;
                }
                case ')': {
                    if (!this.isMethod()) {
                        throw new IllegalArgumentException("Unexpected: ) in " + this.signature);
                    }
                    type = ")";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: '" + c + "'");
                }
            }
            ++i;
            break;
        }
        this.parsePosition = i;
        if (arrays > 0) {
            StringBuffer buf = new StringBuffer(arrays << 2 + type.length());
            buf.append(type).append(this.ARRAYS[arrays]);
            type = buf.toString();
        }
        return type;
    }

    private String getFormattedType(String type) {
        if (this.formatter != null) {
            type = this.formatter.getFormattedType(type);
        }
        return type;
    }

    private void parseMethod() {
        String type = this.nextType();
        if (!"(".equals(type)) {
            throw new IllegalArgumentException("Method sig must begin with '(': " + this.signature);
        }
        this.parameters.clear();
        while (!")".equals(type = this.nextType())) {
            ++this.parameterCount;
            this.parameters.add(type);
        }
        this.type = this.nextType();
    }

    public boolean isMethod() {
        return this.isMethod;
    }

    public String getType() {
        return this.type;
    }

    public int getParameterCount() {
        if (!this.isMethod()) {
            throw new IllegalArgumentException("Not a method: " + this.signature);
        }
        return this.parameterCount;
    }

    public String getParameter(int n) {
        if (!this.isMethod()) {
            throw new IllegalArgumentException("Not a method: " + this.signature);
        }
        if (n < 0 || n > this.getParameterCount()) {
            throw new IllegalArgumentException("No such parameter: " + n);
        }
        return (String)this.parameters.get(n);
    }

    public static interface TypeFormatter {
        public String getFormattedType(String var1);
    }
}

