# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class ClusterTypes(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Cluster types
    """

    CONNECTED_CLUSTERS = "connectedClusters"
    MANAGED_CLUSTERS = "managedClusters"

class ComplianceStateType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The compliance state of the configuration.
    """

    PENDING = "Pending"
    COMPLIANT = "Compliant"
    NONCOMPLIANT = "Noncompliant"
    INSTALLED = "Installed"
    FAILED = "Failed"

class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class ExtensionsClusterResourceName(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    MANAGED_CLUSTERS = "managedClusters"
    CONNECTED_CLUSTERS = "connectedClusters"

class ExtensionsClusterRp(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    MICROSOFT_CONTAINER_SERVICE = "Microsoft.ContainerService"
    MICROSOFT_KUBERNETES = "Microsoft.Kubernetes"

class FluxComplianceState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Compliance state of the cluster object.
    """

    COMPLIANT = "Compliant"
    NON_COMPLIANT = "Non-Compliant"
    PENDING = "Pending"
    SUSPENDED = "Suspended"
    UNKNOWN = "Unknown"

class KustomizationValidationType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Specify whether to validate the Kubernetes objects referenced in the Kustomization before
    applying them to the cluster.
    """

    NONE = "none"
    CLIENT = "client"
    SERVER = "server"

class LevelType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Level of the status.
    """

    ERROR = "Error"
    WARNING = "Warning"
    INFORMATION = "Information"

class MessageLevelType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Level of the message.
    """

    ERROR = "Error"
    WARNING = "Warning"
    INFORMATION = "Information"

class OperatorScopeType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Scope at which the operator will be installed.
    """

    CLUSTER = "cluster"
    NAMESPACE = "namespace"

class OperatorType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the operator
    """

    FLUX = "Flux"

class ProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of the resource.
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"

class ProvisioningStateType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of the resource provider.
    """

    ACCEPTED = "Accepted"
    DELETING = "Deleting"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class ScopeType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Scope at which the configuration will be installed.
    """

    CLUSTER = "cluster"
    NAMESPACE = "namespace"

class SourceKindType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Source Kind to pull the configuration data from.
    """

    GIT_REPOSITORY = "GitRepository"
    BUCKET = "Bucket"
