# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.desktopvirtualization import DesktopVirtualizationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDesktopVirtualizationMgmtWorkspacesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DesktopVirtualizationMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.workspaces.get(
            resource_group_name=resource_group.name,
            workspace_name="str",
            api_version="2024-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update(self, resource_group):
        response = self.client.workspaces.create_or_update(
            resource_group_name=resource_group.name,
            workspace_name="str",
            workspace={
                "location": "str",
                "applicationGroupReferences": ["str"],
                "cloudPcResource": bool,
                "description": "str",
                "etag": "str",
                "friendlyName": "str",
                "id": "str",
                "identity": {"principalId": "str", "tenantId": "str", "type": "SystemAssigned"},
                "kind": "str",
                "managedBy": "str",
                "name": "str",
                "objectId": "str",
                "plan": {"name": "str", "product": "str", "publisher": "str", "promotionCode": "str", "version": "str"},
                "privateEndpointConnections": [
                    {
                        "groupIds": ["str"],
                        "id": "str",
                        "name": "str",
                        "privateEndpoint": {"id": "str"},
                        "privateLinkServiceConnectionState": {
                            "actionsRequired": "str",
                            "description": "str",
                            "status": "str",
                        },
                        "provisioningState": "str",
                        "systemData": {
                            "createdAt": "2020-02-20 00:00:00",
                            "createdBy": "str",
                            "createdByType": "str",
                            "lastModifiedAt": "2020-02-20 00:00:00",
                            "lastModifiedBy": "str",
                            "lastModifiedByType": "str",
                        },
                        "type": "str",
                    }
                ],
                "publicNetworkAccess": "str",
                "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete(self, resource_group):
        response = self.client.workspaces.delete(
            resource_group_name=resource_group.name,
            workspace_name="str",
            api_version="2024-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.workspaces.update(
            resource_group_name=resource_group.name,
            workspace_name="str",
            api_version="2024-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.workspaces.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-04-03",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_subscription(self, resource_group):
        response = self.client.workspaces.list_by_subscription(
            api_version="2024-04-03",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
