/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.Runtime;
import alt.jiapi.instrumentor.ChainInstrumentor;
import alt.jiapi.instrumentor.Instrumentation;
import alt.jiapi.instrumentor.InstrumentorChain;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiClass;
import org.apache.log4j.Category;

public abstract class AbstractInstrumentor
implements ChainInstrumentor {
    private Instrumentation instrumentation;
    private static Category log = Runtime.getLogCategory(AbstractInstrumentor.class);
    private AbstractInstrumentor child;
    private JiapiClass currentClass;

    public InstrumentorChain preInstrument() {
        return null;
    }

    public InstrumentorChain postInstrument() {
        return null;
    }

    public abstract void instrument(InstructionList var1);

    void instrument(InstructionList il, Instrumentation i) {
        log.info((Object)("Instrumenting with " + this));
        this.instrumentation = i;
        if (i == null) {
            log.error((Object)"Got null instrumentation");
        }
        this.instrument(il);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected void forward(InstructionList il) {
        if (this.child != null) {
            JiapiClass jc = this.getCurrentClass();
            this.child.setCurrentClass(jc);
            InstrumentorChain pre = this.child.preInstrument();
            if (pre != null) {
                log.debug((Object)("Pre instrumenting with " + pre));
                pre.instrument(jc);
            } else {
                log.debug((Object)(this.child + " has no need for pre-instrumentation"));
            }
            this.child.instrument(il, this.instrumentation);
            InstrumentorChain post = this.child.postInstrument();
            if (post != null) {
                log.debug((Object)("Post instrumenting with " + post));
                post.instrument(jc);
            } else {
                log.debug((Object)(this.child + " has no need for post-instrumentation"));
            }
        }
    }

    protected JiapiClass getCurrentClass() {
        return this.currentClass;
    }

    void setCurrentClass(JiapiClass clazz) {
        this.currentClass = clazz;
    }

    public Instrumentation getInstrumentation() {
        if (this.instrumentation == null) {
            log.warn((Object)("Instrumentation is null: " + this.getClass()));
        }
        return this.instrumentation;
    }

    void setDescriptorData() {
    }

    Object getDescriptorData() {
        return null;
    }

    void setContexData() {
    }

    Object getContextData() {
        return null;
    }

    void setChild(AbstractInstrumentor i) {
        this.child = i;
    }

    ChainInstrumentor getChild() {
        return this.child;
    }
}

