# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storagecache.aio import StorageCacheManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageCacheManagementStorageTargetsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageCacheManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_targets_begin_dns_refresh(self, resource_group):
        response = await (
            await self.client.storage_targets.begin_dns_refresh(
                resource_group_name=resource_group.name,
                cache_name="str",
                storage_target_name="str",
                api_version="2025-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_targets_list_by_cache(self, resource_group):
        response = self.client.storage_targets.list_by_cache(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2025-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_targets_begin_delete(self, resource_group):
        response = await (
            await self.client.storage_targets.begin_delete(
                resource_group_name=resource_group.name,
                cache_name="str",
                storage_target_name="str",
                api_version="2025-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_targets_get(self, resource_group):
        response = await self.client.storage_targets.get(
            resource_group_name=resource_group.name,
            cache_name="str",
            storage_target_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_targets_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.storage_targets.begin_create_or_update(
                resource_group_name=resource_group.name,
                cache_name="str",
                storage_target_name="str",
                storagetarget={
                    "allocationPercentage": 0,
                    "blobNfs": {"target": "str", "usageModel": "str", "verificationTimer": 0, "writeBackTimer": 0},
                    "clfs": {"target": "str"},
                    "id": "str",
                    "junctions": [
                        {"namespacePath": "str", "nfsAccessPolicy": "default", "nfsExport": "str", "targetPath": "str"}
                    ],
                    "location": "str",
                    "name": "str",
                    "nfs3": {"target": "str", "usageModel": "str", "verificationTimer": 0, "writeBackTimer": 0},
                    "provisioningState": "str",
                    "state": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "targetType": "str",
                    "type": "str",
                    "unknown": {"attributes": {"str": "str"}},
                },
                api_version="2025-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_targets_begin_restore_defaults(self, resource_group):
        response = await (
            await self.client.storage_targets.begin_restore_defaults(
                resource_group_name=resource_group.name,
                cache_name="str",
                storage_target_name="str",
                api_version="2025-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
