# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CapacityProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current deployment state of PowerBI Dedicated resource. The provisioningState is to
    indicate states for resource provisioning.
    """

    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    PAUSED = "Paused"
    SUSPENDED = "Suspended"
    PROVISIONING = "Provisioning"
    UPDATING = "Updating"
    SUSPENDING = "Suspending"
    PAUSING = "Pausing"
    RESUMING = "Resuming"
    PREPARING = "Preparing"
    SCALING = "Scaling"


class CapacitySkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the Azure pricing tier to which the SKU applies."""

    PBIE_AZURE = "PBIE_Azure"
    PREMIUM = "Premium"
    AUTO_PREMIUM_HOST = "AutoPremiumHost"


class IdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created/modified the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class Mode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the generation of the Power BI Embedded capacity. If no value is specified, the
    default value 'Gen2' is used. `Learn More
    <https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2>`_.
    """

    GEN1 = "Gen1"
    GEN2 = "Gen2"


class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of PowerBI Dedicated resource. The state is to indicate more states outside
    of resource provisioning.
    """

    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    PAUSED = "Paused"
    SUSPENDED = "Suspended"
    PROVISIONING = "Provisioning"
    UPDATING = "Updating"
    SUSPENDING = "Suspending"
    PAUSING = "Pausing"
    RESUMING = "Resuming"
    PREPARING = "Preparing"
    SCALING = "Scaling"


class VCoreProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current deployment state of an auto scale v-core resource. The provisioningState is to
    indicate states for resource provisioning.
    """

    SUCCEEDED = "Succeeded"


class VCoreSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the Azure pricing tier to which the SKU applies."""

    AUTO_SCALE = "AutoScale"
