/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	gauge.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_gauge class header
 *
 *	RCSid = "$Id: gauge.H,v 4.11.1.1 1993/06/01 22:54:36 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_gauge_H
#define OI_gauge_H

#ifndef OI_dpy_1d_H
#include <OI/dpy_1d.H>
#endif /* OI_dpy_1d_H */

	// class forward reference declarations
	class OI_mdl_gauge;

 /* upward compatible definitions for OI_display_1d inheritance */

#define		OI_gauge_ends			OI_display_1d_ends
#define		OI_gauge_ends_none		OI_display_1d_ends_none
#define		OI_gauge_ends_numeric		OI_display_1d_ends_numeric
#define		OI_gauge_ends_strings		OI_display_1d_ends_strings
#define		OI_GAUGE_ENDS_NONE		OI_display_1d_ends_none
#define		OI_GAUGE_ENDS_NUMERIC		OI_display_1d_ends_numeric
#define		OI_GAUGE_ENDS_STRINGS		OI_display_1d_ends_strings

#define		OI_gauge_ticks			OI_display_1d_ticks
#define		OI_gauge_ticks_none		OI_display_1d_ticks_none
#define		OI_gauge_ticks_ends		OI_display_1d_ticks_ends
#define		OI_gauge_ticks_all		OI_display_1d_ticks_all
#define		OI_gauge_ticks_ends_custom	OI_display_1d_ticks_ends_custom
#define		OI_GAUGE_ticks_all_custom	OI_display_1d_ticks_all_custom
#define		OI_GAUGE_TICKS_NONE		OI_DISPLAY_1D_TICKS_NONE
#define		OI_GAUGE_TICKS_ENDS		OI_DISPLAY_1D_TICKS_ENDS
#define		OI_GAUGE_TICKS_ALL		OI_DISPLAY_1D_TICKS_ALL
#define		OI_GAUGE_TICKS_ENDS_CUSTOM	OI_DISPLAY_1D_TICKS_ENDS_CUSTOM
#define		OI_GAUGE_TICKS_ALL_CUSTOM	OI_DISPLAY_1D_TICKS_ALL_CUSTOM

 /* misc definitions */
#define		OI_GAUGE_LRTB_DIRECTION	1	/* mercury moves left->right, top->bottom */
#define		OI_GAUGE_RLBT_DIRECTION	-1	/* mercury moves right->left, bottom->top */
#define		OI_GAUGE_LABEL_OFFSET	2	/* offset of tick labels from tick marks in vertical gauges */

/* private control bits */
#define		OI_GAUGE_BAR_PAINTED		0x1		/* 1 => top (unfilled) portion of bar painted */
#define		OI_GAUGE_BVL_PAINTED		0x2		/* 1 => bevel portion of gauge painted */
#define		OI_GAUGE_DOWN_PAINTED		0x4		/* 1 => down portion of gauge painted */
#define		OI_GAUGE_DECOR_PAINTED		0x8		/* 1 => general decoration of gauge painted */

	class OI_gauge : public OI_display_1d {
			OI_mdl_gauge	*mdl_dep ;		/* ptr to model dependent aspects of gauge */
			unsigned long	ctl_bits ;		/* class private control bits */
	 protected:
			OI_orient	orient ;		/* orientation */
			OI_number	bar_wid ;		/* bar width */
			OI_number	bar_sp ;		/* space between container rectangle and bar (minor axis) */
			OI_number	bar_bof_eof_sp ;	/* space before and following the bar */
			OI_number	tick_base;		/* base coordinates of tick mark. */
			OI_number	tick_len;		/* size along minor axis. */
			OI_number	tick_wid;		/* size along major axis. */
	 public:
		static	OI_class	*clsp ;			/* ptr to class record */

		friend	void		dmpOI_gauge(OI_gauge*) ;				/* diagnostic dump procedure */
	 private:
			void		construct(OI_number,OI_orient) ;
		virtual	void		clear_painted() ;
		virtual	OI_stat		create() ;
			OI_bool		is_bar_painted()	{ return((ctl_bits&OI_GAUGE_BAR_PAINTED)?OI_YES:OI_NO); }
			OI_bool		is_bvl_painted()	{ return((ctl_bits&OI_GAUGE_BVL_PAINTED)?OI_YES:OI_NO); }
			OI_bool		is_decor_painted()	{ return((ctl_bits&OI_GAUGE_DECOR_PAINTED)?OI_YES:OI_NO); }
			OI_bool		is_down_painted()	{ return((ctl_bits&OI_GAUGE_DOWN_PAINTED)?OI_YES:OI_NO); }
		virtual	void		new_connection(OI_connection*);
			void		new_orientation(OI_orient) ;
		virtual	void		paint(const XEvent*, void* =NULL) ;			/* paint gauge in screen */
		virtual	void		paint_current() ;					/* paint the current value of the gauge */
			void		paint_label() ;
		virtual	void		paint_value(long) ;
			void		set_bar_painted()	{ ctl_bits |= OI_GAUGE_BAR_PAINTED; }
			void		set_bvl_painted()	{ ctl_bits |= OI_GAUGE_BVL_PAINTED; }
			void		set_decor_painted()	{ ctl_bits |= OI_GAUGE_DECOR_PAINTED; }
			void		set_down_painted()	{ ctl_bits |= OI_GAUGE_DOWN_PAINTED; }
	 protected:
					OI_gauge(OI_class*, const char*, OI_number, OI_orient, long, long,
						const char* =NULL, OI_gauge_ends=OI_GAUGE_ENDS_NONE, const char* =NULL, const char* =NULL,
						OI_bool=OI_NO, OI_number=0, OI_gauge_ticks=OI_GAUGE_TICKS_NONE, const char* const * =NULL);
		virtual	void		new_model(OI_model_type) ;
		virtual	void		re_layout() ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_gauge(const char*, OI_number, OI_orient, long, long,
						const char* =NULL, OI_gauge_ends=OI_GAUGE_ENDS_NONE, const char* =NULL, const char* =NULL,
						 OI_bool=OI_NO,	OI_number=0, OI_gauge_ticks=OI_GAUGE_TICKS_NONE, const char* const * =NULL);
					~OI_gauge() ;
		virtual	void		font_resize();
		static	OI_bool		init(OI_connection*) ;
			OI_bool		is_write_resq(XrmQuark);
		static	OI_gauge	*make_minimal(const char*,OI_minimal_type) ;
		virtual	void		min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
			void		new_active_pixel(PIXEL) ;
		virtual	void		new_fg_pixel(PIXEL, OI_bool=OI_NO) ;
			OI_stat		new_bar_size (OI_number rng) ;
			OI_stat		new_pixel_range (OI_number rng) ;
		virtual void		new_bvl_width(OI_number);
		virtual	void		new_tick_position(OI_position);
		virtual	void		nominal_outside_size(OI_number*,OI_number*);
			void		res_bar_size(void *) ;
			void		res_bar_active_color(void *) ;
			void		res_orientation(void *) ;
			void		res_pixelRange(void *) ;
			void		resize(OI_d_tech*,void*) ;		/* resize callback */
		virtual	void		set_marker_orientation(OI_marker*);	/* Set orientation of the marker */
			OI_number	val_pix(long) ;				/* get pixel position for given value */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
			void		set_active_pixel(PIXEL) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void	clone_adjust(OI_d_tech*) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			PIXEL		active_pixel() ;
			OI_number	bar_size() ;						/* # pixels in interior of bar */
			OI_number	major_size()			{return((orient==OI_HORIZONTAL)?extent.x:extent.y) ;}
												/* # pixels along major axis */
			OI_orient	orientation()			{return(orient) ;}	/* orientation of gauge */
			OI_number	pixel_range() ;
			OI_stat		set_active_color(const char*) ;
			void		set_active_color(PIXEL) ;
			OI_stat		set_bar_size(OI_number) ;				/* set # pixels in bar interior */
			OI_stat		set_major_size(OI_number) ;				/* set major axis size */
			OI_stat		set_pixel_range(OI_number) ;				/* set # distinct pixel positions possible */
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_gauge *oi_create_gauge(const char*, OI_number, OI_orient, long, long=0, const char* =NULL, OI_gauge_ends=OI_gauge_ends_none,
			const char* =NULL, const char* =NULL, OI_bool=OI_NO, OI_number=0, OI_gauge_ticks=OI_gauge_ticks_none,
			const char* const * =NULL) ;

#endif /* OI_gauge_H */
