#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>



connectorIntoSpaceInvadersBunker : OneWayRoomConnector
	-> spaceInvadersBunker2
	noteTraversal(traveler) {
		if(traveler==gPlayerChar) {
			gPlayerChar.posture = standing;
		}
	}
;

connectorIntoSpaceInvadersShip : OneWayRoomConnector
	-> spaceInvadersShip5
	noteTraversal(traveler) {
		if(traveler==gPlayerChar) {
			gPlayerChar.posture = standing;
		}
	}
;



class SpaceInvadersCoveredBunker : Room 'inside cement bunker'
	"This is a claustrophobic cement bunker that appears to have been hastily constructed very
	recently. The ceiling is just barely high enough for you to stand up without bumping your head.
	The east and west sides of the bunker are open exits that lead out from under the bunker.
	There is a small wooden bench next to the north wall. "
//	vocabWords = 'cement bunker'
	roomParts = inherited - defaultWestWall - defaultEastWall
;

MultiInstance
	initialLocationClass = SpaceInvadersCoveredBunker
	instanceObject : Decoration {
			'cement bunker' 'bunker'
			"The cement bunker is open on the east and west sides, so clearly it's intended
			to protect the people inside it from attacks from the sky. "
		}
;


class SpaceInvadersUncoveredBunker : OutdoorRoom 'trench'
	desc {
		"It is night. You are in a dirt trench that shows signs of having been 
		hastily dug very recently.\b ";
	
		if(west!=nil && east!=nil)
			"To the east and west are open bunkers that show signs of heavy damage from above.
			Clearly they have been bombed repeatedly, but neither looks like it is in imminent
			danger of collapsing. ";
		else if(west!=nil)
			"To the west is an open bunker that shows signs of heavy damage from above.
			Clearly it has been bombed repeatedly, but it doesn't look like it is in imminent
			danger of collapsing. ";
		else if(east!=nil)
			"To the east is an open bunker that shows signs of heavy damage from above.
			Clearly it has been bombed repeatedly, but it doesn't look like it is in imminent
			danger of collapsing. ";
				
		"\bBomb craters are everywhere. The real terror appears to reside in the sky though. ";
	}
	
//	vocabWords = 'dirt trench'
	
	roomParts = static inherited - defaultSky + spaceInvadersSky
;
MultiInstance
	initialLocationClass = SpaceInvadersUncoveredBunker
	instanceObject : Decoration {
			'dirt trench' 'trench'
			"The trench was clearly dug in an attempt to gain some protection from the battleships.
			It doesn't appear to be doing much good. "
		}
;
MultiLoc,Distant 'overwhelming forces ship/battleship*ships*battleships' 'ships'
    desc {spaceInvadersSky.desc;}
	isPlural = true
	initialLocationClass = SpaceInvadersUncoveredBunker
;
MultiLoc,Decoration 'bomb landscape crater*craters' 'craters'
	"Craters pock the landscape. "
	isPlural = true
	initialLocationClass = SpaceInvadersUncoveredBunker
;
MultiLoc,Decoration '(heavy) damage*bunkers' 'bunkers'
	"The bunkers don't look like they're in good shape. "
	isPlural = true
	locationList = [spaceInvadersBunker3]
;
MultiLoc,Decoration '(heavy) damage/bunker' 'bunker'
	"The bunker doesn't look like it's in good shape. "
	locationList = [spaceInvadersBunker1,spaceInvadersBunker5]
;


spaceInvadersSky : Distant, RoomPart '(real) terror sky' 'sky'
	"Now you know what a cell feels like inside the body of someone infected by ebola.
	Overwhelming forces are arrayed in the sky. You are but one person standing beneath
	a hammer of doom. Thousands upon thousands of battleships bomb the earth continuously
	without feeling, without mercy. Genocide is upon us. "
;



spaceInvadersBunker1 : SpaceInvadersUncoveredBunker
	east = spaceInvadersBunker2
;

spaceInvadersBunker2 : SpaceInvadersCoveredBunker
	west = spaceInvadersBunker1
	east = spaceInvadersBunker3
;
+ bunker2Bench : BunkerBench;

spaceInvadersBunker3 : SpaceInvadersUncoveredBunker
	west = spaceInvadersBunker2
	east = spaceInvadersBunker4
;

spaceInvadersBunker4 : SpaceInvadersCoveredBunker
	west = spaceInvadersBunker3
	east = spaceInvadersBunker5
;
+ bunker4Bench : BunkerBench;

spaceInvadersBunker5 : SpaceInvadersUncoveredBunker
	west = spaceInvadersBunker4
;


class BunkerBench : Bed,Fixture 'small wooden/wood/bench' 'bench'
	"This is a just a simple wooden bench where, presumably, soldiers are meant to sit and relax
	to regain their strength. "
//	isListedInRoomPart = true

	// This prevents anyone from sitting or putting other things on the bench.
	bulkCapacity = 0
;



class DeadSoldier : UntakeableActor 'dead soldier/man' 'dead soldier'
	"It's a horrific site. It looks like the soldier was wounded by a small explosive blast.
	His chest is torn open and the wound is cauterized. If this were a jungle you might assume
	that a Predator had shot him. But since there are plenty of battleships in the sky above,
	it's probably safe to assume that one of them dropped a small bomb on him.
	Presumably someone carried him in here and put him on the bench because he obviously didn't
	move in here under his own power. "

	specialDesc {
		if(spaceInvadersDisc.isIn(self))
			"A dead soldier lies crumpled on the bench here. He has a disc clutched in his hand. ";
		else
			"A dead soldier lies crumpled on the bench here. ";
	}
	
	isHim = true

	curState = soldierDeadState
	
	cannotTakeMsg = 'Don\'t disturb the dead. Once the war is over the army will probably bring
		the body back to his family. In the mean time, here is as good a place as any for him. '
	cannotMoveMsg = (cannotTakeMsg)
	cannotPutMsg = (cannotTakeMsg)
	
	posture = lying
	
	dobjFor(Attack) {
		verify() {}
		check() {}
		action() {
			"You are one sick puppy! You should respect the dead. ";
		}
	}
	iobjFor(ThrowAt) {
		check() {
			replaceAction(Attack, self);
		}
	}
	
	checkTakeFromInventory(actor, obj)
	{
		return;
		//if(curState == soldierDead)
		//	return;
		//inherited(actor, obj);
	}
	
	dobjFor(Search) {
		verify() {}
		check() {}
		action() {
			"You make a search of the body, feeling the whole time how disgusting it is to be
			going through the pockets of a dead man, but you don't find anything else. ";
		}
	}
	
/*
	iobjFor(Take) {
		verify() {}
		check() {}
		action() {
			if(gDobj==spaceInvadersDisc)
				"You pry the man's fingers loose and take posession of the disc. ";
			inherited();
		}
	}
*/	
   
/*
	iobjFor(Take) {
		verify() {
			if(gDobj==spaceInvadersDisc)
				return;
			else
				inherited();
		}
		
		check() {}
		action() {}
	}
*/	
;
+ Decoration 'pocket*pockets' 'pockets'
	"The soldier's clothing is covered with pockets, but there doesn't seem to be anything in any of them. "
	isPlural = true
;
+ Component 'chest/wound' 'chest'
	"It's awful. At least he died quickly. No one with a wound like that would have lasted for long. "
;
+ soldierDeadState : HermitActorState
//	specialDesc {
//		"A dead soldier lies crumpled on the ground here. ";
//	}
	
	noResponse = "The soldier is dead, so any interaction with him would be rather one sided. "
	
	isInitState = true
;


deadSoldier5 : DeadSoldier
//	location = spaceInvadersBunker5
	location = bunker4Bench
;
spaceInvadersDisc : Readable 'circular writing memory disc/disk' 'disc'
//	@spaceInvadersBunker5
	@deadSoldier5
	"This is a memory disc. It normally contains computer programs or data.
	But this one, according to the label, contains highly dangerous computer viruses.
	How convenient! "
	
//	specialDesc = "The soldier has a disc clutched in his hand. "
//	initDesc = "The soldier has a disc clutched in his hand. "
//	initExamineDesc = specialDesc
//	obscuredInitDesc = specialDesc
//	obscuredSpecialDesc = specialDesc
//	specialDescBeforeContents = specialDesc
//	specialDescBeforeContents = true

//	isListedInContents = nil
//	isListed = nil

	
	wasPlayed = nil
;

/*
armyKit : Container 'kit' 'kit' @spaceInvadersBunker4
	"This is a standard issue army supply kit. "
;

+ toothBrush : Thing 'tooth brush/toothbrush' 'toothbrush'
	"This is a standard issue army toothbrush. It is cut short to minimize weight. "
	
	iobjFor(BrushWith) {
		verify() {}
		check() {}
	}
;
*/

/*
bleach : Thing 'bleach/bottle' 'bleach'
	"This is standard issue army bleach. The bottle is <<amountOfBleachStr>>. "
	
	isPlural=true

	iobjFor(PourInto) {
		verify() {
			if(amountOfBleach==0) {
				"The bottle is empty. ";
				return nil;
			} else {
				return true;
			}
		}
		action() {
			--amountOfBleach;
			inherited;
		}
	}
	
	iobjFor(Bleach) asIobjFor(PourInto)
	iobjFor(PourOnto) asIobjFor(PourInto)

	dobjFor(Pour) {
		verify() {return true;}
		action() {
			if(amountOfBleach==0) {
				"The bottle is empty. ";
				return;
			} else {
				"You pour bleach from the bottle. It drains away. ";
				--amountOfBleach;
			}
		}
	}	
	
	amountOfBleachStr {
		switch(amountOfBleach) {
			case 2: return 'full';
			case 1: return 'half full';
			default: return 'empty';
		}
	}
	
	amountOfBleach = 2
;
*/

/*
flagpole : Attachable,Thing 'flagpole/pole' 'flagpole'
//	@spaceInvadersBunker2
	desc {
//		if(isAttachedTo(flag))
//			"This is a wooden flagpole with a flag attached. ";
//		else
			"This is a wooden flagpole. ";
	}
	
	initDesc = "You see a flagpole here. "
	
//	putFlagpoleUp() {
//		"Another soldier enters from the south carrying a flagpole.\b
//		
//		He shouts out <q>The Orangustanians have joined us!</q> This elicits cheers from
//		around the room.\b
//		
//		The soldier then walks up to the wall and puts the 
//		";
//	}
	
	canAttachTo(obj) {
		return obj==flag;
	}
	isMajorItemFor(obj) {
		return true;
	}

//	isListedInContents = nil
//	descContentsLister = nil
	
	attachedObjects = [flag]
;

flag : Attachable,Thing 'orangustanian flag' 'orangustanian flag'
//	@spaceInvadersBunker2
	desc {
		if(isBleached) {
			"This is a white flag. ";
		} else {
			"This is a brand new Orangustanian flag. ";
		}
	}
	
//	attachedObjects = [flagpole]
	
	canAttachTo(obj) {
		return obj==flagpole;
	}
	isListed = (!isIn(flagpole))
	isListedInContents = (!isIn(flagpole))
	
//	isMajorItemFor(obj) {
//		return nil;
//	}
	
	
	dobjFor(Bleach) {
		verify() {return !isBleached;}
		action() {
			"The flag turns pure white. ";
			name = 'white flag';
			initializeVocabWith('white flag');
			isBleached = true;
		}
	}
	
	dobjFor(PourOnto) asDobjFor(Bleach)
	dobjFor(PourInto) asDobjFor(Bleach)	
	
	isBleached = nil
;
*/



class SpaceInvadersShipRoomSet : Room
;

spaceInvadersShip2 : SpaceInvadersShipRoomSet 'crazy control room north'
	"Countless blinking lights are arrayed along the wall here.
	Nestled among the many blinking lights, in a very prominent position,
	is a covered rectangle with a small rectangular button to the right of it.
	<p>
	In front of the control panel is what appears to be a captain's chair.
	"
	south = spaceInvadersShip5
		
	roomParts = [defaultFloor, defaultCeiling, shipControlPanelWall, blinkingLightsWalls]
;
+ BlinkingLights;
+ spaceInvadersDrawer : RestrictedContainer,Component 'covered circular indentation rectangle/drawer/panel/tray/drive' 'drawer'
	desc {
		if(isOpen) {
			"Hmm. The drawer has a circular indentation into it. If you didn't
			know better you would think that this was a disc drawer that took memory
			discs like the ones that humans use in their computers. But that is of course
			absurd. The technology of the aliens is beyond the comprehension of humanity.
			How could they possibly be using exactly the same technology to store information
			as humans do? Human storage technologies rarely remain popular for more than
			a few decades. Why would aliens a thousand years more advanced than humans
			be using the same storage technology as humans? ";
		} else {
			"It's a rectangular panel in the wall that is obviously opened by the rectangular
			button next to it. ";
		}
	}
	
	canPutIn(obj) {
		return obj!=nil && obj.ofKind(spaceInvadersDisc);
	}
	
	dobjFor(Open) {
		verify() {}
		check() {}
		action() {
			if(isOpen) {
				"It's already open. ";
			} else {
				replaceAction(Push,spaceInvadersDrawerButton);
			}
		}
	}
	
	dobjFor(Close) {
		verify() {}
		check() {}
		action() {
			if(isOpen) {
				replaceAction(Push,spaceInvadersDrawerButton);
			} else {
				"It's already closed. ";
			}
		}
	}
	
	isOpen = nil
	wasOpened = nil
;
+ spaceInvadersDrawerButton : Button,Component 'small rectangular button' 'rectangular button'
	"It's a small rectangular button. It is very pressable. "
	dobjFor(Push) {
		action() {
			spaceInvadersDrawer.isOpen = !spaceInvadersDrawer.isOpen;
			if(spaceInvadersDrawer.isOpen) {
				"The covered rectangle slides out like a drawer. ";
				if(!spaceInvadersDrawer.wasOpened) {
					spaceInvadersDrawer.wasOpened = true;
					spaceInvadersDrawer.desc;
				}
			} else {
				"The drawer slides smoothly closed. ";
			
				if(spaceInvadersDisc.isIn(spaceInvadersDrawer) /*&& !spaceInvadersDisc.wasPlayed*/) {
//					spaceInvadersDisc.wasPlayed = true;
					"The disc begins to be read by the alien computer. Luckily, in addition
					to using memory disc readers which read human disc media, these
					highly advanced aliens also use computers which have the same security
					holes that human computers do. They have had technology for 1000 years
					longer than humans, yet the Code Red virus is still able to bring
					their system to its knees. How convenient! I guess they just haven't
					gotten around to installing Microsoft's latest security patch?<.p>
					
					Far and wide, all across the earth, humans cheer as the alien ships
					burst into flame and plummet to the earth. Sweet! Not only are their
					systems susceptible to a fairly typical human computer virus,
					but the alien IT guys handily networked all of their ships together
					in such a way that failure of one system caused all other systems
					to spontaneously fail! It sure is a good thing that the alien
					IT guys didn't bother to install firewalls on their computers!<.p>
					
					As the ship burns up around you, you are pulled back into the
					arcade.
					";
					
					spaceInvadersBunkerMachine.learnTrueName();
					spaceInvadersShipMachine.learnTrueName();
//					spaceInvadersBunkerMachine.whenPlayedMsg = 'You play '+ spaceInvadersShipMachine.properName +' for
//						a little bit, but the game just doesn\'t draw you in like it used to. ';
//					spaceInvadersShipMachine.whenPlayedMsg = spaceInvadersBunkerMachine.whenPlayedMsg;
					
					spaceInvadersBunkerMachine.winGame();
					nestedAction(StopPlaying);
				}
			}
		}
	}
;

spaceInvadersShip5 : SpaceInvadersShipRoomSet 'crazy control room'
	"Blinking lights. Shazbot! There are blinking lights everywhere!
	There are thousands upon thousands of blinking lights here!
	Either this is the inside of a small flying saucer or they really spruced up
	the oval office at the white house!
    You are currently in the center of the circular room.
	The main control panel area is to the north. "
	north = spaceInvadersShip2
	
	roomParts = [defaultFloor, defaultCeiling, blinkingLightsWalls]
;
+ BlinkingLights;

shipControlPanelWall : DefaultWall
	name = 'front wall'
	vocabWords = 'front wall'
	desc = "The front wall is mostly covered in blinking lights, but nestled among the lights is
		a control panel. "
;

blinkingLightsWalls: DefaultWall
	name = 'side walls'
	vocabWords = 'side wall*walls'
	desc = "The walls are absolutely covered in blinking lights! "
	isPlural = true
;


class BlinkingLights : Fixture 'blinking light*lights' 'blinking lights'
	"The blinking lights are everywhere. Strangely, they do not seem to
	indicate any useful information except possibly that the alien spaceship
	designers needed to make the ship's interior look more exciting to the
	non-technical bureaucrats who paid big bucks for these ships. "
	
	isPlural=true
	
//	initialLocationClass = SpaceInvadersShipRoomSet
;


alienChair : Chair,Fixture 'captain\'s chair' 'chair'
	"It's a captain's chair. Presumably that means that the alien is the captain of this ship. "
	location = spaceInvadersShip2
	
	dobjFor(SitOn) {
		action() {
			replaceAction(Attack,sleepingAlien);
		}
	}
;
sleepingAlien : UntakeableActor 'short green extremely ugly sleeping captain alien' 'sleeping alien'
	"The alien is a standard short green alien who has 4 tiny little eyes, all of which are currently closed,
	and some monstrously huge lips.
	<p>
	He (assuming it is a he) is leaning on his left arm and is making grunting noises that presumably mean that he is asleep.
	It's probably best not to wake him. These aliens are after all attempting to wipe out the human
	race, so I doubt he would be happy to see you. "
	
	location = alienChair
	specialDesc = "An extremely ugly alien is sleeping there. "
	posture = sitting


	dobjFor(Attack) {
		verify() {}
		check() {}
		action() {
			"You probably shouldn't have done that. The alien suddenly opens all four of its eyes
			and lunges for your throat. It's like fighting a tiger! You are torn to shreds within moments. ";
			
			endGame('You have been torn to shreds.');
		}
	}
	iobjFor(ThrowAt) {
		check() {
			replaceAction(Attack, self);
		}
	}
	
	dobjFor(Take) asDobjFor(Attack)
	dobjFor(Push) asDobjFor(Attack)
	dobjFor(Wake) asDobjFor(Attack)
;
+ Component '4 tiny closed little (alien) eye*eyes' 'alien eyes'
	"What little eyes he has! "
;
+ Component 'monstrously huge big (alien) lips' 'alien lips'
	"Such big lips he has! "
;
+ Component 'left right (alien) arm*arms' 'alien arms'
	"He only has two arms. At least he's normal in that respect. "
	isPlural = true
;
+ alienSleepingAgenda : DelayedAgendaItem
    isReady = ( inherited()
				&& gPlayerChar.canSee(sleepingAlien)
				)
	initiallyActive = true
	isDone = nil
	
	invokeItem {
		"<<alienSleepEvents.doScript()>>";
		setDelay(2);
	}
;
+ alienNoises : SimpleNoise 'alien noises' 'alien noises'
	"The alien is making odd noises in his sleep. "
	//soundPresence {return powerSwitch.isOn;}
;

alienSleepEvents : ShuffledEventList [
	'The alien shifts a bit and expels air with a <q>FWOOOT</q> sound. '
	,'The alien turns rustles a bit while making horrible smacking noises with his lips. '
	,'The alien makes restless <q>ni, ni, ni</q> noises. '
	,'The alien makes odd <q>beedle, beedle, beedle</q> sounds. '
	]
	;	

