/*
** Compass.t creates a compass rose in the bottom of the screen
**
** Copyright (c) 1998, Stephen Granade. All rights reserved.
*/

#pragma C+

class compassItem: floatingItem, item
    noun = 'compass'
    sdesc = "compass"
    ison = true
    isReachable(actor) = true
    separate = nil
    directions = [ &canGoNW, &canGoNorth, &canGoNE, &canGoWest, true,
        &canGoEast, &canGoSW, &canGoSouth, &canGoSE ]
    directionNames = [ 'NW', 'North', 'NE', 'West', 'Remove', 'East', 'SW',
        'South', 'SE' ]
    alignment = [ 'RIGHT', 'CENTER', 'LEFT' ]
    fgcolor = 'statustext'
    bgcolor = 'statusbg'
    padding = 5
    printLink(num, visible) = {
        if (!visible)
            say(self.directionNames[num]);
        else {
            if (num == 5)
                "<a href=\"display compass\">";
            else "<a href=\"<<self.directionNames[num]>>\">";
            "<<self.directionNames[num]>></a>";
        }
    }
    drawCompass(loc) = {
        local i, visible;

        if (!self.ison)
            return;
        if (self.separate)
            "<BANNER ID=\"CompassRose\" ALIGN=\"BOTTOM\"><BODY
                BGCOLOR=\"<<self.bgcolor>>\" TEXT=\"<<self.fgcolor>>\">";
        "<TABLE ALIGN=\"CENTER\" CELLPADDING=\"<<self.padding>>\"><TR>";
        for (i = 1; i <= 3; i++) {
            visible = loc.(self.directions[i]);
            "<TD ALIGN=\"<<self.alignment[i]>>\" VALIGN=\"BOTTOM\"><FONT";
            if (i % 2 == 1)
                " SIZE=\"-2\"";
            else " SIZE=\"-1\"";
            if (!visible)
                " COLOR=\"<<self.bgcolor>>\"";
            "><<self.printLink(i, visible)>></FONT></TD>";
        }
        "</TR><TR>";
        for (i = 4; i <= 6; i++) {
            visible = (self.directions[i] == true || loc.(self.directions[i]));
            "<TD ALIGN=\"<<self.alignment[i-3]>>\" VALIGN=\"MIDDLE\"><FONT";
            if (i == 5)
                " SIZE=\"-3\"";
            else " SIZE=\"-1\"";
            if (!visible)
                " COLOR=\"<<self.bgcolor>>\"";
            "><<self.printLink(i, visible)>></FONT></TD>";
        }
        "</TR><TR>";
        for (i = 7; i <= 9; i++) {
            visible = loc.(self.directions[i]);
            "<TD ALIGN=\"<<self.alignment[i-6]>>\" VALIGN=\"TOP\"><FONT";
            if (i % 2 == 1)
                " SIZE=\"-2\"";
            else " SIZE=\"-1\"";
            if (!visible)
                " COLOR=\"<<self.bgcolor>>\"";
            "><<self.printLink(i, visible)>></FONT></TD>";
        }
        "</TR></TABLE>";
        if (self.separate)
            "</BANNER>";
    }
;

