/* FIRST THINGS FIRST - Locations - future.t
/*  Copyright (c) 1996, 1997, 1999, 2000, 2001 by J. Robinson Wheeler. All Rights Reserved. */

/*
 *				********				 *********
 *				********	 THE GAME CODE	 *********
 *				********				 *********
 */

/********************************************************************************
 *																				*
					The rooms of the FUTURE.							  
 *
 *******************************************************************************/

Fclearing: room
	sdesc = "Clearing"
	ldesc = "The clearing here is desolate, giving the distinct impression that 
			all natural life has left this area. The ground is hard and overgrown by 
			weedy grass. There are no trees any more, but there are some stumps where 
			once they stood. Your old footpath is nowhere to be seen. "
	xdesc = "You do see your house to the northeast, but it too looks abandoned. "
	
	ne = Fwoods
	noexit = 
	{
		"There is nothing but desolate, brown land in that direction. ";
		return( nil ); 
	}
	firstseen =
	{
		incscore( 5 );
		global.scoreCard[7] := 1;
	}
;

FdummyClearingItem: locationDesc
	sdesc = "clearing"
	adjective = 'Fclearing'
	location = Fclearing
;

FclearingDistantHouse: distantItem
	sdesc = "house"
	ldesc = "It's a little too far away to see clearly. "
	noun = 'house'
	adjective = 'my' 'abandoned'
	location = Fclearing
;

weedyGrass: block
	sdesc = "weedy grass"
	noun = 'grass' 'weed' 
	plural = 'weeds'
	adjective = 'weedy'
	location = Fclearing
;

stumps: block
	sdesc = "stumps"
	ldesc = 
	{
		"Some of the stumps look deliberately cut, and others look like the
		result of a fierce storm that once blew through. ";
		
		if ( future.state < 4 )
			"There is some evidence of blackening, as if, somewhat recently, 
			a fire ripped through the woods. ";
	}
	noun = 'stump' 
	plural = 'stumps'
	isThem = true
	location = Fclearing
;

Fwoods: room
	sdesc = "At the rock"
	ldesc =
	{
		"A large rock juts up out of the ground right in your way, a familiar
		landmark in an otherwise unfamiliar landscape. Once nestled along a
		wooded path, it now is the sole feature of an eerily empty landscape,
		distorting your perceptions of scale and distance. The broken remains
		of dark glass bottles lie around the base. ";
		
		if ( future.state < 4 )
			"The rock itself looks darker than you remember it, somewhat
			blackened. ";
	}
	xdesc = "To the northeast is your house, and a clearing is visible to 
			the southwest. "
	ne = FsouthOfHouse
	sw = Fclearing
;

Frock: chairitem
	sdesc = "large rock"
	ldesc = 
	{
		"The rock is a five foot grey boulder, almost egg-shaped, 
		a single piece of heavy, textured granite. Polished smooth over
		time, a wedge shape sheared from the top ages ago provides a
		comfortable place to sit. ";
		
		if ( !lightningRod.attached )
			"\bIt is now darkened near the base, covered in a filmy black
			soot. Other marks, small circular burns that have left
			yellow drip-stains, are noticeable to the left and right
			of the sitting shelf. ";
		else
			"\bSmall, circular burns that have left yellow drip-stains
			 are noticeable to the left and right of the sitting shelf. ";
	}
	noun = 'rock' 'boulder' 'stone'
	adjective = 'large' 'wedge' 'shape' 'chipped' 'chip' 'top' 'granite'
				'heavy' 'textured'
	location = Fwoods
	ne = { self.getOff; return( self.location.ne ); }
	sw = { self.getOff; return( self.location.sw ); }
	noexit = { self.getOff; return( self.location.noexit ); }
	isdroploc = true
	statusPrep = "on"
	outOfPrep = "off of"
	
	getOff = 
	{
		if ( Me.location = self )
		{
			"You get off the rock.\n ";
			Me.moveInto( self.location );
		}
	}
	verDoStandon( actor ) = { self.verDoSiton( actor ); }
	doStandon( actor ) =
	{
		"You stand up on top of the rock. The view isn't much better. ";
		actor.moveInto( self );
	}
	verDoSiton( actor ) = 
	{
		if ( actor.location = self )
			"You are already on the rock. ";
	}
	doSiton( actor ) =
	{
		"You sit down on top of the rock. ";
		Me.moveInto( self );
	}
	
	verDoTake( actor ) =
	{
		"The rock is made of solid granite and conservatively weighs
		one and a half tons. You are unable to move it. ";
	}
	verDoMove( actor ) = { self.verDoTake( actor ); }
	verDoPush( actor ) = { self.verDoTake( actor ); }
	verDoPull( actor ) = { self.verDoTake( actor ); }
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sometimes it's nice to have a big ol' rock to
				sit on when you need to think.\" ";
				return( true );
			case Laura:
				"Laura says, \"That sounds like a great spot to sit and 
				meditate.\" ";
				return( true );
			case Architect:
				"He says, \"Ah yes, that old rock just down in the woods. I made
				a special point of preserving it. It would have been such a 
				shame to blast it. I've made something of a habit of taking 
				walks down there to clear my head and think.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

FwoodsDistantHouse: distantItem
	sdesc = "house"
	ldesc = "It's a little too far away to see clearly. "
	noun = 'house'
	adjective = 'my' 'abandoned'
	location = Fwoods
;

filmyBlackSoot: block, floatingItem
	sdesc = "filmy black soot"
	ldesc = "It is evidence that a fire has burned through this area. "
	noun = 'soot'
	adjective = 'blackened' 'darkened' 'base' 'filmy' 'black'
	location = 
	{
		if ( !lightningRod.attached )
			return( Fwoods );
		return( nil );
	}
;

yellowStains: block
	sdesc = "yellow drip-stains"
	noun = 'stain' 
	plural = 'stains' 'drip-stains'
	isThem = true
	adjective = 'yellow' 'drip'
	location = Fwoods
;
	
smallBurns: block
	sdesc = "small circular burns"
	noun = 'burn' 
	plural = 'burns' 'circles'
	isThem = true
	adjective = 'small' 'circular' 'round' 'circle'
	location = Fwoods
;

brokenBottles: block
	sdesc = "broken bottles"
	plural = 'bottles'
	isThem = true
	adjective = 'bottle' 'remains' 'remains of' 'dark' 'glass' 'broken'
	verDoTake( actor ) = { "There is no reason to touch the broken glass. "; }
	verDoTouch( actor ) = { "There is no reason to touch the broken glass. "; }
	location = Fwoods
;

FsouthOfHouse: room
	sdesc = "South of house"
	ldesc = 
	{
		if ( future.state < 4 )
			"This is not your house as you expected to find it, but a scene of
			devastation. ";
		
		switch( future.state )
		{
			case 0:   /*  no rod, no tree, no roof  */
				"The house has been destroyed by fire. There is nothing left 
				of the roof or the upper half, and of the lower half, merely 
				charred timbers and twisted pipes that no longer lead to 
				anything. ";

				if ( FtinyTree.location = self )
				{
					"Beside the house is a scrawny, dead tree. ";
				}
				break;
			case 1:   /*  no rod, no tree, yes roof  */
				"The house has been damaged by fire. Though the roof remains
				intact, the insides have been burnt out, leaving a brittle,
				soot-stained shell that you can hear wind whistling through. ";

				if ( FtinyTree.location = self )
				{
					"Beside the house is a scrawny, dead tree. ";
				}
				break;
			case 2:   /*  no rod, yes tree, no roof  */
				"The house has been ravaged by fire. Though much of the
				lower structure remains, there is nothing left of the roof or 
				the upper half, merely charred timbers and twisted pipes that 
				no longer lead to anything. The fire seems to have spread to
				(or from) the branches of the large tree you planted, as it too 
				has been consumed from the top down. What remains of its upper 
				trunk has broken from its base and toppled onto the open
				roof of the house. ";
				break;
			case 3:   /*  no rod, yes tree, yes roof  */
				"The beautiful tree you planted has split from its scorched trunk and 
				smashed into the side of your house. From what you can see, the roof
				has been torn open by the weight of it, and a terrifying hole gouged
				out to fully halfway down the wall. However, the fire seems not to
				have spread thanks to the fire-resistant shingles. Broken splinters
				of wet and rotting wood lie everywhere, kept moist by recent rains. ";
				break;
			case 4:   /*  yes rod, no tree, no roof  */
				"The house is older and sagging, with long ruts where splinters 
				have broken off. The worst damage is to the roof, which has 
				turned rotten and caved in. The ground slopes down slightly 
				here, and the wall of the house looms extra high because of 
				it, although not quite as high as it once did because of the 
				collapsed roof. ";
				
				if ( FtinyTree.location = self )
				{
					"Beside the house is a scrawny, dead tree. ";
				}
				break;
			case 5:   /*  yes rod, no tree, yes roof  */
				"The house is older and sagging, with long ruts where splinters 
				have broken off, but otherwise looks the way you remember it. 
				The ground slopes down slightly here, and the wall of the house 
				looms an extra story high because of it. The tiny window high 
				in the wall has been crudely boarded shut. ";
			
				if ( FtinyTree.location = self )
				{
					"Beside the house is a scrawny, dead tree. ";
				}
				break;
			case 6:   /*  yes rod, yes tree, no roof  */
				"The house is older and sagging, with long ruts where splinters 
				have broken off. The worst damage is to the roof, which has 
				turned rotten and caved in. The ground slopes down slightly 
				here, and the wall of the house looms extra high because of 
				it, although not quite as high as it once did because of the 
				collapsed roof. ";

				"A large and sagging tree grows here, leaning its bulky canopy 
				toward the house. A large branch has snapped from the middle of
				its trunk and lies in the mud. ";
				break;
			case 7:   /*  yes rod, yes tree, yes roof  */
				"The house is older and sagging, with long ruts where splinters 
				have broken off, but it otherwise looks the way you remember it. 
				The ground slopes down slightly here, and the wall of the house 
				looms an extra story high because of it. The tiny window high 
				in the wall has been crudely boarded shut. ";

				"A large and sagging tree grows here, leaning its bulky canopy 
				toward the house. A large branch has snapped from the middle of
				its trunk and lies in the mud. ";

				break;
//			default: "\b[aborted]"; break;
		}
	}
	xdesc =
	{
		"To the southwest is the old rock and, farther, the 
		clearing. <<future.state < 3 ? "You can walk around what's left of 
		your house to the northwest and northeast" : "You can walk around 
		your house to the northwest and northeast">>. ";
		
		if ( FsecretDoor.location && FsecretDoor.isopen )
			"A secret door is open to the north. ";
	}
	
	noexit = 
	{
		if ( self.ankle )
		{
			"%You're% not going anywhere on a broken ankle. ";
			return( nil );
		}
		else
		{
			"%You% can't go that way. ";
			return( nil );
		}
	}
	sw = 
	{
		if ( self.ankle )
			return( self.noexit );
		else
			return( Fwoods );
	}
	nw =
	{
		if ( self.ankle )
			return( self.noexit );
		else
			return( FbehindHouse );
	}
	ne = 
	{
		if ( self.ankle )
			return( self.noexit );
		else
			return( FfrontOfHouse );
	}
	up = 
	{
		if ( self.ankle )
			return( self.noexit );
		else if ( hangingForDearLife.isseen )
			"You're never climbing up that tree again as long as you live,
			after what nearly happened. ";
		else
		{
			switch( future.state )
			{
				case 0:
				case 1: return( self.noexit );
				case 2:
				case 3: return( FmidTree );
				case 4:
				case 5: return( self.noexit );
				case 6:
				case 7: return( FmidTree );
			}
		}
	}
	north = 
	{
		if ( self.ankle )
			return( self.noexit );
		else if ( future.state < 3 )
			return( FinsideHouse );
		else if ( FsecretDoor.location )
			return( FsecretDoor );
		else return( self.noexit );
	}
	in = { return( self.north ); }
;

Fwall: secretDoorWall
	ldesc = 
	{
		if ( future.state = 0 ) 
			"There is no wall any more, just charred timbers. "; 
		else if ( future.state < 3 )
			"The wall is completely black. It is charred and brittle. ";
		else
			"The wall is splintered and weather beaten. ";
	}
	myDoor = FsecretDoor
	mySwitch = FsecretSwitch
	location = FsouthOfHouse
	verDoKnock( actor ) = 
	{
		if ( future.state < 3 ) 
			"You knock on the brittle, burned-out husk. ";
		else 
			pass verDoKnock;
	}
	doKnock( actor ) =
	{
		if ( self.mySwitch.steppedOn )
		{
			"You hear a weight dropping, and a couple of clicks. The
			secret door springs magically open wide, revealing a 
			darkened entrance. ";
			self.myDoor.isopen := true;
			if ( not FLaura.met && FLaura.daemonCount = 0 ) {
				notify( FLaura, &actorDaemon, 0 );	// summon future-Laura
			}
		}
		else
		{
			"You knock on the wall. It sounds <<self.myDoor.location ?
			"hollow" : "solid">>. ";
		}
	}
;

FsecretDoor: secretDoorItem
	mySwitch = FsecretSwitch
	myWall = Fwall
	otherside = FinteriorSecretPassageDoor
	doordest = 
	{
		if ( future.state > 2 ) 
			return( FsecretPassage );
		return( FinsideHouse );
	}
	doOpen( actor ) =
	{
		if ( future.state < 3 )
			"Even if you could open it, you can see for yourself that the only
			thing it leads to is a burned-out shell of a house. ";
		else pass doOpen;
	}
;

FsecretSwitch: secretSwitchItem
	myWall = Fwall
	myDoor = FsecretDoor
	doStandon( actor ) =
	{
		if ( future.state < 3 ) {
			self.steppedOn := true;
			"You put your foot onto the secret switch. It sinks hollowly and 
			without resistance to your weight. It doesn't feel like
			it's attached to anything. ";
		}
		else pass doStandon;
	}
;

brokenSplinters: block, floatingItem
	sdesc = "splinters of wood"
	adesc = "a splinter of wood"
	ldesc = "They are moist from recent rains, but otherwise unremarkable. "
	noun = 'wood'
	plural = 'splinters' 'ruts'
	isThem = true
	adjective = 'broken' 'splinter' 'wet' 'rotting' 'long' 'rut'
	location =
	{
		if ( future.state >= 3 )
			return( FsouthOfHouse );
		else return( nil );
	}
;

Fbranch: block, floatingItem
	sdesc = "broken branch"
	ldesc = "It has snapped off from the tree and lies dead on the ground. "
	noun = 'branch'
	adjective = 'broken' 'large' 'snapped'
	location =
	{
		if ( future.state >= 6 )
			return( FsouthOfHouse );
		else return( nil );
	}
	verDoTake( actor ) = { "It is too large and heavy to move. "; }
;

Fwindow1: distantItem, floatingItem
	isfixed = nil
	sdesc = "tiny window"
	ldesc = 
	{
		if ( FatticWindow.boardedUp )
			"The tiny window has been crudely boarded shut. You're not
			going to be able to get in through it. ";
		else
			"You recognize the tiny window as the same attic window
			that's always been there. Well, in a manner of speaking,
			always, that is. ";
	}
	noun = 'window'
	adjective = 'tiny' 'little'
	location = 
	{
		if ( ( future.state = 5 ) or ( future.state = 7 ) )
			return( FsouthOfHouse );
		else
			return( nil );
	}
	dobjGen( a, v, i, p ) =
	{
		if ( v != askVerb and v != tellVerb and v != inspectVerb and v != jumpVerb )
		{
			"\^<<self.itisdesc>> too far away.";
			exit;
		}
	}
	
	verDoLeapTo( actor ) = {}
	doLeapTo( actor ) =
	{
		"The little window is 30 feet up. You cannot reach it
		by jumping. ";
	}
	
	verIoThrowAt( actor ) = { self.verIoThrowIn( actor ); }
	ioThrowAt( actor, dobj ) = { self.ioThrowIn( actor, dobj ); }
	
	verIoThrowTo( actor ) = { self.verIoThrowIn( actor ); }
	ioThrowTo( actor, dobj ) = { self.ioThrowIn( actor, dobj ); }
	
	verIoThrowIn( actor ) = {}
	ioThrowIn( actor, dobj ) = 
	{
		"You take and and heave <<dobj.thedesc>> at the window. It 
		misses by a mile and falls to the ground. ";
		dobj.moveInto( southOfHouse );
	}
;

FtinyTree: staticItem
	sdesc = "dead tree"
	ldesc = "The tiny, sickly tree is dessicated and dead. "
	noun = 'tree' 'specimen'
	adjective = 'tiny' 'scrawny' 'puny' 'anemic' 'sickly' 'dead' 'dessicated' 'dry'
	location = nil
;

Ftree: staticItem, floatingItem
	sdesc = 
	{
		if ( future.state < 4 )
		{
			"burned and broken tree";
		}
		else
			"large and sagging tree";
	}
	ldesc = 
	{
		switch( future.state )
		{
			case 0:
			case 1: "[bug - tree shouldn't be available] ";
				break;
			case 2:
			case 3:
				"The tree is crippled and broken, a burnt shadow of its once
				towering presence. ";
				break;
			case 4:
			case 5: "[bug - tree shouldn't be available] ";
				break;
			case 6:
			case 7:
				"The tree is sagging under the enormous weight of its
				overgrown size. ";
				break;
		}
	}
	noun = 'tree'
	adjective = 'stately' 'burnt' 'burned' 'broken' 'large' 'sagging'
	location = 
	{
		switch( future.state )
		{
			case 0:
			case 1: return( nil );
			case 2:
			case 3: return( FsouthOfHouse );
			case 4:
			case 5: return( nil );
			case 6:
			case 7: return( FsouthOfHouse );
		}
	}
	
	verDoClimb( actor ) = 
	{
		actor.travelTo( FsouthOfHouse.up );
	}
;

FmidTree: FtreeRoom
	sdesc = "Mid-way up tree"
	ldesc = 
	{
		switch( future.state )
		{
			case 0:
			case 1: "[BUG - shouldn't be able to be here] ";
				break;
			case 2:
				"You are mid-way up the tree, or what used to be. The burned and
				broken top half of the trunk extends at a slight vertical 
				angle, the blackened top branches merging with the sooty
				timbers of the gutted house. ";
				break;
			case 3:
				"You are mid-way up the tree, or what used to be. The
				broken top half of the trunk extends at a slight vertical 
				angle, the top branches poking into the broken house. ";
				break;
			case 4:
			case 5: "[BUG - shouldn't be able to be here] ";
				break;
			case 6:
			case 7:
				"You are mid-way up the large tree, which extends 
				upward and outward into swollen limbs, although
				many of the larger ones have been severed and 
				blown away by recent storms. ";
				break;
		}
	}
	xdesc = 
	{
		if ( future.state = 3 )
		{
			"You can climb back down to the ground. More dangerously, 
			you can shimmy north along the slick, broken trunk that 
			leads into the open attic of the house. ";
		}
		else
		{
			"The tree is too slick and has lost too many branches to
			climb any higher than here. There is nowhere to go except 
			back down to the ground. ";
		}
	}
	
	north = 
	{
		if ( future.state = 2 )
		{
			"As you hoist yourself carefully up to the broken base
			and stare at the distance you must cross at this height,
			the barest pressure of your weight causes the trunk to
			groan and shift. It is much too unstable at the far end
			to attempt a crosssing. ";
			return( nil );
		}	
		if ( future.state = 3 )
		{
			if ( not trunk1.isseen )
				"Testing it with gentle pressure, the trunk seems solid 
				and steady, enough for you to believe that it will hold. 
				Fearlessly, for the moment, you straddle your legs 
				around the broken base of the horizontal trunk, and 
				begin to scoot yourself forward. ";
			
			return( trunk1 );
		}
		else
			return( self.noexit ); 
	}
	up = { self.xdesc; return( nil ); }
	down = FsouthOfHouse
;

Fwindow2: distantItem, floatingItem
	isfixed = nil
	sdesc = "tiny window"
	ldesc = 
	{
		if ( FatticWindow.boardedUp )
			"The tiny window has been crudely boarded shut. ";
		else
			"I see nothing special about the tiny window. ";
	}
	noun = 'window'
	adjective = 'tiny' 'little'
	location = 
	{
		if ( ( future.state = 5 ) or ( future.state = 7 ) )
			return( FmidTree );
		else
			return( nil );
	}
	
	dobjGen( a, v, i, p ) =
	{
		if ( v != askVerb and v != tellVerb and v != inspectVerb and v != jumpVerb )
		{
			"\^<<self.itisdesc>> too far away.";
			exit;
		}
	}
	
	verDoLeapTo( actor ) = 
	{
		"It is too dangerous to be jumping when the rain has slickened
		the tree. ";
	}
	
	verIoThrowAt( actor ) = { self.verIoThrowIn( actor ); }
	ioThrowAt( actor, dobj ) = { self.ioThrowIn( actor, dobj ); }
	
	verIoThrowTo( actor ) = { self.verIoThrowIn( actor ); }
	ioThrowTo( actor, dobj ) = { self.ioThrowIn( actor, dobj ); }
	
	verIoThrowIn( actor ) = {}
	ioThrowIn( actor, dobj ) = 
	{
		"You take and and heave <<dobj.thedesc>> at the window. It 
		misses by a mile and falls to the ground. ";
		dobj.moveInto( southOfHouse );
	}
;

swollenLimbs: block
	sdesc = "swollen limbs"
	noun = 'limb' 
	plural = 'limbs' 'leaves' 'branches'
	isThem = true
	adjective = 'swollen' 'canopy'
	location = 
	{
		switch( future.state )
		{
			case 6:
			case 7: return( FmidTree );
			default: 
//				"[BUG - shouldn't be available] ";
				return( nil );
		}
	}
;

shimmyTrunk: block, floatingItem
	sdesc = "broken trunk"
	ldesc = "It is hanging by splinters, and slickened from recent rains. "
	noun = 'trunk'
	adjective = 'broken'
	location = 
	{
		if ( isclass( Me.location, FtreeRoom ) && Me.location != hangingForDearLife )
		{
			if ( future.state = 2 || future.state = 3 )
				return( Me.location );
			else return( nil );
		}
		else return( nil );
	}
	
	verIoTieTo( actor ) = 
	{
		"There is no point in tying anything to the broken trunk. ";
	}
	
	verDoShimmy( actor ) = 
	{
		if ( future.state = 2 )
			"At the merest pressure of your weight on the branch, it shifts
			with a crack and a great groaning. It is far too precarious to
			travel along in this state. ";
	}
	doShimmy( actor ) = { actor.travelTo( self.location.north ); }
	
	verDoHoldOn( actor ) = 
	{
		"You are already holding onto the broken trunk as best you can. ";
	}
	
	verDoDrop( actor ) = 
	{
		"You don't want to fall off of the broken trunk. ";
	}
	
	verDoLetGo( actor ) = 
	{
		"You don't want to let go of the broken trunk for fear that
		you will fall off. ";
	}
	
	verDoRelax( actor ) = 
	{
		"You don't want to let go of the broken trunk for fear that
		you will fall off. ";
	}
	
	verDoClimb( actor ) = 
	{
		if ( future.state = 2 )
			"At the merest pressure of your weight on the branch, it shifts
			with a crack and a great groaning. It is far too precarious to
			climb onto in this state. ";
	}
	doClimb( actor ) =
	{
		Me.travelTo( Me.location.north );
	}
	
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) =
	{
		if ( future.state = 2 || Me.location = FmidTree ) 
			Me.travelTo( Me.location.down );
		else
			Me.travelTo( Me.location.south );
	}
;

trunkRoomAtticOpening: distantItem, floatingItem
	sdesc = "attic opening"
	ldesc = 
	{
		switch( Me.location )
		{
			case FmidTree:
				if ( future.state = 2 ) 
					"The burned and broken top half of the trunk extends at a 
					slight vertical angle, the blackened branches merging with
					the sooty timbers of the gutted house. There's no way in
					from here. ";
				else 
					"The broken top half of the trunk extends at a slight vertical 
					angle, the top branches poking into the broken house. It might
					be possible to shimmy north along the slick, broken trunk that 
					leads into the open attic of the house. ";
				break;
			case trunk1:
				"Looking at it again from here, the attic doesn't seem very
				far away at all. Your first estimate, ten or twelve feet, was
				a little short, but not by much. Maybe it's fifteen. It nags
				in the back of your mind that you are having some trouble
				gauging distances, but you ignore it. You haven't climbed 
				very high up in the tree; you'd survive a fall. The temptation
				to get into your house is stronger than all other considerations. ";
				break;
			case trunk2:
				"You are somewhat disheartened to see that the attic seems 
				still just as far away as ever. However, the mid-point of
				the distance between the tree and the opening is in sight. 
				The curve in the broken trunk seems to lessen the vertical
				slant, making the passage seem level, and the goal seem
				attainable in no time. ";
				break;
			case trunkMidway:
				"You see the opening of the attic just ahead, much larger
				now. The hole is rather fierce and gaping, with silvery 
				droplets dripping past the dark opening like drool from 
				a slavering creature's maw. \b
				
				Rather than pay attention to your fertile imagination, you reckon
				that you really just need to make it another five or ten feet.
				You will then be close to the top branches, which offer
				plenty of handholds to guide you as far as the opening. From
				there, a safe hop into the attic is possible. ";
				break;
			case pointOfNoReturn:
				"You stare at your ultimate goal, the opening into the attic, for 
				a long moment. It doesn't seem so very far away. Something about 
				shimmying along the trunk feels vaguely exciting, like something
				you would have done as a child without thinking twice. ";
				break;
			case trunk4:
				"You look again, and the attic is close, very close, but 
				your senses are tricking you at every turn now. As you stare 
				at the opening, it seems to recede, as if in a nightmare; this 
				trunk is the hallway that ever extends, that has no end. ";	
				if ( not self.staredAtFromTrunk4 )
	 			{
					self.staredAtFromTrunk4 := true;
					"\bThe wind picks up momentarily, and the attic opening seems
					to tilt back and forth, like a head rocking with laughter. ";
				}
				break;
			case hangingForDearLife:
				"You can see it, sideways, upside down, a black shape far,
				farther, way too far beyond you, a zone of safety you came close
				to reaching, but couldn't. You can't make it, and realizing
				this makes you want to scream. ";
				break;
			case endOfTrunk:
				"You are almost there. You can nearly touch the ragged sides
				of the house wall to your left. Inside, you can see the 
				floorboards. Receded far into the shadows, you see the attic
				ladder, and that it is open. Just a little farther, and you
				can go in, you can go down, you can be inside your house, 
				safe. ";
				break;
		}
	}
	noun = 'opening'
	adjective = 'attic' 'window' 'maw' 'mouth' 'goal' 'end' 'top' 'house' 
			'hole' 'wall' 'open' 
	location = 
	{
		if ( isclass( Me.location, FtreeRoom ) )
			return( Me.location );
		else return( nil );
	}
	
	verDoBoard( actor ) = {}
	doBoard( actor ) = { self.doEnter( actor ); }
	
	verDoEnter( actor ) = 
	{
		if ( Me.location != endOfTrunk ) 
		{
			if ( Me.location = FmidTree )
				"It is out of reach from here. You might be able to shimmy 
				across the length of the trunk to get there. It's straight,
				and it's broad enough to support your weight. It might
				just be a matter of moving carefully. ";
			else {
				self.ldesc;
				return( nil );
			}
		}
	}
	doEnter( actor ) = 
	{
		"Slowly, slowly, with painstaking care, you shift your weight
		forward on the thin, drooping upper branches, until you see
		attic floorboards beneath you instead of open air. Gingerly,
		you stretch a foot down, but just as your toe makes contact,
		the branch in your right hand, which was holding your weight
		and steadying your balance, snaps. You hurtle yourself forward
		into a roll, desperate to get your mass moving inward instead
		of outward. \b
		
		Amid a tangle of crackling and snapping noises; none of them
		your bones, fortunately; you find yourself, scratched but
		safe, inside the attic of your house. You crawl another foot
		away from the gaping opening before your fear of falling abates
		enough to allow you to stand up. You're safe. \b";
		
		Me.travelTo( Fattic );
	}
;

handHolds: fixedBlock, floatingItem
	sdesc = "handholds"
	ldesc = 
	{
		"The handholds are few and far between. ";
		if ( future.state = 3 )
			"Strong top tree branches are up ahead, offering only the 
			distant promise of security. ";
	}
	noun = 'handhold'
	plural = 'handholds'
	isThem = true
	adjective = 'holds' 'hold' 'waterlogged' 'bark' 'strong' 'top' 'branches'
			'tree' 'grip' 'limb' 'limbs'
	location = 
	{
		if ( isclass( Me.location, FtreeRoom ) && Me.location != hangingForDearLife )
			return( Me.location );
		else return( nil );
	}
	
	verDoTake( actor ) = {}
	doTake( actor ) = { self.doHoldOn( actor ); }
	
	doHoldOn -> shimmyTrunk
	doLetGo -> shimmyTrunk
	doRelax -> shimmyTrunk
;

trunk1: FtreeRoom
	sdesc = "Along the trunk"
	ldesc = "The trunk is slicker than you thought, and the ground is farther
			away, a wet gray mass that will not be a comfortable landing should
			you fall. At this point, the base of the tree is still nearby, so
			after a few deep breaths to collect yourself, you feel secure enough
			to continue. "
	north = 
	{
		if ( not trunk2.isseen )
			"As you shimmy forward, you start to lose your balance. In
			a moment of utter panic, you lean forward and grab the trunk with 
			both hands, seizing it fast until you assure yourself that you are
			finally stable. Still, your head spins, and you can't quite trust 
			your sense of equilibrium. ";
		
		return( trunk2 );
	}
	south = 
	{
		"Carefully, you inch yourself backwards. Somehow, it's a little 
		easier than moving forwards, but the difference is probably 
		psychological. Eventually, you feel the sharpness of splinters
		at your back. Carefully, you reach around and grab ahold of a 
		tree branch, and swing yourself off of the broken trunk. ";
		
		return( FmidTree );
	}
;

trunk2: VertigoRoom
	sdesc = "Farther along the trunk"
	ldesc = "You have made your way about five feet along the trunk towards
			the attic. Your distorted sense of equilibrium is starting to
			induce a sense of fear, because at any odd moment you feel as 
			if you are starting to pitch to one side or the other. Holding
			fast, you remind yourself that you are not losing your balance,
			but are only fearing that you might. "
	xdesc = "If you go just a bit farther, you will be halfway there. Seeing
			this boosts your courage. "
	north = 
	{
		if ( not pointOfNoReturn.isseen )
			"You grit your teeth and loosen up your muscles. Being tense isn't
			going to help you if you start to totter. You move an inch or so,
			releasing the grip with your legs and then clamping them tight
			again. Gradually, your confidence returns. You see the midway point
			ahead of you. \b
			
			Rain is slicking your eyes, but you don't feel confident letting go
			with one hand long enough to wipe the drops away. You scoot forward
			again. A salty taste trickles into the corner of your mouth, and you
			realize that it's not rain on your face, but sweat. Spitting it out,
			you keep your eye on the goal: the halfway point. You ignore the 
			still-distant attic, and above all you ignore the ground. ";
		
		return( pointOfNoReturn );
	}
	south = 
	{
		"You scoot yourself backwards a few inches at a time, making slow and
		steady progress. ";
		
		return( trunk1 );
	}
	
	firstseen = 
	{	
		if ( length( Me.contents ) > 0 )
		{
			local l, i;
			l := Me.contents;
			for ( i := 1; i <= length(l); ++i )
			{
				l[i].moveInto( FsouthOfHouse );
			}
			"\bYou have dropped all of your possessions. ";
		}
	}
;

pointOfNoReturn: VertigoRoom
	sdesc = "Point of no return"
	ldesc = "You realize now that you have reached the point of no return. You 
			are just a little short of the halfway point, and to go forward any
			more will mean committing to the rest of the crawl. The safety
			of the tree will be too far behind you to risk moving backwards. "
	north = 
	{
		if ( not trunkMidway.isseen )
		{
			if ( not trunkRoomAtticOpening.staredAtFromPointOfNoReturn )
				trunkRoomAtticOpening.ldesc;
			
			"Full of youthful courage, you ease yourself forward. Your thigh muscles
			are starting to tire, so you try to relax them even as you use them
			to hold yourself steady. Foot by foot, you make your way forward. ";
		}
		return( trunkMidway );
	}
	south = 
	{
		if ( not self.goneBackwardsOnce )
		{
			"Finding more fear than confidence within yourself, you scoot
			backwards. Carelessly, you put your hand on a slick spot, and 
			pitch dangerously forward. Reminding yourself to be more 
			careful, you choose each grip point with care as you lift 
			your weight off your legs and ease them back. As you become
			accustomed to the difference between moving forwards and 
			moving backwards, you increase your rate of progress, finally
			ending up where you were a few minutes ago. ";
			
			self.goneBackwardsOnce := true;
		}
		else
		{
			"Once again, you scoot backwards, afraid to move past the
			point of no return. ";
		}
		return( trunk2 );
	}
;

trunkMidway: VertigoRoom
	sdesc = "Halfway along the trunk"
	ldesc = "You have reached a distance halfway between the tree behind you
			and the attic in front of you. Rather than feeling good about 
			having made it this far, your pulse is quickened when you 
			recognize what you have lost by coming this far: stability. 
			The trunk was solid and stable at the base, where it is
			connected to the tree, but here in the middle it bows and 
			sways under your weight. You feel it sagging, and when you 
			do not sit still, it bounces and sways. "
	north = 
	{
		"You move more slowly than before, with your eyes fixed only on
		the next six inches, and the six inches after that. Your hands and 
		fingers are hurting. You have been gripping so tightly, with the 
		tendons so tensed, that you have worn the tips raw. The blood has 
		also drained from them, leaving them cold but thankfully not numb. ";
		
		return( trunk4 );
	}
	south = "It is not safe to travel back now. "
;

trunk4: VertigoRoom
	sdesc = "Past the halfway point"
	ldesc = "The opening is close now, a much shorter distance ahead than
			the distance you have already traversed. "
	xdesc = "The trunk curves into a steeper angle, and the top branches
			that will be your secure handholds for the last few feet are
			just out of reach. Just a little more, and you can
			grab the nearest of them. Just a little more, and this travail
			will be over. "
	north = 
	{
		"As you start to move, something feels different. Your mind conjures 
		images of some kind of giant animal, like a forest bear, shaking the 
		trunk below you. But the tree isn't shaking, you are. Your muscles 
		aren't used to this kind of punishment, and your arms are starting to quake 
		involuntarily. You feel your 
		body sagging to one side, your weight rotating around the slickened
		bark of the tree. Panicking, you squeeze tighter and tighter, but you
		are unable to find friction enough to stop your movement. \b

		A sudden twang of reptile-brain fear opens your eyes and puts you 
		into full, unthinking panic. Your body has shifted, and you are 
		starting to fall off the tree. Your fingernails search for a hold,
		your legs clamp as if to snap the trunk in two, but you can't hang on
		much longer. ";
		
		return( hangingForDearLife );
	}
	south = 
	{
		"You tell yourself that you can make it back, that it's safer than
		what lies ahead. You tell yourself that the point of no return is 
		an imaginary concept, that sometimes it's safer to beat a retreat
		than to forge ahead into the unknown. \b
		
		Unfortunately, you are mistaken. \b";
		
		return( self.north );
	}
	firstseen =
	{		
		"\bA small wind, so slight that you would not have noticed it
		if you were on the ground, assails your already-eroded sense
		of balance. ";
	}
;

hangingForDearLife: FtreeRoom
	sdesc = "Hanging for dear life"
	ldesc = 
	{
		if ( self.slipDaemonCount < 4 )
			"You are hanging for dear life, with your body slipping around the
			trunk of the tree. Soon you'll be upside down, trying to support
			your weight with atrophied muscles, with fingers that can't find
			a grip on waterlogged bark. ";
		else 
			"You are now upside down, hanging on for dear life from the underside
			of the tree, trying to support your weight with atrophied muscles, 
			with fingers that can't find a grip on waterlogged bark. You will
			soon lose your hold on the tree completely. ";
	}
	
	climbCount = 0
	up = 
	{
		if ( hangingForDearLife.relaxedOnce )
		{
			self.climbCount++;
			
			switch( self.climbCount )
			{
				case 1:
					"Your relaxed muscles seem willing to put in a renewed 
					effort. Your relaxed mind takes an extra second to figure
					out how best to do this. You're going to need to let go of
					one arm and place it differently, so that you have the 
					leverage and strength to pull your upper body up and 
					around. \b
					
					You adjust your legs, locking your feet together so that
					you can trust them to hold you. You lengthen your arms, 
					then pull as hard as you can, lifting your chest to meet
					the trunk. Then, fully aware of the gamble you are taking,
					you release your left arm and swing it around from the far
					side of the trunk to the nearer, so that your upper body
					is all on the same side. You haven't fallen yet. You take
					another breath. ";
					break;
				case 2:
					"You pull as hard as you can with your arms, and strain
					forward with your chin, almost using it as a third hand
					on a patch of firm bark. With fast, forward slaps, you
					move each hand a little farther, and pull again. You 
					get your chin up to the top of the branch, and take 
					another short breather. ";
					break;
				case 3:
					"You rotate your left arm back again. Finding steady
					grips, you give the muscles that pull a needed break
					and use the ones that can push, lifting your torso
					up. You relax your locked legs, allowing them to
					rotate, your hips following your upper body. Not 
					wanting to lose the progress so far, you lean forward
					and clamp the trunk more tightly again, and cinch 
					your legs around an inch at a time. \b
					
					Before you know it, you are completely on top of the
					trunk again. Too tired, and still too short of the
					attic to be completely ecstatic, you take a rest.
					Finally, bravely, you push back up to a sitting 
					position. ";
					
					return( endOfTrunk );
					unnotify( hangingForDearLife, &slipDaemon );
			}
		}
		else
		{
			"You strain your over-tensed, over-taxed muscles, desperately
			trying to find some leverage, some way of making it back upright,
			back on top of the branch. You find you cannot. Every effort you
			make, effort to the point of snapping your super-taut tendons,
			only serves to increase your pain, your desperation, and your
			chances of falling any second now. ";
		}
		
		return( nil );
	}
	firstseen = 
	{
		notify( self, &slipDaemon, 0 );
	}
	relaxedOnce = nil
	relaxedButSlippingAgain = nil
	relaxedCount = 0
	slipDaemonCount = 0
	slipDaemon =
	{
		if ( self.climbCount > 0 )
			return;
		
		if ( self.relaxedOnce )
		{
			if ( not self.relaxedButSlippingAgain )
			{
				self.relaxedCount++;
				if ( self.relaxedCount = 3 )
				{
					if ( self.slipDaemonCount = 4)
					{
						"\bYou feel yourself slipping again, this time for
						sure. You are about to fall off the tree. ";
						return;
					}
					self.relaxedButSlippingAgain := true;
				}
				else return;
			}
		}
		self.slipDaemonCount++;
		"\b";
		switch( self.slipDaemonCount )
		{
			case 1:
			case 2:
				"You feel your body shift again. ";
				break;
			case 3:
				"You shift again, and are now sideways on the tree
				and slipping around faster. ";
				break;
			case 4:
				"Your body shifts all the way around, and you are now
				clinging to the underside of the tree. You will soon 
				lose your hold completely. ";
				break;
			case 5:
				brokenTrunk.doLetGo( Me );
				break;
			case 6: 
				self.slipDaemonCount := -1;
				unnotify( self, &slipDaemon );
//				"\n[ slipDaemon deactivated ]";
				break;
		}
	}
	
	roomAction( actor, v, dobj, prep, io ) =
	{
		if ( isclass( v, sysverb ) ) 
		{
			pass roomAction;
		}
		else if ( self.climbCount > 0 )
		{
			if ( v = climbVerb || v = uVerb )
				pass roomAction;
			else
			{
				"You'd better keep climbing up. ";
				exit;
			}
		}
		else if ( v = inspectVerb && dobj = trunkRoomAtticOpening )
		{
			pass roomAction;
		}
		else if ( v = holdOnVerb || v = climbVerb || v = helpVerb || v = climbdownVerb ||
				v = prayVerb || v = relaxVerb || v = yellVerb || v = yellForVerb ||
				v = dropVerb || v = letGoVerb || v = cryVerb || v = uVerb || 
				v = jumpVerb )
		{
			pass roomAction;
		}
		else
		{
			"You have to stop yourself from falling. ";
			exit;
		}
	}
;

brokenTrunk: block
	sdesc = "broken trunk"
	ldesc = "It is hanging by splinters, and slickened from recent rains. "
	noun = 'trunk'
	adjective = 'broken'
	location = hangingForDearLife
	
	verDoHoldOn( actor ) = {}
	doHoldOn( actor ) = 
	{
		if ( hangingForDearLife.relaxedOnce )
			"Your grip is once again firm and secure, for the moment. ";
		else
			"You try to hold on, but the more you strain your tensed muscles
			the more you continue to slide. It's like asking a rock to adhere
			to a sheet of wet glass. ";
	}
	
	verDoDrop( actor ) = {}
	doDrop( actor ) = 
	{
		self.doLetGo( actor );
	}
	
	verDoLeapTo( actor ) = {}
	doLeapTo( actor ) =
	{
		self.doLetGo( actor );
	}
	
	verDoLetGo( actor ) = {}
	doLetGo( actor ) = 
	{
		unnotify( hangingForDearLife, &slipDaemon );
		
		switch( rescue.rescuer )
		{
			case 0:
				"You let go of the trunk with your legs, and the weight of them 
				dropping is enough to pull your hands free of the slippery bark. 
				You plummet far and fast, and a terrible jolt shocks its way from 
				your feet up to your skull, jamming all of your bones and innards 
				upward in a series of collisions, like a cue cracking into a line 
				of billiard balls. When the final ball, your brain, is concussed 
				against the top of your cranium, you black out. \b";
				
				morePrompt();
				
				"When you come to, you find yourself shivering from shock, and
				unfortunately unable to tell the extent of your injuries. A slight
				movement of your leg brings a searing pain that tells you that 
				you have, at the very least, broken an ankle. ";
				
				FsouthOfHouse.ankle := true;
				Me.travelTo( FsouthOfHouse );
				break;
			case 1:
				"You let go of the trunk with your legs, and the weight of them 
				dropping is enough to pull your hands free of the slippery bark. \b
				
				\"I gotcha! I gotcha!\"\ <<rescue.rescuer = 1 ? "a" : "the">> gravelly 
				voice below shouts as you plummet. Instead of a hard collision, the 
				next thing you feel is a bizarre and disorienting tangle of arms and 
				legs, some of them probably belonging to you. The voice exclaims, 
				\"Oof!\" Whoever it is has not so much caught you as acted as a 
				human mattress. \b";
				
				morePrompt();
				FsouthOfHouse.lookAround( true );
				
				"\bYou roll off of your rescuer and shakily stand up. Nothing seems
				to be broken, and you hope the same is the case for him. \b
				
				\"Help me up, help me up,\" he wheezes. You extend a hand, and
				pull the man to his feet. It seems to be an old wino, dressed in
				filthy clothes that reek of urine and booze. He has a pudgy frame 
				with an enormous bloated gut, and twizzled grey eyebrows. He 
				hasn't shaved in a long time. \b
				
				His bloodshot eyes show a brief sign of sparkle when you first 
				look in them. ";
				
				if ( Fred.met )
				{
					"You are horrified when you recognize that this is Fred, the man 
					from the sandwich shop. ";
					
					Fred.lookedAtOnce := true;
				}
				
				"\b\^<<FFred.thedesc>> says, \"What the hell were you tryin' to 
				do? Crazy kid.\" He looks away and then back again, and you no 
				longer see the sparkle, only a melancholy darkness. ";
				
				setit( FFred, 1 );
				FFred.met := true;
				FFred.isSeen := true;
				FFred.moveInto( FsouthOfHouse );
				notify( FFred, &actorDaemon2, 0 );
				Me.moveInto( FsouthOfHouse );
				break;
			case 2:
				"You let go of the trunk with your legs, and the weight of them 
				dropping is enough to pull your hands free of the slippery bark. \b
				
				\"I got him! I got him!\"\ <<rescue.rescuer = 1 ? "a" : "the">> hard 
				masculine voice below shouts as you plummet. Instead of a hard 
				collision, the next thing you feel is a pair of powerful arms 
				catching you. Whoever it is sets you back on your feet. \b";
				
				morePrompt();
				Me.moveInto( FsouthOfHouse );
				FsouthOfHouse.lookAround( true );
				
				"You see three people in dark suits, two men and one woman. The
				man who caught you asks if you are okay, shakes your hand, and
				introduces himself as Carl. The other imposing gentleman, Victor,
				tells you that you were lucky they were here. \b";
				
				FLaura.meetLaura;
				break;
			case 3:
				break;
		}
	}
	
	verDoRelax( actor ) = {}
	doRelax( actor ) =
	{
		if ( not hangingForDearLife.relaxedOnce )
		{
			"Against all of your instincts, you relax your muscles.
			This is not easy to do, but it seems to help. You ease up,
			but you do not fall. In fact, you seem to halt and hold 
			steady, not slipping any more -- at least for the moment. \b
			
			You take a deep breath. Maybe you can make it out of this. ";
			
			hangingForDearLife.relaxedOnce := true;
		}
		else if ( hangingForDearLife.relaxedButSlippingAgain )
		{
			if ( hangingForDearLife.slipDaemonCount = 4 )
				"The time to relax is over, and now you've lost all of 
				your chances to stop yourself from falling. ";
			else
				"The time to relax is over. You are slipping again
				and need to get moving before you fall. ";
		}
		else
			"You are already as relaxed as you are liable to get, given
			the predicament. It would be best to move on to your next
			course of action. ";
	}	
	verDoClimb( actor ) = {}
	doClimb( actor ) =
	{
		if ( Me.location = hangingForDearLife )
			Me.travelTo( Me.location.up );
		else
			Me.travelTo( Me.location.north );
	}
	
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) =
	{
		Me.travelTo( Me.location.south );
	}
;

slippingHandHolds: fixedBlock
	sdesc = "handholds"
	ldesc = "Your hold on the trunk is slipping fast. "
	noun = 'handhold'
	plural = 'handholds'
	isThem = true
	adjective = 'holds' 'hold' 'waterlogged' 'bark' 'strong' 'top' 'branches'
			'tree' 'grip' 'limb' 'limbs'
	location = hangingForDearLife
	
	verDoTake( actor ) = {}
	doTake( actor ) = { brokenTrunk.doHoldOn( actor ); }
	
	doHoldOn -> brokenTrunk
	doLetGo -> brokenTrunk
	doRelax -> brokenTrunk
;

rescue: fixedBlock
	sdesc = "help"
	ldesc = "There doesn't seem to be anyone to help you here. "
	noun = 'rescue'
	adjective = 'help' 'aid' 'safety'
	location = hangingForDearLife
	rescuer = 0
	
	verDoPrayFor( actor ) = {}
	doPrayFor( actor ) = 
	{
		"You pray for help, and you pray with a fervency that comes out of any
		human soul in a moment of pure desperation. ";
		
		self.prayedForHelp := true;
		self.decideWhoComesForHelp;
	}
	
	verDoYellAt( actor ) = {}
	doYellAt( actor ) = { self.doYellFor( actor ); }
	
	screamCount = 0
	verDoYellFor( actor ) = {}
	doYellFor( actor ) =
	{
		if ( Me.location = hangingForDearLife )
		{
			self.screamCount++;
			switch( self.screamCount )
			{
				case 1:
					"The scream comes tearing out of your throat, louder than you 
					expected, borne of a terror more real than you have faced before.
					Your voice pierces the humid air, carrying for miles. In the near
					distance, you think hear a voice respond. You aren't sure. ";
					
					self.decideWhoComesForHelp;
					break;
				case 2:
					"You scream again, aiming your voice to the front of the house.
					You hear feet running across wet dirt, slapping into puddles.
					You can't see who is below you, but someone is there. \b
					
					A voice yells up to you, \"Let go! <<self.rescuer = 1 ? 
					"I" : "We">>'ll catch you!\" ";
					break;
				case 3:
					"The voice yells back, \"Stop yelling and drop already! 
					Trust <<self.rescuer = 1 ? "me" : "us">>!\" ";
					break;
			}
		}
		else if ( isclass( Me.location, FtreeRoom ) && Me.location != FmidTree )
		{
			"You got yourself into this situation. You might as well just make
			the best of it and keep going, rather than yelling for help you don't
			yet really need. ";
		}
		else
		{
			"You shouldn't cry wolf. What if you really need help later and
			no one comes? ";
		}
	}
	
	decideWhoComesForHelp =
	{
		if ( FLaura.met )
			self.rescuer := 1;			// Fred comes
		else
		{
			if ( self.prayedForHelp )
				self.rescuer := 1;			// Fred comes
			else 
				self.rescuer := 2;			// Laura and her goons come
			
//			else if ( self.prayedForHelp && FLaura.met )
//			self.rescuer := 3;			// Fred, Laura, and goons come
		}
	}
;

endOfTrunk: FtreeRoom
	sdesc = "End of the trunk"
	ldesc = "You are almost there. You can nearly touch the ragged sides
		of the house wall to your left. Inside, you can see the 
		floorboards. Receded far into the shadows, you see the attic
		ladder, and that it is open. "
	xdesc = "Just a little farther, and you can go in, you can go down, 
		you can be inside your house, safe. "
	north = 
	{
		"Slowly, slowly, with painstaking care, you shift your weight
		forward on the thin, drooping upper branches, until you see
		attic floorboards beneath you instead of open air. Gingerly,
		you stretch a foot down, but just as your toe makes contact,
		the branch in your right hand, which was holding your weight
		and steadying your balance, snaps. You hurtle yourself forward
		into a roll, desperate to get your mass moving inward instead
		of outward. \b
		
		Amid a tangle of crackling and snapping noises; none of them
		your bones, fortunately; you find yourself, scratched but
		safe, inside the attic of your house. You crawl another foot
		away from the gaping opening before your fear of falling abates
		enough to allow you to stand up. You're safe. \b";
		
		return( Fattic );
	}
	floorDesc = "The thick floorboards should run in parallel lines, but are now somewhat
			warped, with large gaps in between. "
	down = { return( self.north ); }
	in = { return( self.north ); }
	south = "There is no way you are going to travel back now. "
;

endOfTrunk_housewall: staticItem
	sdesc = "house wall"
	ldesc = "The house wall is raked open by the fallen tree trunk. "
	noun = 'wall'
	adjective = 'house' 'ragged' 'side' 'sides'
	location = endOfTrunk
	
	verDoTouch( actor ) = {}
	doTouch( actor ) = { "The sides are ragged and slickened with rain. "; }
	verDoEnter( actor ) = {}
	doEnter( actor ) = { trunkRoomAtticOpening.doEnter( actor ); }
;

Fattic: room
	indoors = true
	sdesc = "Attic"
	ldesc = 
	{
		if ( future.state = 3 )
			"A little attic space, once barely tall enough for you to stand in,
			now has a huge, gaping hole raked open in	the roof and the 
			southern wall. Silvery rivulets of rain water drizzle down
			from above, pooling in the uneven floorboards. The twisted 
			top of the tree provides a gnarled support structure for the 
			damaged roof. The jagged, splayed ends of a thick brass pipe
			jut up through the floor. ";
		else if ( future.state = 5 || future.state = 7 )
			"This is a little attic space, barely tall enough for you to stand in. 
			The thick floorboards should run in parallel lines, but are now somewhat
			warped, with large gaps in between. A tiny window to the south has 
			been boarded up. ";
		else
			"You have cheated and gotten here by some strange means! That's
			okay, though, I guess. A little attic space, once barely tall 
			enough for you to stand in, now has a huge, gaping hole raked 
			open in the roof and the southern wall. Silvery rivulets of rain 
			water drizzle down from above, pooling in the uneven floorboards. 
			The twisted top of the tree provides a gnarled support structure 
			for the damaged roof. The jagged, splayed ends of a thick brass pipe
			jut up through the floor. ";
		
		if ( not wrench.takenOnce )
		{
			"\bThere is a monkey wrench lying lengthwise here, spanning the 
			gap between two floorboards. ";
		}
	}
	xdesc = "A ladder attached to a hatch leads down into the darkened 
			house below. "
	listenDesc = 
	{
		if ( future.state = 3 || future.state = 4 || future.state = 6 )
			return( 'You hear the steady drip and drizzle of water coming
			in from the open roof. ');
		else if ( future.state = 5 || future.state = 7 )
			return( 'You hear the steady drip and drizzle of water sliding
			off the roof overhead. ');
	}
	smellDesc = 
	{
		if ( future.state = 3 || future.state = 4 || future.state = 6 )
			"The attic smells of wet, decaying wood, and the round
			stink of mold. ";
		else if ( future.state = 5 || future.state = 7 )
			"The attic smells of must and dust. ";
	}
	floorDesc = "The thick floorboards should run in parallel lines, but are now somewhat
			warped, with large gaps in between. "
	out = { return( self.south ); }
	south = {
		"You can't go out by way of the ";
		if ( future.state = 5 || future.state = 7 )
			"window, since it's been boarded up. ";
		else {
			"tree. The trunk is too unstable to risk a return trip. ";
		}
	}
	down = 
	{
		"You descend the hatch ladder. \b";
		return( FupstairsHallway );
	}
	firstseen = 
	{
		setit( wrench );
		if ( not FLaura.met && FLaura.daemonCount = 0 ) {
			notify( FLaura, &actorDaemon, 0 );	// summon future-Laura
		}
	}
;

Fattic_tree: fixedBlock, floatingItem
	sdesc = "top of the tree"
	ldesc = "The top of the tree dangles its cracked, wet limbs into the gaping
		hole in the wall and roof. "
	noun = 'tree'
	adjective = 'top' 'leaves' 'limbs' 'branches' 'branch' 'limb' 'wet' 'cracked'
		'dangling' 'trunk'
	location = 
	{
		if ( future.state = 3 )
			return( Fattic );
		return( nil );
	}
	
	verDoClimb( actor ) = { "The trunk is too unstable to risk a return trip. "; }
	verDoClimbDown( actor ) = { "The trunk is too unstable to risk a return trip. "; }
	verDoBoard( actor ) = { "The trunk is too unstable to risk a return trip. "; }
	verDoEnter( actor ) = { "The trunk is too unstable to risk a return trip. "; }
;

Ffloorboards: unimportantItem
	sdesc = "floorboards"
	ldesc = "The thick floorboards should run in parallel lines, but are now somewhat
			warped, with large gaps in between. "
	noun = 'floorboard'
	plural = 'floorboards'
	isThem = true
	location = attic
;

floorboardGap: unimportantItem
	sdesc = "gap"
	ldesc = 
	{
		if ( not wrench.takenOnce )
		{
			"There is a monkey wrench lying lengthwise here, spanning the 
			gap between two floorboards. ";
			
			setit( wrench );
		}
		else pass ldesc;
	}
	noun = 'gap'
	plural = 'gaps'
	location = Fattic
;

wrench: item
	isListed = nil
	sdesc = "monkey wrench"
	ldesc = 
	{
		"It's a long monkey wrench, capable of tightening all manner of bolts. ";
		if ( not self.takenOnce )
			"It is lying lengthwise, spanning the gap between two floorboards. ";
	}
	noun = 'wrench' 'spanner'
	adjective = 'long' 'monkey'
	location = Fattic
	
	doTake( actor ) = 
	{
		if ( not self.takenOnce )
		{
			"It's a spanner, but you take it. ";
			self.moveInto( Me );
			self.takenOnce := true;
			self.isListed := true;
		}
		else pass doTake;
	}
	
	verDoLove( actor ) = 
	{
		"I fail to see the humor in your obscure in-jokes. ";
	}
	
	verIoFixWith( actor ) = {}
	ioFixWith( actor, dobj ) =
	{
		if ( dobj = frontWheel || dobj = wheelbarrow )
		{
			if ( frontWheel.broken ) 
			{
				"With ease, you tighten the bolt holding the wheel. 
				The axle is still a little bent, but the wheel should 
				stay on. ";
				
				frontWheel.broken := nil;
				incscore( 2 );
				global.scoreCard[12] := 1;
			}
			else
			{
				"The wheel is already as fixed as it will get. ";
			}
		}
		else
		{
			"I don't know how to do that with "; self.thedesc; ". ";
		}
	}
;

FhatchLadder: staticItem
	sdesc = "hatch ladder"
	ldesc = "The hatch ladder leads down into the house. "
	noun = 'ladder'
	adjective = 'hatch'
	location = Fattic
	verDoOpen( actor ) = { "The hatch ladder is already open. "; }
	verDoClose( actor ) = 
	{
		"You can't close the hatch ladder from inside the attic. You have
		to push it shut from below. ";
	}
	verDoStandon( actor ) = 
	{
		"You stand on the top step of the hatch ladder and gaze
		into the musty darkness below. ";
	}
	verDoSiton( actor ) = 
	{
		"You sit on the top step of the hatch ladder and gaze into
		the musty darkness below. ";
	}
	verDoJumpOn( actor ) = 
	{
		if ( not self.jumpedOnce )
		{
			"You throw all common sense to the winds and jump forcefully
			onto the hatch ladder. Your slickened shoes fail to find a 
			grip, and you scrape painfully down the rungs, unable to 
			stop yourself until you hit the floor below. \b";
			self.jumpedOnce := true;
			Me.travelTo( FupstairsHallway );
		}
		else
			"Common sense tells you not to try it again. ";
	}
	verDoPush( actor ) =
	{
		"The hatch ladder is already open. ";
	}
	verDoPull( actor ) = 
	{
		"You can't close the hatch ladder from inside the attic. You have
		to push it shut from below. ";
	}
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) = 
	{
		Me.travelTo( self.location.down );
	}
	verDoClimb( actor ) = {}
	doClimb( actor ) = 
	{
		"The hatch ladder goes down, not up. ";
	}
;

FatticWindow: block, seeThruItem, floatingItem
	sdesc = "little window"
	ldesc = 
	{
		if ( self.boardedUp )
			"The little window has been boarded shut. ";
		else
		{
			"Out the window you see ";
			
			if ( ( future.state = 5 ) && ( FtinyTree.location = FsouthOfHouse ) )
				"a scrawny, dead tree and ";
			else if ( future.state = 7 )
				"the tree and ";
			
			"the ground far below. ";
		}
	}
	thrudesc = { self.ldesc; }
	noun = 'window'
	adjective = 'little' 'attic' 'ground'
	location = 
	{
		if ( future.state = 5 || future.state = 7 )
			return( Fattic );
		else
			return( nil );
	}
	boardedUp = true
	doLeapTo -> treeView
	verIoThrowOut( actor ) = 
	{
		"Throwing things out of the window isn't necessary. ";
	}
	verDoUnboard( actor ) = {}
	doUnboard( actor ) =
	{
		Me.travelTo( Me.location.south );
	}
;

atticWindowNailedBoards: staticItem
	sdesc = "boards"
	ldesc = "The boards are browned and warped. "
	noun = 'wood' 'board'
	plural = 'boards'
	isThem = true
	adjective = 'boards of' 'cheap' 'nailed' 'warped' 'browned' 'brown'
		'outline' 'notice' 'discoloration' 'jamb'
	location = Fattic
;

atticWindowPileOfBoards: staticItem
	sdesc = "pile of boards"
	ldesc = "The boards are browned and warped. Harsh, rusted nails jut 
			from the ends of each board. "
	noun = 'wood' 'board'
	plural = 'boards' 'ends' 'nails'
	isThem = true
	adjective = 'pile of' 'pile' 'harsh' 'rusted' 'rusty' 'rust' 
			'nail' 'plank' 'end'
	location = nil
	
	verDoTake( actor ) = 
	{
		"It's best to leave them alone now, as you could injure 
		yourself on the rusty nails. ";
	}
;

FtreeView: distantItem, floatingItem
	sdesc = "tree"
	noun = 'tree'
	adjective = 'scrawny' 'dead'
	location = 
	{
		if ( ( future.state = 5 ) && ( FtinyTree.location = FsouthOfHouse ) )
			return( Fattic );
		else if ( future.state = 7 )
			return( Fattic );
		else
			return( nil );
	}
	verDoLeapTo( actor ) = 
	{
		"If you jump from the window you'll break your ankle. ";
	}
;

gapingHole: block, floatingItem
	sdesc = "gaping hole"
	ldesc = "Out the gaping hole you see the trunk leading back to the tree
		and the ground far below. "
	thrudesc = { self.ldesc; }
	noun = 'hole'
	adjective = 'huge' 'gaping'
	location = 
	{
		if ( future.state = 3 )
			return( Fattic );
		return( nil );
	}
	verIoThrowOut( actor ) = 
	{
		"Throwing things out of the window isn't necessary. ";
	}
	verDoUnboard( actor ) = {}
	doUnboard( actor ) = 
	{
		Me.travelTo( Me.location.south );
	}
;

FbrassPipe: staticItem
	sdesc = "broken brass pipe"
	ldesc = 
	{
		if ( future.state = 5 || future.state = 7 )
			"It is a sturdy brass pipe. ";
		else
			"It looks like it burst open and broke. Sections are 
			missing from the middle, and the ends are sharp jags
			of splayed metal. ";
	}
	noun = 'pipe'
	adjective = 'brass' 'broken' 'jags' 'jagged' 'sharp' 'splayed' 'metal'
	location = Fattic

	verIoTieTo( actor ) = {}
	ioTieTo( actor, dobj ) =
	{
		if ( dobj = rope )
		{
			if ( future.state = 5 || future.state = 7 )
				rope.ioTieTo( actor, self );
			else
				"You can't tie the rope to the broken brass pipe. ";
		}
		else
			"I'm not sure how to tie that to <<self.thedesc>>. ";
	}
;

graffiti: block, readable, floatingItem
	sdesc = "graffiti"
	ldesc = "The graffiti covers the walls. It is the markings of 
			territorial youth, strange symbols and stylized lettering.
			What little of it makes sense to you is obscene. "
	noun = 'graffiti'
	plural = 'swirls' 'walls'
	adjective = 'spraypainted' 'strange' 'shocking' 'swirl' 'spraypaint' 'spray-paint'
			'swirls of' 'black' 'silver' 'spray' 'paint' 'wall'
	location = 
	{
		if ( Me.location.graffito )
			return( Me.location );
	}
;

FupstairsHallway: graffiti_room
	sdesc = "Upstairs hallway"
	ldesc = "You are in the upstairs hallway, but it has been desecrated
			nearly beyond recognition. The once pristine white carpeting
			has been stained and burned, and a section of it has been
			torn up, revealing the shredded matting underneath. The
			walls have been spraypainted with unreadable graffiti,
			shocking swirls of black and silver paint. A fist sized 
			hole has been smashed into the east wall, and the light
			fixture in the ceiling has been torn out, leaving gangly
			dangling wires and a darkness that oppresses. "
	firstseen =
	{
		"\bPerhaps it is just as well that the lights are out, as they
		would only illuminate more ugliness, perhaps more than you 
		could bear. ";
	}
	xdesc = 
	{
		if ( hallwayLadder.isopen )
			"The hatch ladder leads back up into the attic. ";
		else
			"The hatch ladder to the attic is closed up into the
			ceiling. ";
		"A rickety staircase leads down to the bottom floor. To the
		east is the upstairs bathroom, and a bedroom is to the south.
		A smaller bedroom is north. ";
	}
	floorDesc = "The once pristine white carpeting has been stained and burned, 
			and a section of it has been torn up, revealing the shredded 
			matting underneath. "
	listenDesc = 'You hear the spooky knocks and creaks of an old house\'s
				floorboards settling under your added weight. '
	upstairs = true
	up = 
	{
		if ( hallwayLadder.isopen )
		{
			if ( future.state = 4 || future.state = 6 )
			{
				"You start to climb the ladder into the attic, but
				you quickly find that there is no attic to go to right
				now. The roof has collapsed, sealing it off. ";
				return( nil );
			}
			else
			{
				"You climb the ladder into the attic. ";
				return( Fattic );
			}
		}
		else
		{
			"You can't go up unless you open the hatch ladder. ";
			return( nil );
		}
	}
	down = 
	{
		"You descend the staircase. ";
		return( Ffoyer );
	}
	east = FupstairsBathDoor1
	south = FupstairsBedroomS
	north = 
	{
		if ( future.state = 4 || future.state = 6 )
			return( FcollapsedUpstairsBedroomN );
		else return( FupstairsBedroomN );
	}
;

danglingWires: block
	sdesc = "dangling wires"
	ldesc = "The light fixture has been yanked out of the ceiling,
			leaving only dangling wires. "
	noun = 'wire'
	plural = 'wires'
	isThem = true
	adjective = 'light' 'fixture' 'dangling' 'gangly'
	location = FupstairsHallway
	verDoPull( actor ) = { "Enough damage has been done already. "; }
	verDoBreak( actor ) = { "Enough damage has been done already. "; }
;

darkness: block
	sdesc = "darkness"
	adesc = "darkness"
	ldesc = "The darkness is oppressive, yet ironically comforting, hiding
			details that you would rather not see. "
	noun = 'darkness' 'dark'
	location = FupstairsHallway
;

holeInWall: staticItem, searchHider
	sdesc = "hole"
	ldesc = "The hole looks like it was made by a fist striking the wall. "
	noun = 'hole'
	adjective = 'fist' 'sized' 'fist-sized' 'fistsized'
	location = FupstairsHallway
	
	verDoLookthru( actor ) = { self.verDoSearch( actor ); }
	doLookthru( actor ) = { self.doSearch( actor ); }
	
	searchObj(actor, list) =
	{
		if ( not self.alreadySearched )
		{
			"For a moment, you are reluctant to put your hand down
			into the hole, cautious about what you might find. With
			care, you slip your hand in. ";
			
			self.alreadySearched := true;
			
			if ( FFred.daemonCount = 0 )		// if daemon not already running
				notify( FFred, &actorDaemon, 0 );	//Fred comes looking for it
		}
		pass searchObj;
	}
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"He says, \"I stay away from that cheap stuff. My dad used to
				drink that rotgut. Not that I really drink.\" He winks at you
				and says, \"Not on the job, anyway.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

whiskeyBottle: item, readable, hiddenItem
	sdesc = "bottle of cheap liquor"
	ldesc = "The label says \"Crow's Feet\". "
	smellDesc = "It smells like harsh, stomach-churning booze, harsh enough
			to make your eyes water. "
	noun = 'bottle' 
	adjective = 'bottle of' 'corn-squeezins' 'rotgut' 'whisky' 'cheap' 'corn' 'squeezings'
			'squeezins' 'whiskey' 'crow\'s' 'feet' 'label' 'liquor' 'booze' 'hooch'
	searchLoc = holeInWall
	readdesc = { self.ldesc; }
	
	verDoTaste( actor ) = 
	{
		"It tastes like distilled shoe leather that has been soaking in
		formaldehyde, with a twist of rancid peach pits. ";
	}
	
	verDoDrink( actor ) = 
	{
		"Just the smell of it makes you nauseous. Drinking it would make you
		quite ill. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"He says, \"I stay away from that cheap stuff. My dad used to
				drink that rotgut. Not that I really drink.\" He winks at you
				and says, \"Not on the job, anyway.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

Fcarpeting: fixeditem
	sdesc = "carpeting"
	ldesc = "It has been stained, burned, and torn up. "
	noun = 'carpet' 'carpeting'
	adjective = 'white' 'stained' 'burned' 'pristine' 'once'
	location = FupstairsHallway
	verDoPull( actor ) = { "Enough damage has been done already. "; }
	verDoBreak( actor ) = { "Enough damage has been done already. "; }
;

matting: block
	sdesc = "matting"
	ldesc = "The exposed matting has been shredded. "
	noun = 'matting' 'mat'
	plural = 'shreds'
	adjective = 'torn' 'section' 'shred' 'shredded' 'revealed' 'exposed'
	location = FupstairsHallway
	verDoPull( actor ) = { "Enough damage has been done already. "; }
	verDoBreak( actor ) = { "Enough damage has been done already. "; }
;

FhouseStaircase: fixedBlock, floatingItem
	sdesc = "stairs"
	noun = 'case'
	adjective = 'stairs' 'steps' 'staircase' 'stair' 'stairway' 'way' 'banister'
	location = 
	{
		if ( Me.location = FupstairsHallway || Me.location = Ffoyer )
			return( Me.location );
		else return( nil );
	}
	
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) = 
	{
		if ( Me.location = FupstairsHallway )
			Me.travelTo( Me.location.down );
		else 
		{
			"The staircase goes up, not down. ";
			return( nil );
		}
	}
	verDoClimb( actor ) =
	{
		if ( Me.location = Ffoyer )
			Me.travelTo( Me.location.up );
		else 
		{
			"The staircase leads down, not up. ";
			return( nil );
		}
	}
;

hallwayLadder: doorway
	sdesc = "hatch ladder"
	ldesc = "The hatch ladder leads up into the attic. "
	noun = 'ladder'
	adjective = 'hatch'
	doordest = Fattic
	location = FupstairsHallway
	isopen = true
	
	verDoClimb( actor ) = {}
	doClimb( actor ) =
	{
		Me.travelTo( self.location.up );
	}
	verDoStandon( actor ) = 
	{
		"You stand for a moment on the bottom step of the hatch ladder. ";
	}
	verDoSiton( actor ) = 
	{
		"You sit for a moment on the bottom step of the hatch ladder. ";
	}
	verDoJumpOn( actor ) = 
	{
		"The hatch ladder is at too steep an angle for you to jump 
		onto it. ";
	}
	verDoPush( actor ) = { self.verDoClose( actor ); }
	verDoPull( actor ) = { self.verDoOpen( actor ); }
	doPush( actor ) = { self.doClose( actor ); }
	doPull( actor ) = { self.doOpen( actor ); }
;

FupstairsBathroom: graffiti_room
	isBathroom = true
	upstairs = true
	sdesc = "Upstairs bathroom"
	ldesc = "This is a hideous scene of waste and ruin. It looks as if someone
			took a sledgehammer to the place, destroying the tub and breaking
			tiles off the walls. The sink has been ripped out, it is gone.
			Someone attempted to do the same to the toilet, leaving it yanked
			out at an angle but still attached to the floor. Swimming in the
			bowl is a foul brackish that fills the room with a rancid stench.
			The mirror above the sink area is cracked but still attached by its 
			hinges to the medicine cabinet behind it. A broken window looks out
			into the front yard. "
	xdesc = "The only exit is west, back into the hallway. "
	west = FupstairsBathDoor2
	smellDesc = "The room smells of rancid waste. "
	myToilet = upstairsToilet
;

bathroomFixture: unimportantItem
	sdesc = "fixture"
	noun = 'fixture'
	adjective = 'bathtub' 'tub' 'tile' 'tiles' 'sink' 'hinge' 'faucet'
	location = FupstairsBathroom
;

bathroomFixtures: unimportantItem
	sdesc = "fixtures"
	noun = 'hinges' 'faucets'
	plural = 'fixtures'
	isThem = true
	location = FupstairsBathroom
;

cabinetMirror: fixedBlock
	sdesc = "mirror"
	ldesc = "It's attached to the medicine cabinet. "
	noun = 'mirror'
	location = FupstairsBathroom
	
	verDoLookin( actor ) = {}
	doLookin( actor ) = 
	{
		"You see a cracked reflection of yourself. ";
	}
	
	doOpen -> medicineCabinet
;

medicineCabinet: fixedBlock, openable
	sdesc = "medicine cabinet"
	noun = 'cabinet'
	adjective = 'medicine'
	location = FupstairsBathroom
;

upstairsToilet: fixedBlock
	sdesc = "toilet"
	ldesc = "Swimming in the bowl is a foul brackish that fills the room 
			with a rancid stench. "
	noun = 'facilities'
	adjective = 'seat' 'bowl' 'foul' 'brackish' 'rancid' 'stench' 'water' 'toilet'
			'john' 'loo' 'wc' 
	smellDesc = "It is one of the most nauseating, terrible smells you can recall. "
	location = FupstairsBathroom
	
	verDoSiton( actor ) = 
	{
		"You really don't want to do that. ";
	}
	verDoDrink( actor ) =
	{
		"That would be extraordinarily poisonous. ";
	}
	verDoFlush( actor ) =
	{
		"The plumbing no longer works. ";
	}
	doExcreteIn( actor ) =
	{
		"That's not a good idea. The plumbing no longer works, and you 
		don't need to add to what's already there. ";
	}
;

brokenWindow: unimportantWindow
	sdesc = "broken window"
	ldesc = 
	{
		"Outside you see the front of the house. ";
		
		if ( FLaura.daemonCount = 1 || FLaura.daemonCount = 2 )
			"Parked in the driveway is a dark sedan. ";
	}
	noun = 'window'
	adjective = 'broken'
	location = FupstairsBathroom
;

FupstairsBathDoor1: doorway
	sdesc = "small door"
	noun = 'door'
	adjective = 'small'
	otherside = FupstairsBathDoor2
	location = FupstairsHallway
	doordest = FupstairsBathroom
;

FupstairsBathDoor2: doorway
	sdesc = "small door"
	noun = 'door'
	adjective = 'small'
	otherside = FupstairsBathDoor1
	location = FupstairsBathroom
	doordest = FupstairsHallway
;

FupstairsBedroomS: graffiti_room
	upstairs = true
	sdesc = "Upstairs bedroom"
	ldesc = "The larger of the two upstairs bedrooms has been looted, but the
			mattress and bedframe remain. The graffiti on the walls is 
			sadistic and nasty. A pile of random debris clogs the northern
			corner of the room. "
	listenDesc = 'Wind whines through the cracked glass of the windows which face
				east out to the front of the house. '
	smellDesc = "The air in here is dank and redolent of mold. "
	xdesc = "The hallway is to the north. "
	north = FupstairsHallway
;

SbedroomStuff: unimportantItem
	sdesc = "stuff"
	noun = 'stuff'
	adjective = 'mattress' 'bed' 'bedframe' 'frame' 'pile' 'random' 'debris'
			'northern' 'corner' 'window' 'windows' 'cracked' 'glass'
	location = FupstairsBedroomS
;

SbedroomWindows: unimportantWindow
	sdesc = "windows"
	ldesc = 
	{
		"Wind whines through the cracked glass of the windows which face
		east out to the front of the house. ";
		
		if ( FLaura.daemonCount = 1 || FLaura.daemonCount = 2 )
			"Parked in the driveway is a dark sedan. ";
	}
	noun = 'window'
	plural = 'windows'
	isThem = true
	adjective = 'cracked' 'glass' 'front'
	location = FupstairsBedroomS
;

FupstairsBedroomN: graffiti_room
	upstairs = true
	sdesc = "Smaller upstairs bedroom"
	ldesc = "The smaller of the two upstairs bedrooms has a sloped ceiling where
			it meets the edge of the north roof. Two windows face east, 
			miraculously unbroken but fogged with dirt and sediment from 
			rains. The furniture is all gone -- the bed, the small dresser,
			the old writing desk -- all that you remember. A picture frame
			hangs on the wall, but the photo it held is gone, and the glass
			has been spraypainted over. "
	smellDesc = "The room smells stale and dusty. "
	xdesc = "The hallway is to the south. "
	south = FupstairsHallway
;

NbedroomWindows: unimportantWindow
	sdesc = "windows"
	ldesc = 
	{
		"Two windows face east, miraculously unbroken but fogged with dirt 
		and sediment from rains. You see the front of the house and 
		some of the driveway. ";
		
		if ( FLaura.daemonCount = 1 || FLaura.daemonCount = 2 )
			"Parked in the driveway is a dark sedan. ";
	}
	noun = 'window'
	plural = 'windows'
	isThem = true
	adjective = 'fog' 'fogged' 'dirt' 'sediment' 'rains'
	location = FupstairsBedroomN
;

NbedroomStuff: unimportantItem
	sdesc = "stuff"
	noun = 'stuff'
	adjective = 'sloped' 'ceiling' 'roof' 'edge' 
	location = FupstairsBedroomN
;

missingStuff: unimportantItem
	sdesc = "stuff"
	ldesc = "That is no longer here. "
	noun = 'furniture' 
	adjective = 'dresser' 'desk' 'small' 'writing' 'old' 'photo'
	location = FupstairsBedroomN
;

pictureFrame: unimportantItem
	sdesc = "picture frame"
	ldesc = "A picture frame hangs on the wall, but the photo it held is gone, 
			and the glass has been spraypainted over. "
	noun = 'frame'
	adjective = 'picture' 'photo'
;

FcollapsedUpstairsBedroomN: graffiti_room
	upstairs = true
	sdesc = "Collapsed bedroom"
	ldesc = "The smaller of the two upstairs bedrooms has been destroyed, barely
			allowing access into it. The sloped ceiling where it mets the 
			edge of the north roof has caved in, collapsing rotten shingles,
			plaster, and other debris into the room. "
	smellDesc = "The room smells like wet, rotten shingles. "
	xdesc = "The hallway is to the south. "
	south = FupstairsHallway
;

collapsedNbedroomStuff: unimportantItem
	sdesc = "stuff"
	ldesc = "That is no longer here. "
	noun = 'furniture' 
	adjective = 'dresser' 'desk' 'small' 'writing' 'old' 'photo'
			'sloped' 'ceiling' 'roof' 'edge' 
	location = FcollapsedUpstairsBedroomN
;

collapsedBedroomDebris: unimportantItem
	sdesc = "debris"
	noun = 'debris'
	adjective = 'collapsed' 'collapsing' 'rotten' 'wet' 'shingles' 'shingle'
			'plaster'
	location = FcollapsedUpstairsBedroomN
;

Ffoyer: graffiti_room
	downstairs = true
	sdesc = "Foyer"
	ldesc = "The entryway to your home has been used as a dumping ground for 
			trash and broken bottles. The tiled floor has been scuffed and
			scarred, and swirled with what looks suspiciously like tire
			treads. Open doorways lead to various areas of the house. "
	xdesc = "A broken staircase leads up to the second floor. The front 
			door is east. A hallway leads south, and the dining room
			is through a doorway to the west. "
	floorDesc = "The tiled floor has been scuffed and scarred, and swirled with 
			what looks suspiciously like tire treads. "
	east = FfrontDoorInside
	up = 
	{
		"You ascend the staircase. ";
		return( FupstairsHallway );
	}
	north = Fkitchen
	west = FdiningRoom
	south = FdownstairsHallway
;

foyerStuff: unimportantItem
	sdesc = "stuff"
	noun = 'stuff'
	adjective = 'dumping' 'dump' 'trash' 'broken' 'bottle' 'bottles' 
	location = Ffoyer
;

tireTreads: unimportantItem
	sdesc = "tire treads"
	ldesc = "The tiled floor has been scuffed with what looks like tire treads. "
	noun = 'tread'
	plural = 'treads'
	isThem = true
	adjective = 'tire' 'tyre' 'tile' 'tiled' 'scuff' 'scuffed' 'scuffs'
			'scar' 'scars' 'scarred' 
	location = Ffoyer
;

FfrontDoorInside: lockableDoorway
	sdesc = "front door"
	ldesc = 
	{
		"Unlike the rest of your house, the door still looks firm and strong. ";

		if ( otherside.pried )
		{
			"It hangs loosely ";
			if ( otherside.isopen )
				"open ";
			else
				"closed ";
			"on its damaged hinges. ";
		}
		else if ( not nailedBoards.pried )
			"The door has been nailed shut from the outside. The nails poke
			through the jamb and the door itself. ";
	}
	noun = 'door'
	adjective = 'front' 'jamb'
	otherside = FfrontDoor
	location = Ffoyer
	doordest = FfrontOfHouse
	islocked = true
	isopen = nil
	mykey = duplicateKey
	noAutoOpen = true
	
	verDoOpen( actor ) =
	{
		if ( not nailedBoards.pried )
		{
			"The outside of the door has been nailed shut with boards 
			and cannot be opened. ";
		}
		else if ( not self.pried )
		{
			if ( self.islocked )
				"It is locked as well as swollen shut. ";
			else
				"It is unlocked but swollen shut. ";
		}
		else if ( self.isopen )
			"It is already open. ";
	}
	doUnlock( actor ) =
	{
		self.setIslocked( nil );
		
		if ( not self.unlockedOnce )
		{
			"It's a strain to turn the rusted lock, but you do so. ";
			self.unlockedOnce := true;
		}
		else
			"Unlocked. ";
	}
;

FfrontDoorInsideNails: unimportantItem
	sdesc = "nails"
	ldesc = "The door has been nailed shut from the outside. The nails poke
			through the jamb and the door itself. "
	noun = 'nail'
	plural = 'nails'
	isThem = true
	unimportantMsg = "The nailed boards are outside. You will have to go there
		if you want to do something about them. "
	location = Ffoyer
;	

Fkitchen: graffiti_room
	downstairs = true
	sdesc = "Kitchen"
	ldesc = "The kitchen has been looted and trashed, as if anger had been vented
			upon it once its supplies ran out. Every cabinet and drawer has 
			been opened, and some of the drawers are heaped in a broken pile
			on the floor. The refrigerator is wide open and full of disgusting
			green stains and patterns of blackening mold. The stove has been
			dented and shows evidence of muddy footprints having stood on top
			of it and kicked it. The small kitchen table has been overturned 
			in the western corner of the room. Windows look out west and east
			to the back and front yards. "
	xdesc = "The dining room is west, and the foyer is to the south. 
			A back door leads north into the garage. "
	west = FdiningRoom
	south = Ffoyer
	north = FkitchenBackDoor
	floorDesc = "Some of the drawers are heaped in a broken pile on the floor. "
;

kitchenWindows: unimportantWindow
	sdesc = "windows"
	ldesc = 
	{
		"You see west out into the back yard and east into the corner of 
		the driveway where it curves around to the front of the garage. ";
		
		if ( FLaura.daemonCount = 1 || FLaura.daemonCount = 2 )
			"Parked in the driveway is a dark sedan. ";
	}
	noun = 'window'
	plural = 'windows'
	isThem = true
	location = Fkitchen
;

kitchenTable: unimportantItem
	sdesc = "kitchen table"
	ldesc = "The small kitchen table has been overturned in the western corner of 
			the room. Windows look out west and east to the back and front yards. "
	noun = 'table'
	adjective = 'kitchen' 'small' 'overturned' 'western' 'corner'
	location = Fkitchen
;	

stove: unimportantItem
	sdesc = "stove"
	ldesc = "The stove has been dented and shows evidence of muddy footprints
			having stood on top of it and kicked it. "
	noun = 'stove'
	location = Fkitchen
	
	verDoStandon( actor ) =
	{
		"Enough damage has been done already. ";
	}
	verDoKick( actor ) =
	{
		"Enough damage has been done already. ";
	}
	dobjGen(a, v, i, p) =
	{
		if ( v != askVerb && v != tellVerb && v != inspectVerb &&
			 v != whereIsVerb && v != kickVerb && v != standOnVerb )
		{
			"\^<<self.thatdesc>> <<self.isntdesc>> important.";
			exit;
		}
	}
;

cabinets: unimportantItem
	sdesc = "cabinets and drawers"
	ldesc = " Every cabinet and drawer has been opened, and some of the drawers 
			are heaped in a broken pile on the floor. "
	noun = 'cabinet'
	plural = 'cabinets'
	isThem = true
	adjective = 'drawer' 'drawers' 'heap' 'heaped' 'broken' 'pile'
	location = Fkitchen
;

refrigerator: unimportantItem
	sdesc = "refrigerator"
	ldesc = "The refrigerator is wide open and full of disgusting
			green stains and patterns of blackening mold. "
	noun = 'refrigerator'
	adjective = 'frige' 'fridge' 'disgusting' 'black' 'blackening' 'mold'
	location = Fkitchen
;

pluralKitchenStuff: unimportantItem
	sdesc = "stains and mold"
	noun = 'stain'
	plural = 'stains'
	isThem = true
	adjective = 'disgusting' 'green' 'black' 'blackening' 'blackened' 'mold'
			'pattern' 'patterns' 'muddy' 'mud' 'footprints' 'footprint'
			'dent' 'dents'
	location = Fkitchen
;

FkitchenBackDoor: doorway
	sdesc = "back door"
	noun = 'door'
	adjective = 'back'
	otherside = FgarageBackDoor
	location = Fkitchen
	doordest = FinGarage
	isopen = nil
//	islocked = true
	noAutoOpen = true
	
	doOpen( actor ) = 
	{
		if ( not FFred.met )
		{
			"As you reach for the door, you hear a thump and a crash from the
			other side of it. ";
			self.noAutoOpen := nil;
			self.otherside.noAutoOpen := nil;
			notify( FFred, &actorDaemon, 0 );
		}
		else pass doOpen;
	}
;

FdiningRoom: graffiti_room
	downstairs = true
	sdesc = "Dining room"
	ldesc = "The dining room, which you had recently converted into a study area, 
			has been kicked around and spraypainted in a similar fashion to the
			other rooms in the house, but the large table remains standing where
			you left it. Piled upon it are empty cans and bottles, and its surface
			is mottled with cigarette burns and knife marks. A bookcase that stood
			in the southern corner of the room is missing, but a pile of yellow,
			water-damaged books remains in its place, underneath more trash. Two 
			large windows face west out to the back yard. The fireplace, too, is
			cluttered with debris. "
	xdesc = "The kitchen is east, and the living room is to the south. 
			A doorway at the southeast corner of the room leads to
			the foyer. "
	east = Fkitchen
	south = FlivingRoom
	se = Ffoyer
;

largeWindows: unimportantWindow
	sdesc = "large windows"
	ldesc = "Through them you see west out into the back yard. "
	noun = 'window'
	plural = 'windows'
	isThem = true
	adjective = 'large'
	location = FdiningRoom
;

largeTable: unimportantItem
	sdesc = "large table"
	ldesc = "Piled upon it are empty cans and bottles, and its surface
			is mottled with cigarette burns and knife marks. "
	noun = 'table'
	adjective = 'large' 'surface'
	location = FdiningRoom
;

tableStuff: unimportantItem
	sdesc = "burns and marks"
	noun = 'mark'
	plural = 'marks'
	isThem = true
	adjective = 'empty' 'cans' 'can' 'bottle' 'bottles' 'mottling' 'mottled'
			'cigarette' 'burns' 'burn' 'knife' 
	location = FdiningRoom
;

diningRoomBookcase: unimportantItem
	sdesc = "missing bookcase"
	ldesc = "It is no longer here. "
	noun = 'bookcase' 'case' 'southern' 'corner'
	location = FdiningRoom
;

pileOfDamagedBooks: unimportantItem
	sdesc = "pile of water-damaged books"
	ldesc = "The books have been water-damaged and are all worthless. You sadly
			recognize them as your own collection. "
	noun = 'pile'
	plural = 'books'
	isThem = true
	adjective = 'water-damaged' 'water' 'damaged' 'yellow' 'trash'
	location = FdiningRoom
;

Ffireplace: unimportantItem
	sdesc = "fireplace"
	ldesc = "The fireplace is cluttered with debris. "
	noun = 'fireplace'
	adjective = 'debris'
	location = FdiningRoom
;

FlivingRoom: graffiti_room
	downstairs = true
	sdesc = "Living room"
	ldesc = 
	{
		if ( not self.isseen )
		{
			"The first thing you notice is that your television set is still here,
			which seems ironic because you never used to watch it and were 
			planning on giving it away. ";
		}
		if ( tvSet.isListed )
		{
			"Against the northern wall a stack of pizza boxes that emit
			a rude odor. A stained and beaten couch -- not your own -- sits
			to the south. Some of its cushions are missing, but it doesn't 
			look as if it were particularly comfortable even in its prime. 
			Bent and twisted blinds hang over the west-facing windows. ";
		}
		else
		{
			"The tv set is no longer on a stand, it sits against the northern 
			wall under a stack of pizza boxes that emit a rude odor. A stained 
			and beaten couch -- not your own -- sits to the south, facing the 
			television set. Some of its cushions are missing, but it doesn't 
			look as if it were particularly comfortable even in its prime. 
			Bent and twisted blinds hang over the west-facing windows. ";
		}
	}
	smellDesc = "The room carries the stink of festering pizza and spilled beer, 
				mixed with a trace of the ill odor of vomit. "
	xdesc = "The dining room is north, and a doorway into the hallway
			is east. "
	east = FdownstairsHallway
	north = FdiningRoom
;

tvSet: sellable, pluggable
	sdesc = "television set"
	ldesc = 
	{
		if ( self.isActive )
			tvScreen.ldesc;
		else
			"It's not a particularly great television set. It's got a 13 inch 
			screen, and some buttons on the front to change the channels 
			and volume and such. A cord runs out the back. <<tvPlug.ldesc>> ";
	}
	noun = 'set'
	adjective = 'television' 'tv' 'telly' 'idiot' 'box' 
	bulk = 2
	location = FlivingRoom
	myPlug = tvPlug
	isListed = nil
	
	sellToComment = 
	{
		if ( self.saidCommentOnce )
		{
			"Changed your mind, eh?\" He looks it over again and frowns.
			\"It's really not worth 10. ";
			self.sellValue := 5;
		}
		else
		{
			"Hmmm, yes. It is an old model, isn't it? No, wait -- in fact,
			it's not particularly old, it just looks aged. You aren't 
			trying to pull a fast one on me, are you?\" \b
			
			He stares at it a little longer. \"Well, I'm not a pawn
			shop, you understand. I normally don't take electronics.
			But I'll make an exception if it at least turns on.\" \b
			
			He plugs the television in and turns it on. A snowy picture
			comes on the screen. He turns it off, unplugs it, and clicks
			his tongue a few times. \b
					
			\"Tell you what. ";
		}
	}
	sellValue = 10
	
	doTake( actor ) =
	{
		if ( not self.isListed )
			self.isListed := true;
		pass doTake;
	}
	
	doTurnon( actor ) =
	{
		"You turn on <<self.thedesc>>. A snowy picture appears. ";
		self.isActive := true;
	}
	doTurnoff( actor ) =
	{
		"The picture shrinks to a white dot, which soon disappears. ";
		self.isActive := nil;
	}
	verDoKick( actor ) =
	{
		"I don't think that damaging <<self.thedesc>> is in your 
		best interests. ";
	}
	doChange -> tvAntenna
;

tvPlug: plugItem
	sdesc = "thin brown cord"
	adjective = 'brown' 'thin'
	location = tvSet
	pluggedIn = FlivingRoomWallSocket
	myOwner = tvSet
	doUnplug( actor ) = 
	{
		inherited.doUnplug( actor );
		
		if ( not pizzaBoxes.movedOnce )
			pizzaBoxes.scatterRoaches;
	}
;

tvVolume: fixedBlock
	sdesc = "volume control"
	adesc = { self.thedesc; }
	noun = 'volume'
	adjective = 'control'
	location = tvSet
	setting = nil
	
	verDoChange( actor ) = 
	{
		if ( not tvSet.isActive )
			"Nothing happens. ";
	}
	doChange( actor ) =
	{
		self.setting := not self.setting;
		
		"You adjust the volume. It gets <<self.setting ? "louder" : "quieter">>. ";
	}
;

tvChannels: fixedBlock
	sdesc = "channel control"
	adesc = { self.thedesc; }
	noun = 'channel'
	plural = 'channels'
	adjective = 'control'
	location = tvSet
	
	verDoChange( actor ) = 
	{
		if ( not tvSet.isActive )
			"Nothing happens. ";
	}
	doChange( actor ) =
	{
		"You change channels a few times, but the picture doesn't get any
		better. You've always been more of a book reader than a television
		watcher, anyway. ";
	}
;

tvAntenna: fixedBlock
	sdesc = "antenna"
	noun = 'antenna'
	adjective = 'rabbit' 'ears'
	location = tvSet
	
	verDoChange( actor ) = 
	{
		if ( not tvSet.isActive )
			"Nothing happens. ";
	}
	doChange( actor ) =
	{
		"You fiddle with the antenna, but the picture doesn't get any
		better. You've always been more of a book reader than a television
		watcher, anyway. ";
	}
;

tvScreen: fixedBlock
	sdesc = "screen"
	ldesc = 
	{
		if ( tvSet.isActive )
			"Playing on the television is a snowy picture. ";
		else
			"The screen is dark. ";
	}
	noun = 'screen' 'display' 'crt' 'cathode' 'ray' 'tube'
	location = tvSet
;

FlivingRoomWallSocket: socketItem
	sdesc = "wall socket"
	adjective = 'wall'
	location = FlivingRoom
	hasJuice = nil
;

livingRoomWindows: unimportantWindow
	sdesc = "west-facing windows"
	ldesc = "They face west out behind the house. "
	noun = 'window'
	plural = 'windows'
	isThem = true
	adjective = 'west-facing' 'facing' 'blind' 'blinds' 'bent' 'twisted'
	location = FlivingRoom
;

stainedCouch: chairitem
	sdesc = "couch"
	ldesc = "This stained and beaten couch is not your own, and doesn't look
			like it's particularly comfortable. "
	noun = 'couch' 'sofa'
	adjective = 'stained' 'beaten'
	location = FlivingRoom
	statusPrep = "on"
	outOfPrep = "off of"
	
	doSiton( actor ) =
	{
		inherited.doSiton( actor );
		"Sure enough, it's not particularly comfortable. ";
	}
;

pizzaBoxes: fixedBlock
	sdesc = "pizza boxes"
	ldesc = "The pizza boxes emit a rude odor. "
	smellDesc = "The odor is not merely that of cheese and tomato sauce that has
			gone bad. Mingled with it is the distinct odor of insect and perhaps
			rat droppings -- which have also gone bad, if that's possible. "
	noun = 'box'
	plural = 'boxes'
	isThem = true
	adjective = 'pizza' 'cheese' 'tomato' 'sauce' 'odor' 'insect' 'rat' 'droppping'
				'droppings' 'cardboard' 'stack'
	location = FlivingRoom
	
	dobjGen(a, v, i, p) =
	{
		if ( not self.movedOnce )
		{
			self.scatterRoaches;
			exit;
		}
		else if ( v != askVerb && v != tellVerb && v != inspectVerb &&
			 v != whereIsVerb && v != smellVerb )
		{
			"\^<<self.thatdesc>> <<self.isntdesc>> important. Also,
			you're not sure that you want to stir up any more of the local
			wildlife. ";
			exit;
		}
	}
	scatterRoaches =
	{
		"As you near the pizza boxes, they suddenly shift. With a violent
		surge, more cockroaches than you care to count run crazy out of
		the boxes in all directions. Within seconds, they have all 
		disappeared again into various nooks and crannies of the room. ";
		
		self.movedOnce := true;
	}
;

livingRoomPluralStuff: unimportantItem
	sdesc = "stuff"
	noun = 'nook'
	plural = 'nooks'
	isThem = true
	adjective = 'cranny' 'crannies' 'roaches' 'roach' 'cockroach' 'cockroaches'
			'cushions' 'cushion'
	location = FlivingRoom
;

FdownstairsHallway: graffiti_room
	downstairs = true
	sdesc = "Downstairs hallway"
	ldesc = "The hallway is dark and feels cramped due to the collected refuse
			that has built up along the wall. Graffiti covers every flat 
			surface, as usual. There is no sign of the photographs that used
			to hang here. "
	xdesc = "The foyer is north, and a doorway into the living room
			is west. The master bedroom is to the south. A small 
			door leads east into a half bathroom. "
	east = FhalfBathDoor1
	north = Ffoyer
	south = FmasterBedroom
	west = FlivingRoom
;

hallwayPhotos: unimportantItem
	sdesc = "photographs"
	ldesc = "The photographs are no longer here. They were pictures of your 
			grandparents and your mother, from whom you inherited the land
			on which this house is built, as well as the money to build the
			house in the first place. If only you'd saved some afterwards.
			If only they had lived to see it -- although, you wouldn't have
			wanted them to see it like this. "
	noun = 'photograph' 'photo'
	plural = 'photographs' 'photos'
	isThem = true
	location = FdownstairsHallway
;

FhalfBathroom: graffiti_room
	isBathroom = true
	downstairs = true
	sdesc = "Half bathroom"
	ldesc = "The bathroom is tiny and dark, but the sink, the toilet and the
			mirror seem to be intact and in place. A number of magazines lie
			in lopsided piles on the floor. "
	xdesc = "The only exit is west, back into the hallway. "
	floorDesc = "A number of magazines lie in lopsided piles on the floor. "
	west = FhalfBathDoor2
	myToilet = halfBathToilet
;

lopsidedPilesOfMagazines: unimportantItem
	sdesc = "magazines"
	ldesc = "They're pornographic magazines of a somewhat unsavory variety. "
	noun = 'magazine'
	plural = 'magazines' 'piles' 'mags' 'periodicals'
	isThem = true
	adjective = 'lopsided' 'porno' 'pornographic' 'hustler' 'wank' 'penthouse'
			'playboy' 'orgasm'
	location = FhalfBathroom
;

halfBathSink: unimportantItem
	sdesc = "sink"
	noun = 'sink' 'faucet' 'faucets'
	location = FhalfBathroom
;

halfBathMirror: fixedBlock
	sdesc = "mirror"
	ldesc = "You see a cracked reflection of yourself. "
	noun = 'mirror'
	location = FhalfBathroom
	
	verDoLookin( actor ) = {}
	doLookin( actor ) = 
	{
		"You see a cracked reflection of yourself. ";
	}
;

halfBathToilet: fixedBlock
	sdesc = "toilet"
	ldesc = "There's nothing in the toilet. "
	noun = 'facilities'
	adjective = 'seat' 'bowl' 'foul' 'brackish' 'rancid' 'stench' 'water' 'toilet'
			'john' 'loo' 'wc' 
	smellDesc = "It is cleaner than the upstairs toilet, but still somewhat
			noisome. "
	location = FhalfBathroom
	
	verDoSiton( actor ) = 
	{
		"You really don't want to do that. ";
	}
	verDoDrink( actor ) =
	{
		"That wouldn't be a good source of drinking water. ";
	}
	verDoFlush( actor ) =
	{
		"The plumbing no longer works. ";
	}
	doExcreteIn( actor ) =
	{
		"That's not a good idea. The plumbing no longer works. ";
	}
;

FhalfBathDoor1: doorway
	sdesc = "small door"
	noun = 'door'
	adjective = 'small'
	otherside = FhalfBathDoor2
	location = FdownstairsHallway
	doordest = FhalfBathroom
;

FhalfBathDoor2: doorway
	sdesc = "small door"
	noun = 'door'
	adjective = 'small'
	otherside = FhalfBathDoor1
	location = FhalfBathroom
	doordest = FdownstairsHallway
;

FmasterBedroom: graffiti_room
	downstairs = true
	sdesc = "Master bedroom"
	ldesc = 
	{
		"This is your bedroom, the one you've been longing all night to get 
		back to. Unfortunately, there is no place to sleep here, even if you
		could close your eyes to the general nightmare that your house has 
		become. The bed is missing. The large dresser that used to stand in 
		the southeast corner of the room has been toppled over, and its 
		spilled contents have been thoroughly looted, leaving nothing behind 
		but some soiled linens. Ratty curtains are open to the west side of
		the house, letting some amount of somber, muted light in. ";
		
		if ( FmasterBedroomSecretDoor.location )
			"The dimensions of the room look slightly smaller than you 
			remember. Perhaps it is a trick of the eyes due to the unsettling 
			damage. ";
	}
	xdesc = 
	{
		"The foyer is north through the hallway, and the master bathroom is to 
		the east. ";
		
		if ( FmasterBedroomSecretDoor.location && FmasterBedroomSecretDoor.isopen )
			"A secret door is open to the southeast. ";
	}
	north = FdownstairsHallway
	east = FmasterBathroom
	out = "You will have to specify a direction. "
	se = 
	{
		if ( FmasterBedroomSecretDoor.location )
			return( FmasterBedroomSecretDoor );
		else
			return( self.noexit );
	}
;

FmasterBedroomEastWall: secretDoorWall
	adjective = 'east' 'southeast' 'se'
	myDoor = FmasterBedroomSecretDoor
	mySwitch = FmasterBedroomSecretSwitch
;
	
FmasterBedroomSecretDoor: secretDoorItem
	myWall = FmasterBedroomEastWall
	mySwitch = FmasterBedroomSecretSwitch
	otherside = FwestSecretPassageDoor
	doordest = FsecretPassage
;

FmasterBedroomSecretSwitch: secretSwitchItem
	ldesc = 
	{
		if ( self.found )
			"It looks amazingly like nothing in particular at all. ";
		else
			"You can't see anything that looks like a secret switch
			around here. ";
	}
	myWall = FmasterBedroomEastWall
	myDoor = FmasterBedroomSecretDoor
	
	verDoFind( actor ) = {}
	doFind( actor ) =
	{
		if ( self.found )
			"You have already found the secret switch and remember 
			where it is. ";
		else if ( secretSwitch.found )
			theFloor.discoverSwitch( self );
		else
			"You aren't quite sure where you might need to look. ";
	}
;

Fdresser: staticItem
	sdesc = "dresser"
	ldesc = "The large dresser that used to stand in the southeast corner of the 
			room has been toppled over. "
	noun = 'dresser'
	adjective = 'large' 'toppled' 'tipped'
	location = FmasterBedroom
	
	verDoStandUp( actor ) = {}
	doStandUp( actor ) =
	{
		"There really isn't any point to standing <<self.thedesc>> back up
		again. ";
	}
	
	verDoLookbehind( actor ) = {}
	doLookbehind( actor ) = 
	{
		if ( FmasterBedroomSecretDoor.location )
		{
			if ( FmasterBedroomSecretSwitch.found )
				"You find nothing else of interest. ";
			else
				self.discoverSwitch( FmasterBedroomSecretSwitch );
		}
		else
			"There's nothing behind the dresser but a bare wall. "; 
	}
	
	discoverSwitch( theSecretSwitch ) =
	{
		"You search behind <<self.thedesc>> near the base of the wall. After
		a few passes, your hand moves across a flat area, about four inches
		across. It has been colored and textured to look like the floor, 
		but it feels different to the touch. This must be the switch. ";
		
		theSecretSwitch.found := true;
	}
;

soiledLinens: unimportantItem
	sdesc = "soiled linens"
	noun = 'linen'
	plural = 'linens'
	isThem = true
	adjective = 'spilled' 'contents' 'looted' 'soiled'
	loation = FmasterBedroom
;

masterBedroomBed: unimportantItem
	sdesc = "master bed"
	ldesc = "That isn't here. "
	noun = 'bed'
	location = FmasterBedroom
;

masterBedroomWindows: unimportantWindow
	sdesc = "west-facing windows"
	ldesc = "They face west out behind the house. "
	noun = 'window'
	plural = 'windows'
	isThem = true
	adjective = 'west-facing' 'facing' 'curtain' 'curtains' 'ratty'
	location = FlivingRoom
;

FmasterBathroom: graffiti_room
	isBathroom = true
	downstairs = true
	sdesc = "Master bathroom"
	ldesc = "This bathroom looks like it has been used as a place to party, in
			the vernacular. Various paraphernalia having to do with drug 
			abuse is in evidence, such as little plastic baggies, discarded
			needles, and the like. It is a shocking and somewhat depressing
			sight, to say the least. "
	xdesc = "The only exit is west, back into the bedroom. "
	west = FmasterBedroom
	myToilet = masterBathToilet
;

drugStuff: unimportantItem
	sdesc = "drugs"
	ldesc = "It is shocking and depressing to see that here. "
	noun = 'paraphernalia'
	adjective = 'baggie' 'bag' 'plastic' 'baggies' 'rubber' 'hose' 'hoses' 'coke' 
			'cocaine' 'heroin' 'pot' 'weed' 'cannibis' 'marijuana' 'maryjane'
			'blow' 'powder'
	location = FmasterBathroom
;

discardedNeedles: fixedBlock
	sdesc = "discarded needles"
	ldesc = "You don't want to have anything to do with those. "
	noun = 'needle' 'syringe'
	plural = 'needles' 'syringes' 
	isThem = true
	adjective = 'discarded' 'used'
	location = FmasterBathroom
	
	verIoStabWith( actor ) = {}
	ioStabWith( actor, dobj ) =
	{
		if ( dobj = Me )
			"That would be \(extraordinarily\) dangerous. ";
		else
			self.ldesc;
	}
	
	dobjGen(a, v, i, p) =
	{
		if ( v != askVerb && v != tellVerb && v != inspectVerb &&
			 v != whereIsVerb && v != pokeVerb )
		{
			self.ldesc;
			exit;
		}
	}
	iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

masterBathSink: unimportantItem
	sdesc = "sink"
	noun = 'sink'
	adjective = 'tub' 'faucet' 'faucets' 'bathtub'
	location = FmasterBathroom
;

masterBathMirror: fixedBlock
	sdesc = "mirror"
	ldesc = "You see a cracked reflection of yourself. "
	noun = 'mirror'
	location = FmasterBathroom
	
	verDoLookin( actor ) = {}
	doLookin( actor ) = 
	{
		"You see a cracked reflection of yourself. ";
	}
;

masterBathToilet: fixedBlock
	sdesc = "toilet"
	ldesc = "There's nothing in the toilet. "
	noun = 'facilities'
	adjective = 'seat' 'bowl' 'foul' 'brackish' 'rancid' 'stench' 'water' 'toilet'
			'john' 'loo' 'wc' 
	smellDesc = "It is cleaner than the upstairs toilet, but still somewhat
			noisome. "
	location = FmasterBathroom
	
	verDoSiton( actor ) = 
	{
		"You really don't want to do that. ";
	}
	verDoDrink( actor ) =
	{
		"That wouldn't be a good source of drinking water. ";
	}
	verDoFlush( actor ) =
	{
		"The plumbing no longer works. ";
	}
	doExcreteIn( actor ) =
	{
		"That's not a good idea. The plumbing no longer works. ";
	}
;

FmasterBathDoor1: doorway
	sdesc = "bathroom door"
	noun = 'door'
	adjective = 'bathroom'
	otherside = FmasterBathDoor2
	location = FmasterBedroom
	doordest = FmasterBathroom
;

FmasterBathDoor2: doorway
	sdesc = "bathroom door"
	noun = 'door'
	adjective = 'bathroom'
	otherside = FmasterBathDoor1
	location = FmasterBathroom
	doordest = FmasterBedroom
;

Fhouse: fixeditem, floatingItem
	sdesc = "house"
	ldesc = 
	{
		switch( future.state )
		{
			case 0:   /*  no rod, no tree, no roof  */
				"The house has been destroyed by fire. There is nothing left 
				of the roof or the upper half, and of the lower half, merely 
				charred timbers and twisted pipes that no longer lead to 
				anything.  ";
				break;
			case 1:   /*  no rod, no tree, yes roof  */
				"The house has been damaged by fire. Though the roof remains
				intact, the insides have been burnt out, leaving a brittle,
				soot-stained shell that you can hear wind whistling through. ";
				break;
			case 2:   /*  no rod, yes tree, no roof  */
				"The house has been ravaged by fire. Though much of the
				lower structure remains, there is nothing left of the roof or 
				the upper half, merely charred timbers and twisted pipes that 
				no longer lead to anything. The nearly unrecognizable remains 
				of furniture are overturned and mildewing inside the jaggered 
				black wood.";
				break;
			case 3:   /*  no rod, yes tree, yes roof  */
				"The house is burned and crippled, a shadow of its former pleasant
				beauty. The southern roof has been torn open by the weight of a
				fallen tree. However, the fire seems not to have spread very far,
				thanks to the fire-resistant shingles. ";
				break;
			case 4:   /*  yes rod, no tree, no roof  */
				"The house is older and sagging, with long ruts where splinters 
				have broken off. The worst damage is to the roof, which has 
				turned rotten and caved in. ";
				break;
			case 5:   /*  yes rod, no tree, yes roof  */
				"The house is older and sagging, with long ruts where splinters 
				have broken off, but otherwise looks the way you remember it. ";
				break;
			case 6:   /*  yes rod, yes tree, no roof  */
				"The house is older and sagging, with long ruts where splinters 
				have broken off. The worst damage is to the roof, which has 
				turned rotten and caved in. ";
				break;
			case 7:
				"Your house is a two-story structure, with stained wood 
				instead of paint on the exterior, allowing it to blend in with
				the landscape. It looks somewhat weathered, as if no one had 
				tended to it for ten years, but is otherwise normal. ";
				break;
		}
	}
	noun = 'house'
	location = 
	{
		switch( Me.location )
		{
			case FfrontOfHouse:
			case FnorthOfHouse:
			case FbehindHouse:
			case Fdriveway:
//			case FinsideHouse:
				return( Me.location );
			default: return( nil );
		}
	}
	verDoEnter( actor ) = 
	{
		"You'll have to specify a direction. ";
	}
	doSynonym( 'Enter' ) = 'Board'
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Locked out, eh? Don't you have a spare key?\" ";
				Fred.askedAboutKey := true;
				return( true );
			case Laura:
				"Laura says, \"You should always keep a spare key outside in
				case of emergencies.\" ";
				Laura.askedAboutKey := true;
				return( true );
			case Architect:
				"He says, \"It'll be a fine house, all righty.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

FfrontOfHouse: room
	sdesc = "Front of house"
	ldesc = 
	{
		switch( future.state )
		{
			case 0:   /*  no rod, no tree, no roof  */
				"The house has been destroyed by fire. There is nothing left 
				of the roof or the upper half, and of the lower half, merely 
				charred timbers and twisted pipes that no longer lead to 
				anything. ";
				break;
			case 1:   /*  no rod, no tree, yes roof  */
				"The house has been damaged by fire. Though the roof remains
				intact, the insides have been burnt out, leaving a brittle,
				soot-stained shell that you can hear wind whistling through. ";
				break;
			case 2:   /*  no rod, yes tree, no roof  */
				"The house has been ravaged by fire. Though much of the
				lower structure remains, there is nothing left of the roof or 
				the upper half, merely charred timbers and twisted pipes that 
				no longer lead to anything. The nearly unrecognizable remains 
				of furniture are overturned and mildewing inside the jaggered 
				black wood. ";
				break;
			case 3:   /*  no rod, yes tree, yes roof  */
				"This is the front your house, and something is terribly wrong. ";
				
				if ( not nailedBoards.pried ) 
					"The front door is boarded up, sealing off all entrance 
					to what should still be your home. ";
				
				"The roof is crippled by the weight of a fallen tree, 
				and all of the front windows are cracked. ";
				break;
			case 4:   /*  yes rod, no tree, no roof  */
				"The front of your house is older and sagging, and the worst 
				damage is to the roof, which has turned rotten and caved in. ";
				break;
			case 5:
				"This is the front of your house. It looks somewhat weathered, 
				as if no one had tended to it for ten years, but is otherwise 
				normal. ";
				break;
			case 6:   /*  yes rod, yes tree, no roof  */
				"The front of your house is older and sagging, and the worst 
				damage is to the roof, which has turned rotten and caved in. ";
				break;
			case 7:
				"This is the front of your house. It looks somewhat weathered, 
				as if no one had tended to it for ten years, but is otherwise 
				normal. ";
				break;
		}
		
		"Sopping mounds of rotting leaves that have collected along the edges 
		and corners indicate years of neglect. A pool of dirty yellow water 
		trickles down from the driveway and collects, full of black silt, 
		near<<future.state > 2 ? " the front door" : " where the front door
		used to be">>. ";
	}
	xdesc = "The driveway is to the northeast, and a clearing is visible far
		to the southwest. <<future.state < 3 ? "You can enter the burned house 
		to the west, but there won't be much to see there" : "The front door
		is to the west">>. "
	ne = Fdriveway
	nw = FnorthOfHouse
	sw = FsouthOfHouse
	west = 
	{
		if ( future.state < 3 )
			return( FinsideHouse );
		else return( FfrontDoor );
	}
;

soppingMoundsOfRottedLeaves: fixedBlock
	sdesc = "mounds of rotting leaves"
	ldesc = "Sopping mounds of rotting leaves have collected along the edges and
			corners of your house, indicating years of neglect. "
	noun = 'leaf' 'mound'
	plural = 'leaves' 'mounds'
	isThem = true
	adjective = 'sopping' 'mounds of' 'rotting' 'rotted'
	location = FfrontOfHouse
	verDoTake( actor ) =
	{
		"Picking up the mounds of rotting leaves would be a filthy and 
		ultimately unworthwhile task. ";
	}
;

yellowPuddle: fixedBlock, qcontainer
	sdesc = "pool of dirty water"
	ldesc = "A pool of dirty yellow water trickles down from the driveway 
			and collects, full of black silt, near the front door. "
	noun = 'water' 'puddle'
	adjective = 'pool' 'pool of' 'dirty' 'yellow' 'trickle'
	location = FfrontOfHouse
	
	verDoTake( actor ) =
	{
		"Taking some of the water from the dirty puddle would be an unseemly
		and generally unhelpful action. ";
	}
	ioPutIn( actor, dobj ) =
	{
		"Putting items into <<self.thedesc>> would be a sullying and 
		genuinely unprofitable activity. ";
	}
;

blackSilt: fixedBlock
	sdesc = "black silt"
	noun = 'silt'
	adjective = 'black'
	location = yellowPuddle
	
	verDoTake( actor ) =
	{
		"Picking up the black silt would be a messy and completely
		unrewarding effort. ";
	}
	ioPutIn -> yellowPuddle
;

FfrontOfHousePath: block
	sdesc = "small path"
	ldesc = "The small path leads northwest and southwest. "
	noun = 'path'
	adjective = 'small'
	location = FfrontOfHouse
;

FfrontOfHouseWindows: FhouseWindow
	ldesc = "The windows here face out from your downstairs bathroom
			to the south and the kitchen to the north, as well as smaller
			windows on the upper floor. Many of them are cracked but still
			locked from the inside, with the blinds closed. "
	location = FfrontOfHouse
;

FfrontDoor: lockableDoorway, floatingItem
	isfixed = nil
	sdesc = "front door"
	ldesc = 
	{
		"Unlike the rest of your house, the door still looks firm and strong. ";

		if ( self.pried )
		{
			"It hangs loosely ";
			if ( self.isopen )
				"open ";
			else
				"closed ";
			"on its damaged hinges. ";
		}
		else if ( not nailedBoards.pried )
			"Boards of cheap wood, browned and warped with some years' age, 
			have been nailed into the jamb and the door itself. ";
	}
	adesc = "your front door"
	noun = 'door'
	plural = 'hinges'
	adjective = 'solid' 'wood' 'front' 'locked' 'hinge' 'damaged'
	location = 
	{
		if ( future.state > 2 )
			return( FfrontOfHouse );
		else return( nil );
	}
	otherside = FfrontDoorInside
	doordest = Ffoyer
	mykey = duplicateKey
	noAutoOpen = true
	
	verDoOpen( actor ) =
	{
		if ( not nailedBoards.pried )
		{
			"It has been nailed shut with boards and cannot be opened. ";
		}
		else if ( not self.otherside.pried )
		{
			if ( self.islocked )
				"It is locked as well as swollen shut. ";
			else
				"It is unlocked but swollen shut. ";
		}
		else if ( self.isopen )
			"It is already open. ";
	}
	doUnlockWith( actor, io ) =
	{
		if ( io = duplicateKey )
		{
			"The key struggles to turn in the rusted lock. Finally,
			it clicks open. ";
			self.setIslocked( nil );
		}
		else if ( io = frontDoorKey ) 
		{
			"[BUG] You can't use that! ";
		}
		else
			"It doesn't fit the lock. ";
	}
	verDoTake( actor ) = { "You can't take the front door. "; }
;

nailedBoards: staticItem, floatingItem
	sdesc = "boards"
	ldesc = "The boards are browned and warped with the passage of several years. 
			On closer inspection, a rectangular outline marks a discoloration 
			where something was once posted. Your first guess, based on the 
			evidence, is that it was a notice that the property has been 
			condemned. "
	noun = 'wood'
	plural = 'boards'
	isThem = true
	adjective = 'boards of' 'cheap' 'nailed' 'warped' 'browned' 'brown'
		'outline' 'notice' 'discoloration' 'jamb'
	location = 
	{
		if ( future.state > 2 )
			return( FfrontOfHouse );
		else return( nil );
	}
;

pileOfBoards: staticItem
	sdesc = "pile of boards"
	ldesc = "The boards are browned and warped with the passage of 
			several years. Harsh, rusted nails jut at crazy angles 
			from the ends of each plank. "
	noun = 'wood'
	plural = 'boards' 'ends' 'nails'
	isThem = true
	adjective = 'pile of' 'pile' 'harsh' 'rusted' 'rusty' 'rust' 
			'nail' 'plank' 'end'
	location = nil
	
	verDoTake( actor ) = 
	{
		"It's best to leave them alone now, as you could injure 
		yourself on the rusty nails. ";
	}
;

FdoorLock: fixedBlock, floatingItem
	sdesc = "<<self.greased? "lock" : "rusted lock">>"
	ldesc = 
	{
		"It's a standard door lock of once-good quality. ";
		
		if ( not self.greased )
			"It is rusted now, and unlikely to turn even if you had 
			the proper key. ";
	}
	noun = 'lock' 'bolt' 'deadbolt'
	location = 
	{
		if ( future.state > 2 )
			return( FfrontOfHouse );
		else return( nil );
	}
	
	doOpen -> FfrontDoor
	doUnlockWith -> FfrontDoor
;

Fdriveway: room
	sdesc = "Driveway"
	ldesc = "Your driveway looks much the same, a thankful sight after the ruin 
			your house has become. "
	xdesc = "The road to town still lies to the east. Your front door is to 
			the southwest. "
	sw = FfrontOfHouse
	west = FnorthOfHouse
	east = Fsidewalk
;

newspaper: bookItem
	sdesc = "newspaper"
	ldesc = "The name of the paper is the same, but somehow it can't be the same 
			publication to which you have long subscribed. Missing is the thorough 
			science and technology section. In its place are colorful graphics, 
			fluffy self-help editorials, and every decoration short of scratch-n-sniff 
			decals. "
	noun = 'paper' 'newspaper' 'news' 'journal' 'times' 'periodical' 'print' 'article'
			'graphics' 'editorial' 'editorials' 'decoration' 'business' 'section'
	
	location = Fdriveway
	readdesc =
	{
		"An item in the business section catches your eye. Apparently, the Lothario 
		Corporation has failed to consume DibbleBits, an upstart technology company, 
		in hostile takeover. It seems DibbleBits is cash-rich right now, its stock 
		value having taken a sudden 80-point jump in the last year, due to technology 
		demand, after having languished at pennies-per-share for 30 years. ";
	}
	
	verDoScratch( actor ) = { "There are no scratch-n-sniff decals in this game. "; }
	verDoSniff( actor ) = { "There are no scratch-n-sniff decals in this game. "; }
	doConsultAbout( actor, iobj ) =
	{
		switch( iobj )
		{
			"\^<<self.thedesc>> contains no information about that subject. ";
		}
	}
	
	verDoShowTo( actor, io ) = 
	{
		if ( global.timeLoc < 4 )
			"It is dangerous to go around showing obvious artifacts from
			the future to people in the past. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Man, if I had a time machine I'd go back and buy
				as much stock in DibbleBits as I could.\" ";
				return( true );
			case Laura:
				return( lotharioCorp.askingAboutMe( Laura ) );
			case PLaura:
				return( dibbleBitsStock.askingAboutMe( who ) );
			default: 
				return( nil );
		}
	}
;

decals: fixeditem
	sdesc = "decals"
	ldesc = "There are no scratch-n-sniff decals. The newspaper has every decoration 
			*short of* scratch-n-sniff decals. "
	noun = 'decal'
	isThem = true
	plural = 'decals'
	adjective = 'scratch-n-sniff' 'scratch&sniff' 'scratch' 'sniff' '-n-sniff'
			'-n' '-n-' 'scratch-n' 'scratch and sniff' 'scratch & sniff' 'scratch&sniff'
	location = newspaper
	
	dobjGen( a, v, i, p ) =
	{
		if ( v != askVerb and v != tellVerb and v != inspectVerb )
		{
			"There are no scratch-n-sniff decals in this game. ";
			exit;
		}
	}
	iobjGen( a, v, d, p ) = { self.dobjGen( a, v, d, p ); }
;

FdrivewayDummy: fixedBlock, readable, floatingItem
	sdesc = "driveway"
	ldesc =
	{
		if ( wetDriveway.writtenOn )
			"\^<<wetDriveway.writtenOnDesc>> is written into <<self.thedesc>> cement. ";
		else if ( wetDriveway.drawnOn )
			"\^<<wetDriveway.drawnOnDesc>> is drawn into <<self.thedesc>> cement. ";
		else pass ldesc;
	}
	noun = 'driveway' 'cement' 'concrete' 'paving' 'paved'
	location = 
	{
		switch( Me.location )
		{
			case Fdriveway:
			case FfrontOfHouse:
			case FnorthOfHouse:
			case FinGarage:
				return( Me.location );
			default:
				return( nil );
		}
	}
;

FtownDummy: distantItem
	sdesc = "town"
	noun = 'town'
	location = Fdriveway
;

FpathDriveway: fixedBlock
	sdesc = "path"
	noun = 'path'
	location = Fdriveway
;

FroadDriveway: fixedBlock
	sdesc = "road"
	noun = 'road'
	location = Fdriveway
;

FnorthOfHouse: room
	sdesc = "North of house"
	ldesc = 
	{
		switch( future.state )
		{
			case 0:   /*  no rod, no tree, no roof  */
				"The house has been destroyed by fire. There is nothing left 
				of the roof or the upper half, and of the lower half, merely 
				charred timbers and twisted pipes that no longer lead to 
				anything. The stone chimney that once led up is a crumbled pile of 
				blackened stone and mortar. ";
				break;
			case 1:   /*  no rod, no tree, yes roof  */
				"The house has been damaged by fire. Though the roof remains
				intact, the insides have been burnt out, leaving a brittle,
				soot-stained shell that you can hear wind whistling through. 
				The stone chimney that once led up is a crumbled pile of 
				blackened stone and mortar. ";
				break;
			case 2:   /*  no rod, yes tree, no roof  */
				"The house has been ravaged by fire. Though much of the
				lower structure remains, there is nothing left of the roof or 
				the upper half, merely charred timbers and twisted pipes that 
				no longer lead to anything. The stone chimney that once led up 
				is a crumbled collection of blackened stone and mortar. ";
				break;
			case 3:   /*  no rod, yes tree, yes roof  */
				"The house is burned and crippled, a shadow of its former pleasant
				beauty. This side of the house is reasonably intact, but still
				somehow decrepit, with a rank odor coming from the garage. ";
				break;
			case 4:   /*  yes rod, no tree, no roof  */
				"The north side of your house is no longer dominated by your 
				garage door. The roof has turned rotten and caved in, and the
				stone chimney that once led up is a crumbled pile of stone and 
				mortar. ";
				break;
			case 5:   /*  yes rod, no tree, yes roof  */
				"The north side of your house is no longer dominated by your 
				garage door, but otherwise looks the way you remember it. The 
				house is older and sagging, with long ruts where splinters 
				have broken off. ";
				break;
			case 6:   /*  yes rod, yes tree, no roof  */
				"The north side of your house is no longer dominated by your 
				garage door. The roof has turned rotten and caved in, and the
				stone wall that once led up is a crumbled pile of stone and 
				mortar. ";
				break;
			case 7:
				"The north side of your house is dominated by your garage door, 
				just the way you remember it. It looks somewhat weathered, as 
				if no one had tended to it for ten years, but is otherwise normal. ";
				break;
		}
		
		if ( future.state > 3 )
		{
			if ( FgarageDoor1.isopen )
				"The garage door is open. ";
			else 
				"The garage door is closed. ";
		}
	}
	xdesc = "The driveway extends east, and a small path leads southeast to the 
		front of the house and southwest to the back<<FstoneWall1.standing ? 
		". A scaled stone wall runs up the side of the house. " : ". ">>"
	south = 
	{
		if ( future.state < 3 )
			return( FinsideHouse );
		else return( FgarageDoor1 );
	}
	in = { return( self.south ); }
	east = Fdriveway
	sw = FbehindHouse
	se = FfrontOfHouse
	up = 
	{
		if ( FstoneWall1.standing )
		{
			"You climb gingerly up the stone wall.\n";
			return( FnorthRoof );
		}
		else
		{
			"There is nothing left standing for you to climb. ";
			return( nil );
		}
	}
	smellDesc = {
		switch( future.state ) {
			case 0:
			case 1:
			case 2:
				"You smell burned wood and mildew. ";
				break;
			case 4:
			case 6:
				"You smell rotten wood and wet stone. ";
				break;
			case 3: 
			case 5: 
			case 7: "A rank odor seems to be coming from the garage. ";
				break;
		}
	}
;

FstoneWall1: fixedBlock
	sdesc = "<<self.standing ? "stone wall" : "crumbled stone and mortar">>"
	ldesc = {
		if ( self.standing ) {
			"The wall tapers in a stairstep fashion as it climbs up to and 
			beyond the edge of the roof. ";
			if ( future.state = 3 ) 
				"It's not clear from here how much of the roof is
				still in one piece. ";
		}
		else {
			"It's been reduced to a pile of stones and crumbled mortar. ";
		}
	}
	noun = 'wall'
	adjective = 'stone' 'chimney' 'pile' 'stones' 'mortar' 'blackened' 'crumbled' 'crumble'
	location = FnorthOfHouse
	standing = 
	{
		if ( future.state = 3 || future.state = 5 || future.state = 7 )
			return( true );
		else return( nil );
	}
	verDoClimb( actor ) = {}
	doClimb( actor ) = 
	{
		Me.travelTo( self.location.up );
	}
;

FgarageDoor1: lockableDoorway, garageDoorItem, floatingItem
	isfixed = nil
	isListed = nil
	isopen = nil
	doordest = FinGarage
	otherside = FgarageDoor2
	sdesc = "garage door"
	noun = 'door' 
	adjective = 'garage'
	noAutoOpen = true
	location = 
	{
		if ( future.state < 3 )
			return( nil );
		else return( FnorthOfHouse );
	}
	
	verDoUnlock( actor ) = 
	{
		"The locking mechanism is on the inside. ";
	}
	verDoLock( actor ) = 
	{
		"The locking mechanism is on the inside. ";
	}
	verDoOpen( actor ) =
	{
		if ( self.isopen )
			"\^<<self.itisdesc>> already open. ";
		else if ( self.islocked )
			"It seems to be locked from the inside. ";
	}
	doOpen( actor ) =
	{
		"You yank open the garage door. It makes a heinous squeak. ";
		self.setIsopen( true );
	}
	doClose( actor ) =
	{
		"You force the garage door shut. It complains, shuddering and
		squeaking, but it obeys. ";
		self.setIsopen( nil );
	}
	verDoKnock( actor ) =
	{
		if ( self.isopen )
			"You can't knock on the garage door when it's open. ";
	}
	
	knockCount = 0
	doKnock( actor ) = 
	{
		if ( FFred.location != FinGarage )
		{
			"There is no answer. ";
			return;
		}
		
		if ( FFred.met )
		{
			if ( not self.metAndKnockedOnce )
			{
				"\^<<self.thedesc>> opens the door and squints at you. \"What the
				heck d'you want? Have you no respect for the hung over? Come in 
				or don't come in, but quit with the pounding.\" He disappears back 
				inside, rather like an eyeball rolling up into its socket. ";
				
				self.metAndKnockedOnce := true;
			}
			else
				"\^<<self.thedesc>> opens the door, grumbles under his breath,
				and disappears back inside. ";
			
			self.setIsopen( true );
			self.setIslocked( nil );
		}
		
		self.knockCount++;
		
		switch( self.knockCount )
		{
			case 1:
				"There is no answer at first, and then you hear a gravelly voice 
				say, \"Goway! Beat it! I got a gun in here!\" ";
				break;
			case 2:
				"The voice says, \"I said beat it! I got a killer dog in here!\" 
				Some barking noises just this side of convincing are heard from
				within. ";
				break;
			case 3:
				"\"I'm warning you!\"\ the voice inside says. \"Killer here 
				hasn't had any fresh meat in days! RRwwff! Rrarf! Down, girl!\" ";
				break;
			case 4:
				"\"What's with you? Can't a man get any peace? Go bother someone
				else before I call the cops.\" ";
				break;
			case 5:
				"\"Get outta here!\"\ the voice says. \"I got the leprosy!\" ";
				break;
			case 6:
				"\"La la la la la la I'm not listening to that damn racket 
				la la la la la la\ ...\" ";
				break;
			case 7:
				"\"Gevalt, what's with you? A deaf man couldn't take this 
				pounding.\" ";
				break;
			default:
				"A thumping noise comes from inside the garage door. \"There,
				see how you like it! Hah? How'd you like that? I got more where
				that came from!\" The knocking continues for a good minute. ";
				break;
		}
	}
;

FinsideHouse: room
	sdesc = "Inside the house"
	ldesc = 
	{
		"You are now inside your house, but it is unrecognizable either
		as yours or as a house. All that there is to see, unfortunately, 
		is fire damaged wood and broken things. ";
		
		switch( future.state )
		{
			case 0:
			case 1:   /*  no rod, no tree, yes roof  */
				"The insides have been burnt out, leaving a brittle,
				soot-stained shell that you can hear wind whistling through. ";
				break;
			case 2:
				"The nearly unrecognizable remains of furniture are 
				overturned and mildewing inside the jaggered black wood. ";
				break;
		}
	}
	xdesc = "Sadly, you can exit in any direction. "
	listenDesc = 'You hear the wind whistling through the shell of the house. '
	smellDesc = "You smell scorched wood and mildewy dampness. "
	north = FnorthOfHouse
	east = FfrontOfHouse
	south = FsouthOfHouse
	west = FbehindHouse
	down = 
	{
		if ( FsecretChamber.isseen ) 
			"You search through the wreckage, but the passage leading down 
			to the secret chamber must be closed up with debris, because you
			can't find it anywhere. ";
		return( self.noexit );
	}
	in = 
	{
		"You are already inside what remains of the house. ";
	}
	out = 
	{
		if ( future.state > 1 )
			return( self.north );
		else 
		{
			"You'll have to specify a direction. ";
			return( nil );
		}
	}
	nw = { return( FnorthOfHouse ); }
	ne = { return( FnorthOfHouse ); }
	sw = { return( self.south ); }
	se = { return( self.south ); }
;

furnitureRemains: unimportantItem, floatingItem
	sdesc = "unrecognizable remains of furniture"
	ldesc = "You really can't identify this battered wreckage as your furniture,
		apart from seeing bits of metal that might have been part of a sofa,
		or a corner of wood that might have been a dresser. "
	noun = 'furniture'
	plural = 'remains'
	adjective = 'unrecognizable' 'jaggered' 'overturned' 'mildew' 
			'mildewing' 'remains' 'things' 'battered' 'wreckage'
			'husks' 'bits' 'metal' 'sofa' 'dresser' 'armoire' 'bed' 'desk'
			'table' 'springs' 'box'
	location = 
	{
		if ( future.state = 2 )
		{
			switch( Me.location )
			{
				case FsouthOfHouse: return( FsouthOfHouse );
				case FnorthOfHouse: return( FnorthOfHouse );
				case FfrontOfHouse: return( FfrontOfHouse );
				case FbehindHouse: return( FbehindHouse );
				case FinsideHouse: return( FinsideHouse );
			}
		}
		else return( nil );
	}
;

brittleSootStainedShell: unimportantItem, floatingItem
	sdesc = "fire damaged wood"
	noun = 'shell' 'debris'
	adjective = 'brittle' 'soot' 'stained' 'soot-stained' 'fire' 'damaged' 'wood'
	location = 
	{
		if ( future.state < 3 )
		{
			switch( Me.location )
			{
				case FsouthOfHouse: return( FsouthOfHouse );
				case FnorthOfHouse: return( FnorthOfHouse );
				case FfrontOfHouse: return( FfrontOfHouse );
				case FbehindHouse: return( FbehindHouse );
				case FinsideHouse: return( FinsideHouse );
			}
		}
		else return( FinsideHouse );
	}
;

charredTimbersTwistedPipes: unimportantItem, floatingItem
	sdesc = "charred timbers and twisted pipes"
	noun = 'timber' 'timbers' 'pipe' 'pipes' 
	isThem = true
	adjective = 'charred' 'broken' 'twisted' 'jagged'
		'scorched' 'burned' 'burned-out' 'burnt' 'cinder' 'cinders'
	location =
	{
		if ( future.state < 3 )
		{
			switch( Me.location )
			{
				case FsouthOfHouse: return( FsouthOfHouse );
				case FnorthOfHouse: return( FnorthOfHouse );
				case FfrontOfHouse: return( FfrontOfHouse );
				case FbehindHouse: return( FbehindHouse );
				case FinsideHouse: return( FinsideHouse );
			}
		}
		else return( FinsideHouse );
	}
;

FinGarage: graffiti_room
	sdesc = "In the garage"
	ldesc = 
	{
		"This room is a stinking mess, in a totally new and horrible way than
		the mess you were used to. A soiled mattress is lumped into
		one corner, surrounded by filth and discarded bottles. ";
	}
	xdesc = 
	{
		"A door leads south into the kitchen. The garage door is to the north ";
		
		if ( FgarageDoor2.isopen )
			"is open. ";
		else
			"is closed. ";
	}
	smellDesc = "The entire garage reeks of various bad smells, none of them 
			particularly identifiable except as a cloud of utter rankness. "
	north = FgarageDoor2
	in = FgarageDoor2
	south = FgarageBackDoor
	out = FgarageBackDoor
;

FgarageDoor2: lockableDoorway, garageDoorItem
	isfixed = nil
	isListed = nil
	isopen = nil
	doordest = FnorthOfHouse
	otherside = FgarageDoor1
	sdesc = "garage door"
	noun = 'door' 
	adjective = 'garage'
	noAutoOpen = true
	location = FinGarage
	
	verDoKnock( actor ) =
	{
		if ( self.isopen )
			"You can't knock on the garage door when it's open. ";
	}
	doOpen( actor ) =
	{
		"You yank open the garage door. It makes a heinous squeak.  ";
		self.setIsopen( true );
	}
	doClose( actor ) =
	{
		"You force the garage door shut. It complains, shuddering and
		squeaking, but it obeys. ";
		self.setIsopen( nil );
	}
;

Fjunk: fixedBlock
	sdesc = "junk"
	ldesc = "There's no reason to look through the junk this time. It reeks
		of genuine filth and waste, and is full of broken bottles. "
	smellDesc = "The entire garage reeks of various bad smells, none of them 
			particularly identifiable except as a cloud of utter rankness. "
	noun = 'filth'
	adjective = 'junk' 'discarded' 'bottle' 'bottles' 'mess' 'filth' 'waste'
		'glass' 'broken'
	location = FinGarage
	
	verDoSearch( actor ) = { self.ldesc; }
	verDoSmell( actor ) = {}
	verDoTake( actor ) = 
	{ 
		"You don't want to get near it, let alone put your hands in it. "; 
	}
;

Fmattress: fixedBlock							// red herring
	sdesc = "soiled mattress"
	ldesc = "It appears to be where <<FFred.thedesc>> lives and sleeps. "
	pluraldesc = "mattresses"
	smellDesc = "The mattress smells like urine, body odor, and lice droppings. "
	noun = 'mattress'
	adjective = 'beat-up' 'soiled' 'lice' 'dropping' 'droppings' 'urine' 'bo' 'body'
			'odor' 
	outOfPrep = "off of"
	location = FinGarage
	
	verDoLieon( actor ) =
	{
		"A more hideous place to rest your head you'll not find. So, no. ";
	}
;

FgarageBackDoor: doorway
	sdesc = "back door"
	ldesc = { FkitchenBackDoor.ldesc; }
	noun = 'door'
	adjective = 'back'
	otherside = FkitchenBackDoor
	location = FinGarage
	doordest = Fkitchen
	isopen = nil
//	islocked = true
	isListed = nil
	noAutoOpen = nil
;

FwallOpener: buttonitem
	isfixed = nil
	sdesc = "wall opener button"
	adjective = 'wall'
	isListed = nil
	location = FinGarage
	
	verDoPush( actor ) =
	{
		"Nothing happens. You suspect that there isn't any electricity running
		in the house any more. ";
	}
;

FFred: NPC
	sdesc = 
	{
		if ( self.met && Fred.met )
		{
			if ( Fred.state = 2 )
				"future Fred";
			else 
				"Fred";
		}
		else
		{
			if ( self.met )
				"wino";
			else
				"shabby man";
		}
	}
	adesc = 
	{
		if ( self.met && Fred.met )
		{
			if ( Fred.state = 2 )
				"future Fred";
			else 
				"Fred";
		}
		else
		{
			if ( self.met )
				"a wino";
			else
				"a shabby man";
		}
	}
	thedesc = 
	{
		if ( self.met && Fred.met )
		{
			if ( Fred.state = 2 )
				"future Fred";
			else 
				"Fred";
		}
		else
		{
			if ( self.met )
				"the wino";
			else
				"the shabby man";
		}
	}
	ldesc = 
	{
		"\^<<self.thedesc>> looks haggard and unruly. ";
		if ( Fred.met )
			"His always-friendly smile is gone, replaced by a largely 
			toothless sneer. His got a pudgy frame now has a gigantic, round
			gut, and his once dark eyebrows are a twizzled grey. He hasn't
			shaved in a long time, and the twinkle behind his eyes has gone
			dark. ";
		else
			"He has a pudgy frame with an enormous bloated gut, and twizzled
			grey eyebrows. He hasn't shaved in a long time, and his bloodshot 
			eyes show no sparkle, only a melancholy darkness. ";
	}
	smellDesc = "He smells of booze and body odor and urine. "
	actorDesc = 
	{
		if ( not self.met ) {
			self.meetFred( nil );
		}
		else {
			"\^<<self.adesc>> is here, <<self.location = FinGarage ? 
			"sitting on a soiled mattress" : "woozing back and forth on 
			his fat legs">>. ";
		}
	}
	noun = 'wino'
	adjective = 'Fred' 'future' 'alcoholic' 'alkie' 'homeless' 'man' 'person' 'bum'
			'sot' 'hobo' 'grubby' 'dirty' 'woozy' 'smelly' 'stinky' 'stinking'
			'Fred\'s' 'his' 'shabby' 'wino'
	location = FinGarage
	myfollower = FFredFollower
	isHim = true
	
	helloCount = 0
	sayHello = {
		switch( self.helloCount ) {
			case 0: "\n\^<<self.thedesc>> says, \"Who are you? Go away!\" ";
				break;
			case 1: "\n\^<<self.thedesc>> belches. ";
				break;
			case 2: "\n\^<<self.thedesc>> says, \"Same to you, buddy!\" ";
				break;
			default: "\n\^<<self.thedesc>> says, \"Gimme a break.\" ";
				self.helloCount := 0;
				break;
		}
		self.helloCount++;
	}
	disavow( it ) = 
	{
		"\^<<self.thedesc>> mutters, \"I don't know nothin' about that. Go away.\" ";
	}
	talkAboutMyself = {
		"\^<<self.thedesc>> says, \"Buddy, I ain't got nothin'. Usedta have 
		sommin'. Aw shaddap. Go away.\" ";
	}
	doWhoAmI( actor ) = {
		"\^<<self.thedesc>> squints at you for a long moment, trying to get
		his eyes to focus. \"You look... <hic> dissidently familiar.\" He 
		grunts and turns away. \"But I dunno you. Go away already.\" ";
	}
	responseToThanks = 
	{
		"\^<<self.thedesc>> grunts and pretends not to hear you. ";
	}
	knowWhereIsList = [ whiskeyBottle ]
	sayWhereIs( it ) =
	{
		if ( it = whiskeyBottle ) {
			if ( it.isIn( self ) ) 
				"\^<<self.thedesc>> smiles like a happy baby and
				shouts, \"Izz right here! HA HA ha ha ha!\" He 
				dissolves into a coughing fit that he assuages
				with a drink. ";
			else if ( it.deepIsIn( self.location ) ) 
				"\^<<self.thedesc>> leans over and snatches it up. 
				\"Izz right here! An' you can't have none!\" ";
			else { 
				if ( FFred.daemonCount = 0 )		// if daemon not already running
					notify( FFred, &actorDaemon, 0 );	//Fred comes looking for it
				"\^<<self.thedesc>> says, \"I ain't tellin' you, thaz' fer sure.\" ";
			}
		}
		else {
			"\^<<self.thedesc>> looks deeply puzzled for a minute.
			\"No idea,\" he finally admits. ";
		}
	}
	giveItemToSomeone( item, someone ) =
	{
		if ( item.isIn( self ) )
			"\^<<self.thedesc>> shouts, \"No! Get out of here! It's all I got...\" ";
		else
			"\^<<self.thedesc>> says, \"I don't have it... whereizzit?\" ";
	}
	verIoGiveTo( actor ) = {}
	ioGiveTo( actor, dobj ) = 
	{
		if ( dobj = whiskeyBottle )
		{
			if ( self.lookingForBottle )
			{
				if ( self.isIn( FinGarage ) )
					"\^<<self.thedesc>> glares at you with sunken, bloodshot eyes. 
					\"Hey! What're you doin' in my stuff? Gimme that!\" He grabs the
					bottle from you and takes a long suck at it. \"And get outta
					my house!\" Emitting a smelly belch, he points at the door. ";
				else
					"\^<<self.thedesc>> glares at you with sunken, bloodshot eyes. 
					\"I knew it! Stay out of my stuff, you thief!\" He grabs the
					bottle from you and takes a long suck at it. \"And stay outta
					my house!\" Emitting a smelly belch, he shambles off, out the
					back door into the garage. ";
			}
			else
			{
				if ( Me.location != FinGarage )
					"\^<<self.thedesc>> eyes you warily as you hand out the 
					bottle. He grunts, \"I was just comin' to look for that.\" 
					He snatches it out of your hand, and almost loses his balance 
					in the process. Steadying himself with a grubby hand, he 
					takes a long suck at it. \"Don't be messing with my stuff,\" 
					he warns you. \"And stay out of my house!\" He shambles off, 
					muttering to himself. You hear him go out the back door into 
					the garage. ";
				else
					"\^<<self.thedesc>> eyes you warily as you hand out the 
					bottle. He grunts, \"I was just comin' to look for that.\" 
					He snatches it out of your hand, and almost loses his balance 
					in the process. Steadying himself with a grubby hand, he 
					takes a long suck at it. \"Don't be messing with my stuff,\" 
					he warns you. \"And get out of my house!\" He points at
					the garage door with as much authority as he can muster. ";
			}
			self.stopActorDaemon;
		}
		else if ( isclass( dobj, sandwichItem ) ) 
		{
			"\^<<self.thedesc>> says, \"My stomach don't take food so good no
			more. Makes me sick.\" ";
		}
		else if ( isclass( dobj, moneyItem ) )
		{
			"\^<<self.thedesc>> says, \"I don't want yer stinkin' charity.\" ";
		}
		else
		{
			"\^<<self.thedesc>> eyes <<dobj.thedesc>> for a moment with unfocused
			eyes. \"That ain't what I'm lookin' for,\" he wheezes. ";
		}
	}
	tellAboutMe( who ) =
	{
		if ( not FFred.met )
			"(the old wino whom you have not met yet) \b";
					
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				if ( not FFred.met )
				{
					"Fred gives you a funny look. ";
					return( nil );
				}
				else
				{
					"Fred looks slightly uncomfortable as you tell him about
					the old wino. \b
					
					\"Um, look,\" he says. \"You come for a sandwich, fine. You
					come and ask me about whatever, that's okay too -- it's a 
					slow night. But now you're trying to tell me about some
					crazy drunk living in your house -- in the future -- and 
					that it's me?\" \b
					
					Fred stares at the counter, idly swabbing it with a cloth.
					\"I mean, I don't know whether to throw you out or punch
					you in the nose. Whoever you met, it's not me, okay? That's
					not my future. I'm going to be manager of this place, get
					married, settle down. That's my future, okay?\" \b
					
					He looks briefly up at you, his eyebrows furrowing. ";
					
					if ( timeMachine.toldFredAbout )
						"\"Okay, so you've told me you have a time machine. ";
					else
						"\"I admit that you've got me curious. So show me some
						proof. Mind you, ";
					
					"I don't really believe you, but if this is something
					I can see for myself, then I want to see it.\" He starts to
					put things away, packing up food and stowing utensils. \"It's
					about ten minutes till closing, but I'm gonna close a few 
					minutes early so you can take me to whoever -- or whenever --
					it is you're talking about. Okay? So just wait out front and 
					I'll join you there after I lock things up.\" \b
					
					Fred escorts you out of the front of the shop, looking very
					preoccupied as he locks the doors from inside and flips the
					\"Closed\" sign. \b";
					
					unnotify( Fred, &actorDaemon );	// stop old daemon
					Fred.action := 0;				// reset daemon counter
					notify( Fred, &actorDaemon2, 0 );	// start new daemon
					
					return( true );
				}
			case Architect:
				"He says, \"I'm not sure what you mean about a transient
				living in your garage, when we haven't even poured the
				concrete foundation yet!\" ";
				return( true );
			default: 
				return( nil );
		}
	}
	askingAboutMe( who ) =
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"Do I know any old winos? Yeah, my deadbeat dad!
				Seriously, though. I haven't seen anyone like that around here.
				This is still a pretty good area of town.\" ";
				return( true );
			case Laura:
				"Laura says, \"Gee, he sounds like a very sad and lonely 
				person. Maybe you should try to give him a little money, 
				or some food. Or maybe a blanket. It's hard to know what
				to do for the homeless.\" ";
				return( true );
			case Architect:
				"He says, \"I don't really know what to tell you about some
				old wino.\" ";
			default: return( nil );
		}
	}
	meetFred( movementStr ) =
	{
		"You are startled to see a staggering, red-eyed man with a bloated gut 
		and ill-fitting clothes";
		
		if ( movementStr != nil ) 
			say( movementStr );
		
		". He regards you warily, as if you are trespassing on his territory.\b
		
		\"What are you doing here? Get out, go away!\"\ he says, his voice a 
		sooty croak. ";
		
		if ( Fred.met )
		{
			"You are horrified when you recognize that this is Fred, the man 
			from the sandwich shop. ";
			
			Fred.lookedAtOnce := true;
		}
		
		"Your instinct is to let him be, whatever he thinks his business here is. ";
		
		newListenDesc( Me.location, 'You hear the man\'s wheezy, tortured 
			breathing. ' );
		
		self.met := true;
		setit( self, 1 );
	}
	takeBottleFromPlayer = 
	{
		if ( self.lookingForBottle )
			"\^<<self.thedesc>> glares at you with sunken, bloodshot eyes. 
			\"I knew it! Stay out of my stuff, you thief!\" He grabs the
			bottle from you and takes a long suck at it. \"And stay outta
			my house!\" Emitting a smelly belch, he shambles off. ";
		else
			"\^<<self.thedesc>> sees the bottle in your hands and
			glares at you furiously. He says, \"Hey -- you been in 
			my stash, you thief! Keep outta my things!\" He grabs the 
			bottle away from you and takes a long suck on it. 
			\"And st--\" He is interrupted by a wet belch. 
			\"Stay outta my house!\" ";
		
		self.staggerAway;
		self.stopActorDaemon;
	}
	takeBottleFromLocation =
	{
		if ( Me.location = self.location )
		{
			if ( whiskeyBottle.location = Fattic )
			{
				"You hear his voice say, \"Aha! Here she is!\" There follows a loud
				sucking and gulping noise for a few moments, and then a rattling
				belch. \b
				
				\^<<self.thedesc>> somehow manages to make it back down the
				ladder on his shaky legs. He wags a dirty finger in your face.
				\"You thief! You ought to be ashamed, makin' an old man climb
				that ladder! I coulda had a heart attack or a st--\" He belches
				again. \"Or a stroke!\" \b
				
				He then seems to forget about you, his eyes losing focus. He
				turns and grips onto the stairway banister. As he starts down
				the stairs, he looks back at you and says, \"Just keep outta
				my things. And stay outta my house!\" Muttering a few more
				oaths, he shambles down the stairs. You hear his footsteps 
				disappear out the back door into the garage. ";
				
				self.stopActorDaemon;
				return( nil );
			}
			else if ( whiskeyBottle.location = Ffoyer )
			{
				"You hear his voice say, \"Aha! Here she is!\" There follows a 
				loud sucking and gulping noise from below for a few moments,
				and then a gurgling belch. \b
				
				\^<<self.thedesc>> attempts to climb back up the stairs, but
				slips and seems to lose the ability in his legs necessary for
				the ascent. Instead, he pokes a finger up the stairs at you.
				\"You thief! Yer just lucky I found it, or I'd have to give 
				you a knuckle sandwich!\" He starts laughing hoarsely. \"Best
				sandwich I ever served up!\" His laughter turns into a rattling
				cough, and then he has to stop to catch his breath. \b

				\"Just keep outta my stuff. And stay outta my house!\" he 
				says, though he hardly manages the breath to do so. After
				that, he shambles off. You hear him go out the back door
				into the garage. ";
				
				self.stopActorDaemon;
				return( nil );		
			}
			else if ( self.lookingForBottle )
				"\^<<self.thedesc>> reaches into a hole in the wall and
				retreives the bottle with a violent yank. \"Aha! Here she
				is.\" After taking a long suck at it, he turns
				his gaze back to you. \"Keep outta my way, and outta 
				my house!\" Emitting a smelly belch, he shambles off. ";
			else
				"\^<<self.thedesc>> wheezes as he picks up the bottle. 
				Taking a long suck at it, he shambles off out through the 
				kitchen and into the garage. ";
			
			self.staggerAway;
		}
		else
		{
			"You hear <<self.thedesc>> let out a grunt. \"Aha! Here she is,\" he 
			mutters to himself. You hear nothing for a few moments, and then a 
			wet belch. ";
			
			if ( Me.location = Ffoyer || Me.location = Fkitchen )
				"Just after that, <<self.thedesc>> shambles heavily down
				the stairs. He staggers past you, out into the garage. ";
			else if ( Me.location.upstairs || Me.location = FupstairsHallway || 
				Me.location = Fattic )
				"Just after that, you hear him shamble down the stairs. His
				footsteps disappear shortly after that. ";
			else if ( Me.location = FinGarage )
				"Just after that, he shambles back into the garage and 
				flops heavily down onto the soiled mattress, oblivious to
				your presence for the moment. ";
			else
				"Just after that, you hear him shamble out through the back 
				door into the garage. ";
		}
		self.stopActorDaemon;
	}
	staggerAway =
	{
		"\b";
		
		switch( Me.location )
		{
			case Fattic:
				"\^<<self.thedesc>> slips shakily down the ladder.
				After that, you hear him make a similarly uneven
				journey down the stairs. His footsteps disappear
				after that. ";
				break;
			
			case FupstairsBedroomN:
			case FupstairsBedroomS:
			case FupstairsBathroom:
			case FupstairsHallway:
				"\^<<self.thedesc>> stumbles violently down the 
				stairs, clutching the banister with his free hand
				for support. You hear his footsteps disappear out
				the back door into the garage. ";
				break;
			
			case Ffoyer:
			case Fkitchen:
				"\^<<self.thedesc>> shambles past you and 
				out the back door into the garage. ";
				break;
			
			default:
				"\^<<self.thedesc>> turns his back on you and noisily breaks wind.
				Letting out a raspy laugh that becomes an asthmatic cough, he
				exits. You hear his footsteps disappear out the back door into
				the garage. ";
				break;
		}
	}
	stopActorDaemon = 
	{
		whiskeyBottle.moveInto( self );
		if ( not self.isIn( FinGarage ) )
			self.moveInto( FinGarage );
		unnotify( self, &actorDaemon );
		restoreListenDesc( Me.location );
		self.actorDaemonStopped := true;
		self.myfollower.moveInto( nil );
		
		if ( not FLaura.met && FLaura.daemonCount = 0 ) 
			notify( FLaura, &actorDaemon, 0 );	// summon future-Laura
	}
	
	daemonCount = 0
	actorDaemon = 
	{
		if ( ( not Me.location.indoors ) || Me.location = locksmiths )
			return;
		
		if ( whiskeyBottle.isIn( self ) )
		{
/*			if ( self.location != FinGarage )
				"[BUG! Fred has bottle but isn't in the garage.] ";
			else
				"[BUG! Fred.actorDaemon shouldn't still be running.] ";
*/
			unnotify( self, &actorDaemon );
			return( nil );
		}

		"\b";
		switch( self.daemonCount )
		{
			case 0: 
			{
				self.moveInto( Fkitchen );
//				FkitchenBackDoor.setIslocked( nil );
				FkitchenBackDoor.setIsopen( true );
				FgarageDoor1.setIslocked( nil );
				FgarageDoor1.setIsopen( true );
				
				if ( Me.location.upstairs )
				{
					"You hear a noise downstairs. "; 
					newListenDesc( Me.location, 'It sounds as if someone else
						is inside the house. ' ); 
				}
				else if ( Me.location = Fkitchen )
				{
					if ( not self.met )
						self.meetFred( ' burst in from the garage before you
						can open the door' );
					else
						"\^<<self.thedesc>> bursts in from the garage. ";
				}
				else if ( Me.location = FinGarage ) 
				{
					"\^<<self.thedesc>> pushes boozily past you through
					the door into the house. \"Wherrzit?\" he slurs, 
					muttering to himself. \"Needa liddle morrrathat.\" ";
				}
				break;
			}
			case 1:
			{
				if ( Me.location = Fkitchen )
				{
					if ( not self.met )
					{
						self.meetFred( nil );
					}
					"\b\^<<self.thedesc>>, a hungry look darkening
					his features, leaves the kitchen in a boozy version of 
					a hurry. ";
				}
				
				self.moveInto( Ffoyer );
				if ( Me.location = Ffoyer )
				{
					if ( not self.met )
						self.meetFred( ' enter from the kitchen' );
					else
						"\^<<self.thedesc>> enters from the kitchen and
						kicks some trash out of the way as he heads toward
						the staircase. ";
				}
				else
				{
					"You hear bits of trash being kicked around in the
					foyer at the bottom of the staircase";
					
					if ( not self.met )
					{
						", and a rough, man's voice uttering curses. ";
						newListenDesc( Me.location, 'It sounds as if someone
							is about to come upstairs. ');
					}
					else
						". ";
				}
				break;
			}
			case 2: 
			{
				if ( Me.location = Ffoyer )
				{
					if ( not self.met )
					{
						self.meetFred( ' lurching towards the stairs' );
					}
					self.moveInto( Ffoyer );
				}
				
				if( whiskeyBottle.isIn( Me ) )
				{
					if ( Me.location = Ffoyer )
					{
						self.takeBottleFromPlayer;
						return( nil );
					}
					else if ( Me.location.downstairs )
					{
						"\^<<self.thedesc>> follows you into the ";
						nocaps(); Me.location.sdesc; 
						". He grabs your shoulder and spins you around to 
						face him. \b";
						
						self.takeBottleFromPlayer;
						return( nil );
					}
					else if ( Me.location = FfrontOfHouse )
					{
						"\^<<self.thedesc>> follows you out the 
						front door. He grabs your shoulder and spins 
						you around to face him. \b";
						
						self.takeBottleFromPlayer;
						return( nil );
					}
				}
				
				self.moveInto( FupstairsHallway );
								
				if ( Me.location = FupstairsHallway )
				{
					if ( not self.met )
					{
						self.meetFred( ' struggle up the stairs' );
					}
					else
						"\^<<self.thedesc>> wheezes as he climbs up 
						the staircase, one hand on the wall and one
						hand on the banister to steady himself. ";
					
					"He pushes past you and sticks his arm into the 
					hole in the wall. Muttering and cursing, he 
					gropes around a second time. Out of breath, he 
					slumps against the wall.\b
					\"It's here somewhere.\" he says. ";
					self.lookingForBottle := true;
					newListenDesc( Me.location, 'You hear the man\'s 
						wheezy, tortured breathing. ' );
				}
				else
				{
					if ( whiskeyBottle.isIn( Ffoyer ) )
						"\^<<self.thedesc>> doesn't seem to notice you
						or the bottle you just dropped. He pushes past
						you, his foot nearly kicking the bottle, and
						struggles up the stairs. ";
					else
						"\^<<self.thedesc>> struggles up the stairs. ";
					
					"You hear some muttering and cursing, and then
					a pause, and then some more muttering. \b
					\"It's here somewhere,\" you hear him say. ";
					self.lookingForBottle := true;
					restoreListenDesc( Me.location );
				}
			}
			break;
			
			case 3:
 			{
				if ( whiskeyBottle.isIn( self.location ) && 
					( not whiskeyBottle.deepIsIn( Me ) ) )
				{
					if ( ( Me.location = self.location ) && ( not self.met ) )
					{
						self.meetFred( ' slumped up against the wall' );
						
						"In a raspy voice he mutters, \"I'll find it -- I'll
						find it. Gotta find it!\" ";
						
						"\b";
					}
					self.takeBottleFromLocation;
					return( nil );
				}

				if ( not self.met )
				{
					if ( Me.location = self.location )
					{
						self.meetFred( ' slumped up against the wall' );
						
						"In a raspy voice <<self.thedesc>> mutters, \"I'll find 
						it -- I'll find it.\" ";
						
						if ( whiskeyBottle.location.upstairs )
							"He starts to search the upstairs rooms. \"Maybe 
							I left it in here,\" you hear him say. ";
						else if ( whiskeyBottle.location = Fattic )
							"He focuses on the ladder behind you and eyes
							you suspiciously. \"If I find it up here,\" he
							wheezes, \"I'll kick yer teeth in.\" He climbs
							shakily up into the attic. ";
						
						"\b";
					}
					else
					{
						"You hear a raspy voice roar, \"Where'd I put it!
						I gotta find it!\" ";

						if ( Me.location = Fattic )
						{
							"Whoever it is starts to climb up the ladder 
							into the attic. \"Maybe I put it up here,\" you
							hear him say. \b";
							
							self.meetFred( ' struggle up the ladder with 
							labored wheezes at every breath' );

							"\b";
						}
						else
						{
							"Whoever it is starts to search around the 
							upstairs rooms. \"Maybe I left it in here,\" you
							hear him say. \b";
							
							self.meetFred( ' burst into the room, almost 
								losing his balance' );
							
							"\b";
						}

						self.moveInto( Me.location );
					}
				}
				else
				{
					if ( Me.location = FupstairsHallway )
					{
						"In a raspy voice <<self.thedesc>> mutters, 
						\"I'll find it. Gotta find it!\" ";
						
						if ( whiskeyBottle.location != nil && 
							whiskeyBottle.location.upstairs )
							"\^<<self.thedesc>> starts to search the upstairs
							rooms. \"Maybe I left it in here,\" you hear him
							say. ";
						else if ( whiskeyBottle.location = Fattic )
							"\^<<self.thedesc>> focuses on the ladder behind 
							you and eyes you suspiciously. \"If I find it up 
							here,\" he wheezes, \"I'll kick yer teeth in.\" 
							He climbs shakily up into the attic. ";
						else if ( whiskeyBottle.location = Ffoyer )
							"\^<<self.thedesc>> gives you the evil eye. 
							\"Didn't I just see you holding it?\" He squeezes 
							past you and stumbles somewhat heavily down the 
							stairs, clutching at the banister for support. "; 
						
						"\b";
					}
					else
					{
						"You hear <<self.thedesc>>'s raspy voice roar, \"I'll 
						find it -- I'll find it. Gotta find it!\" ";
						
						if ( Me.location = Fattic )
						{
							"\^<<self.thedesc>> starts to climb up the ladder 
							into the attic. \"Maybe I put it up here,\" you
							hear him say. \b";
						
							self.moveInto( Fattic );
						}
						else if ( Me.location.upstairs )
						{
							"\^<<self.thedesc>> starts to search the upstairs
							rooms. \"Maybe I left it in here,\" you hear him
							say. \b";
							
							"Moments later, <<self.thedesc>> bursts into the room, 
							almost losing his balance. \b";
							
							self.moveInto( Me.location );
						}
						else
						{
							"\^<<self.thedesc>> starts to search the upstairs
							rooms. \"Maybe I left it in here,\" you hear him
							say. ";
						}
						
						"\b";
					}
				}
				
				if ( Me.location != self.location )
				{
					"After a couple of minutes, you hear a prolonged burst
					of profanity, and then the creak of heavy feet descending
					the stairs. ";
				}
				
				if( whiskeyBottle.isIn( Me.location ) )
				{
					if ( Me.location != self.location )
					{
						"Moments later, <<self.thedesc>> bursts into the room, 
						almost losing his balance. \b";
					}
					
					if ( whiskeyBottle.deepIsIn( Me ) )
						self.takeBottleFromPlayer;
					else
						self.takeBottleFromLocation;
					
					return( nil );
				}
				else 
				{
					self.takeBottleFromLocation; 
					return( nil ); 
				}
			}
			break;
			
			default: 
				"[BUG - Fred should have found the bottle by now. (default)] ";
				self.daemonCount--;
				break;
		}
		self.daemonCount++;
	}
	daemonCount2 = 0
	actorDaemon2 =
	{
		if ( Me.location != self.location )
			return;
		
		switch( self.daemonCount2 )
		{
			case -1:
				unnotify( self, &actorDaemon2 );
				break;
			case 0: 
				"\^<<self.thedesc>> staggers off to the northeast. ";
				FFred.moveInto( FfrontOfHouse );
				setit( FFredFollower, 1 );
				break;
			case 1: 
				"\^<<self.thedesc>> sees you following him, grunts, and
				wanders northwest. ";
				FFred.moveInto( FnorthOfHouse );
				break;
			case 2:
				if ( not FFred.met )
					FFred.meetFred( 'standing in the driveway, cursing under
					his breath about the three dark-suited figures' );
				
				"\^<<self.thedesc>> pulls open the rusty garage door and
				goes inside. ";
				FFred.moveInto( FinGarage );
				FgarageDoor1.setIsopen( true );
				FgarageDoor1.setIslocked( nil );
				break;
			case 3:
				"\^<<self.thedesc>> glares at you. \"Get out!\"\ he yells. 
				He already doesn't seem to remember meeting you. Then his 
				eyes lose focus and he forgets you're even there at all. He opens 
				the door into the house and enters the kitchen, bumping against 
				the refrigerator as he does so. ";
				
				FgarageBackDoor.setIsopen( nil );
				FgarageBackDoor.setIslocked( nil );
				unnotify( self, &actorDaemon2 );
				notify( self, &actorDaemon, 0 );
				
				self.daemonCount2 := 0;
				self.daemonCount := 1;
				break;
		}
		self.daemonCount2++;
	}
;

FFredFollower: follower
	myactor = FFred
	noun = 'wino'
	adjective = 'Fred' 'future' 'alcoholic' 'alkie' 'homeless' 'man' 'person' 'bum'
			'sot' 'hobo' 'grubby' 'dirty' 'woozy' 'smelly' 'stinky' 'stinking'
	location = nil
	
	doFollow( actor ) =
	{
		inherited.doFollow( actor );
		if ( Me.location = self.location );
			setit( self, 1 );
	}
;

FnorthRoof: room
	sdesc = "North roof"
	ldesc = 
	{
		if ( future.state = 3 ) 
			"You stand gingerly on the north end of the roof, one hand 
			on the chimney for support. The shingles under your feet are 
			solid and in very good shape, and they seem to have kept the 
			fire from spreading. ";
		else 
			"This is the north end of the roof. The shingles are in good shape, 
			even after twenty years of weather. Someone obviously took the time and 
			care to do this roof job right. ";
	}
	xdesc = 
	{
		if ( future.state = 3 ) 
			"However, it is still extremely precarious to stand here because 
			of the damage to the south end of the roof. "; 
		else 
			"The roof itself continues south. ";
		"The stone wall of the chimney leads back down. ";
	}
	south = {
		if ( future.state = 3 )
		{
			"You can't walk that way, because the tree has collapsed
			the south end of the roof. ";
		}
		else return( FsouthRoof );
	}
	down = 
	{
		"You climb gingerly down the stone wall.\n";
		return( FnorthOfHouse );
	}
	noexit = "You will fall off the roof if you go in that direction. "
;

trollaxe: fixedBlock, floatingItem
	sdesc = "troll's axe"
	ldesc = "It was just a metaphor. "
	noun = 'axe'
	adjective = 'troll' 'troll\'s' 'soft' 'elven' 'elf' 'skull' 'metaphor'
	location = 
	{
		if ( future.state = 3 )
			return( FnorthRoof );
		else return( nil );
	}
;

gapingHoleInSouthRoof: fixedBlock, floatingItem
	sdesc = "gaping hole"
	ldesc = "The damage is severe. A violent, gaping hole has been 
		smashed open by the tree trunk, splitting open the entire
		southern roof like a troll's axe through a soft elven skull. 
		Drizzly rain leaks down the black, splintered edges. "
	noun = 'hole'
	adjective = 'huge' 'large' 'open' 'hole' 'gaping' 'chewed' 'trunk' 
			'tree' 'drizzly' 'rain' 'damage' 'south' 'roof' 'collapse'
			'collapsed' 'end' 'of'
	location = 
	{			
		if ( future.state = 3 )
			return( FnorthRoof );
		else return( nil );
	}
	
	verDoDrink( actor ) = 
	{
		"I don't know how to drink the drizzly rain that's leaking down
		into the gaping hole. ";
	}
	verDoEnter( actor ) = 
	{
		"It is too dangerous to enter the attic from above in that way. ";
	}
	verDoClimb( actor ) = 
	{
		"It is too dangerous to enter the attic from above in that way. ";
	}
	verDoClimbDown( actor ) = 
	{
		"It is too dangerous to enter the attic from above in that way. ";
	}
	verDoLeapTo( actor ) = 
	{
		"It is too dangerous to enter the attic from above in that way. ";
	}
	verDoLetGo( actor ) =
	{
		"It is too dangerous to enter the attic from above in that way. ";
	}
;

FstoneWall2: fixedBlock
	sdesc = "stone wall"
	noun = 'wall'
	adjective = 'stone'
	location = FnorthRoof

	verDoClimb( actor ) = 
	{
		"You can't climb the stone wall any higher. ";
	}
	
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) = 
	{
		Me.travelTo( self.location.down );
	}
;

Fchimney: block
	sdesc = "chimney"
	noun = 'chimney'
	location = FnorthRoof
	
	verDoEnter( actor ) = 
	{
		"The chimney isn't a way into the house, if that's what you mean.  You can 
		climb down the stone wall to get back to the ground. ";
	}
	doSynonym( 'Enter' ) = 'Board'
	verDoClimbDown( actor ) = 
	{
		"The chimney isn't a way into the house, if that's what you mean.  You can 
		climb down the stone wall to get back to the ground. ";
	}
	doClimb -> FstoneWall2
;

Fshingles1: block
	sdesc = "shingles"
	ldesc = "The shingles are in good shape, even after twenty years of 
			weather<<future.state = 3 ? "and recent natural disaster." :
			".">> Someone really took care to do this roofing job right. "
	noun = 'shingle' 'single' 'tile' 
	isThem = true
	plural = 'shingles' 'singles' 'tiles'
	location = FnorthRoof
	
	verDoLeapTo( actor ) = 
	{
		"You are too high up to risk doing that. You'll break your ankle if
		you jump off the roof. ";
	}
	
	verDoLetGo( actor ) =
	{
		"Falling off the roof is an inherently dangerous idea. ";
	}
;

Fgutter1: qcontainer, staticItem
	sdesc = "gutter"
	ldesc = "It's clogged full of leaves. "
	noun = 'gutter' 'trap'
	location = FnorthRoof
	
	doSearch -> Fleaves1
	doLookin -> Fleaves1
	verDoClean( actor ) = 
	{
		"You pull some leaves out of the gutter and toss them aside.
		The gutter looks a little cleaner now, but not by much. ";
	}
;

Fleaves1: fixeditem
	sdesc = "leaves"	
	noun = 'leaf'
	plural = 'leaves'
	isThem = true
	location = Fgutter1
	bulk = 10
	
	verDoLookin( actor ) = { self.verDoSearch( actor ); }
	doLookin( actor ) = { self.doSearch( actor ); }
	
	verDoClean( actor ) = { self.verDoTake( actor ); }
	verDoTake( actor ) = 
	{
		"You pull a few stray leaves from the gutter and toss them aside. ";
	}
;

FsouthRoof: room
	sdesc = "South roof"
	ldesc = "You stand atop the peak of the house at the southern end.
			The shingles here are in good shape, even after twenty years of weather.
			The ground is a long way down from here, at least 30 feet.  The 
			gutter trap is to the west and continues up to the north end of 
			the house. "
	xdesc = "The only exit is north. " 
	north = FnorthRoof
	south = "You will fall into the gaping hole in the roof if you go in that 
			direction. "
	noexit = "You will fall off the roof if you go in that direction. "
;

Fshingles2: staticItem
	sdesc = "roof shingles"
	ldesc = 
	{
		if ( global.newRoof = nil )
			"The shingles are in really bad shape on this end of the house.  Some of 
			them are really loose. ";
		else
			"The ultimate in roof shingling -- durable, weatherproof, and fancy! ";
	}
	noun = 'shingle' 'single' 'tile' 'roof'
	plural = 'shingles' 'singles' 'tiles'
	isThem = true
	location = FsouthRoof
	
	verDoTake( actor ) =
	{
		"There aren't any shingles loose enough to take. ";
	}
	
	verDoLeapTo( actor ) = 
	{
		"You are too high up to risk doing that. You'll break your ankle if
		you jump off the roof. ";
	}
	
	verDoLetGo( actor ) =
	{
		"Falling off the roof is an inherently dangerous idea. ";
	}
;

Fgutter2: staticItem
	sdesc = "gutter"
	ldesc = "It's clogged full of leaves, but you can still make out the top opening of 
			the drainpipe that leads down to the back of the house. "
	noun = 'gutter' 'trap'
	location = FsouthRoof
	
	ioPutIn -> Fdrainpipe
	ioThrowIn -> Fdrainpipe
	doClean -> Fdrainpipe
	doCleanWith -> Fdrainpipe
	doLookin -> Fdrainpipe
	doSearch -> Fdrainpipe
;

Fleaves2: block
	sdesc = "leaves"
	noun = 'leaf'
	plural = 'leaves'
	isThem = true
	location = Fgutter2
	bulk = 10
	
	verDoLookin( actor ) = { self.verDoSearch( actor ); }
	doLookin( actor ) = { self.doSearch( actor ); }
	
	verDoClean( actor ) = { self.verDoTake( actor ); }
	verDoTake( actor ) = 
	{
		"You pull a few stray leaves from the gutter and toss them aside. ";
	}
;

Fdrainpipe: fixeditem, qcontainer
	sdesc = "drainpipe"
	ldesc = "It runs from here down to a spout at the back of the house. "
	noun = 'pipe' 'drainpipe' 'drain'
	location = FsouthRoof
	cleaned = nil

	verDoSearch( actor ) = {}
	doSearch( actor ) =
	{
		if ( not self.cleaned )
			"You feel nothing but muck and wet leaves in the drainpipe. ";
		else
			"The drainpipe is empty. ";
	}

	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) =
	{
		if ( not drainpipe.cleaned )
		{
			"The drain is so completely clogged from years upon years of
			accumulated leaves that nothing can go down it. ";
			return( nil );
		}
		
		"%You% drop "; dobj.thedesc; " into the drainpipe. ";
		
		if ( self.cleaned )
		{
			"It rattles through and comes out the spout below. ";
			dobj.moveInto( FbehindHouse );
		}
		else
		{
			if ( dobj != cannonball)
			{
				"It vanishes, leaving you with a sinking feeling in your gut 
				that you won't see it again. ";
		
				dobj.doPutIn( actor, stuckLimbo );
			}
			else
			{
				local i, lst, len;

				"It barely fits, so you give it a shove. There is a disgusting vomiting 
				noise below, as the cannonball bursts out the bottom of the spout, 
				pushing all the muck out with it. ";
				
				self.cleaned := true;
				cannonball.moveInto( FbehindHouse );
				FdrainpipeCloggingLeaves.moveInto( nil );
				Fleaves2.moveInto( Fgutter2 );
				
				lst := stuckLimbo.contents;		// empty the pipe by moving all 
				len := length(lst);				// items in stuckLimbo into behindHouse
				for (i := 1 ; i <= len ; ++i)
					lst[i].moveInto( FbehindHouse );
			}
		}
	}
	
	verDoLookin( actor ) = {}
	doLookin( actor ) =
	{
		if ( self.cleaned = nil )
			"%You% see nothing but muck and darkness in the drainpipe. ";
		else
			"Clean as a whistle! ";
	}
	
	verDoAttack( actor ) = { self.doKick( actor ); }
	verDoAttackWith( actor, io ) =
	{
		if ( io = shovel || io = crowbar )
			self.doKick( actor );
		else pass doAttackWith;
	}
	
	verDoClean( actor ) = 
	{
		if ( !self.cleaned )
			FdrainpipeCloggingLeaves.verDoTake( actor );
		else
			"The drainpipe is already cleaned out. ";
	}
	verDoCleanWith( actor, io ) = 
	{
		"That isn't going to work. ";
	}
	
	doKick -> Fdrainspout
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sounds like you need to clean out that sucker.
				Maybe shove something really heavy down it, and it'll blow
				out all the muck.\" ";
				return( true );
			case Laura:
				"Laura says, \"Eewww, clogged drainpipes.\" ";
				return( true );
			case Architect:
				"He says, \"It's important to keep drainpipes clean, otherwise
				they will just clog up. It would take a lot of force to clean 
				out a clogged drainpipe.\" ";
				return( true );
			case squirrel:
				"The squirrel scrambles over to the clogged drainpipe and 
				peers in, then races back to where he was. ";
				return( true);
			default: 
				return( nil );
		}
	}
;

FdrainpipeCloggingLeaves: fixeditem
	sdesc = "leaves"
	ldesc = "The muck is made of wet leaves that are clogging the flow 
			down the drainpipe. "
	adesc = "some leaves"
	noun = 'clog' 'leaf'
	plural = 'leaves'
	isThem = true
	adjective = 'muck' 'wet' 'darkness'
	location = 
	{
		if ( not Fdrainpipe.cleaned )
		{
			if ( Me.location = FsouthRoof )
				return( drainpipe );
			if ( Me.location = FbehindHouse )
				return( drainspout );
		}
		return( nil );
	}
	
	verDoSearch( actor ) = { self.verDoLookin( actor ); }
	verDoLookin( actor ) = 
	{
		"You see nothing but muck and wet leaves in the drainpipe. ";
	}

	verDoClean( actor ) = { self.verDoTake( actor ); }
	verDoCleanWith( actor, io ) = 
	{
		"That isn't going to work. ";
	}
	
	verDoPull( actor ) = { self.verDoTake( actor ); }
	verDoTake( actor ) =
	{
		"You pull out a few stray leaves, but it does nothing to unclog
		the drainpipe. ";
	}
	
	verDoPryWith( actor, io ) =
	{
		"That isn't going to work. ";
	}
;

FbehindHouse: room
	sdesc = "Behind house"
	ldesc = 
	{
		switch( future.state )
		{
			case 0:   /*  no rod, no tree, no roof  */
				"The house has been destroyed by fire. There is nothing left 
				of the roof or the upper half, and of the lower half, merely 
				charred timbers and twisted pipes that no longer lead to 
				anything. ";
				break;
			case 1:   /*  no rod, no tree, yes roof  */
				"The house has been damaged by fire. Though the roof remains
				intact, the insides have been burnt out, leaving a brittle,
				soot-stained shell that you can hear wind whistling through. ";
				break;
			case 2:   /*  no rod, yes tree, no roof  */
				"The house has been ravaged by fire. Though much of the
				lower structure remains, there is nothing left of the roof or 
				the upper half, merely charred timbers and twisted pipes that 
				no longer lead to anything. The nearly unrecognizable remains 
				of furniture are overturned and mildewing inside the jaggered 
				black wood. ";
				break;
			case 3:   /*  no rod, yes tree, yes roof  */
				"The house is burned and crippled, a shadow of its former pleasant
				beauty. The southern roof has been torn open by the weight of a
				fallen tree. However, the fire seems not to have spread very far,
				thanks to the fire-resistant shingles. The dead trees that line the 
				west edge of the property seem to regard the scene with a sagelike
				sadness. ";
				break;
			case 4:   /*  yes rod, no tree, no roof  */
				"The house is older and sagging, with long ruts where splinters 
				have broken off. The worst damage is to the roof, which has 
				turned rotten and caved in. Even the old trees that line the 
				west edge of the property only add to the general gloom, because
				they too are dead. ";
				break;
			case 5:   /*  yes rod, no tree, yes roof  */
				"The house is older and sagging, with long ruts where splinters 
				have broken off, but otherwise looks the way you remember it. 
				The back of your house is as non-descript as ever. Even the 
				old trees that line the west edge of the property don't do much
				to liven the area any more, since they too are dead. The spout 
				of your drainpipe comes down here from the roof. ";
				break;
			case 6:   /*  yes rod, yes tree, no roof  */
				"The house is older and sagging, with long ruts where splinters 
				have broken off. The worst damage is to the roof, which has 
				turned rotten and caved in. The old trees that line the west 
				edge of the property don't do much to liven the area any more. ";
				break;
			case 7:   /*  yes rod, yes tree, yes roof */
				"The back of your house is as non-descript as ever. Even the 
				old trees that line the west edge of the property don't do much
				to liven the area any more. The spout of your drainpipe comes 
				down here from the roof. ";
				break;
		}
	}
	xdesc = "A gravel path extends northeast and southeast. "
	se = FsouthOfHouse
	ne = FnorthOfHouse
	east = 
	{
		if ( future.state < 3 )
			return( FinsideHouse );
		else {
			"You can't enter the house from here. ";
			return( nil );
		}
	}
;

FdeadTrees: fixedBlock
	sdesc = "<<future.state > 5 ? "old trees" : "dead trees">>"
	noun = 'tree'
	plural = 'trees'
	isThem = true
	adjective = 'dead' 'old'
	location = FbehindHouse
;

Fdrainspout: block, qcontainer, floatingItem
	sdesc = "drainpipe"
	noun = 'spout' 
	adjective = 'drainpipe' 'pipe' 'drain'
	location = 
	{
		switch( future.state )
		{
			case 0: return( nil );
			case 1: return( nil );
			case 2: return( nil );
			case 3: return( FbehindHouse );
			case 4: return( nil );
			case 5: return( FbehindHouse );
			case 6: return( nil );
			case 7: return( FbehindHouse );
		}
	}
	maxbulk = 0
	
	verDoSearch( actor ) = { self.verDoLookin( actor ); }
	verDoLookin( actor ) = 
	{
		if ( Fdrainpipe.cleaned )
			"You find nothing of interest. ";
		else
			"The drainpipe is clogged with leaves. ";
	}
	
	verDoAttack( actor ) = { self.doKick( actor ); }
	verDoAttackWith( actor, io ) =
	{
		if ( io = shovel || io = crowbar )
			self.doKick( actor );
		else pass doAttackWith;
	}
	
	doClean -> drainpipeCloggingLeaves
	verDoCleanWith( actor, io ) = 
	{
		"That isn't going to work. ";
	}
	
	verDoKick( actor ) = {}
	doKick( actor ) =
	{
		if ( Fdrainpipe.cleaned ) 
			"You strike the drainpipe. It makes a hollow metallic noise. ";
		else if ( length( stuckLimbo.contents ) = 0 )
			"You strike the drainpipe. It makes a dull noise, padded by all 
			the leaves clogging it up. ";
		else
		{
			if ( self.kickedOnce )
				"Repeatedly striking the drainpipe is not going to unclog
				it. If anything, it will cause whatever is inside it to settle 
				into an even more tightly clogged state. ";
			else
			{
				"It makes a dull noise, and you hear its clogged contents 
				shift slightly. ";
				self.kickedOnce := true;
			}
		}
	}
	
	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) = 
	{
		if ( dobj.bulk > 2 ) 
			"You can't fit that into the drainpipe. ";
		else 
		{
			if ( dobj = cannonball || dobj = tennisBall )
				"You put <<dobj.thedesc>> into <<self.thedesc>>, and it
				rolls out onto the ground. ";
			else
				"You put <<dobj.thedesc>> into <<self.thedesc>>, and it
				falls out onto the ground. ";
			dobj.moveInto( FbehindHouse );
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"If you've got a drainspout, you probably have a 
				drainpipe up on the roof gutter. That's probably where you need
				to look.\" ";
				return( true );
			case Laura:
				"Laura says, \"If nothing's coming out the spout, maybe you should
				look at the drainpipe opening on the roof gutter.\" ";
				return( true );
			case Architect:
				"He says, \"Harumph!\" and shoos you away. \"I'm not here to solve
				your problems for you.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

FgravelPath: fixedBlock
	sdesc = "gravel path"
	noun = 'gravel' 'path'
	location = FbehindHouse
;

Fsidewalk: room
	sdesc = "Sidewalk"
	ldesc = "After the shocking sight of your house, this once-familiar sidewalk 
			is a calming surprise. Someone must have recently repoured the walk, 
			as it is smooth and free of flaws. " 
	xdesc = "The sidewalk bends runs alongside the road from your house to the west 
			into the nearby strip mall, which is north. "
	noun = 'sidewalk'
	adjective = 'smooth'
	west = Fdriveway
	north = stripMall
	
	enterRoom( actor ) =	// sent to room as actor is entering it
	{
		inherited.enterRoom( actor );
		if ( account.isopen && ATMcard.location = nil )
		{
			ATMcard.moveInto( Fmailbox );
			Fmailbox.isopen := true;
			Fmailbox.mailwaiting := true;
			"\bThere's something in your mailbox. ";
		}
	}
;

Fmailbox: openable, qcontainer, staticItem
	isListed = true
	isopen = nil
	sdesc = "mailbox"
	noun = 'mailbox' 'box'
	location = Fsidewalk
;

FmailboxFlag: fixedBlock
	sdesc = "flag"
	ldesc = "The mailbox flag is <<self.isup ? "up" : "down">>. "
	noun = 'flag'
	location = Fsidewalk
	isup = nil
	
	verDoLift( actor ) = 
	{
		if ( self.isup ) 
			"The mailbox flag is already raised. ";
	}
	doLift( actor ) = 
	{
		"You raise the mailbox flag. ";
		self.isup := true;	
	}
	
	verDoLower( actor ) = 
	{
		if ( not self.isup )
			"The mailbox flag is already down. ";
	}
	doLower( actor ) =
	{
		"You lower the mailbox flag. ";
		self.isup := nil;
	}
;

ATMcard: treasure
	sdesc = "ATM card"
	ldesc = "It is your personal automated teller machine card. "
	noun = 'card'
	adjective = 'ATM'
	location = nil
	takevalue = 2
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
		case Fred:
			"Fred says, \"Hm, that's definitely for the local bank, but
			I don't think they have a teller machine at this branch. 
			Maybe they're planning on it.\" ";
			return( true );
		case Laura:
			"Laura says, \"What is that? Where did you get it? I'm not 
			even sure what that's for.\" ";
			return( true );
		default: 
			return( nil );
		}
	}
;

librarySlip: readable, floatingItem
	herring = true
	sdesc = "envelope"
	adesc = "an envelope"
	ldesc = "It's addressed to you, from the library. It's got that stern, official 
			look to it, like it's some kind of official threat. "
	noun = 'envelope' 'invoice' 'bill' 'threat'
	location = nil
	readdesc =
	{
		"It says you are ten years overdue on the library book on time travel 
		theories. No wonder you don't live here any more, you owe more on that 
		book than you've made in your lifetime. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"If I were you, I'd return that book. Ten years
				overdue? That's pretty serious.\" ";
				return( true );
			case Laura:
				"Laura says, \"Tsk! You shouldn't keep books out that long. What
				if someone else wants to check out that book?\" ";
			return( true );
			default: 
				return( nil );
		}
	}
;

Froad1: fixedBlock
	sdesc = "road"
	noun = 'road'
	location = Fsidewalk
;

FdummyVillage: distantItem
	sdesc = "village"
	noun = 'village'
	adjective = 'shopping' 'nearby'
	location = Fsidewalk
;

stripMall: room
	sdesc = "Strip mall"
	ldesc = "The walk to town is much shorter, because progress seems to have 
			brought the town to you. Where there used to be some nice trees and 
			bushes is a concrete strip-mall. The old village square with the 
			library, bank, and sandwich shop seems to have been mowed down to 
			make way for this thing. In fact, a sign here makes you think even 
			this strip mall isn't long for this world. Even the bank is gone, 
			replaced by an impersonal <<ATM.saidOnce ? "ATM" :
			"automated teller machine (ATM)">>.\b
			
			In the strip mall you see a number of vacant offices. "
	xdesc = "The only shop that seems to be open for business is an alabaster 
			little store labelled \"Locksmith,\" which is directly to the north.
			The way back to your house is south. "
	north = locksmiths
	in = locksmiths
	south = Fsidewalk
;

ATM: staticItem
	sdesc = "<<ATM.saidOnce? "ATM" : "automated teller machine">>"
	ldesc = 
	{
		"\^<<self.thedesc>> has a slot, a display, and a numeric 
		keypad. ";
		
		if ( not self.saidOnce )
			self.saidOnce := true;
	}
	noun = 'atm'
	adjective = 'automated' 'teller' 'machine' 'auto' 'automatic'
	location = stripMall
	PINvalue = 0
	rejectCount = 0
	contentsVisible = { return true; }
	contentsReachable = { return true; }
	state = 0						// 0 - waiting for card
								// 1 - waiting for PIN number
								// 2 - waiting for transaction
								// 3 - waiting for withdrawal amount
								// 4 - another-transaction message
								// 5 - thank-you message
	
	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) =
	{
		if ( dobj != ATMcard )
			"You can't put that into <<self.thedesc>>. ";
		else
		{
			ATMcard.moveInto( nil );
			self.state := 1;
			ATMdisplay.ldesc;
		}
	}
;

ATMslot: fixedBlock
	sdesc = "card slot"
	noun = 'slot'
	adjective = 'card'
	location = ATM
	
	verIoPutIn( actor ) = {}
	ioPutIn -> ATM
;

ATMdisplay: readable, fixedBlock
	sdesc = "display"
	ldesc = "\^<<self.thedesc>> reads: <<self.displayDesc>>"
	displayDesc = 
	{
		switch ( ATM.state )
		{
			case 0:
				"Welcome to VistaBank, a division of LotharioCorp.
				Please insert your ATM card. ";
				break;
			case 1:
				"Please type your PIN number or push CANCEL. ";
				break;
			case 2:
				"Type 1 to make a deposit, type 2 to make a withdrawal, type
				3 to check your current balance, or push CANCEL to end this
				transaction. ";
				break;
			case 3:
				"Please type the amount to withdraw, in multiples of $20. ";
				break;
			case 4:
				"Would you care to make another transaction? Type 1 for yes,
				CANCEL to end. ";
				break;
			case 5:
				"Thank you for using VistaBank! ";
				break;
		}
	}
	noun = 'display'
	adjective = 'monitor'
	location = ATM
	
	rejectCard =
	{
		"Please try again later. \b
		It spits out your card, which you take. ";
		ATMcard.moveInto( Me );
		self.rejectCount := 0;					// reset rejectCount
		ATM.state := 0;
	}
	resetDisplay = 
	{
		if ( ATM.state = 5 )
			ATM.state := 0;
	}
;

ATMkeypad: fixedBlock
	sdesc = "keypad"
	ldesc = "It has the numbers 0 through 9 and a CANCEL button. "
	noun = 'keypad' 'pad'
	location = ATM
	minsetting = 0
	maxsetting = 9999
	setting = 0
	
	verIoTypeOn( actor ) = {}
	ioTypeOn( actor, dobj ) =
	{
		if ( ATM.state = 0 || ATM.state = 5 )
			"Nothing happens. Perhaps you need to put an ATM card in first. ";
		else if ( dobj = numObj )
		{
			if ( ATM.state = 1 )
			{
				if ( numObj.value < self.minsetting || 
					numObj.value > self.maxsetting )
				{
					self.incorrectEntry;
				}
				else if ( numObj.value != self.setting )
				{
					self.incorrectEntry;
				}
				else
				{
					"The machine whirs for a few moments of mechanical
					thought. \b";
					
					ATM.state := 2;
					ATMdisplay.ldesc;
				}
			}
			else if ( ATM.state = 2 )
			{
				if ( numObj.value < 1 || numObj.value > 3 )
					self.incorrectEntry;
				else
				{
					switch( numObj.value )
					{
						case 1: 
							"The display reads: Sorry, that function
							is unavailable at this time. Please try again
							later. \b";
							ATMdisplay.displayDesc;
							break;
						case 2: 
							ATM.state := 3;
							ATMdisplay.ldesc;
							break;
						case 3:
							"The display reads: ";
							account.doCheck( actor ); "\b";
							ATMdisplay.displayDesc;
							break;
					}
				}
			}
			else if ( ATM.state = 3 )
			{
				local request, balance, newBalance;
			
				request := numObj.value;
				balance := account.F;
				
				if ( request < 0 || request > balance )
				{
					self.incorrectEntry;
				}
				else
				{
					newBalance := balance - request;
					
					if ( newBalance < 0 )
					{
						self.incorrectEntry;
					}
					else if ( newBalance < 100 )
					{
						"The display reads: You must leave a minimum balance 
						of $100 in your account. \b";
						ATMdisplay.ldesc;
					}
					else if ( self.outOfOrder )
					{
						"The machine beeps and rejects your card, which you take.\b
						The display says, \"This machine is experiencing a technical
						malfunction. Please try again later. Thank you for using
						VistaBank!\" ";
						
						cancelButton.doPush( actor );
					}
					else
					{
						local mod;
						
						mod := ( request % 20 );
						
						if ( mod != 0 )
							self.incorrectEntry;
						else
						{
							"The machine whirrs and clacks. Finally, it
							spits out $";
							say( request );
							", which you take. \b";
							
							handleMoneyTrade( playerCash, request );
							account.F -= request;
							ATM.state := 4;
							ATMdisplay.ldesc;
						}
					}
				}
			}
			else if ( ATM.state = 4 )
			{
				if ( numObj.value = 1 )
				{
					ATM.state := 2;
					ATMdisplay.ldesc;
				}
				else
				{
					self.incorrectEntry;
				}
			}
		}
		else if ( dobj = cancelButton )
		{
			cancelButton.doPush( actor );
		}
		else
		{
			"I don't know how to type <<dobj.thatdesc>> on the keypad. ";
		}
	}
	
	incorrectEntry =
	{
		if ( ATM.state = 1 )
		{
			"The display reads: Incorrect PIN number. ";
			
			if ( ATM.rejectCount = 3 )
				ATM.rejectCard;
			else
			{
				"Please try again. ";
				ATM.rejectCount++;
			}
		}
		else
		{
			"The display reads: Incorrect entry. ";
			ATMdisplay.displayDesc;
		}
	}
;

cancelButton: buttonitem, fixedBlock
	sdesc = "cancel button"
	noun = 'button'
	adjective = 'cancel'
	location = ATM

	verDoTypeOn( actor, io ) = {}
	
	verDoAttack( actor ) = { self.verDoPush( actor ); }
	doAttack( actor ) = { self.doPush( actor ); }
	
	verDoPush( actor ) =
	{
		if ( ATM.state = 0 || ATM.state = 5 )
			"Nothing happens. Perhaps you need to put an ATM card in first. ";
	}
	doPush( actor ) =
	{
		ATMcard.moveInto( Me );
		ATM.state := 5;
		ATMdisplay.ldesc;
		notify( ATMdisplay, &resetDisplay, 2 );
		
		"\bThe machine spits out your ATM card, which you take. ";
	}
;

vacantOffices: fixedBlock
	sdesc = "vacant offices"
	ldesc = "The strip mall is full of small offices that are all alike, 
			empty and unused. "
	noun = 'office'
	plural = 'offices'
	isThem = true
	adjective = 'vacant' 'empty' 'strip'
	location = stripMall
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Yeah, I've seen strip malls come in before, and just
				ruin things. They tear down something good to build them, and then
				the strip mall just stays empty for years. It's a shame.\" ";
				return( true );
			case Laura:
				"Laura says, \"Myself, I'd much rather have trees than strip malls.\" ";
				return( true );
			case Architect:
				"He says, \"Let's hope it's a long time before they start building
				strip malls around here.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

road2: fixedBlock
	sdesc = "sidewalk"
	noun = 'road' 'sidewalk'
	location = stripMall
;

dummylocksmith: block
	sdesc = "Locksmith shop"
	noun = 'store'
	adjective = 'locksmith' 'alabaster' 'little' 'shop'
	location = stripMall
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I don't remember a locksmith shop around here, 
				sorry.\" ";
				return( true );
			case Laura:
				"Laura says, \"Locksmith shop? No, I don't remember seeing one.\" ";
				return( true );
			case Architect:
				"He says, \"Why do you need a locksmith? You should always remember
				to keep a spare key where you can find it.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

freeStuffSign: fixedBlock, readable
	sdesc = "sign"
	ldesc = "The sign in the locksmith shop reads, \"Going out of business - Free stuff.\" "
	noun = 'sign'
	location = stripMall
;

locksmiths: room
	indoors = true
	sdesc = "Locksmith shop"
	ldesc = "A sign inside says, \"Going out of business - Free stuff.\" 
			Most everything has been taken already. "
	xdesc = "The only exit is south. "
	south = stripMall
	out = stripMall
;

keyGrinder: container, pluggable
	sdesc = "motorized grinder"
	ldesc = 
	{
		"The device is pretty simple:  you put a master key and a blank into 
		the grinder, turn it on, and the lathe cuts the blank into a 
		duplicate. A black, heavy-duty electrical cord with a plug at the 
		end trails out the back. <<grinderPlug.ldesc>>";
		
		pass ldesc;
	}
	location = locksmiths
	noun = 'motor' 'grinder' 'device' 'lathe'
	adjective = 'motorized' 'electric'
	bulk = 4
	myPlug = grinderPlug
	blankKeyLoaded = { return( blankKey.location = self ); }
	
	doTurnon( actor ) =
	{
		if ( length( self.contents ) = 2 )
		{
			local master, dupe;
				
			if ( self.blankKeyLoaded )
			{
				if ( self.contents[1] = blankKey )
					master := self.contents[2];
				else
					master := self.contents[1];
				
				if ( master = carKey )
					dupe := duplicateCarKey;
				else if ( master = frontDoorKey )
					dupe := duplicateKey;
				
				blankKey.moveInto( nil );
				dupe.moveInto( self );
				self.contents := [ master dupe ];
				
				"You turn on the grinder, and the lathe goes to work,
				slicing the blank key into a duplicate of <<master.thedesc>>. ";
				
				if ( master = frontDoorKey && dupe = duplicateKey )
				{
					incscore( 5 );
					global.scoreCard[25] := 1;
				}
			}
			else
			{
				master := self.contents[1];
				dupe := self.contents[2];
				
				if ( master.isCorrupt || dupe.isCorrupt || 
					( master.masterKey && master.masterKey = dupe ) ||
					( dupe.masterKey && dupe.masterKey = master ) )
				{
					"You turn on the grinder, and the lathe moves, but
					nothing happens to either of the keys. ";
				}
				else
				{
					"You turn on the grinder, and the lathe goes to work. An
					ugly noise ensues as the lathe cuts <<dupe.thedesc>> into
					a corrupted duplicate of <<master.thedesc>>. ";
					
					dupe.moveInto( nil );
					
					if ( corruptKey.location )
						dupe := secondCorruptKey;
					else
						dupe := corruptKey;
					
					dupe.masterKey := master;
					dupe.moveInto( self );
					self.contents := [ master dupe ];
					
				}
			}
			"\bIts work done, <<self.thedesc>> automatically turns 
			itself off. ";
		}
		else
		{
			"\^<<self.thedesc>> turns on and hums for a few seconds. 
			Finding nothing to do, it automatically turns itself off. ";
		}
	}
	
	verIoPutIn( actor ) =
	{
		if ( self.isActive )
			"You can't put anything into the grinder while it is 
			turned on. ";
	}
	ioPutIn( actor, dobj ) =
	{
		if ( !isclass( dobj, keyItem ) )
		{
			"%You% can't fit <<dobj.thatdesc>> in "; self.thedesc; ". ";
		}
		else if ( length( self.contents ) = 2 )
		{
			"You can't put any more keys into the grinder. ";
		}
		else
		{
			dobj.doPutIn( actor, self );
			setit( self );
			
			if ( dobj = blankKey )
				self.blankKeyLoaded := true;
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I'm sure that will come in handy somewhere. You
				gotta love motorized key grinders. I had a friend in high school
				who stole the janitor's key ring and made duplicates of the 
				master key, and we got into everything. Before they caught
				us. Hey, maybe you'd better hide that thing somewhere. You
				don't want people finding that.\" ";
				return( true );
			case Laura:
				"Laura says, \"Are people allowed to have those? Don't you need
				to be a licensed locksmith to use it? Where did you get it? Well,
				maybe you can make yourself a new spare key with it. Once you find
				the original, that is.\" ";
				return( true );
			case Architect:
				"He says, \"I don't know anything about grinding keys. I'm an
				architect, not a locksmith.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

grinderPlug: plugItem, floatingItem
	sdesc = "thick black cord"
	adjective = 'black' 'thick' 'heavy' 'duty' 'heavy-duty' 'electrical'
	pluggedIn = locksmithWallSocket
	myOwner = keyGrinder
	location = { return( myOwner.location ); }
;

locksmithWallSocket: socketItem
	location = locksmiths
	hasJuice = true
;

corruptKey: keyItem
	sdesc = "<<secondCorruptKey.location ? "first corrupted" : "corrupted">> 
			<<self.masterKey.sdesc>>"
	ldesc = "It is a sort-of car, sort-of front door key shaped piece of metal. "
	noun = 'key'
	adjective = 'corrupt' 'corrupted' 'bad' 'car' 'dupe' 'duplicate' 'metal' 'first'
	masterKey = blankKey
	isCorrupt = true
;

secondCorruptKey: keyItem
	sdesc = "second corrupted <<self.masterKey.sdesc>>"
	ldesc = "It is another sort-of car, sort-of front door key shaped piece of metal. "
	noun = 'key'
	adjective = 'corrupt' 'corrupted' 'bad' 'car' 'dupe' 'duplicate' 'metal' 
			'other' 'another' 'second' 
	masterKey = blankKey
	isCorrupt = true
;

blankKey: keyItem
	sdesc = "blank"
	ldesc = "It is a sort-of key shaped piece of shiny silver metal. "
	location = keyGrinder
	noun = 'blank' 
	adjective = 'shiny' 'silver' 'metal'
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Whoa, a blank key. Grind away!\" ";
				return( true );
			case Laura:
				"Laura says, \"If only you had your missing key, you could make 
				a duplicate.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
	verIoOpenWith( actor ) = { self.verIoUnlockWith( actor ); }
	verIoUnlockWith( actor ) = 
	{
		"You can't unlock anything with the blank until you make it
		into a duplicate of a real key. ";
	}
;

duplicateCarKey: keyItem, hiddenItem
	isCarKey = true
	sdesc = "duplicate car key"
	ldesc = 
	{
		if ( self.isfixed )
			"You can't see <<self.thedesc>> right now, because it's
			under <<self.underLoc.thedesc>>. ";
		else
			"This is a shiny new duplicate of <<carKey.thedesc>>. ";
	}
	noun = 'key'
	adjective = 'car' 'duplicate' 'dupe' 'shiny' 'new'
	underLoc = nil
	bulk = 0
	masterKey = carKey
	
	ioStartWith( actor, io ) = 
	{
		if ( io = littleCar || io = ignition )
			io.doStartWith( actor, self );
		else
			"I don't know how to start that with <<self.thedesc>>. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				if ( littleCar.hasOpened ) 
					"Fred says, \"Car key, eh? I wish I could afford a car.\" ";
				else 
					"Fred says, \"Spare key, eh? Good for you.\" ";
				return( true );
			case Laura:
				if ( littleCar.hasOpened ) 
					"Laura says, \"I guess it's good to keep a spare car 
					key around also.\" ";
				else 
					"Laura says, \"One moment, please,\" and answers the phone. 
					After a short conversation, she says to you, \"Is that a 
					spare key? I guess you don't need me to help you think of
					places to look for one, then!\" ";
				return( true );
			default:
				return( nil );
		}
	}
;

FLaura: NPC
	sdesc = "Laura"
	isHer = true
	noun = 'woman'
	adjective = 'future' 'laura'
	
	meetLaura = 
	{
		setit( FLaura, 2 );
		FLaura.met := true;
		FLaura.isSeen := true;
	
		if ( Laura.isSeen )
		{
			"The woman is the biggest surprise. Twenty years older, but 
			still trim and lovely, you recognize her immediately as 
			Laura, the new accounts clerk at the bank. She recognizes
			you, too, as it happens, but not for the same reason. \b";
		}
		else
		{
			"The woman with them seems to be in charge, which you can
			tell from body language cues among the three. In her early
			forties, she is trim and attractive, but her face is a sharp
			mask of bitterness, with frown lines creasing across its
			rouged surface like Martian canals. Her arms folded in a 
			power stance, she attacks you with a certain amount of 
			undiluted invective. \b";
		}
		
		"\"I was going to ask you who you are and what you're doing here,
		but I see that I don't need to. I recognize you quite well from my
		files. ";
		
		if ( lotharioCorp.isOwned )
			"You're even a Lothario Corp stockholder, if negligibly. ";
		
		"And yet, still we have a mystery on our hands, hmm? My question is, 
		why haven't you aged a day in the last twenty years?\"\b
		
		She approaches you and puts her hand to your face. You feel her
		manicured nails at the ends of her cold, steely fingers. She moves
		your head gently from side to side, assessing your features. \b";
		
		if ( dibbleBitsStock.isOwned )
		{
			self.meetLaura2;
			return;
		}
		
		"\"The long-lost owner of the house, reported missing ten years 
		ago, arrives unannounced, out of the blue, on the eve of final
		foreclosure. Coincidence?\" She aims the question to Carl and
		Victor, who ";
		
		if ( rescue.rescuer = 1 )
			"have already reverted from looks of friendly concern
			to goon-like stone faces. ";
		else
			"wear impenetrable, goon-like stone faces. ";
		
		"\"Tomorrow we raze the property, and here you are, ";
		
		if ( rescue.rescuer = 1 )
			"somewhat ridiculously trying to break in. ";
		else if ( FsecretDoor.location ) {
			if ( FsecretDoor.isopen ) 
				"sneaking in and out through a secret entrance. ";
			else "sneaking around, obviously looking for a way in.\" She
				pauses and throws a suspicious glance at the wall, then
				turns back to you. \"";
		}
		else "obviously snooping around. ";
		
		"Here's my question. What's inside that's 
		so important? What did you need to rescue before we hauled 
		it all away to scrap heaps and the city dump?\" \b
		
		She paces from left to right and back again, still taking in 
		your features. \b
		
		\"I'll be back later, and you had better not be here. Carl, Victor? 
		Get the car. Let's go.\" \b
		
		With that, the three of them turn the backs of their tailored
		jackets to you and walk away. You hear three car doors open and
		slam shut, and see a dark sedan drive away through the drizzling
		rain. ";
		
		self.daemonCount := 2;
		
		if ( not FFred.actorDaemonStopped )
		{
			FFred.daemonCount2 := 2;
			FFred.moveInto( FnorthOfHouse );
			notify( FFred, &actorDaemon2, 0 );
		
			morePrompt();
			
			"\bMoments later, you hear the garage door open and shut. ";
		}
	}
	
	meetLaura2 =
	{
		"\"You must know by now that Lothario Corp has big plans for this
		whole area of town. It's been chosen as the site for our new 
		regional headquarters. We're concluding negotations to buy every
		acre of property in the vicinity, except for this one. You're 
		apparently as reclusive as you are wealthy, but I had a feeling
		you'd turn up.\" \b
		
		She paces from left to right and back again, still taking in 
		your features. \b";
		
		"\"The long-lost owner of the house arrives like a thief in the night, 
		immediately after our takeover of a certain high tech company goes 
		bust due to its resurgent stock value. A company in which you own 
		a considerable stake, if I'm not mistaken. Coincidence?\" She aims 
		the question to Carl and Victor, who ";
		
		if ( rescue.rescuer = 1 )
			"have already reverted from looks of friendly concern
			to goon-like stone faces. ";
		else
			"wear impenetrable, goon-like stone faces. ";
		
		"\"The next time I show up, it'll be with two IRS agents, a writ 
		of foreclosure, and a bulldozer. Carl, Victor. Let's go.\" \b
		
		With that, the three of them turn the backs of their tailored
		jackets to you and walk away. You hear three car doors open and
		slam shut, and see a dark sedan drive away through the drizzling
		rain. ";
		
		self.daemonCount := 3;
		
		if ( not FFred.actorDaemonStopped )
		{
			FFred.daemonCount2 := 3;
			FFred.moveInto( FnorthOfHouse );
			notify( FFred, &actorDaemon2, 0 );
		
			morePrompt();
			
			"\bMoments later, you hear the garage door open and shut. ";
		}
	}
	
	askingAboutMe( who ) =
	{
		return( askingAboutLaura.askingAboutMe( who ) );
	}
	
	daemonCount = 0
	actorDaemon = 
	{
		if ( Me.location = locksmiths || Me.location = Fclearing || 
			Me.location = stripMall )
			return;
		
		if ( not self.waitingForPlayer )
			self.daemonCount++;
		
		if ( Me.location = FnorthOfHouse || Me.location = Fdriveway || 
			Me.location = FsouthOfHouse )
		{
			if ( self.waitingForPlayer ) {
				"\bYou are the focus of the surprised attention of three
				people in dark suits, a woman and two rather large men. 
				She walks directly toward you, leaving the men to take up
				imposing stances by the dark sedan parked in your driveway. \b";
			}
			else if ( self.daemonCount = 1 ) 
			{
				"\bA dark sedan pulls into the driveway, carrying a driver
				and two passengers. You are the focus of their surprised
				attention as they climb out of the car and approach you. \b";
			}
			else if ( self.daemonCount = 2 )
			{
				"\bYou hear the car engine turn off and three doors open.
				Three people in dark suits climb out, two men and one 
				woman. You hear her address them as Carl and Victor.
				They nod solemnly and take up imposing stances by the
				car. \b";
				
			}
/*			else { 
				"\bRain drizzles in the muddy tracks left by the sedan.\n"; 
			}
*/			
			self.meetLaura;
			unnotify( self, &actorDaemon );
			restoreListenDesc;
			return;
		}
		
		switch( self.daemonCount )
		{
			case 1: 
				if ( Me.location = Fsidewalk )
					"\bA dark sedan pulls past you, heading for your
					house. You see it pull into your driveway. ";
				else 
					"\bYou hear a car pull into your driveway<<Me.location.indoors ?
					" outside." : ".">> ";
				
				newListenDesc( Me.location, 'You hear the steady purr of an 
					expensive car engine idling in the driveway. ' );
				break;
			
			case 2:
				if ( not self.waitingForPlayer ) {
					self.waitingForPlayer := true;
					"\bYou hear the car engine turn off and three doors open
					and shut, and a female voice issuing orders that you can't
					quite hear clearly. ";
					newListenDesc( Me.location, 'You hear three people talking 
						in the driveway. ');
				}
				break;
		}
	}
;

darkSedan: fixedBlock, floatingItem
	sdesc = "dark sedan"
	ldesc =
	{
		if ( Me.location = FupstairsBathroom || Me.location = FupstairsBedroomN ||
			Me.location = FupstairsBedroomS || Me.location = Fkitchen )
		{
			"You'll have to go outside to get a close look at it. ";
		}
		else if ( Me.location = FinGarage )
		{
			if ( FgarageDoor2.isopen )
				"You'll have to go outside to get a look at it. ";
			else
				"You can't see <<self.thedesc>> with the front door closed. ";
		}
		else if ( Me.location = Ffoyer )
		{
			if ( FfrontDoorInside.isopen )
				"You'll have to go outside to get a look at it. ";
			else
				"You can't see <<self.thedesc>> with the front door closed. ";
		}
		else if ( Me.location.indoors )
		{
			"You'll have to go outside to get a look at it. ";
		}
		else 
		{
			"It's sitting in the driveway. You'll have to walk to the driveway 
			to get a close look at it. ";
		}
	}
	noun = 'sedan'
	adjective = 'dark' 'car'
	location = 
	{
		if ( FLaura.daemonCount = 1 || FLaura.daemonCount = 2 )
		{
			if ( Me.location = FupstairsBathroom || Me.location = FupstairsBedroomN ||
				Me.location = FupstairsBedroomS || Me.location = Fkitchen ||
				Me.location = Ffoyer || Me.location = FfrontOfHouse || 
				Me.location = FinGarage )
				return( Me.location );
		}
		else return( nil );
	}
;

muddyCarTracks: unimportantItem, floatingItem
	sdesc = "muddy tracks"
	noun = 'track'
	plural = 'tracks'
	isThem = true
	adjective = 'muddy' 'mud'
	location = 
	{
		if ( FLaura.met ) {
			if ( Me.location = Fdriveway || Me.location = FsouthOfHouse ||
				Me.location = FfrontOfHouse || Me.location = FnorthOfHouse ||
				Me.location = Fsidewalk ) 
				return( Me.location );
		}
		else return( nil );
	}
;

FsecretPassage: room
	indoors = true
	sdesc = "Secret passage"
	ldesc = 
	{
		"The secret passage is a narrow hallway of sorts, only about twelve feet
		long and three and a half feet wide. The walls are bare plaster and 
		sheet rock. Various springs and tumblers are connected together in an 
		elegant set of mechanisms to open the doors. ";
		
		self.lightDesc;
	}
	xdesc = "The short hallway dead-ends at a crudely-carved staircase leading 
			down. There is another door to the west, and you can go out the 
			way you came in. "
	lightDesc =
	{
		if ( FsecretPassageLightBulb.burnedOut )
		{
			"A small light bulb hangs from the ceiling, but it was left on
			and burned out long ago. ";
		
			if ( FinteriorSecretPassageDoor.isopen )
				"The only light in the passage is from the open door. ";
			else
				"There is barely enough light seeping in through the 
				closed door to see by. ";
		}
		else if ( !FsecretPassageLightBulb.islit )
		{
			"A small light bulb hangs from the ceiling, but it is currently 
			turned off. ";
			
			if ( FinteriorSecretPassageDoor.isopen )
				"The only light in the passage is from the open door. ";
			else
				"There is barely enough light seeping in through the 
				closed door to see by. ";
		}
		else
		{
			"A small light bulb hangs from the ceiling, giving the room 
			some gentle illumnation. ";
		}
	}
	
	north = FsecretChamber
	down = FsecretChamber
	out = FinteriorSecretPassageDoor
	south = FinteriorSecretPassageDoor
	west = FwestSecretPassageDoor
	
	enterRoom( actor ) = 
	{
		FsecretPassageLightBulb.isActive := secretPassageLightBulb.isActive;
		FsecretPassageLightBulb.burnedOut := secretPassageLightBulb.islit;
		pass enterRoom;
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sweet. You could hide stuff there and no one
				would ever find it.\" ";
				return( true );
			case Laura:
				"Laura says, \"Cool. But does it lead anywhere? Maybe it's 
				just a good place to keep stuff.\" ";
				return( true );
			case Architect:
				"He says, \"There's not much room in the floor plan to have
				this connect throughout the house, but it will be a way in,
				and it will be a good storage area that no one else will 
				ever know about.\" He winks at you. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

FsecretPassageLightBulb: lightsource, switchItem
	sdesc = "light bulb"
	noun = 'fixture'
	adjective = 'light' 'bulb'
	location = FsecretPassage
	
	burnedOut = nil
	verDoTurnon( actor ) = 
	{
		if ( self.burnedOut ) 
		{
			if ( self.isActive )
				"The light bulb is already turned on, but it burned 
				out long ago. ";
			"You turn on the light bulb, but nothing happens. It
			burned out long ago. ";
		}
		else pass doTurnon;
	}
	verDoTurnoff( actor ) = 
	{
		if ( self.burnedOut ) 
		{
			if ( !self.isActive )
				"The light bulb is already turned off. ";
			"You turn off the light bulb. ";
		}
		else pass doTurnoff;
	}
;

/*
FsecretPassageWallSocket: socketItem
	adjective = 'electricity' 'wiring' 'electric' 'electrical'
	hasJuice = true
	location = FsecretPassage
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				if ( blueprint.secretpassage )
					"He says, \"When the house is finished, the secret 
					passage will be all wired up.\" ";
				else
					"He says, \"Everything should be fine with the 
					house's electricity. ";
				return( true );
			default: 
				return( nil );
		}
	}
;
*/

FinteriorSecretPassageDoor: doorway
	sdesc = "main door"
	noun = 'door'
	adjective = 'south' 'main'
	location = FsecretPassage
	otherside = FsecretDoor
	doordest = FsouthOfHouse
;

FwestSecretPassageDoor: doorway
	sdesc = "west door"
	noun = 'door'
	adjective = 'west' 'w'
	location = FsecretPassage
	otherside = FmasterBedroomSecretDoor
	doordest = FmasterBedroom
;

FspringsAndTumblers: unimportantItem
	sdesc = "springs and tumblers"
	ldesc = "Various springs and tumblers are connected together in an elegant set 
			of mechanisms to open the doors. "
	noun = 'spring' 'tumbler'
	plural = 'springs' 'tumblers'
	isThem = true
	adjective = 'elegant' 'set' 'mechanism' 'mechanisms' 'various'
	location = FsecretPassage
;

FcrudelyCarvedStaircase: fixedBlock
	sdesc = "crudely carved staircase"
	ldesc = "The staircase doesn't seem to have been part of the architect's
			imaginings. You saw this spot when the house was being 
			constructed, and all that was here was a concrete foundation.
			An opening has been carved into the foundation, and a sloping
			tunnel has been constructed, with crude stair steps hewn out
			of the natural limestone. It is entirely unclear to you when
			this excavation took place, making its existence quite 
			mysterious. "
	noun = 'staircase'
	adjective = 'crudely' 'carved' 'concrete' 'cement' 'foundation' 'opening'
			'sloping' 'tunnel' 'crude' 'stair' 'stairs' 'step' 'steps' 
	location = FsecretPassage
	
	verDoClimb( actor ) = {}
	doClimb( actor ) = { self.doClimbDown( actor ); }
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) = 
	{
		Me.travelTo( FsecretChamber );
		return( true );
	}
;

FnaturalLimestone: unimportantItem
	sdesc = "natural limestone"
	ldesc = "The natural limestone is what makes up most of the earth in 
			this area. "
	noun = 'limestone'
	adjective = 'natural'
	location = FsecretPassage
;

FsecretChamber: room
	indoors = true
	sdesc = "Secret chamber"
	ldesc = "Whether this nondescript room existed before the secret passage
			was made is unclear to you, but here it is now. It is made of
			concrete, about thirty feet square, with a fifteen foot ceiling. 
			The floor of room must be at least twenty feet below the ground. 
			The dim amber light, just enough to see by, seems to be coming
			from the ceiling itself, rather than any kind of recognizable
			fixture. "
	xdesc = {
		if ( future.state < 3 ) 
			"The only exit has been blocked off with charred debris from
			the burned house above. ";
		else 
			"The only exit that you can see is back up. ";
	}
	lightDesc = "The dim amber light, just enough to see by, seems to be coming
			from the ceiling itself, rather than any kind of recognizable
			fixture. Perhaps it is a subtle technology, one you have never 
			seen before. "
	up = 
	{
		if ( future.state < 3 ) {
			"You can't get past the blockage. ";
			return( nil );
		}
		else return( FsecretPassage );
	}
	south = { return( self.up ); }
	
	enterRoom( actor ) =
	{
		if ( !self.isseen && !secretChamber.isseen && Me.location != platform2 )
		{
			"You descend the stairs slowly, unsure of what you might
			find. The stairs go down deeper under the ground than you
			expected. It becomes dark and hard to see your footing, but
			as you keep going, your eyes once again find a dim source
			of light, which you follow. Finally, you reach the bottom,
			and find yourself in a ... \b";
		}
		pass enterRoom;
	}
;

FchamberCeiling: fixedBlock
	sdesc = "ceiling"
	ldesc = "The dim amber light, just enough to see by, seems to be coming
			from the ceiling itself, rather than any kind of recognizable
			fixture. Perhaps it is a subtle technology, one you have never 
			seen before. "
	noun = 'ceiling'
	location = FsecretChamber
;

charredDebrisBlockage: fixedBlock
	sdesc = "blockage"
	ldesc = "The charred debris from the fire damaged house has collapsed,
		filling the stairwell and leaving no exit from this chamber. "
	noun = 'blockage'
	adjective = 'charred' 'timber' 'timbers' 'wreckage' 'debris' 'ash' 'ashes' 'charcoal'
	verDoEnter( actor ) = { "You can't get past the debris. "; }
	verDoAttack( actor ) = { "All you manage to do is stir up ashes. "; }
	verDoAttackWith( actor ) = { 
		"All you manage to do is break off a few flakes of charcoal stir up ashes. "; 
	}
	verDoKick( actor ) = {
		"The debris is made of charred timbers, and is quite solid. ";
	}
;


/* eof */
