/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

/*
 * The Val System
 *
 * PLANETS:
 *
 * Tode:	Homeworld featured in Unnkulian Unventures
 * Tel:
 * Hop:		Home to Hoppians: tall, well-dressed rabbit-like creatures
 * Foon:	Farming planet (home to Elwood Farm and Cassandra)
 * Kuwl:	Duhdhist planet
 * Irata:	Newly colonized, mainly agricultural and mining
 * Frost:	Iceberg
 *
 * COLORSPACES:
 *
 * Burnt Sienna:	Contains frost, where Gavin Kelly's dorm pod is
 *			located.
 * Cornflower:		Contains Foon, Val's main farming planet.
 * Spring Green:	Contains Irata.
 */

/*
 * Our hero's bachelor pod.
 *
 * Gavin starts the game out here, with lots of neat objects and decorations
 * to keep him busy.  In these adornments we hint at many later developments
 * and explain a bit about what's going on with the Unnkulian menace these
 * days.
 */
startroom: Room
	noun = 'pod'
	adjective = 'bachelor'

	firstime = true

	walls = nil
	isdetermined = true

	tdesc = "\^<<self.sdesc>>"
	sdesc = "your bachelor pod"

	ldesc = {
		I(); "Ahhhhh.  Pod sweet pod!  Sure feels good to be back
		in the ol' closet-sized capsule again, yes sir.  While
		slaving away on your master's thesis you've spent
		many late hours here, sustaining yourself on naught
		but Akmi Snak Chipz "; note(self); " and ReVoLT Kola."; P();
		
		I(); "Yep, it's basically a hell-hole, but it's served
		you adequately.  Looking around you can see blurry 
		reflections of yourself and your surroundings in the
		familiar mauve and orange metal walls, which are rounded in
		the corners as is typical of today's \"economical\" 
		graduate housing. (As if they offered any other kind.)  
		The walls are still bare; you'd think after living 
		here for two years you'd have put some posters up.  But
		there's never much time for aesthetics at Akmi
		Yooniversity."; P();

		I(); "Your bed (if you can call it that) and the matter
		mover take up all the available floor space in your pod.
		Miscellaneous Stik-Em Nowtz cling to various parts of
		the furniture and walls, and papers fill any stray gaps,
		making this den an incredible fire trap.  Good thing you
		don't really have heating here.  Anyway, if there's
		a fire you can always bail out through the escape
		hatch.  Oops -- you've never been able to get it
		open.  Never mind."; P();
		
		I(); BPyooniversity.ldesc;
		
		if (self.firstime) {
			self.firstime := nil;

			P();
			I(); "On your desk is your EV, and next to that sits
			the computer you use nearly 37
			hours a day.  Or at least you *assume* it's there;
			you can't really see it.  It's buried under the pile
			of books that just crashed down in front of you as you
			hit your head on the shelf above upon reading more of
			the awful truth about the Unnkulians.
			Still rubbing the bruise on your topknot, you pick up
			all the books and put them back in order."; 
		}
		else {
			P();
			I(); "On your desk, under your
			shelf of textbooks, is the computer you use nearly
			37 hours a day.  Cuddled up right next to it like
			a best friend is your EV.";
		}
		
		P(); I(); BPEV.watchdesc;
	}

	footnote = {
		"All Akmi products and their characteristic spellings
		are trademarks of Akmi Galaktikorp.  Akmi -- proud
		sponsors of the pan-galactic Cheez Games!";	
	}

	in = { BPmover.doEnter(Me); return nil; }
	
	verGoJump(actor) = {}
	goJump(actor) = { "You jump in place.  Hurrah."; return nil; }

	noexit = {
		"Don't be silly!  You know they did away with doors
		and windows in graduate housing decades ago, and you've
		never managed to get that escape hatch unsealed.
		But it's not like we don't have matter movers!";
		
		return nil; 	
	}
;

autodialer: Item
	weight = 0
	bulk = 0
	sdesc = "matter mover autodialer"
	ldesc = {
		I(); "The autodialer keeps track of coordinates for
		matter movers you frequent, thereby eliminating
		the tedium of setting the dials by hand.  It has a
		small display and a keypad with keys numbered 1
		through 25."; P();

		I(); "To use the autodialer, just type the
		number corresponding to the coordinates you
		wish to dial "; note(self); "."; P();

		I(); self.listselections;
	}
	noun = 'dialer' 'autodialer'
	adjective = 'auto' 'mattermover' 'matter' 'mover'

	location = Me
	
	selections = [
		startroom	6000 3270 1736
		adapod		6000 3270 1738
	]

	addselection(mover) = {
		local	loc, r, g, b;

		loc := mover.location;

		if (find(self.selections, loc) <> nil)
			return;

		self.selections += [loc mover.ar mover.ag mover.ab];
	}
	listselections = {
		local i, e;

		"The autodialer contains the following entries:\b";
		
		for (e := 1, i := 1; i <= length(self.selections); i += 4) {
			say(e++); ": "; self.selections[i].tdesc; "\n";
		}
	}
	select(entry) = {
		local i, m;

		m := (entry - 1) * 4 + 1;
		if (m > length(self.selections)) {
			"The autodialer says, \"No such selection.\"";
			return;
		}

		//
		// Find the matter mover in the autodialer's
		// location, if there is one.
		//
		for (i := 1; i <= length(global.moverlist); i++)
			if (self.isin(global.moverlist[i].location))
				break;

		if (i > length(global.moverlist)) {
			"The autodialer says, \"No mover nearby.\"";
			return;
		}

		global.moverlist[i].r.setting := self.selections[m + 1];
		global.moverlist[i].g.setting := self.selections[m + 2];
		global.moverlist[i].b.setting := self.selections[m + 3];

		"The autodialer says, \"Mover dials set.\"";
	}

	footnote = {
		"For example: \"type 16 on autodialer keypad.\"";
	}

	verIoTypeon(actor) = { }
	ioTypeon(actor, dobj) = { autodialerkeypad.ioTypeon(actor, dobj); }
;
autodialerkeypad: Part
	partof = autodialer

	sdesc = "autodialer keypad"
	ldesc = {
		"The keypad has keys numbered 1 through 25.";
	}
	noun = 'keypad' 'keys' 'reset' 'pad' 'key'
	adjective = 'dialer' 'autodialer' 'auto' 'mattermover' 'matter' 'mover'
	
	verIoTypeon(actor) = { }
	ioTypeon(actor, dobj) = {
		if (dobj <> numObj) {
			"You can only type numbers on the autodialer keypad.
			(Don't put numbers in quotes.)";
		}
		else {
			if (numObj.value > 25 or numObj.value < 1)
				"There's no such key on the autodialer!";
			else
				autodialer.select(numObj.value);
		}
	}
;

uudisk: Item, Readable
	stored = []
	sdesc = "your thesis research floppy disk"
	isdetermined = true
	ldesc = {
		I(); "It's a standard 5 centimeter square optical disk with
		your thesis research materials on it. There is a label
		on one side with your writing on it. ";

		self.readdesc;

		P(); I(); 

#ifndef	DEMO
		if (TVgameroom.isseen) {
			"You suspect the games might run on the
			old Zippikraft Kompact Komputer in ";

			if (Me.isin(TVgameroom))
				"here.";
			else
				"the Terminal Velocity game room.";
		}
		else
#endif
			"Unfortunately, the games were designed to be 
			run on an old Zippikraft machine that's pretty
			hard to find these days.";
	}
	readdesc = {
		"The label reads,
		\"Unnkulian Unventures I, II, and III (unfinished).\"";
	}
	noun = 'disk' 'disc' 'label' 'writing' 'diskette' 'disquette'
	adjective = 'thesis' 'research' 'unnkulian' 'unventure' 'unventures'
			'uu' 'floppy' 'optical' 'square'	

	location = Me
;
galacticard: Item, Readable
	sdesc = "Galacticard"
	ldesc = {
		"Everyone has a Galacticard; it's essential for everything
		from checking out library books to buying a new house. ";
		IDstamp.ldesc;
	}
	readdesc = { "It says, \"Gavin Kelly.\""; }
	
	noun = 'galacticard' 'card'
	adjective = 'id' 'intergalactic' 'credit' 'charge' 'magic' 'plastic'
			'library' 'data' 'galactic'
	location = Me
;
IDstamp: Part
	sdesc = "holographic stamp"
	ldesc = {
		"The shiny holographic stamp on the card not only 
		prevents counterfeiting, but stores a few megabytes 
		of data about you as well "; note(self); ".";
	}
	partof = galacticard
	noun = 'stamp'
	adjective = 'holo' 'holographic' 'galacticard' 'card' 'id'
			'intergalactic' 'credit' 'charge' 'magic' 'plastic'
			'library' 'data' 'galactic'
	
	footnote = {
		"There was a great public outcry when the cards were 
		introduced as part of the new Republic 94 years ago. 
		Many claimed that the cards were an invasion of 
		privacy and refused to use them; it wasn't until Akmi 
		made it official policy to accept only Galacticards 
		for all their goods and services that they became 
		truly ubiquitous and universal.  Ha! -- Imagine how 
		inconvenient everything would be without one!";
	}
;

class BPdecoration: Decoration location = startroom;

BPpod: BPdecoration
	sdesc = { startroom.sdesc; }
	ldesc = { startroom.ldesc; }
	thedesc = { startroom.thedesc; }
	noun =	'pod' 'pad' 'room' 'cubicle' 'closet' 'hole' 'hell-hole'
	adjective = 'bachelor' 'dorm' 'hell' 'economical' 'cheap'
;
BPjunkfood: BPdecoration
	sdesc = "junk food"
	ldesc = {
		"They're just normal junk food containers, more gross
		than interesting, frankly.";
	}
	noun = 'food' 'chips' 'chipz' 'containers'
	adjective = 'akmi' 'acme' 'snak' 'snack' 'junk' 'food'
;
revolt: Item, Container, pourable
	iswet = nil
	empty = nil
	liquiddesc = {
		if (not self.empty)
			"ReVoLT Kola";
		else if (self.iswet)
			"water";
	}
	sdesc = {
		if (self.empty) {
			if (not self.iswet)
				"empty ";
		}
		else
			"full ";

		"ReVoLT Kola can";

		if (self.iswet)
			" full of water";
	}
	adesc = {
		if (self.empty and not self.iswet)
			"an ";
		else
			"a ";

		self.sdesc;
	}
	ldesc = {
		I(); "The ReVoLT Kola can has the usual gaudy tomato red 
		and intergalactic orange design and the standard 
		snappy slogan: \"Make every cell in your body RIOT... 
		with ReVoLT!\" The makers of this beverage claim that 
		it is the most powerful stimulant available without a 
		prescription. You've probably taken years off your 
		life with this toxic elixir."; P();

		I(); self.showcontents;
	}
	noun = 'cola' 'kola' 'can' 'beverage' 'drink' 'liquid' 'pop' 'soda'
	adjective = 'revolt' 'soda' 'cola' 'kola' 'beverage' 'drink'
	            'pop' 'soda'

	location = startroom
	bulk = 2
	weight = 1

	//
	// Prevent "buy drink" at the TV Bar from matching the Kola.
	//
	verDoBuy(actor) = { "You've already paid for it."; }

	verDoOpen(actor) = {}
	doOpen(actor) = "It's already open."
	verDoClose(actor) = {}
	doClose(actor) = "You can't close it."

	verDoPouron(actor, io) = {
		if (self.empty and not self.iswet)
			"The can is empty.";
	}
	verDoLookin(actor) = {}
	doLookin(actor) = { self.showcontents; }

	ioPutin(actor, dobj) = {
#ifndef	DEMO
		if (dobj = flower)
			inherited.ioPutin(actor, dobj);
		else if (dobj = elroad3puddle)
			elroad3puddle.doPutin(actor, self);
		else
#endif
			"Now why would you want to do that?";
	}
	verDoDrink(actor) = {
		if (self.empty and not self.iswet)
			"The can's already empty.";
	}
	doDrink(actor) = {
		if (not self.empty) {
			I(); "You gulp down the carbonated Kola and are 
			instantly slammed with a massive sugar high.  
			Your eyes practically leap out of their 
			sockets as the full effect of the stimulant 
			sets in."; P();

			I(); "You feel quick!";

			Me.stimulant := true;
			self.empty := true;

			notify(self, &slowdown, 5);

			self.wasingame := global.ingame;
		}
		else if (self.iswet) {
			"You drink a bit of the water in the can.
			It's surprisingly refreshing.";
		}
	}

	slowdown = {
		if (not global.ingame or self.wasingame) {
			P(); I();
			"The effect of the ReVoLT Kola suddenly wears off,
			and you nearly pass out as your body's blood-sugar
			level plummets back down to normal.";
		}

		Me.stimulant := nil;
	}

	showcontents = {
		local	tot;
		
		if (self.contents <> []) {
			tot := listcontents(self, Me, 3, nil, nil, nil, nil, true, true, nil);

			if (not self.empty) {
 				" The can ";
				
				if (tot > 0)
					"also ";

				"contains some carbonated beverage.";
			}
			else if (self.iswet) {
 				" The can ";
				
				if (tot > 0)
					"also ";

				"contains some water.";
			}
		}
		else {
			if (not self.empty)
				"The can seems to contain some carbonated
				beverage.";
			else if (self.iswet)
				"The can seems to contain some water.";
			else
				"The can is empty.";
		}
	}
;
BPwalls: BPdecoration
	isplural = true
	sdesc = "pod walls"
	ldesc = "The hideous colors are standard issue -- you'll never
		understand Akmi.  The walls are shaped the way they
		are so the pod will be somewhat aerodynamic if they have to
		jettison it.  Fire drills are always fun around here."
	noun = 'wall' 'walls' 'side' 'sides' 'corners'
	adjective = 'pod' 'metal' 'orange' 'mauve'
;
BPyooniversity: BPdecoration
	sdesc = "Akmi Yooniversity"
	isdetermined = true
	ldesc = "Your pod is one of the
		\"Yooniversity Economical Graduate Off-site Dwelling
		Stations\" (YEGODS).
		Though the school is actually hundreds of
		light-years away, matter mover technology makes it possible
		for them to put housing in the cheapest, remotest, most
		inhospitable parts of the galaxy -- places like Frost,
		the iceball of a planet your pod is situated on."
	noun = 'university' 'yooniversity' 'yuniversity' 'school'
	adjective = 'akmi' 'acme' 'my'
;

BPbed: Bed
	sdesc = "your bed"
	isdetermined = true
	ldesc = "It looks more like a counter top than a bed, though with
		enough blankets to cushion (about 15 layers) it's bearable.
		It's supposed to be able to fold up into the wall
		but you've never been able to get it to work reliably.
		Unless you lock it in the down position it tends to close
		up in the middle of the night, with you in it, which would
		be all right except that you can't afford to miss too many
		classes."
	noun = 'bed' 'pallet' 'mattress' 'blankets' 'sheets' 'covers'
	adjective = 'folding' 'pod' 'my'
	location = startroom

	reachsurroundings = true

	verDoOpen(actor) = { self.verDoUnlock(actor); }
	verDoClose(actor) = { "Don't!  You could be killed."; }
	verDoUnlock(actor) = { "I wouldn't risk it, if I were you."; }
	verDoLock(actor) = { "Thankfully it's already locked."; }
	verDoRoll(actor) = {
		"You can't seem to get the bed to fold up into the wall.";
	}
;
BPbedlock: Part
	partof = BPbed
	sdesc = "lock"
	noun = 'lock'
	adjective = 'ada\'s' 'bed'
;
BPEV: BPdecoration, ev
	setting = 1000
	location = BPdesk
	locationtype = 'on'
;
BPmover: BPdecoration, mattermover
	address = {
		"Your pod's address is written on the machine:"; P();
		I(); "\"6000, 3270, 1736 -- colorspace Burnt Sienna\"";
	}

	/*
	 * This mover's coordinates
	 */
	ar = 6000
	ag = 3270
	ab = 1736
	
	/*
	 * This mover's dials
 	 */
	r = BPred
	g = BPgreen
	b = BPblue

	colorspace = 'Burnt Sienna'
	system = 'Val'
	planet = 'Frost'
;

BPgreen: BPdecoration, greendial 	setting = 3270;
BPblue: BPdecoration, bluedial		setting = 1738;
BPred: BPdecoration, reddial 		setting = 6000;

BPnotes: Readable
	sdesc = "Stik-Em Nowtz"
	isplural = true
	readdesc = { self.ldesc; }
	ldesc = {
		I(); "The hundred or so Stik-Em Nowtz littering your pod
		are largely incomprehensible; most of them are scribbled
		diagrams and notes you've made to yourself during your
		two year stay here.  Among the long-forgotten reminders
		you find the address of Terminal Velocity, the favorite
		hang-out for the galaxy's best computer jocks.
		It says, \"Hot Pink (+0, -52, -5) <<note(self)>>,\" but a
		fat lot	of good that's going to do you."; P();

		I(); "You chuckle as you recall your last visit there 
		three years ago -- they weren't particularly 
		interested in yet another 3-dimensional chess 
		program, especially one that couldn't beat their own 
		weekend implementations.  Trying to find software 
		that'll impress them enough to let you in is nearly 
		impossible, which is why it's the most exclusive club 
		around.  It's also probably the best source of 
		computer information in the galaxy...";
	}
	noun = 'notes' 'nowtz' 'note'
	adjective = 'stik-em' 'stick-em' 'stikem' 'post-it' 'postit' 'akmi' 
	location = startroom

	footnote = {
		"Matter mover coordinates are often given relative
		to colorspace basis coordinates.  E.g., \"Hot Pink
		(+0, -52, -5)\" means to take the base coordinates
		for Hot Pink and add zero to red, subtract 52 from
		green, and subtract 5 from blue.";
	}
;

BPpapers: Readable
	isplural = true
	sdesc = "papers"
	ldesc = { self.readdesc; }
	readdesc = {
		"Some of these sheets of paper have been here since
		you moved in, but you've held on to all of them
		JUST IN CASE you might need some important bit
		of information scribbled on one.  Leafing through
		a few piles, you don't find anything of great interest.";

		setit(self);
	}
	noun = 'papers' 'paper' 'pile' 'piles' 'avalanche'
	adjective = 'pod' 'my' 'discarded' 'miscellaneous'
	location = startroom

	verDoTake(actor) = {
		"There are far too many to carry, and besides that
		you don't see anything of any value among the
		reams.";
	}
;

BPfurniture: BPdecoration
	isdetermined = true
	sdesc = "your pod furniture"
	ldesc = "Your pod is pretty spartan; you've got a desk, a chair,
		and a bed.  That's it."
	noun = 'furniture' 'furnishings'
	adjective = 'pod' 'my'
;

BPdesk: Openable, Qcontainer, Desk
	sdesc = "your desk"
	isdetermined = true
	ldesc = {
		I(); "Your desk is piled with papers and junk food
		containers. What would your mother say?"; P();
			
		I(); self.contdesc(Me);
	}
	noun = 'desk' 'table'
 	adjective = 'pod' 'my' 'computer'
	location = startroom
;

BPchair: Chair
	sdesc = "your chair"
	isdetermined = true
	ldesc = "Considering it's still in one piece it must not be
		the standard Akmi univeristy issue, though it is
		painted in clashing orange shades."
	noun = 'chair' 'stool'
	adjective = 'pod' 'my' 'orange'
	location = startroom

	reachsurroundings = true
;

BPshelf: Shelf
	sdesc = "bookshelf"
	ldesc = "It's just your average wooden bookshelf.  It's situated
		directly above your desk, and is bowing under the
		strain of the hundreds of textbooks you've piled to
		the ceiling on it."
	noun = 'shelf' 'bookshelf'
	adjective = 'book' 'wooden'
	location = startroom
;

BPtextbooks: Readable
	examined = nil
	
	location = BPshelf
	locationtype = 'on'
	
	sdesc = "your textbooks"
	isplural = true
	isdetermined = true

	ldesc = {
		self.examined := true;
		
		"Most of the textbooks are uninteresting treatises on
		various aspects of computer science, physics, chemistry,
		and all the other boring stuff you've taken classes in
		over the past few years.  Also present, however, are
		the many tomes of literature you've become so interested
		in of late.";

		if (rgb.location = nil) {
			" As you leaf through your first year physics
			textbook, you find your old color chart.  So
			that's where that thing was!  You pick it up
			and take it with you.";
			
			rgb.movein(Me);
		}
	}

	readdesc = {
		if (not self.examined) {
			self.ldesc;
			P(); I();
		}
			
		"You read through some of the textbooks, but find most
		of them tedious and boring.  Picking up one of your
		2nd VK Era literature anthologies, however, you select one
		of the more commonly cited Unnkulian tales.  It's quite
		primitive, and you've read it a hundred times, but
		somehow it still touches you:"; P();

		I(); "\"Long ago, when the kindness of the first Valley
		King blessed the land, all the people and all the beasts were
		happy and content.  The farmers' crops grew year-round,
		the carpenters had plenty of sturdy oak to build with, and
		the Duhdhists worshiped Duhdha and played \'went\' all day
		long."; P();

		I(); "\"Then one day a terrible black cloud overtook the
		sky, and there was darkness for thirty days.  During this
		'Dark Time' the Unnkulians held the Valley King prisoner
		in his own castle, and threatened to kill him if he
		and all his people didn't acknowledge the Lord of Unnkul
		as their rightful master."; P();
		
		I(); "\"Needless to say, the Valley King refused.  So the
		Unnkulians sent their minions to round up the people and
		imprison them all in a great underground dungeon filled
		with unspeakably horrible beasts with large green teeth
		and very poor manners."; P();
		
		I(); "\"Everyone fled into the forests and the mountains,
		dreading the death of their kind but unable to conquer
		their fear.  One individual, however, would not leave.
		The locals knew him only as Kuulest, though this was
		not his real name.  When the others would ask him
		why he dared stay behind, Kuulest would say only this:
		'Duhdha will guide me.'  No one was convinced by this, but
		all were impressed by his great courage."; P();
		
		I(); "\"When the Unnkulians came around, Kuulest was still
		in his hut."; P();
		
		I(); "\"'You come wif us,' bellowed the leader of
		the Unnkulian army, 'we not wait long.'"; P();

		I(); "\"Kuulest was quite short with them, saying only,
		'Nope, I don't think so.'  The Unnkulians were taken
		aback by Kuulest's insolence."; P();

		I(); "\"'You disobey?' the leader shouted.  'Then you
		get ready die!' He unsheathed his tremendous sword
		and lifted it above his head, ready to slice Kuulest
		in half."; P();

		I(); "\"'Really, now,' Kuulest chided, 'have you thought
		this through?'  The Unnkulians all looked puzzled.  One
		grunted quizzically.  The leader did not move.  'Let's
		all review the situation, shall we?  Now, your master,
		the Lord of Unnkul, has decreed that all those in the
		lands who will not acknowledge him as their one true
		sovereign shall be imprisoned in the dungeon underneath
		the castle for all eternity, right?'  The leader nodded
		in agreement.  'All right, so it logically follows that
		anyone who is in the dungeon underneath the castle
		has NOT acknowledged your master as their master, right?'
		The leader, suspicious, furrowed his brow and grunted
		affirmatively.  'And of course everyone knows that if
		you negate a true statement it's still true, right?
		So that implies that anyone who is NOT in the dungeon
		underneath the castle HAS taken the Lord of Unnkul
		as their sovereign.  Still with me?'"; P();
		
		I(); "\"The leader looked to his comrades for
		confirmation.  They shrugged their shoulders and
		nodded nervously, unsure of what to say.  Kuulest
		seized the moment to drive the point home: 'So you'd
		probably better not go rounding up your master's
		people, eh?  In fact he asked me to come out here
		and make sure you weren't doing anything you shouldn't,
		if you, ah, know what I mean.'  The leader's jaw dropped;
		Kuulest continued: 'Fortunately I'm a reasonable man,
		so I'll agree to forget this whole incident if you'll
		save me the trouble of going all the way to the castle
		to question the Valley King as I have been assigned.
		Bring him here to me so I can discuss terms of 
		surrender, and I'll say nothing of your blunders to 
		the Lord of Unnkul.  Is it a deal? I feel I'm being 
		quite generous.'"; P();

		I(); "\"The leader was quite contrite, and was very
		impressed that someone who had so recently been on
		the wrong side of the law could have risen in the
		ranks so quickly.  Indeed a great leader, he thought."; P();

		I(); "\"He returned only hours later with the Valley
		King, who was completely confused but of course said
		nothing about the affair in front of the Unnkulians.
		His freedom restored, he quickly regrouped and
		recaptured the castle.  And so it came to pass that
		the Valley King secured the region from the Unnkulians
		for many years to come.  Kuulest, for his part,
		lived a quiet life in the country "; note(self);
		", and was brought his daily royal fried egg on a silver
		platter until the day he died.\"";
	}

	noun = 'book' 'books' 'textbooks' 'treatises'
		'tome' 'tomes' 'literature' 'texts'
	adjective = 'text' 'literary' 'class' 'course'
	
	verDoTake(actor) = {
		"There are far too many to carry.  You've read them
		all before anyway.";
	}

	footnote = { "Albeit with a useless slave..."; }
;

rgb: Item, Readable
	location = nil
#include "rgb.t"
;

BPcomputer: Readable, Attachpoint
	firsttime = true

	attachesto = [BPkeyboard]

	plugable = true

	sdesc = "your Zippikraft Data Liquidizer 1024/A"
	isdetermined = true
	readdesc = {
		"The machine is still displaying the results of your
		code analysis of the suspicious \"Unnkul\" code segment
		you stumbled across while running a random search
		of AkNet.  Unfortunately, your computer seems to have locked
		up, and you notice the unfamiliar text \"hq.orange.akmi.aknet:
		remote access = excomm\" at the bottom of the screen.";
	}

	ldesc = {
		I(); "It's a Zippikraft Data Liquidizer 1024/A -- that's the
		technical term for \"one fast machine.\"  Zippikraft
		makes the fastest computing hardware in the galaxy using
		technology no one else has been able to copy yet, despite
		several years of desperate (and creative) industrial
		espionage "; note(self); "."; P();
		
		I(); "Your Liquidizer is entirely lime green, the only color
		Zippikraft computers come in, with a built-in optical
		disk drive, detachable keyboard and high-resolution
		HoloScanning monitor.  You don't usually use the 3D video
		mode in your research since you deal mainly with text, but
		it's great for impressing guests and convincing your parents
		that the machine was really worth as much as the rest of your
		entire college education costs combined."; P();

		I(); "Liquidizers also come with built-in AkNet transceivers,
		allowing access to Akmi's galactic network, which now
		permeates almost all aspects of daily life, from electronic
		mail to shopping and funds transfers.";

		if (self.firsttime) {
			self.firsttime := nil;

			" You use AkNet to access the many ancient literature archives
			in the galaxy, particularly those that might have lost works
			on the mythical Unnkulians."; P();

			I(); "Mythical... or so it seemed.  Your Liquidizer's screen
			is still silently displaying the portentous words \"the
			Unnkulians shall rule again!\""; P();

			I(); "These words, you recall, explain the painful bruise on
			your head.  And why you've got to do everything in your
			power to stop the virus the Unnkulians have unleashed
			upon AkNet."; P();

			I(); "Who'd have thought you'd really find anything of value
			by searching random records in AkNet's database for 
			\"Unnkul,\" much less the code to a virus that's probably
			been wending its way through AkNet's bowels for years.
			Only the Unnkulians' matchless arrogance and some divine
			force could have led you to this single black grain of
			sand in the immense digital beach that is AkNet."; P();

			I(); "Yes, the Unnkulians' supreme arrogance -- an 
			arrogance that's driven them to broadcast their 
			secret declaration of war with the very instrument 
			their success depends upon -- will (with any luck) 
			prove to be their downfall again, as told so many 
			times in the tales of the ancient Valley King Era 
			battles with these thoroughly evil creatures; legends 
			that you've nearly come to memorize through thousands 
			of readings."; P();
		
			I(); "But how to stop the virus? How can you halt the 
			relentless progress of this robotic self-propagating 
			piece of Unnkulian handiwork, their will and psyche 
			and utter evilness distilled into crisp, razor-sharp 
			digital efficiency?"; P();
		
			I(); "And what if, as in \"Unnkulian Unventure II: The 
			Secret of Acme,\" your most recent 
			compuarchaeological find (and one of only two known 
			examples of Unnkulian literature from the 5th VK Era, 
			both of which are computer-driven interactive 
			literature, and both of which only you will know 
			about until your thesis is published), Akmi is 
			involved?  Contacting the main AkNet headquarters 
			might be the worst possible tactic; if Akmi is allied 
			with the Unnkulians again, your spouting off about 
			the virus would be disastrous, and probably fatal."; P();
	
			I(); "And what have the Unnkulians been doing all these years?
			Where are they now?  And did the world simply forget about
			them between 2nd VK Era and 5th VK Era "; note(lithistory);
			", or did the Unnkulians destroy every reference to themselves
			they could find on AkNet in an attempt to rewrite
			history?"; P();
		
			I(); "So many questions.  So little time.  And the consequences
			of failure are great indeed."; P();
		
			I(); "Unfortunately, your computer seems to have locked up.
			Cycling the power has no effect.  You notice
			the unfamiliar text \"hq.orange.akmi.aknet: remote access = 
			excomm\" at the bottom of the screen.";		
		}
	}

	footnote = {
		"The fact that Zippikraft is entirely owned and run 
		by Skivlets from the planet Poot (in the Baig system) 
		probably has a lot to do with the success of the Data 
		Liquidizer line of hardware.  Skivlets are so small 
		they can dance on the heads of pins, and it is 
		widely believed that have a genetically-endowed, 
		deep understanding of quantum physics. Unfortunately
		they're quite xenophobic, though they're more than
		willing to take your money.";
	}

	noun = 'computer' 'liquidizer' 'monitor' 'screen' 'terminal'
	adjective = 'data' 'zippikraft' 'zippi' 'kraft' 'zippy' 'craft'
			'zippi-kraft' 'zippy-kraft' 'zippi-craft'
			'zippy-craft'
	
	location = BPdesk
	locationtype = 'on'

	verDoTake(actor) = {
		"Your Zippikraft Data Liquidizer is not a portable.
		In fact, it's not even a liftable or a movable, at least
		without a fork lift.";
	}
	verDoTurnon(actor) = {
		"It's already on.";	
	}
	verDoTurnoff(actor) = {
		"Flipping the power switch has no effect.  How odd.  It's
		never done this before...";
	}
	verIoTypeon(actor) = {
		if (find(BPkeyboard.attachedto, self) <> nil)
			"The machine seems to be locked up.  Nothing at all
			happens when you type.";
		else
			"There's no keyboard attached.";
	}
;
BPkeyboard: Attachable, Item
	attachesto = [BPcomputer TVBACKDOORterminal]
	attachedto = [BPcomputer]

	plugable = true

	// not listed in room descriptions when attached
	islistable(actor) = {
		if (self.attachedto = [])
			return true;
		else
			return nil;
	}
	sdesc = "Zippikraft detachable keyboard"
	ldesc = {
		"It's just a standard 233-key model. ";

		if (self.attachedto <> []) {
			"It is currently attached to ";
			self.attachedto[1].thedesc; ".";
		}
		else {
			"It is not currently attached to anything.";
		}
	}
	noun = 'keyboard'
	adjective = 'data' 'zippikraft' 'zippi' 'kraft' 'zippy' 'craft'
			'zippi-kraft' 'zippy-kraft' 'zippi-craft'
			'zippy-craft' 'liquidizer' 'computer' 'detachable'

	bulk = 4
	weight = 1
	
	location = BPdesk
	locationtype = 'on'
	
	verIoTypeon(actor) = { 
		if (self.attachedto <> [])
			self.attachedto[1].verIoTypeon(actor);
		else {
			caps();	self.thedesc; " isn't attached to anything.
			This makes typing things on it somewhat less useful.";
		}
	}
	ioTypeon(actor, dobj) = { self.attachedto[1].ioTypeon(actor, dobj); }
;
BPdiskdrive: Qcontainer
	sdesc = "Zippikraft optical disk drive"
	noun = 'drive'
	adjective = 'data' 'zippikraft' 'zippi' 'kraft' 'zippy' 'craft'
			'zippi-kraft' 'zippy-kraft' 'zippi-craft'
			'zippy-craft' 'liquidizer' 'computer' 'floppy'
			'disk' 'disc' 'diskette' 'disquette' 'optical'	

	location = BPdesk
	locationtype = 'on'

	ioPutin(actor, dobj) = {
		if (dobj <> uudisk) {
			caps(); dobj.thedesc; " doesn't fit into ";
			self.thedesc; ".";
		}
		else {
			caps(); dobj.thedesc; " slides into ";
			self.thedesc; " with a solid click.";
			
			dobj.movein(self);
		}
	}
;
lithistory: object
	footnote = {
		"Researcher Jens Brams at Tel University unearthed 
		the first Unnkulian tales in 2051VK.  They were paper 
		texts, dating back to around 400VK -- late First 
		Valley King Era to early Second.  Since then, many 
		other similar works have been found, all from around 
		the same period."; P();
		
		I(); "Your treasures, the Unnkulian Unventures, are the 
		only examples of Unnkulian literature dated later 
		than 420VK -- you've traced them back to around 
		1701VK, the beginning of the Fifth Valley King Era. 
		They're especially interesting because they're early 
		and primitive examples of what is now a widespread 
		form: interactive literature.  The works employ a 
		rudimentary sentence parser to interact with the 
		reader -- quite unsophisticated, but nonetheless 
		similar to today's government-regulated RLR's (Real 
		Language Recognizers) in spirit."; P();

		I(); "The Unnkulian Unventures portray their namesakes as
		wholly evil beings bent on destroying everything they
		are not a part of.";
	}
;
BPhatch: BPdecoration
	sdesc = "your pod's emergency escape hatch"
	isdetermined = true
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }

	ldesc = "The escape hatch is buried under a pile of papers.
		It appears to be sealed shut, and you've never
		had occasion to use it in the past."
	
	noun = 'hatch' 'door'
	adjective = 'emergency' 'escape' 'manual'

	verDoOpen(actor) = {
		"You thoroughly overexert yourself but to no avail.
		Panting and sweating profusely, you finally give up.";
	}
	verDoClose(actor) = {
		"Don't worry, that's already been quite taken care of.";
	}
;

qual_calculator: Item
	sdesc = "qualitative calculator"
	ldesc = {
		I(); "Your parents gave you this for your birthday
		last year.  It's just the sort of thing they'd be
		absolutely wrong about thinking you'd need.  And
		indeed, you've found no use for it to
		date. <<note(self)>>"; P();

		I(); "It has has 9 buttons: ZERO, POSITIVE, NEGATIVE,
		ADD, SUBTRACT, MULTIPLY, DIVIDE, Clear and deClear.
		The readout currently shows <<self.sayreadout>>.";
	}
	noun = 'calculator' 'calc'
	adjective = 'qualitative'
	location = BPdesk

	footnote = { "Respects to Walter Hamscher and Carl de Marcken."; }

	stack = []
	secondstack = []
	saynewreadout = { "\nThe readout now shows <<self.sayreadout>>.\n"; }
	sayreadout = {
		local v;

		if (length(stack) < 1)
			v := 0;
		else
			v := stack[1];

		if (v = -1)
			"[[\ -\ ]]";
		else if (v = 0)
			"[[\ 0\ ]]";
		else if (v = 1)
			"[[\ +\ ]]";
		else
			"[[\ ?\ ]]";
	}
	pop = {
		local v;

		if (length(stack) < 1)
			v := 0;
		else {
			v := car(stack);
			stack := cdr(stack);
		}

		return v;
	}
;

readout: Part
	sdesc = "readout"
	ldesc = { qual_calculator.saynewreadout; }
	partof = qual_calculator
	noun = 'readout'
	adjective = 'calculator'
;

qualbutton: Part, Button
	ldesc = "There is nothing special about <<self.objthedesc(nil)>>."
	partof = qual_calculator
;

clear: qualbutton
	sdesc = "Clear button"
	noun = 'button'
	adjective = 'clear' 'kleer'
	doPush(actor) = {
		qual_calculator.secondstack := qual_calculator.stack;
		qual_calculator.stack := [];
		qual_calculator.saynewreadout;
	}
;

declear: qualbutton
	sdesc = "Clear button"
	noun = 'button'
	adjective = 'declear' 'dekleer'
	doPush(actor) = {
		local tmp;

		tmp := qual_calculator.stack;
		qual_calculator.stack := qual_calculator.secondstack;
		qual_calculator.secondstack := tmp;
		qual_calculator.saynewreadout;
	}
;

zerobutton: qualbutton
	sdesc = "ZERO button"
	noun = 'button'
	adjective = 'zero'
	doPush(actor) = {
		qual_calculator.stack := [ 0 ] + qual_calculator.stack; 
		qual_calculator.saynewreadout;
	}
;

positivebutton: qualbutton
	sdesc = "POSITIVE button"
	noun = 'button'
	adjective = 'positive'
	doPush(actor) = {
		qual_calculator.stack := [ 1 ] + qual_calculator.stack; 
		qual_calculator.saynewreadout;
	}
;

negativebutton: qualbutton
	sdesc = "NEGATIVE button"
	noun = 'button'
	adjective = 'negative'
	doPush(actor) = {
		qual_calculator.stack := [ -1 ] + qual_calculator.stack; 
		qual_calculator.saynewreadout;
	}
;

addbutton: qualbutton
	sdesc = "ADD button"
	noun = 'button'
	adjective = 'add'
	doPush(actor) = {
		local v, v1, v2;
		v1 := qual_calculator.pop;
		v2 := qual_calculator.pop;
		if (v1=2 or v2=2) v := 2;
		else if ((v1=1 and v2=-1) or (v1=-1 and v2=1)) v := 2;
		else if (v1=1 or v2=1) v := 1;
		else if (v1=-1 or v2=-1) v := -1;
		else v := 0;
		qual_calculator.stack := [ v ] + qual_calculator.stack; 
		qual_calculator.saynewreadout;
	}
;

subtractbutton: qualbutton
	sdesc = "SUBTRACT button"
	noun = 'button'
	adjective = 'subtract'
	doPush(actor) = {
		local v, v1, v2;
		v1 := qual_calculator.pop;
		v2 := qual_calculator.pop;
		if (v1=2 or v2=2) v := 2;
		else if ((v1=1 and v2=1) or (v1=-1 and v2=-1)) v := 2;
		else if (v2<>0) v := v2;
		else v := -v1;
		qual_calculator.stack := [ v ] + qual_calculator.stack; 
		qual_calculator.saynewreadout;
	}
;

multiplybutton: qualbutton
	sdesc = "MULTIPLY button"
	noun = 'button'
	adjective = 'multiply'
	doPush(actor) = {
		local v, v1, v2;
		v1 := qual_calculator.pop;
		v2 := qual_calculator.pop;
		if (v1=2 or v2=2) v := 2;
		else if (v1=0 or v2=0) v:= 0;
		else if (v1=v2) v := 1;
		else v := -1;
		qual_calculator.stack := [ v ] + qual_calculator.stack; 
		qual_calculator.saynewreadout;
	}
;

dividebutton: qualbutton
	sdesc = "DIVIDE button"
	noun = 'button'
	adjective = 'divide'
	doPush(actor) = {
		local v, v1, v2;
		v1 := qual_calculator.pop;
		v2 := qual_calculator.pop;
		if (v1=2 or v2=2 or v1=0) v := 2;
		else if (v2=0) v := 0;
		else if (v1=v2) v := 1;
		else v := -1;
		qual_calculator.stack := [ v ] + qual_calculator.stack; 
		qual_calculator.saynewreadout;
	}
;

/*
 * Ada's pod
 */
adapod: Room
	noun = 'pod'
	adjective = 'ada' 'ada\'s'

	sdesc = "Ada's pod"
	thedesc = { self.sdesc; }
	ldesc = {
		I(); "You are in your true love Ada's pod.  It's
		quite similar to your own, but isn't nearly as
		messy. Ada seems to have gone off and left saving
		the galaxy to you alone "; note(self); ".";

		P(); I(); ADAEV.watchdesc;
	}

	footnote = {
		"Perhaps she's off gallivanting with that
		annoying salesman again.  What an annoying
		fellow he is, and with horrible taste in clothing
		to boot!  You hope it's just a phase.";
	}

	in = { ADAmover.doEnter(Me); return nil; }
	out = { return self.down; }
	down = { 
		if (ADAhatch.isopen) {
			"You squeeze through the hatch and scramble down
			the metal ladder leading up to it.\b";
			
			return underada;
		}
		else {
			"You can't go that way.";
			return nil;
		}
	}
;
rylvania: Readable, Item
	sdesc = "paperback book"
	ldesc = {
		"The book is entitled, \"The Horror of Rylvania,
		and Other Ghost Stories.\"  \"Ada Man\" is written
		in the inside cover.  It's one of her favorite
		books, and it appears to be autographed.  The
		handwriting is so poor, however, that you 
		can't make out much of the author's name -- it looks
		like \"D.\ O.\ Louty\" but you're sure that's not
		right.";
	}
	readdesc = {
		"Ada has told you on many occasions how great
		the title tale is, but you don't have time to
		kick back for a few hours and read it right now.";
	}
	noun = 'book' 'novel' 'stories' 'horror' 'rylvania' 'back' 'paperback'
	adjective = 'rylvania' 'paperback' 'paper'
	location = adapod
;
adanote: Readable, Item
	sdesc = "handwritten note"
	ldesc = {
		"The note is to you. ";
		self.readdesc;
	}
	readdesc = {
		"It reads:\b
		\tGavin --\b
		\tStudying at the library today.  Don't forget dinner
		at Grandma's house tomorrow night.  When you go out,
		please pick up some prune seeds from the Barfee outlet
		(8549, 4392, 8392) -- you know how Grandma is about
		her garden.\b
		\t\t\t\t\tLove,\n
		\t\t\t\t\tAda";
	}
	noun = 'note'
	plural = 'notes'
	adjective = 'handwritten'
	location = adapod
;

class ADAdecoration: Decoration location = adapod ;

ADAjunk: ADAdecoration
	isplural = true
	sdesc = "contents of Ada's pod"
	ldesc = {
		"Her pod is filled with the usual stuff: papers,
		clothes, an enterviewer, a mover.  Nothing special.";
	}

	noun = 'textbooks' 'texts' 'furniture' 'item' 'items'
		'stuff' 'junk' 'garbage' 'clothes' 'papers'
	adjective = 'literature'

	verDoTake(actor) = {
		"You can borrow her things any time, but nothing
		here looks all that useful.";
	}
	verDoMove(actor) = {
		"Well, what do you know?  There's an escape hatch
		in Ada's pod, just like in yours.";
	}
;
ADAhatch: ADAdecoration
	isopen = nil

	sdesc = "Ada's pod's emergency escape hatch"
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }

	ldesc = {
		"After some searching, you find the pod's escape hatch 
		buried under a pile of papers. It looks like an airlock;
		all metal, with a big wheel-shaped lever on it";

		if (self.isopen)
			", and open at the moment.";
		else
			" that appears to be keeping it well-sealed.";
	}

	noun = 'hatch' 'door' 'wheel' 'airlock' 'lever'
	adjective = 'emergency' 'escape' 'manual' 'pod' 'ada\'s' 'metal'
			'wheel-shaped' 'steering' 'wheel' 'shaped'

	verDoTurn(actor) = { self.verDoOpen(actor); }
	doTurn(actor) = { self.doOpen(actor); }
	verDoOpen(actor) = {
		if (self.isopen)
			"It's already open.";
	}
	doOpen(actor) = { 
		"Grabbing the steering wheel shaped latch, you
		pull with every bit of strength your muscles can muster.
		Just when you're about to lose hope, the seal gives a
		little and you begin to make progress.  Moments later
		you're looking down into the dark metal corridor below.";
			
		self.isopen := true;

		incscore(1);
	}
	verDoClose(actor) = {
		if (self.isopen)
			"Are you out of your mind?  With all the effort it took
			to get the blasted thing open, you want to seal it up
			again?  Come to your senses!  <slap, slap>";
		else
			"You haven't even gotten it open yet!";
	}
	verDoUnlock(actor) = { "It's not locked, just sealed shut."; }
	verDoLock(actor) = { "It doesn't have a lock."; }
	verDoBreak(actor) = { "Nice try, but it's solid metal."; }
;
ADApod: ADAdecoration
	sdesc = { adapod.sdesc; }
	ldesc = { adapod.ldesc; }
	thedesc = { adapod.thedesc; }
	noun =	'pod' 'pad' 'room' 'cubicle' 'closet'
	adjective = 'dorm' 'economical' 'cheap' 'ada\'s'
	
	doInspect(actor) = {
		adapod.ldesc;
		P(); I();
		ADAhatch.ldesc;
	}
;
ADAbed: ADAdecoration
	sdesc = "Ada's bed"
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }
	ldesc = {
		"It's folded up into the wall, locked.  You assume
		it's just like yours: an uncomfortable countertop.";
	}
	
	noun = 'bed' 'pallet' 'mattress' 'blankets' 'sheets' 'covers'
	adjective = 'folding' 'pod' 'ada\'s'
	
	verDoOpen(actor) = { self.verDoUnlock(actor); }
	verDoClose(actor) = { "It's already closed."; }
	verDoUnlock(actor) = { "I wouldn't risk it, if I were you."; }
	verDoLock(actor) = { "Thankfully it's already locked."; }
	verDoRoll(actor) = {
		"It's already folded up.";
	}
	verDoUnroll(actor) = {	
		"You struggle and strain, but to no avail.";
	}

;
ADAEV: ADAdecoration, ev
	setting = 52109
;
ADAmover: ADAdecoration, mattermover
	address = {
		"Text on the mover says:"; P();
		I(); "\"6000, 3270, 1738 -- colorspace Burnt Sienna\"";
	}

	ar = 6000
	ag = 3270
	ab = 1738

	r = ADAred
	g = ADAgreen
	b = ADAblue
	
	colorspace = 'Burnt Sienna'
	system = 'Val'
	planet = 'Frost'
;

ADAred: ADAdecoration, reddial		setting = 0;
ADAgreen: ADAdecoration, greendial	setting = 0;
ADAblue: ADAdecoration, bluedial	setting = 0;

/*
 * The emergency exit from Ada's pod.
 */
underada: Room
	// the following vocab causes under to not work as a prep:
//	noun = 'ada'
//	adjective = 'under'

	sdesc = "Metal Corridor Under Ada's Pod"
	ldesc = {
		I(); "You're in a narrow but otherwise nondescript metal
		corridor leading east and west.  You see a ladder leading up
		to Ada's pod.";
	}
	
	up = {
		"You climb up the ladder and emerge to find yourself in...\b"; 
		return adapod;
	}
	east = dustycorridor
	west = zdybelroom
;
UNDERADAladder: Decoration
	sdesc = "metal ladder"
	location = underada
	noun = 'ladder'
	adjective = 'metal'
;
dustycorridor: Room
	noun = 'corridor'
	adjective = 'dusty'

	sdesc = "Dusty Corridor"
	ldesc = {
		I(); "The east-west metal corridor narrows here so that
		you have to crouch to go any further east.  The air is musty,
		and there's so much dust that you cough uncontrollably.";
	}
	east = airduct
	west = underada 
;
corridordust: Decoration
	sdesc = "dust"
	ldesc = "It's just ordinary dust."
	noun = 'dust'
	location = dustycorridor
;
airduct: Room
	noun = 'duct' 'grating'
	adjective = 'air' 'duct'

	sdesc = "At an Air Duct Grating"
	ldesc = {
		I(); "You have crawled to the end of an east-west metal 
		corridor and are now looking through a grating into what
		appears to be an air duct.  It is very dusty here. ";
		
		AIRDUCTgrate.ldesc; P();
		
		I(); "The only obvious way out is back west.";
	}	
	west = dustycorridor
	east = {
		if (AIRDUCTgrate.frozen) {
			"You crawl through the opening in the grate."; P();
			
			return behindgrate;
		}
		else {
			"You'll have to get the grating off first.";

			return nil;
		}
	}
;
hammer: Item
	sdesc = "hammer"
	noun = 'hammer'
	bulk = 2
	weight = 3
	location = airduct

	verIoAttackwith(actor) = {}
	ioAttackwith(actor, dobj) = { dobj.doAttackwith(actor, self); }
	verIoHitwith(actor) = {}
	ioHitwith(actor, dobj) = { dobj.doHitwith(actor, self); }
; 
bolt: Item
	sdesc = "bolt"
	ldesc = {
		"It's just a steel bolt, about 4 centimeters across.  It's
		a bit greasy";

		if (not global.ingame and global.turns < 25) {
			", and it's warm, as though it just fell off
			a working machine.";
		}
		else
			".";
	}
	location = airduct
	noun = 'bolt'
	adjective = 'steel' 'greasy' 'warm'
;
raygun: Item
	scrambled = nil
	sdesc = {
		if (self.scrambled)
			"ray gun";
		else
			"ary ung";
	}
	adesc = {
		if (self.scrambled) {
			"a "; self.sdesc;
		}
		else {
			"an "; self.sdesc;
		}
	}
	ldesc = {
		"\^<<self.subjthedesc>> is a black pistol-shaped
		implement that fits snugly in your hand.  It has an
		almost unnoticeable red trigger.";
	}
	noun = 'ary' 'ung' 'ray' 'gun' 'implement' 'pistol'
	adjective = 'ary' 'ray' 'pistol-shaped' 'pistol' 'shaped' 
	plural = 'guns' 'weapons' 'pistols'

	location = airduct
	verIoShootwith(actor) = {}
	verDoShootat(actor, io) = {}
	verIoAttackwith(actor) = {
		"You'll have to be a bit more specific.";
	}
;
trigger: Part
	partof = raygun
	sdesc = "<<raygun.sdesc>> trigger"
	adesc = "<<raygun.adesc>> trigger"
	thedesc = "<<raygun.thedesc>> trigger"
	noun = 'trigger'
	adjective = 'red' 'ray' 'gun'
	
	verDoPull(actor) = {
		"You'll need to be more specific about
		your target.";
	}
;
AIRDUCTgrate: floatingdecoration
	frozen = nil

	isplural = true

	sdesc = "air duct grating"
	ldesc = {
		"The grating is made of metal and is thickly caked with
		dust and grime. It's held firmly in place by a screw in
		each corner.";

		if (self.frozen) {
			" There's a ragged hole in it big enough
			for you to squeeze through.";
		}
	}

	noun = 'grate' 'grating' 'panel' 'filter' 'screw' 'screws' 
	       'corners' 'duct'
	adjective = 'air' 'duct' 'airduct' 'metal'
	loclist = [airduct behindgrate]

	freeze = {
		if (not self.frozen) {
			self.frozen := true;

			"As you pour on the liquid nitrogen, part of the
			grate becomes brittle.  All it takes is a light
			tap of your foot to make a hole large enough
			to fit through.";
		}
		else {
			"You've already done enough damage!";
		}
	}

	verDoOpen(actor) = {
		if (self.frozen)
			"You can already fit through the hole -- why bother?";
		else
			"Not a chance without a screwdriver."; 
	}
	verDoClose(actor) = { "It's quite closed right now."; }
	verDoUnscrew(actor) = { 
		if (self.frozen)
			"You can already fit through the hole -- why bother?";
		else
			"You'll need a screwdriver.";
	}
	verDoTurn(actor) = { self.verDoUnscrew(actor); } // for "turn screw"
	verDoScrew(actor) = { self.verDoUnscrew; }
	verDoBreak(actor) = {
		if (self.frozen)
			"It's already broken!";
		else
			"The grating looks quite sturdy.";
	}
	verDoClean(actor) = {
		if (self.frozen)
			"What remains of the grate looks a little cleaner.";
		else
			"You scrub away, but your labors have little effect.";
	}
	verDoLookthrough(actor) = {
		"It looks like there's just an air duct on the other side.";
	}
	verDoKick(actor) = {}
	doKick(actor) = {
		if (self.frozen)
			"You can already fit through the hole -- why bother?";
		else
			"<Whangggg> The grating reverberates loudly.
			Unfortunately you don't seem to have done any
			permanent damage (or loosening).";
	}
	verDoHit(actor) = {}
	doHit(actor) = {
		"The only damage you manage to do is to yourself.  (Ouch.)";
	}
	verDoHitwith(actor, io) = {}
	doHitwith(actor, io) = { "You fail to break through the grate."; }

	verDoPush(actor) = {}
	doPush(actor) = { "You can't push hard enough to do any damage."; }
;
behindgrate: Room
	sdesc = "In an Air Duct"
	ldesc = {
		// NOTE: player can't get back out once he's in
		// barracks -- he must use the mover.  This means
		// that he can't be in this location without having
		// broken the grate.

		I(); "You are in a dusty, featureless metal air duct.
		The duct narrows to the east and then opens up into
		a room of some kind -- you might be able to fit through,
		but it'll be tight, and you probably won't be able to get
		back up here. Alternatively, you can head back west through
		the hole in the grate.";
	}
	west = airduct
	east = {
		"You squeeze through the tiny duct and wind up on the
		floor of a..."; P();

		return barracks;
	}
;
screwdriver: Item
	sdesc = "screwdriver"
	noun = 'screwdriver' 'driver'
	adjective = 'screw'
	bulk = 1
	weight = 1
	location = behindgrate

	verIoScrewwith(actor) = {}
	verIoUnscrewwith(actor) = {}
	
	ioScrewwith(actor) = {
		"It's the wrong type of screwdriver.";
	}
	ioUnscrewwith(actor) = {
		"It's the wrong type of screwdriver.";
	}
;
barracks: Room
	firsttime = true

	sdesc = "Barracks"
	ldesc = {
		I(); "You're in a long, rectangular chamber.  The walls
		are shiny metal.  From under the floor, a quiet humming
		noise reverberates through the chamber.  Several low bunks
		line the walls.  At the south end of the chamber is a
		massive metal locker, currently ";

	        if (locker.isopen)
	            "open. ";
	        else
	            "closed. ";


		if (self.firsttime) {
			self.firsttime := nil;

			"There's an open doorway to the north."; P();

			I(); "Wait -- there's a medieval-looking armor-clad
			man pedaling a bicycle in the center of the
			room!  All of a sudden, the man and the bike
			both vanish!"; P();

			I(); "You examine the area around where the
			man was, but find nothing. Further inspection of
			the room, however, reveals and airduct in the west
			wall, above you.  It doesn't look like you'll be
			able to reach it.";
		}
		else {
			"There's an open doorway to the north, and
			an airduct above you, in the west wall.";
		}

	}

	west = {
		"You jump as high as you can, but you can't reach the
		airduct.";

		return nil;
	}
	up = { return self.west; }
      	north = survey

	//
	// Don't list humming sound in room descriptions -- only
	// when the player types "listen".
	//
	incontentslistedsound(obj) = {
		return nil;
	}
;
barracksairduct: Distant
	sdesc = "air duct"
	ldesc = {
		"It looks like an ordinary air duct, but you can't
		get close enough to inspect it.";
	}
	noun = 'duct'
	adjective = 'air'
	location = barracks
;
futbunks: Bed
	isplural = true
	sdesc = "bunks"
	ldesc = "All of the bunks are quite hard and low.  They
		look extremely uncomfortable.  "
	noun = 'bunk' 'bunks'
	adjective = 'hard' 'low'
	location = barracks
;
locker: Openable
	sdesc = "locker"
	ldesc = {
		"The locker is extremely large and made out of shiny
		metal. "; 

		inherited.ldesc;
	}
	isopen = true

	noun = 'locker'
	adjective = 'massive' 'large'
	location = barracks

	verDoOpen(actor) = {
		"The door is too heavy to open by hand.";
	}
	verDoClose(actor) = {
		"The door is too heavy to close by hand.";
	}
;
futnoise: Listablesound, Decoration
	isdetermined = true
	sdesc = "something under the floor"
	ldesc = "You can't examine the humming noise, though you might be
		able to listen to it."
	noun = 'noise' 'sound'
	adjective = 'humming'
	location = barracks

	listlistendesc = {
		"is humming loudly.";
	}
	listendesc = {
		"It's a loud humming noise.";
	}
;
survey: Room
	sdesc = "Surveillance Room"
	ldesc = {
		I();
		"You're standing in a square chamber with walls of shiny
		metal.  A huge black desk shaped like a half-moon faces
		north.  On the north wall are three screens, each displaying
		a different picture.  A pale man in a strange outfit
		is slumped in a chair behind the desk, fast asleep and
		snoring.  A passage runs south and a huge sealed door
		is to the west.  Sitting against the eastern wall is a
		matter mover.";
	}
	south = barracks
	west = {
		"The door is sealed.";
		return nil;
	}
	in = {
		surmover.doEnter(Me);
		return nil;
	}
;
surveychair: Chair
	sdesc = "chair"
	ldesc = {
		"The man is in the chair.  Other than that, you don't
		see anything unusual about it.";
	}
	noun = 'chair'
	location = survey

	verDoEnter(actor) = { "The man's already in the chair!"; }
;
class screenitem: Decoration
	noun = 'screen'
	plural = 'screens'
	location = survey
;
screen1: screenitem
	sdesc = "first screen"
	ldesc = {
		if (screen1.isoff)
			"The screen is dark.";
		else {
			"The first screen is rather boring.  It shows a
			chamber that looks like a barracks. ";
		
			if (locker.isopen)
				"A huge metal locker is visible also,
				standing open.";
			else
				"A huge metal locker is also visible.
				It is closed.";
		}
        }
	adjective = 'one' 'first'
;
screen2: screenitem
	sdesc = "second screen"
	ldesc = {
		if (screen1.isoff)
			"The screen is dark.";
		else
			"The second screen shows a vast glowing chamber
			filled with strange machinery.  Huge gray rods
			climb from floor to ceiling, and tiny human figures
			scurrying back and forth give some idea of the
			immensity of the scale.";
	}
	adjective = 'two' 'second'
;
screen3: screenitem
	sdesc = "third screen"
	ldesc = {
	        if (screen1.isoff)
			"The screen is dark.  ";
	        else
			"The third screen displays a dark and gloomy
			landscape. Jutting, fern-like trees slash across a
			blood-red sky, and three suns hang low on the
			horizon.  Black underbrush obscures the forest floor
			-- is that a gnooby you glimpse, darting in and out
			of the vegetation?";
	}

	adjective = 'three' 'third'
;
class deskbutton: Button
	noun = 'button'
	plural = 'buttons'
	ldesc = {
		"Currently, ";
		self.subjthedesc;
		if (self.ison <> true)
			" is up. ";
		else
			" is down. ";
	}
	location = survey
	ison = nil
;
whitebut: deskbutton
	sdesc = "white button"
	adjective = 'white'
	ison = true
	doPush(actor) = {
		"You push the white button. ";
		if (self.ison) {
			"Suddenly, the screens go dark.  ";
			screen1.isoff := true;
			self.ison := nil;
		}
		else {
			"Suddenly, the screens light up.  ";
			screen1.isoff := nil;
			self.ison := true;
		}
	}
;
yellowbut: deskbutton
	sdesc = "yellow button"
	adjective = 'yellow'
	doPush(actor) = {
		"You push the yellow button.  Nothing happens.  ";
		if (self.ison)
			self.ison := nil;
		else
			self.ison := true;
	}
;
greenbut: deskbutton
	ison = true

	sdesc = "green button"
	adjective = 'green'
	doPush(actor) = {
		"You push the green button.  ";
		if (self.ison) {
			self.ison := nil;
			locker.isopen := nil;
		}
		else {
			self.ison := true;
			locker.isopen := true;
		}
		"A small movement on the first screen catches your eye.";
	}
;
redbut: deskbutton
	sdesc = "red button"
	adjective = 'red'
	doPush(actor) = {
		"When you push the red button, a shrill alarm begins to
		sound.  The sleeping guard jumps, awakening.  \"Whazzat?\"
		he murmurs, wiping sleep from his eyes - and then he
		spots you and leaps to his feet.  \"Hey!  Nobody's allowed
		in here!\"  He pulls a blaster from beneath his shirt and
		points it at you...";
		
		notify(deathobject, &death, 0);
	}
;
blackdesk: Desk
	sdesc = "curved desk"
	noun = 'desk'
	adjective = 'black' 'curved'
	location = survey
	ldesc = {
		"There are four buttons on the desk - white, yellow,
		green, and red.  There's a drawing of a little megaphone
		above the red button.  Each button has an up and a down
		position.  ";
	}
;
sealdoor: Decoration
	sdesc = "sealed door"
	ldesc = {
		"The door has no apparent controls of any type.  It's
		sealed shut.";
	}
	noun = 'door' 'doorway'
	adjective = 'sealed' 'western'
	location = survey
	verDoOpen(actor) = {
		"I see no means of opening the door.  ";
	}
	verDoClose(actor) = {
		"The door's already closed -- in fact, it's sealed shut.  ";
	}
	verDoUnlock(actor) = {
		"I don't see any locking mechanism on the door, nor do I see
		any way of getting it open.  ";
	}
	verDoUnlockWith(actor, io) = {
		"I don't see any locking mechanism on the door, nor do I see
		any way of getting it open.  ";
	}
;
guardoutfit: Decoration
	sdesc = "outfit"
	ldesc = {
		"The man's outfit is blue with little gold tassels
		on the shoulders.  Written across the man's chest are
		the words \"Security - Class Y.\"";
	}
	noun = 'outfit' 'clothes' 'clothing'
	adjective = 'blue'
	location = survey
	verDoTake(actor) = {
		"I doubt you could strip the man without waking him.  ";
	}
	verDoSmell(actor) = {
		"Phew!  I don't think this fellow has taken a bath
		lately.";
	}
;
survguard: Decoration
	sdesc = "pale man"
	ldesc = {
		"The pale man is fast asleep with his feet propped up on
		the desk.  He's snoring.";
	}
	noun = 'man' 'him' 'guard'
	adjective = 'security' 'pale'
	location = survey
	verDoWake(actor) = {
		"I don't think that's a good idea.  I don't really think
		you're supposed to be here, and the man's uniform suggests
		he's an official of some kind.  Better let him sleep.";
	}
	verDoAskabout(actor, io) = {
		"He's asleep.";
	}
	verDoTellabout(actor, io) = {
		"He's asleep.";
	}
	verDoSmell(actor) = {
		"Phew!  I don't think he's bathed too recently.  ";
	}
	verDoAttackWith(actor, io) = {
		"That wouldn't be very nice, no would it?";
	}
	verDoKick(actor) = {
		"You'd wake him up, and that would be rude.  ";
	}
	verDoPunch(actor) = {
		self.verDoKick(actor);
	}
;
surmover: mattermover
	location = survey
	address = {
		"The address is written on the machine:"; P();
		I(); "\"6000, 3270, 1732 -- colorspace Burnt Sienna\"";
	}

	//
	// This mover's coordinates
	//
	ar = 6000
	ag = 3270
	ab = 1732
	
	//
	// This mover's dials
 	//
	r = surred
	g = surgreen
	b = surblue

	colorspace = 'Burnt Sienna'
	system = 'Val'
	planet = 'Frost'
;
surblue: Decoration, bluedial
	location = survey
	setting = 6000
;
surgreen: Decoration, greendial
	location = survey
	setting = 3270
;
surred: Decoration, reddial
	location = survey
	setting = 1732
;	 
zdybelroom: Room
	walls = nil

	noun = 'corridor'
	adjective = 'red' 'green' 'zdybel'

	sdesc = "Red and Green Corridor"
	ldesc = {
		I(); "The narrow east-west hallway continues through here
		with but one feature changed: the walls and floor are
		covered with red and green splotches.  Oh yes, and the
		walls appear to be somewhat chewed up."; P();
		
		I(); "You can see a ladder leading up to Ada's pod to the
		east, and what appears to be a landing/launching bay of some
		kind to the west.";
	}
	east = underada
	west = {
		if (zdybel.location = self) {
			if (zdybel.scrambled) {
				"You nimbly step over the harmless 
				Bedzyl and proceed down the hall.\b";

				return escapepod;
			}
			else {
				"The slavering Zdybel blocks your way!";

				return nil;
			}
		}
		else
			return escapepod;
	}
;
class Zdybel: Itemactor
	scrambled = nil
	scored = nil
	beentaken = nil
	sdesc = {
		if (Zdybel.scrambled)
			"harmless little Bedzyl";
		else
			"hideous Zdybel";
	}
	ldesc = {
		if (Zdybel.scrambled) {
			"The Bedzyl is a tiny mouse-like creature
			that seems to be friendly but very afraid of you,
			which is understandable since you're about 100 times
			its size";
			
			if (raygun.isin(Me))
				" and wielding a nasty-looking pistol.";
			else
				".";
		}
		else {
			"The Zdybel are widely regarded as the most 
			disgusting vermin in the known universe.  
			They combine the worst elements of all the 
			vilest creatures into a single emetic rodent: 
			rat-like features; body odor like carrion; 
			slimy, matted fur that drips some  revolting 
			and (thankfully) unidentifiable bodily fluid; 
			voracious appetite; and the eating habits of 
			flies.  This particular specimen is a giant, 
			and judging from the constant flow of saliva 
			from the tips of its razor-sharp buck teeth 
			into ever-growing pools on the ground, I'd 
			say it's hungry "; note(self); ".";
		}
	}

	actordesc = {
		if (not self.isin(Me)) {
			if (Zdybel.scrambled) {
				"There is a little Bedzyl here, 
				scurrying about cheerfully.";
			}
			else {
				if (self.isin(zdybelroom))
					"A hideous Zdybel blocks your
					way west!";
				else
					"There is a hideous Zdybel here,
					eyeing you hungrily and drooling
					profusely.";
			}
		}
	}

	weight = {
		if (Zdybel.scrambled)
			return 1;
		else
			return 150;
	}
	bulk = {
		if (Zdybel.scrambled)
			return 1;
		else
			return 50;
	}

	footnote = {
		"Worst of all, they're mimics.  They constantly babble
		pseudo-language, even when nothing's around to hear
		them.  After a great infestation of Zdybel on Tel in 2112VK,
		a tremendous amount of time and money was invested in
		the complete eradication of the species.  This was almost
		entirely successful, yet a few Zdybel remain scattered
		across the galaxy, presumably having survived the years
		hidden in cargo ships, air ducts, and the like.  They
		are thought to have originated on nearby planet Irata.";
	}

	scramble = {
		if (Zdybel.scrambled) {
			"The peaceful Bedzyl is transformed into a giant
			Zdybel!";

			if (bedzyl.isin(Me)) {
				" Unfortunately, since you were
				carrying the Bedzyl at the time of
				the transformation, you are now
				squashed under the enormous Zdybel's
				weight.";

				notify(deathobject, &death, 0);
			}
			else if (bedzyl.isin(inpod)) {
				"  Unfortunately, there's not enough
				room for both you and the Zdybel in
				the little escape pod.  The Zdybel
				eats you to make more room for itself.";

				notify(deathobject, &death, 0);
			}
#ifndef	DEMO
			else if (bedzyl.isin(uptheoaktree)) {
				"  The branch you're on is too
				weak to support the weight of the
				Zdybel, and soon both you and the
				Zdybel come crashing down to the ground.
				Fortunately, the Zdybel breaks your fall.
				Unfortunately, the Zdybel then eats you.";

				notify(deathobject, &death, 0);
			}
			else if (bedzyl.isin(smallclearing)) {
				" ";

				if (Dylbez.scrambled)
					dylbez.twozdybels;
				else
					dylbez.zdybelanddylbez;

				return;
			}
#endif

			Zdybel.scrambled := nil;
			zdybel.moveto(bedzyl.location, bedzyl.locationtype);
			bedzyl.movein(nil);
		}
		else {
			"The oversized, slavering Zdybel shrivels into a
			cowering Bedzyl!";

			Zdybel.scrambled := true;
			bedzyl.moveto(zdybel.location, zdybel.locationtype);
			zdybel.movein(nil);
			bedzyl.makeknownto(Me);

			if (not Zdybel.scored) {
				Zdybel.scored := true;
				incscore(1);
			}
		}
	}
	verIoGiveto(actor) =  {
		inherited.verIoGiveto(actor);

		if (self.isin(Me))
			"You might want to put it down first.";
	}
	ioGiveto(actor, dobj) = {
		if (Zdybel.scrambled)
			"The Bedzyl zips away from you, evidently
			uninterested in your offer.";
		else {
			dobj.movein(nil);
			"The Zdybel hungrily devours "; dobj.thedesc;
			" and belches loudly thereafter.";
		}
	}

	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = {
		"\^<<self.subjthedesc>> ignores your query.";
	}

	verIoShowto(actor) = {
		if (self.isin(Me))
			"You might want to put it down first.";
	}
	ioShowto(actor, dobj) = {
		if (Zdybel.scrambled) {
			"The Bedzyl approaches you cautiously and sniffs ";
			dobj.thedesc; ".  It evidently decides it's not
			interested.";   
		}
		else {
			"The Zdybel eyes "; dobj.thedesc; " hungrily.  It
			drools a bit on your hand before you wisely jump
			back a few feet.";
		}
	}

	ZdybelMessage = [
		'"Fiddle diddle dee!  Wubba Wubba wubba," shouts the Zdybel.'
		
		'The Zdybel mumbles to itself: "Absolutive interfrastically!
		Enervactive hobnobbling?  Wheeee!"'
		
		'"Icky icky icky; woo woo agnop.  Gack gack gorny gump,"
		the Zdybel growls.'
		
		'The Zdybel threatens you with a nasty claw.  "Psssst!
		Lunch!  Lunch!  Exoculating lunch!" it raves.'
		
		'The Zdybel babbles something incoherent about gummy
		dinosaur juice.'
		
		'"Tabeyoo?  Tabeyoo?" the Zdybel seems to ask.'
		
		'The Zdybel belches loudly.  "Must be a barge coming
		through," it says with great authority.'
		
		'The Zdybel counts on its right claw.  "Quod erat digitum,"
		it says in a haughty tone.'
		
		'"Jens Brams like toms not clams," the Zdybel says
		quizzically.'
		
		'The Zdybel scratches its head.  "What is the sound
		of odorless pungent fantasies gliding fervently?" it asks
		itself.'
		
		'"What do you think I heard the story of Igdoof sitting on?"
		the Zdybel gibbers.'		
	]
	BedzylMessage = [
		'The Bedzyl sniffs your shoe and then zips away.'
		
		'The harmless little Bedzyl cowers in the shadows.'

		'The Bedzyl\'s tiny white whiskers wiggle as it
		sits on its hind legs facing you.'

		'The Bedzyl sits motionless as it eyes you suspiciously.'
		
		'The Bedzyl scampers about playfully.'
		
		'The Bedzyl seems eager to play with you, but not
		entirely sure that you won\'t eat it, stomp it, etc.'
	]

	talk = {
		local c;

		if (Zdybel.scrambled)
			c := bedzyl;
		else
			c := zdybel;

		if (c.isin(Me.location) and not c.isin(Me)) {
			P(); I();
			if (Zdybel.scrambled)
				say(self.BedzylMessage[rnd(6)]);
			else
				say(self.ZdybelMessage[rnd(11)]);
		}
	}

	//
	// Places we don't want the player to drop the Bedzyl.
	// We don't want to have to explain what happens when the
	// player turns the Bedzyl into the Zdybel in a crowded
	// place, so we just make the Bedzyl run away in these
	// places.
	//
	unsafelocations = [
		TV
		outerhall
		middlehall
		innerhall

#ifndef	DEMO
		TVaround1
		TVaround2
		TVaround3
		TVaround4
		TVaround5
		TVaround6
		TVJaxden
		TVgameroom
		TVbar
		watchmen1
		watchmen2
		watchmen3
		watchmen4
		watchlair
#endif

		barfee
		vegetables
		fruits
		flowers
		supplies

#ifndef	DEMO
		barfeelab
		bigoakjadepath
		westbank1jadepath
		westbank2jadepath
		westbank3jadepath
		hutjadepath
		outsidehut
		hut
		AtTheCenter
#endif

		underada
		dustycorridor
		airduct
		behindgrate
		barracks
		zdybelroom
		escapepod

#ifndef	DEMO
		starport
		insidefarmhouse
		livingroom
		kitchen
		hall
#endif
	]

	verDoSmell(actor) = {}
	doSmell(actor) = {
		if (Zdybel.scrambled) {
			if (self.isin(Me))
				"It smells vaguely rodent-like.";
			else
				"You can't get close enough to the 
				Bedzyl to smell it -- whenever you 
				try, it runs away.";
		}
		else
			"It's clear that the Zdybel smells like rotting
			garbage (or worse), even from a safe distance.";
	}
	verDoRub(actor) = {
		if (Zdybel.scrambled) {
			if (self.isin(Me))
				"The Bedzyl, though clearly still 
				very afraid of you, seems to enjoy 
				being rubbed and petted.  You get a 
				warm fuzzy feeling inside when you 
				touch it.";
			else 
				"You can't get close enough to the 
				Bedzyl to do that.";
		}
		else
			"Surely you jest.  The Zdybel would rip your arm off
			and eat it for an appetizer.";
	}
	verDoPlay(actor) = {}
	doPlay(actor) = {
		if (Zdybel.scrambled) {
			"You reach out, eager to play with the Bedzyl.
			Still wary of you, it leaps just out of your
			grasp.";
		}
		else {
			"If you get close enough to the Zdyel to
			play with it, it'll likely rip your head off.";
		}
	}
	verDoAttackwith(actor, io)  = {
		if (self.isin(Me))
			"You might want to put it down first.";
	}
	doAttackwith(actor, io) = {
		if (io = raygun)
			"I'm afraid you'll have to be a bit more specific.";
		else {
			caps(); io.thedesc; " doesn't seem to do much 
			damage to "; self.thdesc; ".";
		}
	}
	verDoTake(actor) = {
		Outhide(true);
		inherited.verDoTake(actor);
		if (Outhide(nil)) {
			inherited.verDoTake(actor);
			return;
		}

		if (self.isin(actor))
			return;
			
		if (Zdybel.scrambled) {
			if (not Me.stimulant) {
				"You reach down to snatch the little 
				Bedzyl, but the tiny creature is too 
				quick for you. It scurries away and 
				cowers in the corner for a few 
				minutes before working up the courage 
				to emerge from the shadows again.";
			}
		}
		else {
			"The fearsome Zdybel would surely kill you
			if you got close enough to it to grab it.  Please
			do get a grip on the gravity of the situation.";
		}
	}
	doTake(actor) = {
		"In your hyperstimulated state you find that the Bedzyl is no
		match for your razor-sharp reflexes. You whisk the little
		animal off the ground in an eye-blink.";

		self.movein(Me);
		if (not Zdybel.beentaken) {
			Zdybel.beentaken := true;
			incscore(3);
		}
	} 

	verDoTakeout(actor, io) = {
		inherited.verDoTakeout(actor, io);
		self.verDoTake(actor);
	}
	verDoDrop(actor) = {
		inherited.verDoDrop(actor);
	}
	doDrop(actor) = {
		if (find(self.unsafelocations, Me.location) = nil) {
			"You move to set the Bedzyl down gently, but it 
			squirms out of your grasp and leaps away before you 
			get the chance. Tenacious little guy, isn't he?";

			Outhide(true);
			inherited.doDrop(actor);
			Outhide(nil);
#ifndef	DEMO
			if (not Me.isin(smallclearing))
				incscore(-1);
#endif
		}
		else {
			"The little Bedzyl hits the ground running.
			Before you can scoop it back up again, it
			scurries off, intoxicated with its new
			freedom.";

			self.movein(nil);
		}
	}
	verDoPutX(actor, io, loctype) = {
		if (self.isin(Me)) {
			"If you try to put the little Bedzyl in
			<<io.objthedesc(actor)>>, the animal will probably
			squirm out of your grasp.";
		}
		else
			inherited.verDoPutX(actor, io, loctype);
	}
	verDoMove(actor) = {
		if (Zdybel.scrambled)
			"Moving the Bedzyl doesn't seem productive.";
		else
			"You got a death wish or something?";
	}

	verDoSpraywith(actor, io) = {}
	doSpraywith(actor, io) = {
		if (Zdybel.scrambled)
			"\^<<self.subjthedesc>> seems unaffected.";
		else {
			"\^<<self.subjthedesc>> lets out a blood-curdling
			scream and gets even madder than before.";
		}
	}
;
zdybel: Zdybel
	noun = 'zdybel' 'vermin' 'creature' 'animal'
		'monster' 'pest' 'beast' 
	adjective =	'hideous' 'horrible' 'disgusting' 'giant' 'large'
			'oversize' 'oversized'  'emetic'
	location = zdybelroom
;
bedzyl: Zdybel
	noun = 'bedzyl' 'creature' 'animal' 'beast' 
	adjective =	'cute' 'little' 'tiny' 'furry' 'friendly'
			'timid' 'small'
;
zdybelwalls: Decoration
	sdesc = "walls"
	ldesc = {
		"The walls are covered with splotches that look
		like dried blood.  There are chunks taken out of
		the walls here and there, and bite marks all around.";
	}
	noun = 'walls' 'splotches' 'marks' 'wall'
	adjective = 'red' 'green' 'fang' 'bite'
	location = zdybelroom
;
zdybelladder: Distant
	sdesc = "ladder"
	noun = 'ladder'
	location = zdybelroom
;
zdybelbay: Distant
	sdesc = "escape pod bay"
	ldesc = {
		"It's too far away to make out specific features.";
	}
	noun = 'bay' 'pod' 'pods'
	adjective = 'escape' 'pod'
	location = zdybelroom
;
escapepod: Room
	noun = 'bay'
	adjective = 'escape' 'pod' 'docking'

	sdesc = "Escape Pod Docking Bay"
	ldesc = {
		I(); "The metal corridor widens into a large open area
		here, where you can see several escape pod landing/launching
		bays in the western wall. The pods are, you assume, meant
		for use during emergencies when the matter movers are
		down or unsafe. At the moment ";
		
		if (ESCAPEPODpod.isin(nil))
			"all the pods are gone,";
		else
			"all the pods but one are gone,";

		" and ";

		escapepodglass.lookthrough; P();

		I(); "A metal corridor leads east.";
	}
	east = zdybelroom
	west = { return self.in; }
	in = {
		if (ESCAPEPODpod.isin(nil)) {
			"All the pod bays are empty!";
			return nil;
		}
		else {
			ESCAPEPODpod.doBoard(Me);
			return nil;
		}
	}
;
class ESCAPEPODdecoration: Decoration location = escapepod ;
escapepodglass: ESCAPEPODdecoration
	sdesc = "glass"
	ldesc = "There's nothing unusual about the glass."
	noun = 'glass' 'window'
	adjective = 'escape' 'pod' 'glass'
	
	verDoLookthrough(actor) = {}
	doLookthrough(actor) = {
		"\^<<self.lookthrough>>";
	}
	lookthrough = {
		"through the glass guarding the empty bays you can see
		an incredible spectacle:  absolute blackness streaked with
		dusty plumes, like the frozen crests of breaking waves, and
		textured with varying densities of white-bright points that
		create a fantastic continuum of grays.  And, you reflect
		for a moment, only a few centimeters of clear glass separate
		you from what feels like the whole of creation.";
	}
;
escapepodscenery: Distant, ESCAPEPODdecoration
	sdesc = "space"
	ldesc = {
		escapepodglass.doLookthrough(Me);
	}
	noun = 'space' 'spectacle' 'blackness' 'plumes' 'crests' 'waves'
		'densities' 'textures' 'points' 'continuum' 'grays' 'greys'
	adjective = 'incredible' 'absolute' 'dusty' 'frozen' 'breaking'
		'white' 'white-bright' 'bright' 'fantastic'

;
ESCAPEPODpod: ESCAPEPODdecoration
	sdesc = "escape pod"
	ldesc = {
		"The one remaining escape pod sits quietly in its bay,
		evidently ready for launch.  It fits snugly in the circular
		hole in the wall designed for it, and hence you can only tell
		that it's roughly spherical and has a person-sized entrance
		at floor level for boarding.";
	}
	noun = 'pod' 'pods'
	adjective = 'escape' 'remaining' 'docked' 'emergency'

	verDoBoard(actor) = {}
	doBoard(actor) = {
		"You step inside the escape pod...\b";
		Me.travelto(inpod);
	}
	verDoEnter(actor) = {}
	doEnter(actor) = { self.doBoard(actor); }
	verDoGetin(actor) = {}
	doGetin(actor) = { self.doBoard(actor); }
;
ESCAPEPODbays: ESCAPEPODdecoration
	sdesc = "escape pod landing/launching bays"
	ldesc = {
		if (ESCAPEPODpod.isin(nil))
			"They're all empty.";
		else
			"All the bays but one are empty.";
	}
	noun = 'bay' 'bays'
	adjective = 'landing' 'launching' 'landing/launching' 'escape' 'pod'
	
	verDoCount(actor) = {}
	doCount(actor) = { "There are three bays."; }
	verDoEnter(actor) = {
		if (ESCAPEPODpod.isin(nil))
			"That's going to be pretty difficult since
			there aren't any escape pods left.";
		else
			"Try entering the pod itself.";
	}
;
inpod: Room
	noun = 'pod'
	adjective = 'inside' 'escape'

	launched = nil
	landed = nil
	state = 0
	sdesc = "Inside the Escape Pod"
	ldesc = {
		I(); "You are standing inside the escape pod.   The interior
		is spartan, lacking even seats and tables, and it's barely
		big enough to hold several people.  The only control seems to
		be a big red button marked \"LAUNCH.\"";

		P(); I();
		INPODglass.ldesc;
	
		if (self.landed) {
			P(); I();
			"The pod exit is to the south.";
		}
	}
	out = {
		INPODpod.doExit(Me);
		return nil;
	}
	south = { return self.out; }

	spacetravel = {
		self.state := self.state + 1;
		
		if (self.state = 1) {
			P(); I(); 
			"The course correction jets kick in, and the pod
			stops spinning about wildly.  You regain your 
			balance.";
		}
		else if (self.state = 2) {
			P(); I();
			"The engines really begin to roar as the pod
			accelerates.";

			INPODenginenoise.loud := true;
		}
		else if (self.state = 4) {
			P(); I();
			"The pod quiets some as it reaches what is
			presumably cruising velocity.";
			
			global.colorspace := '';
		}
		else if (self.state = 5) {
			P(); I(); 
			"The light is nearly blinding as the pod
			briefly turns toward Val, the star that has
			warmed the homeworld Tode and the other populated
			planets in this system for millennia.";
		}
		else if (self.state = 7) {
			P(); I();
			"Far in the distance you see a tiny orange dot,
			just larger than a star.  It grows bigger and
			bigger -- you seem to be headed straight for it.";
		}
		else if (self.state = 8) {
			P(); I();
			"Moments later, the dot has become a fist-sized
			ball.  You are approaching it at an incredible
			speed.";
						
			global.colorspace := 'Spring Green';
		}
		else if (self.state = 9) {
			P(); I();
			"A giant orange sphere now fills your entire
			view.  You're about to crash land on a 
			distant planet!";
		}
		else if (self.state = 10) {
			P(); I();
			"Your little craft plunges through the orange
			planet's atmosphere and hurtles towards the ground
			below.  Cabin heat becomes nearly unbearable as
			you decelerate, and you're being thrown about
			like a pet's chew toy.";
		}
		else if (self.state = 11) {
			P(); I(); 
			"Though the pod is slowing down at an almost
			alarming rate, the ground is still approaching
			faster than you can believe.  This looks like
			the end!"; P(); 
			
			I();  "A formerly invisible readout next to the launch
			button flashes,

				\"Standby to land on the planet Irata.\"";
						
			global.planet := 'Irata';
		}
		else if (self.state = 12) {
			P(); I();
			"The pod plunges through a dense forest of blue-green
			trees.  You cover your eyes and hope for the best.
			Miraculously, you survive unscathed, though quite
			dizzy and a bit queasy from the hundred or so 
			barrel rolls the pod must have made once it touched
			down.  The door slides open silently.";
			
			unnotify(self, &spacetravel);
			self.landed := true;
			ESCAPEPODpod.movein(nil);
			INPODenginenoise.loud := nil;
			
#ifdef	DEMO
			enddemo();
#endif
		}
	}

	//
	// Don't list engine noise in room description -- only
	// when the player types "listen".
	//
	incontentslistedsound(obj) = {
		return nil;
	}
;
class INPODdecoration: Decoration location = inpod ;
INPODpod: INPODdecoration
	sdesc = "escape pod"
	ldesc = { inpod.ldesc; }

	noun = 'pod'
	adjective = 'escape' 'remaining' 'docked' 'emergency'

	verDoBoard(actor) = {}
	doBoard(actor) = {
		"You're already inside the pod!";
	}
	verDoEnter(actor) = {}
	doEnter(actor) = { self.doBoard(actor); }
	verDoExit(actor) = {}
	doExit(actor) = {
		if (inpod.landed) {
#ifndef	DEMO
			"You clamber out of the escape pod...\b";
			Me.travelto(landingarea);
#endif
		}
		else if (inpod.launched) {
			"That's going to be pretty unpleasant now that
			you're hurtling through space.  There's also the
			problem of getting the door open.  Perhaps you
			should condider another plan of action.";
		}
		else {
			"You step out of the pod and into the bay...\b";
			Me.travelto(escapepod);
		}
	}
;
INPODbutton: Button, INPODdecoration
	warned = nil

	sdesc = "launch button"
	ldesc = {
		"It's just a big red button with the word \"LAUNCH\"
		embossed on it.";
	}
	noun = 'button' 'panel' 'controls'
	adjective = 'big' 'red' 'launch' 'escape' 'pod' 'control'

	doPush(actor) = {
		if (inpod.launched or inpod.landed)
			"Nothing happens.";
		else {
 			if (not self.warned) {
				warnsave(); 
				self.warned := true;
			}
			
			"The escape pod's engines spring to life!  You are
			thrown against the now-closed metal entrance door
			as the craft rockets away from the Yooniversity
			Dwelling Site and into space on an unknown (to
			you, at least) course.  You can see the tiny blue
			planet Frost disappear in the distance as you look
			through the top of the spinning pod.";
			
			inpod.launched := true;
			notify(inpod, &spacetravel, 0);
			
			global.planet := '';
		}
	}
;
INPODglass: INPODdecoration
	sdesc = "glass canopy"
	ldesc =  {
		if (inpod.landed) {
			"The top and front of the pod are badly
			mangled.  The transparent material you thought
			was glass is evidently something else -- it has
			crumpled just like the metal.";
		}
		else {
			"The top and front of the spherical pod are made
			of glass.  This affords you a spectacular view of
			space.";
		}
	}
	noun = 'top' 'front' 'glass' 'canopy' 'window' 'material' 'space'
	adjective = 'pod' 'glass' 'damaged' 'mangled' 'transparent'

	verDoLookthrough(actor) = {}
	doLookthrough(actor) = {
		if (inpod.landed)
			"You can tell by looking through the escape
			pod's canopy that you're in a small clearing.";
		else
			"Looking through the glass canopy rewards you
			with a spectacular view of space.";
	}
;
INPODenginenoise: Listablesound, Decoration
	loud = nil
	islistablesound(actor) = { return self.loud; }

	//
	// Always name this in room descriptions, even though it's
	// never listed visually.  (I.e., say "The engines are
	// roaring." instead of "Some things are roaring."
	//
	alwaysname(actor) = { return true; }

	isplural = true
	sdesc = "engines"
	ldesc = {
		"You can't see the pod engines";

		if (self.loud)
			", but the noise they're making is nearly deafening";

		".";
	}
	noun = 'engines'
	location = inpod

	listlistendesc = {
		if (self.loud)
			"are roaring.";
		else
			"aren't making any noise, as far as you can tell.";
	}
	listendesc = { "The engines <<self.listlistendesc>>"; }
;

#ifndef	DEMO

landingarea: Outside
	noun = 'pod' 'wreckage'
	adjective = 'outside' 'escape' 'pod' 

	sdesc = "Outside the Escape Pod Wreckage"
	ldesc = {
		I(); "You are in the middle of a clearing at the site
		of your crash landing.  The escape pod lies to the north,
		and is still intact, though very badly damaged."; P();
		
		I(); "Dense forest surrounds this little area, though 
		it looks like you might be able to make some progress 
		through the woods to the east, northwest, and south.  
		Passage along other routes looks very unlikely.";
	}
	north = { return self.in; }
	in = { LANDINGAREApod.doBoard(Me); return nil; }
	east = sketchcrash
	nw = smallclearing
	south = fence2
;
class LANDINGAREAdecoration: Decoration location = landingarea ;
irataforest: floatingdecoration
	sdesc = "forest"
	ldesc = {
		"The forest is all around you.  The trees here have
		grown strangely close together.";
	}
	noun = 'forest' 'trees' 'tree' 'woods' 'foliage'
	adjective = 'thick' 'dense'
	loclist = [
		landingarea fence1 fence2 sketchcrash smallclearing
		surveystation
	]
;
LANDINGAREApod: LANDINGAREAdecoration
	sdesc = "crashed escape pod"
	ldesc = {
		"The escape pod is in bad shape -- it's a wonder you
		survived the landing.  The once spherical craft is now
		flat on one side, the metal crumpled up like tin foil.";
	}
	noun = 'pod'
	adjective = 'escape' 'crashed' 'emergency' 'crumpled' 'damaged'

	verDoBoard(actor) = {}
	doBoard(actor) = {
		"You step inside the crumpled escape pod...\b";
		Me.travelto(inpod);
	}
	verDoEnter(actor) = {}
	doEnter(actor) = { self.doBoard(actor); }
;
//
// The fences are red herrings -- you can't cross them
//
class fenceroom: Outside
	sdesc = "At a Tall Fence"
	ldesc = {
		I(); "Your way south is blocked by a very tall fence. 
		You notice a loud humming sound here.  It seems to be 
		coming from the fence."; P();

		I(); "Thick forest surrounds you -- you can head back 
		north, but it doesn't look like you'll make much 
		progress going any other way.";
	}
	up = {
		"You'll have to climb the fence.";
		return nil;
	}

	//
	// Don't list humming sound in room descriptions -- only
	// when the player types "listen".
	//
	incontentslistedsound(obj) = { return nil; }
;
fence2: fenceroom
	north = landingarea
	south = {
		fencedecoration.doClimb(Me);
		return nil;
	}
;
fencedecoration: floatingdecoration, Listablesound
	sdesc = "fence"
	ldesc = {
		"It just looks like an ordinary fence, except that
		it's very tall.  It's making a humming noise.";
	}
	noun = 'fence'
	adjective = 'tall'
	loclist = [fence1 fence2 camelfield]

	listlistendesc = {
		"is humming loudly.";
	}
	listendesc = {
		"The fence is humming loudly.";
	}

	verDoClimb(actor) = {}
	doClimb(actor) = {
		"You grab the fence in order to scale it, but
		are immediately electrocuted.";

		notify(deathobject, &death, 0);
	}
	verIoThrowat(actor) = {}
	ioThrowat(actor, dobj) = {
		if (dobj = bedzyl) {
			caps(); dobj.thedesc; " squeals as you toss 
			it.  There is a bright flash and then a cloud 
			of smoke as the creature hits the fence.";

			dobj.movein(nil);
			incscore(-1);
		}
		else {
			caps(); dobj.thedesc; " hits the fence and 
			there is a loud <ZAP> and a shower of 
			sparks.";

			dobj.movein(Me.location);
		}
	}
	verDoTouch(actor) = {}
	doTouch(actor) = {
		"You touch the fence and are instantly electrocuted.";


		notify(deathobject, &death, 0);
	}
	verDoLick(actor) = {}
	doLick(actor) = {
		"You touch your tongue to the fence and are instantly 
		electrocuted.";

		notify(deathobject, &death, 0);
	}
;

//
// The fearsome Dylbez is here!
//
smallclearing: Outside
	noun = 'clearing'
	adjective = 'small' 'dylbez'

	sdesc = "In a Small Clearing"
	ldesc = {
		I(); "You are standing in a small clearing in the 
		middle of a dense forest.  The tall grass here 
		tickles your ankles and sways in a light breeze. A 
		dirt road leads north.  Passage through the forest 
		looks difficult, but you could probably make your way 
		south.  You can also head southeast, back to where 
		you crash landed earlier.";

		if (dylbez.isin(self) or zdybel2.isin(self)) {
			P(); I();
			if (Dylbez.scrambled)
				"A ferocious Zdybel blocks your way north!";
			else
				"A fearsome Dylbez blocks your way north!";
		}
	}
	south = fence1
	north = {
		if (dylbez.isin(self) or zdybel2.isin(self)) {
			"The "; dylbez.sdesc; " blocks your way!";
			return nil;
		}
		else
			return surveystation;
	}
	se = landingarea
;
dirtroad: floatingdecoration
	sdesc = "dirt road"
	noun = 'road'
	adjective = 'dirt'
	loclist = [smallclearing surveystation]
;
tallgrass: Decoration
	sdesc = "tall grass"
       	ldesc = {
		"The grass is lime green -- not a variety you
		have on your native Tode.";
	}
	noun = 'grass'
	adjective = 'tall' 'lime' 'green'
	location = smallclearing
;
class Dylbez: Actor
	scrambled = nil
	scored = nil

	sdesc = {
		if (Dylbez.scrambled)
			"hideous Zdybel";
		else
			"ferocious Dylbez";
	}
	ldesc = {
		if (Dylbez.scrambled) {
			"This Zdybel is much like the one you saw
			earlier, only it's bigger and more disgusting.
			(Which is a pretty neat trick.)";
		}
		else {
			I(); "The Dylbez is a fearsome beast, three 
			times as tall as a man and stronger than 
			twenty.  These giant two-headed bears are 
			found only on Irata, and with good reason: no
			one has ever been able to capture one and 
			leave Irata alive."; P();

			I(); "The Dylbez attacks swiftly and viciously,
			by grabbing its victim with its powerful claws
			and then hugging it to death.  Don't mess with
			this fellow, OK?";
		}
	}

	islistable(actor) = { return nil; }
	actordesc = {}

	scramble = {
		if (Dylbez.scrambled) {
			"The slavering Zdybel is transformed into a 
			fearsome Dylbez!";

			Dylbez.scrambled := nil;
			dylbez.moveto(zdybel2.location, zdybel2.locationtype);
			zdybel2.movein(nil);
		}
		else {
			"The fearsome Dylbez is transformed into a
			horrible Zdybel!";

			if (zdybel.isin(smallclearing))
				self.twozdybels;

			Dylbez.scrambled := true;
			zdybel2.moveto(dylbez.location, dylbez.locationtype);
			dylbez.movein(nil);
			zdybel2.makeknownto(Me);
		}
	}
	verIoGiveto(actor) =  {}
	ioGiveto(actor, dobj) = {
		if (Dylbez.scrambled) {
			dobj.movein(nil);
			"The Zdybel hungrily devours "; dobj.thedesc;
			" and belches loudly immediately thereafter.";
		}
		else {
			"You can't (sanely) get close enough to the 
			beast to give it anything.";
		}
	}

	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = {
		"\^<<self.subjthedesc>> pays no attention.";
	}

	verIoShowto(actor) = {}
	ioShowto(actor, dobj) = {
		if (Dylbez.scrambled) {
			"The Zdybel eyes "; dobj.thedesc; " hungrily.  It
			drools a bit on your hand before you wisely jump
			back a few feet.";
		}
		else {
			"You'd have to be totally insane to get that 
			close to this monster.";
		}
	}

	DylbezMessage = [
		'The Dylbez prepares to rush you, and then decides
		against it.'

		'The Dylbez wanders about in a circle inexplicably.'

		'The Dylbez nearly deafens you with a growl.'

		'The Dylbez eyes you hungrily.'

		'The Dylbez comes a step closer to you.'

		'The Dylbez snorts.'

		'The Dylbez bumps its heads together and grimaces.'

		'One of the Dylbez\'s heads is startled by and growls
		at the other head.'
	]

	ZdybelMessage = [
		'"Fie, fie, fie on it, and fum too!" screams the Zdybel.'

		'The Zdybel turns to you and says, "Thanks, Alex. 
		What would I like to take \'The Letter X\' for 200?"'

		'"Zoop zoopy doop. Strrrrrrignorf," the Zdybel growls.'

		'The Zdybel draws a circle in the air with an
		outstretched claw. "Wind a string around that!" it raves.' 

		'The Zdybel gibbers on about fungus.'
		
		'"Shhhhhh," the Zdybel whispers, "The snork!"'

		'The Zdybel scratches its head and yells, "Eureka!"'
		
		'The Zdybel sings a lyric: "What a Noooooble man
		was Strickland..."'

		'The Zdybel babbles, "Ku ulert hank uule stia miam."'
		
		'"To be..." the Zdybel says dramatically, "or to ben\'t."'
	]

	talk = {
		local c;

		if (Dylbez.scrambled)
			c := zdybel2;
		else
			c := dylbez;

		if (c.isin(Me.location)) {
			P(); I();
			if (Dylbez.scrambled)
				say(self.ZdybelMessage[rnd(10)]);
			else
				say(self.DylbezMessage[rnd(8)]);
		}
	}

	verDoSmell(actor) = {}
	doSmell(actor) = {
		if (Dylbez.scrambled) {
			"It's clear that the Zdybel smells like rotting
			garbage (or worse), even from a safe distance.";
		}
		else {
			"You can't smell it at all from a safe distance.";
		}
	}
	verDoRub(actor) = {
		if (Dylbez.scrambled) {
			"Surely you jest.  The Zdybel would rip your arm off
			and eat it for an appetizer.";
		}
		else {
			"You have lost your mind.";
		}
	}
	verDoAttackwith(actor, io)  = {}
	doAttackwith(actor, io) = {
		if (io = raygun)
			"I'm afraid you'll have to be a bit more specific.";
		else {
			caps(); io.thedesc; " doesn't seem to do much 
			damage to "; self.thdesc; ".";
		}
	}
	verDoTake(actor) = {
		"The fearsome beast would surely kill you if you got 
		close enough to it to grab it. Please do get a grip 
		on the gravity of the situation.";
	}
	verDoMove(actor) = {
		"You got a death wish or something?";
	}

	zdybelanddylbez = {
		P();

		"The two horrific beasts face each other and bristle. 
		The air is at once electrified with their mutual 
		hatred, and in an eye-blink they are upon each other. 
		After a terrible struggle, the Dylbez emerges 
		victorious.  It eats the Zdybel whole as a reward.";

		zdybel.movein(nil);
		bedzyl.movein(nil);

		incscore(-1);
	}

	twozdybels = {
		P();

		"The Zdybels look at each other fiercely for a 
		moment, both ready to mount a vicious attack. But 
		then they gaze longingly into each other's eyes as 
		they discover they are two of a kind. They soon rush 
		into each other's arms and scamper off into the 
		forest, claw in claw.";

		dylbez.movein(nil);
		zdybel.movein(nil);
		bedzyl.movein(nil);
		zdybel2.movein(nil);

		incscore(4);

		Dylbez.scored := true;
	}

	verDoSpraywith(actor, io) = {}
	doSpraywith(actor, io) = {
		"\^<<self.subjthedesc>> howls and runs around in
		circles.  Beyond that, your attack seems to have
		had little effect.";
	}
;
dylbez: Dylbez
	noun = 'dylbez' 'creature' 'animal'
		'monster' 'beast' 'bear'
	adjective = 'hideous' 'horrible' 'giant' 
		'large' 'oversize' 'oversized' 'huge' 'big'
		'ferocious'
	location = smallclearing
;
zdybel2: Dylbez
	noun = 'zdybel' 'vermin' 'creature' 'animal'
		'monster' 'pest' 'beast' 'bigger'
	adjective =	'hideous' 'horrible' 'disgusting' 'giant' 'large'
			'oversize' 'oversized'  'emetic' 'more'
;
//
// Fence room.   Red herring -- no way to climb over fence
//
fence1: fenceroom
	north = smallclearing
	south = {
		fencedecoration.doClimb(Me);
		return nil;
	}
;
//
// Matter mover is here
//
surveystation: Outside
	noun = 'station'
	adjective = 'survey'

	sdesc = "Survey Station"
	ldesc = {
		I(); "You are standing in the middle of a narrow dirt 
		road in front of a small survey station.  You assume 
		that the station is used to monitor the frequent 
		mining operations here on Irata.  A light on top of 
		the station is blinking ";

		if (SSmover.accepting)
			"green.";
		else
			"red.";

		P();

		I(); "The station entrance is to the north -- the
		road ends here --  but you can travel south 
		on it. Passage in other directions looks unlikely -- 
		the forest is too dense.  There is, however, a matter 
		mover next to the station.";
	}
	south = smallclearing
	in = insurveystation
	north = { return self.in; }
;
SSlight: Decoration
	sdesc = "survey station light"
	ldesc = {
		"The light is blinking ";
		if (SSmover.accepting)
			"green.";
		else
			"red.";
	}
	noun = 'light' 
	adjective = 'survey' 'blinking' 'station' 'red' 'green'
	location = surveystation
;
SSdecoration: Decoration
	sdesc = "survey station"
	ldesc = {
		"Why don't you go in for a better look?";
	}
	noun = 'station'
	adjective = 'survey'
	location = surveystation

	verDoEnter(actor) = {}
	doEnter(actor) = { Me.travelto(insurveystation); }
;
SSmover: mattermover
	location = surveystation
	doEnter(actor) = {
		//
		// hackola to prevent player from leaving without
		// meeting Timon.
		//
		if (not sketch.met) {
			"Strangely, nothing happens when you 
			enter the mover.  Must be a freak
			breakdown.";

			return;
		}

		if (self.checkaddr(actor) = nil)
			return;


		if (sketch.location <> nil) {
			I(); "You bid Timon a fond farewell as you step
			into the matter mover.  He looks up from
			playing his latest tune and thanks you
			for activating the mover."; P();

			I(); "\"I woulda never gotten off this rock
			alive without you, man.  I owe you one.  Good
			luck savin' the galaxy,\" he says, \"and be sure
			to look up the Watchmaker, but be careful on
			New Hell -- it gets rough sometimes.  Oh, and
			one more thing -- watch for my latest tune;
			I think you'll like it.\" Timon Sketch is
			definitely a man with clear priorities."; P();

			Me.travelhook -= [sketch, &follow];
			sketch.wrotesong := true;
			sketch.movein(nil);
		}

		inherited.doEnter(actor);
	}

	accepting = { return surveyswitch.isactive; }
	sending = { return self.accepting; }

	address = {
		"This mover's address is (0, 10000, 4950) -- 
		colorspace Spring Green.";
	}

	/*
	 * This mover's coordinates
	 */
	ar = 0
	ag = 10000
	ab = 4950
	
	/*
	 * This mover's dials
 	 */
	r = SSred
	g = SSgreen
	b = SSblue

	colorspace = 'Spring Green'
	system = 'Val'
	planet = 'Irata'
;

SSgreen: greendial	setting = 0	location = surveystation;
SSblue: bluedial	setting = 0	location = surveystation;
SSred: reddial 		setting = 0	location = surveystation;

//
// Inside the survey station
//
insurveystation: Room
	noun = 'station'
	adjective = 'inside' 'survey'

	sdesc = "Inside the Survey Station"
	ldesc = {
		I(); "You are looking around the inside of the survey 
		station.  There's not much here apart from some maps 
		and charts -- it doesn't look like the station has 
		been used in quite some time.  There is a switch on
		the wall labeled \"Mover.\" ";

		surveyswitch.ldesc;
	}
	out = surveystation
	south = { return self.out; }
;
surveyswitch: Switch, Readable
	sdesc = "switch"
	isactive = nil
	ldesc = {
		"The switch is currently ";
		if (self.isactive)
			"on";
		else
			"off";
		".";
	}
	readdesc = { "The switch is labeled \"Mover.\""; }
	noun = 'switch'
	adjective = 'matter' 'mattermover' 'mover'
	location = insurveystation
;
surveymapscharts: Readable, Decoration
	isplural = true
	sdesc = "maps and charts"
	adesc = { self.sdesc; }
	ldesc = {
		"They're just routine mining reports.  Nothing
		exciting.";
	}
	readdesc = { self.ldesc; }
	noun = 'maps' 'charts' 'map' 'chart' 'reports'
	adjective = 'mining'
	location = insurveystation

	verDoTake(actor) = { "They're of no use to you."; }
;

//
// Where Timon Sketch crash landed
//
triangle: Item		// this gets Gavin an audience with the Watchmaker
	firstseen = true

	sdesc = "tiny triangular pink circuit board"
	ldesc = {
 		if (self.firstseen) {
			self.firstseen := nil;
			watchmenmover.ar := 980 + rnd(50);
			watchmenmover.ag := 980 - rnd(50);
			watchmenmover.ab := 4392 + rnd(50);
			watchmenmover.accepting := true;
		}
		
		"You can't tell exactly what it is, but you figure 
		that it must store some kind of information.  There 
		are mover coordinates on the back of the device:"; P();

		"\t Midnight Blue (+";
			say(watchmenmover.ar - 980);
	        ", -";
			say(980 - watchmenmover.ag);
		", +";
			say(watchmenmover.ab - 4392);
		")";
	}
	noun = 'triangle' 'circuit' 'board' 'device'
	adjective = 'tiny' 'pink' 'triangular' 'circuit'
	location = nil
;
sketchcrash: Outside
	noun = 'site'
	adjective = 'another' 'sketch' 'crash'

	firsttime = true
	
	sdesc = "Another Crash Site"
	ldesc = {
		if (self.firsttime) {
			self.firsttime := nil;
			sketchtransition.transition;
			Me.travelhook += [sketch, &follow];
		}

		I(); "You're walking about a small clearing amidst 
		the wreckage of Timon Sketch's ship.  Dense forest 
		surrounds you on all sides.  It looks like you might 
		be able to beat a path through the foliage to the 
		north and south.  Head west and you're back at your 
		own crash site.";
	}
	west = landingarea
	north = {
		"You fight your way through the forest up a steep
		slope.  After a long struggle, you find yourself..."; P();

		return cliff;
	}
	east = abandonedretreat
	south = camelfield
;
sketchwreckage: Decoration
	sdesc = "wreckage from Timon Sketch's ship"
	ldesc = {
		"There's nothing left of Timon Sketch's ship
		but twisted pieces of machinery scattered everywhere.";
	}
	noun = 'ship' 'wreckage' 'pieces' 'machinery' 'site'
	adjective = 'timon' 'sketch\'s' 'twisted' 'scattered'
	location = sketchcrash
;

//
// Timon Sketch himself
//
sketch: Male, Actor
	met = nil 	// has player met him yet?
	wrotesong = nil	// written song about Gavin yet?
	
	sdesc = "Timon Sketch"
	isdetermined = true

	ldesc = {
		"Timon Sketch is a wiry fellow with long hair
		that seems to have a mind of its own.  From
		the looks of it, he often becomes totally 
		absorbed in playing his synthesizer, thereby
		remaining oblivious to the world around him.";
	}
	noun = 'sketch' 'timon'
	adjective = 'timon'
	location = sketchcrash

	//
	// Installed by code in "Another Crash Site" above.
	//
	follow(actor, oldloc, oldloctype, newloc, newloctype) = {
		P(); "(Timon Sketch follows you.)"; P();
		self.moveto(newloc, newloctype);
	}

	actorAction(v, d, p, i) = {
		if (v = helloVerb) {
			"\"What's up.\"";
		}
		else if (v = followVerb) {
			"He's already following you!";
		}
		else
			"Timon seems less than interested in taking
			explicit orders from you.";

		exit;
	}

	Message = [
		'Timon Sketch is here, playing a mind-numbing
		tuba solo on his SoundSquasher X-1000.'

		'Timon Sketch presses a button and his synthesizer
		makes an awful squawking noise.  He mashes down
		a lot of the keys and it stops.'

		'Timon Sketch plays a catchy melody.'

		'Timon Sketch mumbles lyrics to himself while
		playing a tune on a kazoo patch.'

		'Timon Sketch programs his keyboard for a new
		backing rhythm.'

		'Timon Sketch plays a screaming guitar solo
		with his feet.'

		'Timon Sketch plays an ever-ascending pattern
		on the keyboard until he finally runs out of 
		keys and begins playing air.'

		'Smiling as he gets his "watermelon dropped
		from high above" patch just right, Timon Sketch
		begins an inspired solo.'

		'Timon Sketch plays a few bars of the hit song
		"I Want a Girl with Green Hair and Horns."'

		'Timon Sketch plays a few bars of the classic
		tune "Aerobics."'

		'Timon Sketch plays the chorus of "I Suck."'
		
		'Timon Sketch plays the chorus of "You Suck."'

		'Timon Sketch starts and stops playing the same
		melody a dozen times, then smashes all the keys
		down in a frustrated frenzy.'

		'Timon Sketch begins to sing: "Igdoof ... Nothing
		more than ... Igdoof..."'

		'Timon Sketch places his nose on middle C while
		playing a contrapuntal fantasy with both hands.'

		'Timon Sketch mutters about new song ideas.'

		'Timon Sketch urges you to sell your digital
		Melodiwafer-based stereo system and buy an
		antique turntable.  "Analog sound is so much more
		palpable," he says.'
	]

	actordesc = { 
		say(self.Message[rnd(length(self.Message))]);
	}

	verIoGiveto(actor) =  {}
	ioGiveto(actor, dobj) = {
		"\"Dude, I don't really need that,\" Timon explains.";
	}

	verDoTellabout(actor, io) = {}
	doTellabout(actor, io) = {
		if (io = akmi) {
			"\"Yeah, they're scumbags.  Akmi sux.  I'd
			write a tune about 'em if I thought I could
			get away with it.  But they got spies	
			*everywhere*,\" he says.";
		}
		else if (io = virus) {
			"\"Man, we better do something!\" Timon
			exclaims.  But he has little advice to offer.";
		}
		else {	
			"\"Whoa,\" Timon says, feigning interest.";
		}
	}

	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = {
		if (io = synth)
			"\"It's a totally killer synth.  The best.
			I take it with me wherever I go.\" Timon says.";
		else if (io = akmi)
			"\"Akmi's got serious underground connections.
			I wouldn't mess with them unless somebody's
			got your back.\" he warns.";
		else if (io = watchmaker)
			"\"The Watchmaker?\" he asks rhetorically.
			\"I'm not sure you two will get along at first,
			but you have to believe me when I say the
			Watchmaker's really good at heart.  Watch is just
			misunderstood.\"";
		else if (io = watchworkers) // i.e., "watchmen"
			"\"The Watchmen work like clockwork -- they
			follow the Watchmaker's every order.  It's almost
			like they're machines or something.  And they 
			never complain.  But sometimes I wonder if, in
			their hearts, they really resent Watch for it.
			They don't have much choice but to work for
			Watch out there on New Hell,\" he says ruefully.
			\"People don't like people like them.\"";
		else
			"Timon doesn't seem to have much of an opinion
			on that.";
	}
	
	ioShowto(actor, dobj) = { self.doAskabout(actor, dobj); }

	doSmell(actor) = { "He smells like a gnooby."; }
	verDoRub(actor) = { "Keep your mitts to yourself, pal."; }
	verDoAttackwith(actor, io)  = {}
	doAttackwith(actor, io) = { 
		"Killing Timon won't help your situation any,
		you psychopath!";
	}

	verDoSpraywith(actor, io) = {}
	doSpraywith(actor, io) = {
		if (io <> repellant)
			"Timon Sketch doesn't seem to notice.";
		else {
			"You spray Timon Sketch with the 
			poisonous substance.  \"Hey!\" he
			yells, \"Gimme that!\" and rips the
			can away from you.";

			repellant.movein(nil);
		}
	}
;

synth: Part
	partof = sketch
	sdesc = "portable SoundSquasher X-1000"
	ldesc = {
		I(); "The SoundSquasher X-1000 is the very latest 
		in a long line of fine SoundSquasher products.
		Brett Simpkin built the first SoundSquasher in
		his garage 34 years ago out of hubcaps and audion
		capacitors pirated from intra-planetary navigation
		beacons. After the 5th major ship disaster, Simpkin was
		arrested, an event that propelled the SoundSquasher
		to galaxy-wide success.";
	}

	footnote = {
		"SoundSquasher's synthesizers are widely regarded as 
		the best.  The new X-1000 model features a Neutrino 
		Overdrive/Inhibitor Synthesizer-Effector, the latest 
		and greatest sound-modifying gizmo.";
	}

	noun = 'synth' 'synthesizer' 'soundsquasher' 'squasher' 'x-1000'
	adjective = 'portable' 'sound'
;

//
// Cliff
//
cliff: Outside
	noun = 'cliff'
	adjective = 'atop'

	sdesc = "Atop a Cliff"
	ldesc = {
		I(); "This place is well worth the trouble it took to 
		get here.  Your spot atop this steep cliff affords 
		you a panoramic view of the land all around.  
		Directly in front of you, to the north, is a 500 
		meter drop down to a thick forest canopy that 
		continues to the horizon undisturbed.  Do be 
		careful."; P();

		I(); "To the south are the crash sites, and you notice
		a tiny building in the woods to the east of Sketch's
		ship."; P();

		I(); "Farther south is what looks to be an agricultural
		and mining complex of some kind, with a fence running all
		around 	the perimeter."; P();

		I(); "The cliff continues to the northwest and 
		southeast, but you'd have to have climbing gear to 
		survive passage along it -- this whole region is 
		covered with rocks of all sizes and you barely made 
		it this far without breaking a leg."; P();

		I(); "You see a clearing to the southwest, on this 
		side of the cliff. A path north through the trees 
		leads from the tiny clearing to a small tower.  Atop 
		the tower is a blinking ";

		if (SSmover.accepting)
			"green";
		else
			"red";

		" light."; P();

		I(); "Looks like the only way out of here is to the 
		south, the way you came.";
	}
	south = sketchcrash
	down = {
		"Probably not a wise move.";
		return nil;
	}
	up = { "You can't fly."; return nil; }
	jump = {
		"Don't be a fool -- you'd surely plummet to your death.";
		return nil;
	}
	noexit = {
		"Nope, too risky.  You'd better not push your luck 
		out here -- your agility hardly puts you in the 
		mountain goat category.";

		return nil;
	}
;
cliffcliff: Decoration
	sdesc = "cliff"
	location = cliff
	noun = 'cliff'
	verDoClimb(actor) = {}
	doClimb(actor) = {
		"Too risky -- you'd break every bone in your body.";
	}
;
cliffclearing: Distant
	sdesc = "clearing"
	ldesc = "You'll need to get closer for a better look."
	noun = 'clearing'
	adjective = 'tiny'
	location = cliff
;
clifftower: Distant
	sdesc = "tower"
	ldesc = "You'll need to get closer to see more."
	noun = 'tower'
	location = cliff
;
clifflight: Distant
	sdesc = "blinking light"	
	ldesc = "It's just a blinking light."
	noun = 'light'
	adjective = 'blinking'
	location = cliff
;
cliffrocks: Decoration
	isplural = true
	sdesc = "rocks"
	noun = 'rock' 'rocks'
	adjective = 'big' 'jagged'
	location = cliff
;
cliffcomplex: Distant
	sdesc = "agricultural and mining complex"
	ldesc = { "Is that a CAMEL you see in the fields?"; }
	noun = 'complex'
	adjective = 'agricultural' 'mining'
	location = cliff
;
cliffbuilding: Distant
	sdesc = "tiny building"
	ldesc = {
		"From here you can only tell that it's some kind
		of small dwelling -- perhaps a shack.";
	}
	noun = 'building' 'shack' 'cottage' 'dwelling'
		'domicile' 'hut' 'retreat'
	adjective = 'tiny' 'small' 'little' 'monk\'s'
	location = cliff
;
cliffcrashsites: Distant
	sdesc = "crash sites"
	ldesc = {
		"From here you can see that your own ship is
		still largely intact.  Timon's, however, was
		completely obliterated by the impact.";
	}
	noun = 'sites' 'site'
	adjective = 'crash' 'my' 'timon\'s' 'sketch\'s'
	location = cliff
;
cliffhorizon: Distant
	sdesc = "horizon"
	ldesc = "It's the horizon.  What more can be said?"
	noun = 'horizon'
	adjective = 'distant'
	location = cliff
;
cliffforest: Distant
	sdesc = "thick forest canopy"
	ldesc = {
		"The forest looks like a sea of green from way
		up here -- quite beautiful.";
	}
	noun = 'forest' 'trees' 'canopy'
	adjective = 'thick' 'green' 'beautiful'
	location = cliff
;

//
// Outside the Duhdhist retreat.
//
abandonedretreat: Outside
	noun = 'shack'
	adjective = 'outside' 'monk'

	sdesc = "Outside a Shack"
	ldesc = {
		I(); "You are standing outside a humble little shack 
		in a clearing barely large enough to hold it. There 
		is a scrawled parchment note on the door, and a small 
		jade box on the ground underneath it."; P();

		I(); "Head west and you're back at Timon Sketch's 
		crash site.";
	}
	west = sketchcrash
	in = { return self.east; }
	east = {
		if (retreatdoor.islocked) {
			"The door to the shack is locked tight, as if 
			by some magical force.";

			return nil;
		}
		else {
			"\^";
			if (not retreatdoor.isopen)
				"The door opens easily, and ";

			"you walk inside the shack."; P();

			return inretreat;
		}
	}
;
abandonedretreatshack: Decoration
	sdesc = "tiny building"
	ldesc = "You'll have to go inside for a better look."
	noun = 'shack' 'retreat' 'building'
	adjective = 'humble' 'little' 'tiny' 'small' 'duhdhist'
		'duhdist' 'dudhist'
	location = abandonedretreat
	verDoEnter(actor) = {}
	doEnter(actor) = { Me.travelto(inretreat); }
;
abandonedretreatclearing: Decoration
	sdesc = "tiny clearing"
	ldesc = "You're in it."
	noun = 'clearing'
	adjective = 'tiny' 'small' 'little'
	location = abandonedretreat
;
retreatdoor: Decoration		// not a real door -- we fake it
	islocked = true
	isopen = nil

	sdesc = "shack door"
	ldesc = {
		"It just looks like an ordinary wooden door.  There's
		a parchment note on the door.";
	}
	noun = 'door'
	adjective = 'shack' 'wooden'
	location = abandonedretreat

	verDoOpen(actor) = {}
	doOpen(actor) = {
		if (self.islocked)
			"You can't -- it seems to be sealed shut somehow.";
		else {
			"Done.";
			self.isopen := true;
		}
	}
	verDoClose(actor) = {}
	doClose(actor) = {
		"Closed.";
		self.isopen := nil;
	}
	verDoUnlock(actor) = {}
	doUnlock(actor) = { "There is no lock."; }
	verDoLock(actor) = {}
	doLock(actor) = { "There is no lock."; }
;
retreatcontainer: Decoration, Container
	done = nil
	warned = nil

	sdesc = "jade box"
	ldesc = {
		"It looks like an ordinary box, except that it seems
		to be made of solid jade!";
	}
	noun = 'box' 'container'
	adjective = 'jade'
	location = abandonedretreat

	verDoOpen(actor) = { "It has no top."; }
	verDoClose(actor) = { "It has no top."; }

	verDoTake(actor) = {}
	doTake(actor) = {
		"You try to take the box, but an unseen force
		holds it fast.";
	}

	verIoPutin(actor) = {}
	ioPutin(actor, dobj) = {
		if (dobj = friedegg or dobj = friedsynthegg) {
			if (self.done) {
				"You've already gotten the
				door open with the other egg.";
			}
			else {
				if (not self.warned) {
					warnsave();
					self.warned := true;
				}

				"You drop "; dobj.thedesc; " in the
			        jade box.  There is a bright flash and
				the egg disappears!";

				dobj.movein(nil);
				retreatdoor.islocked := nil;

				if (dobj = friedsynthegg)
					incscore(2);

				self.done := true;
			}
		}
		else
			inherited.ioPutin(actor, dobj);
	}
;
retreatsign: Readable, Decoration
	sdesc = "parchment note"
	ldesc = {
		"The parchment note on the door reads:"; P();

		"My son,\b";

		"Please leave today's fried egg in the jade container 
		to gain entrance.  Be ready to discuss \"Benedict the 
		Holy\" when I return. Do NOT burn anything this 
		time.\b";

		"\ \ \ \ \ \ -- Kuulest";
	}
	readdesc = { self.ldesc; }

	noun = 'note'
	plural = 'notes'
	adjective = 'parchment' 'scrawled'
	location = abandonedretreat

	verDoTake(actor) = {}
	doTake(actor) = { "Probably not a good idea."; }
;
//
// Duhdhist retreat.  No monk, but info on how to get to Kuwl
//
inretreat: Room
	noun = 'shack'
	adjective = 'inside' 'monk'

	sdesc = "Inside Shack"
	ldesc = {
		I(); "You're in a tiny room in a little shack.
		There's a desk and a chair here, but the room
		is otherwise bare.  The only exit is 
		out the door, to the west.";
	}
	out = abandonedretreat
	west = { return self.out; }
;
inretreatdoor: Decoration
	sdesc = "door"
	ldesc = "It looks like a typical wooden door.  It's sealed shut."

	noun = 'door'
	adjective = 'wooden'
	location = inretreat

	verDoOpen(actor) = {}
	doOpen(actor) = { "It's locked."; }
	verDoUnlock(actor) = {}
	doUnlock(actor) = { "There doesn't; seem to be a keyhole."; }
	verDoLock(actor) = {}
	doLock(actor) = { "There doesn't seem to be a keyhole."; }
;
inretreattable: Desk
	sdesc = "desk"
	ldesc = "It's just a wooden desk."
	noun = 'desk'
	adjective = 'wooden'
	location = inretreat
;
inretreatchair: Chair
	sdesc = "chair"
	ldesc = "It's just an uncomfortable wooden chair."
	noun = 'chair'
	adjective = 'uncomfortable' 'wooden'
	location = inretreat
	reachsurroundings = true
;
//
// The player has to see the leaflet before he can move to Kuwl.
// To make this more believable, we randomly generate the
// coordinates of the Kuwl spaceport.  This makes it impossible
// to "know" the coordinates just by having read the leaflet in
// a previous game.
//
kuwlleaflet: Readable, Item
	firstseen = true
	
	sdesc = "dog-eared leaflet"
	ldesc = {
 		if (self.firstseen) {
			self.firstseen := nil;
			starportmover.ar := 10000;
			starportmover.ag := 10000;
			starportmover.ab := 9521 + rnd(750) - 375;
			starportmover.accepting := true;
		}
		
		"The leaflet warns of the dangers of technology, 
		discusses various scandals involving Akmi, and urges 
		the reader to visit Kuwl "; note(self);
		" at Egg White (+0, +0, ";
		if (starportmover.ab >= 9521)
			"+";
		say(starportmover.ab - 9521);
		").  There is also an ad for the Duhdhist Broadcasting
		Network, channel 361.";
	}
	readdesc = { self.ldesc; }
	location = inretreattable
	locationtype = 'on'
	noun = 'leaflet' 'brochure'
	adjective = 'dog' 'eared' 'dog-eared'
		'duhdhist' 'duhdist' 'dudhist' 'dudist' 'kuwl'

	footnote = {
		"The planet Kuwl was colonized by the Duhdhists soon 
		after interplanetary travel became possible.  To this 
		day it is mainly inhabited by zealous followers of 
		Duhdha, although things have gotten a bit 
		commercialized since the colony's humble 
		beginnings.";
	}
;
//
// Watch the CAMELs hard at work.
//
camelfield: fenceroom
	sdesc = "CAMELs at Work"
	ldesc = {
		I(); "Through the tall fence here you can see hundreds
		of CAMELs "; note(self); " hard at work in the fields.
		Most seem to going about agricultural tasks, but some
		have giant solar collectors on them."; P();

		I(); "There is no obvious way to proceed beyond the
		fence.";
	}
	north = sketchcrash
	south = {
		fencedecoration.doClimb(Me);
		return nil;
	}

	footnote = {
		"The first Compact All-Purpose Mobile Electronic Laborer was
		developed by Andi Bunnet over 150 years ago, and many of
		the earliest models are still in used today.  CAMELs are
		robots with the simple AI required to perform agricultural
		and mining tasks.  Much cheaper than human-operated heavy
		machinery, the CAMELs work harder and faster than any
		human team could.";
	}
;
camelsworking: Distant
	sdesc = "CAMELs"
	ldesc = {
		"The CAMELs faithfully serve their human owners
		night and day.  It gives you pause to think that
		not so long ago it was men, not machines,
		that bore the yoke of slavery.";
	}
	noun = 'camels' 'camel'
	adjective = 'hard-working' 'hard' 'working'
	location = camelfield
;
camelsolarcollectors: Distant
	sdesc = "solar collectors"
	ldesc = "You can't tell much about the solar collectors from here."
	noun = 'collectors' 'panels'
	adjective = 'solar'
	location = camelfield
;
//
// The Starport on planet Kuwl
//
starport: Room
	noun = 'startport' 'kuwl'
	adjective = 'kuwl'

	gotfigurine = nil

	sdesc = "Kuwl Starport"
	ldesc = {
		I(); "Welcome to the starport on Kuwl!  This place
		is so big and crowded that you can't see an exit anywhere.
		There are thousands of short, bald, old men in robes
		wandering around here accosting normally-attired
		passers-by.  They seem to be handing flowers,
		leaflets, and other paraphernalia to the hapless
		victims, who try to flee but at every turn encounter
		yet another smiling, ancient Duhdhist.";
	}

	noexit = {
		"If I were you, I'd stay close to the mover.  If
		you get stuck in this crowd you'll die here, buried
		under a pile of flowers and self-discovery books.";

		return nil;
	}

	verGoIn(actor) = {}
	goIn(actor) = {
		starportmover.doEnter(actor);
		return nil;
	}

	enter(actor) = {
		inherited.enter(actor);
		notify(self, &event, 0);
	}

	leave(actor) = {
		inherited.leave(actor);
		unnotify(self, &event);
	}

	event = {
		if (not self.gotfigurine and rndchance(25)) {
			P(); I();
			"A wizened old man pops up out of nowhere
			and mysteriously intones, \"My son, you
			are doing well.  Duhdha smiles upon your
			progress.  But you have yet to face His
			greatest challenge.  Take this with you
			and perhaps you will find the soul wisdom
			to meet this challenge.  On the other hand,
			maybe you're just not up to it.  We'll find
			out soon, my son.  Oh yes, we'll find out
			soon.\"  He hands you a small figurine,
			taps his left nostril dramatically, and then
			vanishes into the crowd.";

			figurine.movein(Me);
			self.gotfigurine := true;
		}
		else if (rndchance(25)) {
			P(); I();
			say(self.Message[rnd(length(self.Message))]);
		}	
	}

	Message = [
		'An ancient man hands you a flower, dances a jig,
		takes the flower back, then turns away.'

		'Someone shouts, "Praise Duhdha!"'
		
		'The startport intercom comes on: "Would Kuulest
		please call on the egg-white courtesy phone?  Kuulest."
		Suddenly, thousands of wizened old men stampede
		towards the phones.'

		'A short balding man offers you an informational
		flyer on the First Galactic Bank of Duhdha, but
		you refuse it.'
		
		'A pruney old merchant hawking "Way Kuul" buttons
		passes by you in search of a sale.'

		'Someone says, "Hey, buddy, you\'re in The Way,"
		and pushes you aside.'
	]
;
starportstuff: Decoration
	sdesc = "Duhdhist paraphernalia"
	ldesc = {
		"The Duhdhists are handing out flowers, leaflets,
		and religious materials.";
	}
	noun = 'flowers' 'leaflets' 'paraphernalia'
	adjective = 'duhdhist' 'duhdist' 'dudhist' 'dudist'
	location = starport
;
starportmonks: Decoration
	isplural = true
	sdesc = "short, bald, old men"
	ldesc = {
		"The men are scurrying around madly, desperately
		trying to convert as many bystanders as possible
		to the Way.";
	}
	noun = 'men' 'monks' 'monk' 'kuulests' 'duhdists'
		'duhdhists' 'dudists' 'dudhists'
	adjective = 'short' 'old' 'bald' 'wizened' 'smiling' 'ancient'
	location = starport
;
robes: Part
	partof = starportmonks
	isplural = true
	sdesc = "robes"
	noun = 'robes'
;
starportpeople: Decoration
	sdesc = "people"
	ldesc = "There are creatures of all kinds here."
	noun = 'people' 'creatures' 'passers-by' 'victims'
	adjective = 'normally-attired' 'hapless'
	location = starport
;
starportmover: mattermover
	accepting = nil		// not until leaflet is read

	address = {
		"The address listed on the machine is: "; P();
		I(); "\"";
		say(self.ar); ", ";
		say(self.ag); ", ";
		say(self.ab); " ";
		"-- colorspace Egg White\"";
	}

	/*
	 * This mover's coordinates
	 */
	ar = -1
	ag = -1
	ab = -1

	/*
	 * This mover's dials
 	 */
	r = SPred
	g = SPgreen
	b = SPblue

	colorspace = 'Egg White'
	system = 'Val'
	planet = 'Kuwl'

	location = starport
;

SPgreen: greendial	setting = 0	location = starport;
SPblue: bluedial	setting = 0	location = starport;
SPred: reddial 		setting = 0	location = starport;

figurine: Item, Readable
	tossed = nil

	sdesc = "figurine of the Great Duhdha"
	ldesc = {
		I(); "It's a jade figurine of the Watchful Duhdha -- legend
		has it that this likeness of The Great One will ward off evil
		spirits. Additionally, it is said that an image like this one
		carved in jade by an enlightened follower of Duhdha has
		power to control the seas."; P();

		I(); self.readdesc;
	}
	readdesc = {
		"Tiny letters carved in the base of the figurine read:\b

		\"Rendered by the humble hands of Kuulest,\n
		For His Majesty Kuul,\n
		Son of Uul,\n
		In the 376th year of His Majesty's reign.\n
		Praise Duhdha!\"\b

		Wow, this thing's an artifact -- ";

		if (global.ingame)
			"1325";
		else
			"almost 1800";

		" years old!";
	}
	weight = 1	
	noun = 'figurine' 'dudha' 'duhda' 'duhdha' 'figure'
	adjective = 'jade' 'watchful'
	location = nil

	verDoRub(actor) = { }
	doRub(actor) = {
		"You feel as though Duhdha is watching over you.";
	}
	verDoEat(actor) = {
		"An affront to the Great Duhdha!  You musn't speak
		such things!";
	}
	verDoSmell(actor) = {
		"Smells like a rock.  You were expecting something else?";
	}
;

#endif	/* DEMO */

//
// Elwood Farm, where Cassandra lives
//
elroad: Outside
	noun = 'road'
	adjective = 'elwood' 'dirt'

	sdesc = "A dirt road"
	ldesc = {
		I(); "You're standing outside a matter mover right 
		next to a dirt road.  The weather is lovely here, if 
		a bit humid, and the sky is a stunningly pure 
		blue-green.  There is a crispness and freshness to 
		the air here that you've never before experienced."; P();

		I(); "The road is extremely narrow, and runs right 
		through a corn field.  It seems like the road has no 
		business being here, but is a necessary nuisance. 
		It's clear that priorities are different on Foon."; P();

		I(); "The road leads east and west.";
	}
	in = { ELmover.doEnter(Me); return nil; }
	east = elroad2
	west = elwood

	north = { self.noexitmessage; return nil; }
	south = { self.noexitmessage; return nil; }
	ne = { self.noexitmessage; return nil; }
	nw = { self.noexitmessage; return nil; }
	se = { self.noexitmessage; return nil; }
	sw = { self.noexitmessage; return nil; }

	noexitmessage = "The cornfield is too thick for you to get through."
;
ELcorn: floatingdecoration
	sdesc = "corn"
	ldesc = "It's just typical Foonian corn."
	noun = 'corn' 'field' 'vegetables' 'crops' 'stalks' 'cornfield'
	adjective = 'corn'

	loclist = [
		   elroad elroad2 elwood
#ifndef	DEMO
		   elroad3 elstore farmhousefront tireswing
#endif
	]

	verDoPick(actor) = {
		self.verDoEnter(actor);
	}
	verDoEnter(actor) = {
		"This is no time to practice your agrarian skills!";
	}
;
ELroad: floatingdecoration
	sdesc = "dirt road"
	ldesc = "It's just an ordinary, albeit narrow, dirt road."
	noun = 'road'
	adjective = 'narrow' 'dirt'
	loclist = [	
		   elroad elroad2 elwood
#ifndef	DEMO
		   elroad3 elstore farmhousefront tireswing garden
#endif
	]
;
ELsky: floatingdecoration
	isdtermined = true
	sdesc = "the Foonian sky"
	ldesc = { "The Foonian sky is beautiful indeed."; }
	noun = 'sky'
	adjective = 'Foonian' 'blue-green' 'pale-green' 'blue' 'green'
		'pale' 'green' 'reflected' 'exquisite' 'beautiful'
	loclist = [
		elroad elroad2 elwood
#ifndef	DEMO
		elroad3 elstore farmhousefront tireswing behindhouse garden
#endif
	]
;
ELmover: Decoration, mattermover
	accepting = nil	// Doesn't accept until VEGseller enables it

	location = elroad
	address = {
		"Scrawled script on the mover reads \"3921, 5840, 9278\".";
	}

	/*
	 * This mover's coordinates
	 */
	ar = 3921
	ag = 5840
	ab = 9278
	
	/*
	 * This mover's dials
 	 */
	r = ELred
	g = ELgreen
	b = ELblue

	colorspace = 'Cornflower'
	system = 'Val'
	planet = 'Foon'
;
ELgreen: Decoration, greendial	location = elroad setting = 0;
ELblue: Decoration, bluedial	location = elroad setting = 0;
ELred: Decoration, reddial	location = elroad setting = 0;

elwood: Outside
	noun = 'farm' 'elwood'
	adjective = 'outside' 'elwood'
		
	sdesc = "Outside Elwood Farm"
	ldesc = {
		I(); "You're standing a few hundred yards away from
		a modest-sized farmhouse.  You gather from the posted sign
		that this is Elwood Farm, and that the corn lining the dirt
		road you came in on belongs to the Elwoods."; P();

		I(); "From here, the building itself seems fairly 
		well maintained, but could use a good painting.  The 
		sizes of the carefully placed trees in the front yard 
		give you the impression that people have lived on 
		this plot of land for hundreds of years."; P();

		I(); "The farmhouse is to the west.  Head east and you're
		back at the local matter mover.";
	}

	east = elroad
	west = {
#ifdef	DEMO
		"Since this is only a demo, you cannot travel
		any farther in this direction.";  P();
		
		demoblurb();

		P();

		return self;
#else
		return farmhousefront;
#endif
	}

	
	north = { self.noexitmessage; return nil; }
	south = { self.noexitmessage; return nil; }
	ne = { self.noexitmessage; return nil; }
	nw = { self.noexitmessage; return nil; }
	se = { self.noexitmessage; return nil; }
	sw = { self.noexitmessage; return nil; }
	
	noexitmessage = {
		"I don't think it would be wise to wander all around
		their property willy-nilly.";
	}
;
elwoodfarmousedecoration: Decoration
	sdesc = "farmhouse"
	ldesc = {
		"Why not get closer for a better look?";
	}
	location = elwood
	noun = 'house' 'farmhouse' 'farm' 'building'
	adjective = 'farm'
;

elwoodsign: Readable, Decoration
	sdesc = "sign"
	ldesc = { self.readdesc; }
	readdesc = {
		"The sign says, \"Elwood Farm.\"";
	}
	location = elwood
	noun = 'sign'
	adjective = 'elwood' 'farm'
;
elwoodtrees: Decoration
	sdesc = "trees"
	adesc = "trees"
	ldesc = {
		"The trees are all at least 20 meters tall, and their
		trunks are immense.  Not being familiar with Foonian
		flora, you don't know what they're called, but suffice
		it to say that they're quite similar in appearance to
		the one's you're used to back home on Tode, except that
		the leaves are somewhat bluish.";
	}
	location = elwood
	noun = 'tree' 'trees'
;
elwoodtreesleaves: Decoration
	sdesc = "tree leaves"
	adesc = "tree leaves"
	ldesc = {
		"The leaves look normal, except that they're bluish.";
	}
	location = elwood
	noun = 'leaf' 'leaves'
	adjective = 'tree' 'tree\'s'
;

elroad2: Outside
	sdesc = "On a Dirt Road"
	ldesc = {
		I(); "You're on the dirt road, now quite far from the
		matter mover. Tracks from some land vehicle begin here
		and lead east, around a bend, but the corn that lines the road
		blocks your view past the turn.  The matter mover is
		to the west.";

		if (not akmid.found) {
			P();
			I(); "A flash of light near a moss-covered rock by
			the side of the road catches your eye.";
		}
		else if (akrock.isin(self)) {
			P();
			I(); "A moss-covered rock lies by the side of
			the road.";
		}
	}

	west = elroad
	east = {
#ifdef	DEMO
		"Since this is only a demo, you cannot travel
		any farther in this direction.";  P();
		
		demoblurb();

		P();

		return self;
#else
		return elstore;
#endif
	}

	north = { self.noexitmessage; return nil; }
	south = { self.noexitmessage; return nil; }
	ne = { self.noexitmessage; return nil; }
	nw = { self.noexitmessage; return nil; }
	se = { self.noexitmessage; return nil; }
	sw = { self.noexitmessage; return nil; }

	noexitmessage = "The cornfield is too thick for you to get through."
;
eltracks: floatingdecoration
	sdesc = "tire tracks"
	ldesc = "There's nothing terribly fascinating about the tire tracks."
	adesc = { self.sdesc; }
	noun = 'tracks'
	adjective = 'land' 'vehicle' 'tire'
	loclist = [
		elroad2 
#ifndef	DEMO
		elstore
#endif
	]
;
akrock: Decoration
	indentified = nil
	found = nil

	sdesc = {
		if (not self.identified)
			"moss-covered rock";
		else
			"geode";
	}
	ldesc = {
		if (not akmid.found) {
			self.findakmid;
		}
		else {
			"Though it looks completely everyday at first 
			glance, a closer inspection reveals the rock 
			to be a geode: dull and unimpressive on the 
			outside, but with a brilliant, sparkling 
			crystalline center -- absolutely beautiful!";

			self.identified := true;
		}
	}
	noun = 'rock' 'light' 'flash' 'glint' 'geode' 'crystal'
	adjective = 'moss-covered' 'mossy' 'moss' 'covered'
			'beautiful' 'brilliant' 'sparkling' 'crystalline'
	location = elroad2

	findakmid = {
		"You spot a lost akmid half-covered by the rock, and 
		pocket it. Lucky day!";

		akmid.found := true;
		akmid.movein(Me);
	}
	
	verDoTake(actor) = {}
	doTake(actor) = {
		if (not akmid.found) {
			I(); self.findakmid;
			P(); I();
		}

		"You pick up the rock.";
		rock.movein(Me);
		self.movein(nil);
	}
;
akrockmoss: Part
	partof = akrock
	sdesc = "some moss on the rock"
	adesc = { self.sdesc; }
	thedesc = "the moss on the rock"
	ldesc = "It's just moss."
	noun = 'moss'
	adjective = 'rock' 'light' 'flash' 'glint' 'geode' 'crystal' 
		'moss-covered' 'mossy' 'moss' 'covered' 'beautiful' 
		'brilliant' 'sparkling' 'crystalline' 
;
rock: Item	// Item version of akrock
	sdesc = { akrock.sdesc; }
	ldesc = { akrock.ldesc; }
	noun = 'rock' 'light' 'flash' 'glint' 'geode' 'crystal'
	adjective = 'moss-covered' 'mossy' 'moss' 'covered'
			'beautiful' 'brilliant' 'sparkling' 'crystalline'
	location = nil
;
rockmoss: Part
	partof = rock
	sdesc = "some moss on the rock"
	ldesc = "It's just moss."
	adesc = { self.sdesc; }
	thedesc = "the moss on the rock"
	noun = 'moss'
	adjective = 'rock' 'light' 'flash' 'glint' 'geode' 'crystal' 
		'moss-covered' 'mossy' 'moss' 'covered' 'beautiful' 
		'brilliant' 'sparkling' 'crystalline' 
;
akmid: Attachable, Attachpoint, Readable

	attachesto = [
#ifndef	DEMO
		string
#endif
	]

	tieable = true
	found = nil

	sdesc =	"akmid"
	thedesc = "the akmid"
	adesc = { "an "; self.sdesc; }
	ldesc = {
		I(); "Nowadays you don't see these much, since everyone uses
		credit for their purchases.  It looks like this one has
		been nailed to a wall or something: it's got a hole right
		through its center."; P();

		self.readdesc;

		if (self.attachedto <> []) {
			P(); I();
			self.attachedtodesc;
		}
	}
	readdesc = {
		I(); "Tiny letters stamped across a hologram on the face of
		the akmid read, \"One (1) Akmid.  In Cheez We Trust.  Kee
		Plastybus Akum.\"  What nostalgia -- it was minted before the
		Republic forced Akmi to put the Motto of the Republic ";
		note(self); " on the currency!";
	}

	bulk = 1
	weight = 1
	noun = 'akmid' 'coin'
	
	footnote = {
		"\"Peace, freedom, and equality for all creatures.\"";
	}
;
akmidhologram: Part
	partof = akmid
	sdesc = "hologram"
	ldesc = "The hologram appears to be a representation
		of some kind of key."
	noun = 'hologram'
	adjective = 'akmid'
;

#ifndef	DEMO

elstore: Outside
	noun = 'eats'
	adjective = 'outside' 'elwood' 'elwood\'s'

	sdesc = "Outside \"Elwood's Eats\""
	ldesc = {
		I(); "A poorly painted sign nailed at an angle to the
		tiny building north of you reads, \"Elwood's Eats.\"
		Though the current lack of patronage might suggest
		otherwise, you suspect that the food served inside
		might actually be good, considering that you're
		literally surrounded by vegetation."; P();

		I(); "The building looks like it's on the verge of
		collapse, and you're sure the roof might cave in at any
		second.  Still, it has a certain rustic charm, and you feel
		compelled to go inside."; P();

		I(); "Tire tracks in the road lead up to the store from the
		west.  You can also head farther east down the road.";
	}

	west = elroad2
	east = elroad3
	in = inelstore
	north = { return self.in; }
;
elbuilding: Decoration
	sdesc = "building"
	ldesc = "You'll have to go inside for a better look."
	noun = 'building' 'shack' 'eats'
	adjective = 'old' 'rickety' 'rustic' 'charming' 'elwood\'s'
	location = elstore	
	
	verDoEnter(actor) = {}
	doEnter(actor) = { Me.travelto(inelstore); }
;
elroof: Distant
	sdesc = "roof"
	ldesc = "It's in need of repair."
	noun = 'roof'
	location = elstore	
;
elstoresign: Readable, Decoration
	sdesc = "sign"
	ldesc = "It's just a poorly-made wooden sign."
	readdesc = "It says, \"Elwood's Eats.\""
	noun = 'sign' 
	location = elstore
;
inelstore: Room
	noun = 'eats'
	adjective = 'inside' 'elwood' 'elwood\'s'

	sdesc = "Inside \"Elwood's Eats\""
	ldesc = {
		I(); "Oddly enough, no one seems to be minding the store;
		it really *must* be a slow day.  There are several
		aisles of food on ragged wooden shelves here, most of it
		standard household dry goods and canned items.  There's also
		a counter behind which you expect the owner would normally be
		right now, and above which hangs a board with a menu
		and prices on it, given in oversized, green, poorly
		kerned magnetic letters."; P();

		I(); "The store smells wonderfully earthy, and the
		floor and walls are all wooden, which adds to the homey
		feel -- this store definitely has character.  The only thing
		that looks out of place is a mechanical carnival game, which
		is off in one corner.  You notice with tremendous glee that
		it has no galacticard slot -- it only takes coins.  This part
		of the galaxy is so quaint!";
	}
	out = elstore
	south = { return self.out; }
;
elstoredecoration: Decoration
	sdesc = "Elwood's Eats"
	ldesc = { inelstore.ldesc; }
	noun = 'store' 'building' 'establishment'
	location = inelstore
;
elisles: Decoration
	isplural = true
	sdesc = "shelves of food"
	ldesc = {
		"The shelves are covered with all sorts of foodstuffs.
		You could spend all day here looking through the 
		merchandise in this tiny establishment.";
	}
	noun = 'aisles' 'isles' 'food' 'shelves' 'goods' 'items' 'merchandise'
	adjective = 'ragged' 'wooden' 'dry' 'canned'
	location = inelstore

	verDoTake(actor) = {
		"Oh, so now we'll resort to stealing, will we?  No dice,
		chucko!  Sometimes I've got to save you from yourself.";
	}
 ;
elcounter: Surface
	sdesc = "counter"
	// Do not put an ldesc here (see inelstore.ldesc)
	noun = 'countertop'
	adjective = 'wooden'
	location = inelstore
	verDoLookbehind(actor) = {
		"Peering behind the counter, you find condiments, napkins,
		straws, and other typical stuff, but nothing worth
		STEALING, that's for sure.";
	}
;
elcondiments: Decoration
	sdesc = "condiments"
	adesc = { self.sdesc; }
	ldesc = { "Trust me, they're not worth messing with."; }
	location = inelstore
	noun = 'napkins' 'straw' 'straws' 'stuff' 'condiments' 
	adjective = 'typical'
;
elmenu: Readable, Decoration
	sdesc = "Elwood's Eats menu board"
	adesc = { return self.sdesc; }
	ldesc = {
		"The menu lists the usual things: sandwiches, beverages,
		side orders, etc.  Nothing particularly exciting.";
	}
	readdesc = { self.ldesc; }
	noun = 'board' 'menu' 'letters' 'words'
	adjective = 'menu' 'green' 'magnetic' 'Elwood\'s' 'Eats'
	location = inelstore
;
cranemaster: Qcontainer
	scored = nil
	credits = 0
	gamesplayed = 0

	sdesc = "CraneMaster game"
	ldesc = {
		"The game consists of a pile of kitschy stuff behind 
		thick glass and a crane with a grabber on the end.  
		You steer the crane with a joystick mounted on the 
		front panel.  If you're dextrous enough to snag one 
		of the toys, you can move it over to the drop chute, 
		via which it will slide out onto the floor.";
	}
	noun = 'game' 'machine' 'slot' 'crane' 'master'
	adjective = 'carnival' 'mechanical' 'computer' 'crane' 'coin'
			'operated' 'coin-operated' 'cranemaster' 'master'
	location = inelstore

	verDoPlay(actor) = {}
	doPlay(actor) = {
		if (self.credits > 0) {
			self.credits := self.credits - 1;
			if (Me.stimulant) {
				I(); "In your hopped-up state you are a 
				veritable dexterity god.  The 
				mechanics of the game seem so 
				mind-numbingly trivial -- what joy!"; P();

				I(); self.gotone;
			}
			else if (self.gamesplayed = 0) {
				I(); "Having never had any practise at this
				particular exercise, you fail miserably.
				The crane swings about wildly as you struggle
				desperately to control it. You hardly get
				the hang of opening and closing the grabber
				when your time is up."; P();

				I(); "Too bad.  You have the feeling
				that if you just played a few more games
				you'd get good enough to grab some of
				the loot.";
			}
			else if (self.gamesplayed = 1) {
				"You do a bit better the second time out.
				You manage to steer the crane around and
				lower it into the pile of goods.  Actually
				getting the grabber around an item, however,
				is pretty tricky.  You don't come up
				with anything.";
			}
			else if (self.gamesplayed = 2) {
				"Now you're cooking -- you quickly drop the
				crane into the wares and grab a little 
				whistle.  Half way to the chute, though,
				the pesky thing rolls right off and
				back into the pile.";
			}
			else {
				if (rndchance(75)) {
					self.gotone;
				}
				else {
					"Got one!  No, wait, wait!  AIIIEEE!
					Dropped right off the grabber at 
					the last second.  Maybe next time...";
				}
			}
			
			self.gamesplayed := self.gamesplayed + 1;
		}
		else {
			"The machine belches a loud synthesized <RAZZZZ>.
			It flashes the message \"Please insert coin!\"
			on a panel above the coin slot, with a large
			blinking arrow pointing out just where the coin
			slot is.  (Wouldn't want anyone to miss it,
			I suppose.).";
		}
	}

	creditmessage(dobj) = {
		"You drop "; dobj.objthedesc(nil); " into the slot.
		The machine goes <DING!> and then registers
		a credit";

		if (self.gamesplayed = 0)
			" <<note(self)>>";

		".";
	}
	verIoPutin(actor) = {}
	ioPutin(actor, dobj) = {
		if (dobj = valmid) {
			self.creditmessage(dobj);
			dobj.movein(nil);
			self.credits++;

			P(); I(); "A little display near the coin slot reads
			\"CREDITS: "; say(self.credits); ".\"";
		}
		else if (dobj <> akmid) {
			"Common sense tells you the slot only takes akmids.";
		}
		else {
			if (find(string.attachedto, akmid) <> nil) {
				"You snicker to yourself maniacally as you
				drop the coin in the slot.  The machine
				burbles a bit and then chimes as it registers
				a credit.  You grab the string and carefully
				pull the coin back out of the machine.
				You devil, you.";

				if (not self.scored) {
					self.scored := true;
					incscore(4);
				}
			}
			else {
				self.creditmessage(dobj);
				dobj.movein(nil);
			}
			self.credits := self.credits + 1;
	
			P(); I(); "A little display near the coin slot reads
			\"CREDITS: "; say(self.credits); ".\"";
		}
	}
	verDoUnplug(actor) = {
		"Really, now, you're getting a bit desperate, aren't you?";
	}
	verDoKick(actor) = {}
	doKick(actor) = {
		"Now, now.  Musn't resort to violence at the least
		bit of frustration, you know.  This really isn't
		*that* hard a puzzle.  (I'm sure that makes you
		feel much better.)";
	}
	verDoHit(actor) = { self.verDoKick(actor); }
	doHit(actor) = { self.doKick(actor); }
	verDoAttackwith(actor, io) = { self.verDoKick(actor); }
	doAttackwith(actor, io) = { self.doKick(actor); }
	verDoHitwith(actor, io) = { self.verDoAttackwith(actor, io); }
	doHitwith(actor, io) = { self.doAttackwith(actor, io); }

	goodies = [ wh moodring firecracker wackyputty plasticegg letterq ]

	gotone = {
		if (self.goodies = []) {
			"You try to snag a prize, but there's just 
			nothing left that's easily accessible.  May I 
			point out, however, that you've already 
			gotten more than your money's worth.  Best to 
			quit while you're ahead, before the management 
			finds out what you've been doing...";
		}
		else {
			local	o;

			o := car(self.goodies);
			self.goodies := cdr(self.goodies);

			I(); "You whip the crane over an 
			easy-to-get item and grab it with 
			breathtaking poise and skill. Moments later 
			you drop it into the chute and it lands at 
			your feet."; P();

			o.movein(inelstore);
			o.makeknownto(Me);

			I(); "It's <<o.subjadesc>>!";
		}
	}

	footnote = {
		"To play the game, enter the command \"play game\".";
	}
;
cranechute: Decoration
	sdesc = "CraneMaster prize chute"
	ldesc = "It's just a hole in the machine via which prizes fall
		out onto the floor."
	noun = 'chute' 'hole'
	adjective = 'cranemaster' 'crane' 'master' 'carnival' 'game' 'prize'
			'drop' 'machine'
	location = inelstore
;
cranejoystick: Decoration
	sdesc = "CraneMaster joystick"
	ldesc = "It just moves the crane around.  Once you put money in,
		that is."
	noun = 'joystick' 'stick' 'control'
	adjective = 'joy' 'crane' 'master' 'cranemaster' 'carnival'
		'game' 'machine'
	location = inelstore
;
cranetoys: Decoration
	sdesc = "CraneMaster prizes"
	ldesc = {
		"Most of the toys look like they're intended for
		small children, who are presumably the only
		people naive enough to dump money into such a
		ludicrous contraption.";
	}
	noun = 'toys' 'prizes' 'goodies'
	adjective = 'crane' 'cranemaster' 'master'
	location = inelstore

	verDoTake(actor) = {}
	doTake(actor) = {
		"Good idea.  But how do you propose to accomplish this?";
	}
;
craneglass: Decoration
	sdesc = "thick glass"
	ldesc = {
		"Through the thick glass you can see lots of
		cheesy little prizes.";
	}
	noun = 'glass'
	adjective = 'crane' 'cranemaster' 'master' 'thick'
	location = inelstore

	verDoLookthrough(actor) = {}
	doLookthrough(actor) = { self.ldesc; }

	verDoBreak(actor) = {}
	doBreak(actor) = {
		"You bash on the glass with all your might, but
		are unable to break it.";
	}
	verDoHitwith(actor, io) = {}
	doHitwith(actor, io) = { self.doBreak(actor); }

	verDoAttackwith(actor, io) = {}
	doAttackwith(actor, io) = { self.doBreak(actor); }

	verDoHit(actor) = {}
	doHit(actor) = {
		"You ram your fist into the glass ith all your
		might. This action is accompanied by a loud cracking
		sound and, soon after, great pain.";
	}

	verDoKick(actor) = {}
	doKick(actor) = {
		"You perform a dramatic flying sidekick into
		the glass.  Aside from causing you extreme
		pain, this accomplishes nothing.";
	}
;
wh: Item
	sdesc = "plastic whistle"
	ldesc = "It's just a cheap plastic whistle.  It's bright green
		and more than loud enough to annoy parents."
	noun = 'whistle'
	adjective = 'cheap' 'plastic' 'toy'
	plural = 'toys'
	location = nil
	
	verDoBlow(actor) = {}
	doBlow(actor) = {
		"You blow into the whistle and nearly deafen yourself
		in the process.  Pretty impressive for form-molded plastic.";
		
		// The whistle affects Squirt just like a human whistle
		if (squirt.inroom) {
			" "; squirt.whistle;
		}
	}
;
moodring: Clothing
	sdesc = "mood ring"
	ldesc = {
		"It's supposed to change colors according to your
		mood when you wear it, though you suspect that it's
		really just random.  Right now it is ";
		
		if (self.isworn) {
			say(self.styles[rnd(length(self.styles))]);
			" ";
			say(self.colors[rnd(length(self.colors))]);
		}
		else 
			"black";
			
		".";
	}
	noun = 'ring' 'toy'
	adjective = 'mood'
	plural = 'toys'

	styles = [
		'deep' 'dark' 'light' 'off' 'psychedelic' 'murky' 'swirling'
		'fluorescent' 'pastel' 'incandescent' 'flecked' 'kind of'
		'a bit'
	]

	colors = [
		'red' 'orange' 'yellow' 'green' 'blue' 'indigo'
		'violet' 'mauve' 'chartreuse' 'peach' 'salmon'
		'teal'	'azure' 'lemon' 'pink' 'obsidian' 'marble'
		'ocher'
	]

	location = nil
;
firecracker: Item
	sdesc = "firecracker"
	ldesc = "It's just a little red firecracker with a long fuse."
	noun = 'firecracker' 'cracker'
	adjective = 'fire'
	location = nil
	weight = 1
	bulk = 1

	verDoLight(actor) = {
		"A fine idea, but how do you propose to do it?";
	}
;
firecrackerfuse: Part
	partof = firecracker
	sdesc = "fuse"
	ldesc = "It's just a long fuse, leading into a little firecracker."
	noun = 'fuse'
	adjective = 'firecracker' 'fire' 'cracker'

	verDoLight(actor) = { firecracker.verDoLight(actor); }
;
//
// In the game-within-a-game, Kuulest alludes to the fact (?) that
// Wacki Putti is somehow related to the Unnkulian demons.
// 
wackyputty: Edible, Item
	sdesc = "some Akmi Wacki Putti"
	adesc = { self.sdesc; }
	thedesc = "the Akmi Wacki Putti"
	ldesc = {
		I(); "The Akmi Wacki Putti is a freak of materials science.
		It's bright pink and molds easily.  Easily, that is, when
		it's not runny, which it seems to become at random times.
		Suffice it to say that the stuff is pretty disgusting."; P();

		I(); "The Wacki Putti is currently ";
		if (rndchance(50))
			"runny.";
		else
			"firm.";
	}
	noun = 'putty' 'putti' 'puttee'
	adjective = 'wacky' 'wacki' 'wackee' 'silly' 'sillee' 'silli' 'akmi'
	bulk = 2
	location = nil
	verDoSmell(actor) = {}
	doSmell(actor) = { "It smells like synthetic egg substitute."; }
	eatdesc(actor) = { "Bleah!  You can barely keep it down!"; }
;
plasticegg: Item
	sdesc = "plastic plover's egg"
	ldesc = "It looks like an ordinary plover's egg, except
		that it's made of plastic.  Tiny letters along a
		seam say, \"C&W Model Y2. Plugh Mfg.\ Co.\""
	location = nil
	noun = 'egg' 'plover'
	adjective = 'plover\'s' 'plastic'
	plural = 'eggs'

	verDoEat(actor) = {
		"It's PLASTIC.	Better-tasting, perhaps, than
		most Akmi products, but nevertheless better left
		out of your diet.";
	}
;
plasticeggseam: Part
	partof = plasticegg
	sdesc = "seam"
	ldesc = "It's just the seam where the two halves were fused
		together."
	noun = 'seam'
	adjective = 'egg' 'plover' 'plover\'s' 'plastic'
;
letterq: Readable, Item
	sdesc = "magnetic letter Q"
	ldesc = "It's a plastic green letter Q with a magnet on the back."
	readdesc = "It says, \"Q.\""
	noun = 'q' 'letter'
	adjective = 'plastic' 'letter'
	location = nil
;
letterqmagnet: Part
	partof = letterq
	sdesc = "little magnet on the back of the letter Q"
	ldesc = "Hate to tell you, but there's nothing particularly exciting
		about the little magnet on the back of the letter Q."
	noun = 'magnet'
	adjective = 'q' 'letter' 'plastic'
;
elroad3: Outside
	noun = 'road' 'puddle'
	adjective = 'dirt' 'puddle'
	
	sdesc = "On a Dirt Road, at a Puddle"
	ldesc = {
		I(); "The road straightens here, with corn flanking both
		sides as before.  To the east the road continues unchanged
		as far as the eye can see, but there's a store down the
		road to the west."; P();

		I(); "There is a sizeable puddle right at your feet.";
	}
	west = elstore
	east = {
		"Looking down the road, you don't see anything of
		interest.  You'd probably be walking for quite a while,
		and you've got more pressing matters to attend to.";
		
		return nil;
	}
	down = {
		"You descend into the underworld hidden below 
		the surface of Foon!  Seriously, you can't think the
		puddle's that deep!";

		return nil;
	}
;
elorad3store: Distant
	sdesc = "store"
	ldesc = "The store is too far away for you to tell much about it."
	noun = 'store' 'building' 'eats'
	adjective = 'tiny' 'small' 'elwood\'s'
	location = elroad3
;
elroad3puddle: Decoration
	sdesc = "puddle in the road"
	ldesc = {
		I(); "As you gaze into the puddle you look right beyond
		the plane of the water and seem to view another
		world entirely.  But soon you realize that you're
		just looking at the reflected majesty of the Foonian
		sky, now a pale-green canvas upon which hundreds
		of Foonian birds sail in sweeping arcs."; P();

		I(); "The effect is striking; the adjacency of the close,
		muddy, mundane ground and the distant, reflected, exquisite
		sky creates an illusion that assaults your visual intuition.";
	}
	location = elroad3
	noun = 'puddle' 'water' 'h2o'
	adjective = 'muddy' 'murky' 'mundane' 'reflective' 'reflecting'
			'reflection'

	verDoLookin(actor) = {}
	doLookin(actor) = { self.ldesc; }

	verDoLookunder(actor) = { "What a concept."; }

	verDoTake(actor) = {}
	doTake(actor) = { self.getwater; }

	verDoPutX(actor, io, loctype) = {
		if (loctype <> 'in')
			"You can't put the puddle <<self.loctype>> anything.";
		else if (io <> revolt)
			"That doesn't look like a suitable container.";
	}
	verDoPutin(actor, io) = { self.verDoPutX(actor, io, 'in'); }

	doPutin(actor, io) = { self.doPutX(actor, io, 'in'); }
	doPutX(actor, io, loctype) = {
		if (loctype <> 'in')
			io.ioPutX(actor, [] + self, loctype);
		else if (io <> revolt)
			"That doesn't look like a suitable container.";
		else
			self.getwater;
	}

	getwater = {
		if (not revolt.isin(Me)) {
			"You have nothing to put water in at the moment.";
		}
		else if (not revolt.empty) {
			"You don't have an empty container.";
		}
		else if (revolt.iswet) {
			"You've already got plenty!";
		}
		else {
			"You fill "; revolt.thedesc; " with water.";
			revolt.iswet := true;
		}
	}
;
/*
 * The Elwood Farmhouse
 */
farmhousefront: Outside
	noun = 'farm' 'farmhouse' 'house'
	adjective = 'farm' 'outside' 'elwood' 'elwood\'s'

	sdesc = "Outside the Elwood Farmhouse"
	ldesc = {
		I(); "You are standing at the wooden front door of the
		Elwood Farmhouse.  A quaintly narrow stone path lined with 
		colorful flowers leads up to the door, flanked on 
		both sides by a well-groomed, vibrant kelly green 
		lawn."; P();

		I(); farmhousefrontfarm.ldesc; P();

		I(); "The entrance is to the west.  You might also
		take a walk around the house to the northwest and
		southwest.  The stone path leads east, back to the
		dirt road.";
	}
	east = elwood
	nw = garden
	sw = tireswing
	west = farmhousefrontdoor1
	in = { return self.west; }
;
farmhousefrontdirtroad: Decoration
	sdesc = "dirt road"
	ldesc = "The dirt road is east of here."
	location = farmhousefront
	noun = 'road'
	adjective = 'dirt'
;
farmhousefrontfarm: Decoration
	sdesc = "farmhouse"
	ldesc = {
		"The paint is peeling in places, and the windows could
		use new shutters, but otherwise the house is in decent
		shape considering its age -- the design, though simple,
		suggests architectural trends popular several hundred
		years ago, before the formation of the Republic ";
		note(self); ".";
	}
	location = farmhousefront
	noun = 'house' 'farmhouse' 'building' 'paint' 'windows'
		'design' 'architecture' 'shutters' 'exterior'
	adjective = 'farm' 'old' 'decent' 'farmhouse' 'house' 'building'

	footnote = {
		"You always wondered if that architecture class you
		almost slept through would ever be of any use...  Though
		design ideas are fairly slow to propagate to Foon from
		Tode, Hop, and Tel, you don't imagine that even Foonian
		architects would still be using Cerquian school style
		beyond 1950VK.  That makes the house at least 208 years
		old (unless it was built during the brief Cerquian
		retro phase 20 years ago, which you doubt from the
		amount of wear on the exterior).";
	}
;
farmhousefrontpath: Decoration
	sdesc = "stone path"
	ldesc = {
		"It's just a typical cobblestone path, made of
		smooth, flat, gray and brown rocks.";
	}
	location = farmhousefront
	noun = 'path' 'walkway' 'way'
	adjective = 'stone' 'walk' 'cobble' 'cobblestone' 'quaint'
		'quaintly' 'narrow' 'thin'
;
farmhousefrontlawn: Decoration
	sdesc = "lawn"
	adesc = { self.thedesc; }
	ldesc = {
		"The lawn looks very healthy, and is a bright kelly color
		you've never seen in Todian grass.  (And they sure don't
		have lawns on Frost!)";
	}
	location = farmhousefront
	noun = 'lawn' 'grass' 'yard'
	adjective = 'bright' 'kelly' 'green' 'healthy' 'vibrant'
			'well-groomed' 'well' 'groomed'
			'farm' 'house' 'farmhouse'
;
farmhousefrontflowers: Decoration
	picked = nil
	sdesc = "colorful flowers lining the path"
	adesc = { self.thedesc; }
	ldesc = {
		"There are several varieties, with colors ranging from deep
		purple to almost neon orange.  Having never studied botany,
		you have no idea what to call them besides \"beautiful.\"";
	}
	location = farmhousefront
	noun = 'flowers' 'plants'
	adjective = 'colorful' 'pretty' 'beautiful'

	verDoSmell(actor) = {}
	doSmell(actor) = {
		"Some of them have no scent; others give off powerful
		and exciting aromas.  One of them, in fact, smells a
		lot like Ada's favorite perfume.";
	}
	verDoPick(actor) = {
		if (self.picked) {
			"You've already picked enough flowers from
			the Elwoods' front yard.  Didn't your mother
			ever teach you any manners?";
		}
	}
	doPick(actor) = {
		self.picked := true;
		"You look around to be sure no one sees you, then 
		snatch up one of the particularly pretty and fragrant 
		flowers.";
		flower.movein(Me);
		notify(flower, &wilt, 0);
	}
	verDoTake(actor) = { self.verDoPick(actor); }
	doTake(actor) = { self.doPick(actor); }

	verDoEat(actor) = {
		"Your bovine instincts say, \"Yes,\" but your human
		stomach says, \"No.\"";
	}
;
flower: Item
	wiltcount = 0
	
	sdesc = "pretty red flower"
	ldesc = {
		"It's a fabulous red flower that smells like perfume.";

		if (self.wiltcount >= 10 and self.wiltcount < 20) {
			" It looks a bit wilted.";
		}
		else if (self.wiltcount >= 20 and self.wiltcount < 30) {
			" It's wilted some, and now droops a bit.";
		}
		else if (self.wiltcount >= 30 and self.wiltcount < 40) {
			" Unfortunately, it's wilted a lot, and so 
			looks much less impressive than it originally 
			did.";
		}
		else if (self.wiltcount >= 40) {
			" Sad to say, but the flower is now covered with
			ugly brown splotches, and droops sadly.  But
			it sure was beautiful while it lasted.";
		}

		if (self.location)
			if (self.location.iswet)
				" It seems happy to be in water.";
	}
	noun = 'flower' 'plant' 'petals'
	adjective = 'pretty' 'fragrant' 'fabulous' 'red' 'perfume'

	wilt = {
		/*
		 * If the flower's in water, don't make it wilt more.
		 */
		if (self.location) if (not self.location.iswet) {		
			self.wiltcount := self.wiltcount + 1;

			if (self.wiltcount > 50) {
				unnotify(self, &wilt);
				if (self.isin(Me)) {
					P(); I();
					"The flower crumbles into a 
					shower of curled, brown 
					petals, totally wilted.";
				}
				self.movein(nil);
			}
		}
	}

	location = nil

	verDoPlant(actor) = {
		"If you wanted it in the ground, why'd you rip
		it up in the first place?";
	}
	verDoEat(actor) = {
		"It's a FLOWER -- hello, anybody home?  HELLO?";
	}
	verDoSmell(actor) = {
		"It smells just like Ada's favorite perfume!";
	}
;
farmhousefrontdoor1: Door
	doordest = insidefarmhouse
	otherside = farmhousefrontdoor2

	isopen = true
	islocked = nil
	islockable = nil

	sdesc = "front door"
	adesc = { self.thedesc; }
	ldesc = {
		"It's just an ordinary wooden door.  It looks quite
		old but sturdy enough. ";

		inherited.ldesc;
	}
	location = farmhousefront

	noun = 'door' 'entrance'
	adjective = 'farm' 'house' 'farmhouse' 'wooden' 'sturdy' 'old'
;

garden: Outside
	noun = 'garden'
	adjective = 'elwood' 'elwood\'s'

	sdesc = "At a Garden Outside the Farmhouse"
	ldesc = {
		I(); "Here on the north side of the farmhouse is a
		large garden full of yummy-looking treats.  The soil has been
		recently tilled and smells wonderfully rich, and from the
		looks of it supports the vegetables planted in it far better
		than any Todian earth could."; P();

		I(); "You've heard plenty of stories about the
		near-magical fertility of the Foonian soil, but
		this close-up demonstration really drives the point
		home.  The goodies here are all oversized and
		delicious-looking.  You suspect that even you, with
		your limited gardening experience, could grow a prize
		plant on Foon."; P();

		I(); "From here you can head either southeast, to the front
		of the farmhouse, or southwest, to the rear.";
	}
	se = farmhousefront
	sw = behindhouse
;
gardenfarmhouse: Decoration
	sdesc = "farmhouse"
	ldesc = {
		"All you can see of the farmhouse is the northern wall.";
	}
	location = tireswing
	noun = 'house' 'farmhouse'
	adjective = 'farm'
;
gardendecoration: Decoration
	sdesc = "vegetable garden"
	ldesc = {
		"The garden is very impressive, with vegetables of all
		varieties.";
	}
	location = garden
	noun = 'garden' 'soil' 'dirt' 'treats'
	adjective = 'vegetable' 'yummy'

	verIoPlantin(actor) = {}
	verIoPutin(actor) = {}
	ioPutin(actor, dobj) = {
		if (dobj.isseeds)
			dobj.doPlant(actor);
		else
			"Stuffing <<dobj.objthedesc(nil)>> into
			the dirt won't help any!";
	}

	verDoSmell(actor) = {}
	doSmell(actor) = {
		"Like I said, it smells wonderfully rich.";
	}
	verDoEat(actor) = {
		"Now you're REALLY starting to worry me.";
	}
;
gardenvegetables: Decoration
	sdesc = "vegetables"
	adesc = "vegetables"
	ldesc = {
		"There are many different kinds.  All are bigger and
		tastier-looking than their Todian counterparts.
		Actually, this is starting to make you feel hungry!";
	}
	location = garden
	noun = 'vegetables' 'goodies' 'plants'
	adjective = 'foonian' 'garden' 'big' 'tasty' 'tasty-looking'
			'yummy' 'yummy-looking'

	verDoTake(actor) = {
		"Much as you'd like to, your moral upbringing
		prevents you from ripping off the Elwoods ";
		note(self); ".";
	}
	verDoPick(actor) = { self.verDoTake(actor); }

	footnote = {
		"I don't want to hear any complaining, by the way.";
	}
;
tireswing: Outside
	noun = 'swing'
	adjective = 'tire'

	sdesc = "At the Tire Swing Outside the Farmhouse"
	ldesc = {
		I(); "You have walked around to the south side of the 
		farmhouse, and find yourself confronted with a giant 
		oak-like tree "; note(self); ".  The tree has a tire 
		swing attached to it."; P();

		I(); "From here you can head either northeast or northwest,
		towards the front and rear of the house, respectively.";
	}
	ne = farmhousefront
	nw = behindhouse
	up = {
		"You'll need to climb up.";
		return nil;
	}

	footnote = {
		"\"Oak-like\" because you doubt it's the same variety
		of tree that you call an oak back home on Tode.";
	}
;
tireswingfarmhouse: Decoration
	sdesc = "farmhouse"
	ldesc = {
		"All you can see of the farmhouse is the southern wall.";
	}
	location = tireswing
	noun = 'house' 'farmhouse'
	adjective = 'farm'
;
tire: Chair, Qcontainer
	standable = nil	// can't stand on tire

	sdesc = "tire"
	ldesc = {
		"It's just an ordinary tire.  It's very worn; so much so
		that the manufacturer's name isn't legible anymore.";
	}
	noun = 'tire'
	adjective = 'bald' 'worn'
	location = tireswing

	// If the player sits in the tire, we move them to the
	// tire swing object.  This is so the player can still
	// examine the "tire" as an object separate from the 
        //  "tire swing".
	verDoEnter(actor) = { tireswingdecoration.verDoEnter(actor); }
	doEnter(actor) = { tireswingdecoration.doEnter(actor); }
	verDoExit(actor) = { tireswingdecoration.verDoExit(actor); }
	doExit(actor) = { tireswingdecoration.doExit(actor); }
	doSwingin(actor) = { tireswingdecoration.doSwingin(actor); }
;
tireswingdecoration: Chair
	standable = nil	// can't stand on tire
	reachsurroundings = true

	sdesc = "tire swing"
	ldesc = {
		"The tire swing is on a sturdy rope tied to a thick
		branch in the oak-like tree high above.  Whoever
		put it up must have used one heck of a ladder.";
	}
	noun = 'swing' 'tireswing'
	adjective = 'tree' 'tire'
	location = tireswing

	goUp(actor) = {
		"You fold your limbs into the uncomfortable configuration
		required to exit the tire swing.  You're a bit big for
		this kind of thing, you know."; P();

		return self.location;
	}	

	verDoSwingin(actor) = {
		if (not actor.isin(self))
			"You'll have to get in the tire swing first.";
	}
	doSwingin(actor) = {
		"You get a little momentum going and swing around in 
		a wide circle.  There's not enough room to really get 
		going though, and besides that you're afraid you 
		might crash into the farmhouse or the tree. These 
		things can be dangerous, you know!";
	}

	noexit = {
		self.doSwingin(Me);
		return nil;
	}
;
tireswingrope: Decoration
	sdesc = "rope"
	ldesc = {
		"The rope looks stong.  It was not made by Akmi; they've
		been out of the rope business for a *long* time.";
	}
	noun = 'rope' 'knot'
	location = tireswing

	verDoClimb(actor) = {}
	doClimb(actor) = {
		"You pull yourself up with your arms and legs, and slowly
		reach the top.\b";

		Me.travelto(uptheoaktree);
	}

	verDoUntie(actor) = {
		"You'll have to get to where the knot is first.";	
	}
	verDoTie(actor) = {
		"It seems pretty well-tied already.";
	}
;
tireswingbigoak: Decoration
	sdesc = "giant oak-like tree"
	noun = 'tree' 'oak'
	adjective = 'giant' 'oak' 'oak-like'
	location = tireswing

	verDoClimb(actor) = {
		"There are no branches low enough for you to grab
		onto.  There is, however, a rope tied to one branch.
		You might try climbing up the rope.";
	}
;

// Up the Oak Tree
uptheoaktree: Outside
	sdesc = "Up the Oak-Like Tree"
	ldesc = {
		I(); "Your precarious perch high in the tree affords
		you a spectacular view of the surrounding environs.
		You now see the tremendous expanse of crops on just
		Elwood Farm alone -- the land is a patchwork as
		far as the eye can see."; P();

		I(); "You spot the dirt road leading up to the
		farmhouse; a store past a bend in the road; and the
		local matter mover, which doesn't seem to get much
		traffic."; P();

		if (not akmid.found) {
			I(); "You notice a glint of light in the road, 
			about halfway between the matter mover and the 
			store."; P();
		}

		I(); "High above you, on a far away branch, is a little
		bird's nest.";

		birdsnest.seebaby;

		if (not poodle.taken) {
			P();
			I(); "There is "; poodle.adesc; " hanging from
			a nearby branch.";
		}
	}

	down = {
		"You slide down the rope, being careful not to get 
		rope burns."; P();

		return tireswing;
	}	
	noexit = {
		"Think again; it's a long way down.";

		return nil;
	}

	/*
	 * Things dropped here fall all the way to the ground.
	 * To be nice, we don't worry about breaking things.
	 */
	roomdrop(actor, obj) = {
		"\^<<obj.subjthedesc>> lands on the ground below.";

		obj.movein(tireswing);
	}
;
poodle: Attachable, Attachpoint, Clothing, Readable
	isListed = nil	// not listed until taken the first time
	islistable(actor) = { return self.isListed; }

	tieable = true
	
	attachesto = [string]
	attachedto = [string]

	taken = nil

	sdesc = {
		"poodle charm";
	}
	thedesc = "the poodle charm"
	ldesc = {
		I(); "It's a little gold charm shaped like a poodle.
		It looks like it's quite old -- the edges are somewhat
		worn and it could use a good polishing. ";

		self.readdesc;

		if (find(self.attachedto, string) <> nil) {
			P(); I();
			"There is "; self.attachedto[1].adesc; " tied to
			the charm, making it into a simple necklace.";
		}
	}
	readdesc = { "The word \"Pierre\" is engraved on the back."; }	
	bulk = 1
	weight = 1
	noun = 'charm' 'necklace'
	adjective = 'poodle' 'pierre'
	location = uptheoaktree

	verDoDetachfrom(actor, io) = {
		if (self.isworn)
			"You'll have to take the poodle charm
			off to untie it.";
		else
			inherited.verDoDetachfrom(actor, io);
	}
	verIoDetachfrom(actor) = {
		if (self.isworn)
			"You'll have to take the poodle charm
			off to untie it.";
		else
			inherited.verIoDetachfrom(actor);
	}

	verDoWear(actor) = {
		Outhide(true);
		inherited.verDoWear(actor);
		if (Outhide(nil)) {
			inherited.verDoWear(actor);
			return;
		}

		if (find(self.attachedto, string) = nil) {
			"I don't see any way to wear the charm without
			a chain of some kind.";
		}
	}
	doTake(actor) = {
		inherited.doTake(actor);
		if (not self.taken)
			self.maketaken;
	}

	maketaken = {
		self.taken := true;
		self.isListed := true;
		self.attachedto[1].isListed := true;
	}
;

//
// See also companion Item tiedstring below.
// The knotting stuff is just to be goofy.
//
string: Attachable, Attachpoint
	isListed = nil	// Doesn't show up in room description by
			// default until the player takes the necklace.
	islistable(actor) = { return self.isListed; }
	
	tieable = true

	attachesto = [poodle akmid]
	attachedto = [poodle]

	location = uptheoaktree

	knots = 0
	sdesc = "piece of string"
	thedesc = "the piece of string"
	ldesc = {
		"It's just an ordinary piece of string. ";
		
		if (self.knots = 1)
			" It has a knot in it. ";
		else if (self.knots > 1)
			" It has knots in it. ";

		if (self.attachedto <> [])
			self.attachedtodesc;
	}
	noun = 'string' 'piece'
	
	verDoDetachfrom(actor, io) = {
		if (find(self.attachedto, poodle) <> nil and poodle.isworn)
			"You'll have to take the poodle charm
			off to untie it.";
		else
			inherited.verDoDetachfrom(actor, io);
	}

	verDoKnot(actor) = {}
	doKnot(actor) = {
		if (self.knots = 0)
			"You knot the string.";
		else
			"You add another knot to the string.";
	}
	verDoUnknot(actor) = {}
	doUnknot(actor) = {
		if (self.knots = 0)
			"The string is already unknotted.";
		else if (self.knots = 1)
			"You untie the knot.";
		else 
			"You untie all the knots in the string.";
	
		self.knots := 0;
	}
;
uptheoakenvirons: Distant
	sdesc = "surrounding environs"
	adesc = { return self.sdesc; }
	ldesc = {
		"The surrounding environs are a truly
		beautiful piece of work.";
	}
	location = uptheoaktree
	noun = 'environs' 'crops' 'corn' 'patchwork'
	adjective = 'surrounding' 'local'
;
uptheoakdirtroad: Distant
	sdesc = "dirt road"
	ldesc = {
		"It's just the dirt road you came in.";
	}
	location = uptheoaktree
	noun = 'road' 'bend'
	adjective = 'dirt'
;
uptheoakstore: Distant
	sdesc = "store"
	ldesc = {
		"You can't tell much about it from here.";
	}
	location = uptheoaktree
	noun = 'store'
;
uptheoakmattermover: Distant
	sdesc = "matter mover"
	ldesc = {
		"It's just a typical public matter mover.";
	}
	location = uptheoaktree
	noun = 'mover' 'mattermover'
	adjective = 'matter'
;
uptheoakfarmhouse: Distant
	sdesc = "farmhouse"
	ldesc = {
		"All you can see of the farmhouse is the roof, which
		looks like it could use some new shingles.";
	}
	location = uptheoaktree
	noun = 'house' 'farmhouse' 'roof' 'shingles'
	adjective = 'farm'
;
birdsnest: Distant
	sdesc = "bird's nest"
	ldesc = {
		"It's just a little bird's nest, made of typical
		bird's nest materials like twigs.";

		self.seebaby;
	}
	location = uptheoaktree
	noun = 'nest' 
	adjective = 'bird' 'bird\'s'

	seebaby = {
		if (rndchance(12))
			" You catch a glimpse of a little baby bird sticking
			its head out of the nest. An instant later it's hidden
			away again.";
		else if (rndchance(6))
			" You see a bird return to the nest with
			some branches and then fly away.";
	}

	verDoTake(actor) = { "The nest is far out of reach."; }
;
birdsnestbird: Distant
	sdesc = "bird"
	ldesc = "It's already out of sight."
	location = uptheoaktree
	noun = 'bird' 'baby'
	adjective = 'baby' 'parent' 'mother' 'father' 'adult'
;
branch: Decoration
	sdesc = "branch"
	ldesc = {
		"Carved in the bark is the phrase, \"Gavin Kelly luvs Ada
		Man 4Ever\".  Have you been here before or something?
		What an incredible coincidence!";
	}

	noun = 'branch' 'bark' 'tree' 'oak'
	adjective = 'oak'
	location = uptheoaktree
;
uptheoakswing: Distant
	sdesc = "tire swing"
	ldesc = "It looks like an ordinary tire swing from here."
	noun = 'swing' 'tireswing'
	adjective = 'tree' 'tire'
	location = uptheoaktree 
;
uptheoakrope: Decoration
	sdesc = "rope"
	ldesc = "The rope is tied to the branch here."
	noun = 'rope' 'knot'
	location = uptheoaktree

	verDoClimb(actor) = {}
	doClimb(actor) = {
		"You slide down the rope, being careful not to get 
		rope burns.\b";

		Me.travelto(tireswing);
	}

	verDoUntie(actor) = {
		"Somehow I don't think untying the rope would be a
		good idea.  It's your only way down, you know.";
	}	
;
behindhouse: Outside
	noun = 'farmhouse' 'farm' 'house'
	adjective = 'outside' 'farm' 'elwood' 'elwood\'s'

	sdesc = "Behind the Farmhouse"
	ldesc = {
		I(); "You are standing on the grassy lawn behind the 
		farmhouse. The lawn is quite big by Todian standards, 
		but is made to look rather insignificant by the vast 
		expanse of crops that border it on all sides.  It's 
		times like these that you wish your folks didn't live 
		in the city -- Tode's so crowded and noisy compared 
		to places like this.  But then again, maybe Foon's a 
		bit *too* rural..."; P();

		I(); "The farmhouse has a back door, but it doesn't
		look like it gets much use.  Given that, you suspect
		that the only ways to go from here are back around
		the house to the northeast and southeast."; P();

		I(); "There is a little tombstone in the ground
		nearby.";
	}

	ne = garden
	se = tireswing

	in = {
		"No way; at least not with the door shut like that.";
		return nil;
	}
	east = { return self.in; }
;
behindhousefarmhouse: Decoration
	sdesc = "farmhouse"
	ldesc = {
		"It just looks like an ordinary farmhouse from this
		vantage point.";
	}
	location = behindhouse
	noun = 'house' 'farmhouse' 'barn'
	adjective = 'farm'
;
behindhousecrops: Decoration
	sdesc = "crops"
	ldesc = {
		"They just look like typical crops, albeit very
		healthy ones.";
	}
	location = behindhouse
	noun = 'crops' 'plants' 'vegetables' 'corn'

	verDoPick(actor) = { "Grow some funk of your own!"; }
;
behindhouselawn: Decoration
	sdesc = "grassy lawn"
	ldesc = { "You're standing on it.  It looks normal."; }
	location = behindhouse
	noun = 'lawn' 'grass'
	adjective = 'grassy'
;
behindhousebackdoor: Decoration
	sdesc = "wooden back door"
	ldesc = {
		"The door is made of wood, and from the looks of it 
		very old.  It doesn't look all that secure, but on 
		the other hand it seems to be rusted shut, and you'd 
		guess that it hasn't been opened in years.";
	}
	location = behindhouse
	noun = 'door' 'hole' 'lock' 'hinge' 'hinges' 'backdoor'
	adjective = 'back' 'wooden' 'old' 'rusted' 'key' 'rusty'
	verDoOpen(actor) = {
		"No luck.  It's sealed tight.";
	}
	verDoUnlock(actor) = {
		"That's really not the problem; the hinges are just
		so rusty that it won't open despite being unlocked.";
	}
	verDoLock(actor) = {
		"Why bother?";
	}
	verDoAttackwith(actor, io) = {
		"I don't think the Elwoods would appreciate you
		busting into their house and destroying their
		back door in the process.  You might consider
		using the FRONT door instead.";
	}
	verDoKick(actor) = { self.verDoAttackwith(actor, nil); }
	verDoHit(actor) = { self.verDoAttackwith(actor, nil); }
	verDoHitwith(actor, io) = { self.veDoAttackwith(actor, io); }
;
pierretombstone: Decoration, Readable
	sdesc = "little granite tombstone"
	ldesc = {
		"The tombstone is small, very roughly carved, and
		made of granite. It looks to be hundreds of years
		old. ";

		self.readdesc;
	}
	readdesc = {
		"The weathered inscription on the tombstone reads:\b

		\tPierre\n
		\t1975-1992\n 
		\tOur faithful friend.\n
		\tRest in peace.";
	}
	location = behindhouse
	noun = 'tombstone' 'stone' 'headstone'
	adjective = 'pierre\'s' 'little' 'granite' 'dog\'s' 'dog'
		'poodle' 'poodle\'s' 'old' 'tomb' 'head'

	verDoLookunder(actor) = { "Don't be disgusting."; }
	verDoMove(actor) = {
		"No chance.  Wouldn't be respectful anyway.";
	}
	verDoTake(actor) = {
		"It's GRANITE.";
	}
	verDoKick(actor) = {}
	doKick(actor) = {
		"Someone in a position of extreme power relative to 
		you in this game doesn't like your attitude at all.";

		notify(deathobject, &death, 0);
	}
	verDoAttackwith(actor, io) = {}
	doAttackwith(actor, io) = { self.doKick(actor); }
	verDoPunch(actor) = {}
	doPunch(actor) = { self.doPunch(actor); }
;

/*
 * Inside the Elwood Farmhosue
 */
insidefarmhouse: Room
	noun = 'farm' 'house' 'farmhouse'
	adjective = 'farm' 'inside' 'elwood' 'elwood\'s'

	sdesc = "Inside the Farmhouse"
	ldesc = {
		I(); "You're standing in the entrance hallway of the 
		Elwood farmhouse.  The hardwood floors creak as you 
		walk upon them, and the earthy, rustic decor delights 
		your jaded cosmopolitan senses."; P();

		I(); "The front door is in the east wall. Ahead, to 
		the west, is the living room.";
	}
	east = farmhousefrontdoor2
	west = livingroom
;
farmhousedecor: Decoration
	sdesc = "farmhouse decor"
	ldesc = "The decor is charming."
	noun = 'decor'
	adjective = 'earthy' 'rustic' 'charming''delightful'
	location = insidefarmhouse
;
farmhousefrontdoor2: Door
	doordest = farmhousefront
	otherside = farmhousefrontdoor1

	isopen = true
	islocked = nil
	islockable = nil

	sdesc = "front door"
	adesc = { self.thedesc; }
	ldesc = {
		"It's just an ordinary wooden door.  It looks quite
		old but sturdy enough. ";

		inherited.ldesc;
	}
	location = insidefarmhouse

	noun = 'door'
	adjective = 'farm' 'house' 'farmhouse' 'wooden' 'sturdy' 'old'
;
livingroom: Room
	noun = 'room'
	adjective = 'living'

	sdesc = "Living Room"
	ldesc = {
		I(); "The EV dominates this simply furnished family 
		room -- it's nestled comfortably in the center of the 
		north wall, encased in a boxy dark wood enclosure 
		with feet shaped like those on an old bathtub.  A 
		burly old man is sacked out on the couch here in 
		front of the enterviewer, eyes completely glazed 
		over."; P();

		I(); "The kitchen is to the south.  A hall leads west.";

		P(); I(); livingroomEV.watchdesc;
	}
	east = insidefarmhouse
	south = kitchen
	west = hall
;
livingroomEV: ev
	setting = 778
	location = livingroom
;
couchman: Male, Actor
	sdesc = "old man on the couch"
	ldesc = {
		I(); "The old man has typical Foonian features:
		light green skin, wine-colored hair and thin,
		nearly horizontal eyebrows.  He is quite handsome
		but looks to have weathered a stormy life."; P();

		I(); "You sense that he is very much alive, but he 
		seems utterly comatose, clutching the EV's remote 
		control with what remains of his life's energy, alone 
		in a world of pictures and sounds from wherever, 
		oblivious to you and this moment, the next, or the 
		last."; P();

		I(); "You look into those ebony Foonian eyes, 
		searching for the man behind them, but see only the 
		reflected images of the current program.  And there, 
		in his eyes, you see them: every pixel discrete; every 
		one unique in the infrequent off-air snows, but each 
		now a tiny player in a meticulously but mindlessly 
		orchestrated ever-changing production -- each with a 
		role but none of any overall importance."; P();

		I(); "You turn to look at the EV directly.  And 
		conversely, there lies a reflection of the man.";
	}
	noun = 'man' 'farmer' 'mother' 'person' 'foonian' 'potato'
	adjective = 'old' 'comatose' 'couch'
	
	location = livingroom

	islistable(actor) = { return nil; }
	actordesc = {}

	nothere = { "The man doesn't even seem to know you're here."; }
	verIoGiveto(actor) =  { self.nothere; }
	verDoAskabout(actor, io) = { self.nothere; }
	verIoShowto(actor) = { self.nothere; }

	doSmell(actor) = { "He smells normal.  Are you?"; }
	verDoRub(actor) = { "Whatever you say... You get no reaction."; }	
	verDoAttackwith(actor, io)  = {}
	doAttackwith(actor, io) = {
		"The man does nothing in response.  You stop
		yourself.";
	}
	doSpraywith(actor, io) = {
		"Your hostile action does not get any reaction
		from the man.";
	}
;
manremote: Decoration
	sdesc = "EV remote control"
	ldesc = {
		"It's just an ordinary EV remote.  As usual, the
		EV can be operated without it.";
	}
	location = couchman
;

kitchen: Room
	noun = 'kitchen'
	
	sdesc = "Kitchen"
	ldesc = {
		I(); "You're in a fairly typical if slightly cramped 
		kitchen. Here you find the usual appliances: a 
		refrigerator, an oven with range top burners, and, on the
		counter, various food processing machines.  The cupboards
		appear to be well-stocked."; P();

		I(); "The living room is to the north.";
	}

	north = livingroom
;
kitchenmachines: Decoration
	sdesc = "food processing machines"
	adesc = { self.thedesc; }
	ldesc = {
		"By your standards, the machines are all very old, 
		but they all appear to be functional.  Among them are 
		a mixer, a blender, and an Akmi Slysor Dysor.";
	}
	location = kitchen
	noun = 'machines' 'processors'
	adjective = 'food' 'processing'
;
kitchenslysordysor: Item, Container
	on = nil

	islistable(actor) = {
		if (self.location = kitchencounter)
			return nil;
		else
			return true;
	}

	sdesc = "Akmi Slysor Dysor"
	ldesc = {
		I(); "The Akmi Slysor Dysor is a fearsome contraption. 
		With 33 different blades and 194 additional 
		attachements, this thing is a vegetable's worst 
		nightmare."; P();

		I(); "Designed to be easy to use, the Dysor only has 
		one setting -- \"on\".  It uses patented Akmi Fuz-E 
		Artyfishal Nooral Intellujince to determine the most 
		appropriate action for the item you insert. 
		Unfortunately, the Dysors tend to prefer pureeing 
		over all other options "; note(self); "."; P();

		I(); inherited.ldesc; " ";
		if (self.on)
			"It is currently running.";
		else
			"It is currently off.";
	}
	location = kitchencounter
	locationtype = 'on'

	noun = 'dysor' 'slysor' 'dicer' 'slicer'
	       'blade' 'blades' 'attachments'
	adjective = 'akmi' 'acme' 'slysor' 'slicer' 'additional'

	bulk = 6
	weight = 3

	verDoTurnon(actor) = {
		if (self.on)
			"It's already running.";
	}
	doTurnon(actor) = {
		if (rndchance(12)) {
			"There is a pregnant pause.  The machine does 
			nothing.  Then, suddenly, it explodes in a 
			giant pillar of flame that takes out the 
			entire surrounding area, including you.";

			notify(deathobject, &death, 0);
			return;
		}

		if (length(self.contents) > 0) {
			"Seconds after you turn on the Dysor there is 
			a terrible grinding noise, and a cloud of 
			thick black smoke billows up. When you look 
			back, the machine is completely empty.";

			while (length(self.contents) > 0)
				self.contents[1].movein(nil);
		}
		else
			"With a hideous squawk the machine spins up.";

		self.on := true;
	}
	verDoTurnoff(actor) = {
		if (not self.on)
			"It's already off.";
	}
	doTurnoff(actor) = {
		"The machine grinds slowly to a halt.";
		self.on := nil;
	}

	ioPutin(actor, dobj) = {
		if (dobj.bulk > 1) {
			caps(); dobj.thedesc; " is too big to
			fit in "; self.thedesc; ".";
		}
		else if (self.on) {
			"The machine makes a whirring sound as it 
			changes setting, and "; dobj.thedesc;
			" is soon transformed into a swirling goo.  
			Moments later, not a trace is left. My 
			goodness, the Dysor seems to have completely 
			vaporized "; dobj.thedesc; ".";

			dobj.movein(nil);
		}
		else
			inherited.ioPutin(actor, dobj);
	}

	footnote = { "They also tend to explode without warning."; }
;
kitchenblender: Item, Container
	islistable(actor) = {
		if (self.location = kitchencounter)
			return nil;
		else
			return true;
	}
	
	sdesc = "blender"
	ldesc = {
		"It just looks like an average blender.";
	}
	location = kitchencounter
	locationtype = 'on'

	noun = 'blender'
	adjective = 'average'

	bulk = 6
	weight = 3

	verDoTurnon(actor) = { "Click."; }
	verDoTurnoff(actor) = { "It's already off."; }
	ioPutin(actor, dobj) = {
		if (dobj.bulk > 1) {
			caps(); dobj.thedesc; " is too big to
			fit in "; self.thedesc; ".";
		}
		else
			inherited.ioPutin(actor, dobj);
	}
;
kitchenmixer: Item, Container
	on = nil
	
	islistable(actor) = {
		if (self.location = kitchencounter)
			return nil;
		else
			return true;
	}
	
	sdesc = "mixer"
	ldesc = {
		"It's an ordinary kitchen mixer.  Unfortunately, it 
		seems to be missing the metal beaters, and is 
		therefore useless.";
	}
	location = kitchencounter
	locationtype = 'on'

	noun = 'mixer' 
	adjective = 'useless' 'ordinary' 'kitchen'

	bulk = 6
	weight = 3

	verDoTurnon(actor) = {
		if (self.on)
			"It's already running.";
	}
	doTurnon(actor) = {
		"You turn on the machine, and it happily begins 
		pointlessly running without its beaters.";
		
		self.on := true;
	}
	verDoTurnoff(actor) = {
		if (not self.on)
			"It's already off.";
	}
	doTurnoff(actor) = {
		"The machine stops.";
		self.on := nil;
	}

	ioPutin(actor, dobj) = {
		if (dobj.bulk > 1) {
			caps(); dobj.thedesc; " is too big to
			fit in "; self.thedesc; ".";
		}
		else
			inherited.ioPutin(actor, dobj);
	}
;
kitchencounter: Surface
	sdesc = "counter"
	location = kitchen
	noun = 'countertop'
	adjective = 'kitchen'
;
kitchenfridge: Openable, Qcontainer, Surface
	isopen = nil
	sdesc = "refrigerator"
	ldesc = {
		I(); "The refrigerator looks to be a model that was 
		popular on Tode 75 years ago.  It is functional but 
		the aesthetics could use work -- it's just a basic 
		white box; nothing at all like today's popular 
		day-glo spherical models, and -- this is the good 
		part -- you have to open it with the *handle*. 
		Unbelievable!"; P();
		
		I(); inherited.ldesc; 

		// list things on the fridge
		// if nothing, don't say anything
		" "; self.doLookX(Me, 'on', true);

	}
	location = kitchen
	noun = 'fridge' 'refrigerator'
	adjective = 'old' 'functional' 'white' 'boxy'
	maxbulk = 30

	ioPuton(actor, dobj) = {
		if (dobj = letterq)
			inherited.ioPuton(actor, dobj);
		else
			"There's no good surface on the refrigerator.";
	}
;
cheese: Edible
	sdesc = "hunk of cheese"
	noun = 'cheese' 'hunk'
	plural = 'food'
	location = kitchenfridge
;
grapes: Edible
	isplural = true
	sdesc = "grapes"
	noun = 'grapes'
	plural = 'food'
	location = kitchenfridge
;
tomato: Edible
	sdesc = "overripe tomato"
	adesc = "an <<self.sdesc>>"
	noun = 'tomato'
	plural = 'food'
	adjective = 'overripe' 'over' 'ripe' 'over-ripe'
	location = kitchenfridge
;
butter: Edible
	sdesc = "stick of butter"
	noun = 'butter' 'stick'
	plural = 'food'
	location = kitchenfridge

	doEat(actor) = { "Bleah.  You feel kind of queasy now."; }
;
salami: Edible
	sdesc = "piece of salami"
	noun = 'salami' 'piece'
	plural = 'food'
	location = kitchenfridge
;
bananas: Edible
	total = 6

	isplural = {
		if (self.total > 1)
			return true;
		else
			return nil;
	}
	sdesc = {
		if (self.isplural)
			"<<self.total>> bananas";
		else
			"banana";
	}
	ldesc = {
		if (self.isplural)
			"They look like <<self.total>> ordinary
			bananas.";
		else
			"It looks like an ordinary banana.";
	}

	noun = 'bananas'
	plural = 'food'
	location = kitchenfridge
	doEat(actor) = {
		if (self.total = 1)
			"You eat the last banana.";
		else
			"You eat one of the bananas.";

		" It's delicious!";
		self.total--;

		if (self.total = 0)
			self.movein(nil);
	}
;

class Synthegg: Edible
	cracked = nil
	sdesc = {
		"raw Synthegg";

		if (Synthegg.cracked)
			" yolk";
	}
	ldesc = {
		"The SynthEgg is an egg substitute which supposedly 
		tastes just like the real thing. It looks pretty much 
		like a regular egg, but ";

		if (Synthegg.cracked)
			"you notice that the yolk";
		else
			"it";

		" doesn't have quite the right color";

		if (not Synthegg.cracked)
			", and it's too	light to be real";
		
		".";
	}

	verDoEat(actor) = { "Yuck; it's raw."; }
	verDoBreak(actor) = {}
	doBreak(actor) = {
		if (Synthegg.cracked)
			"\^<<self.subjthedesc>> is already cracked!";
		else {
			"You crack open <<self.objthedesc(nil)>>.";
			self.crack;
		}
	}

	crack = {
		Synthegg.cracked := true;
		syntheggyolk.moveto(synthegg.location, synthegg.locationtype);
		synthegg.movein(nil);
		syntheggyolk.makeknownto(Me);
	}
;
synthegg: Synthegg
	noun = 'synthegg' 'egg' 'substitute'
	adjective = 'synth' 'egg' 'raw'
	plural = 'eggs'
	location = kitchenfridge
;
syntheggyolk: Synthegg
	noun = 'synthegg' 'egg' 'substitute' 'yolk'
	adjective = 'synth' 'egg' 'raw' 'synthegg' 'substitute'
	plural = 'eggs' 'yolks'
	location = nil
;

kitchenoven: Qcontainer
	isopen = nil
	sdesc = "oven"
	ldesc = {
		"The oven is an old and fairly primitive model, but it 
		looks adequate.  There are four burners on the range 
		top.";
	}
	location = kitchen
	noun = 'oven' 'stove' 'range'
	adjective = 'old' 'primitive'

	verDoTurnon(actor) = { 
		"The pilot light seems to be out, but the burners
		might work...";
	}
	verDoTurnoff(actor) = { "It's not on."; }
	verIoPuton(actor) = {}
	ioPuton(actor, dobj) = { kitchenstovetop.ioPuton(actor, dobj); }
	verDoLookon(actor) = {}
	doLookon(actor) = { kitchenstovetop.doLookon(actor); }
	verIoTakeoff(actor) = {}
	ioTakeoff(actor, dobj) = { kitchenstovetop.ioTakeoff(actor, dobj); }

	acceptsput(actor, loctype) = {
		if (loctype = 'in' or loctype = 'on')
			return true;
		else
			return nil;
	}
;
kitchenovenpilotlight: Decoration
	sdesc = "oven pilot light"
	adesc = { "an "; self.sdesc; }
	noun = 'light'
	adjective = 'oven' 'pilot' 'range'
	location = kitchen

	verDoLight(actor) = { "You don't have anything to light it with."; }
;
kitchencupboard: Qcontainer
	isplural = true
	sdesc = "kitchen cupboards"
	ldesc = { self.contdesc(Me); }
	location = kitchen
	noun = 'cupboards' 'cabinets' 'pantry'
	verDoOpen(actor) = {}
	doOpen(actor) = { "Opened."; }
	verDoClose(actor) = {}
	doClose(actor) = { "Closed."; }
;
kitchendrygoods: Decoration
	isplural = true
	sdesc = "miscellaneous dry goods"
	ldesc = {
		"They're just typical kitchen stuff -- nothing
		exciting.";
	}
	verDoTake(actor) = {
		"You don't need any of that junk!";
	}
	noun = 'goods'
	adjective = 'dry'
	location = kitchencupboard
;
pot: Item, Container
	msg = true

	sdesc = "frying pan"
	ldesc = "It's just an ordinary frying pan."
	location = kitchencupboard
	noun = 'skillet' 'pot' 'pan' 'griddle' 'saucepan'
	adjective = 'cooking' 'metal' 'frying'
	weight = 3
	bulk = 5

	putmessage(dobj, loctype) = { 
		if (self.msg)
			"Done.";
	}

	ioPutin(actor, dobj) = {
		if (dobj = synthegg or dobj = egg) {
			"Do you want to crack <<dobj.objthedesc(nil)>>\ 
			first? (YES or NO) > ";

			if (yorn() = 1) {
				"You crack <<dobj.objthedesc(nil)>>\ 
				into the pan. ";

				dobj.crack;
				if (dobj = synthegg)
					dobj := syntheggyolk;
				else
					dobj := eggyolk;

				self.msg := nil;
			}
			else
				"Okay. ";
		}

		inherited.ioPutin(actor, dobj);
		self.msg := true;

		if (self.ison(kitchenstovetop) and kitchenstovetop.on)
			if (dobj = synthegg or dobj = syntheggyolk or dobj = egg or dobj = eggyolk or dobj = friedegg or dobj = friedsynthegg)
				kitchenstovetop.cookit;
	}
;
class Egg: Edible
	cracked = nil
	sdesc = {
		"raw Foonian egg";

		if (Egg.cracked)
			" yolk";
	}
	ldesc = {
		"It just looks like an ordinary Foonian egg ";
		if (Egg.cracked)
			"yolk ";

		note(self); ".";
	}

	verDoEat(actor) = { "Yuck; it's raw."; }
	verDoBreak(actor) = {}
	doBreak(actor) = {
		if (Egg.cracked)
			"\^<<self.subjthedesc>> is already cracked!";
		else {
			"You crack open <<self.objthedesc(nil)>>.";
			self.crack;
		}
	}

	crack = {
		Egg.cracked := true;
		eggyolk.moveto(egg.location, egg.locationtype);
		egg.movein(nil);
		eggyolk.makeknownto(Me);
	}
	
	footnote = {
		"Said to make the best fried eggs in the galaxy --
		even better than the ones that come from Todian
		chickens, and so much more politically correct!";
	}
;
egg: Egg
	noun = 'egg'
	adjective = 'foonian' 'raw'
	plural = 'eggs' 'food'
;
eggyolk: Egg
	noun = 'egg' 'yolk'
	adjective = 'foonian' 'raw' 'egg'
	plural = 'eggs' 'yolks' 'food'
;
friedegg: Edible
	sdesc = "fried Foonian egg"
	ldesc = "It just looks like an ordinary fried egg."
	noun = 'egg'
	adjective = 'fried' 'foonian'
	plural = 'eggs' 'food'

	location = nil
;
friedsynthegg: Edible
	sdesc = "fried SynthEgg"
	ldesc = {
		"It looks just like a real fried egg.  You'd have to 
		be a real ova Eggspert to tell the difference ";
		note(self); ".";
	}

	footnote = { "Har!"; }

	noun = 'synthegg' 'egg' 'substitute'
	adjective = 'fried' 'egg' 'synth' 'synthetic'
	plural = 'eggs'

	location = nil
;
cinder: Item
	sdesc = "cinder"
	ldesc = "It's a fried-egg-shaped cinder."
	noun = 'cinder'
	adjective = 'fried' 'egg' 'shaped' 'fried-egg' 'egg-shaped'
			'fried-egg-shaped'
	location = nil
	verDoEat(actor) = { "You must be joking."; }
;
synthcinder: Item
	sdesc = "synthetic-looking cinder"
	ldesc = "It's a fried-SynthEgg-shaped cinder."
	noun = 'cinder'
	adjective = 'fried' 'synth' 'egg' 'shaped' 'fried-egg' 'egg-shaped'
			'synth-egg-shaped' 'fried-egg-shaped' 'synthetic' 
	location = nil
	verDoEat(actor) = { "You must be joking."; }
;
kitchenstovetop: Surface
	on = nil
	sdesc = "stove top"
	ldesc = {
		"There's nothing particularly striking about the
		stove top.";
		
		if (self.on)
			" One of the burners is on.";
	}
	location = kitchen
	noun = 'top' 'burners'
	adjective = 'stove' 'range' 'top'

	ioPuton(actor, dobj) = {
		if (dobj = synthegg or dobj = syntheggyolk or dobj = egg or dobj = eggyolk)
			"You need something to cook it in!";
		else if ((dobj = firecracker or dobj = firecrackerfuse) and self.on) {
			"The heat from the burner lights the fuse!  The
			firecracker makes a little <POP> in the process
			of vaporizing.";

			incscore(-1);

			firecracker.movein(nil);
		}
		else if (dobj <> pot)
			"Don't be silly.";
 		else if (self.on)
			self.cookit;
		else
			inherited.ioPuton(actor, dobj);
	}

	cookit = {
		local cooked := nil;

		if (friedegg.isin(pot)) {
			"The fried egg gets burned to a cinder. Nice one. ";

			cooked := true;
			friedegg.movein(nil);
			cinder.movein(pot);
		}
		if (eggyolk.isin(pot)) {
			"The egg cooks up nicely. ";

			cooked := true;
			eggyolk.movein(nil);
			friedegg.movein(pot);
		}
		if (egg.isin(pot)) {
			"You'll have to crack the egg to cook it. ";
		}
		if (friedsynthegg.isin(pot)) {
			"The fried SynthEgg gets burned to a cinder. 
			Congratulations, Champ. ";

			cooked := true;
			friedsynthegg.movein(nil);
			synthcinder.movein(pot);
		}
		if (syntheggyolk.isin(pot)) {
			"The SynthEgg cooks up just like a real egg! ";
			cooked := true;
			syntheggyolk.movein(nil);
			friedsynthegg.movein(pot);
		}
		if (synthegg.isin(pot)) {
			"You'll have to crack the SynthEgg
			to cook it. ";
		}
		// other amusing things here

		if (cooked) {
			" You take the pan off the burner.";
			pot.movein(Me);

			//
			// Make new stuff in the pan known to the player.
			//
			pot.makecontentsknownto(Me);
		}
		else {
			"The pan heats up.";
		}

	}
	
	verDoTurnon(actor) = {
		if (self.on)
			"One of the burners is already on.";
	}
	doTurnon(actor) = {
		"You turn on one of the burners.  It heats
		up rapidly.";

		self.on := true;
		
		if (pot.ison(self)) {
			" "; self.cookit;
		}
	}
	verDoTurnoff(actor) = {
		if (not self.on)
			"All the burners are already off.";
	}
	doTurnoff(actor) = {
		"You turn off the burner.";
		self.on := nil;
	}
;

hall: Room
	noun = 'hall'
	adjective = 'elwood' 'elwood\'s'

	sdesc = "Hall"
	ldesc = {
		I(); "This narrow hall is similar to the one at the 
		farmhouse entrance.  A wooden staircase leads up from 
		here; unfortunately, it also leads up to a 
		protective-looking dog who is currently barking his
		head off at you."; P();

		I(); "At the end of the hall, further west, is the
		back door.  It looks like it's been sealed shut.";
	}
	east = livingroom
	west = {
		"You try to open the old door, but with no success.";
		return nil;
	}
	up = {
		"As you begin ascending the staircase you find that 
		the dog's volume level is inversely proportional to 
		your distance from him, though he refuses to leave 
		his perch several steps above you.  As you near the 
		top, you hear a female voice yell from an upstairs 
		room, \"Rockoo, quit thawt bullering; it's jest eh 
		frawgen churrel!\"  You hastily retreat.";
	}
;
staircase: Decoration
	sdesc = "wooden staircase"
	noun = 'staircase' 'case' 'stairs' 'steps'
	adjective = 'stair' 'wooden' 'wood'
	location = hall
;
halldoor: Decoration
	sdesc = "wooden door"
	location = hall
	noun = 'door' 'hole' 'lock' 'hinge' 'hinges' 'backdoor'
	adjective = 'back' 'wooden' 'old' 'rusted' 'key' 'rusty'
	verDoOpen(actor) = {
		"No luck.  It's sealed tight.";
	}
	verDoUnlock(actor) = {
		"That's really not the problem; the hinges are just
		so rusty that it won't open despite being unlocked.";
	}
	verDoLock(actor) = {
		"Why bother?";
	}
	verDoAttackwith(actor, io) = {
		"I don't think the Elwoods would appreciate you
		busting into their house and destroying their
		back door in the process.  You might consider
		using the FRONT door instead.";
	}
	verDoKick(actor) = { self.verDoAttackwith(actor, nil); }
	verDoHit(actor) = { self.verDoAttackwith(actor, nil); }
	verDoHitwith(actor, io) = { self.veDoAttackwith(actor, io); }
;
stepsdog: Male, Actor
	sdesc = "dog"
	ldesc = {
		I(); "It's an annoying but spirited pooch that looks much 
		like the ones you have on your native Tode. On Tode 
		you would call this animal a \"mutt,\" but you can't 
		be sure that it's not *supposed* to look like that 
		here."; P();

		I(); "You get the feeling that it has better vocal 
		cords than fangs.";
	}
	smelldesc = "He smells doggy even from here."

	noun = 'dog' 'pooch' 'mutt' 'animal' 'rocky' 'doggy' 'puppy'
	adjective = 'annoying' 'spirited' 'barking' 'guard'
	
	location = hall

	actordesc = {}
	islistable(actor) = { return nil; }	// don't print actordesc

	nointerest = {
		"The animal shows no interest whatsoever.  It doesn't 
		exactly give you the impression that it is a rocket 
		scientist among dogs.";
	}
	
	verIoGiveto(actor) =  {}
	ioGiveto(actor, dobj) = {
		if (isclass(dobj, Edible)) {
			"You toss <<dobj.objthedesc(nil)>> to
			the dog, who quickly devours
			<<dobj.objprodesc(nil)>>.";

			dobj.movein(nil);
		}
		else if (dobj = firecracker) {
		        "The dog sniffs <<dobj.objthedesc(nil)>> suspiciously,
			then decides against eating it.  Glaring, it kicks it
			back to you.";
		}
		else
			self.nointerest;
	}

	scramble = { 
		"The dog is transformed into a powerful deity!  You
		sit up and beg, but the deity smites you for your
		arrogance anyway!";

		notify(deathobject, &death, 0);
	}

	verDoAskabout(actor, io) = { self.nointerest; }
	verIoShowto(actor) = { self.nointerest; }

	verDoRub(actor) = { "You can't really get close enough."; }	
	verDoAttackwith(actor, io)  = {}
	doAttackwith(actor, io) = {
		"In order to comply with the wishes of animal rights 
		groups, we can allow no dogs to be harmed in this 
		game.  Sorry.";
	}
	verDoKick(actor) = {}
	doKick(actor) = { self.doAttackwith(actor, nil); }
	verDoHit(actor) = {}
	doHit(actor) = { self.doAttackwith(actor, nil); }
	verDoHitwith(actor, io) = { self.verDoAttackwith(actor, io); }
	doHitwith(actor, io) = { self.doAttackwith(actor, io); }

	verDoSpraywith(actor, io) = {}
	doSpraywith(actor, io) = {
		"You spray the dog with the repellent.  The dog
		likes the repellant!  For a moment it seems like
		the dog is having hallucinations -- it barks
		oddly and chases its tail, then lolls its tongue
		back and forth.  But the dog soon returns to normal.";
	}
;

#endif	/* DEMO */
