#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"
#include "qtalk.h"
//Quip template "desc"? "reply"?;

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// THE CELL: the room
// THE CELL: vd1Daemon (pseudodaemon)
// THE CELL: contents of room
// THE CELL: ary ung and T-remover transformed objects
// THE CELL: food dispenser and related items
// THE FOOD DISPENSER MENU
// THE VICKI/DIANE CONVERSATION
// PRIOR TO CUT SCENE 3
// CUT SCENE 3
// CELL BANNER PICTURE
// DEBUG STUFF

// -------------------------------------------------------------------
// NOTES
// -------------------------------------------------------------------

// This file is meant to include pretty much everything that happens
// in the cell during the intro part of the game -- *except it does 
// not define NPCs or things directly related to NPCs, such as NPC 
// collectivegroups, objects owned by NPCs, etc.*
// 
// As such, this file basically includes two things:
// 
// (1) the cell and its component objects, and
// (2) the conversation you have with Vicki and Diane in the cell.

// -------------------------------------------------------------------
// THE CELL: the room
// -------------------------------------------------------------------

cell: FormerRoomShadowCaster, AlienRoom 'Cell'
  desc {
    "This spartan room is dominated on one side 
      by a bunk bed for three people. ";
    if (foodDispenser.isIn(self) || cellToilet.isIn(self)) {
      "On the other side is ";
      if (foodDispenser.isIn(self))
        "a <<foodDispenser.descNounPhrase>>";
      if (foodDispenser.isIn(self) && cellToilet.isIn(self))
        " and, to its right, ";
      if (cellToilet.isIn(self))
        "something resembling a toilet";
      ". ";
    }
    if (cellDoor.isOpen)
      "To the north, an open door leads into a hallway. ";
    else
      "A door stands closed to the north. ";
  }
  // for vocabWords, see modifications in 3endgame.t.
  showTerminalPic = nil
  showKillYouPic = nil
  bannerValue() {
    if (glob.isInEndgame)
      return endgame;
    else {
      if (cell.showTerminalPic && foodCube.location == foodBin)
        return cellFood;
      else if (cell.showKillYouPic)
        return cellKill;
      else if (cell.showTerminalPic)
        return cellTerm;
      else
        return cellPris;
    }
  }
  actorTravelingWithin(origin, dest) {
    if (gActor == gPlayerChar && !glob.isInEndgame
        && (dest == lowerBunk || dest == middleBunk)
        && dest.bunkOwner.canSee(gPlayerChar)) {
      local reactionTxt;
      if (dest.bunkOwner == diane)
        reactionTxt = 'She scowls at you. ';
      else // vicki
        reactionTxt = 'She frowns at you. ';
      reportFailure('\^' + dest.bunkOwner.theName + ' sees you
          heading toward ' + dest.theName + ' and says, 
          <.q>Hey! That<./s>s my bunk!<./q> ' + reactionTxt + '
        <p>You decide not to get onto ' + dest.theName 
          + ' after all. ');
      dest.hasBeenAttempted = true;
      exit;
    }
    if (dest == upperBunk && !dest.hasBeenAttempted) {
      dest.initializeVocabWith('your my -');
      dest.hasBeenAttempted = true;
    }
    if (!dest.hasBeenAttempted) {
      dest.hasBeenAttempted = true;
    }
  }
  getDoorForLeavingRoom = cellDoor
  roomParts = [cellFloor, defaultCeiling, defaultWalls]
  isInColumn = 1
  isInRow = 6
  north =   cellDoor
  out asExit(north)
  // Obviously debugging crap from months past. I'll keep it here 
  // commented out as a reminder to maybe handle Yell here again
  // in the future.
  //roomAfterAction {
  //  if (gActionIs(Yell)) {
  //    "<.p>gActionIs(Yell). ";
  //    hat.moveInto(vicki);
  //    nestedActorAction(vicki, Drop, hat);
  //  }
  //}
  roomDaemon() {
    if (vicki.location == self && diane.location == self
        && !glob.isInEndgame) {
      vd1Daemon.daemon;
    }
    // This is all that's normally in roomDaemon():
    //if (atmosphereList != nil)
    //  atmosphereList.doScript();
  }
;

// -------------------------------------------------------------------
// THE CELL: vd1Daemon (pseudodaemon)
// -------------------------------------------------------------------

vd1Daemon: object // only a nominal daemon, not a real one.
  daemon {
    if (daemonCount) {
      daemonCount--;
      return;
    }
    if (gActionIs(Sleep)) {
      return;
    }
    
    daemonList.doScript;
    
    return;
  }
  daemonCount = 2
  daemonList: ShuffledEventList {
    [
       'Diane glances at the walls for a few moments, then 
         turns her attention back to the floor. '
      ,nil
      ,'Vicki adjusts her shirt. '
      ,nil
      ,'Diane walks over to the food dispenser, as if thinking
         of getting some food. Then she walks back, muttering,
         <.q>I<./s>m not <i>that</i> hungry.<./q> '
      ,nil
      ,'Vicki walks over and studies the food dispenser for 
         a moment. Then, seeing nothing new, she walks back. '
      ,nil
      ,nil
      ,'Diane sighs. '
      ,nil
      ,'Vicki walks over to the bunk bed for a moment and runs her
         hands over it, dusting it off. Then, wiping her hands, 
         she returns to where she was. '
      ,nil
      ,'Diane runs her fingers through her hair. '
      ,nil
      ,'Vicki begins to whistle a tune, but then Diane casts
         her a glance of annoyance. Vicki shrugs and stops
         whistling. '
      ,nil
      ,nil
    ]
  }
;

// -------------------------------------------------------------------
// THE CELL: contents of room
// -------------------------------------------------------------------

cellFloor: defaultFloor
  // Remove from the cell any default things to sit on.
  // "Sit" should not assume that players mean the bed bunks,
  // but neither should it assume the toilet or the floor.
  hideFromDefault(action) {
    if (action.ofKind(SitOnAction))
      return true;
    return inherited(action);
  }
;

bunkBed: FormerShadowCaster, Soft, Fixture 
  'metal frame (bunk) bed bunkbed ladder -' 
  'bunk bed'
  @cell
  "The bunk bed is held up by a metal frame
    with a ladder, and supports three bunks, 
    which are so close together that there are 
    barely two feet between each of them. "
  canBeVaporized = nil
  shadowVocabWords = '(metal) (frame) (lower) (bottom) (middle) (upper) (top) bunk bed bunkbed ladder -'
  shadowList = [hallway3]
  dobjFor(Climb) {
    verify() { }
    check() { }
    action() {
      if (gActor.location == upperBunk)
        replaceAction(GetOffOf, upperBunk);
      else
        replaceAction(LieOn, upperBunk);
    }
  }
  dobjFor(ClimbUp) {
    verify() {
      if (gActor.location == upperBunk)
        illogicalAlready('You<./s>re already as high
          up as you can go. ');
    }
    check() { }
    action() {
      replaceAction(LieOn, upperBunk);
    }
  }
  dobjFor(ClimbDown) {
    verify() {
      if (gActor.location == upperBunk)
        logical;
      else if (gActor.location == middleBunk)
        illogical('You don<./s>t need to climb down the
          ladder from where you are. You can just
          get out. ');
      else if (gActor.location == lowerBunk)
        illogicalAlready('You<./s>re already about
          as far down as you<./s>re going to get. ');
      else
        illogicalAlready('You<./s>re already
          at the bottom of the ladder. ');
      
    }
    check() { }
    action() {
      replaceAction(GetOffOf, upperBunk);
    }
  }
  dobjFor(LieOn) {
    verify() {
      if (gActor.location.ofKind(Bunk))
        illogicalAlready('You<./s>re already lying on ' 
          + gActor.location.theName + '. ');
    }
    check() { }
    action() {
      if (upperBunk.hasBeenAttempted)
        replaceAction(LieOn, upperBunk);
      else
        "You<./s>ll have to specify which bunk you want to lie on:
          the lower bunk, the middle bunk, or the upper bunk. ";
    }
    //action() {
    //  if (upperBunk.hasBeenAttempted)
    //    replaceAction(LieOn, upperBunk);
    //  else if (!lowerBunk.hasBeenAttempted)
    //    replaceAction(LieOn, lowerBunk);
    //  else if (!middleBunk.hasBeenAttempted)
    //    replaceAction(LieOn, middleBunk);
    //  else
    //    replaceAction(LieOn, upperBunk);
    //}
  }
  dobjFor(Enter) asDobjFor(LieOn)
  dobjFor(Board) asDobjFor(LieOn)
  dobjFor(Use)   asDobjFor(LieOn)
  iobjFor(PutOn) {
    verify {
      if (gDobj)
        illogical('The bunk bed has a lower bunk, a middle bunk, and
          an upper bunk. You<./s>ll have to specify which of the
          bunks to put {it dobj/him} on. ');
    }
  }
  dobjFor(GetOutOf) {
    verify() {
      if (gActor.location.ofKind(Bunk))
        logical;
      else
        illogical(&notOnPlatformMsg);
    }
    action() {
      replaceAction(GetOutOf, gActor.location);
    }
  }
  dobjFor(GetOffOf) {
    verify() {
      if (gActor.location.ofKind(Bunk))
        logical;
      else
        illogical(&notOnPlatformMsg);
    }
    action() {
      replaceAction(GetOffOf, gActor.location);
    }
  }
  cannotSitOnMsg =
    'None of the bunks have enough room above them
      to allow you to sit upright. If you want to be 
      on the bunks, you<./s>ll have to lie down instead. '
  actorInPrep = 'on'
;

class Bunk: OutOfReach, Soft, Bed, Fixture
  cannotSitOnMsg =
    'There<./s>s no room to sit upright on ' + theName + ',
      since the next bunk is barely two feet above it. '
  cannotStandOnMsg =
    'Standing up on top of ' + theName + ' is out of the question.
      The next bunk is barely two feet above it. '
  bunkOwner = nil
  // "Enter" stuff
  roomOkayPostureChangeMsg(posture, obj) {
    gMessageParams(obj);
    return bunkEnterTxt;
  }
  dobjFor(Enter) asDobjFor(LieOn)
  // "Exit" stuff
  disembarkRoom() {
    say(bunkExitTxt);
    replaceAction(GetOffOf, self);
  }
  dobjFor(Use) {
    verify { }
    check { }
    action {
      if (gActor.isIn(self))
        replaceAction(Sleep);
      else
        replaceAction(LieOn, self);
    }
  }
  okayNotStandingOnMsg = (bunkExitTxt)
  iobjFor(PutOn) {
    check {
      if (gActor == gPlayerChar && !glob.isInEndgame
          && (self == lowerBunk || self == middleBunk)
          && bunkOwner.canSee(gPlayerChar)) {
        local reactionTxt;
        if (bunkOwner == diane)
          reactionTxt = 'She scowls at you. ';
        else // vicki
          reactionTxt = 'She frowns at you. ';
        reportFailure('\^' + bunkOwner.theName + ' sees you
            heading toward {the iobj/him} and says, 
            <.q>Hey! That<./s>s my bunk!<./q> ' + reactionTxt + '
          <p>You decide not to put {the dobj/him} onto 
            {the iobj/him}  after all. ');
        exit;
      }
    }
  }
  //out : TravelMessage { 
  //  -> cell
  //  "<<bunkExitTxt>>"
  //}
  //out : TravelConnector { 
  //  preCond = []
  //  verify() { }
  //  check() { }
  //  action() {
  //    replaceAction(GetOffOf, self);
  //  }
  //}
  makeStandingUp() {
    gActor.makePosture(location.defaultPosture);
    gActor.travelWithin(location);
    ///* generate the appropriate default for the new location */
    //gActor.okayPostureChange();
    say(bunkExitTxt);
  }
  hasBeenAttempted = nil
  canObjReachContents(obj) { return true; }
  canReachFromInside(obj, dest) {
    local selfVal, destVal;
    if (dest.ofKind(Bunk)) {
      if (self == lowerBunk ) selfVal = 1;
      if (self == middleBunk) selfVal = 2;
      if (self == upperBunk ) selfVal = 3;
      if (dest == lowerBunk ) destVal = 1;
      if (dest == middleBunk) destVal = 2;
      if (dest == upperBunk ) destVal = 3;
      // if dest is the bunk the obj is on, or if it is
      // the bunk directly above the one the obj is on,
      // return true.
      if (destVal == selfVal || destVal - 1 == selfVal)
        return true;
    }
    if (dest == bunkBed) return true;
    return nil;
  }
  //canReachSelfFromInside(obj) { return true; }
  //performEntry(posture) {
  //  if (posture != lying) {
  //    "No. ";
  //    exit;
  //  }
  //}
  
  // This method hacked so that sitting on the bunks is 
  // not illogical. 
  // The object here is to make it so that
  // if you type "sit," the game won't assume you mean
  // to sit on the toilet.
  // While we're at it, also handle "stand"
  allowedPostures = [lying]
  obviousPostures = [lying]
  //dobjFor(Sit) {
  //  verify { }
  //  check {
  //    //say(cannotSitOnMsg);
  //    "Yowzers. ";
  //    exit;
  //  }
  //}
  //dobjFor(Stand) {
  //  verify { }
  //  check {
  //    say(cannotStandOnMsg);
  //    exit;
  //  }
  //}
  wordName = 'bunk'
;

lowerBunk: Bunk
  'lower bottom bunk/mattress*bunks*mattresses'
  'lower bunk'
  @cell
  "The lower bunk is very close to the floor, and barely 
    two feet below the middle bunk. "
  bunkOwner = diane
  bunkEnterTxt = 'You bend down and barely squeeze 
    onto the lower bunk. '
  bunkExitTxt = 'You squeeze out of the lower bunk. '
;

middleBunk: Bunk
  'middle bunk/mattress*bunks*mattresses'
  'middle bunk'
  @cell
  "The middle bunk is about waist-high, 
    barely two feet above the lower bunk, 
    and barely two feet below the upper bunk. "
  bunkOwner = vicki
  bunkEnterTxt = 'You step onto your tiptoes and squeeze 
    with difficulty onto the middle bunk. '
  bunkExitTxt = 'You squeeze out of the middle bunk 
    and manage with difficulty to reach the floor below. '
  //actorTravelingWithin(origin, dest) {
  //  if (gActor == gPlayerChar && !glob.isInEndgame
  //      && bunkOwner.canSee(gPlayerChar) && self == dest) {
  //    reportFailure('\^' + bunkOwner.theName + ' sees you
  //        heading toward ' + dest.theName + ' and says, 
  //        <.q>Hey! That<./s>s my bunk!<./q> She gives
  //        you a mean look.
  //      <p>You decide not to get onto ' + dest.theName 
  //        + ' after all. ');
  //    exit;
  //  }
  //}
;

upperBunk: Bunk
  'upper top bunk/mattress*bunks*mattresses'
  'upper bunk'
  @cell
  "The upper bunk is at about the level of your head, 
    barely two feet above the middle bunk, 
    and barely two feet below the ceiling. "
  cannotSitOnMsg =
    'There<./s>s no room to sit upright on this bunk,
      since the ceiling is barely two feet above it. '
  cannotStandOnMsg =
    'Standing up on top of the bunk is out of the question.
      The ceiling is barely two feet above it. '
  bunkOwner = me
  bunkEnterTxt = 'You climb up the ladder and barely squeeze 
    onto the upper bunk. '
  bunkExitTxt = 'You squeeze out of the upper bunk and climb down
    the ladder to the floor below. '
;

// Do not allow the PC to sit/stand on/in a toilet! This will
// result in bugs if you are standing/sitting on a toilet,
// then turn it into an oile.
class Toilet: /*Chair,*/ Fixture
  'black ceramic funnel funnel-shaped urinal toilet lever' 
  'toilet'
  "This is a funnel-shaped piece of black ceramic,
    fixed to the floor, with a lever on one side. 
    You gather that it is meant to be used as a toilet. "
  cannotOpenMsg = 
    'You see no way to open the toilet. '
  cannotCloseMsg = 
    'You see no way to close the toilet. '
  dobjFor(Use) {
    preCond = []
    verify { }
    check {
      "You don<./s>t need to use the toilet right now. ";
    }
  }
  dobjFor(Pull) asDobjFor(Flush)
  dobjFor(Push) {
    verify { }
    check {
      "You can<./s>t seem to push the toilet lever, although
        you could certainly pull it. ";
      exit;
    }
  }
  dobjFor(Flush) {
    verify { }
    check { }
    action {
      "You pull the toilet lever. The inside bottom of the toilet
        opens up, and a gush of pressurized air blows forcefully
        down into the toilet. Then the inside bottom of the toilet
        closes again. ";
    }
  }
  iobjFor(PutOn) asIobjFor(PutIn)
  //iobjFor(PutOn) {
  //  verify() {
  //    if (gDobj && reasonableContents.indexOf(gDobj) == nil)
  //      illogical('You have no desire to put {that dobj/him} 
  //        on the toilet. ');
  //  }
  //}
  
  // This is REALLY kludgey. Will DEFINITELY need to be fixed.
  // But it's good enough for the intro.
  dobjFor(LookIn) {
    verify { }
    check { }
    action {
      "There<./s>s nothing in the toilet, not even water. ";
    }
  }
  dobjFor(SitOn) asDobjFor(Use)
  iobjFor(PutIn) {
    verify() {
      if (gDobj && (glob.isInEndgame || reasonableContents.indexOf(gDobj) != nil))
        illogical('In the interests of not breaking the toilet,
          you decide not to put {that dobj/him} in there. ');
    }
    check {
      "Vicki rushes over and says, <.q>No, no!
          Don<./s>t put {that dobj/him} in there!
          Last time we did that, we broke the toilet.<./q>
        <p>";
      if (gDobj.isIn(gActor))
        "You decide to hang on to {the dobj/him} for now. ";
      else
        "You decide to leave {the dobj/him} where it is. ";
      exit;
    }
  }
  reasonableContents = [foodCube]
;

//modify Thing
//  flushingObjection = nil
//;

cellToilet: Toilet
  location = cell
  // Remove from the cell any default things to sit on.
  // "Sit" should not assume that players mean the bed bunks,
  // but neither should it assume the toilet or the floor.
  hideFromDefault(action) {
    if (action.ofKind(SitOnAction))
      return true;
    return inherited(action);
  }
  zapT = transform(self, cellOile)
;

// -------------------------------------------------------------------
// THE CELL: ary ung and T-remover transformed objects
// -------------------------------------------------------------------

class Oile: Nonsense
  'oile' 'oile'
  bulk = 3
  isEquivalent = true
  //zapAry = disappear(leoI.giveText, self)
  zapAry = disappear(giveLeoText, self, 'Leo I')
  zapAryCq {
    glob.leoAlreadyAppeared = true;
    openDoorInThisRoom();
  }
  giveLeoText {
    if (!glob.leoAlreadyAppeared) {
      //glob.leoAlreadyAppeared = true;
      return transformUnsimulated('a bearded man, wearing magnificent
          clothing, almost like that of a pope', nil, nil)
          + 'The man turns to you and says something in some 
          language you don<./s>t understand. Then he repeats
          himself, and it sort of sounds like he<./s>s asking
          about <.q>Attila?<./q>
        <p>But you can only gape silently at him, open-mouthed.
        <p>Then the man shrugs, looks at you kindly, and says 
          something unintelligible.
          With that, he '
          + (doorInThisRoomMustBeOpened()
             ? '' : 'heads for the door, opens it, and ')
          + 'strides briskly out of the room, far out of sight. 
          You are left speechless. ';
    }
    else { // he has already appeared
      return transformUnsimulated('the same bearded pontiff you saw 
          before', nil, nil)
          + 'The man looks at you in confusion, then looks to the sky 
          and says something you don<./s>t understand. With that,
          he '
          + (doorInThisRoomMustBeOpened()
             ? '' : 'heads for the door, opens it, and ')
          + 'strides briskly out of the room, far out of sight. ';
    }
  }
;
cellOile: Oile
  asscToilet = cellToilet
;
bathOile: Oile
  asscToilet = bathToilet
;
modify glob
  leoAlreadyAppeared = nil
;
//leoI: object
//  alreadyAppeared = nil
//;

//noClosedPanel: Unthing
//  'closed (hitherto) unnoticed panel'
//  'panel'
//  @cell
//  notHereMsg = 'You fail to notice any panel here. '
//;

// -------------------------------------------------------------------
// THE CELL: food dispenser and related items
// -------------------------------------------------------------------

closedPanel: /*OutOfReach,*/ BarelyReachable, Fixture
  'closed (hitherto) unnoticed panel'
  'panel'
  @cell
  dobjFor(Open) {
    verify { }
    check {
      "You don<./s>t see any way to open it. ";
      exit;
    }
  }
  dobjFor(Close) {
    verify {
      illogical('It<./s>s already closed. ');
    }
  }
  //dobjFor(Open) {
  //  verify { }
  //}
  //dobjFor(Close) {
  //  verify { }
  //}
  //outOfReachMsg(obj) {
  //  gMessageParams(obj);
  //  return '{You/he} {can\'t} reach {the obj/him}. ';
  //}
  wordName = 'panel'
  zapAry = die(
    'The panel is transformed into Nepal! 
      <p>This is an event of staggering proportions,
        and Oo geologists will debate 
        for generations how it could have happened.
      <p>Another upshot is, you are now instantly buried
        under the Himalayas. '
    , 'Nepal', self, killEverybody
  )
;

modify glob
  knowsFoodCubeTaste = nil
  hasEatenFoodCube = nil
  dispenserNotice {
    if (!hasSeenDispenserNotice)
      "<p>[If you wish to interact with the food dispenser,
        you may type USE DISPENSER.] ";
    hasSeenDispenserNotice = true;
  }
  hasSeenDispenserNotice = nil
;

//foodBullpen: Room
//  'Food Bullpen' 'Food Bullpen'
//;

foodDispenser: FdThing
  '(food) dispenser 53a dispensing computer terminal unit -'
  'food dispenser'
  @cell
  descNounPhrase {
    if (hasBeenIdentified)
      return 'computer terminal';
    else
      return 'food dispenser';
  }
  descNoun {
    if (hasBeenIdentified)
      return 'terminal';
    else
      return 'dispenser';
  }
  desc {
    "Looking at the computer terminal, you see that
      it bears the name Food Dispenser 53A. It consists 
      of a monitor, a keyboard, and a small bin for
      dispensing food. ";
    if (glob.isInEndgame)
      "<p>Looking closer at the dispenser, you see 
          the following words:
        <p><<glob.lockedComputerText>>";
    // Give a one-time notice about 'USE DISPENSER'.
    glob.dispenserNotice;
    hasBeenIdentified = true;
  }
  hasBeenIdentified = nil
  dobjFor(Hit) asDobjFor(Use)
  dobjFor(EnterOn) asDobjFor(Use)
  dobjFor(TypeOn) asDobjFor(Use)
  dobjFor(TypeLiteralOn) asDobjFor(Use)
  dobjFor(Use) {
    verify { }
    check { }
    action {
      startTerminal();
      // Delay doing any of Vicki and Diane's random fidgety stuff
      // for a bit after you use the terminal.
      vd1Daemon.daemonCount = 1;
    }
  }
  dobjFor(Run) asDobjFor(Use)
  dobjFor(Play) asDobjFor(Use)
  zapRemoveCq {
    foodMonitor.moveInto(nil);
    foodKeyboard.moveInto(nil);
    foodBin.moveInto(nil);
  }
;

class FdThing: Fixture
  dobjFor(TurnOn) {
    verify { }
    check {
      "You don<./s>t see any way of turning on 
        {the dobj/him}. ";
    }
  }
  dobjFor(TurnOff) {
    verify { }
    check {
      "You don<./s>t see any way of turning off 
        {the dobj/him}. ";
    }
  }
  transformObj = foodDispenser
;

foodMonitor: FdThing
  '(food) (terminal) (dispenser) (dispensing) (53a) (computer) 
    (black) screen/tv/monitor'
  'monitor'
  @cell
  desc {
    "The monitor consists of a black screen with green text.
      It is part of the food dispenser unit. ";
    if (glob.isInEndgame)
      "<p>Looking closer at the monitor, you see 
          the following words:
        <p><<glob.lockedComputerText>>";
    // one-time syntax hint
    glob.dispenserNotice;
  }
  dobjFor(Read) {
    verify { }
    preCond = [touchObj]
    check { }
    action {
      startTerminal();
    }
  }
;

foodKeyboard: FdThing
  '(food) (terminal) (dispenser) (dispensing) (53a) (computer) 
    (oo) alphabet/keyboard/keys/buttons -'
  'keyboard'
  @cell
  "This computer keyboard is a bit unusual in that its keys 
    are way bigger than that of a normal Earth keyboard, and there
    are only 24 of them. 
    That, and the keys are covered with the letters
    of the Oo alphabet.
    The keyboard is part of the food dispenser unit. 
    <<glob.dispenserNotice>>"
  dobjFor(Push) asDobjFor(Use)
  dobjFor(Feel) asDobjFor(Use)
  dobjFor(EnterOn) asDobjFor(Use)
  dobjFor(TypeOn) asDobjFor(Use)
  dobjFor(TypeLiteralOn) asDobjFor(Use)
  dobjFor(Strike) asDobjFor(Use)
  dobjFor(Hit) asDobjFor(Use)
  dobjFor(Use) {
    verify { }
    check { }
    action {
      startTerminal();
    }
  }
;

foodBin: Container, Fixture
  '(food) (terminal) (dispenser) (dispensing) (53a) (computer) 
    (small) bin/container/box'
  'food bin'
  @cell
  "This bin is part of the food dispensing unit. "
  bulkCapacity = 30
  maxSingleBulk = 12
;

cellDoor: DoorNearCell
  location = cell
  initiallyLocked = true
  holdsPrisoners = true
;

// For more on the Satiating class, see 3extreme.t.

foodCube: Satiating, Food
  'spinach plaster lettuce gelatin gelatinous wilted processed seaweed
    styrofoam soylent green jello jell-o food cube substance -'
  'food cube'
  @nil
  "This green, gelatinous cube is apparently supposed
    to resemble food. "
  //isEquivalent = true
  smellDesc = "Ominously, the food substance does not have
    much of a smell. "
  tasteDesc {
    if (!glob.knowsFoodCubeTaste)
      "You take a slight taste of the food substance,
        and immediately regret it. It<./s>s like
        wilted lettuce, with an aftertaste of
        Styrofoam. ";
    else
      "Uh, no thanks. It tasted bad enough the first time. ";
    glob.knowsFoodCubeTaste = true;
  }
  dobjFor(Eat) {
    action() {
      if (glob.hasEatenFoodCube) {
        "No. Once was enough. ";
      }
      else {
        "Mustering all your willpower, 
          you gulp down the food substance. It tastes 
          even worse than you expected, like a 
          combination of spinach, plaster, and Jell-O. ";
        moveInto(nil);
        glob.knowsFoodCubeTaste = true;
        glob.hasEatenFoodCube = true;
      }
    }
  }
//  // This is a hack/kludge that won't work in the endgame,
//  // but I think it will always work in the intro.
//  throwHitFallMsg(projectile, target, dest) {
//    gMessageParams(projectile, target);
//    return '{The projectile/he} hit{s} {the target/him}
//        with a splat, and fall{s projectile} '
//        + dest.putInName + '. ';
//  }
  uselessToAttackMsg {
    return 'You could hit {the dobj/him}, but you don<./s>t 
      want to make a mess. ';
  }
  uselessToHitMsg  = (uselessToAttackMsg)
  dobjFor(AttackWith) asDobjFor(Attack)
  dobjFor(HitWith) asDobjFor(Hit)
  //flushingObjection {
  //  if (!glob.isInEndgame) {
  //    return
  //      'Vicki rushes over and says, <.q>No, no!
  //          Don<./s>t put {that dobj/him} in there!
  //          Last time we did that, we broke the toilet.<./q>
  //        <p>'
  //        + (gDobj && gDobj.isIn(gActor)
  //          ? 'You decide to hang on to {the dobj/him} for now. '
  //          : 'You decide to leave {the dobj/him} where it is. ');
  //  }
  //  else { // endgame scenario
  //    return
  //      'In the interest of not breaking the toilet, you decide 
  //        not to put the food cube in it. ';
  //  }
  //}
  vickiGiveResponse {
    "<.q>Uh, no thanks,<./q> says Vicki. ";
    if (glob.isInEndgame && vicki.foodEaten < vicki.satiationLevel)
      "<.q>I may be hungry, but I<./s>m not <i>that</i> hungry.<./q> ";
  }
  dianeGiveResponse {
    "<.q>No, no,<./q> says Diane. ";
    if (glob.isInEndgame && diane.foodEaten < diane.satiationLevel)
      "<.q>My stomach is growling, true, but I<./s>m not that 
        desperate.<./q> ";
    else
      "<.q>You<./s>re not going to pawn that off on me.<./q> ";
  }
;

// -------------------------------------------------------------------
// THE FOOD DISPENSER MENU
// -------------------------------------------------------------------

startTerminal() {
  if (glob.isInEndgame) {
    "You try typing in a few passwords into the keyboard, 
      but it<./s>s useless. 
      The dispenser is
      asking for Neton<./s>s password.
      Until you know the password, you can<./s>t do anything
      with the dispenser. ";
  }
  else {
    //"If this had been an actual game, we would now
    //  be doing the terminal sequence. ";
    glob.hasSeenDispenserNotice = true;
    glob.font = courier;
    cell.showTerminalPic = true;
    nbmCls();
    nbmBanner.updateMe;
    //glob.quipOpenParen = '[';
    //glob.quipCloseParen = ']';
    
    fdMain.select;
    //"We are going to try outputting some text. ";
    
    //glob.quipOpenParen = '(';
    //glob.quipCloseParen = ')';
    cell.showTerminalPic = nil;
    
    if (!glob.takeMeToVR) {
      nbmPause();
      glob.font = verdana;
    }
    glob.takeMeToVR = nil;
    
    nbmCls();
    nbmBanner.updateMe;
    nestedAction(Look);
    
    cancelPendingCommands();
  }
}

fdMain: FQuip, QMain
  reply {
    nbmCls();
    nbmBanner.updateMe;
    welcomeMessage;
  }
  welcomeMessage =
    "Welcome to the Food Dispenser 53A! Please 
      select from one of the options below. <.p>"
  welcomeMessage2 =
    "Welcome to the Food Dispenser 53A! Please 
      select from one of the options below. "
  killQ = true
  options = [
     fdGet
    ,fdLogin
    ,fdExit
  ]
  zeroOption = fdExit
;

class FQuip: Quip
  quipOptionStart = '['
  quipOptionEnd = '] '
  orZeroToSayNothing = 'or 0 to exit '
;

class FRegularQuip: FQuip
  reply {
    "<p>";
    fdReply();
    nbmPause();
    nbmCls();
    if (transfer)
      transfer.welcomeMessage2;
  }
  transfer = fdMain
;

fdGet: FRegularQuip
  "Get food "
  fdReply {
    if (foodCube.location == foodBin) {
      "A food cube is already in the food bin.
        Please take it and consume it before requesting
        another. ";
    }
    else if (foodCube.location != nil) {
      "The Organic Positioning System contained
        within the food substance you previously obtained
        indicates that you have not yet consumed that food 
        substance. Please consume it
        before requesting another. ";
    }
    else { //foodCube.location == nil
      "A food cube is being dispensed.
        Thank you for using the Food Dispenser 53A! ";
      if (!vd1Cube.hasBeenSelected) vd1Cube.isOn = true;
      foodCube.moveInto(foodBin);
      nbmBanner.updateMe;
    }
  }
;

fdLogin: FRegularQuip
  desc {
    "Log in as administrator ";
    if (!vd1Admin.needNotBeTurnedOnAgain) {
      vd1Admin.needNotBeTurnedOnAgain = true;
      vd1Admin.isOn = true;
    }
  }
  optionShown = nil
  fdReply {
    "Please enter your password. 
      <p>";
    if (!glob.knowsAboutFifthTier) {
      "(";
      //if (!glob.knowsAboutAlphabet)
      //  "To your surprise you find that you are perfectly
      //    able to understand the Oo alphabet displayed
      //    on the computer keyboard. ";
      "You try typing in a few passwords, but after repeated
        failure you inevitably have to give up.) ";
      glob.knowsAboutAlphabet = true;
      glob.knowsAboutFoodLogin = true;
    }
    // Otherwise, knowsAboutFifthTier -- thus, 
    // knows the password.
    else { 
      // At this point the PC has a guess as to the password,
      // and this guess will turn out to be correct. But the PC
      // *may not yet know* that this password guess is correct.
      if (!glob.knowsAboutGoodPass) {
        "(With some trepidation, you type in the 
          Oo spelling of <i><.s>Cave Maze VII,<./s></i>
          then wait to see what happens.) ";
        glob.knowsAboutGoodPass = true;
      }
      else {
        "(You type in the Oo spelling of 
          <i><.s>Cave Maze VII.<./s></i>) ";
      }
      nbmPause();
      "<p>Hello, Ovan! Please press any key to enter your
        secure menu. ";
      
      glob.hasLoggedIn = true;
      vd1Dunno.isOn = nil;
      vd1Tedious.isOn = nil;
      vd1Killed.isOn = nil;
      vd1Idea.isOn = nil;
      vd1Hack.isOn = nil;
      vd1Login.isOn = nil;
      vd1Logged.isOn = true;
    }
  }
  transfer {
    if (!glob.knowsAboutFifthTier)
      return fdMain;
    else
      return fdOvan;
  }
;

fdExit: FRegularQuip
  "End session "
  // No fdReply. This is intentional!
  reply() {
    "Thank you for using the Food Dispenser 53A!
      Have a nice day! ";
  }
  transfer = nil
;

modify glob
  knowsAboutFoodLogin = nil
  hasLoggedIn         = nil
;

fdOvan: FQuip, QSub
  reply {
    nbmCls();
    nbmBanner.updateMe;
    welcomeMessage;
  }
  welcomeMessage =
    "Hello, Ovan! Welcome to your secure menu. 
      Please select from one of the options below. <.p>"
  welcomeMessage2 =
    "Hello, Ovan! Welcome to your secure menu. 
      Please select from one of the options below. "
  killQ = true
  options = [
     fdCave
    ,fdStaff
    ,fdHumans
    //,fdCell
    ,fdMines
    ,fdNbm
    ,fdLogout
  ]
  zeroOption = fdExit
;

fdCave: FRegularQuip
  //CM7 intentionally not italicized
  "Play Cave Maze VII "
  fdReply {
    "ERROR: You have been denied access to this application 
        by user Neton. Neton left you the following message:
      <p>From: neton@hum.cesac.ces.edu.gov.ee \n
        To: ovan@hum.cesac.ces.edu.gov.ee
      <p>Ovan, I have become exceedingly annoyed by your 
        apparent failure to do anything other than play 
        Cave Maze VII. As a result,
        I have revoked your game-playing privileges.
        If you wish to get them reinstated, I will need
        to see more productive work on your next evaluation.
      <p>-- Neton, Director, Institute of Humanities, 
        Center of Earthological Studies, Australian Campus ";
    hasBeenSelected = true;
  }
  transfer = fdOvan
  hasBeenSelected = nil
;

fdStaff: FRegularQuip
  "Get status report of staff and crew "
  fdReply {
    "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
      <tr valign=\"top\">
        <td>EMPLOYEE</td>
        <td>&nbsp;&nbsp;</td>
        <td>LOCATION</td>
        <td>&nbsp;&nbsp;</td>
        <td>ACTIVITY</td>
      </tr>
      <tr valign=\"top\">
        <td>Director</td>
        <td>&nbsp;</td>
        <td>Office</td>
        <td>&nbsp;</td>
        <td><<netonActivity.doScript>></td>
      </tr>
      <tr valign=\"top\">
        <td>Asst prof</td>
        <td>&nbsp;</td>
        <td>Office</td>
        <td>&nbsp;</td>
        <td><<ovanActivity.doScript>></td>
      </tr>
      <tr valign=\"top\">
        <td>Assistant</td>
        <td>&nbsp;</td>
        <td>Conf room</td>
        <td>&nbsp;</td>
        <td><<assistantActivity>></td>
      </tr>
      <tr valign=\"top\">
        <td>Senior guard</td>
        <td>&nbsp;</td>
        <td>Break room</td>
        <td>&nbsp;</td>
        <td><<oldGuardActivity.doScript>></td>
      </tr>
      <tr valign=\"top\">
        <td>Junior guard</td>
        <td>&nbsp;</td>
        <td>Break room</td>
        <td>&nbsp;</td>
        <td><<youngGuardActivity.doScript>></td>
      </tr>
    </table> ";
  }
  netonActivity : CyclicEventList {
    [
      'Reading a paper on theoretical physics '
     ,'Filling out paperwork '
     ,'Reading a paper on the behavior patterns of dying humans '
     ,'Filling out paperwork '
     ,'Reading a paper on galactic language morphemes '
     ,'Filling out paperwork '
     // 'Reading a paper on theoretical physics '
     //,'Reading a paper on theoretical physics '
     //,'Filling out paperwork '
     //,'Filling out paperwork '
     //,'Reading a paper on the behavior patterns of dying humans '
     //,'Reading a paper on the behavior patterns of dying humans '
     //,'Filling out paperwork '
     //,'Filling out paperwork '
     //,'Reading a paper on galactic language morphemes '
     //,'Reading a paper on galactic language morphemes '
     //,'Filling out paperwork '
     //,'Filling out paperwork '
    ]
  }
  // CM7 not italicized because this is a computer terminal.
  ovanActivity : CyclicEventList {
    [
      'Fiddling with his tablet device '
     ,'Searching the newsgroups for information on Cave Maze VII '
     //,'Fiddling with his tablet device '
     //,'Searching the Internet for information on Cave Maze VII '
     //,'Fiddling with his tablet device '
     //,'Searching the periodicals database for information on Cave Maze VII '
     //,'Fiddling with his tablet device '
     //,'Searching his tablet device fruitlessly for a copy of Cave Maze VII '
    ]
  }
  assistantActivity = "Engaging in \"deep space\" meditation "
  oldGuardActivity : CyclicEventList {
    [
      'Eating a roast beef sandwich '
        ,'Talking about the advantages of Earth food '
     ,'Eating a slice of carrot cake '
     ,'Eating a bowl of chicken noodle soup '
     ,'Eating some beets '
        ,'Talking about Neton<./s>s snobbishness '
     ,'Eating a slice of mutton '
     ,'Eating an ice cream bar '
     ,'Eating a bowl of minestrone soup '
        ,'Talking about the advantages of government work '
     ,'Eating a taco '
     ,'Eating some truffles '
     ,'Eating a lemon '
        ,'Talking about Ovan<./s>s security lapses '
     ,'Eating some mashed potatoes '
     // Uh oh. Better censor out this cheese or the game won't be certified cheese-free.
     //,'Eating some macaroni and cheese ' 
     ,'Eating a bowl of clam chowder '
     ,'Eating a steak '
        ,'Talking about his upcoming vacation in Tierra del Fuego '
     ,'Eating a torte '
     ,'Eating some baked beans '
    ]
  }
  youngGuardActivity : CyclicEventList {
    [
      'Talking about Oo War II '
     ,'Cleaning his gun '
    ]
  }
  transfer = fdOvan
;

fdHumans: FRegularQuip
  "Get status report of prisoners "
  fdReply {
    "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
      <tr valign=\"top\">
        <td>PRISONER</td>
        <td>&nbsp;&nbsp;</td>
        <td>LOCATION</td>
        <td>&nbsp;&nbsp;</td>
        <td>ACTIVITY</td>
      </tr>
      <tr valign=\"top\">
        <td>Vicki Murakami</td>
        <td>&nbsp;</td>
        <td>Cell</td>
        <td>&nbsp;</td>
        <td>Resting</td>
      </tr>
      <tr valign=\"top\">
        <td>Diane Gadke</td>
        <td>&nbsp;</td>
        <td>Cell</td>
        <td>&nbsp;</td>
        <td>Resting</td>
      </tr>
      <tr valign=\"top\">
        <td><<me.fullName>></td>
        <td>&nbsp;</td>
        <td>Cell</td>
        <td>&nbsp;</td>
        <td>Using food dispenser</td>
      </tr>
    </table> ";
  }
  transfer = fdOvan
;

modify glob
  gasHasBeenReleased = nil
  takeMeToVR = nil
;

fdMines: FRegularQuip
  "Release deadly methane gas at Queensland Salt Mines "
  fdReply {
    if (!glob.gasHasBeenReleased) {
      "Attempting to release deadly methane gas
        at Queensland Salt Mines\ .\ .\ . ";
      nbmPause();
      "<p>Methane gas release successful! Preliminary 
        reports estimate a fatality rate in the range of 
        15%&ndash;30%. Recruitment for the salt mines
        can now continue unimpeded. ";
      glob.gasHasBeenReleased = true;
    }
    else {
      "ERROR: Methane gas reserves depleted at 
        Queensland Salt Mines. ";
    }
  }
  transfer = fdOvan
  //qOff = [fdMethane]
;

fdNbm: FRegularQuip
  "Program Nothing but Mazes "
  reply {
    "Loading MIFS 9 environment\ .\ .\ . ";
    nbmPause();
    "<p>(Suddenly you look up from the terminal. 
        Something is happening.) ";
    nbmPause();
    "<p>(On the ceiling, 
        a<<glob.alreadyReturnedFromVR ? '' : ' hitherto unnoticed'>>
        panel opens up. In a flash, an articulated metal arm 
        descends from the open panel and attaches itself 
        to your head.) ";
    nbmPause();
    "<p>(Your thoughts fade, and within moments
        you lose consciousness.) ";
    nbmPause();
    
    glob.takeMeToVR = true;
    //gPlayerChar.moveIntoForTravel(vrRoom);
    goToVR.execute;
    vd1Logged.isOn = nil;
    vd1Vr.isOn = true;
    vd1Done.isOn = true;
    mazesExe.npcsKnowAsMuchAsPc = nil;
  }
  transfer = nil
;

fdLogout: FRegularQuip
  "End session "
  // No fdReply. This is intentional!
  reply() {
    "Logging out of your secure menu, Ovan. 
      Thank you for using the Food Dispenser 53A!
      Have a nice day! ";
  }
  transfer = nil
;


// -------------------------------------------------------------------
// THE VICKI/DIANE CONVERSATION
// -------------------------------------------------------------------

convKey() {
  //nbmPause();
}

// This starts it all off, right after you enter the room,
// before you get a chance to type anything.

enterCell() {
  "<.p>As soon as you walk in, the Asian woman 
      walks up to you and says, 
      <.q>You must be the new prisoner. Hi, my name 
      is Vicki. This is Diane.<./q>
    <p>The blonde woman glances up at you and 
      nods her head. ";
  
  convKey();
  "<p><.q>Hi, my name<./s>s Gary,<./q> you say.
    <p><.q>Nice to meet you, Gary,<./q> says Vicki. 
      <.q>So how<./s>d you get here?<./q> ";
  
  convKey();
  "<p><.q>I just woke up a few days ago and 
      went through about a week of physical 
      rehabilitation. Then they took me here.<./q>
    <p><.q>Another unfrozen one, just like 
      us,<./q> says Diane.
    <p><.q>Let me guess, you talked to 
      Neton and Ovan,<./q> says Vicki. 
      <.q>What did they tell you?<./q> ";
  
  convKey();
  "<p><.q>Well, they said that a nuclear war 
      wiped out most of the human race,<./q> 
      you say. <.q>Then they said that aliens 
      landed on the planet Earth. 
      And they said that all this happened 
      while I was cryogenically frozen.<./q>
    <p>Normally you<./s>d expect 
      people to run the other way
      after hearing something like that. 
      But Vicki just says, <.q>Yeah, 
      that<./s>s what they told us. 
      And what else did they say? 
      Do you know why they revived you?<./q> ";
  
  convKey();
  "<p><.q>Uh, they said they woke me up 
      because they wanted me to play some 
      computer game,<./q> you say.
    <p>Somehow this sounds even dumber 
      than your last comment. 
      But Diane<./s>s response surprises you. 
      She says, <.q>Uh oh, he knows.<./q> ";
  
  convKey();
  "<p><.q>Knows what?<./q> you say. <.q>That 
      it<./s>s called <i>Nothing but Mazes?<./q></i>
    <p><.q>Oh,<./q> says Diane. <.q>Maybe 
      he doesn<./s>t know after all.<./q> ";
  
  vicki.hasBeenIdentified = true;
  diane.hasBeenIdentified = true;
}

activateSecondTier() {
  vd1Tedious.isOn = true;
  vd1Killed.isOn = true;
  vd1Uhoh.isOn = true;
  vd1Know.isOn = true;
  vd1Play.isOn = true;
  vd1Text.isOn = true;
  glob.knowsAboutSecondTier = true;
}
activateThirdTier() {
  glob.knowsAboutThirdTier = true;
  if (glob.knowsAboutThirdTier && glob.knowsAboutFourthTier) {
    vd1Uhoh.isOn = nil;
  }
}
activateFourthTier() {
  vd1Idea.isOn = true;
  vd1Players.isOn = true;
  glob.knowsAboutFourthTier = true;
  if (glob.knowsAboutThirdTier && glob.knowsAboutFourthTier) {
    vd1Uhoh.isOn = nil;
  }
}
activateFifthTier() {
  vd1Hack.isOn = true;
  vd1Login.isOn = true;
  glob.knowsAboutFifthTier = true;
  vd1Admin.isOn = nil; // The question asked by this quip is explained here
  vd1Admin.needNotBeTurnedOnAgain = true; // make sure it's not turned on again
}
activateSixthTier() {
  glob.knowsAboutSixthTier = true;
  glob.knowsAboutAlphabet = true;
}

vd1Main: QMain
  reply {
    // Delay doing any of Vicki and Diane's random fidgety stuff
    // for a little while after you talk to them.
    vd1Daemon.daemonCount = 2;
  }
  options = [
     vd1Dunno   // 2  1 "You said there's something I don't know?"
    ,vd1Tedious // 3  2 "Well, a virtual reality maze might be tedious, but I think I can handle it."
    ,vd1Killed  // 4  2 "If you get killed in their game, do you die in real life?"
    ,vd1Idea    // 5  4 "You have an idea to help me survive? Well, let's hear it!"
    ,vd1Hack    // 6  5 "So how do I hack into their system?"
    
    ,vd1Vr      //
    ,vd1Done    //
    
    ,vd1Uhoh    //    2 "Why did you say 'uh oh' before?"
    ,vd1Login   //    5 "Hey, why do <i>I</i> have to be the one to log in?"
    
    ,vd1Heard   //    1 Needs modification. "What have you heard about their computer game?"
    ,vd1Know    //    2 Needs differentiation based on knowledge of the game."How do you know all this stuff about their game, anyway?"
    ,vd1Play    //    2 "How come they're not having <i>you</i> play their game?"
    ,vd1Players //    4 "Who all has played their game, then?"
    ,vd1Text    //    2 "So I gather the two of you have played text adventures?"
    
    ,vd1Admin   //      "What's this about 'login as administrator'?"
    ,vd1Cube    //
    
    //,vd1Long    //    1 "How long have the two of you been unfrozen?"
    //,vd1Truth   //    1 "Do you believe the aliens have been telling you the truth?"
    
    ,vd1Person
    ,vd1Earth
  ]
;

modify glob
  knowsAboutSecondTier = nil
  knowsAboutThirdTier  = nil
  knowsAboutFourthTier = nil
  knowsAboutFifthTier  = nil
  knowsAboutSixthTier  = nil
  
  knowsAboutMazeDeath  = nil
  knowsAboutFertility  = nil
  knowsAboutAlphabet   = nil
  knowsAboutGoodPass   = nil
;

explainSecondTier(qarg) {
  if (qarg == vd1Uhoh) {
    "<p>Diane shrugs and says, <.q>Well, before
        I can explain that, I need you
        to tell me what you know about their
        computer game.<./q> 
      <p><.q>You said it<./s>s called 
        <i>Nothing but Mazes,<./q></i> says Vicki. 
        <.q>Is that all you know about it?<./q> ";
  }
  else if (qarg == vd1Heard) {
    "<p>Diane says, <.q>Well, it<./s>d be easier to know
        where to begin if we knew what you
        had heard about it.<./q> ";
  }
  else {
    "<p><.q>Well, we asked you about the computer game, 
        and all you said was that it<./s>s called 
        <i>Nothing but Mazes,<./q></i> says Vicki. 
        <.q>Is that all you know about it?<./q> ";
  }
  
  convKey();
  "<p><.q>Well, I know that it<./s>s interactive 
      fiction,<./q> you say. 
      <.q>A text adventure, like <i>Zork.</i> 
      And I know it<./s>s got a bunch of mazes.<./q> ";
  
  if (qarg == vd1Uhoh) {
    "<p>Diane sighs.
      <p>Vicki takes a deep breath, then says,
        <.q>First of all, ";
  }
  else if (qarg == vd1Heard) {
    "<p>Vicki takes a deep breath, then says,
        <.q>First of all, ";
  }
  else {
    "<p><.q>Oh, dear,<./q> says Diane. 
        <.q>He doesn<./s>t know.<./q> ";
    convKey();
    "<p><i><.q>Know what?<./q></i> you shout exasperatedly.
      <p><.q>Well, first of all,<./q> says Vicki, <.q>";
  }
  
  "their game is <i>not</i> a text adventure. 
      They call it interactive fiction, but it<./s>s 
      not at all like <i>Zork.</i> 
      Their game belongs to an interactive medium 
      that they call
      <i>kona teesofal.</i> It<./s>s what we would 
      call virtual reality. You climb onto one of their 
      <.s>dream couches,<./s> and they send images 
      and sounds into your mind, making you think 
      you<./s>re in some other world. You can interact 
      with that world, and there<./s>s often a goal 
      to accomplish, so it is a <.s>game<./s> of sorts. 
      But it<./s>s not like any game we<./s>ve ever played. 
      We<./s>d call it virtual reality.<./q> ";
  
  convKey();
  "<p><.q>Then why do they call it interactive 
      fiction?<./q> you ask.
    <p><.q>Because that<./s>s the literal translation of 
      <i>kona teesofal,<./q></i> says Vicki.
    <p>Suddenly you realize that she<./s>s right. 
      <i>Kona</i> means <.q>story,<./q> while 
      <i>teesofal</i> means <.q>interactive.<./q>
    <p>Vicki continues, <.q>Apparently when these 
      aliens came to Earth, they kept looking 
      through Earth<./s>s literature for references 
      to their precious <i>kona teesofal.</i> 
      They found out about <.s>interactive fiction<./s> 
      and decided that was what they were looking for.<./q> ";
  
  convKey();
  "<p><.q>But didn<./s>t they play any of Earth<./s>s 
      interactive fiction games?<./q> you ask. 
      <.q>Surely they could tell that <i>Zork</i> 
      isn<./s>t virtual reality.<./q>
    <p>Vicki shakes her head in a bewildered manner.
    <p><.q>I said something like that to Neton once,<./q> 
      says Diane. <.q>He just laughed and said 
      it was amusing how humans could make such petty 
      distinctions. He compared me to an Eskimo 
      distinguishing between different kinds of snow.<./q>
    <p><.q>I don<./s>t understand those aliens at all,<./q> 
      says Vicki. ";
  
  vd1Dunno.isOn = nil;
  activateSecondTier();
}

explainThirdTier(qarg) {
  if (qarg == vd1Tedious) {
    "<p>Diane sighs.
      <p><.q>No, no,<./q> says Vicki. <.q>The problem 
        isn<./s>t tediousness. The problem is what they 
        call <.s>insta-death<./s> rooms.<./q> ";
    "<p>Suddenly the light begins to dawn.
      <p>Vicki continues, <.q>Apparently ";
  }
  else if (qarg == vd1Heard) {
    "<p>Vicki heaves a heavy sigh and says, 
        <.q>Well, there is at least one major thing we 
        didn<./s>t tell you. \^";
  }
  else {
    "<p>Diane looks at you for a second or two, then says,
        <.q>Well, it<./s>s not just that their game is
        virtual reality, or that it<./s>s full of mazes. 
        The real problem has to do with their 
        <.s>insta-death<./s> rooms.<./q> ";
    "<p>Suddenly the light begins to dawn.
      <p>Vicki continues, <.q>Apparently ";
  }
  
  "they fill 
      their mazes with rooms where anyone who enters 
      dies instantly. There is no warning 
      beforehand, and no chance of survival 
      afterwards, just instant death.<./q>
    <p><.q>And there are enough <.s>insta-death<./s> 
      rooms that you are virtually assured of 
      wandering into one of them,<./q> says Diane. ";
  vd1Uhoh.isOn = nil;
  vd1Tedious.isOn = nil;
  activateThirdTier();
}

explainFourthTier(qarg) {
  if (qarg == vd1Killed || qarg == vd1Heard) {
    convKey();
    "<p><.q>So then&mdash;<./q> you say. ";
  }
  else { // vd1Tedious, vd1Uhoh, nil
    convKey();
    "<p><.q>And you said that if you die in their
        game, they kill you in real life,<./q> you say. 
        <.q>So&mdash;<./q> ";
  }
  
  "<p><.q>Yep,<./q> says Diane. 
      <.q>If you play their game, you<./s>re as good as dead.<./q>
    <p><.q>And if I refuse?<./q> you ask.
    <p><.q>I don<./s>t think you can refuse,<./q> 
      says Diane. <.q>They can strap you to the 
      dream couch against your will. They don<./s>t 
      need your cooperation.<./q> Her cold bluntness 
      is starting to make you mad. ";
  
  convKey();
  "<p>You shout, <.q>So there<./s>s no hope? 
      I<./s>m toast, and that<./s>s it, huh?<./q>
    <p><.q>Actually, Diane and I have been thinking 
      about this,<./q> says Vicki, <.q>and we came up 
      with an idea. It<./s>s a shot in the dark, and 
      it could be dangerous. But it<./s>s probably 
      worth a try.<./q> ";
  
  activateFourthTier();
}


vd1Dunno: Quip
  "<.q>You said there<./s>s something I don<./s>t know?<./q> "
  reply {
    "<.q>You said there<./s>s something I don<./s>t know?<./q> 
        you ask. ";
    explainSecondTier(self);
  }
  qOff = [vd1Dunno]
;

vd1Tedious: Quip
  "<.q>Well, a virtual reality maze might sound tedious, 
      but I think I can handle it.<./q> "
  reply {
    "<p><.q>Well, a virtual reality maze might sound tedious, 
        but I think I can handle it,<./q> you say. ";
    explainThirdTier(self);
    //"<p><.q>Well, a virtual reality maze might be tedious, 
    //    but I think I can handle it,<./q> you say. ";
    //  <p>Diane sighs.
    //  <p><.q>No, no,<./q> says Vicki. <.q>The problem 
    //    isn<./s>t tediousness. The problem is what they 
    //    call <.s>insta-death<./s> rooms.<./q>
    //  <p>Suddenly the light begins to dawn.
    //  <p>Vicki continues, <.q>Apparently they fill 
    //    their mazes with rooms where anyone who enters 
    //    dies instantly. There is no warning 
    //    beforehand, and no chance of survival 
    //    afterwards, just instant death.<./q>
    //  <p><.q>And there are enough <.s>insta-death<./s> 
    //    rooms that you are virtually assured of 
    //    wandering into one of them,<./q> says Diane. ";
    //
    //convKey();
    //"<p><.q>Well, then, how do you win?<./q> you ask.
    //  <p><.q>According to everything we<./s>ve heard, 
    //    um\ .\ .\ .<./q> Vicki trails off.
    //  <p><.q>You don<./s>t win. You die,<./q> says Diane. ";
    //
    //activateThirdTier();
    
    if (glob.knowsAboutMazeDeath) {
      explainFourthTier(self);
    }
  }
  isOn = nil
  qOff = [vd1Tedious]
;

vd1Killed: Quip
  "<.q>If you get killed in their game, do you
      die in real life?<./q> "
  reply {
    "<p><.q>If you get killed in their game, do you
        die in real life?<./q> you ask. ";
    "<p>";
    
    if (glob.knowsAboutThirdTier) {
      "Vicki sighs and says, <.q>Nobody<./s>s 
          ever returned from playing their game.<./q>
        <p>Staring at the floor, Diane says, ";
    }
    else {
      "<.q>Apparently so, yes,<./q> says Diane, 
          staring at the floor. ";
    }
    
    "<.q>I overheard the aliens talking in the hallway. 
        They said that when you die in virtual reality, 
        that <i>in itself</i> doesn<./s>t kill you. 
        But you get killed anyway, 
        because the aliens pull the plug on you, 
        just for the fun of it.<./q> ";
    glob.knowsAboutMazeDeath = true;
    vd1Killed.isOn = nil;
    
    if (glob.knowsAboutThirdTier) {
      explainFourthTier(self);
    }
  }
  isOn = nil
  qOff = [vd1Killed]
;

explainFifthTier(qarg) {
  "<.q>Theoretically, you could use the food 
      dispenser to hack into their computer system. 
      Of course, you<./s>d need their password. And even 
      if you got in, there<./s>s no guaranteeing 
      it would help.<./q> ";
  
  convKey();
  "<p><.q>Do you know the password?<./q> you ask.
    <p><.q>No,<./q> says Vicki. <.q>That<./s>s just the 
      problem.<./q>
    <p><.q>But I did hear one hint,<./q> says Diane. 
      <.q>Through the door once I overheard Ovan say 
      something to suggest that he had set his password 
      to the name of an Oo computer game.<./q>
    <p><.q>We tried typing <.s>Nothing but Mazes,<./s>
      but that didn<./s>t work,<./q> says Vicki.
      <.q>We don<./s>t know the names of any other 
      Oo computer games.<./q> ";
  
  convKey();
  "<p><.q>An Oo computer game?<./q> you shout. 
      <.q>Hey! I think Ovan mentioned a game called 
      <.game>Cave Maze VII!<./q><./game> 
    <p><.q>Actually, that does sound promising,<./q> 
      says Diane, suddenly looking you in the eye.
    <p><.q>Okay,<./q> says Vicki. <.q>We<./s>ve got 
      something to work with. But I don<./s>t want to give 
      you any false hopes. This could be dangerous. 
      If you do manage to get into their network, 
      we don<./s>t know what will happen. 
      Maybe alarms will go off. Or maybe you<./s>ll get in, 
      but there won<./s>t be any help there at all.
      You<./s>ll just have to try it and see.<./q> ";
  
  activateFifthTier();
}

vd1Idea: Quip
  "<.q>You<./s>ve got an idea to help me survive?
      Well, let<./s>s hear it!<./q> "
  reply {
    "<p><.q>You<./s>ve got an idea to help me survive?<./q> 
        you shout. <.q>Well, let<./s>s hear it!<./q> ";
    "<p><.q>Well, it has to do with 
        the food dispenser,<./q> says Vicki, 
        pointing to the computer terminal on the back wall. ";
    explainFifthTier(self);
  }
  isOn = nil
  qOff = [vd1Idea]
;


vd1Hack: Quip
  "<.q>So how do I hack into their 
      system<<previouslySelected ? ' again' : ''>>?<./q> "
  reply {
    "<p><.q>So how do I hack into their 
        system<<previouslySelected ? ' again' : ''>>?<./q> 
        you ask. ";
    
    if (!previouslySelected)
      "<p><.q>That<./s>s easy,<./q> says Vicki. ";
    else
      "<p>Diane sighs impatiently.
        <p>Vicki says, ";
    
    "<.q>Just go over 
        to their computer and select <.s>login<./s> 
        from the menu. It doesn<./s>t ask for any user name, 
        just a password. Type in <.s>Cave Maze VII<./s> 
        using the Oo alphabet. ";
    
    if (!previouslySelected) {
      "They did teach you the 
          Oo alphabet, didn<./s>t they?<./q>
        <p>You pause to consider. <.q>Yes, 
          << !glob.knowsAboutAlphabet
            ? 'I guess they did. ' 
            : '' >>I think 
          I know how to spell 
          <.s>Cave Maze VII.<./s><./q>
        <p><.q>Let<./s>s go over to the terminal, and 
          I<./s>ll show you,<./q> says Vicki. <.q>Better yet, 
          you show me.<./q>
        <p>The two of you walk over to the terminal. 
          << !glob.knowsAboutAlphabet
            ? 'Once again you summon an ability you didn<./s>t 
                know you had, pointing'
            : 'You point'>>
          to the buttons on the 
          keyboard that show how you would spell the password.
        <p><.q>Yep, that<./s>s it,<./q> says Vicki. 
          <.q>You<./s>re all ready to go. You can try hacking in 
          anytime tonight. Just remember, if you<./s>re going
          to do this, you have to do it before tomorrow
          morning, because&mdash;well, 
          you know.<./q> 
        <p><.q>That<./s>s when the hangmen arrive,<./q> 
          says Diane. ";
    }
    else {
      "You can try hacking in anytime tonight. 
          Just remember, if you<./s>re going to do this,
          you have to do it before tomorrow morning, 
          because that<./s>s when the aliens
          are coming for you.<./q> ";
    }
    
    previouslySelected = true;
    activateSixthTier();
  }
  isOn = nil
  previouslySelected = nil
  //qOff = [vd1Hack]
;

vd1Logged: Quip
  "<.q>Well, I logged in to their computer system. Now what?<./q> "
  reply {
    "<.q>Well, I logged in to their computer system,<./q>
        you say. <.q>Now what?<./q>
      <p><.q>If it were me, I<./s>d explore their
        system thoroughly,<./q> says Vicki.
        <.q>Do whatever you can that seems like
        it might help.<./q> ";
  }
  //qOff = [vd1Logged]
;

vd1Vr: Quip
  desc {
    if (!hasBeenSelected)
      "<.q>Wait till I tell you what happened to me! 
          I got transported to some 
          virtual reality place!<./q> ";
    else
      "<.q>Do you have any more advice on what 
          to do in that virtual reality place?<./q> ";
  }
  reply {
//#ifdef __DEBUG
//      "vd1Vr.hasBeenSelected = <<vd1Vr.hasBeenSelected ? 'true' : 'nil'>>\n
//      vrRoom.hasBeenDescribed = <<vrRoom.hasBeenDescribed ? 'true' : 'nil'>>\n
//      mazesExe.npcsKnowAsMuchAsPc = <<mazesExe.npcsKnowAsMuchAsPc ? 'true' : 'nil'>>\n
//      glob.iWantToNullify = <<glob.iWantToNullify ? 'true' : 'nil'>>\n
//      glob.iWantToMakeTrue = <<glob.iWantToMakeTrue ? 'true' : 'nil'>>\b";
//      
//      if (glob.iWantToNullify) {
//        mazesExe.npcsKnowAsMuchAsPc = nil;
//        glob.iWantToNullify = nil;
//      }
//      else if (glob.iWantToMakeTrue) {
//        mazesExe.npcsKnowAsMuchAsPc = true;
//        glob.iWantToMakeTrue = nil;
//      }
//      
//      "vd1Vr.hasBeenSelected = <<vd1Vr.hasBeenSelected ? 'true' : 'nil'>>\n
//      vrRoom.hasBeenDescribed = <<vrRoom.hasBeenDescribed ? 'true' : 'nil'>>\n
//      mazesExe.npcsKnowAsMuchAsPc = <<mazesExe.npcsKnowAsMuchAsPc ? 'true' : 'nil'>>\n
//      glob.iWantToNullify = <<glob.iWantToNullify ? 'true' : 'nil'>>\n
//      glob.iWantToMakeTrue = <<glob.iWantToMakeTrue ? 'true' : 'nil'>>\b";
//#endif  // __DEBUG
    if (!hasBeenSelected) {
      "<.q>Wait till I tell you what happened to me!<./q>
          you say. <.q>I got transported to some 
          virtual reality place!<./q> 
        <p><.q>What was it like in there?<./q> asks Vicki. 
        <p>"; mazesExe.pcStatusReport;
      "<p>Vicki says, <.q>"; mazesExe.npcRecommendation; "<./q> ";
    }
    else {
      "<.q>Do you have any more advice on what 
          to do in that virtual reality place?<./q> 
          you ask. 
        <p>";
      if (mazesExe.npcsKnowAsMuchAsPc) {
        "<.q>Just what I said before,<./q> Vicki replies. 
            <.q>"; mazesExe.npcStatusReport;
            mazesExe.npcRecommendation; "<./q> ";
      }
      else { // NPCs need an update
        "<.q>Before I can answer that, you<./s>ll have 
            to bring us up to speed on what you<./s>ve done 
            in there,<./q> says Vicki. 
          <p>"; mazesExe.pcStatusReport;
        "<p>Vicki says, <.q>"; mazesExe.npcRecommendation; "<./q> ";
      }
    }
    mazesExe.npcsKnowAsMuchAsPc = true;
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  isOn = nil
;

vd1Done: Quip
  "<.q>What should I do when I think I<./s>ve done
      all I can for the night?<./q> "
  reply {
    "<.q>What should I do when I think I<./s>ve done
        all I can for the night?<./q> you ask. 
      <p>Vicki replies, <.q>If you really think 
        you<./s>ve done all you can to prepare 
        for the maze game tomorrow, 
        all you need to do is lie down on your bunk
        and go to sleep. The aliens will come in the morning
        and wake you up when they<./s>re ready to 
        take you off to play the game.<./q> ";
  }
  isOn = nil
  //qOff = [vd1Done]
;

/*
    if (!hasBeenSelected) {
      "<.q>Wait till I tell you what happened to me!<./q>
          you say. <.q>I got transported to some 
          virtual reality place!<./q> 
        <p><.q>It sure looked weird to us,<./q> says Diane.
          <.q>We figured it must have been something 
          like that.<./q> 
        <p><.q>What was it like in there?<./q> asks Vicki. ";
    }
    else {
      "<.q>Do you have any more advice on what 
          to do in that virtual reality place?<./q> you ask.
        <p>";
      if (mazesExe.npcsKnowAsMuchAsPc)
        "<.q>First of all, remind us again what you<./s>ve done
            in there,<./q> says Vicki. ";
      else
        "<.q>First of all, what have you done in there
            since the last time we talked about this?<./q> says Vicki. ";
    }
    
    convKey();
    "<p><.q>Well, I saw what looked like some 
        computer files lying on the ground,<./q> you say. ";
    if (m9CompilerExe.hasBeenExecuted) {
      "<.q>I tried running one of them, and it compiled a new
          version of mazes.exe.";
      if (winnabilityExe.hasBeenExecuted)
        " And I also tried running another of them,
          and it told me the odds of winning 
          the maze game.";
      "<./q> ";
    }
    else if (winnabilityExe.hasBeenExecuted) {
      "<.q>I tried running one of them, and it told me
          the odds of winning the game.<./q> ";
    }
    else if
    "<./q> ";
    "<p><.q>And what were the odds?<./q> asks Vicki. 
      <p><<mazesExe.pcOddsReport>>
      <p>";
    "";
*/

vd1Uhoh: Quip
  desc {
    if (!thisQuipHasBeenUsed)
      "<.q>Why did you say <.s>uh oh<./s>?<./q> ";
    else
      "<.q>I still don<./s>t know why you 
          said <.s>uh oh.<./s><./q> ";
  }
  reply {
    if (!thisQuipHasBeenUsed)
      "<.q>Why did you say <.s>uh oh<./s>?<./q> ";
    else
      "<.q>I still don<./s>t know why you 
          said <.s>uh oh,<./s><./q> you say. ";
    
    // If we haven't explained the second tier, 
    // we must first do so.
    if (!glob.knowsAboutSecondTier) {
      explainSecondTier(self);
      thisQuipHasBeenUsed = true;
    }
    // Otherwise, we are explaining the third tier.
    // Come to think of it, if the player knowsAboutMazeDeath,
    // then we are explaining the fourth tier here too.
    else {
      explainThirdTier(self);
      if (glob.knowsAboutMazeDeath) {
        explainFourthTier(self);
      }
    }
  }
  thisQuipHasBeenUsed = nil
  //qOff = [vd1Uhoh]
;

vd1Login: Quip
  "<.q>How about if <i>you</i> hack into their
      system?<./q> "
  reply {
    "<.q>How about if <i>you</i> hack into their
        system?<./q> you suggest.
      <p><.q>No way,<./q> says Diane.
        <.q>It<./s>s <i>your</i> life 
        that<./s>s on the line. 
        You<./s>re the one who has to take 
        the risk.<./q>
      <p><.q>Think of it this way,<./q> says Vicki. 
        <.q>We don<./s>t know any more about
        their computer network than you do. 
        We wouldn<./s>t be any more likely than you 
        to achieve success. And we don<./s>t want 
        to be responsible for what would happen 
        if we failed. Feel free to ask us for
        advice, though.<./q> ";
  }
  isOn = nil
  qOff = [vd1Login]
;

vd1Heard: Quip
  "<.q>So what<<glob.knowsAboutSecondTier ? ' else' : ''>> 
      have you heard about their computer game?<./q> "
  reply {
    "<.q>So what<<glob.knowsAboutSecondTier ? ' else' : ''>> 
        have you heard about their computer game?<./q> 
        you ask. ";
    if (!glob.knowsAboutSecondTier) {
      explainSecondTier(self);
    }
    else if (!glob.knowsAboutThirdTier) {
      explainThirdTier(self);
      if (glob.knowsAboutMazeDeath) {
        explainFourthTier(nil);
      }
      else { // pc knowsAboutMazeDeath
        "<p><.q>But that<./s>s not the worst 
            part, Vicki says, and shakes her head sadly. 
            <.q>Unfortunately, when you get killed
            in the game\ .\ .\ .<./q>
            She trails off.
          <p><.q>When you get killed in the game, you
            also die in real life,<./q> says Diane 
            coldly. <.q>Or anyway, that<./s>s
            what the aliens said once when I overheard
            them talking in the hallway. 
            They said&mdash;get this&mdash;that
            when you die in virtual reality, 
            that <i>in itself</i> doesn<./s>t kill you
            in real life, but you get killed anyway, 
            because the aliens pull the plug on you, 
            just for the fun of it.<./q> ";
        glob.knowsAboutMazeDeath = true;
        vd1Killed.isOn = nil;
        explainFourthTier(self);
      }
    }
    else if (!glob.knowsAboutFourthTier) {
      "<p>Diane says, 
          <.q>Well, certainly, there is at least 
          one more thing we should mention. 
          I overheard the aliens talking in the hallway. 
          They said that when you die in virtual reality, 
          that <i>in itself</i> doesn<./s>t kill you
          in real life. But you get killed anyway, 
          because the aliens pull the plug on you, 
          just for the fun of it.<./q> ";
      glob.knowsAboutMazeDeath = true;
      vd1Killed.isOn = nil;
      explainFourthTier(self);
    }
    else if (!glob.knowsAboutFifthTier) {
      "<p><.q>Well, not a lot more,<./q> says Diane.
          <.q>It<./s>s a virtual reality maze game
          with a lot of <.s>insta-death<./s> rooms.
          You<./s>ll inevitably wander into one of 
          those rooms, and when you do, you<./s>ll die. 
          And that<./s>s about it.<./q> ";
      "<p><.q>There<./s>s that, but then there<./s>s
          also the fact that I<./s>ve thought of
          an idea that might give you a chance of 
          survival,<./q> says Vicki. ";
      //isOn = nil;
    }
    // For all remaining cases, the PC knows the
    // password.
    else {
      "<p><.q>Well, you already know it<./s>s a 
          virtual reality maze game with a lot of 
          <.s>insta-death<./s> rooms,<./q>
          says Vicki. 
        <p><.q>And you know it has a reputation 
          for decreasing the life expectancy 
          of those who play it,<./q> says Diane. 
        <p>";
      // Knows password, but hasn't been to VR
      if (!me.hasSeen(vrRoom)) {
        "<.q>But now we<./s>ve got a good guess as to 
            the food dispenser password,<./q> says Vicki. 
            <.q>And if you<./s>re 
            very lucky, you might be able to use it 
            to fix things to your advantage.<./q> ";
      }
      // Has been to VR, but hasn't told Vicki 
      // about running compiler or winnability.
      else if (!mazesExe.npcsKnowComp &&
               mazesExe.npcsLastSaw == nil) {
        "<.q>But we guessed the food dispenser password, 
            and you seem to have used it in a big way,<./q> 
            says Vicki. <.q>I don<./s>t know 
            whether that will help you survive the game, 
            but maybe there<./s>s hope.<./q> ";
      }
      // Has told Vicki about running compiler, 
      // but not winnability.
      else if (mazesExe.npcsLastSaw == nil) {
        "<.q>But you did manage to hack into their system 
            and recompile the game,<./q> says Vicki. 
            <.q>That sounds promising, 
            and I certainly hope you<./s>ll have a chance 
            of surviving the game now.<./q> ";
      }
      // Has told Vicki about running winnability,
      // and last time you talked to her, the odds
      // of winning were very low.
      else if (mazesExe.npcsLastSaw == zero ||
               mazesExe.npcsLastSaw == one) {
        "<.q>But you did manage to hack into their system and 
            <<mazesExe.npcsKnowComp
              ? 'recompile the game'
              : 'everything' >>,<./q> says Vicki. 
            <.q>You said the odds of winning were very low, 
            but maybe if you keep working at it you<./s>ll 
            fix things so you have a chance of surviving.<./q> ";
      }
      // Has told Vicki about running winnability,
      // and last time you talked to her, the odds
      // of winning were reasonably good.
      // That is, mazesExe.npcsLastSaw == fifty
      else {
        "<.q>But you did manage to hack into their system 
            and recompile the game,<./q> says Vicki. 
            <.q>You said the odds of winning were 
            relatively decent, so I certainly hope 
            you<./s>ll have a chance of surviving the game 
            now.<./q> ";
      }
    } // end "knows password" scenario.
  }
  //Do not automatically turn this quip off.
  //qOff = [vd1Heard]
  
  // I was going to keep this quip on permanently, but
  // my testers found this supremely redundant. As a way
  // of correcting this, the quip hardly needs to be on
  // after the PC knows that the insta-death-filled maze game
  // will also kill him in real life. At that point,
  // he's learned pretty much all V & D can tell him
  // about the game.
  isOn = (!glob.knowsAboutFourthTier)
;

vd1Know: Quip
  "<.q>How do you know all this stuff about their 
      game, anyway?<./q> "
  reply {
    "<.q>How do you know all this stuff about their 
        game, anyway?<./q> you ask. ";
    if (glob.knowsAboutFourthTier) {
      if (!glob.knowsAboutFertility) {
//        <p>Diane says, <.q>After that it was easy 
//          to persuade them that we were more valuable 
//          to them as potential mothers than as 
//          fodder for their maze game.<./q>
//        <p><.q>Sorry that doesn<./s>t help
//          you very much,<./q> Vicki says with a wan smile. 
//          <.q>Please, though. Don<./s>t tell them 
//          about our lie, or we<./s>ll
//          be in big trouble.<./q> ";
        "<p><.q>Well, when the aliens brought the two of us 
            here, originally they 
            wanted us to play the maze game,<./q> says Diane.
            <.q>They described it as 
            <.s>interactive fiction,<./s> which at that
            time I hadn<./s>t heard of, so they
            explained it further. It sounded more like 
            virtual reality than anything else.<./q> ";
        "<p><.q>But then we overheard them talking 
            in the hallway,<./q> says Vicki,
            <.q>and we soon learned
            that any trip into the maze would be fatal.<./q> ";
        "<p><.q>So we came up with a plan,<./q> says Diane.
            <.q>Vicki and I managed to persuade the aliens 
            that, unlike most of the other cryogenically
            frozen women out there, we were still capable
            of bearing children.<./q>
          <p><.q>It was a lie, of course,<./q> says Vicki.
            <.q>But they believed us just the same,
            and they decided that we were more valuable 
            to them as potential mothers than as 
            fodder for their maze game.<./q>
          <p><.q>Soon after that, the aliens brought in 
            a couple of men, like you,<./q> Diane says.
            <.q>Our <.s>child-bearing<./s> excuse
            didn<./s>t work as well for them. 
            They got shipped off to the maze game
            and never came back.<./q>
          <p><.q>Please don<./s>t tell the aliens
            about our lie,<./q> says Vicki. <.q>I don<./s>t
            think it would help you if you told them. 
            But it certainly would
            put a noose around our necks.<./q> ";
        //"<p><.q>So anyway, to answer your question, 
        //    that<./s>s how we learned
        //    what we know about the maze game,<./s> says Diane. ";
      }
      else {
        "<p><.q>Well, when the aliens brought the two of us 
            here, originally they 
            wanted us to play the maze game,<./q> says Diane.
            <.q>They described it as 
            <.s>interactive fiction,<./s> which at that
            time I hadn<./s>t heard of, so they
            explained it further. It sounded more like 
            virtual reality than anything else.<./q> ";
        "<p><.q>Pretty soon Diane overheard them talking 
            in the hallway,<./q> says Vicki,
            <.q>and we soon learned
            that any trip into the maze would be fatal.<./q> ";
        "<p>Diane says, <.q>That<./s>s when we came up with our 
            <.s>child-bearing<./s> story, and that<./s>s when
            they decided we were too valuable to be used 
            as fodder for their maze game.<./s><./q> ";
        "<p><.q>Unfortunately, then they brought in a couple 
            of men, like you,<./s> says Vicki. 
            <.q>Our <.s>child-bearing<./s>
            excuse didn<./s>t work so well for them, 
            so they got shipped off to the 
            maze game and never came back.<./q> ";
        //"<p><.q>So anyway, that<./s>s how we learned
        //    what we know about the maze game,<./s> says Diane. ";
      }
      glob.knowsAboutFertility = true;
      vd1Play.isOn = nil;
    } // end "knowsAboutMazeDeath" scenario
    else {
      "<p><.q>Well, when the aliens brought the two of us 
          here,<./q> says Diane, <.q>originally they 
          wanted us to play the maze game.<./q>
        <p>Vicki says, <.q>They described it to us as 
          <.s>interactive fiction,<./s> which at that
          time Diane hadn<./s>t heard of, so they
          explained it to us. It sounded more like 
          virtual reality than anything else.<./q> ";
    }
  }
  isOn = nil
  qOff = [vd1Know]
;

vd1Play: Quip
  "<.q>How come they<./s>re not having <i>you</i> 
      play their game?<./q> "
  reply {
    "<.q>How come they<./s>re not having <i>you</i> 
        play their game?<./q> you ask.
      <p>";
    // This first case is really bogus and should 
    // never happen. But just to be safe...
    if (glob.knowsAboutFertility) {
      "Vicki says, <.q>Well, as you know, we can<./s>t 
          bear children anymore,
          but we nevertheless persuaded the aliens that 
          we could. So they<./s>re keeping
          us as potential mothers, rather than as 
          maze-runners, so to speak.<./q> ";
    }
    else if (!glob.knowsAboutFourthTier) {
      "Vicki and Diane look at each other for a moment. 
          Then Diane says, <.q>Well, fortunately, 
          we managed to persuade the aliens that, unlike
          most of the cryogenically frozen women out there,
          we were still capable of bearing children.<./q>
        <p><.q>It was a lie, of course,<./q> says Vicki.
          <.q>But they believed us just the same.<./q>
        <p><.q>Now they<./s>re keeping us as
          potential mothers,<./q> says Diane, 
          <.q>and having other people run in their mazes.
          Which suits us fine.<./q>
        <p><.q>Sorry that doesn<./s>t help
          you very much,<./q> Vicki says with a wan smile. 
          <.q>But please, don<./s>t tell them 
          about our lie, or we<./s>ll
          be in big trouble.<./q> ";
    }
    else {
      "Vicki and Diane look at each other for a moment. 
          Then Diane says, <.q>Well, 
          after we figured out that the maze game was a
          near-certain deathtrap, 
          we managed to persuade the aliens that, unlike
          most of the cryogenically frozen women out there,
          we were still capable of bearing children.<./q>
        <p><.q>It was a lie, of course,<./q> says Vicki.
          <.q>But they believed us.<./q>
        <p>Diane says, <.q>After that it was easy 
          to persuade them that we were more valuable 
          to them as potential mothers than as 
          fodder for their maze game.<./q>
        <p><.q>Sorry that doesn<./s>t help
          you very much,<./q> Vicki says with a wan smile. 
          <.q>Please, though. Don<./s>t tell them 
          about our lie, or we<./s>ll
          be in big trouble.<./q> ";
      //"after we figured out that the maze game was a
      //    near-certain deathtrap, 
      //    Vicki and I managed to convince the aliens that they
      //    might need us for the procreation of the human
      //    species. We told them that there are probably
      //    very few fertile women in cryogenic stasis,
      //    so Diane and I may be more valuable to them as
      //    potential mothers than as fodder for their 
      //    mazes.<./q>
      //  <p><.q>Luckily for us, Neton and Ovan actually 
      //    bought that line of reasoning, and as a result 
      //    we haven<./s>t had to play their maze game,<./q> 
      //    says Vicki. ";
    }
    glob.knowsAboutFertility = true;
    vd1Play.isOn = nil; // just to be sure
  }
  isOn = nil
  qOff = [vd1Play]
;

vd1Players: Quip
  "<.q>Who<./s>s played their game, anyway?<./q> "
  reply {
    "<.q>Who<./s>s played their game, anyway?<./q> 
        you ask.
      <p><.q>Well, there was one guy named Stephen,
        an investor from Vancouver,<./q>
        says Vicki. <.q>Then there was another guy
        named Doug, a scientist from Virginia. 
        Unfortunately, we never got to know them
        very well, though.<./q>
      <p><.q>Both of them were here for only
        one night,<./q> says Diane. <.q>After that
        they were led off down the hallway 
        to play the maze game and never came back.
        Later, I heard Ovan talking in the hallway
        about how Doug was dead. I assume the same
        is true for that businessman.<./q> ";
  }
  isOn = nil
  qOff = [vd1Players]
;

vd1Text: Quip
  "<.q>So I gather the two of you 
      have played text adventures?<./q> "
  reply {
    "<.q>So I gather the two of you 
        have played text adventures?<./q> you say. 
      <p><.q>I never have,<./q> says Diane,
        <.q>although Vicki has told me about them,
        and I<./s>ve gotten a general idea 
        of what they<./s>re like.<./q>
      <p>Vicki says, <.q>I played <i>Wishbringer</i> 
        back in the 80s, and I guess one or two others.
        Before I was unfrozen
        I hadn<./s>t thought about those games
        for years,<./q> she says, musing. 
        Then she hastens to add, <.q>But don<./s>t 
        ever tell Neton or Ovan I said that. 
        I<./s>ve managed to conceal this from them, 
        and I<./s>d have my neck in a noose if they 
        found out.<./q> ";
  }
  isOn = nil
  qOff = [vd1Text]
;

vd1Admin: Quip
  "<.q>What<./s>s with the administrator login 
    on that food dispenser?<./q> "
  reply {
    "<.q>What<./s>s with the administrator login 
      on that food dispenser?<./q> you ask. ";
    if (!glob.knowsAboutFourthTier) {
      "<p>Vicki says, <.q>We<./s>ve
          tried logging in there several times. It seems
          to ask for a password, but no username. 
          Even so, we<./s>ve never managed to successfully 
          log in. And we don<./s>t really know why the option
          is there.<./q> ";
    }
    else {
      "<p><.q>That<./s>s just what I was about to tell you,<./q>
        says Vicki. "; // no <p>
      explainFifthTier(self);
    }
    needNotBeTurnedOnAgain = true; // just to be sure
    //}
    //else if (!glob.knowsAboutSixthTier) {
    //  " ";
    //}
    //else {
    //  " ";
    //}
  }
  needNotBeTurnedOnAgain = nil
  isOn = nil
  qOff = [vd1Admin]
;

vd1Cube: Quip
  "<.q>What do you think of the food around here?<./q> "
  reply {
    "<.q>What do you think of the food around here?<./q>
        you ask.
      <p>Diane glares at you angrily.
      <p>Vicki just looks at you with a weary expression.
        <.q>It<./s>s kept us alive so far,<./q> she says.
        <.q>And admittedly, we seem to be in decent health. 
        But I<./s>d give anything for real food.<./q> 
      <p>Diane says, <.q>At this point, even school lunch 
        food would be a welcome change.<./q> ";
    hasBeenSelected = true;
  }
  isOn = nil
  hasBeenSelected = nil
  qOff = [vd1Cube]
;

vd1Long: Quip
  "<.q>How long have the two of you been unfrozen?<./q> "
  reply {
    "<.q>How long have the two of you been unfrozen?<./q> 
        you ask.
      <p><.q>Reply.<./q> ";
  }
  qOff = [vd1Long]
;

vd1Truth: Quip
  "<.q>Do you believe the aliens have been 
      telling you the truth?<./q> "
  reply {
    "<.q>Do you believe the aliens have been 
        telling you the truth?<./q> you ask.
      <p><.q>Reply.<./q> ";
  }
  qOff = [vd1Truth]
;

vd1Revive: Quip
  "<.q>Why did the aliens revive the two of you?<./q> "
  reply {
    "<.q>Why did the aliens revive the two of you?<./q> 
        you ask.
      <p><.q>Reply.<./q> ";
  }
  qOff = [vd1Revive]
;

vd1Told: Quip
  "<.q>Have the aliens told you anything that 
      they haven<./s>t told me?<./q> "
  reply {
    "<.q>Have the aliens told you anything that 
        they haven<./s>t told me?<./q> you ask.
      <p><.q>Reply.<./q> ";
  }
  qOff = [vd1Told]
;

vd1Person: QSub
  "Ask about a person\ .\ .\ . "
  options = [
     vd1Vicki
    ,vd1Diane
    ,vd1Vicdia
    ,vd1Diavic
    ,vd1Me
    ,vd1Neton
    ,vd1Ovan
    ,vd1Asst
    ,vd1Guards
  ]
;

vd1Earth: QSub
  "Ask about the Earth\ .\ .\ . "
  options = [
     vd1Nuclear
    ,vd1Captors
    ,vd1Humans
    ,vd1Frozen
    ,vd1Where
  ]
  isOn = true
  //isOn {
  //  return (
  //       vd1Nuclear.isOn
  //    || vd1Captors.isOn
  //    || vd1Humans.isOn
  //    || vd1Frozen.isOn
  //    || vd1Where.isOn
  //  );
  //}
;

vd1Vicki: Quip
  "<.q>So Vicki, tell me about yourself.<./q> "
  reply {
    "<.q>So Vicki, tell me about yourself,<./q> you say. 
      <p><.q>I grew up in Pasadena,<./q> Vicki replies,
        <.q>But after I got my Ph.D., I moved to Florida, 
        where I spent about 30 years as a history professor 
        at <<vicki.formerUniversity>>.
      <p><.q>They revived me from cryogenic stasis
        about a month and a half ago,<./q> she continues, 
        <.q>and pretty soon they flew me 
        here to this cell. The next day Diane arrived. ";
    if (!glob.knowsAboutFertility) {
      "Fortunately Diane and I managed to convince
          the aliens that we were still capable of 
          bearing children. This wasn<./s>t true,
          of course, but they believed us anyway. 
          As a result, they decided to keep us
          as potential mothers, and have not asked us
          to play their maze game. ";
    }
    else { // doesn't know about fertility
      "As you know, Diane and I managed to 
          convince the aliens that we were still
          capable of bearing children, so they decided
          to keep us as potential mothers, rather than
          having us run in their mazes. ";
    }
    "And so we bide our time here, without much to do.
        We should be grateful we<./s>re alive, I guess.
        But it<./s>s hard to feel that way. We<./s>re
        prisoners.<./q> ";
    vicki.hasExplainedProfession = true;
    glob.knowsAboutFertility = true;
    vd1Play.isOn = nil;
  }
  //qOff = [vd1Vicki]
;

vd1Diane: Quip
  "<.q>So Diane, tell me about yourself.<./q> "
  reply {
    "<.q>So Diane, tell me about yourself,<./q> you say. ";
    "<p>Diane sighs and gives you a long look.
        Then, finally, she says, <.q>Back in the 
        old days I worked as an air traffic controller 
        in Phoenix. But that was back in the old days.
      <p><.q>Six weeks ago the aliens woke me up
        and took me here, where I met Vicki. 
        Luckily, so far 
        they haven<./s>t forced us to play their maze game.
        Unluckily, that means they
        keep us prisoners in this cell and make us eat
        cube-of-processed-seaweed every day.
        The more time goes by, the more I wish I<./s>d
        never agreed to be cryogenically frozen.
        I didn<./s>t want this.<./q> ";
    //if (!hasBeenSelected)
    //  "<p>Diane sighs and gives you a long look.
    //      Then, finally, she says, <.q>Back in the 
    //      old days I worked as an air traffic controller 
    //      in Phoenix. But that was back in the old days.
    //    <p><.q>Six weeks ago the aliens woke me up
    //      and took me here, where I met Diane. 
    //      Luckily, so far 
    //      they haven<./s>t forced us to play their maze game.
    //      Unluckily, that means they
    //      keep us prisoners in this cell and make us eat
    //      cube-of-processed-seaweed every day.
    //      The more time goes by, the more I wish I<./s>d
    //      never agreed to be cryogenically frozen.
    //      I didn<./s>t want this.<./q> ";
    //else
    //  "<p>Diane ignores you. ";
    diane.hasExplainedProfession = true;
    hasBeenSelected = true;
  }
  hasBeenSelected = nil
  //qOff = [vd1Diane]
;

vd1Vicdia: Quip
  "<.q>So Vicki, tell me about Diane.<./q> "
  reply {
    "<.q>So Vicki, tell me about Diane,<./q> you say. 
      <p><.q>When Diane came here last month, at first
        I was really annoyed by her,<./q> says Vicki.
      <p>Diane raises her eyebrow and casts Vicki an
        attentive glance.
      <p><.q>But then I got to know her,<./q> Vicki
        continues. <.q>She<./s>s not so bad, most of
        the time. You just have to ignore her when she
        says something sharp.<./q>
      <p>Then Vicki muses a bit more, and says to Diane,
        <.q>That said, I <i>do</i> wish you<./s>d 
        knock off the verbal abuse.<./q>
      <p><.q>What verbal abuse?<./q> asks Diane.
      <p><.q>Like the time you called me an idiot,<./q>
        says Vicki.
      <p><.q>That<./s>s because you were 
        trying to guess how the food dispenser worked, 
        and your guess went against basic electronics,<./q>
        says Diane.
      <p>Vicki sighs. ";
  }
  //qOff = [vd1Vicdia]
;

vd1Diavic: Quip
  "<.q>So Diane, tell me about Vicki.<./q> "
  reply {
    "<.q>So Diane, tell me about Vicki,<./q> you say. 
      <p>Diane shrugs. <.q>Vicki<./s>s okay.
        It<./s>s better than being stuck in here with
        my son-in-law, that<./s>s for sure. 
        And it<./s>s better than being here 
        in complete isolation, I think.<./q>
      <p><.q>Thanks a lot,<./q> says Vicki.
      <p><.q>But seriously, Vicki is a good person
        to have around,<./q> Diane continues.
        <.q>We never could have figured out as much 
        as we have if we had to do it by ourselves.
        By pooling our knowledge, we<./s>ve gotten
        a much clearer picture of what<./s>s going on
        around here. If nothing else, Vicki<./s>s
        proven her merits that way.<./q>
      <p><.q>Yeah, right,<./q> says Vicki.
        <.q>Just don<./s>t forget who was here 
        first.<./q>
      <p>Diane shrugs. ";
  }
  //qOff = [vd1Diavic]
;

vd1Me: Quip
  "<.q>What do you think of me?<./q> "
  reply {
    "<.q>What do you think of me?<./q> you ask. ";
    if (!me.hasSeen(vrRoom)) {
      "<p>Diane rolls her eyes. ";
    }
    "<p>Vicki says, ";
    // Doesn't know password
    if (!glob.knowsAboutFifthTier) {
      "<.q>I<./s>m certainly pleased to have
          met you. You seem like a nice person.
          I wish you luck in the maze game 
          tomorrow. You<./s>ll definitely need it.<./q> ";
    }
    // Knows password, but hasn't been to VR
    else if (!me.hasSeen(vrRoom)) {
      "<.q>I<./s>m certainly pleased to have
          met you. You seem like a nice person
          to me. I wish you luck in the maze game 
          tomorrow. I hope you make use of 
          the password we gave you.<./q> ";
    }
    // Has been to VR, but hasn't told Vicki 
    // about running compiler or winnability.
    else if (!mazesExe.npcsKnowComp &&
             mazesExe.npcsLastSaw == nil) {
      "<.q>You<./s>re certainly making progress.
          You made good use of the password we gave you,
          and I<./s>m starting to wonder if you
          might have a chance of winning the game
          tomorrow.<./q> ";
    }
    // Has told Vicki about running compiler, 
    // but not winnability.
    else if (mazesExe.npcsLastSaw == nil) {
      "<.q>You<./s>re certainly making progress.
          You successfully recompiled
          that maze game, and I<./s>m starting to
          wonder if you  might have a real chance of 
          winning.<./q> ";
    }
    // Has told Vicki about running winnability,
    // and last time you talked to her, the odds
    // of winning were very low.
    else if (mazesExe.npcsLastSaw == zero ||
             mazesExe.npcsLastSaw == one) {
      "<.q>You<./s>re certainly making progress.
          You made good use of the password we gave you,
          and you successfully recompiled the maze game.
          I know you said the odds of winning
          were low, but I think that as long
          as you keep at it, you might have a 
          real chance of winning.<./q> ";
    }
    // Has told Vicki about running winnability,
    // and last time you talked to her, the odds
    // of winning were reasonably good.
    // That is, mazesExe.npcsLastSaw == fifty
    else {
      "<.q>You<./s>re certainly making progress.
          Not only did you successfully recompile 
          the maze game, but you also said the
          odds of winning were about 30 to 50 percent. 
          I<./s>d say that gives you have 
          a real chance of winning the game.<./q> ";
      //"<.q>Frankly, I was impressed by
      //    your ability to recompile a new version
      //    of the maze game. And then you told
      //    us you had a reasonably good chance
      //    of winning the game tomorrow. I<./s>m
      //    proud of you, and I hope you win.<./q> ";
      //"<p><.q>Me too,<./q> says Diane. And, 
      //    very briefly, she smiles at you. ";
    }
  } // end reply
  //qOff = [vd1Me]
;

vd1Neton: Quip
  "<.q>What do you think of Neton?<./q> "
  reply {
    "<.q>What do you think of Neton?<./q> you ask. ";
    "<p>Vicki says, ";
    if (!fascismEnunciated) {
      "<.q>Well, as far as I can tell, he<./s>s 
          a good administrator.<./q>
        <p><.q>Yeah,<./q> says Diane. 
          <.q>So was Eichmann.<./q>
        <p>Vicki rolls her eyes fiercely, then shakes
          her head. ";
      fascismEnunciated = true;
    }
    "<.q>The way I see it, Neton is just 
        your normal, run-of-the-mill, conformist 
        professional. The problem is, he<./s>s 
        a conformist professional in a society 
        that sees no value in human life whatsoever.<./q>
      <p><.q>One time I told him that humans 
        have rights,<./q> says Diane. 
        <.q>He just looked at me uncomprehendingly 
        for a few seconds, then burst out laughing, 
        saying, <.s>Some humans think they<./s>re 
        people!<./s><./q>
      <p><.q>For all that, he<./s>s not evil or 
        anything,<./q> says Vicki. <.q>At least 
        he<./s>s polite to us. And he did get 
        the toilet fixed that one time.<./q>
      <p><.q>Yeah, as prison wardens go, he<./s>s 
        real swell,<./q> says Diane. ";
  }
  fascismEnunciated = nil
  //qOff = [vd1Neton]
;

vd1Ovan: Quip
  "<.q>What do you think of Ovan?<./q> "
  reply {
    "<.q>What do you think of Ovan?<./q> you ask. 
      <p><.q>If Ovan is their idea of a humanities professor,
        then I<./s>d say their educational system
        is in deep trouble,<./q> says Vicki. ";
    //"<p><.q>From what I<./s>ve heard,<./q> says Diane,
    //    <.q>he does nothing but play computer games
    //    all day long.<./q>
    //  <p><.q>That<./s>s not what I<./s>d call 
    //    productive,<./q> says Vicki. ";
    "<p><.q>He really is a lamebrain,<./q>
        says Diane. Then she scoffs mirthlessly
        and adds, 
        <.q>One time he told me he<./s>d 
        rather play interactive fiction than read
        any of Shakespeare<./s>s <.s>novels.<./s> 
        What a dumbass!<./q> 
      <p><.q>Well, at least he has a sincere enthusiasm
        for interactive media,<./q> says Vicki.
      <p><.q>That<./s>s for sure,<./q> says Diane.
        <.q>From what I<./s>ve heard, he does nothing
        but play computer games, morning to night.<./q> 
      <p><.q>Not exactly a model professor,<./q> 
        agrees Vicki. ";
    "<p><.q>Don<./s>t let his cheerfulness
        fool you, though,<./q>
        says Diane. <.q>He doesn<./s>t respect 
        human beings any more than Neton does.
        I have no doubt that if the time comes 
        for him to kill us,
        he<./s>ll do so cheerfully. Cheerfully,
        I say.<./q> ";
  }
  //qOff = [vd1Ovan]
;

vd1Asst: Quip
  "<.q>What do you think of the assistant?<./q> "
  reply {
    "<.q>What do you think of the assistant?<./q> 
        you ask. 
      <p>Vicki and Diane exchange glances for 
        a moment. Then Diane says, <.q>I don<./s>t
        know what to think about that guy.
        He<./s>s always quiet and soft-spoken,
        but I swear there<./s>s something more
        under the surface. I couldn<./s>t say
        more than that, though.<./q> ";
  }
  //qOff = [vd1Asst]
;

vd1Guards: Quip
  "<.q>What do you think of the guards?<./q> "
  reply {
    "<.q>What do you think of the guards?<./q> 
        you ask. 
      <p><.q>They certainly do a good job of keeping
        the upper hand,<./q> says Vicki.
      <p><.q>If you catch them in one of their
        non-angry, non-gun-pointing moods, it<./s>s
        not hard to see differences between them,<./q>
        says Diane. <.q>That young guard is just a
        musclehead jock. And the old one seems to be
        counting the days to his retirement.<./q> 
      <p><.q>But I still wouldn<./s>t want to go up against
        either of them,<./q> says Vicki.
        <.q>At least not as long as he had his hand cannon
        at his side.<./q> ";
  }
  //qOff = [vd1Guards]
;

vd1Nuclear: Quip
  "<.q>Do you think there really was a nuclear war?<./q> "
  reply {
    "<.q>Do you think there really was a nuclear war?<./q> 
        you ask. 
      <p>Vicki and Diane exchange glances. 
      <p>Vicki says, <.q>Well, certainly, that is the only
        explanation we<./s>ve heard as to why we<./s>re 
        in this situation. It<./s>s a plausible story,
        and I guess I<./s>ll believe it until I have
        reason to believe otherwise.<./q> ";
  }
  //qOff = [vd1Nuclear]
;

// This quip has been cut.
vd1Captors: Quip
  "<.q>Do you think our captors really are aliens?<./q> "
  reply {
    "<.q>Do you think our captors really are aliens?<./q> 
        you ask. 
      <p><.q><b>UNFINISHED</b><./q> ";
  }
  isOn = nil 
  //qOff = [vd1Captors]
;

vd1Humans: Quip
  "<.q>What do you think about the human beings
      out there who survived the war?<./q> "
  reply {
    "<.q>What do you think about the human beings
        out there who survived the war?<./q> 
        you ask. 
      <p><.q>Honestly, I don<./s>t give them a lot of
        thought,<./q> says Diane. <.q>For that
        I<./s>d have to believe that we had
        a chance in hell of getting out of here.<./q>
      <p><.q>Personally, I have thought
        about them,<./q> says Vicki, <.q>but I agree
        it may be a moot point. I mean, even if we escaped
        and wanted to help the indigenous human populations 
        in some way, how would we do it? 
        For one thing, those people are illiterate 
        scavengers and hunters, at least according to 
        Neton and Ovan. 
        For all we know they might regard us
        as enemies and attack us. Also, how much could we help
        a society whose whole underpinnings have been stripped 
        away? It might be worth a try, I guess. 
        But for now it<./s>s impossible in any case.<./q> ";
  }
  //qOff = [vd1Humans]
;

vd1Frozen: Quip
  "<.q>What do you think about the remaining cryogenically
      frozen people out there?<./q> "
  reply {
    "<.q>What do you think about the remaining cryogenically
        frozen people out there?<./q> you ask. 
      <p><.q>I think about them a lot,<./q> says Vicki.
        <.q>If I could somehow escape from here, I<./s>d
        want to fly to them and release them 
        in the hopes of building some reasonably decent 
        community.<./q>
      <p><.q>But that<./s>s impossible, for about
        ten different reasons,<./q> says Diane.
      <p><.q>Yes,<./q> Vicki admits. <.q>We 
        don<./s>t know how to revive anyone
        from cryogenic stasis.<./q> 
      <p><.q>Not even Earth<./s>s best scientists
        knew how to do that,<./q> says Diane.
        <.q>And even if we learned how to do it,
        we<./s>d still have to get transportation
        to the other side of the world,
        contend with nuclear radiation,
        and fend off hostile cavemen, wild beasts,
        and a hopelessly advanced alien civilization.<./q> 
      <p>Vicki sighs. <.q>True enough,<./q> she says.
        <.q>But I won<./s>t give up on the possibility,
        because the only alternative is to believe
        that there<./s>s nothing left to fight for.
        And I won<./s>t do that.<./q> ";
  }
  //qOff = [vd1Frozen]
;

vd1Where: Quip
  "<.q>Where are we, anyway?<./q> "
  reply {
    "<.q>Where are we, anyway?<./q> you ask. 
      <p><.q>Neton and Ovan say we<./s>re at a place called
        CESAC, which is somewhere in
        Australia, and I<./s>ve seen nothing to suggest
        that they were lying,<./q> says Diane. 
      <p>Vicki adds, <.q>If there really was a nuclear war, 
        it would make sense for the aliens to favor 
        the Southern Hemisphere. Any residual
        radiation would probably be in the Northern Hemisphere,
        because that<./s>s where most nuclear targets
        were, back in the old days.<./q> ";
  }
  //qOff = [vd1Where]
;

//modify glob
//  knowsAboutFifthTier = true
//;


// -------------------------------------------------------------------
// PRIOR TO CUT SCENE 3
// -------------------------------------------------------------------

// Obviously, going to sleep is the act that initiates Cut Scene 3.

modify me
  goToSleep() {
    if (isIn(coffin))
      "You feel as though you<./s>ve just spent an eternity 
          trying to wake up. You<./s>re not about to
          go back to sleep right now. ";
    else if (isIn(cell) && !glob.isInEndgame && !location.ofKind(Bunk)) {
      "Perhaps you are a bit tired. 
          But you<./s>ll have to find a good place
          to sleep before settling in for the night. ";
    }
    else if (isIn(cell) && !glob.isInEndgame) { // location is a bunk
      if (!glob.sleepFuseIsOn) {
        "Perhaps you are a bit tired. But you don<./s>t want to
            sleep until you<./s>ve done everything you need to do
            tonight. Are you sure you want to sleep? ";
        glob.sleepFuseIsOn = true;
        ncYesNo.set(
          new function { reallySleep(); }
         ,'Okay, you decide not to sleep. '
        );
      }
      else { // glob.sleepFuseIsOn
        reallySleep;
      }
    }
    else
      "You<./s>re not particularly tired right now. ";
  }
  reallySleep {
    //"Okay. You really sleep. Then, a few moments later, you wake up. ";
    "You call out to Vicki and Diane, <.q>Well, I guess that<./s>s
        it for me. I<./s>m going to bed. Good night!<./q> 
      <p><.q>Sleep well,<./q> says Vicki. <.q>Good luck
        with the maze game tomorrow.<./q> 
      <p>With that, you stretch out on the bunk. 
        You toss and turn a bit, then finally fall asleep. ";
    cutScene3.execute;
  }
;

// -------------------------------------------------------------------
// CUT SCENE 3
// -------------------------------------------------------------------

// New version of Cut Scene 3 as of Aug. 2006.

cutScene3: CutScene
  beginScene {
    // When ending the cut scene, and when killing the player,
    // normally these would involve updating the right-hand banner.
    // Prevent this.
    glob.dontUpdateBanner = true;
    // Make sure the food cube disappears
    foodCube.moveInto(nil);
  }
  endScene {
    // Initial stuff: In all cases, the status line should be blank
    // at this point.
    glob.status = blank;
    statusLine.showStatusLineDaemon();
  
    // ----------------
    // Case 1: Game is viable but not winnable (original state)
    
    if (mazesExe.isViable && !mazesExe.isWinnable) {
      // Courier font
      glob.font = courier;
      "<.nbmfont>";
      // Show final text
      "(You wake up in a maze of twisty little passages,
          all alike.
          Nervous and overwhelmed, you soon
          decide you have no choice but to explore. 
          After a bit of wandering, you get lost
          in the dark. Soon you hear a growl, 
          and then a noxious beast comes and assaults you. 
          As its teeth mince your flesh, your last thoughts are,
          how could I have avoided this calamity?) ";
      
      gPlayerChar.moveInto(nil);
      // Kill the PC
      endGame(ftTwisty);
    }
    
    // ----------------
    // Case 2: the game is not viable (modified ineffectually)
    
    else if (!mazesExe.isViable) {
      // Note that there should be no nbmBanner now.
      // Verdana font. This should be redundant, but whatever.
      glob.font = verdana; // redundant, but whatever
      "<.nbmfont>";
      // Show final text
      ".\ .\ .\ but then, oddly enough,
          you regain consciousness, right back
          where you were before.
        <p><.q>What?<./q> says Ovan. <.q>The game didn<./s>t 
          even run! I don<./s>t get it!<./q>
        <p><.q>The readout says, <.s>Nonviable .exe file,<./s><./q>
          says Neton.
        <p><.q>Nonviable?<./q> shouts Ovan. <.q>But it worked just
          fine yesterday, and I haven<./s>t changed it since then!<./q>
        <p><.q>Well, if you didn<./s>t change it, and 
          I didn<./s>t change it, then somebody else must have 
          changed it,<./q> says Neton, and he casts  
          you a suspicious glance. Finally he says, 
          <.q>I have my doubts about this human. Perhaps 
          he is not worth keeping after all.<./q> 
        <p>Then, turning to the guards, he says, 
          <.q>Please dispose of the prisoner.<./q> ";
      "<p>The guards eagerly oblige, raising their guns
          and firing at you. 
          For a moment you are engulfed in blinding light and 
          agonizing pain. Then you collapse to the floor. 
        <p>In case it is any consolation, you should know that 
          the guards tremendously enjoyed killing you. 
          In times like this, it may be a comfort to know 
          that you have not died in vain. ";
      // Kill the PC.
      endGame(ftDeath);
    }
    
//    // ----------------
//    // Case 3: the game is viable and winnable (modified successfully)
//    // and this is the IntroComp version
//    
//    // We veto Case 3 with "nil" because this is not the IntroComp version
//    
//    else if (nil) { // && mazesExe.isViable && mazesExe.isWinnable
//    
//      // ----------
//      // Case 3, Part A: Initial stuff
//      
//      // Courier font
//      glob.font = courier;
//      "<.nbmfont>";
//      // Cancel pending commands:
//      // Don't add this to the IntroComp
//      // version, or you'll regret it. This created a huge bug.
//      //cancelPendingCommands();
//      
//      // ----------
//      // Case 3, Part B: Show penultimate text (no beach chair)
//      
//      if (!beachChairM.isInExe) {
//        "(You wake up in an entirely empty room, whose only 
//            feature is a tablet device lying on the floor.
//            You walk over and pick up the tablet device, only
//            to discover, to your annoyance, that 
//            the only thing you can do with it is
//            play the aliens<./s> maze game.) ";
//        victoryKey();
//        "<p>(You try exploring the room and looking
//            for ways out, but it truly is an entirely
//            featureless room. Sadly, there is nothing to do
//            here but play the game.) ";
//        victoryKey();
//        "<p>(With a heavy sigh, you glance at the tablet device.
//            You fully expect the game to be annoying and 
//            tedious, but at least you<./s>re guessing
//            it won<./s>t be life-threatening to you,
//            not as you stand here in this empty room.) ";
//        victoryKey();
//        "<p>(You begin to play.) ";
//      }
//      
//      // ----------
//      // Case 3, Part C: Show penultimate text (beach chair scenario)
//      
//      else {
//        "(You wake up on a beautiful, sandy beach. 
//            You are sitting on a beach chair 
//            in front of a peaceful ocean. Warm sun shines
//            down, while a 
//            <<butterflyIdM.isInExe 
//              ? 'red-spotted purple butterfly 
//                  (<i>Limenitis arthemis</i>)'
//              : 'butterfly'>>
//            flies by on the breeze.
//            As you sit, you notice an ice-cold banana daiquiri
//            on one side of the chair. You pick 
//            it up and sip it with pleasure.
//            Then you notice that on the other side of your
//            chair lies a tablet device. You pick it up and turn it on. 
//            Unfortunately, to your annoyance, the only thing you can
//            do with it is play the aliens<./s> maze game.) ";
//        victoryKey();
//        "<p>(For now you ignore the tablet device. You sip on your
//            daiquiri, then lie in the sun.) ";
//        victoryKey();
//        "<p>(But then, after a few minutes, 
//            you start to wonder how you can leave this place.
//            You get up and try walking down the beach, 
//            but you don<./s>t seem to get anywhere. 
//            Suddenly it strikes you 
//            that you may never be able to get out of here 
//            until you accomplish what seems to be your
//            mission: to play the aliens<./s> maze game.) ";
//        victoryKey();
//        "<p>(You sigh heavily, then sit down
//            and pick up the tablet device.
//            You fully expect the game to be annoying
//            and tedious, but at least you<./s>re guessing
//            it won<./s>t be life-threatening to you,
//            not as you sit here in this beach chair.) ";
//        victoryKey();
//        "<p>(You begin to play.) ";
//      }
//      
//      // ----------
//      // Case 3, Part D: IntroComp ending
//      
//      // Pause for Input
//      nbmPause();
//      // Clear the main window; banner is coming
//      nbmCls();
//      // I don't know if I should ensure the status line is blank
//      //glob.status = blank;
//      //statusLine.showStatusLineDaemon();
//      
//      // "The end," plus accompanying fanfare
//      csDispImg('theend.png');
//      playSound('<sound src=\"sound/fanfare1.mp3\" layer=foreground>');
//      // Pause for input
//      nbmPause();
//      // Clear the banner
//      cutSceneBanner.clearWindow();
//      
//      // "For now!" plus accompanying fanfare
//      csDispImg('fornow.png');
//      playSound('<sound src=\"sound/fanfare2.mp3\" layer=foreground>');
//      // Pause for input
//      nbmPause();
//      // Remove the banner
//      cutSceneBanner.removeBanner();
//      
//      // Verdana font
//      glob.font = verdana;
//      "<.nbmfont>";
//      
//      // ----------
//      // Case 3, Part E: Show ultimate text and end game
//      
//      // Show ultimate text
//      "What will the game be like? ";
//      "<p>Will it really consist of nothing but mazes? ";
//      //"<p>If there are mazes, what will they be like? ";
//      "<p>Is it possible you might actually enjoy the game? ";
//      "<p>Find out in the next version of <i>Nothing
//          but Mazes!</i> ";
//      // End the game
//      endGame(ftIntro);
    
    // ----------------
    // Case 4: the game is viable and winnable (modified successfully)
    // and this is *NOT* the IntroComp version
    
    else { // && mazesExe.isViable && mazesExe.isWinnable
      // ----------
      // Case 4, Part A: Initial stuff
      
      // Change font to courier
      glob.font = courier;
      "<.nbmfont>";
      
      // Cancel pending commands:
      // Don't add this before doing the other stuff. That creates problems.
      //cancelPendingCommands();
      
      // ----------
      // Case 4, Part B: Go to empty room, if applicable
      
      if (!beachChairM.isInExe) {
        ". . . and you wake up in an empty room. ";
        "<p>";
        //nbmPause();
        goToEmptyRoom.execute;
        gPlayerChar.lookAround(verboseModeIsOn());
        cancelPendingCommands();
      }
      
      // ----------
      // Case 4, Part C: Go to beach, if applicable
      
      else {
        ". . . and you wake up on a beautiful, sandy beach. ";
        "<p>";
        //nbmPause();
        goToBeach.execute;
        gPlayerChar.lookAround(verboseModeIsOn());
        cancelPendingCommands();
      }
      
      
      
      // ----------
      // Notes
      
      // Possible butterfly species:
      // "Red-spotted purple": Limenitis arthemis: From New England to northern Mexico
      // "swallowtail": Papilio cresphontes / P. thoas: Mexico
      
      // Quote from Frederick Pohl's Gateway:
      // 
      // Grains of yellow fall from nowhere and spread out 
      // until they form a sandy beach. Blues appear 
      // in ragged streaks above, and then they melt together 
      // to become an azure sky. An ocean appears, 
      // then an outdoor bar. You look down and discover 
      // you're wearing swimming trunks and lounging 
      // on a beach chair. A cheerful bartender pops 
      // into existence. He puts a drink on the bar and looks 
      // at you expectantly.
      // 
      // Beach, on the beach chair
      //    The sun hangs directly overhead, tickling you 
      // with its warm, refreshing heat, and brightening 
      // the deep azure sky. You are relaxing on a beach chair, 
      // looking out to the calm ocean. Nearby, you see 
      // a seaside bar and behind it, a cheerful bartender 
      // smiles at you.
      //    The bartender is holding a cloth.
      //    On the beach bar you see a frosted glass.
    }
  }
  sceneList = [
    [ 'The night passes fitfully. You wake up
        over and over again, your sleep continually interrupted 
        by the most vivid dreams. 
        You pass the night thinking about fish pudding 
        and strawberry yams. ',
      nil,
      'illustrations/night_0300.jpg',
      'illustrations/night_0469.jpg' ],
    [ 'The next morning, you are awakened as Neton, Ovan,
        and the guards arrive. The four of them take 
        you down the hallway to one of the rooms you were in
        yesterday. ',
      nil,
      'illustrations/hallway3_0300.jpg',
      'illustrations/hallway3_0469.jpg' ],
    [ '<.q>Please lie down,<./q> says Neton,
        gesturing to the couch.
        At first you try to resist, but then the guards
        point their guns at you, and you decide you have no choice 
        but to lie down and accept your fate. ',
      nil,
      'illustrations/couch0300.jpg',
      'illustrations/couch0469.jpg' ],
    [ 'You feel a sense of trepidation as
        the arm is attached to your head. Then your thoughts 
        begin to fade\ .\ .\ . ',
      nil,
      'illustrations/couch0300.jpg',
      'illustrations/couch0469.jpg' ]
  ]
;

victoryKey() {
  nbmPause();
}

modify glob
  dontUpdateBanner = nil
;

// What follows is the old version of Cut Scene 3. 
// Since it has been commented out without problem, 
// I could certainly delete it if I wanted to.

//modify glob
//  cs3List = [
//    [ 'night.jpg',
//      'The night passes fitfully. You wake up
//        over and over again, your sleep continually interrupted 
//        by the most vivid dreams. 
//        You pass the night thinking about fish pudding 
//        and strawberry yams. ',
//      nil ],
//    [ 'hallway3.jpg',
//      'The next morning, you are awakened as Neton, Ovan,
//        and the guards arrive. The four of them take 
//        you down the hallway to one of the rooms you were in
//        yesterday. ',
//      nil ],
//    [ 'couch.jpg',
//      '<.q>Please lie down,<./q> says Neton,
//        gesturing to the couch.
//        At first you try to resist, but then the guards
//        point their guns at you, and you decide you have no choice 
//        but to lie down and accept your fate. ',
//      nil ],
//    [ 'couch.jpg',
//      'You feel a sense of trepidation as
//        the arm is attached to your head. Then your thoughts 
//        begin to fade\ .\ .\ . ',
//      nil ]
//    //[ '.jpg',
//    //  ' ',
//    //  nil ],
//  ]
//;
//
//cutSceneThree() {
//  //"Stretching out on the bunk, you toss and turn a bit, 
//  //    until before long you fall asleep. ";
//  nbmPause();
//  "<.p>";
//  glob.status = blank;
//  statusLine.showStatusLineDaemon();
//  nbmBanner.removeBanner;
//  foodCube.moveInto(nil);
//  nbmCls();
//  // Put up the cutSceneBanner, to clear the screen with nothing
//  // but a big banner.
//  csShout('');
//  // Make sure the text actually goes to the main window. People won't
//  // see this on the screen right now, because of the 100%-size banner
//  // window. But we have to do this, or else it won't go to the 
//  // transcript when we put the text to the banner later.
//  for (local a=1; a<=glob.cs3List.length(); ++a) {
//    "<<glob.cs3List[a][2]>><.p>";
//  }
//  nbmCls();
//  // Go through the slide show.
//  for (local a=1; a<=glob.cs3List.length(); ++a) {
//    // Clear the 100%-size banner window.
//    cutSceneBanner.clearWindow();
//    // Unless the first element in this part of the list is nil,
//    // display it as an image in the banner window.
//    if (glob.cs3List[a][1]) {
//      csDispImg(glob.cs3List[a][1]);
//    }
//    // If there is text to output to the window, output it.
//    if (glob.cs3List[a][2]) {
//      csShout(glob.cs3List[a][2]);
//    }
//    // If there is anything to output to the main window (i.e. sound)
//    // output it.
//    if (glob.cs3List[a][3]) {
//      "<<glob.cs3List[a][3]>>";
//    }
//    nbmPause();
//  }
//  
//  cutSceneBanner.removeBanner();
//  
//  glob.dontUpdateBanner = true;
//  // Case 1: the game is viable but not winnable (initial setting)
//  if (mazesExe.isViable && !mazesExe.isWinnable) {
//    glob.font = courier;
//    "<.nbmfont>";
//    
//    "(You wake up in a maze of twisty little passages,
//        all alike.
//        Nervous and overwhelmed, you soon
//        decide you have no choice but to explore. 
//        After a bit of wandering, you get lost
//        in the dark. Soon you hear a growl, 
//        and then a noxious beast comes and assaults you. 
//        As its teeth mince your flesh, your last thoughts are,
//        how could I have avoided this calamity?) ";
//    //"(You wake up in a huge maze of twisty little passages.
//    //    Nervous and overwhelmed, you soon
//    //    decide you have no choice but to explore. 
//    //    After only a bit of wandering, you get lost
//    //    in the dark, where you hear a noxious growl 
//    //    emerges from the shadows, 
//    //    and a foul beast leaps upon you. 
//    //    As its teeth mince your flesh, 
//    //    your last thought is, how could I have avoided
//    //    this calamity?) ";
//    //nbmPause();
//    endGame(ftTwisty);
//    
//  }
//  // Case 2: the game is not viable (messed with ineffectually)
//  else if (!mazesExe.isViable) {
//    glob.font = verdana; // redundant, but whatever
//    "<.nbmfont>";
//    //nbmBanner.updateMe;
//    
//    ".\ .\ .\ but then, oddly enough,
//        you regain consciousness, right back
//        where you were before.
//      <p><.q>What?<./q> says Ovan. <.q>The game didn<./s>t 
//        even run! I don<./s>t get it!<./q>
//      <p><.q>The readout says, <.s>Nonviable .exe file,<./s><./q>
//        says Neton.
//      <p><.q>Nonviable?<./q> shouts Ovan. <.q>But it worked just
//        fine yesterday, and I haven<./s>t changed it since then!<./q>
//      <p><.q>Well, if you didn<./s>t change it, and 
//        I didn<./s>t change it, then somebody else must have 
//        changed it,<./q> says Neton, and he casts  
//        you a suspicious glance. Finally he says, 
//        <.q>I have my doubts about this human. Perhaps 
//        he is not worth keeping after all.<./q> 
//      <p>Then, turning to the guards, he says, 
//        <.q>Please dispose of the prisoner.<./q> ";
//    "<p>The guards eagerly oblige, raising their guns
//        and firing at you. 
//        For a moment you are engulfed in blinding light and 
//        agonizing pain. Then you collapse to the floor. 
//      <p>In case it is any consolation, you should know that 
//        the guards tremendously enjoyed killing you. 
//        In times like this, it may be a comfort to know 
//        that you have not died in vain. ";
//    
//    //"<.q>What the&mdash;?<./q> says Ovan. 
//    //    <.q>The game didn<./s>t even run?
//    //    I don<./s>t get it!<./q>
//    //  <p><.q>The only likely explanation is that
//    //    the human somehow hacked into our system
//    //    and modified the game file,<./q>
//    //    says Neton. Then he turns to the guards
//    //    and says, <.q>Please dispose of the prisoner.<./q>
//    //  <p>The guards willingly oblige. ";
//    //nbmPause();
//    endGame(ftDeath);
//    
//  }
//  // Case 3: the game is viable and winnable (messed with successfully)
//  else { // mazesExe.isViable && mazesExe.isWinnable
//    glob.font = courier;
//    "<.nbmfont>";
//    
//    // Don't add the following line to the IntroComp
//    // version, or you'll regret it. This created a huge bug.
//    //cancelPendingCommands();
//    
//    if (!beachChairM.isInExe) {
//      "(You wake up in an entirely empty room, whose only 
//          feature is a tablet device lying on the floor.
//          You walk over and pick up the tablet device, only
//          to discover, to your annoyance, that 
//          the only thing you can do with it is
//          play the aliens<./s> maze game.) ";
//      victoryKey();
//      "<p>(You try exploring the room and looking
//          for ways out, but it truly is an entirely
//          featureless room. Sadly, there is nothing to do
//          here but play the game.) ";
//      victoryKey();
//      "<p>(With a heavy sigh, you glance at the tablet device.
//          You fully expect the game to be annoying and 
//          tedious, but at least you<./s>re guessing
//          it won<./s>t be life-threatening to you,
//          not as you stand here in this empty room.) ";
//      victoryKey();
//      "<p>(You begin to play.) ";
//    }
//    else {
//      "(You wake up on a beautiful, sandy beach. 
//          You are sitting on a beach chair 
//          in front of a peaceful ocean. Warm sun shines
//          down, while a 
//          <<butterflyIdM.isInExe 
//            ? 'red-spotted purple butterfly 
//                [<i>Limenitis arthemis</i>]'
//            : 'butterfly'>>
//          flies by on the breeze.
//          As you sit, you notice an ice-cold banana daiquiri
//          on one side of the chair. You pick 
//          it up and sip it with pleasure.
//          Then you notice that on the other side of your
//          chair lies a tablet device. You pick it up and turn it on. 
//          Unfortunately, to your annoyance, the only thing you can
//          do with it is play the aliens<./s> maze game.) ";
//      victoryKey();
//      "<p>(For now you ignore the tablet device. You sip on your
//          daiquiri, then lie in the sun.) ";
//      victoryKey();
//      "<p>(But then, after a few minutes, 
//          you start to wonder how you can leave this place.
//          You get up and try walking down the beach, 
//          but you don<./s>t seem to get anywhere. 
//          Suddenly it strikes you 
//          that you may never be able to get out of here 
//          until you accomplish what seems to be your
//          mission: to play the aliens<./s> maze game.) ";
//      victoryKey();
//      "<p>(You sigh heavily, then sit down
//          and pick up the tablet device.
//          You fully expect the game to be annoying
//          and tedious, but at least you<./s>re guessing
//          it won<./s>t be life-threatening to you,
//          not as you sit here in this beach chair.) ";
//      victoryKey();
//      "<p>(You begin to play.) ";
//    }
//    
//    // Possible butterfly species:
//    // "Red-spotted purple": Limenitis arthemis: From New England to northern Mexico
//    // "swallowtail": Papilio cresphontes / P. thoas: Mexico
//    
//    // Grains of yellow fall from nowhere and spread out 
//    // until they form a sandy beach. Blues appear 
//    // in ragged streaks above, and then they melt together 
//    // to become an azure sky. An ocean appears, 
//    // then an outdoor bar. You look down and discover 
//    // you're wearing swimming trunks and lounging 
//    // on a beach chair. A cheerful bartender pops 
//    // into existence. He puts a drink on the bar and looks 
//    // at you expectantly.
//    // 
//    // Beach, on the beach chair
//    //    The sun hangs directly overhead, tickling you 
//    // with its warm, refreshing heat, and brightening 
//    // the deep azure sky. You are relaxing on a beach chair, 
//    // looking out to the calm ocean. Nearby, you see 
//    // a seaside bar and behind it, a cheerful bartender 
//    // smiles at you.
//    //    The bartender is holding a cloth.
//    //    On the beach bar you see a frosted glass.
//    
//    //"That<./s>s the end . . . FOR NOW! ";
//    nbmPause();
//    
//    nbmCls();
//    
//    //glob.status = blank;
//    //statusLine.showStatusLineDaemon();
//    csDispImg('theend.png');
//    playSound('<sound src=\"sound/fanfare1.mp3\" layer=foreground>');
//    
//    cutSceneBanner.clearWindow();
//    csDispImg('fornow.png');
//    playSound('<sound src=\"sound/fanfare2.mp3\" layer=foreground>');
//    nbmPause();
//    
//    cutSceneBanner.removeBanner();
//    
//    glob.font = verdana;
//    "<.nbmfont>";
//    "What will the game be like? ";
//    "<p>Will it really consist of nothing but mazes? ";
//    //"<p>If there are mazes, what will they be like? ";
//    "<p>Is it possible you might actually enjoy the game? ";
//    "<p>Find out in the next version of <i>Nothing
//        but Mazes!</i> ";
//    
//    endGame(ftIntro);
//    
//  }
//  
//}

// -------------------------------------------------------------------
// CELL BANNER PICTURE
// -------------------------------------------------------------------

//cellPicPrint() {
//  if (cell.showTerminalPic && foodCube.location == foodBin)
//    return '<img src="misc/termfood2.jpg">';
//  else if (cell.showKillYouPic)
//    return '<img src="misc/killyou.jpg">';
//  else if (cell.showTerminalPic)
//    return '<img src="misc/terminal2.jpg">';
//  else
//    return '<img src="misc/prisoners2.jpg">';
//}

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

//hammer: Thing 'hammer' 'hammer' @cell
//  iobjFor(HitWith) {
//    verify { }
//  }
//  iobjFor(AttackWith) {
//    verify { }
//  }
//;

//fdLogin.optionShown

#endif // __DEBUG

