#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// THE COFFIN
// COFFIN ROOM PARTS
// COFFIN TRAVELMESSAGES, SOUNDS, ETC.
// COFFIN DAEMON
// CUT SCENES: The CutScene class
// CUT SCENES: Cut Scene 1
// THE FIRST TWO TURNS: NON-META VERB BLOCKER
// THE FIRST TWO TURNS: LIBRARY HACKS
// DEBUG STUFF

// -------------------------------------------------------------------
// THE COFFIN
// -------------------------------------------------------------------

//to do:
//pull coffin/push coffin
//sleep
//wake/wake up
//"blackness" or "black" as synonym for "darkness"
//sit -- don't say "stand"

enum lyingKnowledge, coffinKnowledge;

modify glob
  postureKnowledgeState = nil // Change when PC knows he's lying down.
;

coffin: Room
  roomName = libMessages.roomDarkName
  sitOrStand = 'sit'
  triedToStand = nil
  hitCount = 0
  desc = libMessages.roomDarkDesc
  hideFromAll(action) { return true; }
  hideFromDefault(action) { return true; }
  //nothingToHearMsg = 'You hear nothing but the sound of your own breathing. '
  //soundHereDesc() {
  //  "You hear nothing but the sound of your own breathing. ";
  //}
  lookAroundWithinName(actor, illum) {
    if (illum > 1) { "\^<<roomName>>"; }
    else { say(roomDarkName); }
    // We don't want the default "(lying on the floor)" message, 
    // so we do NOT call actor.actorRoomNameStatus(self);
    // Instead, we produce my own hacked posture state messages.
    switch (glob.postureKnowledgeState) {
      case nil:
        break;
      case lyingKnowledge:
        " (lying down)";
        break;
      case coffinKnowledge:
        " (lying in a narrow container)";
        break;
    }
  }
  roomBeforeAction() {
    if(gActionIs(SitOn) || gActionIs(Sit))
      sitOrStand = 'sit';
    else // Note that the following eventuality would apply not only
         // to "stand", but also to "get up" or "up" or most any other
         // verb.
      sitOrStand = 'stand';
    //if(gAction && gAction.getOrigTokenList[1][1].toLower() == 'sit')
    //  sitOrStand = 'sit';
    //else // Note that the following eventuality would apply not only
    //     // to "stand", but also to "get up" or "up" or most any other
    //     // verb.
    //  sitOrStand = 'stand';
    if(gActionIs(Stand) || gActionIs(StandOn) 
       || gActionIs(SitOn) || gActionIs(SitOn)) {
      //replaceAction(TravelVia, coffin.up);
      cantStand.travelDesc();
      exit;
    }
    if(gActionIs(SmellImplicit)) {
      coffinThing.smellDesc;
      exit;
    }
  }
  roomAfterAction() {
    if (gActionIs(Yell)) {
      if (glob.postureKnowledgeState == coffinKnowledge) {
        "Your cry reverberates loudly in the small chamber. ";
      }
      else {
        "<p>Suddenly your mind reels. Something is wrong.
            Your scream has reverberated around you, as though
            you were lying in a small chamber. ";
        //if (glob.postureKnowledgeState != lyingKnowledge)
        //  "That<./s>s when you realize you<./s>re lying down. ";
        "You reach up, and your hands hit an extremely shallow
          ceiling. Then you touch walls on either
          side of you. At last your feet hit against a wall, and so does your head.
          You are lying down within a container not much bigger than your
          body, something like a coffin. ";
        glob.postureKnowledgeState = coffinKnowledge;
      }
    } // YellAction
  }
  roomParts = [coffinCeiling, coffinWalls, coffinFloor]
  north     = cantLeaveCoffin
  south     asExit(north)
  east      asExit(north)
  west      asExit(north)
  northwest asExit(north)
  northeast asExit(north)
  southwest asExit(north)
  southeast asExit(north)
  up        = cantStand
  down      : NoTravelMessage { "<<playerActionMessages.cannotGoThatWayMsg>>"; }
  //down      = playerActionMessages.cannotGoThatWayMsg
  out       = cantGoOut
  //in        : NoTravelMessage { "You're already as enclosed as you're ever going to get. " }
  //down : NoTravelMessage { "It's too dark; you can't see where you're going. " }
;

theDarkness: Vaporous 'dark/darkness' 'darkness'
  @coffin
  "<<libMessages.roomDarkDesc>>"
  //whatDesc = "Darkness, noun.  An absence of light to see by. "
  isQualifiedName = true
  //feelDesc = "Darkness doesn't have a texture. "
  //smellDesc = "Darkness doesn't have an odor. "
  //tasteDesc = "Darkness doesn't have a taste. "
  //dobjFor(ListenTo)
  //  { verify() { illogical('Darkness doesn<./s>t make any sound. '); } }
;

// -------------------------------------------------------------------
// COFFIN ROOM PARTS
// -------------------------------------------------------------------

class CoffinEntity: object // a mix-in class
  location = coffin
  desc() {
    if (glob.postureKnowledgeState == nil 
        || glob.postureKnowledgeState == lyingKnowledge) {
      "In the darkness you reach out and touch the <<nameStr>>.
        <<capitalize(itOrThey)>> <<isOrAre>> made of cold metal. \b";
      if (glob.postureKnowledgeState == nil) {
        "Suddenly your mind spins. Something is wrong. The <<nameStr>>,
          within easy reach, make<<isOrAre == 'is' ? 's' : ''>> 
          you realize&mdash;yes, that<./s>s it. You<./s>re lying down. \b";
      }
      else { // glob.postureKnowledgeState == lyingKnowledge
        "Suddenly your mind spins. Something is wrong. The <<nameStr>> 
          <<isOrAre>>
          within arm's reach, even though you<./s>re lying down. \b";
      }
      "Frantically you move your hands and feet, and you become alarmed. 
        Not only are there 
        walls closely surrounding you on all sides, but you are lying 
        beneath an extremely shallow ceiling.
        You are in a container not much bigger than your
        body, something like a coffin. ";
      glob.postureKnowledgeState = coffinKnowledge;
      coffin.triedToStand = true;
    }
    else { // glob.postureKnowledgeState == coffinKnowledge
      "You run your hands over the <<nameStr>>. 
        <<capitalize(itOrThey)>> <<isOrAre>> made of cold metal.
        Unfortunately, as far as you can tell, the <<nameStr>> 
        <<isOrAre>> entirely featureless. There aren<./s>t even any 
        rivets or bolts, just smooth metal. ";
    }
  }
  nameStr = name
  itOrThem = 'it'
  itOrThey = 'it'
  isOrAre = 'is'
  capitalize(x) {
    return x.substr(1,1).toUpper() + x.substr(2);
  }
  preternatural(x) {
    "This is odd. You somehow have a preternatural knowledge
      that you are in a container of some sort. You feel all around
      you, and sure enough, there are walls closely surrounding you,
      with an extremely shallow ceiling above. You are enclosed in
      something resembling a coffin. \b";
    if (x) "<<x>>";
    glob.postureKnowledgeState = coffinKnowledge;
  }
  dobjFor(Feel) asDobjFor(Examine)
  dobjFor(Break) asDobjFor(Hit)
  dobjFor(Attack) asDobjFor(Hit)
  dobjFor(Hit) {
    action() {
      if (coffin.hitCount == 0) {
        if (glob.postureKnowledgeState != coffinKnowledge)
          preternatural('So you want to hit it, do you? Well, you<./s>re ');
        else
          "You<./s>re ";
          //"This is odd. You somehow have a preternatural knowledge 
          //  that you are in a container of some sort. You feel
          //  all around you, and sure enough, there are walls 
          //  closely surrounding you on all sides, and you are lying 
          //  beneath an extremely shallow ceiling.
          //  You are in a container not much bigger than your
          //  body, something like a coffin. ";
        "feeling extremely weak. Nevertheless, you summon
          all your energy and deliver a solid blow to ";
        if (name == 'walls')
          "one of the walls";
        else
          "the <<name>>";
        ". \b
          Ouch! Well, you may have hurt your ";
        if (gAction.getOrigTokenList[1][1].toLower() == 'kick')
          "foot";
        else
          "hand";
        ", but you<./s>ve done absolutely no damage to the ";
        if (name == 'walls')
          "wall";
        else
          "<<name>>";
        ". ";
        coffin.hitCount = 1;
      }
      else
        "You<./s>re in no mood to hurt yourself again, since you
          know it will only be futile. ";
      //glob.postureKnowledgeState = coffinKnowledge;
    }
  }
  //dobjFor(Clean)
  //dobjFor(Open)
  //dobjFor(Close)
  //dobjFor(GetOffOf)
  //dobjFor(GetOutOf)
  dobjFor(Push) {
    verify() { }
    check() {
      if (glob.postureKnowledgeState != coffinKnowledge)
        preternatural('So you want to push the '+name+'? 
          Well, pushing ');
      else 
        "Pushing ";
      "<<itOrThem>> doesn<./s>t do any good. ";
      exit;
    }
  }
  dobjFor(Pull) {
    verify() { }
    check() {
      if (glob.postureKnowledgeState != coffinKnowledge)
        preternatural('So you want to pull the '+name+'? 
          Well, pulling ');
      else 
        "Pulling ";
      "<<itOrThem>> doesn't do any good. ";
      exit;
    }
  }
  //dobjFor(Move)
  //dobjFor(Turn)
  //dobjFor(Take)
;

coffinThing: CoffinEntity, Fixture
  vocabWords = 'cold metal narrow small little
    cryogenic cryogenics cryonic cryonics 
    coffin/container/casket/capsule/chamber/room/cell/tube/cryotube'
  name = 'container'
  //desc = "<<playerActionMessages.tooDarkMsg>>"
  whatDesc = "It<./s>s the thing you<./s>re trapped inside of right now. "
  smellDesc = "This place smells odd, like a hospital. "
  dobjFor(Enter) {
    verify() { }
    check() {
      if (glob.postureKnowledgeState != coffinKnowledge)
        preternatural('So you want to enter the coffin? 
          Well, you<./s>re already inside of it. ');
      else 
        "You<./s>re already inside of the container. ";
      exit;
    }
  }
  dobjFor(GetOutOf) {
    verify() { }
    check() {
      if (glob.postureKnowledgeState != coffinKnowledge)
        preternatural('So you want to get out of the coffin? 
          Well, that ');
      else 
        "That ";
      "would be a great idea, if you could figure out how. ";
      exit;
    }
  }
  dobjFor(Open) {
    verify() { }
    check() {
      if (glob.postureKnowledgeState != coffinKnowledge)
        preternatural('So you want to open the coffin? 
          Well, you ');
      else 
        "You ";
      "struggle and push against the walls and ceiling, but you
        can<./s>t seem to find any way to open up the container. ";
      exit;
    }
  }
  dobjFor(Close) {
    verify() { }
    check() {
      if (glob.postureKnowledgeState != coffinKnowledge)
        preternatural('So you want to close the coffin? 
          Well, it<./s>s ');
      else 
        "It<./s>s ";
      "already as closed as it<./s>s ever going to get. ";
      exit;
    }
  }
;

coffinCeiling: CoffinEntity, RoomPart
  vocabWords = '(cold) (metal) ceiling/roof/lid/top/cover'
  name = 'ceiling'
  whatDesc = "It<./s>s what<./s>s above you right now. "
  dobjFor(Push) asDobjFor(Open)
  dobjFor(Open) {
    verify() { }
    check() {
      if (glob.postureKnowledgeState != coffinKnowledge)
        preternatural('So you want to open the coffin? 
          Well, you ');
      else 
        "You ";
      "struggle and push against the walls and ceiling, but you
        can<./s>t seem to find any way to open up the container. ";
      exit;
    }
  }
  dobjFor(Close) {
    verify() { }
    check() {
      if (glob.postureKnowledgeState != coffinKnowledge)
        preternatural('So you want to close the coffin? 
          Well, it<./s>s ');
      else 
        "It<./s>s ";
      "already as closed as it<./s>s ever going to get. ";
      exit;
    }
  }
;

coffinFloor: CoffinEntity, Floor
  whatDesc = "It<./s>s what<./s>s beneath you right now. "
  vocabWords = '(cold) (metal) floor/ground'
  name = 'floor'
;

coffinWalls: CoffinEntity, RoomPart
  vocabWords = '(cold) (metal) wall*walls'
  name = 'walls'
  isPlural = true
  nameStr  = 'walls'
  itOrThey = 'they'
  itOrThem = 'them'
  isOrAre  = 'are'
  whatDesc = "It<./s>s what<./s>s surrounding you right now. "
  dobjFor(Push) asDobjFor(Open)
  dobjFor(Open) {
    verify() { }
    check() {
      if (glob.postureKnowledgeState != coffinKnowledge)
        preternatural('So you want to open the coffin? 
          Well, you ');
      else 
        "You ";
      "struggle and push against the walls and ceiling, but you
        can<./s>t seem to find any way to open up the container. ";
      exit;
    }
  }
  dobjFor(Close) {
    verify() { }
    check() {
      if (glob.postureKnowledgeState != coffinKnowledge)
        preternatural('So you want to close the coffin? 
          Well, it<./s>s ');
      else 
        "It<./s>s ";
      "already as closed as it<./s>s ever going to get. ";
      exit;
    }
  }
  //setStrings() {
  //  coffinThing.nameStr = 'walls';
  //  coffinThing.itOrThey = 'they';
  //  coffinThing.itOrThem = 'them';
  //  coffinThing.isOrAre = 'are';
  //}
;

/*
class CoffinPart : RoomPart
  dobjFor(Feel) remapTo(Examine, self)
  desc()
  {
    if (myDarkRoom.triedToStand==nil && myDarkRoom.knowCoffin==nil)
    {
      "In the darkness you reach out and touch the <<str>>.
        It is made of cold metal.\b
       Suddenly your mind spins. Something is wrong. The <<str>>,
        within arm's reach, makes you realize&mdash;yes, that<./s>s it. You<./s>re
        lying down.\b
       Frantically you move your hands and feet to find walls surrounding
        you on all sides, with a ceiling much of you on all sides

       that you
        are lying down within a container not much bigger than your
        body, something like a coffin. ";
      myDarkRoom.triedToStand = true;
      myDarkRoom.knowCoffin = true;
    }
    else if (myDarkRoom.triedToStand==nil && myDarkRoom.knowCoffin==true) {
      "In the darkness you reach out and touch the walls and ceiling,
        which are made of cold metal. It is as you feared.
        There are walls around you on all sides and a shallow ceiling
        above your head. You are lying down within a container not much bigger
        than your body, something like a coffin. ";
      myDarkRoom.triedToStand = true;
    }
    else
      "You run your hands over the <<str>>. It is made of cold metal,
        and is completely featureless, as far as you can detect. ";
  }
;

darkNorthWall : DarkRoomPart, DefaultWall 'n north cold metal wall*walls' 'north wall' str='wall';
darkSouthWall : DarkRoomPart, DefaultWall 's south cold metal wall*walls' 'south wall' str='wall';
darkEastWall  : DarkRoomPart, DefaultWall 'e east cold metal wall*walls'  'east wall'  str='wall';
darkWestWall  : DarkRoomPart, DefaultWall 'w west cold metal wall*walls'  'west wall'  str='wall';
darkCeiling   : DarkRoomPart 'cold metal ceiling' 'ceiling' str='ceiling';
darkFloor     : DarkRoomPart, Floor 'soft strange cushiony material/cushion/floor/surface' 'floor'
  "You run your hands over the floor. It is made of a cushiony material,
    but aside from that you find nothing unusual.  ";
*/

// -------------------------------------------------------------------
// COFFIN TRAVELMESSAGES, SOUNDS, ETC.
// -------------------------------------------------------------------

cantLeaveCoffin: NoTravelMessage
  travelDesc() {
    switch (glob.postureKnowledgeState) {
      case nil:
        "No, no. You can<./s>t move at all. In fact&mdash;yes, that<./s>s
          what the problem is. You<./s>re lying down.";
        glob.postureKnowledgeState = lyingKnowledge;
        break;
      case lyingKnowledge:
        "You<./s>re not going anywhere until you stand up. ";
        break;
      case coffinKnowledge:
        "You<./s>re not going anywhere until you get out of this 
          container. ";
        break;
    }
  }
;

cantGoOut: NoTravelMessage
  travelDesc() {
    switch (glob.postureKnowledgeState) {
      case nil:
        "No, no. You can<./s>t move at all. In fact&mdash;yes, that<./s>s
          what the problem is. You<./s>re lying down.";
        glob.postureKnowledgeState = lyingKnowledge;
        break;
      case lyingKnowledge:
        "You<./s>re not going anywhere until you stand up. ";
        break;
      case coffinKnowledge:
        "Getting out of here would be a great idea, 
          if you could figure out how. ";
        break;
    }
  }
;

cantStand: NoTravelMessage
  travelDesc() {
    switch (glob.postureKnowledgeState) {
      case nil: 
        "Yes, that<./s>s it. You<./s>re lying down. \b"; 
        //"You are so tired that it almost
        //  hurts to move. Nevertheless, you try. \b";
      case lyingKnowledge:
        "You are so tired that it almost hurts to move. Nevertheless,
          you try to <<coffin.sitOrStand>> up. \b";
        "But then, as you shift your body, your elbows hit something: walls.
          Then you raise your arms, and they hit an extremely shallow ceiling.
          At last your feet touch a wall, and so does your head.
          You are lying down within a container not much bigger than your
          body, something like a coffin. ";
          glob.postureKnowledgeState = coffinKnowledge;
          coffin.triedToStand = true;
        break;
      case coffinKnowledge:
        if (coffin.triedToStand) {
          "There<./s>s no way you<./s>ll be able to <<coffin.sitOrStand>> 
            up until you get out of this container. ";
        }
        else {
          "You move your arms around uncertainly, and it is as you feared.
            Metal walls flank both your elbows, your head, and your feet,
            with an extremely shallow ceiling right above your head.
            You are enclosed within a container not much bigger
            than your body, something like a coffin. ";
        }
        glob.postureKnowledgeState = coffinKnowledge;
        coffin.triedToStand = true;
        break;
    }
  }
;

breathingNoise: SimpleNoise '(your) (my) breathing' 'your breathing'
  location = coffin
  isQualifiedName = true
  desc {
    if (coffinDaemon.realCounter < 6)
      "The only sound you hear is the sound of your own breathing. ";
    //else if (coffinDaemon.realCounter == 6)
    //  "You listen, and you think you start to hear a sound. ";
    else
      "You can<./s>t help but listen attentively to the footsteps outside
        the container. ";
  }
  isAmbient = true
  sourceDesc = hereWithSource
  hereWithSource = "The only sound you hear is the sound of your own breathing. "
;

CoffinSoundEvent: SoundEvent
  message = "OVERRIDE. "
  triggerEvent(source) {
    say(message);
    inherited(source);
  }
;

coffinSoundEvent1: CoffinSoundEvent
  message = (glob.coffinMsg1)
;
coffinSoundEvent2: CoffinSoundEvent
  message = (glob.coffinMsg2)
;
coffinSoundEvent3: CoffinSoundEvent
  message = (glob.coffinMsg3)
;

modify glob
  //coffinMsg1 = "Perhaps it is your imagination, but you think you hear
  //  a sound from somewhere outside the container. Could it be footsteps
  //  approaching? "
  //coffinMsg2 = "You hear the sound of a door open somewhere nearby. The 
  //  footsteps, clearly discernible now, come closer. Your heart beats
  //  hard. "
  //coffinMsg3 = "The footsteps continue, and approach until they are right
  //  outside your container. You hear the sound of shuffling outside. \b
  //  You feel a chill. You cannot imagine what will happen next. "
  //coffinMsg4 = "And then the top of the container opens up. Light floods in.
  //  You are nearly blinded. "
  coffinMsg1 = "Suddenly you hear footsteps approaching. They 
    keep getting closer until they are right outside your chamber. 
    You feel a chill, uncertain of what will happen next. "
  coffinMsg2 = ""
  coffinMsg3 = ""
  coffinMsg4 = "And then your chamber opens up. 
    Light floods in. You are nearly blinded. "
;

//coffinSoundEvent4: CoffinSoundEvent
//  message {
//    firstCutScene();
//  }
//;

//modify libMessages
//  nothingToHearMsg { 
//    if (gPlayerChar.location == coffin)
//      return 'You hear nothing but the sound of your own breathing. ';
//    else
//      return inherited();
//  }
//;

// -------------------------------------------------------------------
// COFFIN DAEMON
// -------------------------------------------------------------------

class DaemonComponent: Component
  hideFromAll(action) { return true; }
  hideFromDefault(action) { return true; }
;

coffinDaemon: DaemonComponent
  //name = 'coffin daemon'
  location = coffin
  reallyStarted = nil
  counter = 0
  realCounter = 0
  daemonID = nil
  startDaemon {
    if (daemonID == nil) {
      moveInto(gPlayerChar);
      daemonID = new Daemon(self, &daemon, 1);
    }
    // Otherwise, if the daemon is already running, let it continue.
  }
  daemon {
    if (gPlayerChar.location != coffin) {
      endDaemon();
      return;
    }
    counter++;
    if (glob.postureKnowledgeState == coffinKnowledge
        || counter == 3) {
      reallyStarted = true;
    }
    if (reallyStarted) realCounter++;
    //"<.p>coffinDaemon.realCounter = <<realCounter>><.p>";
    switch (realCounter) {
      case 0:
        break;
      //case 3:
      //  breathingNoise.moveInto(nil);
      //  break;
      case 6:
        coffinSoundEvent1.triggerEvent(coffin);
        break;
      //case 5:
      //  coffinSoundEvent2.triggerEvent(coffin);
      //  break;
      //case 6: 
      //  coffinSoundEvent3.triggerEvent(coffin);
      //  break;
      case 7: 
        //coffinSoundEvent4.triggerEvent(coffin);
        //local k=0; k=k/k;
        cutScene1.execute;
        break;
    }
    
  }    
  endDaemon {
    if (daemonID != nil) daemonID.removeEvent;
    daemonID = nil;
    moveInto(nil);
  }
;

modify glob
  
;

// -------------------------------------------------------------------
// CUT SCENES: The CutScene class
// -------------------------------------------------------------------

// This is quite a challenge.
// 
// The goal:
// 
// -- After it says "You are nearly blinded," go to a long cut scene 
//    that is like a slide show. For each slide, a picture is shown, 
//    a caption is shown underneath it, and there is a pause where 
//    the user can press a key; then the process is repeated.
// -- At one point during this slide show, one of the slides plays 
//    music. The music doesn't last long, but it should continue 
//    even when the screen is cleared for the next slide. It should 
//    even continue after the slide show is done, if it has not 
//    finished by that time.
// -- The text presented in the slide show should successfully go to 
//    the game transcript.
// 
// The solution:
// 
// Create a class CutScene, as follows.

class CutScene: object
  // Is transcript file output to be attempted?
  // Presently only attempt this under Windows, because of reported 
  // incongruities between HyperTADS and the Windows 'terp.
  doTfo = (systemInfo(SysInfoOsName).substr(1,3).toUpper == 'WIN')
  // If transcript file output (TFO) is to be attempted, should 
  // this be done by means of simply outputting text to the main window?
  // Presently, yes, do it this way. There seems to be no other way.
  tfoViaMainWindow = true
  // A hook for anything that happens before the cut scene
  beginScene() { }
  // A hook for anything that happens after the cut scene (and there
  // is always something).
  endScene() { }
  // A hook for an ad-hoc mid-scene method.
  midScene() { }
  // Do we prefer to make the banner window disappear by reducing
  // its width to zero, as opposed to simply removing it?
  banishBannerViaZeroWidth = nil
  // Do we prefer to update the status line when we're done with 
  // our cut-scene? Nearly always, the answer will be yes.
  updateStatusLineAfterwards = true
  // To override the default behavior of executing endScene():
  skipEndScene = nil
  // The main method.
  execute {
    // ----------------
    // Do initial stuff
    
    // First do initial output, etc. before the cut scene begins.
    beginScene();
    // Then pause for input.
    nbmPause();
    // For the sake of any transcript file, ensure a proper paragraph 
    // break between the last outputted text and whatever comes next.
    "<.p>";
    // Make sure the status line is blank during the cut scene.
    glob.status = blank;
    statusLine.showStatusLineDaemon();
    // If the banner is present, then either remove it or reduce its
    // width to zero, depending on preference.
    if (!banishBannerViaZeroWidth)
      nbmBanner.removeBanner();
    else
      nbmBanner.setSize(
        0, // zero size
        BannerSizeAbsolute, // or BannerSizePercent
        nil); // isAdvisory == nil
    // It so happens that with all three cut scenes, I want a cleared
    // screen afterwards. Might as well do that now.
    nbmCls();
    
    // ----------------
    // Attempt transcript file output, if desired
    
    // Do the "transcript file output via main window" scenario
    if (doTfo && tfoViaMainWindow) {
      // Cover the whole screen with a blank, 100%-size banner.
      csShout('');
      // Loop through the list. Output the text to the main window,
      // thereby ensuring the text goes to the transcript.
      for (local a=1; a<=sceneList.length(); ++a) {
        "<<sceneList[a][1]>><.p>";
      }
      // Then clear the main window again, since the text just 
      // outputted is never supposed to be visible in that window.
      nbmCls();
    }
    
    // ----------------
    // Do standard on-screen output
    
    // Loop through the scene list.
    for (local a=1; a<=sceneList.length(); ++a) {
      // If this isn't the first iteration, clear the cut scene banner.
      if (a != 1)
        cutSceneBanner.clearWindow();
      
      // If the image elements (the third and fourth elements, with this 
      // implementation) aren't nil, display it as an image in the 
      // banner window.
      if (glob.imageSize == 1 && sceneList[a].length() >= 3 && sceneList[a][3]) { // GREGTODO
        csDispImg(sceneList[a][3], ''); // 'height=\"100\" width=\"900\"'
      }
      else if (glob.imageSize == 2 && sceneList[a].length() >= 4 && sceneList[a][4]) { // GREGTODO
        csDispImg(sceneList[a][4], ''); // 'height=\"100\" width=\"900\"'
      }
      
      // If there is text to output to the banner, output it.
      if (sceneList[a][1]) {
        csShout(sceneList[a][1]);
      }
      
      // If the second value is non-nil, it might be either
      // (1) a single-quoted string (in which case it represents
      // music to be sent to the main window), or
      // (2) a function pointer (in which case the function should 
      // be executed) (this functionality isn't working, though),
      // (3) the value "true," in which case the midScene()
      // method should be called.
      if (sceneList[a][2]) {
        if (dataType(sceneList[a][2]) == TypeSString) {
          playSound(sceneList[a][2]);
        }
        if (dataType(sceneList[a][2]) == TypeTrue) {
          midScene();
        }
        if (dataType(sceneList[a][2]) == TypeFuncPtr) {
          (sceneList[a][2])();
        }
      }
      nbmPause();
    }
    
    // ----------------
    // Do concluding stuff
    
    // Remove the cut scene banner
    cutSceneBanner.removeBanner;
    // Unless we are in "don't show right-hand banner" mode,
    // return the status line to its usual state.
    if (!glob.dontUpdateBanner && updateStatusLineAfterwards) {
      if (gPlayerChar == bot)
        glob.status = zork;
      else
        glob.status = trinity;
      statusLine.showStatusLineDaemon();
    }
    // Unless we are in "don't show right-hand banner" mode,
    // try to show the right-hand banner.
    if (!glob.dontUpdateBanner)
      nbmBanner.updateMe;
    // Do concluding output after the cut scene is done.
    if (!skipEndScene) {
      endScene();
    }
  }
;

cutSceneBanner: BannerWindow
  updateMe(whatToSay) {
    if (showBanner(nil,      // parent = nil; i.e. the main window.
          BannerLast,        // where = BannerLast: the main window's last priority.
          nil,               // other = irrelevant
          BannerTypeText,    // windowType = BannerTypeText: a regular window
          BannerAlignBottom, // align = BannerAlignRight
          100,               // size = 35 times wider than a "0"
          BannerSizePercent, // sizeUnits = BannerSizeAbsolute: units as wide as a "0"
          (hasVerticalScroll 
            ? BannerStyleVScroll | BannerStyleTabAlign 
            : BannerStyleTabAlign)
          ))
    {
      //clearWindow();
      if (glob.changeFont)   writeToBanner('<.nbmfont>');
      if (glob.changeColors) writeToBanner('<.nbmcolors>');
      writeToBanner(whatToSay);
    }
  }
  hasVerticalScroll = nil
;

// -------------------------------------------------------------------
// CUT SCENES: Cut Scene 1
// -------------------------------------------------------------------

// CURRENT VERSION of Cut Scene 1
// 
// The following is a brand new reworking as of Aug 2006, based on the
// new CutScene class.

cutScene1: CutScene
  beginScene {
    say(glob.coffinMsg4);
  }
  endScene {
    goToConfRoom.execute;
    nestedAction(Look);
    cancelPendingCommands();
  }
  sceneList = [
    [ 'Then, suddenly, when the light hits your eyes, you 
          remember! You know where you are. You know why you 
          are here.
        <p>Years back, in the late 2010s, you heard about a new 
          advance in cryogenics. Using new techniques, 
          scientists could now freeze the human body with far 
          less damage to brain cells than before.
        <p>The idea intrigued you. A few weeks later, you 
          signed up. $100,000 for a chance at immortality? 
          Why not? Even if it was a long shot. ',
      nil,
      nil,
      nil ],
    [ 'Then, years later, you were seized by a pain in the 
          chest. Somehow a coworker rushed you to the 
          hospital. You don<./s>t remember anything after that.
        <p>And now, waking up here . . . blinded 
          by this light . . . you cannot quite 
          bring yourself to grasp what is happening.
        <p>And then your eyes adjust, and you cannot believe 
          what you see. ',
      nil,
      nil,
      nil ],
    [ 'Before you stands a creature that is not human. His 
          skin is green, like that of a lizard or a fish. But 
          he is dressed in clothing, and his eyes peer at you 
          with intensity. ',
      '<sound src=\"sound/alien.mp3\" layer=foreground>',
      'illustrations/firstalien_0300.jpg',
      'illustrations/firstalien_0469.jpg'
    ],
    [ 'With unusual strength, the creature lifts you 
          and carries you onto something resembling a hospital 
          stretcher. He then wheels you out of the room 
          and down the hallway. ',
      nil,
      'illustrations/firstalien_0300.jpg',
      'illustrations/firstalien_0469.jpg' ],
    [ 'Over the next few days, they feed you 
          food that is delicious, but quite unlike 
          anything you<./s>ve seen before. You dine on fish 
          pudding and strawberry yams. ',
      nil,
      'illustrations/hospital0300.jpg',
      'illustrations/hospital0469.jpg' ],
    [ 'You spend days undergoing physical rehabilitation with the 
          help of the creatures, who, you decide, can only be aliens. 
          Within a week, you are able to walk again. ',
      nil,
      'illustrations/hospital0300.jpg',
      'illustrations/hospital0469.jpg' ],
    [ 'One day, new aliens in black uniforms arrive. 
          They escort you onto the roof and into a waiting 
          aircar. The craft lifts off the roof with remarkable 
          agility. It rises to a hover, then 
          suddenly rockets forward through the sky. ',
      nil,
      'illustrations/aircar0300.jpg',
      'illustrations/aircar0469.jpg' ],
    [ 'After a flight of several hours, the aircar descends 
          toward a huge installation of buildings made of black 
          concrete and green glass. The aircar lands, 
          and you are led inside. ',
      nil,
      'illustrations/aircar0300.jpg',
      'illustrations/aircar0469.jpg' ],
    [ 'Inside, a new alien directs you to lie down on a strange 
          metal couch, beneath a dentist<./s>s-style 
          articulated metal arm. The arm is attached to your head, 
          and then things get blurry. ',
      nil,
      'illustrations/couch0300.jpg',
      'illustrations/couch0469.jpg' ],
    [ 'It feels as if information is being 
          sucked out of your brain. Time passes. Then a painful 
          stream of knowledge suddenly comes screaming into 
          your mind. You lose track of time as this cycle is 
          repeated over and over. ',
      nil,
      'illustrations/couch0300.jpg',
      'illustrations/couch0469.jpg' ],
    [ 'Finally the cycle stops. The alien speaks to you, and 
          you are amazed to find that you understand him. 
          He says, <.q>You may feel a bit disoriented, but this 
          will soon pass. Please follow me.<./q> With that he 
          steps out into the hallway. You stumble after him, 
          while two uniformed aliens follow close behind. ',
      nil,
      'illustrations/hallway1_0300.jpg',
      'illustrations/hallway1_0469.jpg' ],
    [ 'Following the alien, you sputter a series of 
          questions: <.q>Where am I?<./q> <.q>Who are you?<./q> 
          <.q>Why have I been brought here?<./q> After you realize 
          that you<./s>re speaking in English, you make a 
          tremendous effort, summon an ability you didn<./s>t 
          know you had, and ask in the aliens<./s> native 
          tongue, <.q>Where am I?<./q> ',
      nil,
      'illustrations/hallway1_0300.jpg',
      'illustrations/hallway1_0469.jpg' ],
    [ 'Your guide glances back 
          at you and replies, <.q>You will be told everything 
          in just a few moments. Please follow me. I am only 
          an assistant.<./q> ',
      nil,
      'illustrations/hallway1_0300.jpg',
      'illustrations/hallway1_0469.jpg' ],
    [ 'The alien leads you to a room with a large table 
          surrounded by chairs. He directs you to sit down, 
          then says, <.q>Your overseers will be here shortly. 
          Please sit and wait.<./q> With that, he leaves. 
          The two uniformed aliens then take their places 
          on either side of the door. ',
      nil,
      'illustrations/confroom_0300.jpg',
      'illustrations/confroom_0469.jpg' ]
  ]
;

csShout(x) {
  cutSceneBanner.updateMe(x);
}

csDispImg(filename, [args]) {
  local extraText = '';
  if (args && args.length > 0) {
    extraText = args[1];
  }
  csShout('<tab align=center><img src=\"' + filename + '\" ' + extraText + ' border=0><.p>');
}

/*
    [ nil,
      'Then, suddenly, when the light hits your eyes, you 
          remember! You know where you are. You know why you 
          are here.',
      nil ],
    [ nil,
      'Years back, in the late 2010s, you heard about a new 
          advance in cryogenics. Using new techniques, 
          scientists could now freeze the human body with far 
          less damage to brain cells than ever before.',
      nil ],
    [ nil,
      'The idea intrigued you. A few weeks later, you 
          signed up. $100,000 for a chance at immortality? 
          Why not? Even if it was a long shot. ',
      nil ],
    [ nil,
      'Then, years later, you were seized by a pain in the 
          chest. With difficulty you stumbled to a coworker<./s>s 
          desk. He helped you to his car and rushed you to the 
          hospital. You don<./s>t remember anything after that.',
      nil ],
    [ nil,
      'And now, waking up here . . . blinded 
          by this light . . . you cannot quite 
          bring yourself to grasp what is happening.',
      nil ],
    [ nil,
      'And then your eyes adjust, and you cannot believe 
          what you see. ',
      nil ],
*/

// PREVIOUS VERSION of Cut Scene 1
// 
// This is the old, crude version of Cut Scene 1, not based on the
// CutScene class. It was adequate for the IntroComp version of the 
// game, but I decided to do things differently after I realized 
// I would have tointroduce another level of complexity to prevent 
// bugs that were reported by people playing the game with HyperTADS.

//modify glob
//  cs1List = [
//    [ nil,
//      'Then, suddenly, when the light hits your eyes, you 
//          remember! You know where you are. You know why you 
//          are here.
//        <p>Years back, in the late 2010s, you heard about a new 
//          advance in cryogenics. Using new techniques, 
//          scientists could now freeze the human body with far 
//          less damage to brain cells than ever before.
//        <p>The idea intrigued you. A few weeks later, you 
//          signed up. $100,000 for a chance at immortality? 
//          Why not? Even if it was a long shot. ',
//      nil ],
//    [ nil,
//      'Then, years later, you were seized by a pain in the 
//          chest. With difficulty you stumbled to a coworker<./s>s 
//          desk. He helped you to his car and rushed you to the 
//          hospital. You don<./s>t remember anything after that.
//        <p>And now, waking up here . . . blinded 
//          by this light . . . you cannot quite 
//          bring yourself to grasp what is happening.
//        <p>And then your eyes adjust, and you cannot believe 
//          what you see. ',
//      nil ],
//    [ 'firstalien.jpg',
//      '',
//      '<sound src=\"sound/alien.mp3\" layer=foreground>' ],
//    [ 'firstalien.jpg',
//      'Before you stands a creature that is not human. His 
//          skin is green, like that of a lizard or a fish. But 
//          he is dressed in clothing, and his eyes peer at you 
//          with intensity. The creature is clearly intelligent, 
//          and he is clearly the one who has awoken you from 
//          your cryogenic sleep. ',
//      nil ],
//    //[ 'firstalien.jpg',
//    //  'You can only hope its intentions are good, because 
//    //      you are lying in a coffin beneath it, and you are 
//    //      far too weak to put up any resistance. ',
//    //  nil ],
//    [ 'firstalien.jpg',
//    //  'The creature extends its hands&mdash;which, you 
//    //      notice, are flipper-like and possess only two 
//    //      digits. Your heart beats hard as he puts his arms 
//    //      underneath you. With unusual strength he lifts you 
//    //      and carries you onto something resembling a hospital 
//    //      stretcher. With that, he wheels you out of the room 
//    //      and down the hallway. ',
//      'The creature extends his hands, which, you 
//          notice, are flipper-like and possess only two 
//          digits. With unusual strength he lifts you 
//          and carries you onto something resembling a hospital 
//          stretcher. With that, he wheels you out of the room 
//          and down the hallway. ',
//      nil ],
//    [ 'hospital.jpg',
//      'He takes you to a sterile room, where you meet with 
//          other creatures. They feed you 
//          food that is quite delicious, but also quite unlike 
//          anything you<./s>ve ever seen before. You dine on fish 
//          pudding and strawberry yams. ',
//      nil ],
//    [ 'hospital.jpg',
//      'You spend the next few days recuperating with the 
//          creatures, who, you decide, can only be aliens. 
//          They help you regain strength 
//          and rehabilitate yourself. Progress is slow at first, 
//          but within a week, you are able to walk again. ',
//      nil ],
//    //[ 'hospital.jpg',
//    //  'Your companions seem to have the best of intentions, 
//    //      but you are unable to communicate with them. When 
//    //      you try to speak to them, they regard you with 
//    //      amusement, and make no effort to understand. ',
//    //  nil ],
//    //[ 'hospital.jpg',
//    //  'You have no doubt that these are aliens from some 
//    //      distant star system. But you are not able to learn 
//    //      much more than that.',
//    //  nil ],
//    [ 'aircar.jpg',
//      'One day, some new aliens in black uniforms arrive. 
//          They escort you onto the roof and into a waiting 
//          aircar. The craft lifts off the roof with remarkable 
//          agility. It rises to a hover, then 
//          suddenly rockets forward through the sky. ',
//      nil ],
//    [ 'aircar.jpg',
//      //'At first you are exhilarated by the fast ride, but 
//      //    then you look out the window, and you are shocked. 
//      //    All signs of human habitation are virtually in 
//      //    ruins. Tall grass pokes through cracks in the 
//      //    streets. Windows are broken, and paint is peeling 
//      //    even on formerly well-tended buildings. You do not 
//      //    want to think about what this means. ',
//      'At first you are exhilarated by the fast ride, but 
//          then you look out the window, and you are shocked. 
//          All signs of human habitation are virtually in 
//          ruins. Windows are broken, and bricks have fallen
//          even from formerly well-tended buildings. You do not 
//          want to think about what this means. ',
//      nil ],
//    [ 'aircar.jpg',
//      'Before long you are up above the clouds. The ride goes
//          for an hour, then two hours, then longer. Wherever
//          you are going, it is very far away from where you 
//          were. ',
//      nil ],
//    [ 'aircar.jpg',
//      'At length the craft descends, and you see 
//          utterly alien structures down below, made 
//          of black concrete and green glass. The strange 
//          buildings become more and more frequent. Soon you 
//          see an installation on the far horizon, a broad 
//          collection of buildings, towers, and launch pads. ',
//      nil ],
//    [ 'couch.jpg',
//      'The aircar descends toward the installation, then 
//          lands near one of the smaller buildings. The aliens 
//          lead you into the building, and then to a quiet, 
//          sterile room. There a new alien greets you, and 
//          directs you to lie down on a strange metal couch, 
//          beneath a dentist<./s>s-style articulated metal arm. ',
//      nil ],
//    [ 'couch.jpg',
//      'The arm is attached to your head, and then things 
//          get blurry. It feels as if information is being 
//          sucked out of your brain. Time passes. Then a painful 
//          stream of knowledge suddenly comes screaming into 
//          your mind. You lose track of time as this cycle is 
//          repeated over and over. ',
//      nil ],
//    [ 'hallway1.jpg',
//      'Finally the cycle stops. The alien speaks to you, and 
//          you are amazed to find that you understand him. 
//          He says, <.q>You may feel a bit disoriented, but this 
//          will soon pass. Please follow me.<./q> With that he 
//          steps out into the hallway. You stumble after him, 
//          while the two uniformed aliens follow close behind. ',
//      nil ],
//    [ 'hallway1.jpg',
//      'Following the alien, you sputter a series of 
//          questions: <.q>Where am I?<./q> <.q>Who are you?<./q> 
//          <.q>Why have I been brought here?<./q> After you realize 
//          that you<./s>re speaking in English, you make a 
//          tremendous effort, summon an ability you didn<./s>t 
//          know you had, and ask in the aliens<./s> native 
//          tongue, <.q>Where am I?<./q> ',
//      nil ],
//    [ 'hallway1.jpg',
//      'Your guide glances back 
//          at you and replies, <.q>You will be told everything 
//          in just a few moments. Please follow me. I am only 
//          an assistant.<./q> ',
//      nil ],
//    [ 'confroom.jpg',
//      'The alien leads you to a room with a large table 
//          surrounded by chairs. He directs you to sit down, 
//          then says, <.q>Your mentors will be here shortly. 
//          Please sit and wait.<./q> With that, he leaves. 
//          The two uniformed aliens then take their places 
//          on either side of the door. You take a seat. ',
//      nil ]
//  ]
//;
//
//cutSceneOne() {
//  say(glob.coffinMsg4);
//  nbmPause();
//  glob.status = blank;
//  statusLine.showStatusLineDaemon();
//  //"<.p>";
//  //mainOutputStream.captureOutput( new function { return '<.p>'; } );
//  nbmCls();
//  // Put up the cutSceneBanner, to clear the screen with nothing
//  // but a big banner.
//  csShout('');
////  // Make sure the text actually goes to the main window. People won't
////  // see this on the screen right now, because of the 100%-size banner
////  // window. But we have to do this, or else it won't go to the 
////  // transcript when we put the text to the banner later.
////  for (local a=1; a<=glob.cs1List.length(); ++a) {
////    "<<glob.cs1List[a][2]>><.p>";
////  }
////  nbmCls();
//  
//  local k=0; k=k/k;
//  outputManager.setOutputStream(cutSceneBanner.outputStream_);
//  
//  // Go through the slide show.
//  for (local a=1; a<=glob.cs1List.length(); ++a) {
//    // Clear the 100%-size banner window.
//    cutSceneBanner.clearWindow();
//    // Unless the first element in this part of the list is nil,
//    // display it as an image in the banner window.
//    if (glob.cs1List[a][1]) {
//      csDispImg(glob.cs1List[a][1]);
//    }
//    // If there is text to output to the window, output it.
//    if (glob.cs1List[a][2]) {
//      csShout(glob.cs1List[a][2]);
//    }
//    // If there is any sound to output to the main window,
//    // and if sound is allowed for output, output it.
//    if (glob.cs1List[a][3] && glob.musicOn) {
//      "<<glob.cs1List[a][3]>>";
//    }
//    
//    csShout('<p>');
//    
//    nbmPause();
//  }
//  
//  outputManager.setOutputStream(mainOutputStream);
//  
//  /*
//  bannerKeyClsImg('white.png');
//  csShout('Then, suddenly, when the light hits your eyes, you remember! 
//    You know where you are. You know why you are here.');
//  bannerKeyClsImg('white.png');
//  csShout('Years back, in the late 2010s, you heard about a new advance 
//    in cryogenics. Using new techniques, scientists could now 
//    freeze the human body with far less damage to brain cells 
//    than ever before.');
//  bannerKeyClsImg('white.png');
//  csShout('The idea intrigued you. A few weeks later, you signed up. 
//    $100,000 for a chance at immortality? Why not? Even if it was 
//    a long shot. ');
//  bannerKeyClsImg('white.png');
//  csShout('Then, years later, you were seized by a pain in the chest. 
//    With difficulty you stumbled to a coworker<./s>s desk. He helped 
//    you to his car and rushed you to the hospital. You don<./s>t 
//    remember anything after that.');
//  bannerKeyClsImg('white.png');
//  csShout('And now, waking up here . . . blinded by this light . . . 
//    you cannot quite bring yourself to grasp what is happening.');
//  bannerKeyClsImg('white.png');
//  csShout('And then your eyes adjust, and you cannot believe what you 
//    see. ');
//  bannerKeyClsImg('firstalien.jpg');
//  
//
//  // No text. However, add music.
//  "<sound src=\"sound/alien.mp3\" layer=foreground>";
//  bannerKeyClsImg('firstalien.jpg');
//  csShout('Before you stands a creature that is not human. Its skin is 
//    green, like that of a lizard or a fish. But it is dressed in 
//    clothing, and its eyes peer at you with intensity. The creature 
//    is clearly intelligent, and it is clearly the one who has 
//    awoken you from your cryogenic sleep. ');
//  bannerKeyClsImg('firstalien.jpg');
//  csShout('You can only hope its intentions are good, because you are 
//    lying in a coffin beneath it, and you are far too weak to put 
//    up any resistance. ');
//  bannerKeyClsImg('firstalien.jpg');
//  csShout('The creature extends its hands-which, you notice, are 
//    flipper-like and possess only two digits. Your heart beats 
//    hard as he puts his arms underneath you. With unusual 
//    strength he lifts you and carries you onto something 
//    resembling a hospital stretcher. With that, he wheels you 
//    out of the room and down the hallway. ');
//  bannerKeyClsImg('hospital.jpg');
//  csShout('He takes you to a sterile room, where you meet with other 
//    creatures. For the next few days, they feed you food that is quite 
//    delicious, but also quite unlike anything you<./s>ve ever seen 
//    before. You dine on fish pudding and strawberry yams. ');
//  bannerKeyClsImg('hospital.jpg');
//  csShout('For the next few days, they help you regain strength and 
//    rehabilitate yourself. Progress is slow at first, but within 
//    a week, you are able to walk again. ');
//  bannerKeyClsImg('hospital.jpg');
//  csShout('Your companions seem to have the best of intentions, but you 
//    are unable to communicate with them. When you try to speak 
//    to them, they regard you with amusement, and make no effort 
//    to understand. ');
//  bannerKeyClsImg('hospital.jpg');
//  csShout('You have no doubt that these are aliens from some distant 
//    star system. But you are not able to learn much more than that.');
//  bannerKeyClsImg('aircar.jpg');
//  csShout('One day, some new aliens in black uniforms arrive. They 
//    escort you to the roof and into a waiting aircar. The craft 
//    lifts off the roof with remarkable agility. The craft briefly 
//    slows to a hover, then suddenly rockets forward through the 
//    sky. ');
//  bannerKeyClsImg('aircar.jpg');
//  csShout('At first you are exhilarated by the fast ride, but then you 
//    look out the window, and you are shocked. All signs of human 
//    habitation are virtually in ruins. Tall grass pokes through 
//    cracks in the streets. Windows are broken, and paint is 
//    peeling even on formerly well-tended buildings. You do not 
//    want to think about what this means. ');
//  bannerKeyClsImg('aircar.jpg');
//  csShout('Then, as you fly further, you begin to see new structures, 
//    but ones that are utterly alien, made of black concrete 
//    and green glass. These alien buildings become more and more 
//    frequent. Soon you see an installation on the far horizon, 
//    a broad collection of buildings, towers, and launch pads. ');
//  bannerKeyClsImg('couch.jpg');
//  csShout('The craft descends toward the installation, then lands near 
//    one of the smaller buildings. The aliens lead you into the 
//    building, and then to a quiet, sterile room. There a new 
//    alien greets you, and directs you to lie down on a strange 
//    metal couch, beneath a dentist<./s>s-style articulated metal 
//    arm. ');
//  bannerKeyClsImg('couch.jpg');
//  csShout('The arm is attached to your head, and then things get 
//    blurry. It feels as if information is being sucked out 
//    of your brain. Time passes. Then a painful stream of 
//    knowledge suddenly comes screaming into your mind. You lose 
//    track of time as this cycle is repeated over and over. ');
//  bannerKeyClsImg('hall2g1h1a.jpg');
//  csShout('Finally the cycle stops. The alien speaks to you, and you 
//    are amazed to find that you understand him. He says, 
//    <.q>You may feel a bit disoriented, but this will soon pass. 
//    Please follow me.<./q> With that he steps out into the hallway. 
//    You stumble after him, while the two uniformed aliens 
//    follow close behind. ');
//  bannerKeyClsImg('hall2g1h1a.jpg');
//  csShout('Following the alien, you sputter a series of questions: 
//    <.q>Where am I?<./q> <.q>Who are you?<./q> <.q>Why have I been brought 
//    here?<./q> After you realize that you<./s>re speaking in English, 
//    you make a tremendous effort, summon an ability you didn<./s>t 
//    know you had, and ask in the aliens<./s> native tongue, 
//    <.q>Where am I?<./q> Your guide glances back at you and 
//    replies, <.q>You will be told everything in just a few 
//    moments. Please follow me. I am only an assistant.<./q>');
//  bannerKeyClsImg('confroom.jpg');
//  csShout('');
//  bannerKeyClsImg('confroom.jpg');
//  csShout('The alien leads you to a room with a large table 
//    surrounded by chairs. He directs you to sit down, then 
//    says, <.q>Your mentors will be here shortly. Please sit 
//    and wait.<./q> With that, he leaves. The two uniformed aliens 
//    then take their places on either side of the door. 
//    You take a seat.');
//  keyCls();
//  */
//  
//  cutSceneBanner.removeBanner();
//  
//  // The old way of doing it:
//  //me.moveInto(confChair);
//  //me.makePosture(sitting);
//  
//  // The new way of doing it:
//  goToConfRoom.execute;
//  
//  nestedAction(Look);
//  
//  // Unfortunately, this doesn't help.
//  //throw new TerminateCommandException();
//  
//  cancelPendingCommands();
//  
//}
//
//bannerKeyClsImg(filename) {
//  nbmPause();
//  //nbmCls();
//  cutSceneBanner.clearWindow();
//  csDispImg(filename);
//}
//
//keyCls() {
//  nbmPause();
//  nbmCls();
//}

// -------------------------------------------------------------------
// THE FIRST TWO TURNS: NON-META VERB BLOCKER
// -------------------------------------------------------------------

function nonMetaVerbBlocker() {
  glob.blockVerbCount++;
  libGlobal.totalTurns++;
  // If the player types "wake up" or "awaken" during the first turn,
  // skip ahead a step.
  if (glob.blockVerbCount == 1 && glob.mainInputStr.toLower.find('wake')) {
    glob.blockVerbCount++;
    libGlobal.totalTurns++;
  }
  //"No, no. None of that. You've done that <<glob.blockVerbCount>> time(s). ";
  switch (glob.blockVerbCount) {
    case 1: 
      "You do not even know if you are awake. ";
      //if (glob.mainInputStr.toLower.find('wake'))
      //  "CONTAINS WAKE!!";
      //else
      //  "no wake";
      break;
    case 2:
      "Eventually you wake up enough to understand that you are 
        awake. But you are also in complete darkness. Where are you? 
        Why are you so stiff and groggy? And why do you feel as 
        though you have been asleep for a hundred years? <.p>";
      glob.status = trinity;
      glob.blockNonMetaVerbs = nil;
      
      me.moveIntoForTravel(coffin);
      me.makePosture(lying);
      nestedAction(Look);
      coffinDaemon.startDaemon();
      
      //nestedAction(Dream);
      //
      //daemonID = new Daemon(me, &daemon, 1);
      break;
  }
}

// -------------------------------------------------------------------
// THE FIRST TWO TURNS: LIBRARY HACKS
// -------------------------------------------------------------------

modify glob
  blockNonMetaVerbs = nil // Will be changed to true when starting the 
                          // game normally.
  blockVerbCount = 0
  mainInputStr = ''
;

modify Action
  isNonMetaForBlocking() {
    if (ofKind(AgainAction)) return true; // "again" is non-meta for blocking purposes
    if (actionTime != 0) return true;
    return nil;
  }
;
//modify AgainAction
//  isNonMetaForBlocking = true
//;

// The executeCommand() function has been hacked for two reasons:
// (1) For the sake of the first two turns: Blocks all non-meta
//     actions when glob.blockNonMetaVerbs = true.
// (2) For the sake of the Scott Adams phaser: Pick up the verb 
//     (or first word of the command) and pass it to glob.latestVerb.
// (3) For the sake of trying to stop commands like "VICKI, JUMP UP"
//     and "VICKI, GO EAT". I succeeded in the former case, but not
//     the latter.
replace executeCommand(targetActor, issuingActor, toks, firstInSentence)
{
  local actorPhrase;
  local actorSpecified;
  
  
  //START HACK #2
  glob.latestVerb = toks[1][1];
  //END HACK #2
  
  
  libGlobal.enableSenseCache();
  actorPhrase = nil;
  actorSpecified = nil;
  if (firstInSentence
    && issuingActor != targetActor
    && issuingActor.revertTargetActorAtEndOfSentence)
  {
    targetActor = issuingActor;
    //senseContext.setSenseContext(targetActor, sight); // changed 2016-11-09 per new adv3 changes
    senseContext.setSenseContext(issuingActor, sight);
  }
 parseTokenLoop:
  for (;;)
  {
    local lst;
    local action;
    local match;
    local nextIdx;
    local nextCommandTokens;
    local extraIdx;
    local extraTokens;
    try
    {
      local rankings;
      extraTokens = [];
      lst = (firstInSentence ? firstCommandPhrase : commandPhrase)
            .parseTokens(toks, cmdDict);
      lst = lst.subset(
          {x: x.resolveFirstAction(issuingActor, targetActor) != nil});
      if (lst.length() == 0)
      {
        
        
        //START HACK #1A
        if (glob.blockNonMetaVerbs) {
          //"Don't you try to do anything except meta verbs. ";
          nonMetaVerbBlocker();
          return;
          //throw new TerminateCommandException;
        }
        //END HACK #1A
        
        
        //START HACK #3A, PART 1
        // This part is directly from TADS 3.0.10.
        if (firstInSentence)
        {
          local i;
          lst = actorBadCommandPhrase.parseTokens(toks, cmdDict);
          lst = lst.mapAll({x: x.resolveNouns(
            issuingActor, issuingActor,
            //new ActorResolveResults())}); // changed 2016-11-09
            new TryAsActorResolveResults())});
          lst = lst.subset({x: x != nil && x.length() != 0});
          if (lst.length() != 0
            && (i = lst.indexWhich(
              {x: x[1].obj_.ofKind(Actor)})) != nil)
            targetActor = lst[i][1].obj_;
        }
        //START HACK #3A, PART 2
        if (targetActor != nil && targetActor != gPlayerChar) {
          say(playerActionMessages.useTalkToMsg);
          return;
        }
        //END HACK #3A - PART 2; PART 3 IS FAR BELOW
        
        
        
        
        
        
        
        
        
        
        tryOops(toks, issuingActor, targetActor,
                1, toks, rmcCommand);
        if (specialTopicHistory.checkHistory(toks))
        {
          targetActor.notifyParseFailure(
            issuingActor, &specialTopicInactive, []);
        }
        else
        {
          targetActor.notifyParseFailure(
            issuingActor, &commandNotUnderstood, []);
        }
        return;
      }
      dbgShowGrammarList(lst);
      rankings = CommandRanking
                 .sortByRanking(lst, issuingActor, targetActor);
      match = rankings[1].match;
      dbgShowGrammarWithCaption('Winner', match);
      nextIdx = match.getNextCommandIndex();
      nextCommandTokens = toks.sublist(nextIdx);
      if (nextCommandTokens.length() == 0)
        nextCommandTokens = nil;
      extraIdx = match.tokenList.length() + 1;
      extraTokens = toks.sublist(extraIdx);
      if (match.hasTargetActor())
      {
        local actorResults;
        
        
        //START HACK #3B
        //local ky = inputManager.getKey(nil, nil);
        //if (ky && ky.toLower == 'q') {
        //  local k=0; k=k/k;
        //  
        //}
        if (match.getTargetActor() != gPlayerChar) {
          say(playerActionMessages.useTalkToMsg);
          return;
        }
        //END HACK #3B
        
        
        if (!actorSpecified && issuingActor != targetActor)
        {
          if (!issuingActor.issueCommandsSynchronously)
          {
            senseContext.setSenseContext(nil, sight);
            issuingActor.getParserMessageObj()
              .cannotChangeActor();
            return;
          }
          issuingActor.addFirstPendingCommand(
            firstInSentence, issuingActor, toks);
          return;
        }
        actorResults = new ActorResolveResults();
        actorResults.setActors(targetActor, issuingActor);
        match.resolveNouns(issuingActor, targetActor, actorResults);
        targetActor = match.getTargetActor();
        actorPhrase = match.getActorPhrase();
        targetActor.copyPronounAntecedentsFrom(issuingActor);
        match.execActorPhrase(issuingActor);
        if (!targetActor.acceptCommand(issuingActor))
        {
          return;
        }
        actorSpecified = true;
        toks = match.getCommandTokens();
        firstInSentence = nil;
        continue parseTokenLoop;
      }
      action = match.resolveFirstAction(issuingActor, targetActor);
      
      
      //START HACK #1B
      if (glob.blockNonMetaVerbs && action.isNonMetaForBlocking) {
        //"Don't you try to do anything except meta verbs. ";
        nonMetaVerbBlocker();
        return;
        //throw new TerminateCommandException;
      }
      //if (action && action.ofKind(SearchAction)) {
      //  local k = 0; k=k/k;
      //}
      //END HACK #1B
      
      
      if (rankings[1].unknownWordCount != 0)
      {
        match.resolveNouns(
          issuingActor, targetActor,
          new OopsResults(issuingActor, targetActor));
      }
      

// Begin replacement 2016-11-09 per new stuff for TADS 3.1.3
//      if (actorSpecified && targetActor != issuingActor)
//        senseContext.setSenseContext(targetActor, sight);
//      withCommandTranscript(CommandTranscript, new function()
//      {
//        executeAction(targetActor, actorPhrase, issuingActor,
//                      actorSpecified && issuingActor != targetActor,
//                      action);
//      });
      if (action != nil && action.isConversational(issuingActor))
        senseContext.setSenseContext(issuingActor, sight);
      else if (actorSpecified && targetActor != issuingActor)
        senseContext.setSenseContext(targetActor, sight);
      withCommandTranscript(CommandTranscript, function()
      {
        executeAction(targetActor, actorPhrase, issuingActor,
                actorSpecified && issuingActor != targetActor,
                action);
      });
// End replacement 2016-11-09
      
      if (nextCommandTokens != nil)
      {
        targetActor.addFirstPendingCommand(
          match.isEndOfSentence(), issuingActor, nextCommandTokens);
      }
      if (actorSpecified && issuingActor != targetActor)
        issuingActor.waitForIssuedCommand(targetActor);
      return;
    }
    catch (ParseFailureException rfExc)
    {
      rfExc.notifyActor(targetActor, issuingActor);
      return;
    }
    catch (CancelCommandLineException cclExc)
    {
      if (nextCommandTokens != nil)
        targetActor.getParserMessageObj().explainCancelCommandLine();
      return;
    }
    catch (TerminateCommandException tcExc)
    {
      return;
    }
    catch (RetryCommandTokensException rctExc)
    {
      toks = rctExc.newTokens_ + extraTokens;
      continue parseTokenLoop;
    }
    catch (ReplacementCommandStringException rcsExc)
    {
      local str;
      str = rcsExc.newCommand_;
      if (str == nil)
        return;
      toks = cmdTokenizer.tokenize(str);
      firstInSentence = true;
      issuingActor = rcsExc.issuingActor_;
      targetActor = rcsExc.targetActor_;
      targetActor.addPendingCommand(true, issuingActor, toks);
      return;
    }
  }
}

// This replacement is the suggested solution to the TADS 3.1.3 bug 
// that causes "hello, me" "hello, sailor" "hello, yak" to produce an ugly nil reference exception. 
// See also
// http://bugdb.tads.org/view.php?id=228
modify NounPhraseWithVocab
    /*
     * Run a set of resolved objects through matchName() or a similar
     * routine. Returns the filtered results. 
     */
    resolveNounsMatchName(results, resolver, matchList)
    {
        local origTokens;
        local adjustedTokens;
        local objVec;
        local ret;

        /* get the original token list for the command */
        origTokens = getOrigTokenList();

        /* get the adjusted token list for the command */
        adjustedTokens = getAdjustedTokens();

        /* set up to receive about the same number of results as inputs */
        objVec = new Vector(matchList.length());

        /* consider each preliminary match */
        foreach (local cur in matchList)
        {
            /* ask this object if it wants to be included */
            local newObj = resolver.matchName(
                cur.obj_, origTokens, adjustedTokens);

            /* check the result */
            if (newObj == nil)
            {
                /* 
                 * it's nil - this means it's not a match for the name
                 * after all, so leave it out of the results 
                 */
            }
            else if (newObj.ofKind(Collection))
            {
                /* 
                 * it's a collection of some kind - add each element to
                 * the result list, using the same flags as the original 
                 */
                foreach (local curObj in newObj)
                    objVec.append(new ResolveInfo(curObj, cur.flags_, self));
            }
            else
            {
                /* 
                 * it's a single object - add it ito the result list,
                 * using the same flags as the original 
                 */
                objVec.append(new ResolveInfo(newObj, cur.flags_, self));
            }
        }

        /* convert the result vector to a list */
        ret = objVec.toList();

        /* if our list is empty, note it in the results */
        if (ret.length() == 0)
        {
            /* 
             * If the adjusted token list contains any tokens of type
             * "miscWord", send the phrase to the results object for
             * further consideration. 
             */
            if (adjustedTokens.indexOf(&miscWord) != nil)
            {
                /* 
                 * we have miscWord tokens, so this is a miscWordList
                 * match - let the results object process it specially. 
                 */
                ret = results.unknownNounPhrase(self, resolver);
            }
            
            /* THIS IS THE NEW BIT */
            if (!ret)
                ret = [];

            /* 
             * if the list is empty, note that we have a noun phrase
             * whose vocabulary words don't match anything in the game 
             */
            if (ret.length() == 0)
                results.noVocabMatch(resolver.getAction(), getOrigText());
        }

        /* return the result list */
        return ret;
    }
;


//START HACK #3A - PART 3

// Commented out now because this is straight from modern versions of TADS 3.

/*
grammar actorBadCommandPhrase(main):
  singleNounOnly->actor_ ',' miscWordList
  | ('ask' | 'tell' | 'a' | 't') singleNounOnly->actor_ 'to' miscWordList
  : FirstCommandProdWithActor
  resolveNouns(issuingActor, targetActor, results)
  {
    return actor_.resolveNouns(getResolver(issuingActor), results);
  }
;
*/
//END HACK #3A - PART 3





// Here is the non-hacked version of executeCommand() as given in
// TADS 3.0.13. The only difference between this and the original
// is that I got rid of the empty lines and reworked the commends 
// to convert the /*'s and */'s to //'s.
// 
// This is here so that if, in the future, I wanted to hack this
// and add it to qtalkverbs.t, I can do that. For now, I am a little
// too uncertain of how to do this in relation to the various past and
// future versions of TADS 3 to want to bother with this.
/*
replace executeCommand(targetActor, issuingActor, toks, firstInSentence)
{
    local actorPhrase;
    local actorSpecified;
    // Turn on sense caching while we're working, until execution
    // begins.  The parsing and resolution phases of command processing
    // don't involve any changes to game state, so we can safely cache
    // sense information; caching sense information during these phases
    // is desirable because these steps (noun resolution in particular)
    // involve repeated inspection of the current sensory environment,
    // which can require expensive calculations.  
    libGlobal.enableSenseCache();
    // we don't have an explicit actor phrase yet
    actorPhrase = nil;
    // presume an actor will not be specified
    actorSpecified = nil;
    // If this is the start of a new sentence, and the issuing actor
    // wants to cancel any target actor designation at the end of each
    // sentence, change the target actor back to the issuing actor.  
    if (firstInSentence
        && issuingActor != targetActor
        && issuingActor.revertTargetActorAtEndOfSentence)
    {
        // switch to the target actor
        targetActor = issuingActor;
        // switch to the issuer's sense context
        senseContext.setSenseContext(targetActor, sight);
    }
    // Keep going until we've processed the command.  This might take
    // several iterations, because we might have replacement commands to
    // execute.  
parseTokenLoop:
    for (;;)
    {
        local lst;
        local action;
        local match;
        local nextIdx;
        local nextCommandTokens;
        local extraIdx;
        local extraTokens;
        // Catch any errors that occur while executing the command,
        // since some of them are signals to us that we should reparse
        // some new text read or generated deep down inside the command
        // processing.  
        try
        {
            local rankings;
            // we have no extra tokens yet
            extraTokens = [];
            // Parse the token list.  If this is the first command on
            // the command line, allow an actor prefix.  Otherwise, just
            // look for a command.  
            lst = (firstInSentence ? firstCommandPhrase : commandPhrase)
                  .parseTokens(toks, cmdDict);
            // As a first cut at reducing the list of possible matches
            // to those that make sense, eliminate from this list any
            // matches which do not have valid actions.  In grammars for
            // "scrambling" languages (i.e., languages with flexible
            // word ordering), it is possible to construct commands that
            // fit the grammatical rules of sentence construction but
            // which make no sense because of the specific constraints
            // of the verbs involved; we can filter out such nonsense
            // interpretations immediately by keeping only those
            // structural interpretations that can resolve to valid
            // actions.  
            lst = lst.subset(
                {x: x.resolveFirstAction(issuingActor, targetActor) != nil});
            // if we have no matches, the command isn't understood
            if (lst.length() == 0)
            {
                // If this is a first-in-sentence phrase, try looking for
                // a target actor phrase.  If we can find one, we can
                // direct the 'oops' to that actor, to allow the game to
                // customize messages more specifically.  
                if (firstInSentence)
                {
                    local i;
                    // try parsing an "actor, <unknown>" phrase
                    lst = actorBadCommandPhrase.parseTokens(toks, cmdDict);
                    // if we got any matches, try to resolve actors
                    lst = lst.mapAll({x: x.resolveNouns(
                        issuingActor, issuingActor,
                        new ActorResolveResults())});
                    // drop any that didn't yield any results
                    lst = lst.subset({x: x != nil && x.length() != 0});
                    // if anything's left, and one of the entries 
                    // resolves to an actor, arbitrarily pick the 
                    // first such entry use the resolved actor as the 
                    // new target actor 
                    if (lst.length() != 0
                        && (i = lst.indexWhich(
                            {x: x[1].obj_.ofKind(Actor)})) != nil)
                        targetActor = lst[i][1].obj_;
                }
                // We don't understand the command.  Check for unknown
                // words - if we have any, give them a chance to use
                // OOPS to correct a typo.  
                tryOops(toks, issuingActor, targetActor,
                        1, toks, rmcCommand);
                // try running it by the SpecialTopic history to see if
                // they're trying to use a special topic in the wrong
                // context - if so, explain that they can't use the
                // command right now, rather than claiming that the
                // command is completely invalid 
                if (specialTopicHistory.checkHistory(toks))
                {
                    // the special command is not currently available
                    targetActor.notifyParseFailure(
                        issuingActor, &specialTopicInactive, []);
                }
                else
                {
                    // tell the issuer we didn't understand the command
                    targetActor.notifyParseFailure(
                        issuingActor, &commandNotUnderstood, []);
                }
                // we're done with this command, and we want to abort
                // any subsequent commands on the command line 
                return;
            }
            // show the matches if we're in debug mode
            dbgShowGrammarList(lst);
            // Perform a tentative resolution on each alternative
            // structural interpretation of the command, and rank the
            // interpretations in order of "goodness" as determined by
            // our ranking criteria encoded in CommandRanking.
            // 
            // Note that we perform the tentative resolution and ranking
            // even if we have only one interpretation, because the
            // tentative resolution is often useful for the final
            // resolution pass.  
            rankings = CommandRanking
                       .sortByRanking(lst, issuingActor, targetActor);
            // Take the interpretation that came up best in the rankings
            // (or, if we have multiple at the same ranking, arbitrarily
            // pick the one that happened to come up first in the list)
            // - they're ranked in descending order of goodness, so take
            // the first one.
            match = rankings[1].match;
            // if we're in debug mode, show the winner
            dbgShowGrammarWithCaption('Winner', match);
            // Get the token list for the rest of the command after what
            // we've parsed so far.
            // 
            // Note that we'll start over and parse these tokens anew,
            // even though we might have parsed them already into a
            // subcommand on the previous iteration.  Even if we already
            // parsed these tokens, we want to parse them again, because
            // we did not have a suitable context for evaluating the
            // semantic strengths of the possible structural
            // interpretations this command on the previous iteration;
            // for example, it was not possible to resolve noun phrases
            // in this command because we could not guess what the scope
            // would be when we got to this point.  So, we'll simply
            // discard the previous match tree, and start over, treating
            // the new tokens as a brand new command.  
            nextIdx = match.getNextCommandIndex();
            nextCommandTokens = toks.sublist(nextIdx);
            // if the pending command list is empty, make it nil
            if (nextCommandTokens.length() == 0)
                nextCommandTokens = nil;
            // Get the part of the token list that the match doesn't use
            // at all.  These are the tokens following the tokens we
            // matched. 
            extraIdx = match.tokenList.length() + 1;
            extraTokens = toks.sublist(extraIdx);
            // We now have the best match for the command tree.
            // 
            // If the command has an actor clause, resolve the actor, so
            // that we can direct the command to that actor.  If the
            // command has no actor clause, the command is to the actor
            // who issued the command.
            // 
            // Do NOT process the actor clause if we've already done so.
            // If we edit the token list and retry the command after
            // this point, there is no need to resolve the actor part
            // again.  Doing so could be bad - if resolving the actor
            // required player interaction, such as asking for help with
            // an ambiguous noun phrase, we do not want to go through
            // the same interaction again just because we have to edit
            // and retry a later part of the command.  
            if (match.hasTargetActor())
            {
                local actorResults;
                // If we haven't yet explicitly specified a target
                // actor, and the default target actor is different from
                // the issuing actor, then this is really a new command
                // from the issuing actor.
                // 
                // First, an actor change mid-command is allowed only if
                // the issuing actor waits for NPC commands to be
                // carried out; if not, then we can't change the actor
                // mid-command.
                // 
                // Second, since the command comes from the issuing
                // actor, not from the default target actor, we want to
                // issue the orders on the issuing actor's turn, so put
                // the command into the queue for the issuer, and let
                // the issuer re-parse the command on the issuer's next
                // turn.  
                if (!actorSpecified && issuingActor != targetActor)
                {
                    // don't allow the command if the issuing actor
                    // doesn't wait for orders to be completed 
                    if (!issuingActor.issueCommandsSynchronously)
                    {
                        // turn off any sense capturing
                        senseContext.setSenseContext(nil, sight);
                        // show the error
                        issuingActor.getParserMessageObj()
                            .cannotChangeActor();
                        // done
                        return;
                    }
                    // put the command into the issuer's queue
                    issuingActor.addFirstPendingCommand(
                        firstInSentence, issuingActor, toks);
                    // done
                    return;
                }
                // create an actor-specialized results object
                actorResults = new ActorResolveResults();
                // set up the actors in the results object
                actorResults.setActors(targetActor, issuingActor);
                // resolve the actor object
                match.resolveNouns(issuingActor, targetActor, actorResults);
                // get the target actor from the command
                targetActor = match.getTargetActor();
                // pull out the phrase specifying the actor
                actorPhrase = match.getActorPhrase();
                // Copy antecedents from the issuing actor to the target
                // actor.  Since the issuer is giving us a new command
                // here, pronouns will be given from the issuer's
                // perspective.  
                targetActor.copyPronounAntecedentsFrom(issuingActor);
                // let the actor phrase know we're actually using it
                match.execActorPhrase(issuingActor);
                // Ask the target actor if it's interested in the
                // command at all.  This only applies when the actor was
                // actually specified - if an actor wasn't specified,
                // the command is either directed to the issuer itself,
                // in which case the command will always be accepted; or
                // the command is a continuation of a command line
                // previously accepted.  
                if (!targetActor.acceptCommand(issuingActor))
                {
                    // the command was immediately rejected - abandon
                    // the command and any subsequent commands on the
                    // same line 
                    return;
                }
                // note that an actor was specified
                actorSpecified = true;
                // Pull out the rest of the command (other than the
                // target actor specification) and start over with a
                // fresh parse of the whole thing.  We must do this
                // because our tentative resolution pass that we used to
                // pick the best structural interpretation of the
                // command couldn't go far enough - since we didn't know
                // the actor involved, we weren't able to resolve nouns
                // in the rest of the command.  Now that we know the
                // actor, we can start over and resolve everything in
                // the rest of the command, and thus choose the right
                // structural match for the command.  
                toks = match.getCommandTokens();
                // what follows obviously isn't first in the sentence
                firstInSentence = nil;
                // go back to parse the rest
                continue parseTokenLoop;
            }
            // pull out the first action from the command     
            action = match.resolveFirstAction(issuingActor, targetActor);
            // If the winning interpretation had any unknown words, run
            // a resolution pass to resolve those interactively, if
            // possible.  We want to do this before doing any other
            // interactive resolution because OOPS has the unique
            // property of forcing us to reparse the command; if we
            // allowed any other interactive resolution to happen before
            // processing an OOPS, we'd likely have to repeat the other
            // resolution on the reparse, which would confuse and
            // irritate users by asking the same question more than once
            // for what is apparently the same command.  
            if (rankings[1].unknownWordCount != 0)
            {
                // resolve using the OOPS results gatherer - this runs
                // essentially the same preliminary resolution process
                // as the ranking results gatherer, but does perform
                // interactive resolution of unknown words via OOPS 
                match.resolveNouns(
                    issuingActor, targetActor,
                    new OopsResults(issuingActor, targetActor));
            }
            // If the command is directed to a different actor than the
            // issuer, change to the target actor's sense context.  
            if (actorSpecified && targetActor != issuingActor)
                senseContext.setSenseContext(targetActor, sight);
            // set up a transcript to receive the command results
            withCommandTranscript(CommandTranscript, new function()
            {
                // Execute the action.
                // 
                // If a target actor was specified, and it's not the same
                // as the issuing actor, this counts as a turn for the
                // issuing actor.  
                executeAction(targetActor, actorPhrase, issuingActor,
                              actorSpecified && issuingActor != targetActor,
                              action);
            });
            // If we have anything remaining on the command line, insert
            // the remaining commands at the start of the target actor's
            // command queue, since we want the target actor to continue
            // with the rest of this command line as its next operation.
            // 
            // Since the remainder of the line represents part of the
            // work the actor pulled out of the queue in order to call
            // us, put the remainder back in at the START of the actor's
            // queue - it was before anything else that might be in the
            // actor's queue before, so it should stay ahead of anything
            // else now.  
            if (nextCommandTokens != nil)
            {
                // Prepend the remaining commands to the actor's queue.
                // The next command is the start of a new sentence if
                // the command we just executed ends the sentence. 
                targetActor.addFirstPendingCommand(
                    match.isEndOfSentence(), issuingActor, nextCommandTokens);
            }
            // If the command was directed from the issuer to a
            // different target actor, and the issuer wants to wait for
            // the full set of issued commands to complete before
            // getting another turn, tell the issuer to begin waiting.  
            if (actorSpecified && issuingActor != targetActor)
                issuingActor.waitForIssuedCommand(targetActor);
            // we're done
            return;
        }
        catch (ParseFailureException rfExc)
        {
            // Parsing failed in such a way that we cannot proceed.
            // Tell the target actor to notify the issuing actor.  
            rfExc.notifyActor(targetActor, issuingActor);
            // the command cannot proceed, so abandon any remaining
            // tokens on the command line 
            return;
        }
        catch (CancelCommandLineException cclExc)
        {
            // if there are any tokens remaining, the game might want to
            // show an explanation 
            if (nextCommandTokens != nil)
                targetActor.getParserMessageObj().explainCancelCommandLine();
            // stop now, abandoning the rest of the command line 
            return;
        }
        catch (TerminateCommandException tcExc)
        {
            // the command cannot proceed - we can't do any more
            // processing of this command, so simply return, abandoning
            // any additional tokens we have 
            return;
        }
        catch (RetryCommandTokensException rctExc)
        {
            // We want to replace the current command's token list with
            // the new token list - get the new list, and then go back
            // and start over processing it.
            // 
            // Note that we must retain any tokens beyond those that the
            // match tree used.  The exception only edits the current
            // match tree's matched tokens, since it doesn't have access
            // to any of the original tokens beyond those, so we must
            // now add back in any tokens beyond the originals.  
            toks = rctExc.newTokens_ + extraTokens;
            // go back and process the command again with the new tokens
            continue parseTokenLoop;
        }
        catch (ReplacementCommandStringException rcsExc)
        {
            local str;
            // retrieve the new command string from the exception
            str = rcsExc.newCommand_;
            // if the command string is nil, it means that the command
            // has been fully handled already, so we simply return
            // without any further work 
            if (str == nil)
                return;
            // Replace the entire command string with the one from the
            // exception - this cancels any previous command that we
            // had.
            toks = cmdTokenizer.tokenize(str);
            // we have a brand new command line, so we're starting a
            // brand new sentence 
            firstInSentence = true;
            // set the issuing and target actor according to the exception
            issuingActor = rcsExc.issuingActor_;
            targetActor = rcsExc.targetActor_;
            // Put this work into the target actor's work queue, so that
            // the issuer will carry out the command at the next
            // opportunity.  This is a brand new command line, so it
            // starts a new sentence.  
            targetActor.addPendingCommand(true, issuingActor, toks);
            // we're done processing this command
            return;
        }
    }
}
*/


// readMainCommandTokens() hacked for two reasons:
// (1) For the sake of the first two turns, to make sure
//     "I beg your pardon?" messages are replaced as desired.
// (2) For the sake of the Scott Adams phaser, to prevent
//     reference to it when the input is is more than two
//     words long.

replace readMainCommandTokens(which)
{
  local str;
  local toks;
  for (;;) {
    str = readMainCommand(which);
    
    
    // BEGIN HACK #1C, added August 2006
    glob.mainInputStr = str;
    // END HACK #1C
    
    
    str = StringPreParser.runAll(str, which);
    // if preparsing returned nil, then return nil
    if (str == nil)
      return nil;
    try {
      toks = cmdTokenizer.tokenize(str);
    }
    catch (TokErrorNoMatch tokExc) {
      
      
      // BEGIN HACK #1A
      if (glob.blockNonMetaVerbs)
        nonMetaVerbBlocker();
      else
        gLibMessages.invalidCommandToken(tokExc.curChar_.htmlify());
      // END HACK #1A
      
      
      continue;
    }
    
    
    // START HACK #2
    //if (toks.length == 3 && toks[3][1] = '.')
    if (toks.length > 0) {
      if (toks[toks.length][1] == '.')
        glob.wordsLastTyped = toks.length - 1;
      else
        glob.wordsLastTyped = toks.length;
    }
    else
      glob.wordsLastTyped = toks.length;
    // END HACK #2
    
    
    if (toks.length() != 0)
      return [str, toks];
    
    
    // BEGIN HACK #1B
    if (glob.blockNonMetaVerbs)
      nonMetaVerbBlocker();
    else
      gLibMessages.emptyCommandResponse();
    // END HACK #1B
    
    
  }
}

/*
// Hacked for the sake of the first two turns, when the parser
// responds to a blank line just like a 
replace readMainCommandTokens(which)
{
  local str;
  local toks;
  for (;;)
  {
    str = readMainCommand(which);
    str = StringPreParser.runAll(str, which);
    if (str == nil)
      return nil;
    try
    {
      toks = cmdTokenizer.tokenize(str);
    }
    catch (TokErrorNoMatch tokExc)
    {
      gLibMessages.invalidCommandToken(tokExc.curChar_.htmlify());
      continue;
    }
    if (toks.length() != 0)
      return [str, toks];
    
    // BEGIN HACK
    if (glob.blockNonMetaVerbs) {
      nonMetaVerbBlocker();
    }
    else {
      "Whoa: ";
      gLibMessages.emptyCommandResponse();
    }
    // END HACK
    
    
  }
}
*/

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

DefineIAction(Safe)
  execAction() {
    CutScene.doTfo = (systemInfo(SysInfoOsName).substr(1,3).toUpper == 'WIN');
    "Okay, non-Windows interpreters will now no longer try to output
      cut scenes to the transcript. ";
  }
  actionTime = 0
;
VerbRule(Safe)
  'safe'
  : SafeAction
  verbPhrase = 'make/making the game safe'
;
DefineIAction(Unsafe)
  execAction() {
    CutScene.doTfo = true;
    "Okay, all interpreters will now try to output cut scenes
      to the transcript. This reportedly produces weird bugs
      under HyperTADS. ";
  }
  actionTime = 0
;
VerbRule(Unsafe)
  'unsafe'
  : UnsafeAction
  verbPhrase = 'make/making the game unsafe'
;

DefineIAction(Cs3)
  execAction() {
    mazesExe.isViable = true;
    mazesExe.isWinnable = true;
    beachChairM.isInExe = true;
    butterflyIdM.isInExe = true;
    me.reallySleep;
  }
  actionTime = 0
;
VerbRule(Cs3)
  'cs' | 'cs3'
  : Cs3Action
  verbPhrase = 'do/doing the third cut scene'
;


myDarkRoom: DarkRoom 'A really, really dark room'
  "Zoinks! This<./s>d be an interesting place if it had any light. "
;
darkRoomToken: Fixture 'darkroom' 'darkroom' @myDarkRoom;
//coffinToken: Fixture 'coffin' 'coffin' @coffin;

//Presently referred to in this file, but I will need to replace both
//it and the below reference with southConfChair or something like that.

#endif // __DEBUG

