#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// DEBUG STUFF
// The Mazes: QuatMaze class
// The Mazes: QuatMaze objects
// Scenery: The hole
// Scenery: Pedestals and artifacts
// NoTravelMessage stuff: HarmfulQuatTravel
// NoTravelMessage stuff: QuatUpDownTravel
// Misc. stuff: getGeneratedWordForQuat()
// Misc. stuff: quatDaemon
// Map: Ancillary map functions
// Map: quat1MapPrint
// Map: quat2MapPrint
// JUNK

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

quat1Fixture: Fixture 'q1/quat1' 'quat1' @quat1Maze;
quat2Fixture: Fixture 'q2/quat2' 'quat2' @quat2Maze;
scarf: MazePortable, Wearable 'scarf' 'scarf';
mitten: Wearable 'mitten' 'mitten';

#endif // __DEBUG

// -------------------------------------------------------------------
// The Mazes: QuatMaze class
// -------------------------------------------------------------------

// The QuatMaze implementation is based in large part upon the 
// BookMovieMaze implementation, and hence owes something to Krister
// Fundin. See my BookMovieMaze comments in 2bookmovie.t.
// 
// QuatMaze is a Room subclass that represents an entire maze.
class QuatMaze: Room
  // Our room list. Each item is a sub-list, where the first item is 
  // the room's artifact string ('-quat-', etc.), and the other items 
  // define the connections in clockwise order from north to northwest.
  roomList = []
  // Our current location in the maze, given as an index into the 
  // roomList.
  curRoom = startingRoom
  // For convenience, extract the letter of the current room.
  // Transform any instances of '-' to '&#45;', to avoid any
  // cases where the output filter wants to replace '--' with 
  // '&mdash;'.
  curString = 
    (roomList[curRoom][1].findReplace('-','&#45;',ReplaceAll))
  curStringSimple = 
    (roomList[curRoom][1])
    //(roomList[curRoom][1].findReplace('-','&ndash;',ReplaceAll))
  // derive our room name and description
  roomName = (curString)
  roomDesc {
    "The only light in this dark room comes from
      a faintly glowing plastic artifact, 
      which sits here atop a pedestal. 
      The artifact has been crafted in such a way as to spell
      <.q><<curString>>.<./q> ";
  }
  // we always move in circles from and back to this room
  isCircularPassage = true
  // Don't remember circular passages, though. This would make the 
  // EXITS command confused, since all exits are circular.
  rememberCircularPassage = nil
  // note traversal to/from this room
  noteTraversal(traveler) {
    glob.sayQuatPassRemark(self, true);
  }
  enteringRoom(traveler) {
    local dir, newRoom;
    // get the direction of travel.
    if (gAction && gAction.getDirection())
      dir = gAction.getDirection();
    else if (gAction && gAction.parentAction 
             && gAction.parentAction.getDirection()
             && gAction.parentAction.getDirection().ofKind(CompassDirection))
      dir = gAction.parentAction.getDirection();
    if (dir) {
      // convert the direction to a clockwise index
      dir = dir.clockwiseOrder;
      // find the room that we're going to
      newRoom = roomList[curRoom][dir + 1];
      // remember that we have traversed this connection
      if (!connVisited(curRoom, newRoom))
          usedConnections.append([curRoom, newRoom]);
      // change into the new room
      curRoom = newRoom;
    }
    // Move out any unwanted statues/signs and put the 
    // appropriate objects in.
    changeMazeObjects;
    // if quatDaemon hasn't been started by this time, start it now
    quatDaemon.startDaemon();
    // update the banner
    nbmBanner.updateMe();
  }
  // If any objects need to be moved into or out of the room
  // before we enter it, do so here.
  changeMazeObjects {
    // The end room of each maze has a hole in the floor.
    // Move it in or out of the room as needed.
    if (curRoom == endingRoom)
      quatHole.moveInto(self);
    else if (quatHole.isIn(self))
      quatHole.moveInto(nil);
    // Move any MazePortable objects into or out of the room.
    for (local cur = firstObj(MazePortable); cur != nil;
         cur = nextObj(cur, MazePortable)) {
      // If the given MazePortable object is in this room when it's
      // no longer supposed to be, then get rid of it.
      if (cur.isIn(self) && !cur.isIn(gPlayerChar) &&
          cur.mazeRoomNumber != curRoom) {
        cur.baseMoveInto(nil);
      }
      // If the MazePortable object is not currently in the room
      // when it should be, then move it in.
      else if (!cur.isIn(self) && cur.mazeLocation && 
          (cur.mazeLocation == self || cur.mazeLocation.isIn(self)) && 
          cur.mazeRoomNumber == curRoom) {
        cur.baseMoveInto(cur.mazeLocation);
      }
    }
  }
  // the room to start in
  startingRoom = 1
  // have we visited a given room?
  roomVisited(room) {
    // a special case: the starting room is always visited
    if (room == startingRoom)
      return true;
    // go through the list of connections that we have traversed, 
    // since we know that the room has been visited if we have 
    // either left it our entered it at some point
    return (usedConnections.indexWhich(
      { x: x[1] == room || x[2] == room }) != nil);
  }
  // have we used a given connection?
  connVisited(room1, room2) {
    // look for a traversal either from room1 to room2 or in the 
    // opposite direction
    return (usedConnections.indexWhich(
      { x: (x[1] == room1 && x[2] == room2)
           || (x[1] == room2 && x[2] == room1) }) != nil);
  }
  roomMapState(str) {
    if (glob.hackQuat1Map || glob.hackQuat2Map)
      return 1;
    if (roomList[curRoom][1] == str)
      return 2;
    if (roomList[startingRoom][1] == str)
      return 1;
    if (usedConnections.indexWhich(
        { x: roomList[x[1]][1] == str || roomList[x[2]][1] == str }
        ) != nil)
      return 1;
    return 0;    
  }
  connMapState(str1, str2) {
    if (glob.hackQuat1Map || glob.hackQuat2Map)
      return 1;
    else if (usedConnections.indexWhich(
        { x: (roomList[x[1]][1] == str1 && roomList[x[2]][1] == str2)
        || (roomList[x[1]][1] == str2 && roomList[x[2]][1] == str1) }) != nil)
      return 1;
    else
      return 0;
  }
  // A vector of connections that we have traversed. Each entry is a 
  // tuplet giving the indices of the origin and the destination.
  // 
  // This implementation is Krister Fundin's, and he set this to be
  // a new Vector(20). That 20 number is weird, because I had 
  // imagined, perhaps naively, that this 20 meant the vector could
  // store 20 tuplets, whereas the maze Krister looked at had 22 
  // connections. The most connections in any maze is 23. Just to be
  // safe, I am changing 20 to 23.
  usedConnections = perInstance(new Vector(162))
  //specificHintState = nil
  specificHintSet = perInstance(new Vector(20))
  resetThisMazeSet {
    // Set the curRoom back to the beginning of the maze
    curRoom = startingRoom;
    // Make it so no rooms or connectors in this maze have been
    // visited
    self.usedConnections = new Vector(162);
    // Reset general hint state
    glob.(generalHintProp) = 0;
    // Reset information about what hints have been requested
    self.specificHintSet = new Vector(20);
    // And so on with various things:
    quatDaemon.endDaemon();
    glob.quatJeopardy = 0;
    glob.quatJeopardyOffset = 0;
    glob.botHasBeenZapped = nil;
    glob.botHasJustBeenZapped = nil;
    glob.quat1HintState = 0;
    glob.quat2HintState = 0;
    glob.quat1PassCount = 0;
    glob.quat2PassCount = 0;
    inherited();
  }
  giveHint {
    if (gPlayerChar.getOutermostRoom.curStringSimple == 'A_AY' || 
        gPlayerChar.getOutermostRoom.curStringSimple == 'EGRE--') {
      "Sheila says, <.q>I think all we need to do here 
        is go down the hole.<./q> ";
      return;
    }
    glob.(generalHintProp)++;
    switch (glob.(generalHintProp)) {
      case 1:
        "Sheila says, <.q>Obviously, the goal of this maze 
          is to find the exit. And since we started in the 
          south-central area, it<./s>s a safe bet that 
          we probably need to get to the north-central
          area. The problem is, this maze is very dark,
          too dark to make the exits easily visible.<./q> ";
        break;
      case 2:
        "Sheila says, <.q>It<./s>s too dark in here for us 
          to find the exits simply by looking. 
          You<./s>ll just have to have me
          walk off in various directions and hope for the best. And, ";
        if (usedConnections.length > 0 && glob.botHasBeenZapped)
          "as you<./s>ve discovered, ";
        else if (usedConnections.length > 0 || glob.botHasBeenZapped)
          "as you may have discovered, ";
        else
          "as you<./s>ll soon find out, ";
        "sometimes I can walk off in particular directions, 
          and sometimes I can<./s>t. It depends on the room. 
          Your job is to figure out why.<./q> ";
        //if (glob.(potentialScoreProp) > (glob.(initialPsp) - 10))
        //  glob.(potentialScoreProp) = glob.(initialPsp) - 10;
        break;
      case 3:
        "Sheila says, <.q>As you may 
          <<!glob.botHasBeenZapped ? 'or may not ' : ''>>have noticed, 
          when I walk off in a direction that isn<./s>t allowed, 
          the artifact says that such-and-such is not a word. 
          That is significant.<./q> ";
        //if (glob.(potentialScoreProp) > (glob.(initialPsp) - 20))
        //  glob.(potentialScoreProp) = glob.(initialPsp) - 20;
        break;
      case 4:
        "Sheila says, <.q>Let<./s>s consider an example. 
          If you<./s>re in a room with an artifact 
          that<./s>s shaped like <.s>TR-AT,<./s> and then 
          you try to go south, it would reply by saying, 
          <.s><.q>Trsat<./q> is not a word.<./s> 
          And, incidentally, it would also deliver me 
          an excruciating blow, which I<./s>d certainly rather 
          avoid.<./q> ";
        //if (glob.(potentialScoreProp) > (glob.(initialPsp) - 30))
        //  glob.(potentialScoreProp) = glob.(initialPsp) - 30;
        break;
      case 5:
        "Sheila says, <.q>Basically, in this maze, 
          you need to move around so that the corresponding 
          abbreviation for where you walk--N, S, NW, SE, etc.--fills in 
          the blanks, so to speak, of the room<./s>s artifact, 
          in order to form a word. Up and down don<./s>t work; 
          only the eight compass directions do. 
          You<./s>ll find that many rooms have more than two exits, 
          while some only have one. So this is indeed a maze, 
          and it may take some time to navigate it.<./q> ";
        //if (glob.(potentialScoreProp) > (glob.(initialPsp) - 40))
        //  glob.(potentialScoreProp) = glob.(initialPsp) - 40;
        break;
      default:
        if (!specificHintSet.indexOf(curRoom)) {
          "Sheila says, <.q>All I can do at this point 
            is reveal the full solution for this room.
            Is that what you want?<./q> ";
          if (!sayYesOrNo()) {
            "<.q>No problem,<./q> says Sheila. <.q>Back to the game, then!<./q> ";
          }
          else {
            giveCompleteSolution();
            specificHintSet.append(curRoom);
          }
        }
        else {
          giveCompleteSolution();
        }
        break;
      /*
      case 5:
        "Sheila says, <.q>I<./s>ve already told you all the hints I can.
          Now all I can do is reveal the full solution for this room.
          Is that what you want?<./q> ";
        if (!sayYesOrNo()) {
          "<.q>No problem,<./q> says Sheila. <.q>Back to the game, then!<./q> ";
          glob.(generalHintProp)--;
        }
        else {
          giveCompleteSolution();
        }
        break;
      default:
        giveCompleteSolution();
        break;
      */
    }
  }
  giveCompleteSolution {
    //getGeneratedWordForQuat(gPlayerChar.getOutermostRoom.artifactStr, asscDir);
    local okLst, thisDir;
    okLst = [];
    local dirLst = [
      northDirection, southDirection, eastDirection, westDirection,
      northeastDirection, southeastDirection, southwestDirection, northwestDirection
    ];
    for (local a = 1; a <= 8; a++) {
      //local k=0; 
      //k=k/k;
      thisDir = dirLst[a];
      //if (gPlayerChar.getOutermostRoom.(thisDir.dirProp) && 
      //    gPlayerChar.getOutermostRoom.(thisDir.dirProp).ofKind(QuatPassage))
      if (self.(thisDir.dirProp) == self)
        okLst = okLst + thisDir;
      //k=k/k;
    }
    "<.q>Well, the artifact here says <.s><<curString>>,<./s><./q> 
      replies Sheila. <.q>From that you ";
    if (okLst.length == 1)
      "can only make the word ";
    else
      "can make the words ";
    for (local a = 1; a <= okLst.length; a++) {
      "<.s>";
      //local k = 0; k=k/k;
      say(getGeneratedWordForQuat(curStringSimple, okLst[a]));
      if (a == okLst.length)
        ".";
      else if (okLst.length > 2)
        ",";
      "<./s> ";
      if (a == okLst.length - 1)
        "and ";
    }
    if (okLst.length == 1)
      "So, as it turns out, you can only go ";
    else
      "So you can go ";
    for (local a = 1; a <= okLst.length; a++) {
      say(okLst[a].name);
      if (okLst.length > 2 && a != okLst.length)
        ", ";
      if (a == okLst.length - 1)
        " and ";
    }
    " from here.<./q> ";
    // The following lines to deduct from the potential score have a
    // slight flaw. This is complicated, so it may not be easily 
    // understandable by people who are not me.
    // 
    // Suppose someone asks for all the help they can get on the maze's
    // first room, then wander around and later type RESET.
    // After the maze is reset, they then ask for help on the first room
    // again.
    // 
    // What *should* happen: 
    // 1. When the maze is reset, the potential score deduction from the
    //    first hint request should be retained.
    // 2. When the second hint request happens, the game should act 
    //    as though the first hint request never took place (despite the 
    //    fact that its having taken place is still reflected in the 
    //    potential score).
    // 3. However, when the second hint request happens, the game should
    //    *not* put the player in double jeopardy by decreasing the 
    //    potential score twice on account of getting the solution 
    //    for any individual room more than once.
    // 
    // What *does* happen:
    // 1 & 2 happen fine, but 3 doesn't. The player *is* put in double
    // jeopardy if they ask for hint requests for any individual room
    // both before and after resetting the maze.
    // 
    // However, I guess I don't care. I can't imagine anyone will 
    // notice this flaw.
    glob.(potentialScoreProp) = glob.(potentialScoreProp) - 15;
    if (glob.(potentialScoreProp) < 0)
      glob.(potentialScoreProp) = 0;
  }
  holeSound = 'the sound of a compass needle spinning'
  // This is a totally useless property. I include it only
  // for the sake of consistency with my old, outdated code
  // which presently I don't feel like changing.
  firstRoomInThisMaze = self
  // this property is meaningless now, but here it is, just 
  // for the sake of consistency
  firstRoomInThisMazeSet = self
  // return self if we can move in a given direction (1 for north, 2 
  // for northeast, etc.), or nil otherwise
  getDestFor(dir, dest, alternative) {
    if (roomList[curRoom][dir + 1] != nil)
      return dest;
    else
      return alternative;
  }
  // route all directional properties through getDestFor()
  north     = getDestFor(1, self, harmfulQuatTravelNorth)
  northeast = getDestFor(2, self, harmfulQuatTravelNortheast)
  east      = getDestFor(3, self, harmfulQuatTravelEast)
  southeast = getDestFor(4, self, harmfulQuatTravelSoutheast)
  south     = getDestFor(5, self, harmfulQuatTravelSouth)
  southwest = getDestFor(6, self, harmfulQuatTravelSouthwest)
  west      = getDestFor(7, self, harmfulQuatTravelWest)
  northwest = getDestFor(8, self, harmfulQuatTravelNorthwest)
  up        = getDestFor(9, niceTryQuatUp, noQuatUp)
  down      = (quatHole.isIn(self) ? quatHole :
              getDestFor(10, niceTryQuatDown, noQuatDown))
;

modify glob
  quat1HintState = 0
  quat2HintState = 0
  botHasBeenZapped = nil
  botHasJustBeenZapped = nil
  hackQuat1Map = nil
  hackQuat2Map = nil
;

// The following modifications were made already in 2bookmovie.t:

//modify northDirection     clockwiseOrder =  1;
//modify northeastDirection clockwiseOrder =  2;
//modify eastDirection      clockwiseOrder =  3;
//modify southeastDirection clockwiseOrder =  4;
//modify southDirection     clockwiseOrder =  5;
//modify southwestDirection clockwiseOrder =  6;
//modify westDirection      clockwiseOrder =  7;
//modify northwestDirection clockwiseOrder =  8;
//modify upDirection        clockwiseOrder =  9;
//modify downDirection      clockwiseOrder = 10;

modify northDirection     quatLetters = 'N' ;
modify southDirection     quatLetters = 'S' ;
modify eastDirection      quatLetters = 'E' ;
modify westDirection      quatLetters = 'W' ;
modify northeastDirection quatLetters = 'NE';
modify northwestDirection quatLetters = 'NW';
modify southeastDirection quatLetters = 'SE';
modify southwestDirection quatLetters = 'SW';

// -------------------------------------------------------------------
// The Mazes: QuatMaze objects
// -------------------------------------------------------------------

quat1Maze: QuatMaze
  bannerValue = quat1
  generalHintProp = &quat1HintState
  //generalHintState = 0
  potentialScoreProp = &potentialScoreQuat1
  initialPsp = &initialPotentialScoreQuat1
  startingRoom = 3
  endingRoom = 71
  roomList = [
    //      string     N   NE  E   SE  S   SW  W   NW  UP   DOWN
    /* 1*/['CRO-'     ,nil,7  ,nil,nil,nil,nil,6  ,nil, nil ,nil ],
    /* 2*/['CA-O-'    ,7  ,8  ,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /* 3*/['-OUN'     ,8  ,nil,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /* 4*/['I-K'      ,9  ,nil,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /* 5*/['K-E-'     ,nil,11 ,nil,nil,nil,nil,nil,9  , nil ,nil ],
    /* 6*/['INVE-TOR' ,12 ,nil,nil,nil,1  ,nil,nil,nil, nil ,nil ],
    /* 7*/['-ERVE'    ,13 ,nil,nil,nil,2  ,1  ,nil,nil, nil ,nil ],
    /* 8*/['-IMMER'   ,nil,nil,nil,nil,3  ,2  ,nil,nil, nil ,true],
    /* 9*/['RE-T'     ,15 ,nil,nil,5  ,4  ,nil,nil,nil, nil ,nil ],
    /*10*/['TE-'      ,16 ,nil,11 ,nil,nil,nil,nil,nil, nil ,true],
    /*11*/['-ORD'     ,nil,nil,nil,nil,nil,5  ,10 ,nil, nil ,nil ],
    /*12*/['-IC-'     ,nil,19 ,nil,nil,6  ,nil,nil,nil, nil ,nil ],
    /*13*/['IN-RT'    ,nil,nil,14 ,7  ,nil,nil,nil,nil, nil ,nil ],
    /*14*/['FA-NING'  ,20 ,nil,nil,nil,nil,nil,13 ,nil, nil ,nil ],
    /*15*/['-AP-'     ,nil,22 ,nil,nil,9  ,nil,nil,nil, nil ,nil ],
    /*16*/['-AS-'     ,nil,nil,17 ,nil,10 ,nil,nil,nil, nil ,nil ],
    /*17*/['LE-D'     ,23 ,nil,nil,nil,nil,nil,16 ,nil, true,nil ],
    /*18*/['SCOR-'    ,24 ,nil,19 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*19*/['-ARMING'  ,nil,nil,nil,nil,nil,12 ,18 ,nil, nil ,nil ],
    /*20*/['-AGA-'    ,nil,nil,nil,nil,14 ,nil,nil,nil, nil ,nil ],
    /*21*/['PLA-T'    ,27 ,28 ,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /*22*/['-ABBED'   ,28 ,nil,nil,nil,nil,15 ,nil,nil, nil ,true],
    /*23*/['-IP'      ,29 ,nil,nil,nil,17 ,nil,nil,nil, nil ,true],
    /*24*/['TE-T'     ,30 ,31 ,nil,nil,18 ,nil,nil,nil, nil ,nil ],
    /*25*/['SPI-'     ,31 ,32 ,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /*26*/['OVERTUR-' ,32 ,nil,27 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*27*/['-HALE'    ,nil,nil,nil,nil,21 ,nil,26 ,nil, nil ,nil ],
    /*28*/['-OON'     ,34 ,nil,nil,nil,22 ,21 ,nil,nil, nil ,nil ],
    /*29*/['-AME'     ,39 ,nil,nil,nil,23 ,nil,nil,nil, nil ,true],
    /*30*/['TO--'     ,nil,36 ,nil,nil,24 ,nil,nil,nil, nil ,nil ],
    /*31*/['-IFT'     ,nil,nil,nil,nil,25 ,24 ,nil,nil, nil ,nil ],
    /*32*/['PE-TER'   ,nil,nil,nil,nil,26 ,nil,25 ,nil, nil ,nil ],
    /*33*/['SE-N'     ,nil,nil,34 ,nil,nil,nil,37 ,nil, nil ,nil ],
    /*34*/['-OLVES'   ,nil,nil,nil,nil,28 ,nil,33 ,nil, nil ,nil ],
    /*35*/['-ARL'     ,nil,nil,36 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*36*/['-O-'      ,nil,nil,nil,nil,nil,30 ,35 ,41 , nil ,nil ],
    /*37*/['TREATI-S' ,nil,nil,38 ,33 ,nil,nil,nil,nil, nil ,nil ],
    /*38*/['PO-DER'   ,46 ,nil,nil,nil,nil,nil,37 ,nil, nil ,nil ],
    /*39*/['MORO-'    ,47 ,nil,nil,29 ,nil,nil,nil,nil, nil ,nil ],
    /*40*/['G-A-'     ,nil,nil,nil,nil,nil,nil,nil,47 , nil ,nil ],
    /*41*/['U-LESS'   ,49 ,nil,nil,36 ,nil,nil,nil,nil, nil ,nil ],
    /*42*/['HOU-D'    ,50 ,nil,nil,43 ,nil,nil,nil,nil, nil ,nil ],
    /*43*/['U-ISE'    ,nil,nil,nil,nil,nil,nil,nil,42 , nil ,nil ],
    /*44*/['-N-MY'    ,nil,nil,45 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*45*/['-IN'      ,nil,nil,nil,nil,46 ,nil,44 ,nil, nil ,true],
    /*46*/['BASI-'    ,45 ,nil,nil,nil,38 ,nil,nil,nil, nil ,nil ],
    /*47*/['MO--Y'    ,nil,54 ,nil,40 ,39 ,nil,nil,nil, nil ,nil ],
    /*48*/['GU-'      ,54 ,nil,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /*49*/['BAR-'     ,55 ,nil,50 ,nil,41 ,nil,nil,nil, nil ,true],
    /*50*/['-AILING'  ,56 ,nil,nil,nil,42 ,nil,49 ,nil, nil ,nil ],
    /*51*/['EVE-T'    ,57 ,nil,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /*52*/['FU-'      ,58 ,nil,nil,53 ,nil,nil,nil,nil, nil ,true],
    /*53*/['THRE-'    ,nil,nil,54 ,nil,nil,nil,52 ,nil, nil ,nil ],
    /*54*/['-EAR'     ,60 ,nil,nil,nil,48 ,47 ,53 ,nil, nil ,true],
    /*55*/['DETE-T-'  ,nil,62 ,nil,nil,49 ,nil,nil,nil, nil ,nil ],
    /*56*/['-LUM-'    ,nil,nil,nil,nil,50 ,nil,nil,nil, nil ,nil ],
    /*57*/['-LOPING'  ,nil,nil,58 ,nil,51 ,nil,nil,nil, nil ,nil ],
    /*58*/['-ON'      ,nil,65 ,59 ,nil,52 ,nil,57 ,nil, nil ,true],
    /*59*/['-AIVE'    ,66 ,nil,nil,nil,nil,nil,58 ,nil, nil ,nil ],
    /*60*/['MI-T'     ,67 ,nil,nil,nil,54 ,nil,nil,nil, nil ,nil ],
    /*61*/['K-EL'     ,nil,69 ,62 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*62*/['-HY'      ,nil,nil,nil,nil,55 ,nil,61 ,nil, nil ,nil ],
    /*63*/['BLE-D'    ,70 ,nil,64 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*64*/['SA-'      ,nil,72 ,nil,nil,nil,nil,63 ,nil, true,true],
    /*65*/['-RF'      ,nil,nil,nil,58 ,nil,nil,nil,nil, nil ,nil ],
    /*66*/['-IGH'     ,73 ,74 ,nil,nil,59 ,nil,nil,nil, nil ,nil ],
    /*67*/['-PA'      ,nil,nil,nil,nil,60 ,nil,nil,nil, nil ,nil ],
    /*68*/['P-A'      ,nil,nil,69 ,nil,nil,nil,nil,nil, nil ,true],
    /*69*/['-IG'      ,nil,nil,nil,nil,nil,61 ,68 ,nil, nil ,true],
    /*70*/['-QUAT-'   ,nil,nil,71 ,nil,63 ,nil,nil,nil, nil ,nil ],
    /*71*/['A-AY'     ,nil,nil,nil,nil,nil,nil,70 ,nil, nil ,nil ],
    /*72*/['-PE-'     ,nil,nil,73 ,nil,nil,64 ,nil,nil, nil ,nil ],
    /*73*/['-EEK'     ,nil,nil,nil,nil,66 ,nil,72 ,nil, nil ,nil ],
    /*74*/['-OOP'     ,nil,nil,nil,nil,nil,66 ,nil,nil, nil ,nil ]
  ]
;
quat2Maze: QuatMaze
  bannerValue = quat2
  generalHintProp = &quat2HintState
  //generalHintState = 0
  potentialScoreProp = &potentialScoreQuat2
  initialPsp = &initialPotentialScoreQuat2
  startingRoom = 4
  endingRoom = 78
  roomList = [
    //      string     N   NE  E   SE  S   SW  W   NW   UP   DOWN
    /* 1*/['DI-ER'    ,8  ,nil,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /* 2*/['TO-'      ,9  ,10 ,3  ,nil,nil,nil,8  ,nil, nil ,true],
    /* 3*/['A-L'      ,nil,nil,nil,nil,nil,nil,2  ,nil, nil ,nil ],
    /* 4*/['-OISE'    ,11 ,nil,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /* 5*/['I--ARDS'  ,12 ,nil,nil,nil,nil,nil,nil,11 , nil ,nil ],
    /* 6*/['S-AT'     ,nil,nil,7  ,nil,nil,nil,12 ,nil, nil ,nil ],
    /* 7*/['ME-'      ,14 ,nil,nil,nil,nil,nil,6  ,nil, nil ,nil ],
    /* 8*/['BROW-'    ,15 ,nil,nil,2  ,1  ,nil,nil,nil, nil ,nil ],
    /* 9*/['FU--Y'    ,16 ,nil,nil,nil,2  ,nil,nil,nil, nil ,nil ],
    /*10*/['I-'       ,20 ,nil,nil,nil,2  ,nil,nil,nil, nil ,true],
    /*11*/['CLEAN-'   ,nil,nil,nil,5  ,4  ,nil,nil,nil, nil ,nil ],
    /*12*/['LO--'     ,nil,18 ,nil,6  ,5  ,nil,nil,nil, nil ,nil ],
    /*13*/['DE-D'     ,nil,nil,14 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*14*/['-AD'      ,nil,nil,nil,nil,7  ,nil,13 ,nil, nil ,true],
    /*15*/['BU-'      ,21 ,nil,nil,nil,8  ,nil,nil,nil, nil ,true],
    /*16*/['-ERI-'    ,nil,nil,9  ,nil,nil,nil,nil,nil, nil ,nil ],
    /*17*/['-ARRING'  ,nil,nil,18 ,nil,nil,nil,20 ,nil, nil ,nil ],
    /*18*/['-AVES'    ,26 ,nil,19 ,nil,12 ,nil,17 ,nil, nil ,nil ],
    /*19*/['S-IVELING',27 ,nil,nil,nil,nil,nil,18 ,nil, nil ,nil ],
    /*20*/['-UIT-'    ,nil,nil,nil,17 ,10 ,nil,nil,nil, nil ,nil ],
    /*21*/['AXI-'     ,nil,nil,nil,nil,15 ,nil,nil,nil, nil ,nil ],
    /*22*/['VI-TAGE'  ,30 ,nil,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /*23*/['HUMA-'    ,30 ,31 ,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /*24*/['PO-D'     ,31 ,nil,nil,25 ,nil,nil,nil,nil, nil ,nil ],
    /*25*/['STO-'     ,nil,32 ,nil,nil,nil,nil,24 ,nil, nil ,nil ],
    /*26*/['-UD-'     ,nil,34 ,nil,nil,18 ,nil,nil,nil, nil ,nil ],
    /*27*/['-IX'      ,34 ,nil,nil,nil,19 ,nil,nil,nil, nil ,nil ],
    /*28*/['DI-'      ,40 ,35 ,29 ,nil,nil,nil,nil,nil, nil ,true],
    /*29*/['FLE-'     ,nil,nil,30 ,nil,nil,nil,28 ,nil, nil ,true],
    /*30*/['-INGS'    ,nil,nil,nil,nil,23 ,22 ,29 ,nil, nil ,true],
    /*31*/['CA-HE-'   ,nil,nil,nil,nil,24 ,23 ,nil,nil, nil ,nil ],
    /*32*/['-VER'     ,nil,38 ,33 ,25 ,nil,nil,nil,nil, nil ,nil ],
    /*33*/['-ATERY'   ,nil,nil,34 ,nil,nil,nil,32 ,nil, nil ,nil ],
    /*34*/['-ADDLING' ,nil,nil,nil,nil,27 ,26 ,33 ,nil, nil ,true],
    /*35*/['-ARTHY'   ,nil,nil,42 ,nil,nil,28 ,nil,nil, nil ,nil ],
    /*36*/['-ACH'     ,nil,nil,37 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*37*/['-ORM'     ,43 ,nil,nil,nil,nil,nil,36 ,nil, nil ,true],
    /*38*/['-ARN'     ,nil,nil,39 ,nil,nil,nil,32 ,nil, nil ,true],
    /*39*/['GALLO-S'  ,45 ,nil,nil,nil,nil,nil,38 ,nil, nil ,nil ],
    /*40*/['CONTE-T'  ,46 ,nil,nil,nil,28 ,nil,nil,nil, nil ,nil ],
    /*41*/['GE-'      ,nil,48 ,42 ,nil,nil,nil,nil,nil, nil ,true],
    /*42*/['CRA-S'    ,nil,55 ,nil,nil,35 ,nil,41 ,nil, nil ,nil ],
    /*43*/['BASSI-T'  ,nil,50 ,nil,nil,37 ,nil,nil,nil, nil ,nil ],
    /*44*/['SHRI-K'   ,50 ,nil,45 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*45*/['LO-ER'    ,51 ,nil,nil,nil,39 ,nil,44 ,nil, nil ,nil ],
    /*46*/['THI-'     ,52 ,53 ,nil,nil,40 ,nil,nil,nil, nil ,nil ],
    /*47*/['I--'      ,53 ,nil,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /*48*/['-NO-'     ,nil,nil,nil,nil,nil,41 ,nil,nil, nil ,nil ],
    /*49*/['SI-K'     ,55 ,nil,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /*50*/['-AKE'     ,nil,nil,nil,nil,44 ,nil,43 ,nil, nil ,nil ],
    /*51*/['-AFER'    ,nil,nil,nil,nil,45 ,nil,56 ,nil, nil ,nil ],
    /*52*/['PA--ED'   ,57 ,nil,nil,nil,46 ,nil,nil,nil, nil ,true],
    /*53*/['-UNG'     ,nil,nil,nil,nil,47 ,46 ,nil,nil, nil ,true],
    /*54*/['CROW-D'   ,nil,60 ,55 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*55*/['-EEPING'  ,nil,nil,nil,nil,49 ,42 ,54 ,nil, nil ,nil ],
    /*56*/['FRO-TI-R' ,nil,62 ,nil,51 ,nil,nil,nil,nil, nil ,nil ],
    /*57*/['-ISH'     ,nil,nil,nil,nil,nil,52 ,63 ,nil, nil ,true],
    /*58*/['GLE-'     ,65 ,nil,59 ,nil,nil,nil,nil,nil, nil ,true],
    /*59*/['LO-LY'    ,nil,67 ,nil,nil,nil,nil,58 ,nil, nil ,nil ],
    /*60*/['-ASP'     ,nil,nil,nil,nil,nil,nil,54 ,nil, nil ,nil ],
    /*61*/['SE-TRY'   ,62 ,nil,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /*62*/['-IT'      ,69 ,nil,nil,nil,56 ,nil,61 ,nil, true,true],
    /*63*/['SA--'     ,nil,70 ,nil,nil,57 ,nil,nil,nil, nil ,nil ],
    /*64*/['A-Y'      ,70 ,nil,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /*65*/['U-ED'     ,nil,nil,nil,nil,58 ,nil,nil,70 , nil ,nil ],
    /*66*/['S-IP'     ,71 ,nil,nil,nil,nil,nil,nil,nil, nil ,nil ],
    /*67*/['RE-O-N'   ,nil,nil,nil,nil,nil,59 ,nil,72 , nil ,nil ],
    /*68*/['OW-'      ,74 ,nil,69 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*69*/['-ICK'     ,75 ,nil,nil,nil,62 ,nil,68 ,nil, nil ,true],
    /*70*/['-AT'      ,nil,77 ,71 ,65 ,64 ,63 ,nil,nil, nil ,nil ],
    /*71*/['-AS'      ,nil,nil,nil,66 ,nil,nil,70 ,nil, nil ,nil ],
    /*72*/['HEAVE-'   ,78 ,nil,nil,nil,67 ,nil,nil,nil, nil ,true],
    /*73*/['-VE'      ,nil,nil,74 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*74*/['-AND'     ,nil,nil,nil,nil,68 ,nil,73 ,nil, nil ,nil ],
    /*75*/['-EDY'     ,nil,81 ,nil,69 ,nil,nil,nil,nil, nil ,nil ],
    /*76*/['CALORI-'  ,nil,nil,77 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*77*/['-ITCHES'  ,nil,nil,nil,nil,nil,70 ,76 ,nil, nil ,nil ],
    /*78*/['EGRE--'   ,nil,nil,nil,nil,72 ,nil,nil,nil, nil ,nil ],
    /*79*/['AR-A'     ,nil,nil,80 ,nil,nil,nil,nil,nil, nil ,nil ],
    /*80*/['-IDER'    ,nil,nil,81 ,nil,nil,nil,79 ,nil, nil ,nil ],
    /*81*/['BURRO-'   ,nil,nil,nil,nil,75 ,nil,80 ,nil, nil ,nil ]
  ]
;

// -------------------------------------------------------------------
// Scenery: The hole
// -------------------------------------------------------------------

quatHole: StairwayDown
  vocabWords = 'hole'
  name = 'hole'
  specialDesc = "There is a hole in the floor here. "
  desc = "The hole is rather wide, and goes down into the floor 
    so far that it disappears into darkness. 
    There are no handholds in it, so be careful.
    If you went there, I can't imagine how you'd ever
    get back up again. "
  soundDesc {
    "From deep inside the hole, your bot thinks she can hear 
      the sound of a hollow cave. ";
  }
  dobjFor(LookThrough) {
    action() {
      "The hole goes down, way down, vanishing into darkness. ";
    }
  }
  dobjFor(Enter) remapTo(TravelVia, self)
  dobjFor(TravelVia) {
    action {
      local str;
      if (!glob.botHasBeenZapped) {
        "<.q>Well, I guess it<./s>s now or never!<./q> cries Sheila. 
            <.q>See you on the other side!<./q> 
          <p>With that, she wheels herself up the hole,
            then gingerly rolls over the edge 
            and plummets down and down\ .\ .\ . ";
        str = 'Whew! That took a while, but now we<./s>re back.';
      }
      else {
        "<.q>What, you mean I get to jump down a bottomless pit?<./q> 
            Sheila says with undisguised eagerness. 
            <.q>Compared to lightning blasts, 
            that sounds downright fun! 
            No need to tell me twice!<./q>
          <p>With that, she promptly jumps into the hole 
            and plummets down and down\ .\ .\ . ";
        str = 'Whew! Well, at least now we<./s>re done with 
          the lightning blasts. Or so I hope.';
      }
      returnToCaveVictoriously(str);
    }
  }
;

// -------------------------------------------------------------------
// Scenery: Pedestals and artifacts
// -------------------------------------------------------------------

//quatPedestal: MultiFaceted
//  initialLocationClass = QuatMaze
//  instanceObject: Surface, Fixture {
//    '(ordinary) square pedestal/dais/pillar/base/ped/foundation/platform'
//    'pedestal'
//    desc {
//      "It<./s>s an ordinary square pedestal, set in the middle of the room. 
//        On the pedestal is an artifact. ";
//    }
//  }
//;


// Since I see no possibility of these changing in unpredictable 
// ways -- e.g., I won't allow anyone to put anything on the 
// pedestals -- I can get away with making the pedestals and the 
// artifacts MultiLoc, rather than MultiFaceted, objects.
class QuatPedestal: Surface, Fixture
  '(ordinary) square pedestal/dais/pillar/base/ped/foundation/platform'
  'pedestal'
  desc {
    "It<./s>s an ordinary square pedestal, set 
      in the middle of the room. ";
    //"On the pedestal is an artifact. ";
  }
  // Artifacts are never specially listed as being "on the pedestal" 
  // in room descriptions (though they are listed as such if you type
  // X PEDESTAL), because the room description already says where
  // the artifact is.
  // This creates a problem when you put something on one of the 
  // pedestals. In order not to give any sentences that would seem
  // to falsely imply that there is no artifact on the pedestal, 
  // change, e.g., "On the pedestal is a scarf", to "*Also* on the pedestal
  // is a scarf".
  contentsLister: surfaceContentsLister {
    showListPrefixWide(itemCount, pov, parent)
      { "Also on <<parent.theNameObj>> <<itemCount == 1 ? 'is' : 'are'>> "; }
    showListPrefixTall(itemCount, pov, parent)
      { "Also on <<parent.theNameObj>> <<itemCount == 1 ? 'is' : 'are'>>:"; }
  }
;
quat1Pedestal: QuatPedestal
  location = quat1Maze
;
quat2Pedestal: QuatPedestal
  location = quat2Maze
;
quatArtifact: MultiLoc, Fixture
  '(hard) (large) white plastic faint glow/artifact'
  'artifact'
  initialLocationClass = QuatPedestal
  desc = 
    "The artifact is made of hard white plastic, and emits a very faint glow.
      It has been shaped in such a way as to spell 
      <.q><<gPlayerChar.getOutermostRoom.curString>>.<./q> "
  isListed = nil
  isListedInContents = true
  isListedInInventory = nil
  //isListed { return isListedInContents; }
  //isListedInContents { return !useSpecialDesc(); }
  //isListedInInventory { return true; }
;

// -------------------------------------------------------------------
// NoTravelMessage stuff: HarmfulQuatTravel
// -------------------------------------------------------------------

class HarmfulQuatTravel: NoTravelMessage
  travelDesc {
    glob.quatJeopardy++;
    glob.sayQuatPassRemark(self, nil);
    giveZapMessage;
    //"<p>If this were an actual game, Sheila would now have gotten zapped. ";
  }
  //pertainsToQuat1 = nil
  //pertainsToQuat2 = nil
  giveZapMessage {
    // --------------------------
    // Paragraph 1:
    // Sheila wheels off that way, but soon...
    "<.p>Sheila wheels off cautiously <<glob.givePassDir(self)>>, 
      but soon ";
    
    // ...a soft hum/a deafening buzz...
    if (glob.quatJeopardy < glob.quatDeathLevel) {
      switch (glob.quatJeopardy) {
        case 1:  "a soft hum"; break;
        case 2:  "a moderate hum"; break;
        case 3:  "a loud hum"; break;
        default: "a fierce buzz"; break;
      }
    }
    else {
      "a deafening buzz";
    }
    
    // ...comes from the artifact, and it shoots out...
    " comes from the artifact,
      and it shoots out ";
    
    // ...a bolt, which zaps Sheila.
    if (glob.quatJeopardy < glob.quatDeathLevel) {
      switch (glob.quatJeopardy) {
        case 1:
          "a small lightning bolt, which zaps Sheila 
            in the back. ";
          break;
        case 2:
          "a good-sized lightning bolt, which gives Sheila 
            a very powerful zap. ";
          break;
        case 3:
          "a huge lightning bolt, zapping Sheila with
            such force that she is momentarily sent reeling 
            before she catches herself. ";
          break;
        default:
          "a torrent of lightning, which strikes Sheila 
            with a blinding flash, knocking her to the floor. ";
          break;
      }
    }
    else {
      "a monumental cascade of lightning, which strikes Sheila 
        with a blinding flash, knocking her to the floor. 
        This time, she does not get up. ";
      endGame(ftDeath);
      return;
    }
    
    // --------------------------
    // Paragraph 2
    // Sheila lets out yelp. "Yow! That hurt!"
    if (glob.quatJeopardy < glob.quatDeathLevel) {
      switch (glob.quatJeopardy) {
        case 1:
          "<p>Sheila lets out a yelp, then says,
            <.q>Wow! That hurt!<./q> ";
          break;
        case 2:
          "<p>Sheila lets out a howl, then shouts,
            <.q>Yow! Was that ever painful!<./q> ";
          break;
        case 3:
          "<p>Sheila lets out an anguished shriek, then cries,
            <.q>My God, did that ever hurt!<./q> ";
          break;
        default:
          "<p>After a few moments, Sheila hobbles up from the floor, 
            whispering, <.q>Please, no more.<./q> ";
          break;
      }
    }
    
    // --------------------------
    // Paragraph 3
    // "That is not a valid word," says the artifact.
    if (glob.quatJeopardy < glob.quatDeathLevel) {
      "<p><.q><.s>\^";
      say(getGeneratedWordForQuat(
        gPlayerChar.getOutermostRoom.curStringSimple, asscDir));
      "<./s> is not a valid word,<./q> 
        replies the artifact impassively. ";
    }
    
    // --------------------------
    // Paragraph 4
    // Sheila glares angrily at the artifact.
    if (glob.quatJeopardy == glob.quatDeathLevel - 2) {
      "<p>Sheila glares angrily at the artifact. ";
    }
    else if (glob.quatJeopardy == glob.quatDeathLevel - 1) {
      "<p>Sheila glares angrily at the artifact. Then, slowly,
        she straightens her posture, until finally she seems to regain
        most of her composure. ";
    }
    glob.botHasBeenZapped = true;
    glob.botHasJustBeenZapped = true;
    glob.quatJeopardyOffset = 0;
  }
;

harmfulQuatTravelNorth    : HarmfulQuatTravel asscDir=northDirection    ;
harmfulQuatTravelNortheast: HarmfulQuatTravel asscDir=northeastDirection;
harmfulQuatTravelEast     : HarmfulQuatTravel asscDir=eastDirection     ;
harmfulQuatTravelSoutheast: HarmfulQuatTravel asscDir=southeastDirection;
harmfulQuatTravelSouth    : HarmfulQuatTravel asscDir=southDirection    ;
harmfulQuatTravelSouthwest: HarmfulQuatTravel asscDir=southwestDirection;
harmfulQuatTravelWest     : HarmfulQuatTravel asscDir=westDirection     ;
harmfulQuatTravelNorthwest: HarmfulQuatTravel asscDir=northwestDirection;

modify glob
  quatJeopardy = 0
  //quat1Jeopardy = 0
  //quat2Jeopardy = 0
  quatJeopardyOffset = 0
  quatDeathLevel = 5
;

modify glob
  quat1PassCount = 0
  quat2PassCount = 0
  sayQuatPassRemark(psg, successful) {
    local passCount;
    if (gPlayerChar.getOutermostRoom == quat1Maze) {
      if (glob.quat1PassCount < 10)
        glob.quat1PassCount++;
      passCount = glob.quat1PassCount;
    }
    else { // the quat2 maze
      if (glob.quat2PassCount < 10)
        glob.quat2PassCount++;
      passCount = glob.quat2PassCount;
    }
    switch (passCount) {
      case 1:
        "<.q>It<./s>s too dark for me to tell if there<./s>s 
          an exit in that direction,<./q> says Sheila. 
          <.q>But let me walk that way and see what happens.<./q> ";
        if (successful) {
          "<p>Cautiously, Sheila heads off <<givePassDir(psg)>>, 
            and soon finds herself in another room. ";
        }
        break;
      case 2:
      case 3:
      case 4:
      case 5:
        "<.q>Okay, I<./s>ll try going that way through the darkness,<./q>
          says Sheila";
        if (successful)
          ", and she cautiously heads off <<givePassDir(psg)>>";
        ". ";
        break;
      //default:
    }
  }
  // give a phrase describing the direction of movement.
  // psg is now a dummy variable, no longer used. I could
  // get rid of it, but I'm lazy.
  givePassDir(psg) {
    local dir;
    if (gAction && gAction.getDirection())
      dir = gAction.getDirection();
    else if (gAction && gAction.parentAction 
             && gAction.parentAction.getDirection())
      dir = gAction.parentAction.getDirection();
    if (!dir)
      "that way";
    else
      "to the <<dir.name>>";
  }
//  givePassDir(psg) {
//    if (psg.ofKind(Passage)) {
//      if      (psg.location.north     == psg) "to the north";
//      else if (psg.location.ne        == psg
//            || psg.location.northeast == psg) "to the northeast";
//      else if (psg.location.east      == psg) "to the east";
//      else if (psg.location.southeast == psg) "to the southeast";
//      else if (psg.location.south     == psg) "to the south";
//      else if (psg.location.southwest == psg) "to the southwest";
//      else if (psg.location.west      == psg) "to the west";
//      else if (psg.location.northwest == psg) "to the northwest";
//      else "in that direction";
//    }
////    // Otherwise, this is presumably a NoTravelMessage.
////    else {
////      local prnt;
////      prnt = gAction;
////      for (;;) {
////        if (prnt.parentAction)
////          prnt = prnt.parentAction;
////        else
////          break;
////      }
////      if (prnt && prnt.dirMatch) {
////        switch (prnt.dirMatch.dir) {
////          case northDirection:     "to the north";      break;
////          case neDirection:
////          case northeastDirection: "to the northeast";  break;
////          case eastDirection:      "to the east";       break;
////          case southeastDirection: "to the southeast";  break;
////          case southDirection:     "to the south";      break;
////          case southwestDirection: "to the southwest";  break;
////          case westDirection:      "to the west";       break;
////          case northwestDirection: "to the northwest";  break;
////          default:                 "in that direction"; break;
////        }
////      }
////      else 
////        "in that direction";
////    }
//    else if (psg.asscDir) {
//      switch (psg.asscDir) {
//        case northDirection    : "to the north";      break;
//        case northeastDirection: "to the northeast";  break;
//        case eastDirection     : "to the east";       break;
//        case southeastDirection: "to the southeast";  break;
//        case southDirection    : "to the south";      break;
//        case southwestDirection: "to the southwest";  break;
//        case westDirection     : "to the west";       break;
//        case northwestDirection: "to the northwest";  break;
//        default:                 "in that direction"; break;
//      }
//    }
//    else 
//      "in that direction";
//  }
//  givePassDir2(psg) {
//    if (psg.ofKind(Passage)) {
//      if      (psg.location.north     == psg) return 1;
//      else if (psg.location.ne        == psg
//            || psg.location.northeast == psg) return 2;
//      else if (psg.location.east      == psg) return 3;
//      else if (psg.location.southeast == psg) return 4;
//      else if (psg.location.south     == psg) return 5;
//      else if (psg.location.southwest == psg) return 6;
//      else if (psg.location.west      == psg) return 7;
//      else if (psg.location.northwest == psg) return 8;
//      else return 9;
//    }
//    // Otherwise, this is presumably a NoTravelMessage.
//    else {
//      if (gAction && gAction.parentAction && gAction.parentAction.dirMatch) {
//        switch (gAction.parentAction.dirMatch.dir) {
//          case northDirection:     return 10;
//          case northeastDirection: return 11;
//          case eastDirection:      return 12;
//          case southeastDirection: return 13;
//          case southDirection:     return 14;
//          case southwestDirection: return 15;
//          case westDirection:      return 16;
//          case northwestDirection: return 17;
//          default:                 return 18;
//        }
//      }
//      return 19;
//    }
//  }
;

// -------------------------------------------------------------------
// NoTravelMessage stuff: QuatUpDownTravel
// -------------------------------------------------------------------

class QuatUpDownTravel: NoTravelMessage
  travelDesc {
    if (isNiceTry)
      "<.q>That<./s>s a nice try,<./q> says Sheila, 
        <.q>but there<./s>s no staircase here to 
        <<goesUp ? 'ascend' : 'descend'>>.<./q> ";
    else
      "<.q>There<./s>s no staircase here to 
        <<goesUp ? 'ascend' : 'descend'>>,<./q>
        says Sheila. ";
  }
  goesUp = nil
  isNiceTry = nil
;
noQuatDown: QuatUpDownTravel
;
noQuatUp: QuatUpDownTravel
  goesUp = true
;
niceTryQuatDown: QuatUpDownTravel
  isNiceTry = true
;
niceTryQuatUp: QuatUpDownTravel
  goesUp = true
  isNiceTry = true
;

// -------------------------------------------------------------------
// Misc. stuff: getGeneratedWordForQuat()
// -------------------------------------------------------------------

getGeneratedWordForQuat(artStr, direc) {
  local endStr = '';
  local blankCount = 0;
  local firstBlank = nil;
  local twoBlanks = nil;
  // determine if there are two blanks in artStr.
  firstBlank = artStr.find('-');
  if (firstBlank && artStr.find('-', firstBlank + 1)) {
    twoBlanks = true;
  }
  for (local a = 1; a <= artStr.length; a++) {
    // If the character being examined is a letter, then 
    // simply add it to endStr.
    if (artStr.substr(a,1) != '-' /*&& artStr.substr(a,1) != '_'*/) {
      endStr = endStr + artStr.substr(a,1);
    }
    // If the character being examined is a blank, then
    // determine what to put there.
    else {
      blankCount++;
      // If the direction has a one-letter abbreviation
      // (N, S, E, or W), then simply add that abbreviation.
      if (direc.quatLetters.length == 1)
        endStr = endStr + direc.quatLetters;
      // If the direction has a two-letter abbreviation, then 
      // it depends on how many blanks there are in artifactStr.
      // If there's only one such blank, just add the whole
      // two-letter abbreviation.
      else if (!twoBlanks)
        endStr = endStr + direc.quatLetters;
      // If the direction has a two-letter abbreviation and
      // there are two blanks in artifactStr, then add either
      // the first or last letter of the abbreviation, 
      // depending on the value of blankCount.
      else
        endStr = endStr + direc.quatLetters.substr(blankCount, 1);
    }
  }
  return endStr.toLower;
}

// -------------------------------------------------------------------
// Misc. stuff: quatDaemon
// -------------------------------------------------------------------

quatDaemon: DaemonComponent
  location = nil
  daemonID = nil
  startDaemon {
    if (daemonID == nil) {
      daemonID = new Daemon(self, &daemon, 1);
      self.moveInto(gPlayerChar);
    }
  }
  daemon {
    if (glob.quatJeopardy == 0) {
      glob.quatJeopardyOffset = 0;
    }
    else if (!glob.botHasJustBeenZapped) {
      glob.quatJeopardyOffset++;
      if (glob.quatJeopardyOffset == jeopardyQuotient) {
        glob.quatJeopardyOffset = 0;
        glob.quatJeopardy--;
      }
    }
    glob.botHasJustBeenZapped = nil;
  }
  endDaemon {
    if (daemonID != nil) daemonID.removeEvent;
    daemonID = nil;
    self.moveInto(nil);
  }
  // jeopardyQuotient has to do with how much the zap intensity
  // diminishes when Sheila does not persist in going in bad directions.
  // For instance, suppose Sheila has just gone in bad directions
  // and been zapped as many times as possible without dying.
  // If jeopardyQuotient is 3, for instance, she will need to wait
  // three times before she can survive going in a bad direction again.
  jeopardyQuotient = 3
;

// -------------------------------------------------------------------
// Map: Ancillary map functions
// -------------------------------------------------------------------

//gQuatFile(str, roomLst, passageLst) {
gQuatFile(str, roomLst, passageLst, [args]) {
  local outermostRoom = gPlayerChar.getOutermostRoom;
  if (glob.hackQuat1Map) outermostRoom = quat1Maze;
  if (glob.hackQuat2Map) outermostRoom = quat2Maze;
  
  local ignoreCurLoc = nil;
  if (args.length && args[1] != nil)
    ignoreCurLoc = true;
  if(roomLst && roomLst.length() > 0) {
    for (local a = 1; a <= roomLst.length(); a++) {
      //str = str + gPlayerChar.getOutermostRoom.roomMapState(roomLst[a]);
      str = str + maybeGive1Or0(outermostRoom.roomMapState(roomLst[a]), ignoreCurLoc);
    }
  }
  if(passageLst && passageLst.length() > 0) {
    for (local a = 1; a <= passageLst.length(); a++) {
      str = str + outermostRoom.connMapState(passageLst[a][1],passageLst[a][2]);
    }
  }
  return str;
}

maybeGive1Or0(val, give1Or0) {
  // If we do not specifically say that non-1, non-0 values
  // are forbidden, then just return val.
  if (!give1Or0)
    return val;
  // If non-1, non-0 values are forbidden, then return 1 or 0
  // as appropriate.
  if (val)
    return 1;
  else
    return 0;
}

// -------------------------------------------------------------------
// Map: quat1MapPrint
// -------------------------------------------------------------------

quat1MapPrint() {
return '<table border="0" cellspacing="0" cellpadding="0">
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gQuatFile('q1l01-',['P-A'],[]) + '.png" width="29" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1l02-',[],[['-IG','P-A'],['-IG','K-EL']]) + '.png" width="23" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1l03-',['-IG'],[]) + '.png" width="43" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1l04-',['-QUAT-'],[['-QUAT-','A-AY']]) + '.png" width="69" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1l05-',['A-AY'],[]) + '.png" width="38" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1l06-',['-PE-'],[['-PE-','SA-']]) + '.png" width="54" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1l07-',['-EEK'],[['-EEK','-PE-']]) + '.png" width="53" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1l08-',['-OOP'],[['-IGH','-OOP']]) + '.png" width="57" height="17" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gQuatFile('q1k01-',['K-EL'],[['-IG','K-EL'],['-HY','K-EL']]) + '.png" width="49" height="53" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1k02-',['-HY'],[['-IG','K-EL'],['-HY','DETE-T-']]) + '.png" width="53" height="53" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1k03-',['BLE-D'],[['-QUAT-','BLE-D']]) + '.png" width="41" height="53" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1k04-',[],[['BLE-D','SA-']]) + '.png" width="29" height="53" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1k05-',['SA-'],[['-PE-','SA-']]) + '.png" width="49" height="53" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1k06-',['-RF'],[['-PE-','SA-'],['-ON','-RF']]) + '.png" width="55" height="53" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1k07-',['-IGH'],[['-EEK','-IGH'],['-IGH','-OOP'],['-AIVE','-IGH']]) + '.png" width="59" height="53" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1k08-',['-PA'],[['-PA','MI-T']]) + '.png" width="31" height="53" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gQuatFile('q1j01-',['DETE-T-'],[['-HY','DETE-T-'],['BAR-','DETE-T-']]) + '.png" width="71" height="26" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1j02-',['-LUM-'],[['-AILING','-LUM-']]) + '.png" width="68" height="26" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1j03-',['-LOPING'],[['-LOPING','EVE-T']]) + '.png" width="54" height="26" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1j04-',[],[['-LOPING','-ON']]) + '.png" width="25" height="26" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1j05-',['-ON'],[['-ON','FU-']]) + '.png" width="30" height="26" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1j06-',[],[['-ON','-RF'],['-AIVE','-ON']]) + '.png" width="25" height="26" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1j07-',['-AIVE'],[]) + '.png" width="58" height="26" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1j08-',['MI-T'],[['-PA','MI-T']]) + '.png" width="35" height="26" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gQuatFile('q1i01-',['BAR-'],[['BAR-','DETE-T-'],['BAR-','U-LESS']]) + '.png" width="44" height="39" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1i02-',[],[['-AILING','BAR-']]) + '.png" width="25" height="39" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1i03-',['-AILING'],[['-AILING','-LUM-'],['-AILING','HOU-D']]) + '.png" width="76" height="39" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1i04-',['EVE-T'],[['-LOPING','EVE-T']]) + '.png" width="74" height="39" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1i05-',['FU-'],[['-ON','FU-'],['FU-','THRE-']]) + '.png" width="50" height="39" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1i06-',['THRE-'],[]) + '.png" width="43" height="39" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1i07-',[],[['-EAR','THRE-'],['-EAR','MO--Y']]) + '.png" width="19" height="39" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1i08-',['-EAR'],[['-EAR','MI-T']]) + '.png" width="35" height="39" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gQuatFile('q1h01-',['U-LESS'],[['BAR-','U-LESS'],['-O-','U-LESS']]) + '.png" width="70" height="50" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1h02-',['HOU-D'],[['-AILING','HOU-D']]) + '.png" width="45" height="50" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1h03-',['HOU-D','U-ISE'],[['HOU-D','U-ISE']],true) + '.png" width="14" height="50" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1h04-',['-N-MY','U-ISE'],[]) + '.png" width="62" height="50" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1h05-',['BASI-'],[['-IN','-N-MY']]) + '.png" width="19" height="50" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1h06-',['-IN','BASI-'],[['-IN','BASI-']]) + '.png" width="53" height="50" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1h07-',['MO--Y'],[['-EAR','MO--Y'],['G-A-','MO--Y'],['MO--Y','MORO-']]) + '.png" width="71" height="50" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1h08-',['GU-'],[['-EAR','GU-']]) + '.png" width="32" height="50" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gQuatFile('q1g01-',['-ARL'],[]) + '.png" width="39" height="39" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1g02-',['-O-'],[['-O-','U-LESS'],['-ARL','-O-'],['-O-','TO--']]) + '.png" width="70" height="39" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1g03-',['TREATI-S'],[['PO-DER','TREATI-S'],['SE-N','TREATI-S']]) + '.png" width="87" height="39" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1g04-',['PO-DER'],[['BASI-','PO-DER']]) + '.png" width="67" height="39" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1g05-',['MORO-'],[['MO--Y','MORO-'],['-AME','MORO-']]) + '.png" width="62" height="39" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1g06-',['G-A-'],[['G-A-','MO--Y']]) + '.png" width="41" height="39" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gQuatFile('q1f01-',['TO--'],[['TE-T','TO--']]) + '.png" width="41" height="33" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1f02-',[],[['-O-','TO--']]) + '.png" width="6" height="33" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1f03-',['-IFT'],[['-IFT','TE-T'],['-IFT','SPI-']]) + '.png" width="46" height="33" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1f04-',['PE-TER'],[['PE-TER','SPI-']]) + '.png" width="81" height="33" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1f05-',['SE-N'],[['SE-N','TREATI-S']]) + '.png" width="76" height="33" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1f06-',['-OLVES'],[['-OLVES','SE-N'],['-OLVES','-OON']]) + '.png" width="70" height="33" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1f07-',[],[['-AME','MORO-']]) + '.png" width="46" height="33" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gQuatFile('q1e01-',['TE-T'],[['TE-T','TO--'],['-IFT','TE-T'],['SCOR-','TE-T']]) + '.png" width="62" height="33" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1e02-',['SPI-'],[['-IFT','SPI-'],['PE-TER','SPI-']]) + '.png" width="54" height="33" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1e03-',['OVERTUR-'],[['OVERTUR-','PE-TER']]) + '.png" width="67" height="33" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1e04-',['-HALE'],[['-HALE','OVERTUR-']]) + '.png" width="69" height="33" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1e05-',['-OON'],[['-OLVES','-OON'],['-OON','PLA-T'],['-ABBED','-OON']]) + '.png" width="76" height="33" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1e06-',['-AME'],[['-AME','-IP']]) + '.png" width="38" height="33" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gQuatFile('q1d01-',['SCOR-'],[['SCOR-','TE-T']]) + '.png" width="44" height="32" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1d02-',['-ARMING'],[['-ARMING','SCOR-'],['-ARMING','-IC-']]) + '.png" width="102" height="32" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1d03-',['-AGA-'],[]) + '.png" width="64" height="32" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1d04-',['PLA-T'],[['-HALE','PLA-T'],['-OON','PLA-T']]) + '.png" width="57" height="32" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1d05-',[],[['-ABBED','-AP-']]) + '.png" width="3" height="32" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1d06-',['-ABBED'],[['-ABBED','-OON']]) + '.png" width="65" height="32" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1d07-',['-IP'],[['-AME','-IP'],['-IP','LE-D']]) + '.png" width="31" height="32" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gQuatFile('q1c01-',['-IC-'],[['-ARMING','-IC-'],['-IC-','INVE-TOR']]) + '.png" width="71" height="49" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1c02-',['IN-RT'],[['FA-NING','IN-RT'],['-ERVE','IN-RT']]) + '.png" width="71" height="49" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1c03-',['FA-NING'],[['-AGA-','FA-NING']]) + '.png" width="78" height="49" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1c04-',['-AP-'],[['-ABBED','-AP-'],['-AP-','RE-T']]) + '.png" width="57" height="49" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1c05-',['-AS-'],[['-AS-','TE-']]) + '.png" width="36" height="49" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1c06-',[],[['-AS-','LE-D']]) + '.png" width="18" height="49" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1c07-',['LE-D'],[['-IP','LE-D']]) + '.png" width="35" height="49" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gQuatFile('q1b01-',['INVE-TOR'],[]) + '.png" width="61" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1b02-',['-ERVE'],[['-ERVE','CRO-']]) + '.png" width="76" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1b03-',['-IMMER'],[['-IMMER','CA-O-']]) + '.png" width="84" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1b04-',['RE-T'],[['K-E-','RE-T']]) + '.png" width="60" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1b05-',['TE-'],[]) + '.png" width="28" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1b06-',[],[['-ORD','TE-'],['-ORD','K-E-']]) + '.png" width="19" height="17" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1b07-',['-ORD'],[]) + '.png" width="38" height="17" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gQuatFile('q1a01-',[],[['CRO-','INVE-TOR']]) + '.png" width="40" height="36" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1a02-',['CRO-'],[['-ERVE','CRO-']]) + '.png" width="54" height="36" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1a03-',['CA-O-'],[['-ERVE','CRO-'],['-ERVE','CA-O-'],['-IMMER','CA-O-']]) + '.png" width="70" height="36" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1a04-',['-OUN'],[['-IMMER','-OUN']]) + '.png" width="63" height="36" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1a05-',['I-K'],[['I-K','RE-T']]) + '.png" width="23" height="36" border="0"></td>
     <td><img src="quat1/' + gQuatFile('q1a06-',['K-E-'],[['K-E-','RE-T'],['-ORD','K-E-']]) + '.png" width="116" height="36" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
</table>'
+ doCompass(true);
}

// -------------------------------------------------------------------
// Map: quat2MapPrint
// -------------------------------------------------------------------

quat2MapPrint() {
return '<table border="0" cellspacing="0" cellpadding="0">
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2n01-',['CALORI-'],[]) + '.png" width="54" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2n02-',[],[['-ITCHES','CALORI-'],['-AT','-ITCHES']]) + '.png" width="27" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2n03-',['-ITCHES'],[]) + '.png" width="79" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2n04-',['EGRE--'],[]) + '.png" width="43" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2n05-',['AR-A'],[]) + '.png" width="47" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2n06-',[],[['-IDER','AR-A']]) + '.png" width="15" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2n07-',['-IDER'],[]) + '.png" width="32" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2n08-',[],[['-IDER','BURRO-']]) + '.png" width="15" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2n09-',['BURRO-'],[]) + '.png" width="54" height="15" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2m01-',['-AT'],[['-AT','SA--'],['-AT','A-Y']]) + '.png" width="66" height="35" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2m02-',['-AT'],[['-AT','-ITCHES'],['-AS','-AT'],['-AT','U-ED']],true) + '.png" width="41" height="35" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2m03-',['-AS'],[['-AS','S-IP']]) + '.png" width="53" height="35" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2m04-',['HEAVE-'],[['EGRE--','HEAVE-']]) + '.png" width="43" height="35" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2m05-',['-VE'],[['-AND','-VE']]) + '.png" width="49" height="35" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2m06-',['-AND'],[]) + '.png" width="43" height="35" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2m07-',['-EDY'],[['-EDY','BURRO-'],['-EDY','-ICK']]) + '.png" width="71" height="35" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2l01-',['SA--'],[['-AT','SA--'],['-ISH','SA--']]) + '.png" width="43" height="46" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2l02-',['A-Y'],[['-AT','A-Y']]) + '.png" width="25" height="46" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2l03-',['U-ED'],[['-AT','U-ED'],['GLE-','U-ED']]) + '.png" width="68" height="46" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2l04-',['S-IP'],[['-AS','S-IP']]) + '.png" width="44" height="46" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2l05-',['RE-O-N'],[['HEAVE-','RE-O-N'],['LO-LY','RE-O-N']]) + '.png" width="72" height="46" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2l06-',['OW-'],[['-AND','OW-']]) + '.png" width="31" height="46" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2l07-',[],[['-ICK','OW-']]) + '.png" width="35" height="46" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2l08-',['-ICK'],[['-EDY','-ICK'],['-ICK','-IT']]) + '.png" width="48" height="46" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2k01-',['-ISH'],[['-ISH','SA--'],['-ISH','PA--ED']]) + '.png" width="62" height="41" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2k02-',['GLE-'],[['GLE-','U-ED'],['GLE-','LO-LY']]) + '.png" width="79" height="41" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2k03-',['LO-LY'],[['LO-LY','RE-O-N'],['-ASP','CROW-D']]) + '.png" width="68" height="41" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2k04-',['-ASP'],[]) + '.png" width="51" height="41" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2k05-',['SE-TRY'],[['-IT','SE-TRY']]) + '.png" width="61" height="41" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2k06-',['-IT'],[['-ICK','-IT'],['-IT','FRO-TI-R']]) + '.png" width="45" height="41" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2j01-',['PA--ED'],[['PA--ED','THI-']]) + '.png" width="45" height="29" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2j02-',['-UNG'],[['-UNG','THI-'],['-UNG','I--']]) + '.png" width="47" height="29" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2j03-',['CROW-D'],[]) + '.png" width="74" height="29" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2j04-',['CROW-D'],[['-ASP','CROW-D'],['-EEPING','CROW-D']],true) + '.png" width="16" height="29" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2j05-',['-EEPING'],[['-EEPING','CROW-D'],['-EEPING','CRA-S'],['-EEPING','SI-K']]) + '.png" width="57" height="29" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2j06-',['FRO-TI-R'],[['-IT','FRO-TI-R'],['-AFER','FRO-TI-R']]) + '.png" width="127" height="29" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2i01-',['THI-'],[['PA--ED','THI-'],['-UNG','THI-'],['CONTE-T','THI-']]) + '.png" width="65" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2i02-',['I--'],[['-UNG','I--']]) + '.png" width="21" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2i03-',['-NO-'],[['-NO-','GE-']]) + '.png" width="57" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2i04-',[],[['-EEPING','CRA-S']]) + '.png" width="60" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2i05-',['SI-K'],[['-EEPING','SI-K']]) + '.png" width="27" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2i06-',[],[['-AKE','BASSI-T']]) + '.png" width="38" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2i07-',['-AKE'],[]) + '.png" width="30" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2i08-',[],[['-AFER','FRO-TI-R']]) + '.png" width="25" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2i09-',['-AFER'],[['-AFER','LO-ER']]) + '.png" width="43" height="27" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2h01-',['CONTE-T'],[['CONTE-T','THI-']]) + '.png" width="49" height="32" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2h02-',['GE-'],[['-NO-','GE-'],['CRA-S','GE-']]) + '.png" width="64" height="32" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2h03-',['CRA-S'],[['-EEPING','CRA-S'],['-ARTHY','CRA-S']]) + '.png" width="79" height="32" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2h04-',['BASSI-T'],[['-AKE','BASSI-T'],['-ORM','BASSI-T']]) + '.png" width="71" height="32" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2h05-',['SHRI-K'],[['-AKE','SHRI-K']]) + '.png" width="39" height="32" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2h06-',[],[['LO-ER','SHRI-K']]) + '.png" width="20" height="32" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2h07-',['LO-ER'],[['-AFER','LO-ER'],['GALLO-S','LO-ER']]) + '.png" width="44" height="32" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2g01-',[],[['CONTE-T','DI-']]) + '.png" width="25" height="33" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2g02-',['-ARTHY'],[['-ARTHY','DI-']]) + '.png" width="63" height="33" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2g03-',[],[['-ARTHY','CRA-S']]) + '.png" width="60" height="33" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2g04-',['-ACH'],[]) + '.png" width="31" height="33" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2g05-',[],[['-ACH','-ORM']]) + '.png" width="18" height="33" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2g06-',['-ORM'],[['-ORM','BASSI-T']]) + '.png" width="35" height="33" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2g07-',[],[['-ARN','-VER']]) + '.png" width="35" height="33" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2g08-',['-ARN'],[]) + '.png" width="31" height="33" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2g09-',[],[['-ARN','GALLO-S']]) + '.png" width="18" height="33" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2g10-',['GALLO-S'],[['GALLO-S','LO-ER']]) + '.png" width="50" height="33" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2f01-',['DI-'],[['-ARTHY','DI-'],['DI-','FLE-']]) + '.png" width="49" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2f02-',['FLE-'],[]) + '.png" width="28" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2f03-',['-INGS'],[['-INGS','FLE-'],['-INGS','VI-TAGE'],['-INGS','HUMA-']]) + '.png" width="51" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2f04-',['CA-HE-'],[['CA-HE-','HUMA-'],['CA-HE-','PO-D']]) + '.png" width="71" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2f05-',['-VER'],[['-ARN','-VER'],['-ATERY','-VER'],['-VER','STO-']]) + '.png" width="46" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2f06-',['-ATERY'],[]) + '.png" width="42" height="27" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2f07-',['-ADDLING'],[['-ADDLING','-ATERY'],['-ADDLING','-UD-']]) + '.png" width="79" height="27" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2e01-',['AXI-'],[['AXI-','BU-']]) + '.png" width="54" height="43" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2e02-',['HUMA-','VI-TAGE'],[['-INGS','VI-TAGE']]) + '.png" width="77" height="43" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2e03-',[],[['CA-HE-','HUMA-']]) + '.png" width="13" height="43" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2e04-',['PO-D'],[['CA-HE-','PO-D'],['PO-D','STO-']]) + '.png" width="52" height="43" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2e05-',['STO-'],[['-VER','STO-']]) + '.png" width="55" height="43" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2e06-',['-UD-'],[['-ADDLING','-UD-']]) + '.png" width="73" height="43" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2e07-',['-IX'],[['-ADDLING','-IX'],['-IX','S-IVELING']]) + '.png" width="42" height="43" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2d01-',[],[['AXI-','BU-']]) + '.png" width="54" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2d02-',['-UIT-'],[['-ARRING','-UIT-']]) + '.png" width="142" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2d03-',[],[['-AVES','-UD-'],['-IX','S-IVELING']]) + '.png" width="170" height="15" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2c01-',['BU-'],[]) + '.png" width="59" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2c02-',['-ERI-'],[]) + '.png" width="32" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2c03-',[],[['-ERI-','FU--Y']]) + '.png" width="36" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2c04-',[],[['-UIT-','I-']]) + '.png" width="31" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2c05-',[],[['-ARRING','-UIT-']]) + '.png" width="30" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2c06-',['-ARRING'],[]) + '.png" width="46" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2c07-',[],[['-ARRING','-AVES']]) + '.png" width="14" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2c08-',['-AVES'],[]) + '.png" width="36" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2c09-',[],[['-AVES','S-IVELING']]) + '.png" width="25" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2c10-',['S-IVELING'],[]) + '.png" width="57" height="15" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2b01-',['BROW-'],[['BROW-','BU-'],['BROW-','TO-'],['BROW-','DI-ER']]) + '.png" width="84" height="51" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2b02-',['FU--Y'],[['-ERI-','FU--Y'],['FU--Y','TO-'],['I-','TO-']]) + '.png" width="37" height="51" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2b03-',['I-'],[['I-','TO-']]) + '.png" width="42" height="51" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2b04-',['CLEAN-'],[['-OISE','CLEAN-'],['CLEAN-','I--ARDS']]) + '.png" width="62" height="51" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2b05-',['LO--'],[['-AVES','LO--'],['LO--','S-AT'],['I--ARDS','LO--']]) + '.png" width="69" height="51" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2b06-',['DE-D'],[]) + '.png" width="30" height="51" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2b07-',[],[['-AD','DE-D']]) + '.png" width="17" height="51" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2b08-',['-AD'],[['-AD','ME-']]) + '.png" width="25" height="51" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gQuatFile('q2a01-',['DI-ER'],[]) + '.png" width="43" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2a02-',[],[['BROW-','TO-']]) + '.png" width="46" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2a03-',['TO-'],[]) + '.png" width="27" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2a04-',[],[['I-','TO-'],['A-L','TO-']]) + '.png" width="16" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2a05-',['A-L'],[]) + '.png" width="34" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2a06-',['-OISE'],[]) + '.png" width="34" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2a07-',['I--ARDS'],[['CLEAN-','I--ARDS']]) + '.png" width="65" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2a08-',[],[['LO--','S-AT']]) + '.png" width="28" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2a09-',['S-AT'],[]) + '.png" width="31" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2a10-',[],[['ME-','S-AT']]) + '.png" width="16" height="15" border="0"></td>
     <td><img src="quat2/' + gQuatFile('q2a11-',['ME-'],[]) + '.png" width="26" height="15" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
</table>'
+ doCompass(true);
}

// -------------------------------------------------------------------
// JUNK
// -------------------------------------------------------------------

/*
gQuatFileQ2J04() {
  local str;
  
  str = gQuatFile('q2j04-',['CROW-D'],[['-ASP','CROW-D'],['-EEPING','CROW-D']],true);
  
  //str = 'q2j04-';
  //str = str + '111';
  
  //if (qrCROW_D.beenThere) str = str + '1'; else str = str + '0';
  //if (qp_ASPtoCROW_D.beenTraversed) str = str + '1'; else str = str + '0';
  //if (qp_EEPINGtoCROW_D.beenTraversed) str = str + '1'; else str = str + '0';
  
  return str;
} // qrCROW_D; qp_ASPtoCROW_D, qp_EEPINGtoCROW_D //111

gQuatFileQ2M02() {
  local str;
  
  str = gQuatFile('q2m02-',['-AT'],[['-AT','-ITCHES'],['-AS','-AT'],['-AT','U-ED']],true);
  
  //str = 'q2m02-';
  //str = str + '1111';
  
  //if (qr_AT.beenThere) str = str + '1'; else str = str + '0';
  //if (qp_ATto_ITCHES.beenTraversed) str = str + '1'; else str = str + '0';
  //if (qp_ASto_AT.beenTraversed) str = str + '1'; else str = str + '0';
  //if (qp_ATtoU_ED.beenTraversed) str = str + '1'; else str = str + '0';
  
  return str;
}
gQuatFileQ1H03() {
  local str;
  
  str = gQuatFile('q1h03-',['HOU-D','U-ISE'],[['HOU-D','U-ISE']],true);
  
  //str = 'q1h03-';
  //str = str + '111';
  
  //if (qrHOU_D.beenThere) str = str + '1'; else str = str + '0';
  //if (qrU_ISE.beenThere) str = str + '1'; else str = str + '0';
  //if (qpHOU_DtoU_ISE.beenTraversed) str = str + '1'; else str = str + '0';
  
  return str;
}
*/



/*
gFileQ1L01() { return gQuatFile('q1l01-',['P-A'      ],[                                         ]); } // 1
gFileQ1L02() { return gQuatFile('q1l02-',[           ],[['-IG','P-A'],['-IG','K-EL']                   ]); } // 11
gFileQ1L03() { return gQuatFile('q1l03-',['-IG'      ],[                                         ]); } // 1
gFileQ1L04() { return gQuatFile('q1l04-',['-QUAT-'   ],[['-QUAT-','A-AY']                           ]); } // 11
gFileQ1L05() { return gQuatFile('q1l05-',['A-AY'     ],[                                         ]); } // 1
gFileQ1L06() { return gQuatFile('q1l06-',['-PE-'     ],[['-PE-','SA-']                              ]); } // 11
gFileQ1L07() { return gQuatFile('q1l07-',['-EEK'     ],[['-EEK','-PE-']                             ]); } // 11
gFileQ1L08() { return gQuatFile('q1l08-',['-OOP'     ],[['-IGH','-OOP']                             ]); } // 11
gFileQ1K01() { return gQuatFile('q1k01-',['K-EL'     ],[['-IG','K-EL'],['-HY','K-EL']                  ]); } // 111
gFileQ1K02() { return gQuatFile('q1k02-',['-HY'      ],[['-IG','K-EL'],['-HY','DETE-T-']               ]); } // 111
gFileQ1K03() { return gQuatFile('q1k03-',['BLE-D'    ],[['-QUAT-','BLE-D']                          ]); } // 11
gFileQ1K04() { return gQuatFile('q1k04-',[           ],[['BLE-D','SA-']                             ]); } // 1
gFileQ1K05() { return gQuatFile('q1k05-',['SA-'      ],[['-PE-','SA-']                              ]); } // 11
gFileQ1K06() { return gQuatFile('q1k06-',['-RF'      ],[['-PE-','SA-'],['-ON','-RF']                   ]); } // 111
gFileQ1K07() { return gQuatFile('q1k07-',['-IGH'     ],[['-EEK','-IGH'],['-IGH','-OOP'],['-AIVE','-IGH']  ]); } // 1111
gFileQ1K08() { return gQuatFile('q1k08-',['-PA'      ],[['-PA','MI-T']                              ]); } // 11
gFileQ1J01() { return gQuatFile('q1j01-',['DETE-T-'  ],[['-HY','DETE-T-'],['BAR-','DETE-T-']           ]); } // 111
gFileQ1J02() { return gQuatFile('q1j02-',['-LUM-'    ],[['-AILING','-LUM-']                         ]); } // 11
gFileQ1J03() { return gQuatFile('q1j03-',['-LOPING'  ],[['-LOPING','EVE-T']                         ]); } // 11
gFileQ1J04() { return gQuatFile('q1j04-',[           ],[['-LOPING','-ON']                           ]); } // 1
gFileQ1J05() { return gQuatFile('q1j05-',['-ON'      ],[['-ON','FU-']                               ]); } // 11
gFileQ1J06() { return gQuatFile('q1j06-',[           ],[['-ON','-RF'],['-AIVE','-ON']                  ]); } // 11
gFileQ1J07() { return gQuatFile('q1j07-',['-AIVE'    ],[                                         ]); } // 1
gFileQ1J08() { return gQuatFile('q1j08-',['MI-T'     ],[['-PA','MI-T']                              ]); } // 11
gFileQ1I01() { return gQuatFile('q1i01-',['BAR-'     ],[['BAR-','DETE-T-'],['BAR-','U-LESS']           ]); } // 111
gFileQ1I02() { return gQuatFile('q1i02-',[           ],[['-AILING','BAR-']                          ]); } // 1
gFileQ1I03() { return gQuatFile('q1i03-',['-AILING'  ],[['-AILING','-LUM-'],['-AILING','HOU-D']        ]); } // 111
gFileQ1I04() { return gQuatFile('q1i04-',['EVE-T'    ],[['-LOPING','EVE-T']                         ]); } // 11
gFileQ1I05() { return gQuatFile('q1i05-',['FU-'      ],[['-ON','FU-'],['FU-','THRE-']                  ]); } // 111
gFileQ1I06() { return gQuatFile('q1i06-',['THRE-'    ],[                                         ]); } // 1
gFileQ1I07() { return gQuatFile('q1i07-',[           ],[['-EAR','THRE-'],['-EAR','MO--Y']              ]); } // 11
gFileQ1I08() { return gQuatFile('q1i08-',['-EAR'     ],[['-EAR','MI-T']                             ]); } // 11
gFileQ1H01() { return gQuatFile('q1h01-',['U-LESS'   ],[['BAR-','U-LESS'],['-O-','U-LESS']             ]); } // 111
gFileQ1H02() { return gQuatFile('q1h02-',['HOU-D'    ],[['-AILING','HOU-D']                         ]); } // 11
gFileQ1H03() { return gQuatFile('q1h03-',['HOU-D','U-ISE'],[['HOU-D','U-ISE']],true); }                                                              // 111
gFileQ1H04() { return gQuatFile('q1h04-',['-N-MY','U-ISE'],[                                     ]); } // 11
gFileQ1H05() { return gQuatFile('q1h05-',['BASI-'    ],[['-IN','-N-MY']                             ]); } // 11
gFileQ1H06() { return gQuatFile('q1h06-',['-IN','BASI-'],[['-IN','BASI-']                           ]); } // 111
gFileQ1H07() { return gQuatFile('q1h07-',['MO--Y'    ],[['-EAR','MO--Y'],['G-A-','MO--Y'],['MO--Y','MORO-']]); } // 1111
gFileQ1H08() { return gQuatFile('q1h08-',['GU-'      ],[['-EAR','GU-']                              ]); } // 11
gFileQ1G01() { return gQuatFile('q1g01-',['-ARL'     ],[                                         ]); } // 1
gFileQ1G02() { return gQuatFile('q1g02-',['-O-'      ],[['-O-','U-LESS'],['-ARL','-O-'],['-O-','TO--']    ]); } // 1111
gFileQ1G03() { return gQuatFile('q1g03-',['TREATI-S' ],[['PO-DER','TREATI-S'],['SE-N','TREATI-S']      ]); } // 111
gFileQ1G04() { return gQuatFile('q1g04-',['PO-DER'   ],[['BASI-','PO-DER']                          ]); } // 11
gFileQ1G05() { return gQuatFile('q1g05-',['MORO-'    ],[['MO--Y','MORO-'],['-AME','MORO-']             ]); } // 111
gFileQ1G06() { return gQuatFile('q1g06-',['G-A-'     ],[['G-A-','MO--Y']                            ]); } // 11
gFileQ1F01() { return gQuatFile('q1f01-',['TO--'     ],[['TE-T','TO--']                             ]); } // 11
gFileQ1F02() { return gQuatFile('q1f02-',[           ],[['-O-','TO--']                              ]); } // 1
gFileQ1F03() { return gQuatFile('q1f03-',['-IFT'     ],[['-IFT','TE-T'],['-IFT','SPI-']                ]); } // 111
gFileQ1F04() { return gQuatFile('q1f04-',['PE-TER'   ],[['PE-TER','SPI-']                           ]); } // 11
gFileQ1F05() { return gQuatFile('q1f05-',['SE-N'     ],[['SE-N','TREATI-S']                         ]); } // 11
gFileQ1F06() { return gQuatFile('q1f06-',['-OLVES'   ],[['-OLVES','SE-N'],['-OLVES','-OON']            ]); } // 111
gFileQ1F07() { return gQuatFile('q1f07-',[           ],[['-AME','MORO-']                            ]); } // 1
gFileQ1E01() { return gQuatFile('q1e01-',['TE-T'     ],[['TE-T','TO--'],['-IFT','TE-T'],['SCOR-','TE-T']  ]); } // 1111
gFileQ1E02() { return gQuatFile('q1e02-',['SPI-'     ],[['-IFT','SPI-'],['PE-TER','SPI-']              ]); } // 111
gFileQ1E03() { return gQuatFile('q1e03-',['OVERTUR-' ],[['OVERTUR-','PE-TER']                       ]); } // 11
gFileQ1E04() { return gQuatFile('q1e04-',['-HALE'    ],[['-HALE','OVERTUR-']                        ]); } // 11
gFileQ1E05() { return gQuatFile('q1e05-',['-OON'     ],[['-OLVES','-OON'],['-OON','PLA-T'],['-ABBED','-OON']]); } // 1111
gFileQ1E06() { return gQuatFile('q1e06-',['-AME'     ],[['-AME','-IP']                              ]); } // 11
gFileQ1D01() { return gQuatFile('q1d01-',['SCOR-'    ],[['SCOR-','TE-T']                            ]); } // 11
gFileQ1D02() { return gQuatFile('q1d02-',['-ARMING'  ],[['-ARMING','SCOR-'],['-ARMING','-IC-']         ]); } // 111
gFileQ1D03() { return gQuatFile('q1d03-',['-AGA-'    ],[                                         ]); } // 1
gFileQ1D04() { return gQuatFile('q1d04-',['PLA-T'    ],[['-HALE','PLA-T'],['-OON','PLA-T']             ]); } // 111
gFileQ1D05() { return gQuatFile('q1d05-',[           ],[['-ABBED','-AP-']                           ]); } // 1
gFileQ1D06() { return gQuatFile('q1d06-',['-ABBED'   ],[['-ABBED','-OON']                           ]); } // 11
gFileQ1D07() { return gQuatFile('q1d07-',['-IP'      ],[['-AME','-IP'],['-IP','LE-D']                  ]); } // 111
gFileQ1C01() { return gQuatFile('q1c01-',['-IC-'     ],[['-ARMING','-IC-'],['-IC-','INVE-TOR']         ]); } // 111
gFileQ1C02() { return gQuatFile('q1c02-',['IN-RT'    ],[['FA-NING','IN-RT'],['-ERVE','IN-RT']          ]); } // 111
gFileQ1C03() { return gQuatFile('q1c03-',['FA-NING'  ],[['-AGA-','FA-NING']                         ]); } // 11
gFileQ1C04() { return gQuatFile('q1c04-',['-AP-'     ],[['-ABBED','-AP-'],['-AP-','RE-T']              ]); } // 111
gFileQ1C05() { return gQuatFile('q1c05-',['-AS-'     ],[['-AS-','TE-']                              ]); } // 11
gFileQ1C06() { return gQuatFile('q1c06-',[           ],[['-AS-','LE-D']                             ]); } // 1
gFileQ1C07() { return gQuatFile('q1c07-',['LE-D'     ],[['-IP','LE-D']                              ]); } // 11
gFileQ1B01() { return gQuatFile('q1b01-',['INVE-TOR' ],[                                         ]); } // 1
gFileQ1B02() { return gQuatFile('q1b02-',['-ERVE'    ],[['-ERVE','CRO-']                            ]); } // 11
gFileQ1B03() { return gQuatFile('q1b03-',['-IMMER'   ],[['-IMMER','CA-O-']                          ]); } // 11
gFileQ1B04() { return gQuatFile('q1b04-',['RE-T'     ],[['K-E-','RE-T']                             ]); } // 11
gFileQ1B05() { return gQuatFile('q1b05-',['TE-'      ],[                                         ]); } // 1
gFileQ1B06() { return gQuatFile('q1b06-',[           ],[['-ORD','TE-'],['-ORD','K-E-']                 ]); } // 11
gFileQ1B07() { return gQuatFile('q1b07-',['-ORD'     ],[                                         ]); } // 1
gFileQ1A01() { return gQuatFile('q1a01-',[           ],[['CRO-','INVE-TOR']                         ]); } // 1
gFileQ1A02() { return gQuatFile('q1a02-',['CRO-'     ],[['-ERVE','CRO-']                            ]); } // 11
gFileQ1A03() { return gQuatFile('q1a03-',['CA-O-'    ],[['-ERVE','CRO-'],['-ERVE','CA-O-'],['-IMMER','CA-O-']]); } // 1111
gFileQ1A04() { return gQuatFile('q1a04-',['-OUN'     ],[['-IMMER','-OUN']                           ]); } // 11
gFileQ1A05() { return gQuatFile('q1a05-',['I-K'      ],[['I-K','RE-T']                              ]); } // 11
gFileQ1A06() { return gQuatFile('q1a06-',['K-E-'     ],[['K-E-','RE-T'],['-ORD','K-E-']                ]); } // 111

gFileQ2N01() { return gQuatFile('q2n01-',['CALORI-'  ],[                                           ]); } //1
gFileQ2N02() { return gQuatFile('q2n02-',[           ],[['-ITCHES','CALORI-'],['-AT','-ITCHES']         ]); } //11
gFileQ2N03() { return gQuatFile('q2n03-',['-ITCHES'  ],[                                           ]); } //1
gFileQ2N04() { return gQuatFile('q2n04-',['EGRE--'   ],[                                           ]); } //1
gFileQ2N05() { return gQuatFile('q2n05-',['AR-A'     ],[                                           ]); } //1
gFileQ2N06() { return gQuatFile('q2n06-',[           ],[['-IDER','AR-A']                              ]); } //1
gFileQ2N07() { return gQuatFile('q2n07-',['-IDER'    ],[                                           ]); } //1
gFileQ2N08() { return gQuatFile('q2n08-',[           ],[['-IDER','BURRO-']                            ]); } //1
gFileQ2N09() { return gQuatFile('q2n09-',['BURRO-'   ],[                                           ]); } //1
gFileQ2M01() { return gQuatFile('q2m01-',['-AT'      ],[['-AT','SA--'],['-AT','A-Y']                    ]); } //111
gFileQ2M02() { return gQuatFile('q2m02-',['-AT'],[['-AT','-ITCHES'],['-AS','-AT'],['-AT','U-ED']],true); } //1111
gFileQ2M03() { return gQuatFile('q2m03-',['-AS'      ],[['-AS','S-IP']                                ]); } //11
gFileQ2M04() { return gQuatFile('q2m04-',['HEAVE-'   ],[['EGRE--','HEAVE-']                           ]); } //11
gFileQ2M05() { return gQuatFile('q2m05-',['-VE'      ],[['-AND','-VE']                                ]); } //11
gFileQ2M06() { return gQuatFile('q2m06-',['-AND'     ],[                                           ]); } //1
gFileQ2M07() { return gQuatFile('q2m07-',['-EDY'     ],[['-EDY','BURRO-'],['-EDY','-ICK']               ]); } //111
gFileQ2L01() { return gQuatFile('q2l01-',['SA--'     ],[['-AT','SA--'],['-ISH','SA--']                  ]); } //111
gFileQ2L02() { return gQuatFile('q2l02-',['A-Y'      ],[['-AT','A-Y']                                 ]); } //11
gFileQ2L03() { return gQuatFile('q2l03-',['U-ED'     ],[['-AT','U-ED'],['GLE-','U-ED']                  ]); } //111
gFileQ2L04() { return gQuatFile('q2l04-',['S-IP'     ],[['-AS','S-IP']                                ]); } //11
gFileQ2L05() { return gQuatFile('q2l05-',['RE-O-N'   ],[['HEAVE-','RE-O-N'],['LO-LY','RE-O-N']          ]); } //111
gFileQ2L06() { return gQuatFile('q2l06-',['OW-'      ],[['-AND','OW-']                                ]); } //11
gFileQ2L07() { return gQuatFile('q2l07-',[           ],[['-ICK','OW-']                                ]); } //1
gFileQ2L08() { return gQuatFile('q2l08-',['-ICK'     ],[['-EDY','-ICK'],['-ICK','-IT']                  ]); } //111
gFileQ2K01() { return gQuatFile('q2k01-',['-ISH'     ],[['-ISH','SA--'],['-ISH','PA--ED']               ]); } //111
gFileQ2K02() { return gQuatFile('q2k02-',['GLE-'     ],[['GLE-','U-ED'],['GLE-','LO-LY']                ]); } //111
gFileQ2K03() { return gQuatFile('q2k03-',['LO-LY'    ],[['LO-LY','RE-O-N'],['-ASP','CROW-D']            ]); } //111
gFileQ2K04() { return gQuatFile('q2k04-',['-ASP'     ],[                                           ]); } //1
gFileQ2K05() { return gQuatFile('q2k05-',['SE-TRY'   ],[['-IT','SE-TRY']                              ]); } //11
gFileQ2K06() { return gQuatFile('q2k06-',['-IT'      ],[['-ICK','-IT'],['-IT','FRO-TI-R']               ]); } //111
gFileQ2J01() { return gQuatFile('q2j01-',['PA--ED'   ],[['PA--ED','THI-']                             ]); } //11
gFileQ2J02() { return gQuatFile('q2j02-',['-UNG'     ],[['-UNG','THI-'],['-UNG','I--']                  ]); } //111
gFileQ2J03() { return gQuatFile('q2j03-',['CROW-D'   ],[                                           ]); } //1
gFileQ2J04() { return gQuatFile('q2j04-',['CROW-D'],[['-ASP','CROW-D'],['-EEPING','CROW-D']],true); } // qrCROW-D; qp-ASPtoCROW-D'],['-EEPINGtoCROW-D //111
gFileQ2J05() { return gQuatFile('q2j05-',['-EEPING'  ],[['-EEPING','CROW-D'],['-EEPING','CRA-S'],['-EEPING','SI-K']]); } //1111
gFileQ2J06() { return gQuatFile('q2j06-',['FRO-TI-R' ],[['-IT','FRO-TI-R'],['-AFER','FRO-TI-R']         ]); } //111
gFileQ2I01() { return gQuatFile('q2i01-',['THI-'     ],[['PA--ED','THI-'],['-UNG','THI-'],['CONTE-T','THI-']]); } //1111
gFileQ2I02() { return gQuatFile('q2i02-',['I--'      ],[['-UNG','I--']                                ]); } //11
gFileQ2I03() { return gQuatFile('q2i03-',['-NO-'     ],[['-NO-','GE-']                                ]); } //11
gFileQ2I04() { return gQuatFile('q2i04-',[           ],[['-EEPING','CRA-S']                           ]); } //1
gFileQ2I05() { return gQuatFile('q2i05-',['SI-K'     ],[['-EEPING','SI-K']                            ]); } //11
gFileQ2I06() { return gQuatFile('q2i06-',[           ],[['-AKE','BASSI-T']                            ]); } //1
gFileQ2I07() { return gQuatFile('q2i07-',['-AKE'     ],[                                           ]); } //1
gFileQ2I08() { return gQuatFile('q2i08-',[           ],[['-AFER','FRO-TI-R']                          ]); } //1
gFileQ2I09() { return gQuatFile('q2i09-',['-AFER'    ],[['-AFER','LO-ER']                             ]); } //11
gFileQ2H01() { return gQuatFile('q2h01-',['CONTE-T'  ],[['CONTE-T','THI-']                            ]); } //11
gFileQ2H02() { return gQuatFile('q2h02-',['GE-'      ],[['-NO-','GE-'],['CRA-S','GE-']                  ]); } //111
gFileQ2H03() { return gQuatFile('q2h03-',['CRA-S'    ],[['-EEPING','CRA-S'],['-ARTHY','CRA-S']          ]); } //111
gFileQ2H04() { return gQuatFile('q2h04-',['BASSI-T'  ],[['-AKE','BASSI-T'],['-ORM','BASSI-T']           ]); } //111
gFileQ2H05() { return gQuatFile('q2h05-',['SHRI-K'   ],[['-AKE','SHRI-K']                             ]); } //11
gFileQ2H06() { return gQuatFile('q2h06-',[           ],[['LO-ER','SHRI-K']                            ]); } //1
gFileQ2H07() { return gQuatFile('q2h07-',['LO-ER'    ],[['-AFER','LO-ER'],['GALLO-S','LO-ER']           ]); } //111
gFileQ2G01() { return gQuatFile('q2g01-',[           ],[['CONTE-T','DI-']                             ]); } //1
gFileQ2G02() { return gQuatFile('q2g02-',['-ARTHY'   ],[['-ARTHY','DI-']                              ]); } //11
gFileQ2G03() { return gQuatFile('q2g03-',[           ],[['-ARTHY','CRA-S']                            ]); } //1
gFileQ2G04() { return gQuatFile('q2g04-',['-ACH'     ],[                                           ]); } //1
gFileQ2G05() { return gQuatFile('q2g05-',[           ],[['-ACH','-ORM']                               ]); } //1
gFileQ2G06() { return gQuatFile('q2g06-',['-ORM'     ],[['-ORM','BASSI-T']                            ]); } //11
gFileQ2G07() { return gQuatFile('q2g07-',[           ],[['-ARN','-VER']                               ]); } //1
gFileQ2G08() { return gQuatFile('q2g08-',['-ARN'     ],[                                           ]); } //1
gFileQ2G09() { return gQuatFile('q2g09-',[           ],[['-ARN','GALLO-S']                            ]); } //1
gFileQ2G10() { return gQuatFile('q2g10-',['GALLO-S'  ],[['GALLO-S','LO-ER']                           ]); } //11
gFileQ2F01() { return gQuatFile('q2f01-',['DI-'      ],[['-ARTHY','DI-'],['DI-','FLE-']                 ]); } //111
gFileQ2F02() { return gQuatFile('q2f02-',['FLE-'     ],[                                           ]); } //1
gFileQ2F03() { return gQuatFile('q2f03-',['-INGS'    ],[['-INGS','FLE-'],['-INGS','VI-TAGE'],['-INGS','HUMA-']]); } //1111
gFileQ2F04() { return gQuatFile('q2f04-',['CA-HE-'   ],[['CA-HE-','HUMA-'],['CA-HE-','PO-D']            ]); } //111
gFileQ2F05() { return gQuatFile('q2f05-',['-VER'     ],[['-ARN','-VER'],['-ATERY','-VER'],['-VER','STO-'] ]); } //1111
gFileQ2F06() { return gQuatFile('q2f06-',['-ATERY'   ],[                                           ]); } //1
gFileQ2F07() { return gQuatFile('q2f07-',['-ADDLING' ],[['-ADDLING','-ATERY'],['-ADDLING','-UD-']       ]); } //111
gFileQ2E01() { return gQuatFile('q2e01-',['AXI-'     ],[['AXI-','BU-']                                ]); } //11
gFileQ2E02() { return gQuatFile('q2e02-',['HUMA-','VI-TAGE'],[['-INGS','VI-TAGE']                     ]); } //111
gFileQ2E03() { return gQuatFile('q2e03-',[           ],[['CA-HE-','HUMA-']                            ]); } //1
gFileQ2E04() { return gQuatFile('q2e04-',['PO-D'     ],[['CA-HE-','PO-D'],['PO-D','STO-']               ]); } //111
gFileQ2E05() { return gQuatFile('q2e05-',['STO-'     ],[['-VER','STO-']                               ]); } //11
gFileQ2E06() { return gQuatFile('q2e06-',['-UD-'     ],[['-ADDLING','-UD-']                           ]); } //11
gFileQ2E07() { return gQuatFile('q2e07-',['-IX'      ],[['-ADDLING','-IX'],['-IX','S-IVELING']          ]); } //111
gFileQ2D01() { return gQuatFile('q2d01-',[           ],[['AXI-','BU-']                                ]); } //1
gFileQ2D02() { return gQuatFile('q2d02-',['-UIT-'    ],[['-ARRING','-UIT-']                           ]); } //11
gFileQ2D03() { return gQuatFile('q2d03-',[           ],[['-AVES','-UD-'],['-IX','S-IVELING']            ]); } //11
gFileQ2C01() { return gQuatFile('q2c01-',['BU-'      ],[                                           ]); } //1
gFileQ2C02() { return gQuatFile('q2c02-',['-ERI-'    ],[                                           ]); } //1
gFileQ2C03() { return gQuatFile('q2c03-',[           ],[['-ERI-','FU--Y']                             ]); } //1
gFileQ2C04() { return gQuatFile('q2c04-',[           ],[['-UIT-','I-']                                ]); } //1
gFileQ2C05() { return gQuatFile('q2c05-',[           ],[['-ARRING','-UIT-']                           ]); } //1
gFileQ2C06() { return gQuatFile('q2c06-',['-ARRING'  ],[                                           ]); } //1
gFileQ2C07() { return gQuatFile('q2c07-',[           ],[['-ARRING','-AVES']                           ]); } //1
gFileQ2C08() { return gQuatFile('q2c08-',['-AVES'    ],[                                           ]); } //1
gFileQ2C09() { return gQuatFile('q2c09-',[           ],[['-AVES','S-IVELING']                         ]); } //1
gFileQ2C10() { return gQuatFile('q2c10-',['S-IVELING'],[                                           ]); } //1
gFileQ2B01() { return gQuatFile('q2b01-',['BROW-'    ],[['BROW-','BU-'],['BROW-','TO-'],['BROW-','DI-ER'] ]); } //1111
gFileQ2B02() { return gQuatFile('q2b02-',['FU--Y'    ],[['-ERI-','FU--Y'],['FU--Y','TO-'],['I-','TO-']    ]); } //1111
gFileQ2B03() { return gQuatFile('q2b03-',['I-'       ],[['I-','TO-']                                  ]); } //11
gFileQ2B04() { return gQuatFile('q2b04-',['CLEAN-'   ],[['-OISE','CLEAN-'],['CLEAN-','I--ARDS']         ]); } //111
gFileQ2B05() { return gQuatFile('q2b05-',['LO--'     ],[['-AVES','LO--'],['LO--','S-AT'],['I--ARDS','LO--']]); } //1111
gFileQ2B06() { return gQuatFile('q2b06-',['DE-D'     ],[                                           ]); } //1
gFileQ2B07() { return gQuatFile('q2b07-',[           ],[['-AD','DE-D']                                ]); } //1
gFileQ2B08() { return gQuatFile('q2b08-',['-AD'      ],[['-AD','ME-']                                 ]); } //11
gFileQ2A01() { return gQuatFile('q2a01-',['DI-ER'    ],[                                           ]); } //1
gFileQ2A02() { return gQuatFile('q2a02-',[           ],[['BROW-','TO-']                               ]); } //1
gFileQ2A03() { return gQuatFile('q2a03-',['TO-'      ],[                                           ]); } //1
gFileQ2A04() { return gQuatFile('q2a04-',[           ],[['I-','TO-'],['A-L','TO-']                      ]); } //11
gFileQ2A05() { return gQuatFile('q2a05-',['A-L'      ],[                                           ]); } //1
gFileQ2A06() { return gQuatFile('q2a06-',['-OISE'    ],[                                           ]); } //1
gFileQ2A07() { return gQuatFile('q2a07-',['I--ARDS'  ],[['CLEAN-','I--ARDS']                          ]); } //11
gFileQ2A08() { return gQuatFile('q2a08-',[           ],[['LO--','S-AT']                               ]); } //1
gFileQ2A09() { return gQuatFile('q2a09-',['S-AT'     ],[                                           ]); } //1
gFileQ2A10() { return gQuatFile('q2a10-',[           ],[['ME-','S-AT']                                ]); } //1
gFileQ2A11() { return gQuatFile('q2a11-',['ME-'      ],[                                           ]); } //1

quat1MapPrint() {
return '<table border="0" cellspacing="0" cellpadding="0">
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gFileQ1L01() + '.png" width="29" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1L02() + '.png" width="23" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1L03() + '.png" width="43" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1L04() + '.png" width="69" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1L05() + '.png" width="38" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1L06() + '.png" width="54" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1L07() + '.png" width="53" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1L08() + '.png" width="57" height="17" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gFileQ1K01() + '.png" width="49" height="53" border="0"></td>
     <td><img src="quat1/' + gFileQ1K02() + '.png" width="53" height="53" border="0"></td>
     <td><img src="quat1/' + gFileQ1K03() + '.png" width="41" height="53" border="0"></td>
     <td><img src="quat1/' + gFileQ1K04() + '.png" width="29" height="53" border="0"></td>
     <td><img src="quat1/' + gFileQ1K05() + '.png" width="49" height="53" border="0"></td>
     <td><img src="quat1/' + gFileQ1K06() + '.png" width="55" height="53" border="0"></td>
     <td><img src="quat1/' + gFileQ1K07() + '.png" width="59" height="53" border="0"></td>
     <td><img src="quat1/' + gFileQ1K08() + '.png" width="31" height="53" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gFileQ1J01() + '.png" width="71" height="26" border="0"></td>
     <td><img src="quat1/' + gFileQ1J02() + '.png" width="68" height="26" border="0"></td>
     <td><img src="quat1/' + gFileQ1J03() + '.png" width="54" height="26" border="0"></td>
     <td><img src="quat1/' + gFileQ1J04() + '.png" width="25" height="26" border="0"></td>
     <td><img src="quat1/' + gFileQ1J05() + '.png" width="30" height="26" border="0"></td>
     <td><img src="quat1/' + gFileQ1J06() + '.png" width="25" height="26" border="0"></td>
     <td><img src="quat1/' + gFileQ1J07() + '.png" width="58" height="26" border="0"></td>
     <td><img src="quat1/' + gFileQ1J08() + '.png" width="35" height="26" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gFileQ1I01() + '.png" width="44" height="39" border="0"></td>
     <td><img src="quat1/' + gFileQ1I02() + '.png" width="25" height="39" border="0"></td>
     <td><img src="quat1/' + gFileQ1I03() + '.png" width="76" height="39" border="0"></td>
     <td><img src="quat1/' + gFileQ1I04() + '.png" width="74" height="39" border="0"></td>
     <td><img src="quat1/' + gFileQ1I05() + '.png" width="50" height="39" border="0"></td>
     <td><img src="quat1/' + gFileQ1I06() + '.png" width="43" height="39" border="0"></td>
     <td><img src="quat1/' + gFileQ1I07() + '.png" width="19" height="39" border="0"></td>
     <td><img src="quat1/' + gFileQ1I08() + '.png" width="35" height="39" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gFileQ1H01() + '.png" width="70" height="50" border="0"></td>
     <td><img src="quat1/' + gFileQ1H02() + '.png" width="45" height="50" border="0"></td>
     <td><img src="quat1/' + gFileQ1H03() + '.png" width="14" height="50" border="0"></td>
     <td><img src="quat1/' + gFileQ1H04() + '.png" width="62" height="50" border="0"></td>
     <td><img src="quat1/' + gFileQ1H05() + '.png" width="19" height="50" border="0"></td>
     <td><img src="quat1/' + gFileQ1H06() + '.png" width="53" height="50" border="0"></td>
     <td><img src="quat1/' + gFileQ1H07() + '.png" width="71" height="50" border="0"></td>
     <td><img src="quat1/' + gFileQ1H08() + '.png" width="32" height="50" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gFileQ1G01() + '.png" width="39" height="39" border="0"></td>
     <td><img src="quat1/' + gFileQ1G02() + '.png" width="70" height="39" border="0"></td>
     <td><img src="quat1/' + gFileQ1G03() + '.png" width="87" height="39" border="0"></td>
     <td><img src="quat1/' + gFileQ1G04() + '.png" width="67" height="39" border="0"></td>
     <td><img src="quat1/' + gFileQ1G05() + '.png" width="62" height="39" border="0"></td>
     <td><img src="quat1/' + gFileQ1G06() + '.png" width="41" height="39" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gFileQ1F01() + '.png" width="41" height="33" border="0"></td>
     <td><img src="quat1/' + gFileQ1F02() + '.png" width="6" height="33" border="0"></td>
     <td><img src="quat1/' + gFileQ1F03() + '.png" width="46" height="33" border="0"></td>
     <td><img src="quat1/' + gFileQ1F04() + '.png" width="81" height="33" border="0"></td>
     <td><img src="quat1/' + gFileQ1F05() + '.png" width="76" height="33" border="0"></td>
     <td><img src="quat1/' + gFileQ1F06() + '.png" width="70" height="33" border="0"></td>
     <td><img src="quat1/' + gFileQ1F07() + '.png" width="46" height="33" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gFileQ1E01() + '.png" width="62" height="33" border="0"></td>
     <td><img src="quat1/' + gFileQ1E02() + '.png" width="54" height="33" border="0"></td>
     <td><img src="quat1/' + gFileQ1E03() + '.png" width="67" height="33" border="0"></td>
     <td><img src="quat1/' + gFileQ1E04() + '.png" width="69" height="33" border="0"></td>
     <td><img src="quat1/' + gFileQ1E05() + '.png" width="76" height="33" border="0"></td>
     <td><img src="quat1/' + gFileQ1E06() + '.png" width="38" height="33" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gFileQ1D01() + '.png" width="44" height="32" border="0"></td>
     <td><img src="quat1/' + gFileQ1D02() + '.png" width="102" height="32" border="0"></td>
     <td><img src="quat1/' + gFileQ1D03() + '.png" width="64" height="32" border="0"></td>
     <td><img src="quat1/' + gFileQ1D04() + '.png" width="57" height="32" border="0"></td>
     <td><img src="quat1/' + gFileQ1D05() + '.png" width="3" height="32" border="0"></td>
     <td><img src="quat1/' + gFileQ1D06() + '.png" width="65" height="32" border="0"></td>
     <td><img src="quat1/' + gFileQ1D07() + '.png" width="31" height="32" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gFileQ1C01() + '.png" width="71" height="49" border="0"></td>
     <td><img src="quat1/' + gFileQ1C02() + '.png" width="71" height="49" border="0"></td>
     <td><img src="quat1/' + gFileQ1C03() + '.png" width="78" height="49" border="0"></td>
     <td><img src="quat1/' + gFileQ1C04() + '.png" width="57" height="49" border="0"></td>
     <td><img src="quat1/' + gFileQ1C05() + '.png" width="36" height="49" border="0"></td>
     <td><img src="quat1/' + gFileQ1C06() + '.png" width="18" height="49" border="0"></td>
     <td><img src="quat1/' + gFileQ1C07() + '.png" width="35" height="49" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gFileQ1B01() + '.png" width="61" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1B02() + '.png" width="76" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1B03() + '.png" width="84" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1B04() + '.png" width="60" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1B05() + '.png" width="28" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1B06() + '.png" width="19" height="17" border="0"></td>
     <td><img src="quat1/' + gFileQ1B07() + '.png" width="38" height="17" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat1/' + gFileQ1A01() + '.png" width="40" height="36" border="0"></td>
     <td><img src="quat1/' + gFileQ1A02() + '.png" width="54" height="36" border="0"></td>
     <td><img src="quat1/' + gFileQ1A03() + '.png" width="70" height="36" border="0"></td>
     <td><img src="quat1/' + gFileQ1A04() + '.png" width="63" height="36" border="0"></td>
     <td><img src="quat1/' + gFileQ1A05() + '.png" width="23" height="36" border="0"></td>
     <td><img src="quat1/' + gFileQ1A06() + '.png" width="116" height="36" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
</table>';
}

quat2MapPrint() {
return '<table border="0" cellspacing="0" cellpadding="0">
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2N01() + '.png" width="54" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2N02() + '.png" width="27" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2N03() + '.png" width="79" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2N04() + '.png" width="43" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2N05() + '.png" width="47" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2N06() + '.png" width="15" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2N07() + '.png" width="32" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2N08() + '.png" width="15" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2N09() + '.png" width="54" height="15" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2M01() + '.png" width="66" height="35" border="0"></td>
     <td><img src="quat2/' + gFileQ2M02() + '.png" width="41" height="35" border="0"></td>
     <td><img src="quat2/' + gFileQ2M03() + '.png" width="53" height="35" border="0"></td>
     <td><img src="quat2/' + gFileQ2M04() + '.png" width="43" height="35" border="0"></td>
     <td><img src="quat2/' + gFileQ2M05() + '.png" width="49" height="35" border="0"></td>
     <td><img src="quat2/' + gFileQ2M06() + '.png" width="43" height="35" border="0"></td>
     <td><img src="quat2/' + gFileQ2M07() + '.png" width="71" height="35" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2L01() + '.png" width="43" height="46" border="0"></td>
     <td><img src="quat2/' + gFileQ2L02() + '.png" width="25" height="46" border="0"></td>
     <td><img src="quat2/' + gFileQ2L03() + '.png" width="68" height="46" border="0"></td>
     <td><img src="quat2/' + gFileQ2L04() + '.png" width="44" height="46" border="0"></td>
     <td><img src="quat2/' + gFileQ2L05() + '.png" width="72" height="46" border="0"></td>
     <td><img src="quat2/' + gFileQ2L06() + '.png" width="31" height="46" border="0"></td>
     <td><img src="quat2/' + gFileQ2L07() + '.png" width="35" height="46" border="0"></td>
     <td><img src="quat2/' + gFileQ2L08() + '.png" width="48" height="46" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2K01() + '.png" width="62" height="41" border="0"></td>
     <td><img src="quat2/' + gFileQ2K02() + '.png" width="79" height="41" border="0"></td>
     <td><img src="quat2/' + gFileQ2K03() + '.png" width="68" height="41" border="0"></td>
     <td><img src="quat2/' + gFileQ2K04() + '.png" width="51" height="41" border="0"></td>
     <td><img src="quat2/' + gFileQ2K05() + '.png" width="61" height="41" border="0"></td>
     <td><img src="quat2/' + gFileQ2K06() + '.png" width="45" height="41" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2J01() + '.png" width="45" height="29" border="0"></td>
     <td><img src="quat2/' + gFileQ2J02() + '.png" width="47" height="29" border="0"></td>
     <td><img src="quat2/' + gFileQ2J03() + '.png" width="74" height="29" border="0"></td>
     <td><img src="quat2/' + gFileQ2J04() + '.png" width="16" height="29" border="0"></td>
     <td><img src="quat2/' + gFileQ2J05() + '.png" width="57" height="29" border="0"></td>
     <td><img src="quat2/' + gFileQ2J06() + '.png" width="127" height="29" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2I01() + '.png" width="65" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2I02() + '.png" width="21" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2I03() + '.png" width="57" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2I04() + '.png" width="60" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2I05() + '.png" width="27" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2I06() + '.png" width="38" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2I07() + '.png" width="30" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2I08() + '.png" width="25" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2I09() + '.png" width="43" height="27" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2H01() + '.png" width="49" height="32" border="0"></td>
     <td><img src="quat2/' + gFileQ2H02() + '.png" width="64" height="32" border="0"></td>
     <td><img src="quat2/' + gFileQ2H03() + '.png" width="79" height="32" border="0"></td>
     <td><img src="quat2/' + gFileQ2H04() + '.png" width="71" height="32" border="0"></td>
     <td><img src="quat2/' + gFileQ2H05() + '.png" width="39" height="32" border="0"></td>
     <td><img src="quat2/' + gFileQ2H06() + '.png" width="20" height="32" border="0"></td>
     <td><img src="quat2/' + gFileQ2H07() + '.png" width="44" height="32" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2G01() + '.png" width="25" height="33" border="0"></td>
     <td><img src="quat2/' + gFileQ2G02() + '.png" width="63" height="33" border="0"></td>
     <td><img src="quat2/' + gFileQ2G03() + '.png" width="60" height="33" border="0"></td>
     <td><img src="quat2/' + gFileQ2G04() + '.png" width="31" height="33" border="0"></td>
     <td><img src="quat2/' + gFileQ2G05() + '.png" width="18" height="33" border="0"></td>
     <td><img src="quat2/' + gFileQ2G06() + '.png" width="35" height="33" border="0"></td>
     <td><img src="quat2/' + gFileQ2G07() + '.png" width="35" height="33" border="0"></td>
     <td><img src="quat2/' + gFileQ2G08() + '.png" width="31" height="33" border="0"></td>
     <td><img src="quat2/' + gFileQ2G09() + '.png" width="18" height="33" border="0"></td>
     <td><img src="quat2/' + gFileQ2G10() + '.png" width="50" height="33" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2F01() + '.png" width="49" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2F02() + '.png" width="28" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2F03() + '.png" width="51" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2F04() + '.png" width="71" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2F05() + '.png" width="46" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2F06() + '.png" width="42" height="27" border="0"></td>
     <td><img src="quat2/' + gFileQ2F07() + '.png" width="79" height="27" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2E01() + '.png" width="54" height="43" border="0"></td>
     <td><img src="quat2/' + gFileQ2E02() + '.png" width="77" height="43" border="0"></td>
     <td><img src="quat2/' + gFileQ2E03() + '.png" width="13" height="43" border="0"></td>
     <td><img src="quat2/' + gFileQ2E04() + '.png" width="52" height="43" border="0"></td>
     <td><img src="quat2/' + gFileQ2E05() + '.png" width="55" height="43" border="0"></td>
     <td><img src="quat2/' + gFileQ2E06() + '.png" width="73" height="43" border="0"></td>
     <td><img src="quat2/' + gFileQ2E07() + '.png" width="42" height="43" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2D01() + '.png" width="54" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2D02() + '.png" width="142" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2D03() + '.png" width="170" height="15" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2C01() + '.png" width="59" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2C02() + '.png" width="32" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2C03() + '.png" width="36" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2C04() + '.png" width="31" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2C05() + '.png" width="30" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2C06() + '.png" width="46" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2C07() + '.png" width="14" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2C08() + '.png" width="36" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2C09() + '.png" width="25" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2C10() + '.png" width="57" height="15" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2B01() + '.png" width="84" height="51" border="0"></td>
     <td><img src="quat2/' + gFileQ2B02() + '.png" width="37" height="51" border="0"></td>
     <td><img src="quat2/' + gFileQ2B03() + '.png" width="42" height="51" border="0"></td>
     <td><img src="quat2/' + gFileQ2B04() + '.png" width="62" height="51" border="0"></td>
     <td><img src="quat2/' + gFileQ2B05() + '.png" width="69" height="51" border="0"></td>
     <td><img src="quat2/' + gFileQ2B06() + '.png" width="30" height="51" border="0"></td>
     <td><img src="quat2/' + gFileQ2B07() + '.png" width="17" height="51" border="0"></td>
     <td><img src="quat2/' + gFileQ2B08() + '.png" width="25" height="51" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border="0" cellspacing="0" cellpadding="0">
    <tr>
     <td><img src="quat2/' + gFileQ2A01() + '.png" width="43" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2A02() + '.png" width="46" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2A03() + '.png" width="27" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2A04() + '.png" width="16" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2A05() + '.png" width="34" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2A06() + '.png" width="34" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2A07() + '.png" width="65" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2A08() + '.png" width="28" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2A09() + '.png" width="31" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2A10() + '.png" width="16" height="15" border="0"></td>
     <td><img src="quat2/' + gFileQ2A11() + '.png" width="26" height="15" border="0"></td>
    </tr>
   </table>
  </td>
 </tr>
</table>';
}
*/
