/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
#include "stdafx.h"
#include "States.h"

//#include <conio.h>
//#include <stdio.h>

#include "cvocab.hpp"
#include "CondActsArray.h"


/*GLOBAL DATA */
/*------------*/

CVocab Vocabulary;				//The vocabulary Object
CMessageList SysMsgs, StdMsgs;	//Messages
CObjectList ObjectList;			//Objects
CAdvMap Locations;				//Locations
CProcessTable* Tables[1024];		//Process Tables
int ProcessTableCount = 0;		//Count of the number of the above!!
bool BlanksOK = false;			//blanks ignored or not!!
char filename[255]="input.txt";
int Registered = 0;
int Debug = 1;

/************************/

int GetVocab();
int GetWordType( CString );

int GetSysMsgs();
int GetStdMsgs();
int GetObjectText();
int GetLocationText();
int GetConnections();
int GetObjectDefs();
int GetProcessTables();
int GetCondActNum( char * );
char *my_fgets( char *string, int count, FILE *stream );
void check_for_lnk( char *string );
void print_error( char *error_text, CString Param1 = "");
bool CheckParam( int type, CString Param1, char *output );


int SourceLine=0; // Holds Current Source Line.
FILE *InFile;

void main( int argc, char *argv[] )
{
	int state=CTL;
	int vocab_entries=0;
	SourceLine = 0;
	CFile f;
	char buf[512];
	int Counter;

	if ( argc < 3 )
	{
		printf ("Usage :- Compiler inputfile outputfile [nodebug]\n");
		exit(-1);
	}

	if (argc == 4 )
	{
		if ( strcmp ( argv[3],"nodebug" ) != 0 )
		{
			printf ("Usage :- Compiler inputfile outputfile [nodebug]\n");
			exit(-1);
		}
		Debug = 0;
	}

	if ( (InFile = fopen (argv[1],"r"))== NULL )
	{
		printf("Error Opening Input File \n");
		exit(-1);
	}

	if( !f.Open( argv[2], CFile::modeCreate | CFile::modeWrite ) ) 
	{
		print_error("Cannot write to file");
		exit(1);
	}

	strcpy ( filename, argv[1] ); //copy filename;


	CArchive ar( &f, CArchive::store, 512, buf );

	while (state != COMP_END )
	{
		switch( state )

		{
		case CTL:
			state = VOC;
			break;

		case VOC:
			vocab_entries++;
			state = GetVocab();
			break;

		case STX:
			printf("%d Vocabulary entries processed\n",vocab_entries);
			state = GetSysMsgs();
			break;

		case MTX:
			BlanksOK=true;
			state = GetStdMsgs();
			break;

		case OTX:
			BlanksOK=true;
			state = GetObjectText();
			break;

		case LTX:
			BlanksOK=true;
			state = GetLocationText();
			break;

		case CON:
			BlanksOK=false;
			state = GetConnections();
			break;

		case OBJ:
			 state = GetObjectDefs();
			break;

		case PRO:
			//do PRO stuff
			state = GetProcessTables();
			break;

		case COMP_ERROR:
			if (Tables != NULL )
			exit(-1);

		default: //Should never get here!!!!!!
				print_error("Compiler Internal Error");
				exit(-1);
				break;
		}
	}

	Vocabulary.Serialize( ar );
	SysMsgs.Serialize( ar );
	StdMsgs.Serialize( ar );
	ObjectList.Serialize( ar );
	Locations.Serialize( ar );
	ar<<ProcessTableCount;

	for ( Counter=0; Counter<ProcessTableCount; Counter++ )
	{
		Tables[Counter]->Serialize( ar );
	}


	ar << (int) 1;//REGISTERED FLAG (NOT USED ATM)

	ar << Debug;

	fclose ( InFile );

}

int GetVocab()
{
	char Input[255];
	char Word[10];
	char Type[10];
	int Num;
	int Status;
	int WordType;
	char *IsEof;

	IsEof = my_fgets(Input, 255, InFile);
	if( IsEof == NULL )
	{
		print_error("Unexpected end of file.");
		return COMP_ERROR;
	}
	else
		if ( Input[0] == '/' )
		{
			Input[4]='\0'; //Ignore the rest of the Line
			if ( strcmp ( "/STX", Input ) != 0 )
			{
				print_error("/STX Expected");
				return COMP_ERROR;
			}
			else
			{
				return STX; //Next Section
			}
		}
		else
		{
			Status=sscanf(Input,"%s%d%s",Word,&Num,Type );
			if ( Status != 3 )
			{
				print_error("Syntax Error");
				return COMP_ERROR;
			}
		
			WordType= GetWordType( Type );
			if (WordType == -1 )
			{
				print_error("Incorrect word type");
				return COMP_ERROR;
			}

		switch( WordType )
		{
		case V_NOUN:
			Vocabulary.SetNoun( Word, Num );
			break;
	
		case V_VERB:
			Vocabulary.SetVerb( Word, Num );
			break;

		case V_ADJECTIVE:
			Vocabulary.SetAdjective( Word, Num );
			break;

		case V_ADVERB:
			Vocabulary.SetAdverb( Word, Num );
			break;

		case V_PREPOSITION:
			Vocabulary.SetPreposition( Word, Num );
			break;

		case V_PRONOUN:
			Vocabulary.SetPronoun( Word, Num );
			break;

		case V_CONJUGATION:
			Vocabulary.SetConjugation( Word, Num );
			break;
		}


	}
return VOC;
}


int GetWordType( CString Word )
{
	Word.MakeUpper();
	if ( Word == "VERB" ) return V_VERB;
	if ( Word == "NOUN" ) return V_NOUN;
	if ( Word == "ADJECTIVE" ) return V_ADJECTIVE;
	if ( Word == "ADVERB" ) return V_ADVERB;
	if ( Word == "PREPOSITION" ) return V_PREPOSITION;
	if ( Word == "PRONOUN" ) return V_PRONOUN;
	if ( Word == "CONJUGATION" ) return V_CONJUGATION;

	return -1;
}

int GetSysMsgs( void )
{
	char CurrentLine[1024];
	int Finished = 0;
	int LastMessage = -1; // Cannot be below 60
	int MessageNum=0;
	char temp;
	CString MessageText,TempString;
	bool NewLineRequired = true;


	my_fgets(CurrentLine, 1024, InFile);

	while ( !Finished )
	{
		if (CurrentLine[0] != '/' )
		{
			print_error("Syntax Error / expected ");
			return COMP_ERROR;
		}

		CurrentLine[5]='\0';
		SysMsgs.MaxMessages = MessageNum;
		if ( strncmp ( CurrentLine, "/MTX",4 ) == 0)
		{
			printf("%d System Messages processed\n",MessageNum );
			return MTX;
		}

		if (sscanf( CurrentLine, "%c%d", &temp, &MessageNum ) != 2 )
		{
			print_error("Message Number Expected");
			return COMP_ERROR;
		}

		/*if (MessageNum < 0 )
		{
			printf("Error System Messages Begin at 60\n");
			return COMP_ERROR;
		}*/

		if (MessageNum <= LastMessage++ )
		{
			print_error("Message Number Out Of Step");
			return COMP_ERROR;
		}

		my_fgets (CurrentLine, 1024, InFile);
			
		while ( CurrentLine[0] != '/' )
			{
				/*if (CurrentLine[0] < (char)32)
				{
					printf("Error : Blank Line ?");
					return COMP_ERROR;
				}
				*/
				TempString = CurrentLine;
				if ( CurrentLine[0] =='\n' )
				{
					if ( NewLineRequired )
					{
						MessageText = MessageText + "\n" ;
						NewLineRequired=false;
					}
				}
				else
				{
					NewLineRequired=true;//reset new line flag
				}

//				if ( TempString.GetAt( TempString.GetLength() ) == '\n' )
//					TempString= TempString.Left( TempString.GetLength()-1);
				if ( MessageText != "" )
					MessageText = MessageText + " " +TempString;
				else
					MessageText = TempString;
				
				my_fgets( CurrentLine, 1024, InFile );
			}

			SysMsgs.SetMessage( MessageNum, MessageText );
			MessageText = "";

	}
	return COMP_ERROR;
}


int GetStdMsgs( void )
{
	char CurrentLine[1024];
	int Finished = 0;
	int LastMessage = -1; // Cannot be below 0
	int MessageNum=0;
	char temp;
	CString MessageText,TempString;
	bool NewLineRequired;


	my_fgets( CurrentLine, 1024, InFile );

	while ( !Finished )
	{
		if (CurrentLine[0] != '/' )
		{
			print_error(" / expected ");
			return COMP_ERROR;
		}

		StdMsgs.MaxMessages = MessageNum;
		CurrentLine[5]='\0';
		if ( strncmp ( CurrentLine, "/OTX",4 ) == 0)
		{
			printf("%d User messages processed\n",MessageNum );
			return OTX;
		}

		if (sscanf( CurrentLine, "%c%d", &temp, &MessageNum ) != 2 )
		{
			print_error("Message Number Expected");
			return COMP_ERROR;
		}

		
		if (MessageNum <= LastMessage++ )
		{
			print_error("Message Number Out Of Step");
			return COMP_ERROR;
		}

		my_fgets( CurrentLine, 1024, InFile );
			
		while ( CurrentLine[0] != '/' )
			{
			/*
				if (CurrentLine[0] < (char)32)
				{
					printf("Error : Blank Line ?");
					return COMP_ERROR;
				}
			*/
				TempString = CurrentLine;
				
				if ( CurrentLine[0] =='\n' )
				{
					if ( NewLineRequired )
					{
						MessageText = MessageText + "\n" ;
						NewLineRequired=false;
					}
				}
				else
				{
					NewLineRequired=true;//reset new line flag
				}


//				if ( TempString.GetAt( TempString.GetLength() ) == '\n' )
//					TempString= TempString.Left( TempString.GetLength()-1);
				if ( MessageText != "" )
					MessageText = MessageText + " " +TempString;
				else
					MessageText = TempString;
				my_fgets( CurrentLine, 1024, InFile );
			}

			StdMsgs.SetMessage( MessageNum, MessageText );
			MessageText = "";

	}
	return COMP_ERROR;
}

int GetObjectText( void )
{
	char CurrentLine[1024];
	int Finished = 0;
	int LastObject = -1; // Cannot be below 0
	int ObjectNum;
	char temp;
	CString ObjectText,TempString;

	my_fgets( CurrentLine, 1024, InFile );

	while ( !Finished )
	{
		if (CurrentLine[0] != '/' )
		{
			print_error(" / expected ");
			return COMP_ERROR;
		}

		CurrentLine[4]='\0';
		if ( strcmp ( CurrentLine, "/LTX" ) == 0)
		{
			printf("%d Object Texts Processed\n",ObjectNum+1 );
			return LTX;
		}

		if (sscanf( CurrentLine, "%c%d", &temp, &ObjectNum ) != 2 )
		{
			print_error("Object Number Expected");
			return COMP_ERROR;
		}

		
		if (ObjectNum <= LastObject++ )
		{
			print_error("Object Number Out Of Step");
			return COMP_ERROR;
		}

		my_fgets( CurrentLine, 1024, InFile );
			
		while ( CurrentLine[0] != '/' )
			{
			/*
				if (CurrentLine[0] < (char)32)
				{
					printf("Error : Blank Line ?");
					return COMP_ERROR;
				}
			*/
				TempString = CurrentLine;
				ObjectText = ObjectText + TempString;
				my_fgets( CurrentLine, 1024, InFile );
			}

			ObjectList.SetObjectDesc( ObjectNum, ObjectText );
			ObjectText = "";

	}
	return COMP_ERROR;
}

int GetLocationText( void )
{
	char CurrentLine[1024];
	int Finished = 0;
	int LastLocation = -1; // Cannot be below 1
	int LocationNum;
	char temp;
	CString LocationText,TempString;

	my_fgets( CurrentLine, 1024, InFile );

	while ( !Finished )
	{
		if (CurrentLine[0] != '/' )
		{
			print_error(" / expected ");
			return COMP_ERROR;
		}

		CurrentLine[4]='\0';

		Locations.MaxLocation = LocationNum;

		if ( strcmp ( CurrentLine, "/CON" ) == 0)
		{
			BlanksOK=false;
			printf("%d Location Texts Processed\n",LocationNum+1);
			return CON;
		}

		if (sscanf( CurrentLine, "%c%d", &temp, &LocationNum ) != 2 )
		{
			print_error("Location Number Expected");
			return COMP_ERROR;
		}

		
		if (LocationNum <= LastLocation++ )
		{
			print_error("Location Number Out Of Step");
			return COMP_ERROR;
		}

		BlanksOK = true;

		my_fgets( CurrentLine, 1024, InFile );
			
		while ( CurrentLine[0] != '/' )
			{
				TempString = CurrentLine;
				LocationText = LocationText + TempString;
				my_fgets( CurrentLine, 1024, InFile );
			}

			Locations.SetDescription( LocationNum, LocationText );
			LocationText = "";

	}
	return COMP_ERROR;
}

int GetConnections( void )
{
	char CurrentLine[255];
	int Finished = 0;
	int LastLocation = -1; // Cannot be below 0
	int LocationNum;
	char temp;
	char Word[10];
	int Verb;
	int LocNum;
	

	my_fgets( CurrentLine, 255, InFile );

	while ( !Finished )
	{
		if (CurrentLine[0] != '/' )
		{
			print_error("/ expected ");
			return COMP_ERROR;
		}

		CurrentLine[4]='\0';
		if ( strcmp ( CurrentLine, "/OBJ" ) == 0)
		{
			printf ("%d Connections Processed\n",LocationNum+1);
			return OBJ;
		}
		if (sscanf( CurrentLine, "%c%d", &temp, &LocationNum ) != 2 )
		{
			print_error("Location Number Expected");
			return COMP_ERROR;
		}

		
		if (LocationNum <= LastLocation++ )
		{
			print_error("Location Number Out Of Step");
			return COMP_ERROR;
		}

		if (LocationNum > Locations.MaxLocation )
		{
			print_error("Error location Doesn't Exist");
			return COMP_ERROR;
		}

		my_fgets( CurrentLine, 255, InFile );
			
		while ( CurrentLine[0] != '/' )
			{
			/*
				if (CurrentLine[0] < (char)32)
				{
					printf("Error : Blank Line ?");
					return COMP_ERROR;
				}
			*/	
				if (sscanf( CurrentLine,"%s%d",(LPCTSTR)Word,&LocNum ) != 2 )
				{
					print_error("Syntax Error");
					return COMP_ERROR;
				}
				
				Verb = Vocabulary.GetVerb ( Word );
				if ( Verb == -1 ) 
				{
					char temp[255];
					sprintf (temp,"Verb - %s Not found",Word);
					print_error(temp);
					return COMP_ERROR;
				}
				Locations.SetConnection( LocationNum, Verb, LocNum );
				my_fgets( CurrentLine, 255, InFile );


			}

	}
	return COMP_ERROR;
}

int GetObjectDefs()
{
char CurrentLine[255];
	char temp;
	int Finished = 0;
	int LastObject = -1; 
	int CurrentObject;
	char StartLoc[10];
	int Location;
	char Wearable[10];
	char Container[10];
	int Weight;
	char StringWeight[10];
	char Noun[11];
	char Adjective[11];
	int NounNo, AdjectiveNo;
	CObjectDef *Object;


	my_fgets( CurrentLine, 255, InFile );

	while ( !Finished )
	{
		if (CurrentLine[0] != '/' )
		{
			print_error(" / expected ");
			return COMP_ERROR;
		}

		if (strncmp( "/PRO", CurrentLine,4 ) == 0)
		{
			printf("%d Object Definitions Processed\n",CurrentObject+1);
			return PRO;
		}

		if (sscanf( CurrentLine, "%c%d%s%s%s%s%s%s",&temp,
												  &CurrentObject,
												  StartLoc,
												  StringWeight,
												  Container,
												  Wearable,
												  Noun,
												  Adjective) != 8 )
		{
			print_error("Not Enough Paramaters");
			return COMP_ERROR;
		}

		if (StringWeight[0] == '_' ) Weight=0;
		else
			sscanf(StringWeight,"%d",&Weight);

		if (CurrentObject != (LastObject+1) )
		{
			print_error("Object Number Out Of Step");
			return COMP_ERROR;
		}
		
		NounNo = Vocabulary.GetNoun ( Noun ); //Validate Noun
				if ( NounNo == -1 ) 
				{
					if ( Noun[0] != '_' ) //NULL WORD
					{
						char temp[255];
						sprintf(temp,"Noun - %s Not found",Noun);
						print_error(temp);
						return COMP_ERROR;
					}
				}
				
		AdjectiveNo = Vocabulary.GetAdjective( Adjective ); //Validate Adjective
				if( AdjectiveNo == -1 )
				{
					if (Adjective[0] != '_' )
					{
						char temp[255];
						sprintf(temp,"Adjective - %s Not Found",Adjective );
						print_error( temp );
						return COMP_ERROR;
					}
				}
				if ((AdjectiveNo!=-1) && ( NounNo == -1 ))
				{
					print_error("You must specify a Noun");
					return COMP_ERROR;
				}

				if ( (Weight > 63 ) || (Weight < 0) )
				{
					print_error("Weight must me in the range 0 - 63");
					return COMP_ERROR;
				}

				if ( StartLoc[0]=='C' ) Location = OBJ_CARRIED;
				else if ( StartLoc[0]=='W' ) Location = OBJ_WORN;
				else if ( StartLoc[0]=='_' ) Location = OBJ_NOT_CREATED;
				else if ( sscanf( StartLoc,"%d",&Location ) != 1 )
						{
							print_error("Location Does Not Exist" );
							return COMP_ERROR;
						}
				Object = new CObjectDef();
				Object -> Adjective = AdjectiveNo;
				Object -> Noun = NounNo;
				Object -> StartLocation = Location;
				Object -> ObjWeight = Weight;
				Object -> Wearable = ( Wearable[0]=='Y' );
				Object -> Container = ( Container[0] == 'Y' );
				ObjectList.SetObject( CurrentObject, Object );

		LastObject++;
		my_fgets(CurrentLine, 255, InFile );
	}
	return COMP_ERROR;
}

int GetProcessTables()
{
	char CurrentLine[255];
	char *temp; //remove after debugging!!!
	CProcessTable* p_ProcessTable;
	bool EndOfFile = false , EndOfTable = false;
	char Verb[20], Noun[20], CondAct[20];
	int Param1, Param2;
	CString StrParam1, StrParam2;
	int NounNo, VerbNo;
	int CondActNo;
	int CondActCounter=0;
	int ConditionCounter=0;
	CCondAct *p_CondAct;
	Condition *p_Condition;

	char TempString1[100];
	char TempString2[100];
	char TempString[100];
	int TempInt;

	
	while (!EndOfFile)
	{
		CondActCounter=0;
		ConditionCounter=0;
		EndOfTable=false;
		Tables[ProcessTableCount]=new CProcessTable;
		p_ProcessTable=Tables[ProcessTableCount];
		if ((temp=my_fgets(CurrentLine, 255, InFile )) == NULL )
		{
			print_error("Unexpected End Of File Reached");
			return COMP_ERROR;
		}

		while(!EndOfTable)
		{
			Param1=0;
			Param2=0;
			sscanf(CurrentLine,"%s%s%s%s%s",Verb,Noun,CondAct,TempString1, TempString2); /* Read input */

			NounNo = Vocabulary.GetNoun ( Noun ); //Validate Noun
				if ( NounNo == -1 ) 
				{
					if ( Noun[0] != '_' ) //NULL WORD
					{
						char temp[255];
						sprintf (temp,"Noun - %s Not found",Noun);
						print_error(temp);
						return COMP_ERROR;
					}
				}

			VerbNo = Vocabulary.GetVerb ( Verb ); //Validate Verb
				if ( VerbNo == -1 ) 
				{
					if ( Verb[0] != '_' ) //NULL WORD
					{
						char temp[255];
						sprintf (temp,"Verb - %s Not found",Verb);
						print_error( temp);
						return COMP_ERROR;
					}
				}
				
			CondActNo = GetCondActNum( CondAct );
				if ( CondActNo == -1 )
				{
					print_error("CondAct Not Recognised " );
					return COMP_ERROR;
				}
				StrParam1=TempString1;
				StrParam2=TempString2;

				switch ( CondActNo )
				{
				case	ADJECT1:
					Param1 = Vocabulary.GetAdjective( StrParam1 );
					if ( Param1 == -1 )
					{
						char temp[255];
						sprintf (temp,"Adjective - %s Not found",StrParam1);
						print_error(temp);
						return COMP_ERROR;
					}
					break;

				case	ADVERB:
					Param1 = Vocabulary.GetAdverb( StrParam1 );
					if ( Param1 == -1 )
					{
						char temp[255];
						sprintf (temp,"Adverb - %s Not found",StrParam1);
						print_error(temp);
						return COMP_ERROR;
					}
					break;

				case	PREP:
					Param1 = Vocabulary.GetPreposition( StrParam1 );
					if ( Param1 == -1 )
					{
						char temp[255];
						sprintf (temp,"Preposition - %s Not found",StrParam1);
						print_error(temp);
						return COMP_ERROR;
					}
					break;

				case NOUN2:
					Param1 = Vocabulary.GetNoun( StrParam1 );
					if ( Param1 == -1 )
					{
						char temp[255];
						sprintf (temp,"Noun - %s Not found",StrParam1);
						print_error(temp);
						return COMP_ERROR;
					}
					break;

				case ADJECT2:
					Param1 = Vocabulary.GetAdjective( StrParam1 );
					if ( Param1 == -1 )
					{
						char temp[255];
						sprintf (temp,"Adjective - %s Not found",StrParam1);
						print_error(temp);
						return COMP_ERROR;
					}
					break;

				default:
					if (CondactActArray[CondActNo].type1 != NONE ) 
					{
						if ( !CheckParam( CondactActArray[CondActNo].type1, StrParam1, temp ) )
						{
							print_error(temp);
							return COMP_ERROR;
						}
					}
					
					if (CondactActArray[CondActNo].type2 != NONE ) 
					{
						if ( !CheckParam( CondactActArray[CondActNo].type2, StrParam2, temp ) )
						{
							print_error(temp);
							return COMP_ERROR;
						}
					}
				}
					if ( StrParam1 == "HERE" )		Param1 = OBJ_HERE;
					if ( StrParam1 == "CARRIED" )	Param1 = OBJ_CARRIED;
					if ( StrParam1 == "WORN" )		Param1 = OBJ_WORN;
					if ( StrParam2 == "HERE" )		Param2 = OBJ_HERE;
					if ( StrParam2 == "CARRIED" )	Param2 = OBJ_CARRIED;
					if ( StrParam2 == "WORN" )		Param2 = OBJ_WORN;

					if ( Param1 == 0 ) sscanf( StrParam1,"%d",&Param1 );
					if ( Param2 == 0 ) sscanf( StrParam2,"%d",&Param2 );
				

				p_Condition=new Condition;
				p_Condition->CondAct=CondActCounter;
				p_Condition->Verb=VerbNo;
				p_Condition->Noun=NounNo;
				p_ProcessTable->Conditions.Add(p_Condition);
				p_ProcessTable->ConditionCount++;

				p_CondAct= new CCondAct;
				CondActCounter++;
				p_CondAct->OpCode = CondActNo;
				p_CondAct->Param1 = Param1;
				p_CondAct->Param2 = Param2;
				p_CondAct->First = true;
				p_ProcessTable->Processes.Add(p_CondAct);
				p_ProcessTable->ProcessCount++;
				
				if ((temp=my_fgets(CurrentLine, 255, InFile ))==NULL)
				{
					EndOfFile=true;
					EndOfTable=true;
				}

				if(!EndOfTable)
				{

					while( CurrentLine[0]==' ' || CurrentLine[0]=='\t' )
					{
						sscanf(CurrentLine,"%s%s%s",CondAct,TempString1, TempString2); /* Read input */
					
						CondActNo = GetCondActNum( CondAct );
						if ( CondActNo == -1 )
						{
							print_error("CondAct Not Recognised");
							return COMP_ERROR;
						}
				Param1=Param2=0;

				StrParam1=TempString1;
				StrParam2=TempString2;
		
				switch ( CondActNo )
				{
				case	ADJECT1:
					Param1 = Vocabulary.GetAdjective( StrParam1 );
					if ( Param1 == -1 )
					{
						char temp[255];
						sprintf (temp,"Adjective - %s Not found",StrParam1);
						print_error(temp);

						return COMP_ERROR;
					}
					break;

				case	ADVERB:
					Param1 = Vocabulary.GetAdverb( StrParam1 );
					if ( Param1 == -1 )
					{
						char temp[255];
						sprintf (temp,"Adverb - %s Not found",StrParam1);
						print_error(temp);

						return COMP_ERROR;
					}
					break;

				case	PREP:
					Param1 = Vocabulary.GetPreposition( StrParam1 );
					if ( Param1 == -1 )
					{
						char temp[255];
						sprintf (temp,"Preposition - %s Not found",StrParam1);
						print_error(temp);

						return COMP_ERROR;
					}
					break;

				case NOUN2:
					Param1 = Vocabulary.GetNoun( StrParam1 );
					if ( Param1 == -1 )
					{
						char temp[255];
						sprintf (temp,"Noun - %s Not found",StrParam1);
						print_error(temp);

						return COMP_ERROR;
					}
					break;

				case ADJECT2:
					Param1 = Vocabulary.GetAdjective( StrParam1 );
					if ( Param1 == -1 )
					{
						char temp[255];
						sprintf (temp,"Adjective - %s Not found",StrParam1);
						print_error(temp);

						return COMP_ERROR;
					}
					break;

				default:
					if (CondactActArray[CondActNo].type1 != NONE ) 
					{
						if ( !CheckParam( CondactActArray[CondActNo].type1, StrParam1, temp ) )
						{
							print_error(temp);
							return COMP_ERROR;
						}
					}
					
					if (CondactActArray[CondActNo].type2 != NONE ) 
					{
						if ( !CheckParam( CondactActArray[CondActNo].type2, StrParam2, temp ) )
						{
							print_error(temp);
							return COMP_ERROR;
						}
					}
				}
					if ( StrParam1 == "HERE" )		Param1 = OBJ_HERE;
					if ( StrParam1 == "CARRIED" )	Param1 = OBJ_CARRIED;
					if ( StrParam1 == "WORN" )		Param1 = OBJ_WORN;
					if ( StrParam2 == "HERE" )		Param2 = OBJ_HERE;
					if ( StrParam2 == "CARRIED" )	Param2 = OBJ_CARRIED;
					if ( StrParam2 == "WORN" )		Param2 = OBJ_WORN;

					if ( Param1 == 0 ) sscanf( StrParam1,"%d",&Param1 );
					if ( Param2 == 0 ) sscanf( StrParam2,"%d",&Param2 );
				

						p_CondAct= new CCondAct;
						CondActCounter++;
						p_CondAct->OpCode = CondActNo;
						p_CondAct->Param1 = Param1;
						p_CondAct->Param2 = Param2;
						p_CondAct->First = false;
						p_ProcessTable->Processes.Add(p_CondAct);
						p_ProcessTable->ProcessCount++;
					
						if (my_fgets(CurrentLine, 255, InFile )==NULL )
						{
							EndOfTable=true;
							EndOfFile=true;
							CurrentLine[0]=(char)255;
							continue; //Ugh Yuk
						}
					}

					sscanf( CurrentLine,"%s%d", TempString, &TempInt );
					if ( strcmp( TempString,"/PRO" ) == 0 )
						{
							EndOfTable = true;
						}
					}
			}

		p_Condition = new Condition;
		p_Condition->Noun = -2; /* Mark the end point - used for searialization */
		p_ProcessTable->Conditions.Add(p_Condition);
	
		ProcessTableCount++;

		if ( (ProcessTableCount != TempInt) && (!EndOfFile) )
		{
			char temp[255];
			sprintf(temp,"Process Table Number %d Expected",ProcessTableCount );
			print_error( temp );
			return COMP_ERROR;
		}
	
	}
	printf("%d Process Tables Processed",ProcessTableCount );
	return COMP_END;
}

int GetCondActNum( char *Text )
{
	int count;
	for(count=0; count<1000; count++)
	{
		if (strcmp( Text,CondactActArray[count].Name)==0) return count;
		if (CondactActArray[count].Name[0]=='*') return -1;
	}
	return -1; /*should never get here i hope!! 1000 condacts is ambitious but leaves room for
				expansion!!!!!*/



}

char *my_fgets( char *string, int count, FILE *stream ) 
{
	char *temp;
	string[0] = '#';

	
	while ( (string[0] == '#') || ((string[0] == '\n') && (!BlanksOK ))  ) //discard blank lines an comments 
	{
		SourceLine++;
		temp = fgets( string, count, stream );

		 if (temp == NULL ) return NULL;
		check_for_lnk(string);
	}

	if ( (temp != NULL) && (!BlanksOK) )
	{
		string[ strlen( string )-1 ] = '\0';
	}
	return temp;
}

void check_for_lnk( char *string )
{
	char temp[50];
	strncpy( temp, string,4 );
	temp[4]='\0';
	if( strcmp( "/LNK", temp ) == 0 )
	{
		sscanf( string,"%s%s",temp,filename );
		printf("\nOpening File %s\n\n",filename );
		fclose( InFile );
		InFile = fopen( filename,"r");
		string[0]='#';
		SourceLine=0;
		if ( InFile == NULL ) 
		{
			printf("Error Opening %s - %s\n",filename, strerror(errno) );
			exit(-1);
		}
	}
}

void print_error( char *error_text, CString Param1)
{
	CString Temp;
	if ( Param1 != "" )
		Temp = error_text + Param1;
	else
		Temp = error_text;

	printf("ERROR - %s at line %d. Filename %s\n",Temp, SourceLine, filename );
}

bool CheckParam( int type, CString Param1, char *output )
{
	int param1;
	
	sscanf((LPCTSTR)Param1,"%d",&param1);

	switch ( type )
	{
	case FLAG:
		if ((param1 > 999) || ( param1 < 0 ))
		{
			sprintf(output,"Flag number out of range ( 0 -> 999 ) ");
			return false;
		}
		break;

	case LOCATION:
		if ( !Locations.validate( param1 ) )
		{
			sprintf(output,"Location %d does not exist ",param1 );
			return false;
		}
		break;

	case SYSTEMMESS:
		if ( !SysMsgs.validate( param1 ) )
		{
			sprintf( output,"System Message %d not defined ",param1 );
			return false;
		}
		break;

	case USRMESS:
		if ( !StdMsgs.validate( param1 ))
		{
			sprintf( output,"User Message %d not defined",param1 );
			return false;
		}
		break;

	case OBJECT:
		if( !ObjectList.validate( param1 ) )
		{
			sprintf( output, "Object %d undefined ",param1 );
			return false;
		}
		break;

	}

	return true; //validated!!!!
}