/* Perdition's Flames - Downtown section */
// copyright (c) 1993, 2002 by Michael J. Roberts.

downtown: room
    sdesc = "Downtown"
    ldesc = "You're in the center of Hell's business district.
        To the north is an extremely tall tower, which reaches
        up into the sky; the top is lost in mist high above.
        An archway leads south.  You can go down the street
        to the east and west."
    south = courtyard
    east = downtown2
    west = suburbWest
    north = towerbase
;

downtown2: room
    sdesc = "Downtown"
    ldesc = "You're on a street in downtown Hell.  To the south
        is the entrance to a large low-rise building labeled
        \"Infernolab,\" and to the north is the fortress-like
        Bank of Hell.  The street continues east and west.
        A narrow alley leads alongside the Infernolab building
        to the southwest."
    east = suburbEast
    west = downtown
    south = infernolab
    sw = alley
    north = bank
;

tellerPapers: decoration
    sdesc = "pile of papers"
    noun = 'pile' 'paper' 'papers'
    location = bank
;

teller: Actor
    isHim = true
    location = bank
    sdesc = "teller"
    noun = 'teller' 'tellers' 'vest' 'shirt' 'tie' 'bowtie'
    ldesc = "He looks to be in his early thirties.  Like all the
        other tellers, he's dressed in a pin-stripe vest, white
        shirt, and bow tie."
    actorDesc = nil
    verGrab(obj) = {}
    verIoGiveTo(actor) = {}
    ioGiveTo(actor, dobj) =
    {
        if (dobj = infernoCheck or dobj = driversLicense or dobj = csCard)
        {
            "\"Thank you,\" the teller says, accepting << dobj.thedesc
            >> and looking it over carefully. ";
            dobj.moveInto(self);

            if (driversLicense.location <> self)
                "\"I'll need to see your Driver's License, please.\"";
            else if (csCard.location <> self)
                "\"I'll need to see your Celestial Security Card, please.\"";
            else if (infernoCheck.location <> self)
                "\"Now, what did you want to cash?\"";
            else
            {
                "\"I have all of the required documentation now,\" the
                teller says. \"One moment, please.\" He takes some papers
                out from below the counter, and starts thumbing through
                them. He then gets out a rubber stamp, inks it elaborately,
                turns the check over, and stamps it.  He repeats this
                process five times with different rubber stamps.
                \"Sign here,\" he says, offering you a pen; you sign
                the check and hand it back to him.
                \n\tThe teller picks up all the documents, then walks
                back to one of the desks behind the counter. He and
                the older man behind the desk confer for a few moments;
                the teller points at you, and the older man looks up,
                then looks back at the documents.  Finally, the man
                behind the desk initials the check, and initials several
                other pieces of paper the teller took with him; the
                teller collects the paperwork and returns to the counter.
                \n\t\"Let's see,\" he says, inspecting the check, \"twenty
                Hellmids.\" He takes a key out of his pocket, unlocks a
                drawer behind the counter, takes out a banknote, and
                hands it to you, along with your driver's license and
                Celestial Security card.
                \n\t\"Thank you very much for visiting the Bank of
                Hell today,\" he says.";

                awardPoints(25, self);
                driversLicense.moveInto(Me);
                csCard.moveInto(Me);
                twentyHellmids.moveInto(Me);
                infernoCheck.moveInto(nil);
            }
        }
        else if (dobj = twentyHellmids)
        {
            "\"I'm sorry, but it's against bank policy to
            make change. Management doesn't believe there's
            a profit in it.\"";
        }
        else if (dobj = dollar)
            "\"I'm sorry, we can't convert this currency to
            Hellmids.  You should have converted that prior
            to entering Hell.  You can't take it with you!\"";
        else
            "He looks confused. \"I don't have any use for that.\"";
    }
    ioSynonym('GiveTo') = 'ShowTo'
    actorDaemon =
    {
        "\bThe teller looks at you expectantly.";
    }
    actorAction(v, d, p, i) =
    {
        if (v = helloVerb)
            "\"Good day.  How may I help you?\"";
        exit;
    }
    doSynonym('AskAbout') = 'TellAbout'
    verDoAskFor(actor, iobj) = {}
    doAskFor(actor, iobj) =
    {
        if (iobj = twentyHellmids)
            "\"I'm sorry, you'll have to give me something to cash.\"";
        else
            "He seems more interested in discussing official bank business.";
    }
    disavow = "He seems more interested in discussing bank business."
    askWord(word, lst) =
    {
        switch(word)
        {
        case 'check':
        case 'hellmid':
        case 'hellmids':
            "\"I'll be happy to cash a check, although we require
            two forms of identification.\"";
            break;

        case 'dollar':
        case 'dollars':
            "\"I'm afraid we can't convert that currency.  You should
            have changed that before entering Hell. You know what
            they say -- 'you can't take it with you'!\"";
            break;

        case 'license':
            "\"A driver's license is acceptable identification. Two
            forms of identification are required.\"";
            break;

        case 'celestial':
        case 'security':
        case 'card':
            "\"A Celestial Security card is acceptable identification.
            Two forms of identification are required.\"";
            break;

        default:
            return(nil);
        }
        return(true);
    }
;

driversLicense: item
    sdesc = "driver's license"
    noun = 'license'
    adjective = 'drivers' 'driver\'s' 'driver'
    ldesc = "In addition to the terrible picture of you (with your
       eyes closed, of course), the license reads:\b
         \bINFERNAL DEPARTMENT OF MOTOR VEHICLES
         \n\t\tDriver's License
         \bName:\ << self.driverName >>
         \bAge:\ \ << self.driverAge >>"
;

csCard: item
    sdesc = "Celestial Security Card"
    noun = 'card'
    adjective = 'celestial' 'security'
    ldesc = "Celestial Security Administration
        \bName:\ \ \ << self.cardName >>
        \bNumber:\ 1078-10383-203-1313-612"
;

twentyHellmids: item
    sdesc = "twenty Hellmid bill"
    noun = 'bill' 'hellmid' 'hellmids' 'money'
    adjective = 'twenty' '20' 'hellmid'
;

bankLights: fixeditem
    location = bank
    sdesc = "banker's lamp"
    noun = 'light' 'lights' 'lamp' 'lamps'
    adjective = 'green' 'banker\'s' 'banker'
    ldesc = "They're the kind of short desk lamps, with green glass
        shades, that bankers seem to prefer."
;

bankDesks: fixeditem
    location = bank
    sdesc = "desk"
    noun = 'desk' 'desks' 'chair' 'chairs' 'armchair' 'armchairs'
    adjective = 'huge' 'oak'
    ldesc = "You can't see much more detail, since they're all
        behind the counter."
;

bankCounter: fixeditem
    location = bank
    sdesc = "counter"
    noun = 'counter'
;

bankGranite: fixeditem
    location = bank
    noun = 'block' 'blocks'
    sdesc = "granite block"
    adjective = 'granite'
;

bankCustomers: fixeditem
    noun = 'customer' 'customers'
    location = bank
    sdesc = "customer"
    ldesc = "They're all going about their business."
;

bank: room
    sdesc = "Bank of Hell"
    ldesc = "You're in the cavernous interior of the main office of
        the Bank of Hell.  The style is very 19th Century: the building
        itself is made of granite blocks; huge oak desks with
        dark green and burgundy leather armchairs are arranged in neat
        rows behind the counter that runs the width of the room;
        and dozens of tellers dressed in dark pinstripe vests and
        bow ties stand behind the counter, each at a window with
        a stack of papers and a green banker's light, waiting on
        a customer.
        \n\tThe exit is to the south."
    enterRoom(actor) =
    {
        inherited.enterRoom(actor);

        "\bOne of the tellers waves you over to his window.
        \"Can I help you?\" he asks.";
        notify(teller, &actorDaemon, 0);
    }
    south =
    {
        local i, tot, lst;

        // no more need for the teller daemon
        unnotify(teller, &actorDaemon);

        // give back any documents handed over
        lst := teller.contents;
        tot := length(lst);
        if (tot)
        {
            "As you leave, the teller hands you back ";
            listcont(teller); ".\b";
        }
        for (i := 1 ; i <= tot ; ++i) lst[i].moveInto(Me);

        // now leave
        return(downtown2);
    }
    out = (self.south)
;

workerFollower: follower
    sdesc = "maintenance man"
    noun = 'man' 'worker' 'repairman'
    adjective = 'maintenance'
    myactor = worker
;

worker: Actor
    isHim = true
    myfollower = workerFollower
    sdesc = "maintenance man"
    noun = 'man' 'worker' 'repairman'
    adjective = 'maintenance'
    location = infernolab
    actorDesc = nil
    ldesc = "His clothes are on fire, and he's flailing his
        arms wildly and running around in little circles, screaming
        in pain."
    track = [ downtown2 downtown suburbWest minimall suburbWest
              downtown towerbase downtown ]
    leaveDir = [ 'west' 'west' 'north' 'south' 'east' 'north' 'south' 'east' ]
    actorState = 1
    timeHere = 0
    actorDaemon =
    {
        if (Me.location = self.location)
            "\bA man whose clothes are on fire is running around
            in circles, flailing his arms and screaming.";
        ++timeHere;
        if (timeHere > 2)
        {
            if (Me.location = self.location)
                " He runs off to the << leaveDir[actorState] >>.";

            if (++actorState > length(track)) actorState := 1;
            self.moveInto(track[actorState]);
            timeHere := 0;

            if (Me.location = location)
                "\bA man whose clothes are on fire comes running
                into the area.  He starts running around in
                circles, flailing his arms and screaming.";
        }
    }
    verDoAskAbout(actor, iobj) = {}
    doAskAbout(actor, iobj) = { "He seems preoccupied."; }
    doSynonym('AskAbout') = 'TellAbout'
    actorAction(v, d, p, i) =
    {
        "He seems preoccupied.";
        exit;
    }
    verDoDouseWith(actor, iobj) = {}
    doDouseWith(actor, iobj) = { self.ioPourOn(actor, iobj); }
    ioSynonym('PourOn') = 'ThrowAt' 'ThrowOn' 'PutOn'
    verDoCoverWith(actor, iobj) = {}
    doCoverWith(actor, iobj) = { self.ioPutOn(actor, iobj); }
    verIoPourOn(actor) = {}
    ioPourOn(actor, dobj) =
    {
        if (dobj = bucketWater)
        {
            "You pour the water onto the burning man, and the flames
            are immediately extinguished. He looks dazed for a moment,
            then sees that you're the kind person that did the good
            deed. \"Hey!\" he shouts at you. \"What did you do that
            for? Now I've got to go back to work!\"
            \n\tHe fumbles through his pockets. As he does, you
            notice a small metal object drop to the ground.  He
            eventually finds a matchbook in his pocket, and strikes
            a match; he tries to get his clothes burning again, but
            they're too wet. \"Oh, well, it's no use,\" he says,
            and stomps away.";

            dobj.moveInto(nil);
            toolboxKey.moveInto(self.location);
            self.moveInto(nil);
            self.myfollower.moveInto(nil);
            unnotify(self, &actorDaemon);

            awardPoints(13, self);
        }
        else if (dobj = bedspread)
        {
            "You throw << dobj.thedesc >> onto the man, hoping it
            will suffocate the fire, but it does just the opposite --
            it provides ample new fuel.  The fire rages even faster
            for a few moments as << dobj.thedesc >> is consumed
            in the flames.";
            dobj.moveInto(nil);
        }
        else
            "That doesn't seem to help the situation.";
    }
;

infernolab: room
    sdesc = "Lobby"
    ldesc =
    {
        "You're in a lobby, decorated with a very high-tech
        look:  the walls are brushed stainless steel; the illumination
        is provided by black track lighting suspended from an intricate
        network of black metal railing; the furniture is black and
        angular.  Along the far wall, spelled out in four-foot-high Helvetica
        Medium Extended letters carved from granite, is the word:
        \b\t\t\tI N F E R N O L A B
        \b\tIn the center of the lobby is a huge black leather couch,
        and a low black marble coffee table.  A hallway leads east, and
        an exit leads north, back out to the street.";

        if (not self.isseen)
        {
            "\n\tA pair of maintenance workers in white overalls
            walks in from the east.  One is carrying a toolbox,
            and the other is carrying a light bulb and a sheet of
            paper.
            \n\t\"Let's see,\" says the one carrying the sheet of paper,
            carefully reading it. \"The trouble ticket says that bulb
            number 47 has blown again.\" He looks up at the track
            lighting. \"Damn!  We forgot the ladder!\"
            \n\t\"No need,\" says the other.  He sets his toolbox
            on the coffee table, then climbs up onto the table.
            \"I can reach number 47 from here,\" he says. He reaches
            up and unscrews one of the bulbs, then lays it on top of
            the railing. \"Hand me that new bulb,\" he says.  The
            other worker hands him the bulb, and he screws it into
            the socket.  As he's screwing it in, a huge flash of
            light suddenly erupts from the socket, followed by a shower
            of glass.  The flash of light is quickly replaced by a
            cloud of smoke, and flames engulf the worker.  He
            jumps off of the table, his clothes in flames, screaming
            and flailing his arms, and runs out into the street.
            The other worker shrugs and disappears down the hall.";

            worker.moveInto(downtown2);
            notify(worker, &actorDaemon, 0);
            toolbox.moveInto(infernoTable);
            deadbulb.moveInto(infernoRails);
        }
    }
    enterRoom(actor) =
    {
        local i, lst, tot;

        // move everything from rail room into rail item in this room
        for (lst := infernoRailRoom.contents, tot := length(lst), i := 1 ;
             i <= tot ; ++i)
        {
            if (not lst[i].noRailMove)
                lst[i].moveInto(infernoRails);
        }
        pass enterRoom;
    }
    north = downtown2
    out = (self.north)
    east = infernoHall
;

toolboxKey: keyItem
    sdesc = "small metal key"
    noun = 'key'
    adjective = 'small' 'metal'
    ldesc = "It's small -- too small for an ordinary door lock.
        It's probably for a desk or some other small lock."
;

toolbox: keyedLockable
    sdesc = "toolbox"
    noun = 'toolbox' 'box'
    adjective = 'metal' 'tool' 'gray'
    mykey = toolboxKey
    isopen = nil
    islocked = true
    ldesc =
    {
        "It's a gray metal toolbox. ";
        pass ldesc;
    }
    verDoPick(actor) = {}
    doPick(actor) =
    {
        "Unfortunately, being an accomplished thief is not what
        landed you in Hell.  You don't know how to pick the lock.";
    }
;

toolboxNote: readable
    sdesc = "yellow note"
    noun = 'note' 'paper' 'piece'
    adjective = 'yellow'
    location = toolbox
    ldesc =
    {
        if (not self.isseen)
        {
            // choose combination the first time we look at this
            infernoDial.settingCorrect := [(rand(29)+1) rand(30) rand(30)];
            isseen := true;
        }
        "It's a small piece of yellow paper, with nothing
        written on it except a series of numbers: <<
        infernoDial.settingCorrect[1] >>-<<
        infernoDial.settingCorrect[2] >>-<<
        infernoDial.settingCorrect[3] >>.";
    }
;

deadbulb: item
    sdesc = "dead light bulb"
    noun = 'bulb' 'lightbulb'
    adjective = 'dead' 'burned-out' 'burned' 'out' 'light'
    ldesc = "It's a dead light bulb. It seems slightly
        charred inside."
;

infernoLights: fixeditem
    sdesc = "track lights"
    adesc = "a track light"
    location = infernolab
    noun = 'light' 'lights' 'lighting'
    adjective = 'track'
    ldesc = "The track lighting is suspended several feet below
        the ceiling by an intricate network of black
        metal railing."
;

infernoRails: fixeditem, surface
    sdesc = "black metal railing"
    adesc = "a rail"
    location = infernolab
    noun = 'rail' 'rails' 'railing'
    adjective = 'black' 'metal'
    verGrab(obj) =
    {
        if (Me.location <> infernoTable)
            "You can't reach it from here; it's up in the railing.";
    }
    verIoPutOn(actor) =
    {
        if (actor.location <> infernoTable)
            "You can't reach the railing from here.";
    }
    ldesc =
    {
        "It's a very intricate network of black metal
        rails, hanging about four feet below the ceiling.";
        if (Me.location = infernoTable)
            " From up here on the table, you can easily
            reach the rails.  Up on the ceiling above the railing,
            you notice an access panel.";
    }
    verDoClimb(actor) =
    {
        if (actor.location <> infernoTable)
            "You can't reach the rails from here.";
    }
    doClimb(actor) =
    {
        actor.sitloc := nil;
        "With a little effort, you manage to climb up into the rails.\b";
        self.climbed := true;       // this flag allows going 'up' from table
        actor.travelTo(infernoRailRoom);
        awardPoints(13, self);
    }
    doSynonym('Climb') = 'Grab' 'Board'
;

infernoCouch: chairitem
    sdesc = "couch"
    noun = 'couch'
    adjective = 'huge' 'black' 'leather' 'large'
    location = infernolab
    ldesc =
    {
        "The couch is very large.  It's upholstered in black leather,
        and has a shiny chrome frame. ";
        pass ldesc;
    }
    verDoStandon(actor) = { "Sitting on it would be more dignified."; }
;

infernoTable: fixeditem, surface, nestedroom
    statusPrep = "on"
    outOfPrep = "off of"
    reachable =
    {
        return(infernolab.contents + infernoRails.contents);
    }
    sdesc = "marble coffee table"
    noun = 'table'
    adjective = 'black' 'marble' 'coffee'
    location = infernolab
    ldesc =
    {
        "Like everything in the lobby, the coffee table has a
        sterile, high-tech look, which is understated yet harsh.
        It's a simple, large, low slab of black marble. ";
        pass ldesc;
    }
    verDoStandon(actor) = {}
    doStandon(actor) =
    {
        "You climb up onto the coffee table.  It makes a pretty
        good platform -- you can reach the railing from here.";
        actor.moveInto(self);
    }
    doSynonym('Standon') = 'Board'
    up =
    {
        if (not infernoRails.climbed)
        {
            "I'm not sure how to do that from here.";
            return(nil);
        }

        Me.sitloc := nil;
        "From here, you can easily reach the rails. With a little
        effort, you manage to lift yourself up into the rails.\b";
        return(infernoRailRoom);
    }
    verDoUnboard(actor) =
    {
        if (actor.location <> self) "You're not on << self.thedesc >>!";
    }
    doUnboard(actor) =
    {
        "You climb off the table.\b";
        actor.travelTo(infernolab);
    }
    down =
    {
        "You climb off the table.\b";
        return(infernolab);
    }
    doSynonym('Unboard') = 'Getdown'
;

infernoSign: fixeditem
    sdesc = "INFERNOLAB sign"
    adesc = "an INFERNOLAB sign"
    noun = 'sign' 'letter' 'letters'
    adjective = 'infernolab' 'granite'
    ldesc = "The sign is quite imposing.  It's made of four-foot-high
        letters in a font that you take as Helvetica Medium Extended
        (a very high-tech-looking font); the letters appear to be
        carved from granite."
    location = infernolab
;

infernoRailRails: fixeditem
    sdesc = "railing"
    noun = 'rail' 'rails' 'railing'
    adjective = 'black' 'metal'
    location = infernoRailRoom
    ldesc = "They seem sturdy enough."
    noRailMove = true       // don't move in and out of railing
;

infernoPanel: doorway
    sdesc = "access panel"
    adesc = "an access panel"
    location = infernoRailRoom
    noun = 'panel' 'hatch' 'cover'
    adjective = 'access'
    doordest = crawlway1
    verDoOpen(actor) =
    {
        if (actor.location <> infernoRailRoom)
            "You can't reach it from here.";
        else
            pass verDoOpen;
    }
;

infernoRailRoom: room
    sdesc = "Up a Rail"
    ldesc = "You're crouching in the intricate network of
        rails above the lobby floor.  You can't stand up,
        because the ceiling is only a few feet above the
        top of the rails, but there's plenty of room to move
        around. You can go down, back to the lobby floor.
        \n\tIn the ceiling, you notice an access panel.
        The panel is currently
        << infernoPanel.isopen ? "open" : "closed">>."
    up = infernoPanel
    down = infernolab
    enterRoom(actor) =
    {
        local i, lst, tot;

        // move everything from rail item near table to rail room
        for (lst := infernoRails.contents, tot := length(lst), i := 1 ;
             i <= tot ; ++i)
        {
            if (not lst[i].noRailMove)
                lst[i].moveInto(self);
        }
        pass enterRoom;
    }
;

crawlway1: room
    sdesc = "Crawlway"
    ldesc = "You're in a maintenance crawlway.  It's cramped, but
        you can easily move around on your hands and knees.  The crawlway
        continues to the north and south; you can also climb down
        through a hole in the floor."
    down = infernoRailRoom
    south = crawlway2
    north = crawlway5
;

crawlway5: room
    sdesc = "Crawlway"
    ldesc = "You're at the north end of a crawlway.  The only
        way to crawl out is to the south."
    south = crawlway1
;

crawlway2: room
    sdesc = "Crawlway, at T"
    ldesc = "You're at a \"T\" intersection between a crawlway
        that continues off to the north, and an east-west crawlway."
    north = crawlway1
    east = crawlway3
    west = crawlway4
;

smallPanel: fixeditem
    isqcontainer = true
    location = crawlway3
    noun = 'panel' 'hole' 'opening'
    adjective = 'access' 'small'
    sdesc = "small access panel"
    ldesc = 
    {
        "It's only about one foot by one foot square.
        It's currently << isopen ? "open" : "closed" >>. ";

        if (mirror.location = self)
            "A mirror is covering the hole.";
        else if (isopen)
            self.thrudesc;
    }
    thrudesc =
    {
        if (mirror.location = self)
            "A mirror is covering the hole.";
        else
            "Through the hole, you can see a room below. The
            room seems to consist of a series of small cubicles,
            each separated by a six-foot-high partition.  Each
            cubicle contains a chair and a desk.  In most of the
            cubicles, a person is occupying the chair.
            \n\tSouth of the cubicles is a large, white room, in which
            a number of people in white labcoats are moving     about,
            consulting with one another and writing notes on the
            clipboards they're carrying.";
    }
    verDoLookthru(actor) =
    {
        if (not isopen)
            "It's closed, which prevents you from seeing
            anything through it.";
    }
    doLookthru(actor) = { self.thrudesc; }
    verDoOpen(actor) = { if (isopen) "It's already open!"; }
    doOpen(actor) =
    {
        "Opened.";
        isopen := true;
        cubicleOpening.moveInto(infernoCube);
    }
    verDoClose(actor) =
    {
        if (not isopen) "It's already closed!";
        else if (mirror.location = self) "There's a mirror in the way.";
    }
    doClose(actor) =
    {
        "Closed.";      
        isopen := nil;
        cubicleOpening.moveInto(nil);
    }
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) =
    {   
        if (dobj = mirror)
            self.ioPutOver(actor, dobj);
        else
            "Better not; it would just drop through to the room below.";
    }
    verIoPutOver(actor) = {}
    ioPutOver(actor, dobj) =
    {
        /* be courteous - open the panel if it's not already open */
        if (not self.isopen)
        {
            "(Opening the panel first.)\n";
            isopen := true;
        }

        if (dobj <> mirror)
            "That doesn't fit over the opening.";
        else if (mirror.location = self)
            "It's already over the opening!";
        else
        {
            "The mirror fits well over the opening, covering
            the hole entirely.";
            dobj.moveInto(self);
            mirror2.moveInto(infernoCube);
        }
    }
    Grab(obj) =
    {
        if (obj = mirror) mirror2.moveInto(nil);
    }
    ioSynonym('PutOver') = 'PutOn'
    verDoCoverWith(actor, iobj) = {}
    doCoverWith(actor, iobj) = { self.ioPutOver(actor, iobj); }
;

cubicleOpening: fixeditem
    noun = 'opening' 'panel' 'hole'
    adjective = 'small' 'ceiling'
    sdesc = "opening"
    ldesc =
    {
        "It's directly overhead (and far too high to reach). ";
        if (mirror2.location = self.location)
            "There's a mirror covering the opening, affording a good
            view of the cubes to your left and right.";
    }
    doSynonym('Inspect') = 'Lookin'
;

crawlway3: room
    sdesc = "Crawlway"
    ldesc =
    {
        "You're at the east end of a crawlway.  There's a
        small access panel in the floor (which is currently
        << smallPanel.isopen ? "open" : "closed" >>), although
        it's too small for you to go through.";
        
        if (mirror.location = smallPanel)
            "\n\tA mirror is sitting on the floor, covering the
            open access panel.";
    }
    down =
    {
        if (smallPanel.isopen)
            "The access hole too small.";
        else
            "The access panel is closed. Besides, it's too small.";
        return(nil);
    }
    west = crawlway2
;

class crawlPipes: fixeditem
    noun = 'pipe' 'pipes'
    adjective = 'large' 'metal'
    sdesc = "pipe"
    ldesc = "The pipes are about six inches in diameter, and made
        of a shiny silvery metal."
;

pipe1: crawlPipes
    location = crawlway1
;

pipe2: crawlPipes
    location = crawlway2
;

pipe3: crawlPipes
    location = crawlway3
;

pipe4: crawlPipes
    location = crawlway4
;

pipe5: crawlPipes
    location = crawlway5
;

pipevalve: fixeditem
    sdesc = "valve"
    noun = 'valve'
    location = crawlway4
    isopen = nil
    gasState = 0
    addgas =
    {
        if (Me.location = self.location)
            "\bYou hear gas continuing to pour out of the pipe.
            The odor of gas is growing stronger.";
        ++gasState;
    }
    ldesc = "The valve is currently << isopen ? "open" : "closed" >>."
    verDoOpen(actor) = { if (isopen) "It's already open!"; }
    doOpen(actor) =
    {
        "You turn the wheel, opening the valve.  As you do, the
        pipe starts hissing, and you smell natural gas pouring
        out of the pipe.";
        isopen := true;
        notify(self, &addgas, 0);
    }
    verDoClose(actor) = { if (not isopen) "It's already closed."; }
    doClose(actor) =
    {
        "You close the valve.  The gas slowly dissipates.";
        gasState := 0;
        isopen := nil;
        unnotify(self, &addgas);
    }
    verDoTurn(actor) = {}
    doTurn(actor) =
    {
        if (self.isopen)
        {
            "(closing the valve)\n";
            self.doClose(actor);
        }
        else
        {
            "(opening the valve)\n";
            self.doOpen(actor);
        }
    }
;

ripcord: fixeditem
    sdesc = "rip-cord"
    noun = 'rip-cord' 'cord' 'ripcord'
    adjective = 'rip' 'red' 'bright'
    location = parachute
    ldesc = "You pull it when you want to deploy the parachute."
    verDoPull(actor) = {}
    doPull(actor) =
    {
        if (actor.location <> thinAir)
            "This isn't a good time.";
        else if (not parachute.isworn)
            "Perhaps it would save the parachute, but it won't
            save you -- the parachute can't do much good unless
            you're wearing it!";
        else if (parachute.deployed)
            "The parachute is already deployed.  Pulling the rip-cord
            again won't help.";
        else
        {
            "You pull the cord, and the parachute rapidly deploys.
            You're abruptly yanked skyward as the chute catches an
            updraft between the buildings.  You start to float
            gently over the roof of the building to the west.";
            parachute.deployed := true;
        }
    }
;

parachute: clothingItem
    sdesc = "parachute"
    ldesc =
    {
        "It's a bulky bag with straps for attaching it
        to your torso.  It has a bright red rip-cord.";

        if (self.deployed)
            " The huge cloth parachute is currently
            deployed and fully inflated in the air above you.";
    }
    location = airplaneCompartment
    noun = 'parachute' 'chute'
    verDoUnwear(actor) =
    {
        if (self.deployed) "This really wouldn't be a good time.";
        else pass verDoUnwear;
    }
    verDoOpen(actor) = {}
    doOpen(actor) = { ripcord.doPull(actor); }
;

thinAir: room
    sdesc = "Flying through the air"
    ldesc = "You're flying through the air, sailing toward a
        short building to the west."
    roomDrop(obj) =
    {
        "You let go of << obj.thedesc >>, and it falls to the ground
        below.";
        obj.moveInto(parachute.deployed ? courtyard : alley);
    }
    noexit =
    {
        "You're too busy flying through the air.";
        return(nil);
    }
    landMe =
    {
        "\bYou gently land on the roof of the Celestial
        Security building.  The parachute flutters to
        the ground; you gather it up and pack it back into
        its bag.  (In Hell, you don't have to worry about lots
        of picky safety regulations governing who is allowed to
        pack parachutes.)\b";
        Me.travelTo(csRoof);
        parachute.deployed := nil;
        awardPoints(25, self);
    }
    dropMe =
    {
        "\b";
        if (parachute.deployed)
        {
            "You float over the first building, and find yourself
            over a large open area which you recognize as the
            civic center courtyard.  As you continue your descent,
            you seem to be heading toward the roof of the Celestial
            Security building.";
            notify(self, &landMe, 1);
        }
        else
        {
            "You just barely clear the roof of the building,
            and find yourself falling toward the ground.  Within
            moments, you hit the ground with a painful thud.
            You're dazed for a few seconds, but you manage to
            get up and brush yourself off.  You find yourself
            in...\b";
            Me.travelTo(courtyard);
        }
    }
;

lighter: item
    sdesc = "pocket lighter"
    noun = 'lighter'
    adjective = 'pocket' 'plastic' 
    ldesc = "It's a small plastic pocket lighter."
    doTake(actor) =
    {
        inherited.doTake(actor);
        awardPoints(13, self);
    }
    verIoLightWith(actor) = {}
    ioLightWith(actor, dobj) = { dobj.doLightWith(actor, self); }
    ioSynonym('LightWith') = 'BurnWith'
    verDoLight(actor) = {}
    doLight(actor) =
    {
        if (actor.location <> crawlway4 or pipevalve.gasState = 0)
            "You flick the lighter, and it emits a small
            flame.  After a few moments, you take your thumb
            off the lever, and the flame goes out.";
        else
        {
            "Just as you flick the lighter, your realize that
            there's natural gas in the room. ";
            switch(pipevalve.gasState)
            {
            case 1:
                "Fortunately, there's very little gas, so the
                only result is a small burst of flame.";
                break;

            case 2:
                "The gas bursts into a large cloud of fire.
                You jump back and shield your eyes. In a few
                moments, the flames die down.";
                break;

            case 3:
                "The gas ignites in a loud explosion and
                ball of fire. You jump back and shield your eyes.
                After several seconds, the flames subside, and
                you cautiously uncover your eyes.";
                break;

            default:
                "The gas explodes in a huge
                ball of fire.  You suddenly feel as though
                someone hit you with dozens of sledgehammers all at
                once.  Time seems to slow down as the force of the
                explosion lifts you off the floor of the crawlway
                and hurls you towards the west wall. ";
                if (crawlHole.location <> nil)
                    "You go sailing through the hole. ";
                else
                {
                    "You crash into the wall, and the metal rips
                    open. ";
                    crawlHole.moveInto(crawlway4);
                    alleyHole.moveInto(alley);
                }

                "You suddenly find yourself flying through the
                air over the alley, sailing over a shorter building
                to the west...\b";
                actor.travelTo(thinAir);
                notify(thinAir, &dropMe, 2);
            }
            pipevalve.gasState := 0;
        }
    }
    doSynonym('Light') = 'Flick'
;

crawlHole: fixeditem
    noun = 'hole'
    adjective = 'huge'
    sdesc = "huge hole"
    ldesc = "It's a large hole in the wall. Looking out the hole,
        you notice that it's up on the side of the building, about
        twenty feet off the ground; there's a dumpster on the ground
        directly below."
;

crawlway4: room
    sdesc = "Crawlway"
    ldesc =
    {
        "You're at the west end of a crawlway.  Large metal
        pipes run along the walls.  The crawlway continues to
        the east.
        \n\tOne of the pipes ends here.  The end of the pipe is
        not connected to anything at all; you assume it's
        being left for future expansion.  Just before the end
        of the pipe is a valve, evidently to cut off the flow of
        whatever the pipe carries until something is attached here.
        The valve is currently << pipevalve.isopen ? "open" : "closed" >>.";

        if (pipevalve.isopen)
        {
            "\n\tThe end of the pipe is making a loud hissing sound,
            and there is ";
            switch(pipevalve.gasState)
            {
            case 1: "a slight"; break;
            case 2: "a strong"; break;
            case 3: "an intense"; break;
            default: "an overpowering"; break;
            }
            " odor of natural gas filling the crawlway.";
        }

        if (crawlHole.location = self)
            "\n\tThe west wall of the crawlway has been ripped open
            (you think you may recall what caused the hole).  The
            hole seems to lead outside, and is easily large
            enough for you to go through.";
    }
    east = crawlway2
    west =
    {
        if (crawlHole.location = self)
        {
            "You step through the hole, and discover that you're about
            twenty feet up in the air alongside the building.  As you
            fall, you notice there's a dumpster below you.  You close
            your eyes, and land with a thud in the dumpster.\b";
            return(dumpsterRoom);
        }
        else
        {
            "You can't go that way.";
            return(nil);
        }
    }
;

dumpster2: fixeditem
    location = alley
    noun = 'dumpster'
    adjective = 'large' 'smelly'
    sdesc = "dumpster"
    ldesc =
    {
        "It's a really large, very smelly dumpster.";
        if (flippers.location = dumpsterRoom)
            " Over the edge of the dumpster, you can see a
            pair of flippers sticking up. Unfortunately, you
            can't quite reach them from here.";
    }
    verDoBoard(actor) = { "It's too high to climb into."; }
    doSynonym('Board') = 'Enter' 'Climb'
    verDoLookin(actor) = {}
    doLookin(actor) =
    {
        if (flippers.location = dumpsterRoom)
            "All you can see is the flippers sticking up over
            the edge.";
        else
            "You can't anything see over the edge.";
    }
    doSynonym('Lookin') = 'Search'
;

dummyFlippers: fixeditem
    location = alley
    noun = 'flipper' 'flippers' 'pair'
    sdesc = "pair of flippers"
    ldesc = "They're sticking up out of the trash in the dumpster.
        You can't quite reach them from here."
    verDoTake(actor) = { "You can't quite reach them from here."; }
    ioThrowAt(actor, dobj) =
    {
        if (dobj = rope)
            "You can't manage to get at them from this angle.";
        else
            pass ioThrowAt;
    }
    verDoTakeWith(actor, iobj) = {}
    doTakeWith(actor, iobj) =
    {
        "All you can manage to do is push them away from you.
        You'll have to get into the dumpster somehow.";
    }
    doSynonym('TakeWith') = 'MoveWith' 'PullWith' 'PushWith'
;

fakeDumpster: closedRefItem
    noun = 'dumpster'
    location = dumpsterRoom
    doSynonym('Unboard') = 'Climbdown'
;

dumpsterRoom: closedNestedRoom
    adjective = 'large' 'smelly'
    out = alley
    down = alley
    myRefItem = fakeDumpster
    sdesc = "dumpster"
    ldesc = "You're in a large, smelly dumpster, which is
        at the south end of a short alley. The dumpster is
        filled with disgusting, slimy trash.  You can
        climb out into the alley."
    doSynonym('Unboard') = 'Climbdown'
;

braceletAmulet: amuletItem
    sdesc = "genuine gold bracelet"
    noun = 'bracelet' 'object' 'thing' 'amulet'
    adjective = 'gold' 'shiny' 'glimmering' 'genuine'
    ldesc = "It's a gold bracelet, made up of little loops of gold
        wire all linked together."
;

glimmeringObj: fixeditem
    noun = 'object' 'thing'
    adjective = 'shiny' 'shining' 'glimmering'
    sdesc = "shiny object"
    location = dumpsterRoom
    ldesc = "You can just barely see something shiny under the trash."
    dobjGen(a, v, i, p) =
    {
        if (v <> inspectVerb)
        {
            "You can't reach it; it's under a lot of trash.";
            exit;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

dumpstertrash: fixeditem
    sdesc = "trash"
    noun = 'trash' 'garbage' 'rubbish'
    adjective = 'disgusting' 'slimy'
    location = dumpsterRoom
    ldesc =
    {
        "There's quite a lot of it.";
        if (not self.isSearched)
            " You see a shiny object glimmering under the trash.";
    }
    verDoSearch(actor) = {}
    doSearch(actor) =
    {
        if (not self.isSearched)
        {
            "You pull back some of the trash to locate the glimmering
            object.  The trash is ripe and disgusting, but you manage
            to look through it long enough to find a very nice bracelet!";
            braceletAmulet.moveInto(dumpsterRoom);
            isSearched := true;
            glimmeringObj.moveInto(nil);
        }
        else
            "You carefully search the disgusting refuse, and
            discover -- more trash!";
    }
    doSynonym('Search') = 'Lookin' 'Lookthru' 'Move'
;

alleyHole: fixeditem
    sdesc = "huge hole"
    noun = 'hole'
    adjective = 'huge'
    ldesc = "It looks like it was punched in the wall from the
        inside, as though by a massive explosion."
    verDoEnter(actor) = { "It's twenty feet up the wall!"; }
;

alleyBuilding: fixeditem
    sdesc = "building"
    noun = 'building' 'wall'
    adjective = 'east' 'eastern' 'west' 'western'
    location = alley
    ldesc = "It's just a building."
    verDoEnter(actor) = { "There's no entrance here."; }
;

alley: room
    north = downtown2
    ne = downtown2
    sdesc = "Alley"
    ldesc =
    {
        "You're in an alley between two large low-rise buildings,
        one to the east and one to the west.
        The alley dead-ends to the south; you can go out to the north.";
        if (alleyHole.location <> nil)
            " There's a huge hole in the wall of the east building,
            about twenty feet up.";
        "\n\tAt the south end of the alley is a large dumpster.";
    }
;

class infernoSlot: fixeditem
    sdesc = "slot"
    noun = 'slot' 'reader'
    adjective = 'card' 'reader'
    ldesc = "It's a little slot, about big enough for a credit card.
        There's a little red light above it."
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) =
    {
        if (dobj = infernoBadge and not infernoHallDoor.isopen)
        {
            "You insert the card into the slot, and the little red
            light changes into a little green light.  The door slides
            open. You remove the card and the light turns red again.";
            infernoHallDoor.openup;
        }
        else if (dobj.iscard)
            "You slide it into the slot, and nothing happens. You
            withdraw it.";
        else
            "It doesn't fit in the slot.";
    }
;

infernoSlot1: infernoSlot
    location = infernoHall2
;

class infernoLight: fixeditem
    sdesc = "red light"
    noun = 'light'
    adjective = 'red' 'little' 'small' 'card' 'reader'
    ldesc = "It's glowing red."
;

infernoLight1: infernoLight
    location = infernoHall2
;

infernoHallDoor: infernoHallDoorway
    location = infernoHall2
    doordest = infernoHall3
    otherside = infernoHall3Door
;

class infernoHallDoorway: doorway
    isopen = nil
    noAutoOpen = true
    noun = 'door'
    sdesc = "door"
    ldesc = "It's a sliding metal door. It's currently
        << isopen ? "open" : "closed" >>."
    closeup =
    {
        if (Me.location = infernoHall2 or Me.location = infernoHall3)
            "\bThe door slides shut.";
        isopen := nil;
        infernoHall3Door.isopen := nil;
    }
    openup =
    {
        isopen := true;
        infernoHall3Door.isopen := true;
        notify(self, &closeup, 2);
    }
    verDoOpen(actor) =
    {
        if (isopen) "It's already open!";
        else "You don't see how to do that.";
    }
    verDoClose(actor) =
    {
        if (not isopen) "It's already closed!";
        else "You don't see how to do that.";
    }
;

infernoHall: room
    sdesc = "Hallway"
    ldesc = "You're in a hallway that leads east and west.  All along the
        south wall are closely-spaced doors; all of the doors
        are closed, except for one.  The hall continues to the east."
    south = infernoCube
    west = infernolab
    east = infernoHall2
;

infernoHall2: room
    sdesc = "East end of hall"
    ldesc = "You're at the east end of a long hallway.  To the
        east is a<< infernoHallDoor.isopen ? "n open" : " closed">> door.
        Next to the door is a slot; a small red light is above the slot.
        The hall continues back to the west."
    east = infernoHallDoor
    west = infernoHall
;

infernoHallDoors: fixeditem
    sdesc = "doors"
    adesc = "a door"
    ldesc = "All of the doors are closed, except for one.
        The doors are strange metal sliding doors; there's
        no obvious way to open or close them."
    location = infernoHall
    noun = 'door' 'doors'
    adjective = 'closed' 'open' 'opened' 'south' 'southern'
                'strange' 'metal' 'sliding'
    verDoOpen(actor) =
    {
        "These are strange, metal, sliding doors.  There's
        no obvious way to open or close them.";
    }
    verDoClose(actor) = { self.verDoOpen(actor); }
;

infernoCubeDoor: fixeditem
    sdesc = "door"
    ldesc = "It's a strange, metal, sliding door. It's currently
        << isopen ? "open" : "closed" >>, and there's no
        obvious way for you to change that."
    noun = 'door'
    adjective = 'strange' 'metal' 'sliding'
    location = infernoCube
    isopen = true
;

infernoCubeChair: chairitem
    location = infernoCube
    reachable = { return(self.contents + self.location.contents
                         + infernoConsole.contents); }
    noun = 'chair'
    adjective = 'black' 'leather'
    sdesc = "chair"
    ldesc = "It's a high-tech office chair, ergonomically designed
        with a low back, armrests, rollers, and a swivel base.  The
        chair is upholstered in black
        leather like all of the other furniture you've seen here."
    verDoStandon(actor) = {}
    doStandon(actor) =
    {
        "You carefully climb up onto the chair, which seems
        quite unstable thanks to the rolling wheels.  As soon as you
        manage to get your balance, one of the scientists runs over
        to you. \"Hey!  Get down from there!  No cheating allowed!\"
        You sheepishly get back down off the chair.";
    }
    doSiton(actor) =
    {
        inherited.doSiton(actor);

        if (infernoCube.state = 1)
        {
            infernoCubeDoor.isopen := nil;
            "\n\tAs you sit down, the door behind you slides closed.
            One of the scientists walks over to one of the others,
            and asks him, \"Are you ready to begin, Doctor
            Merkwurtigblatt?\"
            \n\tMerkwurtigblatt turns to face her.  \"A moment please!\"
            He stands facing away from the cubicles, and runs his
            hands through his hair, inhaling deeply.  He then
            abruptly turns on his heel to face the cubicles.  He has short,
            curly black hair, and is wearing very thick, dark glasses,
            a white lab coat, and black leather gloves.
            \n\t\"Thank you all for coming.  I'm Doctor Merkwurtigblatt,
            and I'll be your scientist today.  The experiment we're
            performing is in a field called Micro-Economics, which means
            that we're going to attempt to model a particular set of
            market forces under controlled conditions.  As a result, you
            may find the experiment to be quite abstract, but don't
            worry; we don't actually want you to understand the point
            of this experiment, for two reasons.  First, if you knew
            what we were attempting to prove, it would bias the results.
            And second, our theories might seem strange, or even
            laughable, to the layman, and you might be left with the
            impression that Economics is something less -- much less --
            than the precise and exacting science that we Economists
            know it to be.  But you will be able to rest assured in
            your confusion that the economic future of Hell is in
            capable hands.  You can tell by our white labcoats,
            clipboards, and seemingly effortless use of large words
            that we are authority figures to be respected -- yes --
            and feared!
            \n\t\"Now, the rules of the experiment are quite simple.
            Each of you is a trader in goods we will call 'widgets.'
            The experiment will consist of a series of trading rounds.
            In each trading round, you will conduct a transaction
            with the subject to your left and the one to your right.
            \n\t\"We will be using what we Economists refer
            to as the Extended RSP Trading Model, which stands
            for Rock, Scissors, Paper.  We call it 'extended'
            because we have added a new element that radically
            changes the equation:  dynamite.  In this model,
            dynamite pulverizes rock, rock crushes scissors, scissors
            cut paper -- yes, to shreds! -- but paper covers dynamite.
            \n\t\"You start with 5 widgets.  In each trading round,
            you will choose
            dynamite, rock, scissors, or paper, and your trading
            choice will be compared with the choices of those to
            your left and right.  The subject who prevails out of
            each group of three will acquire one widget each from
            the subjects on the left and right.  The experiment
            will proceed for five trading rounds.
            \n\t\"As an incentive to do your best, if you manage to
            win every round, you will be awarded Twenty Hellmids
            at the end of the experiment.  Choose carefully.\"";

            infernoCube.round := 1;
            infernoCube.state := 4;
            infernoConsole.display := 5;
            notify(infernoCube, &experiment, 0);

            if (infernoConsole.location = nil)
            {
                "\n\tYou notice a control panel on the desk that
                you hadn't seen before.  The control panel has a numeric
                display, which is currently displaying
                \"<< infernoConsole.display >>\", and
                four buttons, labeled Dynamite, Rock, Scissors, and Paper.";
                infernoConsole.moveInto(infernoCube);
            }
        }
    }
;

infernoCubeChairDetails: decoration
    sdesc = "chair part"
    location = infernoCube
    noun = 'armrest' 'armrests' 'back' 'roller' 'rollers' 'base'
    adjective = 'low' 'swivel'
    ldesc = "It's just part of the chair -- it's not important."
;

infernoCubeDesk: fixeditem
    sdesc = "desk"
    noun = 'desk'
    location = infernoCube
    ldesc =
    {
        "It's a large desk that fills the entire south half of
        the cubicle. ";
        if (infernoConsole.location)
            "Embedded in the surface of the desk is a small
            control panel.";
    }
    verDoStandon(actor) =
    {
        "You climb up onto the desk.  As soon as you do, though,
        one of the scientists runs over
        to you. \"Hey!  Get down from there!  No cheating allowed!\"
        You sheepishly get off the desk.";
    }
;

infernoPartitions: fixeditem
    sdesc = "partition"
    noun = 'partition' 'partitions' 'wall' 'walls'
    adjective = 'six' 'foot' 'six-foot' 'high' 'six-foot-high' 'left' 'right'
    ldesc = "They're just tall enough that you can't see over them."
    location = infernoCube
    doLookOver(actor) =
    {
        "They're just a litle too tall to see over. Perhaps if
        you were try standing on something, you could see more.";
    }
;

infernoCubeSciDetails: fixeditem
    location = infernoCube
    sdesc = "scientist's possession"
    ldesc = "It's just something the scientist is carrying.
        It's not important."
    noun = 'clipboard' 'coat' 'paper' 'papers' 'clipboards' 'coats'
    adjective = 'white' 'lab' 'long' 'black' 'metal'
;

infernoCubeScientists: fixeditem
    location = infernoCube
    noun = 'scientists' 'men' 'women' 'man' 'woman' 'scientist'
    sdesc = "scientist"
    ldesc = "Several scientists are walking around the room.
        Each is wearing a long white lab coat. They're all carrying
        black metal clipboards. Some are consulting with each other,
        while others are looking through their notes and writing notes
        on the papers on their clipboards."
    verDoAskAbout(actor, iobj) = {}
    doAskAbout(actor, iobj) = { "You can't seem to get their attention."; }
    verIoShowTo(actor) = {}
    ioShowTo(actor, dobj) = { self.doAskAbout(actor, dobj); }
    verIoGiveTo(actor) = {}
    ioGiveTo(actor, dobj) = { self.doAskAbout(actor, dobj); }
;

infernoConsole: fixeditem
    isqcontainer = true
    sdesc = "console"
    noun = 'console' 'panel' 'display'
    adjective = 'control' 'numeric'
    display = 5
    ldesc = "The control panel consists of a display, which is currently
        showing \"<< display >>\", and four buttons, labeled
        Dynamite, Rock, Scissors, and Paper."
;

class consoleButton: buttonitem
    location = infernoConsole
    sdesc = "<< self.buttonName >> button"
    ldesc = "It's a small pushbutton labeled \"<< self.buttonName >>.\""
    buttonVal = 0
    leftVal = 0
    rightVal = 0
    doPush(actor) = 
    {
        local names := ['dynamite' 'rock' 'scissors' 'paper'];
        local whatItDoes  := ['blows up' 'crushes' 'cuts' 'wraps'];
        local winVal;

        if (infernoCube.state = 4)
        {
            if (mirror.location <> smallPanel)
            {
                local v1, v2;

                // choose a winning number
                v1 := buttonVal - 1;
                if (v1 < 1) v1 := 4;
                v2 := buttonVal + 1;
                if (v2 > 4) v2 := 1;

                // decide randomly who wins
                if (rand(100) < 50)
                {
                    infernoCube.leftVal := v1;
                    infernoCube.rightVal := v2;
                }
                else
                {
                    infernoCube.leftVal := v2;
                    infernoCube.rightVal := v1;
                }
            }

            "You push the button, making your choice. One of the
            scientists walks over and looks at your choice and
            the choices of the people on your left and right.
            \"Let's see, you chose << names[buttonVal] >>,\"
            she says, looking at your button. \"The subject on
            your left chose << names[infernoCube.leftVal] >>, and the subject
            on the right chose << names[infernoCube.rightVal] >>. ";

            // we won if no one chose the value just above us
            winVal := buttonVal - 1;
            if (winVal < 1) winVal := 4;
            if (infernoCube.leftVal = buttonVal or
                infernoCube.rightVal = buttonVal)
            {
                "This round tied, so we'll have to do it over.\"";
                infernoCube.round--;
                infernoCube.choiceRound := 0;
            }
            else if (infernoCube.leftVal = winVal or
                     infernoCube.rightVal = winVal)
            {
                "I'm afraid that << names[winVal] >> << whatItDoes[winVal]
                >> << names[buttonVal] >>, so you've lost this round.
                You lose one widget.\"";
                infernoConsole.display--;
            }
            else
            {
                "You've won this round! You gain two widgets.\"";
                infernoConsole.display += 2;
            }
            "\n\tYour display now reads \"<< infernoConsole.display >>\".";

            if (infernoCube.round++ = 5)
            {
                unnotify(infernoCube, &experiment);
                infernoCubeDoor.isopen := true;

                "\bDr.\ Merkwurtigblatt announces loudly, \"That
                concludes the experiment. Thank you all for participating.
                You've provided a great deal of valuable data that will
                significantly advance this important field of science.
                Those of you with with fifteen widgets will be given
                your checks now.\"
                \n\tThe cubicle's door slides open.
                \n\tOne of the men in labcoats walks up to your desk
                and looks at your console's display. ";

                if (infernoConsole.display = 0)
                {
                    if (not infernoConsole.ridiculed)
                    {
                        "He bursts into laughter. \"Zero! What a loser!
                        Don't you realize that you'd do a lot better than
                        this by PURE RANDOM CHANCE?\" He
                        calls to a couple of the other scientists.
                        \"Hey, have a look at this! He got zero! I've
                        never seen one of these before!\" Several scientists
                        come over and gawk at your display, and walk off
                        laughing.";
                        infernoConsole.ridiculed := true;
                    }
                    else
                        "\"Zero again,\" he says. \"I don't think you
                        understand the experiment very well.  Oh, well,
                        better luck next time.\"";
                    infernoCube.state := 2;   // come again!
                }
                else if (infernoConsole.display <> 15)
                {
                    "\"Not bad,\" he says, \"but the rule is that
                    you have to win all five rounds to be paid.
                    Oh, well, better luck next time.\" He walks away.";
                    infernoCube.state := 2;    // come again!
                }
                else
                {
                    "\"Congratulations!\" he says. He gets out a checkbook
                    and proceeds to make out a check for Twenty Hellmids.
                    \"Here you go,\" he says, handing you the check, and
                    walks away.";
                    infernoCheck.moveInto(Me);
                    infernoCube.state := 3;     // can't play again
                    awardPoints(25, infernoConsole);
                }
            }
        }
        else
            "Nothing happens.";
    }
;

infernoCheck: item
    noun = 'check'
    adjective = '20' 'twenty' 'hellmid'
    sdesc = "check"
    ldesc = "
        \bThe Bank of Hell / Main Branch / Downtown Hell\t\t\t#55093
        \bPAY\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ Twenty (20) Hellmids
        \nTo the order of\ \ \ BEARER.
        \bFrom the account of:
        \b\tI N F E R N O L A B
        \n\tEconomics Division
        \n\tAccount #0666-059982"
;

button1: consoleButton
    adjective = 'dynamite'
    buttonName = "dynamite"
    buttonVal = 1
;

button2: consoleButton
    adjective = 'rock'
    buttonName = "rock"
    buttonVal = 2
;

button3: consoleButton
    adjective = 'scissors'
    buttonName = "scissors"
    buttonVal = 3
;

button4: consoleButton
    adjective = 'paper'
    buttonName = "paper"
    buttonVal = 4
;
    

infernoCube: room
    choiceRound = 0
    experiment =
    {
        local names := ['dynamite' 'rock' 'scissors' 'paper'];

        "\bDr.\ Merkwurtigblatt writes some notes on his clipboard.
        \"Round << self.round >>,\" he announces. \"Please make your
        selections.\"";

        // choose left and right values if player can cheat
        if (mirror.location = smallPanel and choiceRound <> round)
        {
            choiceRound := round;        // don't choose again for this round
            infernoCube.leftVal := rand(4);
            infernoCube.rightVal := rand(4);
            if (infernoCube.rightVal = infernoCube.leftVal)
            {
                if (infernoCube.rightVal++ = 4)
                    infernoCube.rightVal := 1;
            }
            "\n\tIn the mirror above, you notice the subjects on your
            left and right making their selections. The person
            on the left chooses << names[infernoCube.leftVal] >>, and
            the person on the right chooses
            << names[infernoCube.rightVal] >>.";
        }
    }
    sdesc = "Cubicle"
    ldesc =
    {
        "You're in a small cubicle, bordered on the east and
        west by six-foot-high partitions, and on the south by a desk.
        There's a chair that occupies most of the rest of the
        space.  A door is to the north; the door is
        << infernoCubeDoor.isopen ? "open" : "closed" >>.
        \n\tOn the other side of the desk is a very large,
        bright white room.  Several men and women are walking
        about the room, consulting with each other; each is wearing
        a long white lab coat, and carrying a black metal clipboard
        stuffed with papers. ";

        if (smallPanel.isopen)
        {
            "Overhead, you notice a small opening in the ceiling. ";
            if (mirror.location = smallPanel)
                "Covering the opening is a mirror. In the mirror,
                you notice that you can easily see the people in the
                cubicles on either side of your cubicle.";
        }
    }
    state = 0
    enterRoom(actor) =
    {
        inherited.enterRoom(actor);
        "\n\t";
        switch(state)
        {
        case 0:
            "As you enter, one of the women in labcoats walks over
            to you. \"Ah, you must be subject 32,\" she says with a
            bit of impatience in her voice. \"Everyone else is ready
            to begin. Now, if you'd take your seat, we could proceed
            with the experiment.\" She walks back toward the center
            of the room and confers with another of the scientists.";
            state := 1;
            break;

        case 1:
            "One of the scientists notices you have come back
            into the cubicle, and walks over to you. \"Where did
            you go?\" she asks, obviously irritated. \"Well, now
            that you're back, will you PLEASE sit down so we can
            begin the experiment?\"  Before you can reply, she
            stomps off to another part of the room.";
            break;

        case 2:
            "One of the scientists recognizes you, and walks over.
            \"You're back for another try, are you?  Well, we normally
            don't like to use the same subjects multiple times, since
            it can throw off the results, but given your pathetic
            performance last time, I suppose that it can't do much
            harm.  It's not like you'll have any sort of advantage over
            the other subjects!\"  She lets out a little laugh -- actually,
            it's more like a snort -- then turns serious again.
            \"Anyway, we're about to begin another experiment, so
            if you'll have a seat, we will proceed.\" She walks
            away.";
            state := 1;
            break;

        case 3:
            "One of the scientists recognizes you, and walks over.
            \"I'm sorry, but we can't allow you to participate again,
            now that you know all about the experiment. It would throw
            off the results if you were to participate. If you're looking
            for more money, I've heard that Infernolab Missiles and Space
            is looking for subjects in the nosecone crash testing lab.\"
            She walks away.";
            break;
        }
    }
    north =
    {
        if (infernoCubeDoor.isopen)
            return(infernoHall);
        else
        {
            "The door is closed.";
            return(nil);
        }
    }
    out = (self.north)
;

infernoHall3Slot: infernoSlot
    location = infernoHall3
;

infernoHall3Light: infernoLight
    location = infernoHall3
;

infernoHall3Door: infernoHallDoorway
    location = infernoHall3
    doordest = infernoHall2
    otherside = infernoHallDoor
;

infernoHall3: room
    sdesc = "Hallway"
    ldesc = "You're in a hallway.  A doorway leads south, another
        leads north, and
        a door (which is << infernoHallDoor.isopen ? "open" : "closed"
        >>) is to the west.  Next to the door is a card reader slot,
        and above the slot is a small red light.   There's also a
        room to the east, labeled \"Maintenance\"."
    west = infernoHall3Door
    south = rocketLab
    north = dimnetLab
    east = infernoMaint
;

// a reference to infernolab, for asking questions about it
infernolabRef: fixeditem
    noun = 'infernolab'
    sdesc = "Infernolab"
    adesc = "Infernolab"
    thedesc = "Infernolab"
;

dimnetEquip: fixeditem
    sdesc = "equipment"
    adesc = "some equipment"
    noun = 'equipment' 'wire' 'wires' 'coil' 'coils' 'light' 'lights'
            'tube' 'tubes'
    adjective = 'plastic' 'glowing' 'translucent' 'huge' 'strange'
            'randomly' 'flashing'
    location = dimnetLab
    ldesc = "It's all incomprehensible to you. The only features that
        seem to merit further investigation are the glass booth at
        the center of all the equipment, and a control panel."
;

dimnetPanel: fixeditem
    sdesc = "control panel"
    noun = 'panel' 'console' 'dial' 'dials' 'lever' 'levers' 'buttons'
    adjective = 'control'
    location = dimnetLab
    ldesc = "It's labeled \"Infernolab Dimensional Networking
        Products Division Model DN-2.\" It has a large number of
        dials and buttons and levers, but you feel safest leaving
        them alone.  There is, however, one particularly large
        red button labeled \"Activate\"."
;

dimnetButton: buttonitem
    sdesc = "red button"
    adjective = 'activate' 'red'
    location = dimnetLab
    activate =
    {
        --self.timer;
        if (Me.location <> dimnetBooth and Me.location <> dimnetLab)
        {
            if (timer = 0)
            {
                self.isActive := nil;
                unnotify(self, &activate);
            }
            return;
        }

        switch(timer)
        {
        case 2:
            "\b\"Warning!  System activated.  Power sequence complete;
            power flux stabilized within nominal range. Initiating software
            configuration.  Failsafe activated; manual override
            disabled.  Stand by...\"";
            break;

        case 1:
            "\b\"FINAL WARNING!  Software configuration completed.
            Final power sequence calculations completed.  Power flux
            decoupled from main power feed.  Diagnostics completed;
            all systems within normal tolerances.  Stand by...\" ";
            break;

        case 0:
            "\b\"SYSTEM ACTIVATED.\" ";
            if (Me.location = dimnetBooth)
            {
                local lst, tot, i;

                // drop all posessions before travel
                for (lst := Me.contents, tot := length(lst), i := 1 ;
                     i <= tot ; ++i)
                    lst[i].moveInto(dimnetBooth);

                "The room begins to vibrate, and a loud rumbling sound
                echoes all around.  A glowing fog starts to surround you,
                and the vibration and rumbling are gradually muffled.
                Soon, you near nothing, and see only the strange glow.
                You feel yourself losing your balance; you squint your
                eyes trying to peer through the fog, and reach out for
                the edge of the booth, but you find nothing where the
                booth was.  You feel yourself falling forward, and you
                reach out to brace yourself, but you just keep falling.
                \n\tYou start to hear a distant rumbling sound. The
                noise grows steadily louder and closer, and you start
                to notice vague shapes out in the fog.  The shapes draw
                closer, and the rumbling grows louder.  Suddenly, the
                glow and the rumble are gone.\b";
                
                notify(hauntedPeople, &actorDaemon, 0);
                hauntedPeople.moveInto(basement);
                hauntedPeople.couldSee := nil;
                Me.travelTo(basement);
            }
            else
                "The whole room vibrates as though a jet engine were
                inches above the ceiling, and the wire coils pulsate
                with power.  The booth is enveloped in a strange glow,
                which is at once dim and painfully bright, as though
                it were emitting huge amounts of some strange radiation
                that was just beyond the limits of your eyes. The vibration
                and glow steadily increase in intensity, growing louder
                and more painful, until all at once everything abruptly
                stops, and the lab is once again quiet.";

            self.isActive := nil;
            unnotify(self, &activate);
            break;
        }
    }
    doPush(actor) =
    {
        if (dimnetEmployee.location = self.location)
            "The employee runs over to stop you before you can
            push the button. \"Hey! We're not ready for a test
            run!\" He returns to his chair.";
        else if (self.isActive)
            "Nothing happens.";
        else
        {
            "You hear a mechanical male voice through a hidden speaker:
            \"Warning! System activated. Commencing primary
            power sequence. Diagnostics initiated. All personnel
            report to assigned stations. Stand by...\"";
            notify(self, &activate, 0);
            isActive := true;
            timer := 4;
        }
    }
;

dimnetBooth: fixeditem, nestedroom
    reachable = ([] + self)
    sdesc = "booth"
    noun = 'booth'
    adjective = 'large' 'glass'
    statusPrep = "in"
    location = dimnetLab
    out = dimnetLab
    verDoBoard(actor) = {}
    doBoard(actor) =
    {
        if (dimnetEmployee.location = self.location)
            "The technician yells, \"Hey! We're not ready for a run!\"
            He runs over and prevents you from entering, then returns
            to his chair.";
        else
            actor.travelTo(self);
    }
    doSynonym('Board') = 'Enter'
    noexit =
    {
        "You'll have to get out of the booth first.";
        return(nil);
    }
;

dimnetLab: room
    sdesc = "Lab"
    ldesc = "You're in a large laboratory filled with strange equipment --
        huge coils of wire, glowing translucent plastic tubes, panels
        of randomly flashing lights, and in the center of it all is
        a large glass booth, big enough for a person to stand in.
        A door leads south."
    south = infernoHall3
    enterRoom(actor) =
    {
        if (dimnetEmployee.location = self)
            notify(dimnetEmployee, &actorDaemon, 0);
        pass enterRoom;
    }
    leaveRoom(actor) =
    {
        if (dimnetEmployee.location = self)
            unnotify(dimnetEmployee, &actorDaemon);
        pass leaveRoom;
    }
;

dimnetEmployee: Actor
    sdesc = "technician"
    isHim = true
    noun = 'technician' 'engineer' 'man' 'employee'
    location = dimnetLab
    ldesc = "He's a scrawny man in his mid twenties. He looks like
        he's been wearing a pocket protector since his early childhood."
    actorDesc =
    {
        if (self.location = dimnetLab)
            "There's a technician here, idly sitting reading a book.";
        else
            "There's a technician here, plowing through mugs of beer.";
    }
    messages =
    [
        'The technician starts telling you about a
        computer game. "Have you ever tried to pick up one of
        the cursed emeralds?" he asks. "It\'s pretty amazing how
        quickly your character gets killed when you do."'
        'The technician pages through his book.'
        'The technician looks up from his book. "Do you know if
        they\'re going to get another keg in here? We finished the
        last one days ago."'
        'The technician twirls around on his chair.'
    ]
    state = 0
    actorDaemon =
    {
        if (Me.location <> self.location) return;
        if (self.location = boatbar)
        {
            "\bThe technician plows through another mug of beer.";
            return;
        }

        ++state;
        if (state > length(messages)) state := 1;
        "\b"; say(messages[state]);
    }
    disavow = "\"Figure it out yourself!\""
    ioSynonym('GiveTo') = 'ShowTo'
    verIoGiveTo(actor) = {}
    ioGiveTo(actor, dobj) =
    {
        switch(dobj)
        {
        case liquorglass:
        case beermug:
            if (self.location = boatbar)
                "\"No thanks -- I've got all I need.\"";
            else
            {
                "The technician grabs it and immediately drinks the contents.
                \"Hey! The boat must be in! Why didn't you say so? Cover for
                me, will you? I'm going to run over and get some free drinks
                as long as it's here.\" He runs gleefully out of the room.";
                awardPoints(13, self);
                dobj.moveInto(nil);
                self.moveInto(boatbar);
            }
            break;

        default:
            "\"No, thanks.\"";
            break;
        }
    }
;

dimnetChair: chairitem
    sdesc = "chair"
    noun = 'chair'
    location = dimnetLab
    verDoSiton(actor) =
    {
        if (dimnetEmployee.location = self.location)
            "The technician is already sitting there.";
        else
            pass verDoSiton;
    }
;

dimnetBook: readable
    sdesc = "book"
    noun = 'book'
    location = dimnetEmployee
    ldesc = "It seems to be a book that describes a role-playing game
        of some kind."
;

infernoMaint: room
    sdesc = "Maintenance Room"
    ldesc = "You're in a small, closet-sized room.  The only notable
        feature is a locker, which is << infernoLocker.isopen ?
        "open" : "closed" >>. The exit is to the west."
    west = infernoHall3
;

infernoDial: fixeditem, dialItem
    sdesc = "combination lock dial"
    noun = 'dial' 'lock'
    adjective = 'combination' 'lock'
    location = infernoMaint
    maxsetting = 30
    setting = 1
    settingHistory = [0 0 0]
    settingCorrect = [99 99 99]
    settingPos = 1
    doTurnTo(actor, iobj) =
    {
        if (settingPos > 3)
        {
            settingPos := 1;
            "You spin the dial a couple times first to clear the previous
            combination. ";
        }
        inherited.doTurnTo(actor, iobj);
        settingHistory[settingPos++] := setting;

        if (not infernoLocker.isopen)
        {
            if (settingPos = 4 and settingHistory = settingCorrect)
            {
                " You hear a click within the lock mechanism.";
                infernoLocker.islocked := nil;
            }
            else
                infernoLocker.islocked := true;
        }
    }
;

infernoLocker: fixeditem, openable
    sdesc = "locker"
    noun = 'locker'
    location = infernoMaint
    isopen = nil
    islocked = true
    ldesc =
    {
        "The locker has a dial, which can be turned to positions from
        1 to 30. ";
        pass ldesc;
    }
    doOpen(actor) =
    {
        if (self.islocked) "It seems to be locked.";
        else pass doOpen;
    }
    doClose(actor) =
    {
        self.islocked := true;
        pass doClose;
    }
;

maintUniform: clothingItem
    sdesc = "maintenance uniform"
    noun = 'uniform'
    adjective = 'maintenance'
    location = infernoLocker
    ldesc = "It's a one-piece white jumpsuit.  It's a bit singed."
;

rocketEquip: fixeditem
    noun = 'equipment' 'oscilloscope' 'oscilloscopes' 'scope' 'scopes'
        'supply' 'supplies' 'meter' 'meters'
    adjective = 'lab' 'testing' 'measuring'
    location = rocketLab
    sdesc = "lab equipment"
    ldesc = "There's all sorts of complex equipment:  oscilloscopes,
        power supplies, meters, and lots of things you don't recognize."
    verDoTake(actor) = { "You shouldn't touch it; it could be dangerous."; }
;

rocketMotor: fixeditem
    sdesc = "rocket motor"
    location = rocketLab
    noun = 'motor' 'pipe' 'pipes' 'valve' 'valves' 'electronics' 'control'
        'controls'
    adjective = 'rocket' 'fuel' 'electronic'
    ldesc = "It's about twenty feet long and six feet in diameter.
        You had always pictured a rocket as being mostly a hollow
        cylinder full of fuel, but this is actually an extremely
        complex array of pipes, valves, and electronics."
    verDoTake(actor) = { "It's far too heavy."; }
;

rocketNosecone: fixeditem
    sdesc = "nose cone"
    noun = 'cone' 'nosecone' 'wire' 'wires' 'board' 'boards'
    adjective = 'nose' 'circuit'
    location = rocketLab
    ldesc = "It's been disassembled:  the cover panels have all
        been removed to reveal a network of wires and circuit boards."
;

rocketMissile: fixeditem
    sdesc = "missile"
    location = rocketLab
    noun = 'missile'
    ldesc = "It's in pieces all over the lab."
;
rocketLab: room
    sdesc = "Rocket Lab"
    ldesc =
    {
        "You're in a large lab filled with equipment, all clustered
        around a disassembled missile.  You never realized how big
        and complex missiles really are; you always pictured them as
        oversized model rockets, with big cylinders full of fuel
        that you just light on fire and watch it go.  The missile
        here is large and complicated.  The rocket motor is lying
        on the floor, with all its cover plates removed, revealing
        a complex array of pipes and electronic controls.  Lying
        next to the rocket motor is the nose cone";
        if (heatShield.location = self)
            " and the heat shield, which have been disassembled and removed.";
        else
            ", which has also been disassembled and removed.";
    }
    north = infernoHall3
;

tower: decoration
    noun = 'tower' 'building' 'needle'
    adjective = 'space' 'hadescorp'
    location = downtown
    sdesc = "Space Needle"
    ldesc = "The tower is extremely tall.  You can see its lighted
        windows high above, disappearing into the dark mist of
        the sky above.  The words \"HadesCorp Space Needle\"
        are engraved in large letters above the entrance."
;

towerElev: fixeditem
    noun = 'elevator' 'doors' 'door'
    adjective = 'elevator'
    sdesc = "elevator"
    ldesc = "The doors are open."
    location = towerbase
    verDoEnter(actor) = {}
    doEnter(actor) = { actor.travelTo(elevator); }
;

towerbase: room
    sdesc = "Base of Tower"
    ldesc = "You're in a gigantic, imposing lobby.  The ceiling is
        at least five stories above; the dark granite walls are adorned
        with strange gargoyles looking down on you from high overhead.
        The exit out to the street is to the south.
        \n\tAn elevator is to the north.  The elevator doors are open."
    south = downtown
    out = downtown
    north = elevator
;

gargoyle: decoration
    sdesc = "gargoyles"
    adesc = "some gargoyles"
    noun = 'gargolye' 'gargoyles'
    ldesc = "They look like unusual gargoyles to me."
    location = towerbase
;

elevPanels: decoration
    sdesc = "panel"
    noun = 'panel' 'panels' 'vine' 'vines' 'pattern' 'patterns'
    adjective = 'tiled' 'gold' 'interweaved'
    location = elevator
;

elevCarpet: decoration
    noun = 'carpet' 'carpeting' 'rug' 'floor'
    sdesc = "carpeting"
    location = elevator
;

elevLights: decoration
    sdesc = "light"
    noun = 'light' 'lights'
    location = elevator
;

elevator: room
    sdesc = "Elevator"
    ldesc =
    {
        "You're in a large, ornate elevator.  The walls are
        tiled with gold panels decorated with an intricate
        pattern of interweaved lines, resembling vines; the
        floor is covered with deep, plush carpeting; and 
        hanging from the ceiling is a chandelier with
        thousands of tiny lights. The open door leads
        south, ";
        if (self.inheaven)
            "onto the roof of the tower.";
        else
            "back out into the lobby.";
    }
    south =
    {
        if (inheaven)
            return(towerRoof);
        else
            return(towerbase);
    }
    out = (self.south)
    enterRoom(actor) =
    {
        if (inheaven)
        {
            inheaven := nil;
            "The operator immediately recognizes you. \"No need to
            show me your pass -- the trip
            down is free,\" he says with a slightly evil twinkle
            in his eye.  He pushes the \"Hell\" button, and the
            doors slide closed.  After a repeat (in reverse) of
            the ride, the doors open, and you find yourself back
            in hell.\b";
        }
        else if (ticket.istaken)
        {
            inheaven := true;
            "The operator immediately recognizes you. \"Back for
            another trip to Heaven?  Okay, let's go!\" He pushes
            the \"Heaven\" button, and the doors slide closed.
            After another exhilerating ride up into the sky,
            the doors slide open, and you find yourself back
            in heaven.\b";
        }
        pass enterRoom;
    }
;

elevControls: fixeditem
    sdesc = "controls"
    adesc = "any controls"
    ldesc = "Although you don't recognize the meaning of
        a few of the controls, you can easily guess the
        purpose of the two main buttons:  the top one
        is labeled \"Heaven,\" and the bottom one
        is labeled \"Hell.\""
    noun = 'controls' 'control' 'panel'
    adjective = 'control'
    location = elevator
;

chandelier: fixeditem
    sdesc = "chandelier"
    location = elevator
    noun = 'chandelier'
;

class elevButton: fixeditem
    noun = 'button'
    location = elevator
    verDoPush(actor) = {}
    doPush(actor) =
    {
        "The operator pushes you back gently but firmly.
        \"Sorry, I'm the only one authorized to operate the
        controls,\" he says.";
    }
;

heavenButton: elevButton
    adjective = 'heaven'
    sdesc = "heaven button"
    ldesc = "It's a large button labeled \"Heaven.\""
;

hellButton: elevButton
    adjective = 'hell'
    sdesc = "hell button"
    ldesc = "It's a large button labeled \"Hell.\""
;

