/* FIRST THINGS FIRST - objects.t
/*  Copyright (c) 1996, 1997, 1999, 2000, 2001 by J. Robinson Wheeler. All Rights Reserved. */

/* Pre-declare Misc. Objects */

playerCash: moneyItem
	doDrop( actor ) =
	{
		pass doDrop;
		
		"Dropping sums of cash ";
		
		if ( self.location.isTreeRoom )
			"to the ground from up here";
		if ( self.location.indoors )
			"on the floor";
		else
			"on the ground";
		" might be considered an imprudent activity. ";
	}
	
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"What do I look like, an economics professor?
				I just sell sandwiches.\" ";
				return( true );
			case Laura:
				if ( account.isopen )
					"Laura says, \"Did you want to deposit that? Because you'll
					have to see the teller about deposits.\" ";
				else
				{
					if ( self.value >= 100 )
						return( account.askingAboutMe( Laura ) );
					else
						"Laura says, \"That's not quite enough to open an account,
						I'm afraid.\" ";
				}
				return( true );
			case PLaura:
				return( finances.askingAboutMe( PLaura ) );
			case Architect:
				"He says, \"You've already paid me to work on this project,
				thank you. I wouldn't be here if you hadn't.\" ";
			default:
				return( nil );
		}
	}
;

dummyClearing: unimportantItem
	sdesc = "clearing"
	ldesc = 
	{
		self.location.ldesc;
	}
	noun = 'clearing'
	adjective = 'parking' 'lot'
	location =
	{
		local place;
		
		if ( Me.location = platform )
			place := Me.location.location;
		else
			place := Me.location;
		
		switch( place )
		{
			case FPclearing:
			case Pclearing:
			case clearing:
			case Fclearing:
				return( place );
			default:
				return( nil );
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"None of my business, of course, but it seems 
				like something weird is in the air tonight. I'd think about
				checking out that clearing in the woods.\" ";
				return( true );
			case Laura:
				"Laura says, \"That clearing sounds like it's full of
				weirdness.\" ";
				return( true );
			case Architect:
				"He says, \"As you recall, we thought about building
				farther out into the woods, but you determined that 
				we should leave as much of the trees in place as 
				possible.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

air: fixedBlock, floatingItem
	sdesc = "air"
	adesc = "air"
	ldesc = 
	{
		if ( Me.location = clearing )
		{
			if ( prettyLight.isWeird = 1 )
				"The air is rippling and whirling. ";
			else if ( prettyLight.isWeird = 2 )
				"The air is suffused with haze and ozone. ";
			else
				"You see nothing unusual. ";
		}	
		else if ( Me.isIn( FFclearing ) || Me.location = monolith )
			"The air is stifling, searing hot, and oppressive. It
			shimmers, making you feel as if you are hallucinating
			this experience. ";
		else if ( Me.location = grotto )
			"The air is still and quiet. ";
		else if ( Me.location = tightBend )
			chalkyDust.ldesc;
		else
			"You see nothing unusual. ";
	}
	
	noun = 'air' 
	adjective = 'wind' 'oxygen' 'warmth' 'heat' 'ozone' 'disturbance' 'vacuum' 'smoke'
			'puff' 'atmosphere' 'atmos' 'vibrations' 'vibration' 'damp'
	location = { return( Me.location ); }
	
	verDoTouch( actor ) = {}
	doTouch( actor ) =
	{
		if ( Me.location = clearing )
		{
			if ( prettyLight.isWeird > 0 )
				"The air is in motion, and feels electrified. ";
			else
				"The air feels slightly warmer than usual. ";
		}
		else if ( ( Me.location = FFclearing ) or ( Me.location = monolith ) )
			"The air feels stifling, searing hot, and oppressive. ";
		else if ( Me.location = grotto )
			"The air feels crisp, still, and quiet. ";
		else if ( Me.location.inSkyscraper )
			"The air is cold and sterile. ";
		else
			"You feel nothing special. ";
	}
	
	smellDesc =
	{
		if ( clearing.ozone = true )
			"The air smells of ozone. ";
		else if ( Me.location = grotto )
			"The air smells crisp, fresh, and sweet. ";
		else if ( global.timeLoc = 5 )
			"The air is a hot furnace blast in your nostrils, smelling
			of baked pavement. ";
		else if ( Me.location.location )
			Me.location.location.smellDesc;
		else
			Me.location.smellDesc;
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Air. Mmm.\" ";
				return( true );
			case Laura:
				"Laura says, \"I'm all for fresh air.\" ";
				return( true );
			case Architect:
				"He says, \"Air's air.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

genericLight: unimportantItem, floatingItem
	sdesc = 
	{
		"general light in the <<Me.location.indoors ? "room" : "area">>";
	}
	adesc = { "the "; self.sdesc; }
	ldesc = 
	{
		if ( Me.location.indoors || Me.location.cave )
		{
			Me.location.lightDesc;
		}
		else
		{
			local playerLoc;
			
			if ( Me.location = platform )
				playerLoc := Me.location.location;
			else
				playerLoc := Me.location;
			
			switch( global.timeLoc )
			{
				case 1:                                      
					if ( playerLoc.isFoliageRoom || playerLoc.cave )
						playerLoc.lightDesc;
					else
						theSky.ldesc;
					break;
				case 2:
				case 3:
				case 4:
				case 5:
					theSky.ldesc;
					break;
			}
		}
	}
	noun = 'light'
	adjective = 'general' 'somber' 'muted' 'dim' 'amber' 'misty' 'subdued'
			'pale' 'sparkling' 'brilliant' 'flourescent' 'fluorescent'
			'florescent' 'florecent' 'fluorecent' 'lighting' 'fixture' 'fixtures'
			'vibrant' 'dance' 'reflected' 'refracted' 'source'
	location =
	{
		if ( Me.location = clearing || ( Me.location = platform && 
			Me.location.location = clearing ) )
			return( nil );
		else
			return( Me.location );
	}
;

theMoon: unimportantItem, floatingItem
	sdesc = "moon"
	adesc = "the moon"
	ldesc = 
	{
		switch( global.timeLoc )
		{
			case 3:
				"The moon is gibbous and waning, but bright on this 
				cloudless night. ";
				break;
			case 4:
				"The moon is a silver sliver barely visible through
				the clouds near the horizon. ";
				break;
		}
	}
	noun = 'moon' 'luna' 'moonlight'
	adjective = 'gibbous' 'waning' 'silver' 'sliver'
	location =
	{
		if ( Me.location.indoors || Me.location.cave )
			return( nil );
		
		switch( global.timeLoc )
		{
			case 3:
			case 4: return( Me.location );
			default: return( nil );
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"The moon's okay I guess. I never pay much
				attention to it, to be honest.\" ";
				return( true );
			case Laura:
				"Laura says, \"I don't have much to say about the moon. 
				It's a big thing in the sky. Can be beautiful sometimes.\" ";
				return( true );
			case FLaura:
			case FFLaura:
				"Laura glares at you impatiently and says, \"What about it?\" ";
				return( true );
			case Architect:
				"He says, \"The moon is the moon is the moon. Must you 
				pester me with trivialities when I'm trying to work?\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

theStars: unimportantItem, floatingItem
	sdesc = "stars"
	adesc = "the stars"
	ldesc = 
	{
		switch( global.timeLoc )
		{
			case 3:
				"The stars are twinkling in the sky overhead. ";
				break;
		}
	}
	noun = 'star' 'aster' 'starlight'
	plural = 'stars' 'asters' 'constellations' 'planets' 
	isThem = true
	adjective = 'planet' 'constellation' 'milky' 'way'
	location =
	{
		if ( Me.location.indoors || Me.location.cave )
			return( nil );
		if ( global.timeLoc = 3 )
			return( Me.location );
		return( nil );
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"The stars are cool I guess. I never pay much
				attention to the sky, to be honest.\" ";
				return( true );
			case Laura:
				"Laura says, \"I love being out in the country where you can
				see millions of them that you never see in the night sky when
				you're in the city.\" ";
				return( true );
			case FLaura:
			case FFLaura:
				"Laura glares at you impatiently and says, \"What about them?\" ";
				return( true );
			case Architect:
				"He says, \"I'm an architect, not an astrologer.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

theSun: unimportantItem, floatingItem
	sdesc = "sun"
	adesc = "the sun"
	ldesc = 
	{
		if ( Me.location.indoors )
			return( nil );
		
		switch( global.timeLoc )
		{
			case 1:
				"The sun is full and bright on this summery morning. ";
				break;
			case 2:
				"The sun is warm, white and high overhead. ";
				break;
			case 4:
				"The sun is a white circle nearing the western horizon. ";
				break;
			case 5:
				if ( newFuture.isHere )
					"The sun is shining brightly golden. ";
				else
					"The sun is a fiery red globe, sizzling and oppressive. ";
				break;
		}
	}
	noun = 'sun' 'sol' 'sunlight'
	adjective = 'bright' 'golden' 'fiery' 'red' 'globe' 'sunset' 'sunrise'
			'sunsets' 'sunrises' 'brightly'
	location =
	{
		if ( Me.location.indoors || Me.location.cave )
			return( nil );
		
		switch( global.timeLoc )
		{
			case 1:
			case 2:
			case 5: return( Me.location );
			default: return( nil );
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"The sun's okay I guess. I never pay much
				attention to it, to be honest.\" ";
				return( true );
			case Laura:
				"Laura says, \"I love the sun. Especially a beautiful sunrise.\" ";
				return( true );
			case FLaura:
			case FFLaura:
				"Laura glares at you and says, \"What about it?\" ";
				return( true );
			case Architect:
				"He says, \"The moon is the moon is the moon. Must you 
				pester me with trivialities when I'm trying to work?\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

theSky: unimportantItem, floatingItem
	sdesc = "sky"
	adesc = "the sky"
	ldesc = 
	{
		if ( Me.location.indoors || Me.location.cave )
			return( nil );
		
		switch( global.timeLoc )
		{
			case 1:
				"The sun is full and bright on this summery morning. ";
				break;
			case 2:
				"The sun is warm, white and high overhead. ";
				break;
			case 3:
				"The moon is gibbous and waning, but bright on this 
				cloudless night. ";
				break;
			case 4:
				"The sky is overcast, a solid sheet of iron gray and pallid
				white. The moon is a silver sliver barely visible through
				the clouds near the horizon. The sun is a white circle 
				nearing the opposite horizon. ";
				break;
			case 5:
				if ( newFuture.isHere )
					"The sun is shining brightly golden. ";
				else
					"The sky is like a lake a molten fire, the first 
					sunset you ever thought to describe as ugly, as a
					blight. The	sun is a fiery red globe in the west, 
					sizzling and oppressive. ";
				break;
		}
	}
	noun = 'sky'
	adjective = 'clouds' 'cloud' 'weather'
	location =
	{
		if ( Me.location.indoors || Me.location.cave )
			return( nil );
		return( Me.location );
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Nice warm night tonight.\" ";
				return( true );
			case Laura:
				"Laura says, \"It's a beautiful day. I wish I were outside
				instead of in here working.\" ";
				return( true );
			case FLaura:
			case FFLaura:
				"Laura glares at you impatiently and says, \"What about it?\" ";
				return( true );
			case Architect:
				"He says, \"We're having a run of good weather. No spring rains
				to slow down construction, thankfully.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

rain: unimportantItem, floatingItem
	sdesc = "rain"
	ldesc = "It is a grey drizzle. "
	noun = 'rainclouds' 'rain'
	adjective = 'gray' 'grey' 'drizzle' 'wet'
	location =
	{
		if ( global.timeLoc = 4 )
			return( Me.location );
		else return( nil );
	}
;

You: Topic, floatingItem
	sdesc = "you"
	adesc = "you"
	thedesc = "you"
	ldesc = "I'm not sure who you're referring to. "
	noun = 'you'
	location = { return( Me.location ); }
	
	doILoveYou( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"Um.\" ";
				break;
			case FFred:
				"\^<<who.thedesc>> merely grunts in response. ";
				break;
			case Laura:
				"Laura blushes and says, \"Um, that's very sweet of you
				to say, but we've only just met.\" ";
				break;
			case PLaura:
				"Laura laughs. \"That's sweet of you to say, although
				I don't know what prompted that.\" ";
			case FFLaura:
				"Laura glares at you harshly. \"Somehow, I doubt your
				sincerity.\" ";
				break;
			case Architect:
				"He looks uncomfortable for a moment and says, \"Well,
				thank you, I suppose.\" ";
				break;
			default:
				"\^<<who.thedesc>> doesn't return your affections, I'm afraid. ";
				break;
		}
	}
	
	askingAboutMe( who ) = 
	{
		who.talkAboutMyself;
		return( true );
	}
	
	talkingAboutMe( who ) = 
	{
		"You'll have to rephrase that. ";
		return( true );
	}
	
	verDoThank( actor ) = {}
	doThank( actor ) = { "Don't mention it. "; }
;

sailor: fixeditem
	sdesc = "sailor"
	noun = 'sailor'
	
	verDoHello( actor ) = {}
	doHello( actor ) =
	{
		"Nothing happens. ";
	}
;

strength: fixeditem
	sdesc = "strength"
	noun = 'strength'
	
	verDoPray( actor ) = {}
	doPray( actor ) = 
	{
		if ( Me.location != hangingForDearLife )
			prayVerb.action( actor );
		else
		{
			"You pray for the strength to climb back up. You pray with a 
			fervency you didn't know you could summon. Something comes over
			you, a strange sense of peace, and you hear an inner voice tell
			you to relax. \b";
			
			brokenTrunk.doRelax( actor );
			rescue.prayedForHelp := true;
		}
	}
;

wolf: fixeditem
	sdesc = "wolf"
	noun = 'wolf'
	
	verDoYellFor( actor ) = {}
	doYellFor( actor ) =
	{
		"You shouldn't cry wolf. What if you really need help later and
		no one comes? ";
	}
;

bathOrShower: staticItem, floatingItem
	sdesc = "shower"
	ldesc = 
	{
		if ( self.location.isBathroom )
			"That isn't important. ";
		else
			"You don't see that here. ";
	}
	noun = 'bath' 'shower'
	location = { return( Me.location ); }
	
	verDoTake( actor ) = 
	{
		if ( self.location.isBathroom )
			"You can't do that here. ";
	}
	doTake( actor ) =
	{
		"The plumbing no longer works. ";
	}
;	

excrement: fixeditem, floatingItem
	sdesc = "excrement"
	ldesc = 
	{
		if ( self.location = FupstairsBathroom )
			"You'd rather not inspect it at all closely. ";
		else
			"You don't see that here. ";
	}
	noun = 'piss' 'shit' 'dump' 'crap' 'pee'
	location = { return( Me.location ); }
	
	verDoTake( actor ) = {}
	doTake( actor ) =
	{
		excreteVerb.action( actor );
	}
;

gameOfCatch: fixeditem, floatingItem
	sdesc = "game of catch"
	ldesc = "I don't see any <<self.sdesc>> here. "
	noun = 'catch' 'fetch'
	location = { return( Me.location ); }
	
	verDoPlay_With( actor, io ) = {}
	doPlay_With( actor, io ) = 
	{
		if ( tennisBall.deepIsIn( Me ) )
		{
			tennisBall.doThrowTo( actor, io );
		}
		else if ( frisbee.deepIsIn( Me ) )
		{
			frisbee.doThrowTo( actor, io );
		}
		else 
		{
			"You don't have anything handy to play catch with. ";
			if ( io != Fred && io != Blackie )
				"Besides, <<io.thedesc>> probably <<io.isntdesc>> interested
				in playing catch with you. ";
		}
	}
;

/* eof */
