/* Nurse's Transcript */

breakRoom: room
  sdesc = "Break Room"
  ldesc = {
    if (!self.seen) {
      self.seen := true;
      Me.jessicaArriveCnt := 0;
      setdaemon(jessicaArriveDaemon,nil);                   // two turns before Jen arrives
    }
    "You're inside one of the many break rooms here at the Hospital";
    if (freddie.location = receptionArea)
      ", just recharging with some apple chips and a bottle of Evian before heading back to your shift. ";
    else
      ", still a bit shaken after seeing that gun. ";
    "\bThe door leading out of the break room is to the west.  A small TV is wedged in the corner of the room. ";
  }
  out = {
    if (!Me.seenJessica) {
      "As you make your way toward the door, your friend Jessica pops her head into the room. \b";
      jessicaText();
      "\b";
    }
    return breakRoomDoor;
  }
  west = (self.out)
;

uniform: fixeditem
  sdesc = "uniform"
  noun = 'uniform'
  ldesc = "It fits you well. "
  verDoDrop(actor) = { "You need it. "; }
  takedesc = "You need to keep it on. "
;

evian: item
  sdesc = "bottle of Evian"
  noun = 'evian' 'water'
  adjective = 'bottle'
  ldesc = "There's nothing remarkable about the bottle of Evian. "
  verDoDrink(actor) = {}
  doDrink(actor) = {
    if (!self.isIn(Me)) {
      "(taking the bottle first)\n";
      self.moveInto(Me);
    }
    "You drink the water. Very refreshing. ";
  }
  verDoDeflate(actor) = {}
  doDeflate(actor) = { self.doDrink(actor); }
  verDoOpen(actor) = { "It's already open. "; }
  verDoClose(actor) = { "You can't do that. "; }
;

chips: item
  sdesc = "apple chips"
  noun = 'chips'
  adjective = 'apple'
  eatenCnt = 0
  ldesc = "Your favorite snack - apple chips. "
  verDoChew(actor) = {self.verDoEat(actor); }
  verDoEat(actor) = {}
  doEat(actor) = {
    if (!self.isIn(Me)) {
      "(taking the apple chips first)\n";
      self.moveInto(Me);
    }
    if (eatenCnt++ > 3) {
      "You finish them off. ";
      self.moveInto(nil);
    }
    else
      "You eat some apple chips. ";
  }
  isThem = true
;

breakRoomDoor: doorway
  noun = 'door'
  sdesc = "door"
  location = breakRoom
  doordest = receptionArea
  otherside = breakRoomDoor2
  
;

breakRoomDoor2: doorway
  noun = 'door'
  sdesc = "door"
  location = receptionArea
  doordest = breakRoom
  otherside = breakRoomDoor
;

jessica: Actor
  sdesc = "Jessica"
  adesc = "Jessica"
  thedesc = "Jessica"
  actorDesc = "Jessica"
  noun = 'jessica' 'jess'
;

jessicaArriveDaemon: function(parm)
{
  if (Me.jessicaArriveCnt++ = 2) {
    "\bYour friend Jessica pops her head into the room for a moment. \b ";
    jessicaText();
  }     
}     

jessicaText: function
{
  "<q>Sarah, it's Freddie,</q> she says. Freddie. Your ex-boyfriend. He hadn't come to work 
  in order to stalk you for almost two weeks now. It would be too soon if he held out for 
  two more centuries. <q>I tried to tell him that you weren't working today, but he says that
  he saw your car. Do you want me to -- </q>\b
  <q>No, it's okay,</q> you say. You've tried being nice. You've tried being stern. You've 
  tried to gently break the news to him that you no longer wish to see him, and you've told 
  him point blank to his face. Enough is enough. It's time to start being a complete bitch --
  anything to let him know you're serious.\b
  Jen gives you a thumbs-up sign and wishes you luck. She leaves the room and
  goes toward the reception area. ";
  Me.seenJessica := true;
  remdaemon(jessicaArriveDaemon, nil);
  setdaemon(freddieDaemon, nil);                // Freddie is now waiting for her
}

receptionArea: room
  sdesc = "Reception Area"
  ldesc = {
    "This is where the patients' guests and loved ones congregate before entering the rest of the 
    hospital and the individual rooms. ";
    if (freddie.location <> self) 
      "The LDR -- the labor, delivery, and recovery room -- is just north of the reception area. ";
  }
  noexit = { 
    if (freddie.location = self)
      "Freddie blocks your path. Not with force, but with pure, pathetic sniveling. ";
    else
      "The LDR is north, or you can enter the break room to the east. ";
  }
  north = {
    if (freddie.location = self)
      "Freddie blocks your path. Not with force, but with pure, pathetic sniveling. ";
    else {
      displayLDRscene();
      displayORscene();
      updateGameState('D');
      die();
    }
  }
  east = (self.in)
  in = {
    if (freddie.location = self)
      "Freddie blocks your path. Not with force, but with pure, pathetic sniveling. ";
    else
      return breakRoomDoor2;
  }
  genericHint = true
;

displayLDRscene: function
{
  "You enter the LDR Room, one of many here at the hospital -- a bit of
  oversentimental tedium designed to keep the expectant couples thinking pleasant
  thoughts, and introduce yourself to the patient and husband. \b
  <q>Hi, I'm -- </q>\b
  <q>Sarah, right,</q> says the man, <q>I know. Look, I am really concerned about my wife here, can you --</q>\b
  <q>You bet, don't worry. I will take a look and see what's up.</q> You suspect that everything will 
  probably be okay -- it was just a nasty shock to her head, not a gunshot wound to the belly
  or anything, but you feel the need to play it cool in case something <i>is</i> the matter.\b ";
  morePrompt();
  "You hook the belly band up to the woman and turn on the various monitors. \b
  <q>So, do you follow the Red Sox?</q> you ask the husband, in an attempt to liven his mood a bit
  and get him thinking of another kind of tragedy. \b
  <q>Yeah, a little -- hopefully this'll be the year,</q> says the husband. <q>I mean, we get Garrett 
  back, we have new management...</q>\b
  You take a look at the monitor strip. Things do not look good, but you continue to 
  play your poker face. \b
  <q>New management, right?</q> you say absent-mindedly. <q>Wait, wasn't that one guy who those
  crazies put out on a stake and -- </q>\b
  <q>Well, yeah, Duquette, the GM. Kind of a shame seeing him on fire like that, but I guess 
  we New England denizens can only go so many centuries without burning witches and heretics at -- </q>\b
  You study the fetal monitor. \b
  Everything makes sudden, horrible sense. \b
  Something -- the umbilical?\ -- is wrapped around the baby's neck. \b
  Your face goes white. The husband stops in mid-sentence.\b ";
  morePrompt();
  "After getting to the intercom, you send out a page:\b
  <q>Dr.\ McKinney, I need you in LDR 14 STAT, paging Dr.\ McKinney, LDR 14 STAT!</q>\b
  The husband looks confused and alarmed, but you have work to do.  You take his wife's
  blood pressure, temperature and heart rate.\b
  <q>We're going to need to get to the OR,</q> you tell the husband, softly. ";
  morePrompt();
}

displayORscene: function
{      
  "\bDr.\ McKinney does his best to save the little girl.  The poor baby had a nucal cord -- they're just so damn
  hard to predict.  You head over to the OR table to see if CPR can save a life, but before you arrive, you 
  stop dead in your tracks as you watch the father's face fill with horror.\b   
  You overhear a bit of the conversation between the doctor and his assistants. 
  It doesn't sound good, it doesn't sound like the baby made it...\b
  The doctor shakes his head and leaves the operating table. You can tell from the manner in which he carries
  himself that the baby didn't make it. \b
  He passes you, just a shell of his regular self. This is the first time you've seen him like 
  this -- he's usually a bastion of security and success.\b
  Dr.\ McKinney goes to break the news to Kieron, the woman's husband.\b
  You leave the Operating Room. You wander back over to the break room to pick up your stuff. Jessica meets you 
  half-way there. \b
  <q>Did you hear yet?</q> she says. <q>Freddie's on the news. They've got a camera on him. Over on channel 5.</q>\b
  <q>I don't really want to hear about Freddie right now,</q> you say. \b
  <q>What's wrong?</q>\b
  <q>The baby, the baby from LDR 14, you know, that couple?</q>\b
  <q>Oh, yeah.</q>\b
  <q>The baby died. Dr.\ McKinney just -- well, I just got back.</q>\b
  <q>That's so sad,</q> says Jessica. She pauses a couple of respectful beats. <q>Let's go get some lunch.</q> ";
  morePrompt(); 
}
      
spanishInq: decoration
  sdesc = "Spanish Inquisition"
  noun = 'inquisition'
  adjective = 'spanish'
  location = freddie
  ldesc = "Nobody expects them, really. "
;

freddie: Actor
  sdesc = "Freddie"
  noun = 'freddie' 'fred'
  takedesc = "I don't think he would appreciate that. "
  isHim = true
  ldesc = "Freddie's about 5'9\", and 150 pounds. He's very handsome on the outside, in a young-Robert-Redford 
          way, but just not someone you want to be around because of what he's like on the inside. He's a bit 
          of an aspiring inventor, and tinkers around with electronics but has no real formal education and 
          gets frustrated easily. He's obsessed with a girl being around while he works away at one of his 
          many poorly-conceived mechanical devices, but then goes into total ignore mode once you -- or 
          one of his other previous girlfriends -- comes over. And you stopped being That Girl somewhere 
          between age 14 and 15. Also, when things start to go wrong with one of his projects he swears 
          like a blue-faced sailor. And he gets *mean*. Etcetera, etcetera. It just got pointless to be around him. "
  adesc = { self.sdesc; }
  thedesc = { self.sdesc; }
  location = receptionArea
  actorDesc = "Freddie is here, looking grim. "
  verDoSearch(actor) = { "<q>Hey!</q>\ he protests, moving away from you. 
                         <q>What is this, the Spanish Inquisition?</q> "; }
  verDoHug(actor) = {"You don't feel that way toward him. He's a jerk! "; }
  verDoKiss(actor) = {"You'd hate to give him the wrong idea -- besides, he's really pissed you off
                      by coming down here. "; }
  answerYes = { "\^<<self.thedesc>> likes it when you say yes. "; }
  answerNo =  { "\^<<self.thedesc>> doesn't like to hear no. "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    if (v.isTravelVerb) {
      "<q>I'm not going anywhere right now.</q> ";
      exit;
    }
    switch(v) {
      case noVerb:
      case yesVerb:
      case helloVerb:
        break;
      case wearVerb:
        "<q>I'm comfortable with what I'm already wearing.</q> ";
        exit;
      default:
        "<q>Stop telling me what to do,</q> he says. ";
        exit;
    }
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what <<self.thedesc>> has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  dontKnow = {
    local msg := [
      '<q>I don\'t know much about that,</q> says '
      '<q>I don\'t really know,</q> states '
      '<q>You probably know as much as I do,</q> quips '
      '<q>Were you talking to me?</q>\ questions '
      '<q>Sorry, not my area of expertise,</q> exclaims '
      '<q>Um... Did you say something?</q>\ asks '
      'A shrug is all you get from '
    ];
    say(msg[rand(length(msg))]);
  }
  askWord(word, lst) = {
    switch(substr(word, 1, 7)) {
      case 'me':
      case 'myself':
      case 'sarah':
        "<q>I still want you back, baybee.</q> ";
        break;
      case 'jacket':
        "<q>Pretty cool, huh?</q> ";
        return true;
        break;
      case 'gun':
        "What gun? ";
        return true;
        break;
      case 'electro':
        "<q>Ha, ha,</q> says Freddie, <q>look, I know you're not into that stuff.</q> ";
        return true;
        break;
      case 'paper':
      case 'poem':
      case 'zeppeli':
      case 'led zep':
      case 'zep':
      case 'led':
      case 'lyrics':
        if (freddie.turnCount < 7)            // if more singing needed by Freddie
          "<q>Hold on, babe,</q> he says, <q>I'm not done yet.</q> ";
        else if (!self.searchGun)
           sarahGunText();
        else
          "Nothing but silence from freddie. ";
        return true;
        break;
      default:
        dontKnow; "<<self.sdesc>>. ";
        return nil;
      }
  }
  doAskAbout(actor, iobj) = {
    switch(iobj) {
      case himself:
        "<q>Ah, I'm just this guy, you know. I can be a better guy, though,</q> he says. ";
        break;
      default:
        /* we didn't find anything special; use the default behavior */
        inherited.doAskAbout(actor, iobj);
    }
  }
  doHello = { 
    if (!self.helloSaid) {
      "<q>Hey babe,</q>\ he says. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.sdesc>> smiles at you, probably wondering why you 
      insist on repeating a greeting. ";
  }
  verDoTurnon(actor) = { "I'm sure you can think of something else to do, no? 
                         Besides, why would you want to alienate <<self.sdesc>>. "; }
  verDoScrew(actor) = { "You'd sooner screw a pig. "; }
  doSynonym('Attack') = 'Push' 'Pull' 'Move' 'Touch'
  verDoAttack(actor) = { }
  doAttack(actor) = { "Probably best not to do that, he'd interpret it to mean that you still want his bod. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = {
    if (dobj = Me)
      "You did a strip-tease for him once to the theme song of 'The Transformers' but you 
      had consumed a bowl of gin. Such things, you decided, were never to be done again! ";
    else
      "Freddie ignores you. ";
  }
  turnCount = 0         // used by Daemon
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { 
    if (freddie.turnCount < 7) {          // if more singing needed by Freddie
      freddieText(nil);                   //   sending NIL tells function it's called from here
      self.skipDaemon := true;            //   fake daemon code to not execute anything
    }
    else if (!self.searchGun)
      sarahGunText();
    else
      freddieGunText(nil);              // call function from TALK TO (vs. Daemon)
  }
;

sarahGunText: function
{
  "<q>What on earth was that, Freddie?</q>\b
  <q>It was 'What Is And What Should Never Be' from Zep's second album. I -- </q>\b
  <q>I know what it was. You had to come down here, and interrupt my break for that? You simply <i>had</i>
  to state that, hm? What on earth does that even mean, anyway? 'You will be mine by taking our
  time'? Is that what you think? How can I put this into words you'll understand -- Go away.
  Leave me alone, and never speak to me again.  Am I getting through to you?</q> \b
  <q>But -- </q>\b
  <q>Apparently not. Look, I'll put this into words that you can understand.</q> You
  clear your voice and start singing a quick impression of the Led Zeppelin song
  called <q>D''yer Mak'er.</q> <q>Go, go, go, go, <i>go!</i></q>\b
  Freddie digs through his jacket. ";
  remdaemon(freddieDaemon, nil);
  setdaemon(freddieGunDaemon, nil);
  freddie.searchGun := true;
  freddie.skipDaemon := true;            //   fake daemon code to not execute anything
}

jacket: clothingItem
  sdesc = "jacket"
  noun = 'jacket' 'coat'
  adjective = 'freddie\'s'
  location = freddie
  ldesc = "Nothing special. "
  isListed = nil
  isworn = true
  verDoWear(actor) = { "Freddie is wearing the jacket. "; }
  verDoTake(actor) = { "It's not yours. "; }
;


freddieItems: item
  sdesc = "topic of the moment"
  noun = 'himself' 'jacket' 'gun' 'electronics' 'paper' 'poem' 'zeppelin' 'page' 'plant' 'bonham' 'jones' 'zepp' 'led zeppelin' 'lyrics' 'zep'
  adjective = 'led'
;

freddieDaemon: function(parm)
{
  if (freddie.skipDaemon) {             // is skip daemon (code already executed by TALK TO method)
    freddie.skipDaemon := nil;          //   only skip once!
    return;                            
  }
  freddieText(true);                    // tell function called from daemon
}

freddieText: function(fromDaemon)
{
  freddie.turnCount++;                  // keep changing game state
  if ((freddie.turnCount > 2) and (Me.location = breakRoom)) {
    if (!freddie.knocked) {
      freddie.knocked := true;
      "\bYou hear a knock on the door -- it's Freddie. ";
      if (breakRoomDoor.isopen) {
        if (!breakRoomDoor.knockKnock) {
          breakRoomDoor.knockKnock := true;
          "\bWhat a moron -- even with the door open he still knocks. ";
        }
      }
    }
    else
      switch(rand(9)) {
        case 1:
          "\bFreddie knocks on the door a little more forcefully. ";
          if (breakRoomDoor.isopen) {
            if (!breakRoomDoor.knockKnock) {
              breakRoomDoor.knockKnock := true;
              "\bWhat a moron -- even with the door now open, he still continues to knock. ";
            }
          }
          break;
        case 4:
          "\bFreddie tries the 'shave and a haircut' knock. ";
          if (breakRoomDoor.isopen) {
            if (!breakRoomDoor.knockKnock) {
              breakRoomDoor.knockKnock := true;
              "\bWhat a moron -- even with the door now open, he still continues to knock. ";
            }
          }
          break;
        case 7:
          "\bFreddie knocks, again, on the door. ";
          if (breakRoomDoor.isopen) {
            if (!breakRoomDoor.knockKnock) {
              breakRoomDoor.knockKnock := true;
              "\bWhat a moron -- even with the door now open, he still continues to knock. ";
            }
          }
          break;
      }
    freddie.turnCount--;                // keep it at 3 so switch code below can work
    return;
  }
  if (Me.location = breakRoom) return;  // do nothing until you're in the reception area
  switch (freddie.turnCount) {
    case 0:
    case 1:
    case 2:
    case 3:
      "\b<q>Thank God you're here,</q> he says. <q>I have something to say to you, please, just hear 
      me out.</q> He can't help instinctively giving you a visual once-over; must be the uniform. ";
      freddie.turnCount := 3;           // force to next switch state
      break;
    case 4:
      if (!fromDaemon)
        "<q>What are you doing here?</q>\ you ask. ";
      "\b<q>I was working on the refrigeration unit -- you know, the one I was telling you about 
      before,</q> he says, as he brings a hand up to brush his fair hair out of his face. <q>And 
      I knew, really, that I had to have you back. I have a poem for you. Can I -- is this okay?</q> ";
      Me.conversingWith := true;
      break;
    case 5:
      Me.conversingWith := nil;
      if (!fromDaemon)
        "<q>This really is not the time, Freddie. Listen, I don't want you coming 
        here any more. Do you understand?</q>
        <q>Please,</q> he says. <q>Just listen. Hear me.</q> ";
      "\bFreddie pulls out a piece of paper. ";
      poem.moveInto(freddie);
      break;
    case 6:
      if (!fromDaemon)
        "You start to talk, but Freddie cuts you off. ";
      else
        "\bFreddie clears his throat and continues. ";
      "\b<q>And if I say to you tomorrow,</q> Freddie says, in a very bad British falsetto, 
      <q>Take my hand, child, come with me. It's to a castle I will take you, Where what's 
      to be, they say will be.</q> He looks up briefly. You try to remember where that is from.\b
      <q>Catch the wind, see us spin,<q> he continues, <q>Sail away, leave today, Way up high in the sky.</q>\b
      <q>But the wind won't blow, You really shouldn't go, It only goes to show That you will be mine
      By takin' our time. Oooh, oooooh.....</q> ";
      break;
    case 7:
      if (!fromDaemon)
        "<q>Is that...\ what is that?</q>\b Freddie ignores you. ";
      else
        "\bFreddie licks his lips and continues singing. ";
      "\b<q>And if you say to me tomorrow, Oh what fun it all would be, Then what's to stop us, pretty baby,
      But What Is And What Should Never Be.</q>\b
      He looks up at you with puppy-dog eyes. As if reading the lyrics -- badly -- to an old Led Zeppelin
      song is somehow going to instantly change the fact that he's a mite desperate oil-covered stalker
      without a hint of real social charm? ";
      break;
    default:
      if (!fromDaemon)
        "You can't think of anything else to say at the moment. ";
      else if (rand(4) = rand(4)) {
        if (rand(4) = rand(4))
          "\bIt looks like Freddie wants you to talk to him about his reading or something. ";
        else if (rand(4) = rand(4))
          "\bFreddie looks at you with anticipation. ";
      }
      break;
  }     
}     

poem: item
  sdesc = "paper"
  noun = 'paper' 'poem'
  ldesc = "Well, it's the words to the poem Freddie just felt you absolutely had to hear. "
  isListed = nil
  verDoRead(actor) = { "Freddie won't let you. "; }
;

freddieGunDaemon: function(parm)
{
  if (freddie.skipDaemon) {             // is skip daemon (don't excute the first time)
    freddie.skipDaemon := nil;          //   only skip once!
    return;                            
  }
  freddieGunText(true);                    // tell function called from daemon
}

freddieGunText: function(fromDaemon)
{
  if (!fromDaemon)
    "You start to speak, but he cuts you off in mid sentence.";
  "\bFreddie shows you a gun, briefly.\b
  <q>See this, bitch? I'm going to make you sorry you ever met me.</q>\b
  Freddie puts the gun away and storms out of the hospital.\b
  A moment later, your name comes up on the intercom.\b
  <q>Sarah Thompson, please report to LDR 14, Sarah Thompson, LDR 14.</q>\b
  The LDR -- the labor, delivery, and recovery room -- is just north of the reception area. ";
  remdaemon(freddieGunDaemon,nil);
  freddie.moveInto(nil);  
}

// Added TV in breakroom to spit out some text concerning the "monster".
// Ripped the code from At Wit's End...
nurseTV: fixeditem
  sdesc = "portable TV"
  noun = 'tv' 'screen' 'picture'
  adjective = 'portable'
  location = breakRoom 
  takedesc = "It's hospital property. "
  verDoFix(actor) = { "Patients at this hospital with terminal cancer are not as hopeless as the odds of
                      getting the vertical hold synched correctly on the TV. "; }
  ldesc = {
    "It's an aging 14\" color TV with vertical hold problems. It has an antenna";
    if (antenna.extended)
      " (extended), ";
    " attached to the back.  The TV is currently ";
    if (self.ison) "on"; else "off"; 
    " and appears to be battery operated. On the back of 
    the TV is a battery compartment. ";
    if (TVcompartment.isopen) TVcompartment.ldesc;
    "\bA TV dial is attached to the front of <<self.thedesc>>. ";
    TVdial.ldesc;
  }
  verDoTurnon(actor) = {
    if (self.ison)
      "The TV is already on. ";
    if (self.broken)
      "The TV did not survive the fall from the ladder. ";
  }
  verDoTurnoff(actor) = {
    if (!self.ison)
      "The TV is not on. ";
  }
  doTurnoff(actor) = {
    "You turn off the TV. ";
    self.ison := nil;
  }
  doTurnon(actor) = {
    switch (self.batteryCnt) {
      case 0:
        "It does not turn on. ";
        break;
      case 1:
        "The TV requires four C batteries, so you're three short. ";
        break;
      case 2:
        "The TV requires four C batteries, so you're two short. ";
        break;
      case 3:
        "The TV requires four C batteries, so you're one short. ";
        break;
      case 4:
        "The TV is now on. ";
        self.ison := true;
        self.turnedOn := true;          // for hint system
        if (antenna.extended and TVdial.setting <> 7 and TVdial.setting <> 8 
            and TVdial.setting <> 11 and TVdial.setting <> 13)
          "A picture now appears on the small TV screen. ";
        break;
    }
  }
  broken = nil
  isListed = nil
  verIoPutIn(actor) = {}
  ioPutIn (actor, dobj) = { TVcompartment.ioPutIn(actor, dobj); }
  batteryCnt = 4
  verDoWatch(actor) = {}
  doWatch(actor) = { watchTV(); }
  watching = 0
;

watchTV: function
{

  local show1 = 808, show2 = 818, show3 = 828, show4 = 838; // yeah, every 10 minutes. ;)
  
  if (!nurseTV.ison) {
    "You stare at a blank screen for a moment, but quickly get bored. ";
    exit;
  }
  if (!antenna.extended) {
    "You see nothing but snow. ";
    exit;
  }
  switch (TVdial.setting) {
    case 2:
      "It's the local public broadcast station.  ";
      if (timesys.time < show1)
        "The Teletubbies are bouncing around the screen.  Pure joy. ";
      else if (timesys.time < show2)
        "The characters of Sesame Street are filling the tiny screen. ";
      else if (timesys.time < show3)
        "A big purple dinosaur is singing and laughing.  Your stomach turns. ";
      else if (timesys.time < show4)
        "Some do-it-yourself show is currently playing. ";
      else 
        "A couple of boring people are debating something. ";
      break;
    case 3:
      if (timesys.time < show1)
        "Two characters are over-acting like only William Shatner can; it's
        apparently a soap opera. ";
      else if (timesys.time < show2)
        "Some soap opera is playing. ";
      else if (timesys.time < show3)
        "A slow paced movie is playing. ";
      else if (timesys.time < show4)
        "A boring movie is currently on the tube. ";
      else 
        "A forgettable movie is currently playing. ";
      break;
    case 4:
      "An episode of Star Trek, the original series, is on.  You've seen
      this one before.  ";
      if (timesys.time < show1)
        "Somebody stole Spock's brain; one of the worst episodes to ever air,
        in your humble opinion. ";
      else if (timesys.time < show2)
        "Kirk is about to use the Corbomite maneuver to trick that alien dude. ";
      else if (timesys.time < show3)
        "It's the Trouble With Tribbles; a classic episode, especially since
        Deep Space Nine revisited their ship. ";
      else if (timesys.time < show4)
        "It's the one about that rock monster that is killing the miners 
        because they're killing its young.  You fondly remember it because
        it was the first time you witness Spock do his mind-meld.  Real cool.";
      else 
        "Kirk has amnesia and thinks he's a god.  Now that's a stretch. ";
      break;
    case 5:
      if (timesys.time < show2)
        "An old western movie is plodding along. ";
      else 
        "A black and white movie is trudging along. ";
      break;
    case 6:
      "A talk show concerned with how to ";
      if (timesys.time < show1)
        "properly raise children is playing. ";
      else if (timesys.time < show2)
        "avoid e-mail spam is playing. ";
      else if (timesys.time < show3)
        "avoid blind dates is currently playing. ";
      else if (timesys.time < show4)
        "save money while shopping is playing. ";
      else 
        "attract the opposite sex is currently playing. ";
      break;
    case 7:
      nurseTV.watching++;
      if (nurseTV.watching = 1)
        "The only thing that is on is coverage of a student protest at Southside Community College.
        The interviewed students have worked themselves into a furor, but from what you are gathered
        they are extremely upset with rumors that someone is planning on bringing a, quote, <q>monster</q>
        into the community. ";
      else if (nurseTV.watching = 2)
        "The screen starts to act up again, but the sound at least works correctly. A wiry waif of a 
        male student with glasses that look like they came straight out of <q>The Far Side</q> is advocating
        violence and retaliation against those who would willingly bring fiends into the state. After
        some prodding from the reporter, he sort of backtracks and reduces his arguments to supporting
        mere criminal mischief and harassment instead. ";
      else if (nurseTV.watching = 3) 
        "Students continue to protest, chanting <q>Pittman must go</q> and then the image freezes... ";
      else
        "The signal has stalled on an image of students protesting.  There is no sound. ";
      break;
    case 8:
      "Nothing but snow.";
      break;
    case 9:
      if (timesys.time < show1)
        "A fishing show is on. ";
      else if (timesys.time < show2)
        "An auto show is playing. ";
      else if (timesys.time < show3)
        "A documentary on urban legends is playing. ";
      else if (timesys.time < show4)
        "A fishing show is on. ";
      else 
        "A program on the history of Interactive Fiction is playing. ";
        if (!Me.seenIF) {
          Me.seenIF := true;
          "\b[Author's note: You're probably the <i>only</i> player to ever see this message!] ";
        }
      break;
    case 10:
      if (timesys.time < show1)
        "The local news is being aired.  Nothing interesting is being reported. ";
      else if (timesys.time < show2)
        "A sports show is being shown. ";
      else if (timesys.time < show3)
        "The local news is being aired.  Boring. ";
      else if (timesys.time < show4)
        "An interview is being conducted at town hall.  It's monotonous. ";
      else 
        "The local news is being aired. ";
      break;
    case 11:
      "Nothing but snow. ";
      break;
    case 12:
      "A trashy talk show, focusing on ";
      if (timesys.time < show1)
        "lesbians that ride Harley's together";
      else if (timesys.time < show2)
        "triangle love affairs";
      else if (timesys.time < show3)
        "why woman really think size is important";
      else if (timesys.time < show4)
        "women that love men that want women to ride naked with other woman on Harley's";
      else 
        "sex in the new millennium";
      " is currently playing. ";
      break;
    case 13:
      "It's the weather channel.  ";
      if (timesys.time < show1)
        "It appears that a large storm is heading toward New England. ";
      else if (timesys.time < show2)
        "It appears that a very large storm is ready to hit New England. ";
      else if (timesys.time < show3)
        "They're focusing on a very large storm slamming the New England coastline. ";
      else if (timesys.time < show4)
        "Apparently a very large storm is drenching New England. ";
      else 
        "A vicious storm is pounding the New England coastline. ";
      break;
  }   
}

TVsnow: decoration
  sdesc = "snow"
  noun = 'snow'
  location = nurseTV
  ldesc = {
    if (nurseTV.ison and !antenna.extended)
      "It's a pretty pattern of snow, the reception is lousy here. ";
    else
      "I see no such thing. ";
  }
;

TVcompartment: fixeditem
  sdesc = "TV compartment"
  noun = 'compartment'
  adjective = 'TV'
  location = nurseTV
  verDoOpen(actor) = { "It's sealed shut. "; }
  ldesc = {
    if (!self.isopen)
      "It appears to be a battery compartment; it's currently closed. ";
    else if (itemcnt(self.contents) = 0)
      "The compartment is currently empty.  It appears that it requires four
      C batteries. ";
    else {
      "The compartment seems to contain ";
      listcont(self.contents); ". ";
    }
  }
  ioPutIn (actor, dobj) = {
    if (dobj.location <> Me)
      "You're not carrying <<dobj.thedesc>>. ";
    else if (!self.isopen)
      "The compartment is closed. ";
    else 
      "You can't put <<dobj.thedesc>> into <<self.thedesc>>. ";
  }
  isopen = nil
  takedesc = "The compartment is attached to the TV. "
;

TVdial: fixeditem
  sdesc = "TV dial"
  noun = 'dial' 'channel'
  adjective = 'TV'
  location = nurseTV
  minsetting = 2  // it has settings from this value...
  maxsetting = 13 // ...to this value
  setting = 7     // the current setting
  ldesc = {
    caps(); self.thedesc; " can be turned to channels
    numbered from <<self.minsetting>> to <<self.maxsetting>>.
    \^<<self.itisdesc>> currently set to <<self.setting>>. ";
  }
  verDoSet(actor) = {}
  doSet(actor) = { askio(toPrep); }
  verDoSetTo(actor, io) = {}
  doSetTo(actor,io) = { self.doTurnTo(actor, io); }
  verDoTurn(actor) = {}
  doTurn(actor) = { askio(toPrep); }
  verDoTurnTo(actor, io) = {}
  doTurnTo(actor, io) = {
    if (io = numObj) {
      if (numObj.value < self.minsetting
          or numObj.value > self.maxsetting)
        "There's no such channel. ";
      else if (numObj.value <> self.setting) {
        self.setting := numObj.value;
        "Okay, <<self.itisdesc>> now turned to channel ";
        say(self.setting); ". ";
      }
      else {
        "\^<<self.itisdesc>> already set to ";
        say(self.setting); ". ";
      }
    }
    else
      "I don't know how to turn <<self.thedesc>> to that. ";
  }
  takedesc = "It's firmly attached to the TV. "
;

antenna: fixeditem
  location = nurseTV
  sdesc = "antenna"
  adesc = "an antenna"
  noun = 'antenna'
  extended = true
  ldesc = {
    "It's your standard twelve inch metal antenna. ";
    if (self.extended)
      "It is currently extended. ";
    else
      "It is currently retracted. ";
  }
  doSynonym('Pull') = 'Extend' 'Move'
  verDoPull(actor) = {}
  doPull(actor) = {
    if (self.extended)
      "The antenna is extended as far as it can. ";
    else {
      "The antenna is now extended. ";
      self.extended := true;
      if (nurseTV.ison and TVdial.setting <> 8 and
          TVdial.setting <> 11 and TVdial.setting <> 13)
        "A picture now appears on the small TV screen. ";
    }
  }
  doSynonym('Close') = 'Retract'
  verDoClose(actor) = {}
  doClose(actor) = {
    if (!self.extended)
      "The antenna is already retracted. ";
    else {
      "The antenna is now retracted. ";
      self.extended := nil;
      if (nurseTV.ison)
        "The TV screen turns to snow. ";
    }
  }
;

/* The remaining code is not used due to, well, I didn't have the time or patience to implement it.  It
   doesn't work, but the intent was to replay Kieron's actions (they can be successfuly stored/retrieved)
   but it got to close to the deadline so we decided to scrap it.  MjS 9/6/01
LDRNurse: room
  sdesc = "LDR 14"
  ldesc = {
    "This LDR Room is one of many here at the hospital -- a bit of oversentimental tedium 
    designed to keep the expectant couples thinking pleasant thoughts. ";
    if (!self.seen) {
      self.seen := true;
      if (global.turnsofar < 25)                // if not past 1:41 already.
        settimesys( '1:41 p.m.', 1, 2001, 10, 01 );
      "\bA pregnant woman and her husband (presumably) are here with you. ";
        game.handle := fopen('pc1.ldr', 'rt');    // open file for reading in text mode
        game.unused := fread(game.handle);        // read in first garbage line
        setdaemon(nurseReplayDaemon,nil);
    }
  }
  genericHint = true
;

nurseReplayDaemon: function(parm)
{
  "\b";
  switch(nurse.count++) {
    case 0: 
      "You arrive from the hall. ";
      break;
    case 1:
      "You introduces yourself to the patient and husband and begin checking on mom. ";
      break;
    case 2:
      "You wrap the belly band on the patient. ";
      strip.moveInto(nurse);
      break;
    case 3:
      if (!fetalMonitor.hookedUp) {
        fetalMonitor.hookedUp := true;
        "The nurse begins hooking up the various monitors to Charlise. ";
      }
      else
        "The nurse patiently waits for the fetal monitor to give a reading. ";
      break;
    case 4:
      "You start reviewing the monitor strip -- it doesn't look good. ";
      strip.moveInto(nurse);
      break;
    case 5:
      "You continue to study the fetal monitor with a concerned look. ";
      break;
    case 6:
      "Your face goes white. You head toward the intercomm. \b
      <q>Paging Dr.\ McKinney, I need you in LDR 14 STAT, paging Dr.\ McKinney, 
      LDR 14 STAT!</q> ";
      break;
    case 7:
      "You take mom's blood pressure and check her heart rate. ";
      break;
    case 8:
      "You continue to study the fetal monitor strip. ";
      break;
    case 9:
      "You take mom's temperature. ";
      break;
    case 10:
      "You head to the OR ";
      break;
  }
  processKieronScript();
}     

processKieronScript: function()
{
  local actor, verb, dobj, prep, iobj;
  if (game.handle = nil) return;
  actor := fread(game.handle);
  if (actor = nil) return;              // unexpected EOF
  verb := fread(game.handle);
  dobj := fread(game.handle);
  prep := fread(game.handle);
  iobj := fread(game.handle);
  "\b<<actor>> <<verb>> <<dobj>> <<prep>> <<iobj>>.";
  if (nurse.count = 10) remdaemon(nurseReplayDaemon,nil);
}
*/
