////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: DarkRoomActionable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _DARK_ROOM_ACTIONABLE_H_
#define _DARK_ROOM_ACTIONABLE_H_

#include <roomactionable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  DarkRoomActionable: RoomActionable
 *
 *  Rules for room actions in a DarkRoom-style room.
 */
class DarkRoomActionable: RoomActionable
    lightsOn = nil
    roomCheck(v) = {
        if (self.isLit(gActor()) || v.isDarkVerb)
            return true;
        else {
            "It's pitch black.\n";
            return nil;
        }
    }
    roomAction(actor, v, dobj, prep, io) = {
        if (!self.isLit(actor) && !v.isDarkVerb) {
            "%You% can't see a thing. ";
            exit;
        }
        else pass roomAction;
    }
;

#pragma C-

#endif /* _DARK_ROOM_ACTIONABLE_H_ */
