////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: DialItem 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _DIAL_ITEM_H_
#define _DIAL_ITEM_H_

#include <fixeditem.h>
#include <askforiobj.t>

#pragma C+

/*
 *  DialItem: FixedItem
 *
 *  This class is used for making "dials," which are controls in
 *  your game that can be turned to a range of numbers.  You can
 *  define the property maxSetting as a number specifying the
 *  highest number to which the dial can be turned; the lowest number
 *  on the dial is minSetting.  The setting property is the dial's
 *  current setting, and can be changed by the player by typing the
 *  command "turn dial to number."  By default, the lDesc
 *  method displays the current setting.
 */
class DialItem: FixedItem
    minSetting = 1  // it has settings from this value...
    maxSetting = 10 // ...to this value
    setting = 1     // the current setting
    lDesc = {
        caps(); self.theDesc; " can be turned to settings
        numbered from << self.minSetting >> to << self.maxSetting >>.
        \^<<self.itIsDesc>> currently set to << self.setting >>. ";
    }
    verDoTurn(actor) = {}
    doTurn(actor) = {
        askForIobj(toPrep);
    }
    verDoTurnTo(actor, io) = {}
    doTurnTo(actor, io) = {
        if (io == numObj) {
            if (numObj.value < self.minSetting
            || numObj.value > self.maxSetting) {
                "There's no such setting! ";
            } else if (numObj.value != self.setting) {
                self.setting = numObj.value;
                "Okay, <<self.itIsDesc>> now turned to ";
                say(self.setting); ". ";
            } else {
                "\^<<self.itIsDesc>> already set to ";
                 say(self.setting); "! ";
            }
        } else {
            "I don't know how to turn "; self.theDesc;
            " to that. ";
        }
    }
;

#pragma C-

#endif /* _DIAL_ITEM_H_ */
