////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: NestedRoomTravelable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _NESTED_ROOM_TRAVELABLE_H_
#define _NESTED_ROOM_TRAVELABLE_H_

#include <roomtravelable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  NestedRoomTravelable: RoomTravelable
 *
 *  This class allows the actor to board the object with commands such
 *  such as "get in/get on". The actor posture is set to "standing"
 *  by default.
 */
class NestedRoomTravelable: RoomTravelable
    verDoBoard(actor) = {
        if (actor.location == self
        && actor.posture == self.boardingPosture) {
            "%You're% already <<actor.posture.desc>> 
            <<self.boardingPrep>> <<self.theDesc>>! ";
        }
    }
    doBoard(actor) = {
        if (actor.location != self)
            actor.travelTo(self);
        actor.posture = self.boardingPosture;
        "Okay, %you're% now <<actor.posture.desc>> 
        <<self.boardingPrep>> <<self.theDesc>>. ";
    }
    noExit = {
        "%You're% not going anywhere until %you%
        get%s% <<unboardingPrep>> <<theDesc>>. ";
        return nil;
    }
;

#pragma C-

#endif /* _NESTED_ROOM_TRAVELABLE_H_ */
