////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: scoreStatus() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SCORE_STATUS_T_
#define _SCORE_STATUS_T_

#include <scoreformat.t>

#pragma C+

/*
 *  scoreStatus: function(points, turns)
 *
 *  This function updates the score on the status line.  This implementation
 *  simply calls the built-in function setscore() with the same information.
 *  The call to setscore() has been isolated in this function to make it
 *  easier to replace with a customized version; to replace the status line
 *  score display, simply replace this routine.
 */
scoreStatus: function(points, turns) {
    /* get the formatted score string, and set the score to that value */
    setscore(scoreFormat(points, turns));
}

#pragma C-

#endif /* _SCORE_STATUS_T_ */
