#include <windows.h>
#include <stdlib.h>
#include <string.h>

#include "winio.h"
#include "global.h"

VOID copy_selec_to_clip(unsigned char *buf, long len);
PSZ copy_clip_to_string(VOID);

VOID copy_selec_to_clip(unsigned char *buf, long len)
{
	PSZ		pszDest;
	HGLOBAL	h;
	
	if (len <= 0) return;

	if (OpenClipboard(hwndFrame)) { 

		/* Allocate a shared memory object for the text data. */
		h = GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT | GMEM_DDESHARE, len+1);
		if (h != NULL) {
			if ((pszDest = (PSZ)GlobalLock(h)) != NULL) {
				strncpy(pszDest, buf, len);
				GlobalUnlock(h);
				SetClipboardData(CF_TEXT, h);
			}
		}
		CloseClipboard(); 	
	}
}

/* N.B. this function allocates pszRetn. Make sure to free it when done,
   or the demons of garbage collection will feast on your bones. */
PSZ copy_clip_to_string(VOID)
{
	static PSZ	pszFromClip, pszRetn;
	HANDLE		h;

	if (OpenClipboard(hwndFrame)) {
		if ((h = GetClipboardData(CF_TEXT)) != NULL) {
			if ((pszFromClip = (PSZ)GlobalLock(h)) != NULL) {
				pszRetn = (char *)malloc(sizeof(char)*(strlen(pszFromClip)+1));
				strcpy(pszRetn, pszFromClip);
				GlobalUnlock(h);
			}
		}
		CloseClipboard();
	}
	return pszRetn;
}
