//
//  XTLogAppenderNSLog.m
//  TadsTerp
//
//  Created by Rune Berg on 15/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTLogAppenderULS.h"
#import <os/log.h>

@implementation XTLogAppenderULS

static os_log_t ourLog;

#define XT_OBJ_LOG_FMT "%{public}@"
#define XT_LOG_FMT "[" XT_OBJ_LOG_FMT "] [" XT_OBJ_LOG_FMT "] " XT_OBJ_LOG_FMT " "

+ (void)initialize
{
	ourLog = os_log_create("XTads", "");
}

- (void)appendToLog:(NSString *)logName msg:(NSString *)msg level:(XTLoggerLevel)level
{
	switch (level) {
		case XT_LEVEL_NONE:
			break;
		case XT_LEVEL_TRACE:
		case XT_LEVEL_DEBUG:
			os_log_debug(ourLog, XT_LOG_FMT, [self nameForLevel:level], logName, msg);
			break;
		case XT_LEVEL_INFO:
			os_log_info(ourLog, XT_LOG_FMT, [self nameForLevel:level], logName, msg);
			break;
		case XT_LEVEL_WARN:
		case XT_LEVEL_ERROR:
		case XT_LEVEL_FATAL:
			os_log_error(ourLog, XT_LOG_FMT, [self nameForLevel:level], logName, msg);
			break;
		default:
			os_log(ourLog, XT_LOG_FMT, [self nameForLevel:level], logName, msg);
			break;
	}
}

@end
