//
//  XTStringUtils.h
//  TadsTerp
//
//  Created by Rune Berg on 24/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTCharConstants.h"
#import "XTRange.h"
#import "XTTextTableBlock.h"


@interface XTStringUtils : NSObject

+ (BOOL)string:(NSString *)string endsWithChar:(unichar)ch;

+ (BOOL)string:(NSString *)string endsWith:(NSString *)end;

+ (BOOL)string:(NSString *)string endsWithCaseInsensitive:(NSString *)end;

+ (NSUInteger)lengthOfTrailingEffectiveNewlineNotInTableCell:(NSAttributedString *)attrString;

+ (BOOL)string:(NSString *)string startsWith:(NSString *)start;

+ (BOOL)string:(NSString *)string1 isEqualToCaseInsensitive:(NSString *)string2;

+ (NSString *)filterRepeatedNewlines:(NSString *)string;

+ (NSRange)findRangeOfTrailingWhitespaceInLastParagraph:(NSString *)string;

+ (NSRange)findRangeOfLastParagraph:(NSString *)string;

+ (NSRange)findRangeOfOngoingParagraph:(NSString *)string;

+ (NSString *)trimLeadingAndTrailingWhitespace:(NSString *)string;

+ (NSString *)removeLeadingZwsp:(NSString *)string;

+ (NSString *)emptyIfNull:(NSString *)string;

+ (BOOL)isEmptyOrNull:(NSString *)string;

+ (BOOL)isInternetLink:(NSString *)string;

+ (NSString *)stringOf:(NSUInteger)n string:(NSString *)s;

+ (NSCharacterSet *)breakingWhitespaceCharSet;

+ (NSUInteger)indexInString:(NSString *)string ofCharAtRow:(NSUInteger)row column:(NSUInteger)column;

+ (NSRange)rangeOfLongestLineIn:(NSString *)string;

+ (unichar)removeLastCharFrom:(NSMutableString *)string;

+ (NSString *)numericPrefix:(NSString *)string;

+ (unichar)lastChar:(NSString *)string;

+ (NSArray *)splitString:(NSString *)s
			 bySeparator:(NSString *)sep
 includeSeparatorEntries:(BOOL)includeSepEntries;

+ (NSRange)rangeOfNextParagraphIn:(NSString *)string fromLoc:(NSUInteger)loc;

+ (NSRange)rangeOfParagraphIn:(NSString *)string atLoc:(NSUInteger)loc;

+ (NSArray *)splitAttributedString:(NSAttributedString *)attrString
					   bySeparator:(NSString *)separator;

+ (NSArray<NSAttributedString *>*)splitIntoParagraphs:(NSAttributedString *)attrString;

+ (NSString *)safeNameForEncoding:(NSStringEncoding)encoding;

+ (BOOL)isTads2GameUrl:(NSURL *)url;

+ (BOOL)isTads3GameUrl:(NSURL *)url;

+ (BOOL)url:(NSURL *)url endsWith:(NSString *)dotFileExtension;

+ (BOOL)isEffectiveNewline:(unichar)ch;

+ (void)trimTrailingNewlines:(NSMutableAttributedString *)mutAttrString;

+ (void)removeTrailingString:(NSString *)string from:(NSMutableAttributedString *)mutAttrString;

+ (NSArray<XTRange *>*)findRangesOfLinesExcludingNewlines:(NSString *)string;

+ (NSUInteger)numberOfTrailingNewlinesIn:(NSString *)string;

+ (NSAttributedString *)withoutTrailingNewline:(NSAttributedString *)attrString;

+ (NSAttributedString *)withOnlyLastChar:(NSAttributedString *)attrString;

+ (NSString *)withoutLastChar:(NSString *)string;

+ (BOOL)stringContainsNewlines:(NSString *)string;

+ (NSMutableParagraphStyle *)mutableParagraphStyleFor:(NSAttributedString *)attrString;

+ (NSMutableParagraphStyle *)mutableParagraphStyleFor:(NSAttributedString *)attrString atIndex:(NSUInteger)index;

+ (NSAttributedString *)filterZwsp:(NSAttributedString *)attrString;

+ (void)applyParagraphStyle:(NSParagraphStyle *)paragraphStyle toAttrString:(NSMutableAttributedString *)mutAttrString;

+ (NSMutableAttributedString *)concatenateAttributedStringArray:(NSArray<NSAttributedString *> *)attrStringArray;

+ (void)removeXTadsParagraphStyles:(NSMutableAttributedString *)mutAttrString;

+ (XTTextTableBlock *)tableCellForAttrString:(NSAttributedString *)attrString range:(NSRange)range;

+ (XTTextTableBlock *)tableCellForAttrString:(NSAttributedString *)attrString atIndex:(NSUInteger)idx;

+ (void)removeAttributeForNewlines:(NSMutableAttributedString *)mutAttrString attrName:(NSString *)attrName;

+ (NSString *)stringForSpecialSpaceWhenMonoFont:(unichar)specialSpace;

+ (void)applyParagraphStyle:(NSMutableParagraphStyle *)pgStyle toLastParagraphOf:(NSMutableAttributedString *)mutAttrString;

+ (NSMutableParagraphStyle *)getParagraphStyleAtStartOfOngoingParagraphOf:(NSAttributedString *)attrString;

+ (NSMutableParagraphStyle *)getParagraphStyleAtStartOfLastParagraphOf:(NSAttributedString *)attrString;

+ (void)removeTrailingWhitespaceInLastParagraph:(NSMutableAttributedString *)mutAttrString;

+ (BOOL)stringContainsOnlyWhitespace:(NSString *)string;

+ (NSString *)withoutNewlines:(NSString *)string;

+ (NSString *)removeLeadingSpace:(NSString *)string;

@end
