<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "<xsl:text><![CDATA[ ]]></xsl:text>">
	<!ENTITY copylogo "&#169;">
]>
<!--
	This template is used as an example of how to extend the base class for making custom class templates for databases.
	
	Author : Konstantine Kougios
	Version: 0.9Beta

-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="yes" encoding="UTF-8" omit-xml-declaration="yes"/>

<xsl:template match="ROOT">
/**
 * TABLE: <xsl:value-of select="CLASSINFO/@name"/>
 * This class was generated with the OODBFramework and the SimpleDBExt
 * template. Please don't modify, inherit instead.
 **/
package <xsl:value-of select="CLASSINFO/@package"/>;

import java.sql.Statement;
import java.sql.SQLException;

<xsl:value-of select="template/imports"/>

// ============================================================================
// =       CLASS DEFINITION                                                   =
// = This class is the base for many others that will access the database     =
// ============================================================================
<xsl:value-of select="template/modifiers"/> class <xsl:value-of select="CLASSNAME"/>
<xsl:if test="template/extends!=''">
	extends <xsl:value-of select="template/extends"/>
</xsl:if>
{
	public <xsl:value-of select="CLASSNAME"/>(java.sql.ResultSet rs) throws java.sql.SQLException
	{
		super(rs);
	}
	public <xsl:value-of select="CLASSNAME"/>(Statement st,<xsl:value-of select="PRIMARYKEYS/@commaSepJavaType"/>) throws SQLException
	{
		super(st,<xsl:value-of select="PRIMARYKEYS/@commaSep"/>);
	}
}

</xsl:template>


</xsl:stylesheet>