unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Db, DBTables, frxDesgn, frxClass, frxDCtrl, frxBDEComponents,
  frxChart, frxRich, frxBarcode, ImgList, ComCtrls, ExtCtrls, frxOLE,
  frxCross, frxDMPExport, frxExportImage, frxExportRTF, frxExportTXT,
  frxExportXML, frxExportXLS, frxExportHTML, frxGZip;

type
  TForm1 = class(TForm)
    DesignB: TButton;
    frDesigner1: TfrxDesigner;
    frBarCodeObject1: TfrxBarCodeObject;
    frRichObject1: TfrxRichObject;
    frChartObject1: TfrxChartObject;
    frDialogControls1: TfrxDialogControls;
    Tree: TTreeView;
    ImageList1: TImageList;
    PreviewB: TButton;
    DescriptionM: TMemo;
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    frOLEObject1: TfrxOLEObject;
    frCrossObject1: TfrxCrossObject;
    frBDEComponents1: TfrxBDEComponents;
    frxDotMatrixExport1: TfrxDotMatrixExport;
    frxBMPExport1: TfrxBMPExport;
    frxJPEGExport1: TfrxJPEGExport;
    frxTIFFExport1: TfrxTIFFExport;
    frxTXTExport1: TfrxTXTExport;
    frxHTMLExport1: TfrxHTMLExport;
    frxXLSExport1: TfrxXLSExport;
    frxXMLExport1: TfrxXMLExport;
    frxRTFExport1: TfrxRTFExport;
    frReport1: TfrxReport;
    frxGZipCompressor1: TfrxGZipCompressor;
    procedure DesignBClick(Sender: TObject);
    procedure TreeCustomDrawItem(Sender: TCustomTreeView; Node: TTreeNode;
      State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure PreviewBClick(Sender: TObject);
    procedure TreeChange(Sender: TObject; Node: TTreeNode);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    WPath: String;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
begin
  WPath := ExtractFilePath(Application.ExeName);
  Tree.FullExpand;
  Tree.TopItem := Tree.Items[0];
  Tree.Items[0].Item[0].Selected := True;
end;

procedure TForm1.DesignBClick(Sender: TObject);
begin
  frReport1.DesignReport;
end;

procedure TForm1.PreviewBClick(Sender: TObject);
begin
  frReport1.ShowReport;
end;

procedure TForm1.TreeCustomDrawItem(Sender: TCustomTreeView;
  Node: TTreeNode; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  if Node.Count <> 0 then
    Tree.Canvas.Font.Style := [fsBold];
end;

procedure TForm1.TreeChange(Sender: TObject; Node: TTreeNode);
begin
  if Node.StateIndex = -1 then
  begin
    DescriptionM.Lines.Clear;
    DesignB.Enabled := False;
    PreviewB.Enabled := False;
  end
  else
  begin
    DesignB.Enabled := True;
    PreviewB.Enabled := True;
    frReport1.LoadFromFile(WPath + IntToStr(Node.StateIndex) + '.fr3');
    DescriptionM.Lines := frReport1.ReportOptions.Description;
  end;
end;

end.
